/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SXMWEATHERFITYPES_HEADER
#define SXMWEATHERFITYPES_HEADER

// #include <vector>
// 


class sxmweatherfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart():UpdateType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart& operator=(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart& coRef);
   sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_UpdateType UpdateType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TRANSFERUPDATEFILEINFOMETHODSTART;}
};

class sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult():UpdateType(),UpdateFileName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult& operator=(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult& coRef);
   sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_UpdateType UpdateType;
   fi_tclString UpdateFileName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TRANSFERUPDATEFILEINFOMETHODRESULT;}
};

class sxmweatherfi_tclMsgReleaseUpdateFileMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgReleaseUpdateFileMethodStart():UpdateType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgReleaseUpdateFileMethodStart& operator=(const sxmweatherfi_tclMsgReleaseUpdateFileMethodStart& coRef);
   sxmweatherfi_tclMsgReleaseUpdateFileMethodStart(const sxmweatherfi_tclMsgReleaseUpdateFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_UpdateType UpdateType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgReleaseUpdateFileMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_RELEASEUPDATEFILEMETHODSTART;}
};

class sxmweatherfi_tclMsgReleaseUpdateFileMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgReleaseUpdateFileMethodResult():UpdateType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgReleaseUpdateFileMethodResult& operator=(const sxmweatherfi_tclMsgReleaseUpdateFileMethodResult& coRef);
   sxmweatherfi_tclMsgReleaseUpdateFileMethodResult(const sxmweatherfi_tclMsgReleaseUpdateFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_UpdateType UpdateType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgReleaseUpdateFileMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_RELEASEUPDATEFILEMETHODRESULT;}
};

class sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart():WeatherCapabilities() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart& operator=(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart& coRef);
   sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Capabilities WeatherCapabilities;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_XCHNGECAPABILITIESMETHODSTART;}
};

class sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult():SupportedCapabilities(),GraphicalWeatherInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult& operator=(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult& coRef);
   sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_Capabilities SupportedCapabilities;
   fi_tcl_GraphicalInfo GraphicalWeatherInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_XCHNGECAPABILITIESMETHODRESULT;}
};

class sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart& operator=(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart& coRef);
   sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_ACQUIREGRAPHICALAUMETHODSTART;}
};

class sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult& operator=(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult& coRef);
   sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_AU_Index, std::allocator<fi_tcl_AU_Index> > IndexList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_ACQUIREGRAPHICALAUMETHODRESULT;}
};

class sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart& operator=(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart& coRef);
   sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_RELEASEGRAPHICALAUMETHODSTART;}
};

class sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult& operator=(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult& coRef);
   sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_RELEASEGRAPHICALAUMETHODRESULT;}
};

class sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg& operator=(const sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg& coRef);
   sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg(const sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOUPREG;}
};

class sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg& operator=(const sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg& coRef);
   sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg(const sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFORELUPREG;}
};

class sxmweatherfi_tclMsgTabWeatherAuthInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTabWeatherAuthInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTabWeatherAuthInfoGet& operator=(const sxmweatherfi_tclMsgTabWeatherAuthInfoGet& coRef);
   sxmweatherfi_tclMsgTabWeatherAuthInfoGet(const sxmweatherfi_tclMsgTabWeatherAuthInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTabWeatherAuthInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOGET;}
};

class sxmweatherfi_tclMsgTabWeatherAuthInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTabWeatherAuthInfoStatus():TabWeatherAuthStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTabWeatherAuthInfoStatus& operator=(const sxmweatherfi_tclMsgTabWeatherAuthInfoStatus& coRef);
   sxmweatherfi_tclMsgTabWeatherAuthInfoStatus(const sxmweatherfi_tclMsgTabWeatherAuthInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_AuthorizationStatus TabWeatherAuthStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTabWeatherAuthInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOSTATUS;}
};

class sxmweatherfi_tclMsgSXMSignalInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgSXMSignalInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgSXMSignalInfoUpReg& operator=(const sxmweatherfi_tclMsgSXMSignalInfoUpReg& coRef);
   sxmweatherfi_tclMsgSXMSignalInfoUpReg(const sxmweatherfi_tclMsgSXMSignalInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgSXMSignalInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOUPREG;}
};

class sxmweatherfi_tclMsgSXMSignalInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgSXMSignalInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgSXMSignalInfoRelUpReg& operator=(const sxmweatherfi_tclMsgSXMSignalInfoRelUpReg& coRef);
   sxmweatherfi_tclMsgSXMSignalInfoRelUpReg(const sxmweatherfi_tclMsgSXMSignalInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgSXMSignalInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFORELUPREG;}
};

class sxmweatherfi_tclMsgSXMSignalInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgSXMSignalInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgSXMSignalInfoGet& operator=(const sxmweatherfi_tclMsgSXMSignalInfoGet& coRef);
   sxmweatherfi_tclMsgSXMSignalInfoGet(const sxmweatherfi_tclMsgSXMSignalInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgSXMSignalInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOGET;}
};

class sxmweatherfi_tclMsgSXMSignalInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgSXMSignalInfoStatus():SXMSignalStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgSXMSignalInfoStatus& operator=(const sxmweatherfi_tclMsgSXMSignalInfoStatus& coRef);
   sxmweatherfi_tclMsgSXMSignalInfoStatus(const sxmweatherfi_tclMsgSXMSignalInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SignalStatus SXMSignalStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgSXMSignalInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOSTATUS;}
};

class sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg& operator=(const sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg& coRef);
   sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg(const sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLEUPREG;}
};

class sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg& operator=(const sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg& coRef);
   sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg(const sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLERELUPREG;}
};

class sxmweatherfi_tclMsgNewUpdateFileAvailableStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgNewUpdateFileAvailableStatus():UpdateType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgNewUpdateFileAvailableStatus& operator=(const sxmweatherfi_tclMsgNewUpdateFileAvailableStatus& coRef);
   sxmweatherfi_tclMsgNewUpdateFileAvailableStatus(const sxmweatherfi_tclMsgNewUpdateFileAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_UpdateType UpdateType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgNewUpdateFileAvailableStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLESTATUS;}
};

class sxmweatherfi_tclMsgTabWeatherDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTabWeatherDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTabWeatherDataUpReg& operator=(const sxmweatherfi_tclMsgTabWeatherDataUpReg& coRef);
   sxmweatherfi_tclMsgTabWeatherDataUpReg(const sxmweatherfi_tclMsgTabWeatherDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTabWeatherDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATAUPREG;}
};

class sxmweatherfi_tclMsgTabWeatherDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTabWeatherDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTabWeatherDataRelUpReg& operator=(const sxmweatherfi_tclMsgTabWeatherDataRelUpReg& coRef);
   sxmweatherfi_tclMsgTabWeatherDataRelUpReg(const sxmweatherfi_tclMsgTabWeatherDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTabWeatherDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATARELUPREG;}
};

class sxmweatherfi_tclMsgTabWeatherDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgTabWeatherDataStatus():AccessUnitSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgTabWeatherDataStatus& operator=(const sxmweatherfi_tclMsgTabWeatherDataStatus& coRef);
   sxmweatherfi_tclMsgTabWeatherDataStatus(const sxmweatherfi_tclMsgTabWeatherDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 AccessUnitSize;
   std::vector<tU8, std::allocator<tU8> > AccessUnitData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgTabWeatherDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATASTATUS;}
};

class sxmweatherfi_tclMsgGraphicalWeatherAUUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherAUUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherAUUpReg& operator=(const sxmweatherfi_tclMsgGraphicalWeatherAUUpReg& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherAUUpReg(const sxmweatherfi_tclMsgGraphicalWeatherAUUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherAUUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUUPREG;}
};

class sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg& operator=(const sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg(const sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAURELUPREG;}
};

class sxmweatherfi_tclMsgGraphicalWeatherAUStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherAUStatus():Counter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherAUStatus& operator=(const sxmweatherfi_tclMsgGraphicalWeatherAUStatus& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherAUStatus(const sxmweatherfi_tclMsgGraphicalWeatherAUStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU8, std::allocator<tU8> > GraphicalAUData;
   tU32 Counter;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherAUStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUSTATUS;}
};

class sxmweatherfi_tclMsgGraphicalWeatherDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherDataUpReg& operator=(const sxmweatherfi_tclMsgGraphicalWeatherDataUpReg& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherDataUpReg(const sxmweatherfi_tclMsgGraphicalWeatherDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATAUPREG;}
};

class sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg& operator=(const sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg(const sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATARELUPREG;}
};

class sxmweatherfi_tclMsgGraphicalWeatherDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherDataStatus():Counter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherDataStatus& operator=(const sxmweatherfi_tclMsgGraphicalWeatherDataStatus& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherDataStatus(const sxmweatherfi_tclMsgGraphicalWeatherDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Counter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATASTATUS;}
};

class sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg& operator=(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOUPREG;}
};

class sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg& operator=(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFORELUPREG;}
};

class sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet& operator=(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOGET;}
};

class sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus():GraphicalWeatherAuthStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus& operator=(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus& coRef);
   sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_AuthorizationStatus GraphicalWeatherAuthStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOSTATUS;}
};

class sxmweatherfi_tclMsgWeatherAlertsAUUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgWeatherAlertsAUUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgWeatherAlertsAUUpReg& operator=(const sxmweatherfi_tclMsgWeatherAlertsAUUpReg& coRef);
   sxmweatherfi_tclMsgWeatherAlertsAUUpReg(const sxmweatherfi_tclMsgWeatherAlertsAUUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgWeatherAlertsAUUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUUPREG;}
};

class sxmweatherfi_tclMsgWeatherAlertsAURelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgWeatherAlertsAURelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgWeatherAlertsAURelUpReg& operator=(const sxmweatherfi_tclMsgWeatherAlertsAURelUpReg& coRef);
   sxmweatherfi_tclMsgWeatherAlertsAURelUpReg(const sxmweatherfi_tclMsgWeatherAlertsAURelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgWeatherAlertsAURelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAURELUPREG;}
};

class sxmweatherfi_tclMsgWeatherAlertsAUStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgWeatherAlertsAUStatus():AlertPrio() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgWeatherAlertsAUStatus& operator=(const sxmweatherfi_tclMsgWeatherAlertsAUStatus& coRef);
   sxmweatherfi_tclMsgWeatherAlertsAUStatus(const sxmweatherfi_tclMsgWeatherAlertsAUStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU8, std::allocator<tU8> > WeatherAlertsAUData;
   fi_tcl_e8_AlertPrio AlertPrio;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgWeatherAlertsAUStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUSTATUS;}
};

class sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg& operator=(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg& coRef);
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOUPREG;}
};

class sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg& operator=(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg& coRef);
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFORELUPREG;}
};

class sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet& operator=(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet& coRef);
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOGET;}
};

class sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus():WeatherAlertsAuthStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus& operator=(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus& coRef);
   sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_AuthorizationStatus WeatherAlertsAuthStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOSTATUS;}
};


#endif
