/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SXMMOVIEFITYPES_HEADER
#define SXMMOVIEFITYPES_HEADER

// #include <vector>
// 


class sxmmoviefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart():ClientHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart& operator=(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart& coRef);
   sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ClientHighestAvailableUpdateId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIETIMESDATAMETHODSTART;}
};

class sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult():ServerHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult& operator=(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult& coRef);
   sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ServerHighestAvailableUpdateId;
   std::vector<fi_tcl_BinContainer, std::allocator<fi_tcl_BinContainer> > ListOfMovieTimesData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIETIMESDATAMETHODRESULT;}
};

class sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart():ClientHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart& operator=(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart& coRef);
   sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ClientHighestAvailableUpdateId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIEDESCRIPTIONDATAMETHODSTART;}
};

class sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult():ServerHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult& operator=(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult& coRef);
   sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ServerHighestAvailableUpdateId;
   std::vector<fi_tcl_BinContainer, std::allocator<fi_tcl_BinContainer> > ListOfMovieDescriptionData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIEDESCRIPTIONDATAMETHODRESULT;}
};

class sxmmoviefi_tclMsgMovieDataAuthInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieDataAuthInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieDataAuthInfoUpReg& operator=(const sxmmoviefi_tclMsgMovieDataAuthInfoUpReg& coRef);
   sxmmoviefi_tclMsgMovieDataAuthInfoUpReg(const sxmmoviefi_tclMsgMovieDataAuthInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieDataAuthInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOUPREG;}
};

class sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg& operator=(const sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg& coRef);
   sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg(const sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFORELUPREG;}
};

class sxmmoviefi_tclMsgMovieDataAuthInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieDataAuthInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieDataAuthInfoGet& operator=(const sxmmoviefi_tclMsgMovieDataAuthInfoGet& coRef);
   sxmmoviefi_tclMsgMovieDataAuthInfoGet(const sxmmoviefi_tclMsgMovieDataAuthInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieDataAuthInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOGET;}
};

class sxmmoviefi_tclMsgMovieDataAuthInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieDataAuthInfoStatus():MovieDataAuthStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieDataAuthInfoStatus& operator=(const sxmmoviefi_tclMsgMovieDataAuthInfoStatus& coRef);
   sxmmoviefi_tclMsgMovieDataAuthInfoStatus(const sxmmoviefi_tclMsgMovieDataAuthInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_AuthorisationStatus MovieDataAuthStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieDataAuthInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOSTATUS;}
};

class sxmmoviefi_tclMsgSignalInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgSignalInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgSignalInfoUpReg& operator=(const sxmmoviefi_tclMsgSignalInfoUpReg& coRef);
   sxmmoviefi_tclMsgSignalInfoUpReg(const sxmmoviefi_tclMsgSignalInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgSignalInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_SIGNALINFOUPREG;}
};

class sxmmoviefi_tclMsgSignalInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgSignalInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgSignalInfoRelUpReg& operator=(const sxmmoviefi_tclMsgSignalInfoRelUpReg& coRef);
   sxmmoviefi_tclMsgSignalInfoRelUpReg(const sxmmoviefi_tclMsgSignalInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgSignalInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_SIGNALINFORELUPREG;}
};

class sxmmoviefi_tclMsgSignalInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgSignalInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgSignalInfoGet& operator=(const sxmmoviefi_tclMsgSignalInfoGet& coRef);
   sxmmoviefi_tclMsgSignalInfoGet(const sxmmoviefi_tclMsgSignalInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgSignalInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_SIGNALINFOGET;}
};

class sxmmoviefi_tclMsgSignalInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgSignalInfoStatus():SignalStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgSignalInfoStatus& operator=(const sxmmoviefi_tclMsgSignalInfoStatus& coRef);
   sxmmoviefi_tclMsgSignalInfoStatus(const sxmmoviefi_tclMsgSignalInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SigStatus SignalStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgSignalInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_SIGNALINFOSTATUS;}
};

class sxmmoviefi_tclMsgMovieDescriptionDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieDescriptionDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieDescriptionDataUpReg& operator=(const sxmmoviefi_tclMsgMovieDescriptionDataUpReg& coRef);
   sxmmoviefi_tclMsgMovieDescriptionDataUpReg(const sxmmoviefi_tclMsgMovieDescriptionDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieDescriptionDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATAUPREG;}
};

class sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg& operator=(const sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg& coRef);
   sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg(const sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATARELUPREG;}
};

class sxmmoviefi_tclMsgMovieDescriptionDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieDescriptionDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieDescriptionDataGet& operator=(const sxmmoviefi_tclMsgMovieDescriptionDataGet& coRef);
   sxmmoviefi_tclMsgMovieDescriptionDataGet(const sxmmoviefi_tclMsgMovieDescriptionDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieDescriptionDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATAGET;}
};

class sxmmoviefi_tclMsgMovieDescriptionDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieDescriptionDataStatus():ServerHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieDescriptionDataStatus& operator=(const sxmmoviefi_tclMsgMovieDescriptionDataStatus& coRef);
   sxmmoviefi_tclMsgMovieDescriptionDataStatus(const sxmmoviefi_tclMsgMovieDescriptionDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ServerHighestAvailableUpdateId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieDescriptionDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATASTATUS;}
};

class sxmmoviefi_tclMsgMovieTimesDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieTimesDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieTimesDataUpReg& operator=(const sxmmoviefi_tclMsgMovieTimesDataUpReg& coRef);
   sxmmoviefi_tclMsgMovieTimesDataUpReg(const sxmmoviefi_tclMsgMovieTimesDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieTimesDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATAUPREG;}
};

class sxmmoviefi_tclMsgMovieTimesDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieTimesDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieTimesDataRelUpReg& operator=(const sxmmoviefi_tclMsgMovieTimesDataRelUpReg& coRef);
   sxmmoviefi_tclMsgMovieTimesDataRelUpReg(const sxmmoviefi_tclMsgMovieTimesDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieTimesDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATARELUPREG;}
};

class sxmmoviefi_tclMsgMovieTimesDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieTimesDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieTimesDataGet& operator=(const sxmmoviefi_tclMsgMovieTimesDataGet& coRef);
   sxmmoviefi_tclMsgMovieTimesDataGet(const sxmmoviefi_tclMsgMovieTimesDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieTimesDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATAGET;}
};

class sxmmoviefi_tclMsgMovieTimesDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmmoviefi_tclMsgMovieTimesDataStatus():ServerHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmmoviefi_tclMsgMovieTimesDataStatus& operator=(const sxmmoviefi_tclMsgMovieTimesDataStatus& coRef);
   sxmmoviefi_tclMsgMovieTimesDataStatus(const sxmmoviefi_tclMsgMovieTimesDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ServerHighestAvailableUpdateId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmmoviefi_tclMsgMovieTimesDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATASTATUS;}
};


#endif
