/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClientHighestAvailableUpdateId = coRef.ClientHighestAvailableUpdateId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart& sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::operator=(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ClientHighestAvailableUpdateId = coRef.ClientHighestAvailableUpdateId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_TRANSFERMOVIETIMESDATA;}
tU8 sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::operator==(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClientHighestAvailableUpdateId == rfoCmp.ClientHighestAvailableUpdateId);
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ClientHighestAvailableUpdateId;
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgTransferMovieTimesDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ClientHighestAvailableUpdateId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   ListOfMovieTimesData = coRef.ListOfMovieTimesData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult& sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::operator=(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   ListOfMovieTimesData = coRef.ListOfMovieTimesData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_TRANSFERMOVIETIMESDATA;}
tU8 sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfMovieTimesData.size(); ++u32Idx)
         ListOfMovieTimesData[u32Idx].vDestroy();
   }
   ListOfMovieTimesData.clear();
}

tU32 sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfMovieTimesData.size(); ++u32ListIdx)
      u32DynamicSize += ListOfMovieTimesData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::operator==(const sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServerHighestAvailableUpdateId == rfoCmp.ServerHighestAvailableUpdateId);
      bResult = bResult && (ListOfMovieTimesData.size() == rfoCmp.ListOfMovieTimesData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfMovieTimesData.size()); ++u32Idx)
            bResult = bResult && (ListOfMovieTimesData[u32Idx] == rfoCmp.ListOfMovieTimesData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ServerHighestAvailableUpdateId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfMovieTimesData.size(); ++u32Idx)
      {
         ListOfMovieTimesData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfMovieTimesData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfMovieTimesData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgTransferMovieTimesDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServerHighestAvailableUpdateId;
   oOut << (tU32)ListOfMovieTimesData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfMovieTimesData.size(); ++u32Idx)
         oOut << ListOfMovieTimesData[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClientHighestAvailableUpdateId = coRef.ClientHighestAvailableUpdateId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart& sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::operator=(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ClientHighestAvailableUpdateId = coRef.ClientHighestAvailableUpdateId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_TRANSFERMOVIEDESCRIPTIONDATA;}
tU8 sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::operator==(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClientHighestAvailableUpdateId == rfoCmp.ClientHighestAvailableUpdateId);
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ClientHighestAvailableUpdateId;
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ClientHighestAvailableUpdateId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   ListOfMovieDescriptionData = coRef.ListOfMovieDescriptionData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult& sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::operator=(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   ListOfMovieDescriptionData = coRef.ListOfMovieDescriptionData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_TRANSFERMOVIEDESCRIPTIONDATA;}
tU8 sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfMovieDescriptionData.size(); ++u32Idx)
         ListOfMovieDescriptionData[u32Idx].vDestroy();
   }
   ListOfMovieDescriptionData.clear();
}

tU32 sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfMovieDescriptionData.size(); ++u32ListIdx)
      u32DynamicSize += ListOfMovieDescriptionData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::operator==(const sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServerHighestAvailableUpdateId == rfoCmp.ServerHighestAvailableUpdateId);
      bResult = bResult && (ListOfMovieDescriptionData.size() == rfoCmp.ListOfMovieDescriptionData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfMovieDescriptionData.size()); ++u32Idx)
            bResult = bResult && (ListOfMovieDescriptionData[u32Idx] == rfoCmp.ListOfMovieDescriptionData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ServerHighestAvailableUpdateId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfMovieDescriptionData.size(); ++u32Idx)
      {
         ListOfMovieDescriptionData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfMovieDescriptionData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfMovieDescriptionData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgTransferMovieDescriptionDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServerHighestAvailableUpdateId;
   oOut << (tU32)ListOfMovieDescriptionData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfMovieDescriptionData.size(); ++u32Idx)
         oOut << ListOfMovieDescriptionData[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::sxmmoviefi_tclMsgMovieDataAuthInfoUpReg(const sxmmoviefi_tclMsgMovieDataAuthInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDataAuthInfoUpReg& sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::operator=(const sxmmoviefi_tclMsgMovieDataAuthInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIEDATAAUTHINFO;}
tU8 sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::operator==(const sxmmoviefi_tclMsgMovieDataAuthInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieDataAuthInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg(const sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg& sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::operator=(const sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIEDATAAUTHINFO;}
tU8 sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::operator==(const sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieDataAuthInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDataAuthInfoGet::sxmmoviefi_tclMsgMovieDataAuthInfoGet(const sxmmoviefi_tclMsgMovieDataAuthInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDataAuthInfoGet& sxmmoviefi_tclMsgMovieDataAuthInfoGet::operator=(const sxmmoviefi_tclMsgMovieDataAuthInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieDataAuthInfoGet::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieDataAuthInfoGet::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIEDATAAUTHINFO;}
tU8 sxmmoviefi_tclMsgMovieDataAuthInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmmoviefi_tclMsgMovieDataAuthInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieDataAuthInfoGet::operator==(const sxmmoviefi_tclMsgMovieDataAuthInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieDataAuthInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieDataAuthInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDataAuthInfoStatus::sxmmoviefi_tclMsgMovieDataAuthInfoStatus(const sxmmoviefi_tclMsgMovieDataAuthInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MovieDataAuthStatus = coRef.MovieDataAuthStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDataAuthInfoStatus& sxmmoviefi_tclMsgMovieDataAuthInfoStatus::operator=(const sxmmoviefi_tclMsgMovieDataAuthInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   MovieDataAuthStatus = coRef.MovieDataAuthStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieDataAuthInfoStatus::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieDataAuthInfoStatus::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIEDATAAUTHINFO;}
tU8 sxmmoviefi_tclMsgMovieDataAuthInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmmoviefi_tclMsgMovieDataAuthInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmmoviefi_tclMsgMovieDataAuthInfoStatus::operator==(const sxmmoviefi_tclMsgMovieDataAuthInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MovieDataAuthStatus == rfoCmp.MovieDataAuthStatus);
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieDataAuthInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MovieDataAuthStatus;
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieDataAuthInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MovieDataAuthStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgSignalInfoUpReg::sxmmoviefi_tclMsgSignalInfoUpReg(const sxmmoviefi_tclMsgSignalInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgSignalInfoUpReg& sxmmoviefi_tclMsgSignalInfoUpReg::operator=(const sxmmoviefi_tclMsgSignalInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgSignalInfoUpReg::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgSignalInfoUpReg::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_SIGNALINFO;}
tU8 sxmmoviefi_tclMsgSignalInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmmoviefi_tclMsgSignalInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgSignalInfoUpReg::operator==(const sxmmoviefi_tclMsgSignalInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgSignalInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgSignalInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgSignalInfoRelUpReg::sxmmoviefi_tclMsgSignalInfoRelUpReg(const sxmmoviefi_tclMsgSignalInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgSignalInfoRelUpReg& sxmmoviefi_tclMsgSignalInfoRelUpReg::operator=(const sxmmoviefi_tclMsgSignalInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgSignalInfoRelUpReg::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgSignalInfoRelUpReg::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_SIGNALINFO;}
tU8 sxmmoviefi_tclMsgSignalInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmmoviefi_tclMsgSignalInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgSignalInfoRelUpReg::operator==(const sxmmoviefi_tclMsgSignalInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgSignalInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgSignalInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgSignalInfoGet::sxmmoviefi_tclMsgSignalInfoGet(const sxmmoviefi_tclMsgSignalInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgSignalInfoGet& sxmmoviefi_tclMsgSignalInfoGet::operator=(const sxmmoviefi_tclMsgSignalInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgSignalInfoGet::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgSignalInfoGet::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_SIGNALINFO;}
tU8 sxmmoviefi_tclMsgSignalInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmmoviefi_tclMsgSignalInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgSignalInfoGet::operator==(const sxmmoviefi_tclMsgSignalInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgSignalInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgSignalInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgSignalInfoStatus::sxmmoviefi_tclMsgSignalInfoStatus(const sxmmoviefi_tclMsgSignalInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   SignalStatus = coRef.SignalStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgSignalInfoStatus& sxmmoviefi_tclMsgSignalInfoStatus::operator=(const sxmmoviefi_tclMsgSignalInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   SignalStatus = coRef.SignalStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgSignalInfoStatus::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgSignalInfoStatus::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_SIGNALINFO;}
tU8 sxmmoviefi_tclMsgSignalInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmmoviefi_tclMsgSignalInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmmoviefi_tclMsgSignalInfoStatus::operator==(const sxmmoviefi_tclMsgSignalInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SignalStatus == rfoCmp.SignalStatus);
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgSignalInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> SignalStatus;
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgSignalInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SignalStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDescriptionDataUpReg::sxmmoviefi_tclMsgMovieDescriptionDataUpReg(const sxmmoviefi_tclMsgMovieDescriptionDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDescriptionDataUpReg& sxmmoviefi_tclMsgMovieDescriptionDataUpReg::operator=(const sxmmoviefi_tclMsgMovieDescriptionDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieDescriptionDataUpReg::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieDescriptionDataUpReg::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIEDESCRIPTIONDATA;}
tU8 sxmmoviefi_tclMsgMovieDescriptionDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmmoviefi_tclMsgMovieDescriptionDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieDescriptionDataUpReg::operator==(const sxmmoviefi_tclMsgMovieDescriptionDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieDescriptionDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieDescriptionDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg(const sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg& sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::operator=(const sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIEDESCRIPTIONDATA;}
tU8 sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::operator==(const sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieDescriptionDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDescriptionDataGet::sxmmoviefi_tclMsgMovieDescriptionDataGet(const sxmmoviefi_tclMsgMovieDescriptionDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDescriptionDataGet& sxmmoviefi_tclMsgMovieDescriptionDataGet::operator=(const sxmmoviefi_tclMsgMovieDescriptionDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieDescriptionDataGet::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieDescriptionDataGet::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIEDESCRIPTIONDATA;}
tU8 sxmmoviefi_tclMsgMovieDescriptionDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmmoviefi_tclMsgMovieDescriptionDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieDescriptionDataGet::operator==(const sxmmoviefi_tclMsgMovieDescriptionDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieDescriptionDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieDescriptionDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDescriptionDataStatus::sxmmoviefi_tclMsgMovieDescriptionDataStatus(const sxmmoviefi_tclMsgMovieDescriptionDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieDescriptionDataStatus& sxmmoviefi_tclMsgMovieDescriptionDataStatus::operator=(const sxmmoviefi_tclMsgMovieDescriptionDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieDescriptionDataStatus::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieDescriptionDataStatus::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIEDESCRIPTIONDATA;}
tU8 sxmmoviefi_tclMsgMovieDescriptionDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmmoviefi_tclMsgMovieDescriptionDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxmmoviefi_tclMsgMovieDescriptionDataStatus::operator==(const sxmmoviefi_tclMsgMovieDescriptionDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServerHighestAvailableUpdateId == rfoCmp.ServerHighestAvailableUpdateId);
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieDescriptionDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ServerHighestAvailableUpdateId;
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieDescriptionDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServerHighestAvailableUpdateId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieTimesDataUpReg::sxmmoviefi_tclMsgMovieTimesDataUpReg(const sxmmoviefi_tclMsgMovieTimesDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieTimesDataUpReg& sxmmoviefi_tclMsgMovieTimesDataUpReg::operator=(const sxmmoviefi_tclMsgMovieTimesDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieTimesDataUpReg::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieTimesDataUpReg::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIETIMESDATA;}
tU8 sxmmoviefi_tclMsgMovieTimesDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmmoviefi_tclMsgMovieTimesDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieTimesDataUpReg::operator==(const sxmmoviefi_tclMsgMovieTimesDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieTimesDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieTimesDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieTimesDataRelUpReg::sxmmoviefi_tclMsgMovieTimesDataRelUpReg(const sxmmoviefi_tclMsgMovieTimesDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieTimesDataRelUpReg& sxmmoviefi_tclMsgMovieTimesDataRelUpReg::operator=(const sxmmoviefi_tclMsgMovieTimesDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieTimesDataRelUpReg::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieTimesDataRelUpReg::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIETIMESDATA;}
tU8 sxmmoviefi_tclMsgMovieTimesDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmmoviefi_tclMsgMovieTimesDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieTimesDataRelUpReg::operator==(const sxmmoviefi_tclMsgMovieTimesDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieTimesDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieTimesDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieTimesDataGet::sxmmoviefi_tclMsgMovieTimesDataGet(const sxmmoviefi_tclMsgMovieTimesDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieTimesDataGet& sxmmoviefi_tclMsgMovieTimesDataGet::operator=(const sxmmoviefi_tclMsgMovieTimesDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieTimesDataGet::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieTimesDataGet::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIETIMESDATA;}
tU8 sxmmoviefi_tclMsgMovieTimesDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmmoviefi_tclMsgMovieTimesDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmmoviefi_tclMsgMovieTimesDataGet::operator==(const sxmmoviefi_tclMsgMovieTimesDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieTimesDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieTimesDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieTimesDataStatus::sxmmoviefi_tclMsgMovieTimesDataStatus(const sxmmoviefi_tclMsgMovieTimesDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmmoviefi_tclMsgMovieTimesDataStatus& sxmmoviefi_tclMsgMovieTimesDataStatus::operator=(const sxmmoviefi_tclMsgMovieTimesDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmmoviefi_tclMsgMovieTimesDataStatus::u16GetServiceID() const {return SXMMOVIEFI_C_U16_SERVICE_ID;}
tU16 sxmmoviefi_tclMsgMovieTimesDataStatus::u16GetFunctionID() const {return SXMMOVIEFI_C_U16_MOVIETIMESDATA;}
tU8 sxmmoviefi_tclMsgMovieTimesDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmmoviefi_tclMsgMovieTimesDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxmmoviefi_tclMsgMovieTimesDataStatus::operator==(const sxmmoviefi_tclMsgMovieTimesDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServerHighestAvailableUpdateId == rfoCmp.ServerHighestAvailableUpdateId);
   return bResult;
}

fi_tclInContext& sxmmoviefi_tclMsgMovieTimesDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ServerHighestAvailableUpdateId;
   return oIn;
}

fi_tclOutContext& sxmmoviefi_tclMsgMovieTimesDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServerHighestAvailableUpdateId;
   return oOut;
}

