#include "precompiled.hh"

tBool sxmmoviefi_tclDescription::bInitMessage(sxmmoviefi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sxmmoviefi_tclToken::EN_LAST_TOKEN:
   case sxmmoviefi_tclToken::EN_LIST:
   case sxmmoviefi_tclToken::EN_END_OF_STRUCT:
   case sxmmoviefi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIETIMESDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_U32,sxmmoviefi_tclSemanticDomain::EN_MSG_CLIENTHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIETIMESDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_BINCONTAINER,sxmmoviefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_LIST,sxmmoviefi_tclSemanticDomain::EN_MSG_LISTOFMOVIETIMESDATA));
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_U32,sxmmoviefi_tclSemanticDomain::EN_MSG_SERVERHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIEDESCRIPTIONDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_U32,sxmmoviefi_tclSemanticDomain::EN_MSG_CLIENTHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIEDESCRIPTIONDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_BINCONTAINER,sxmmoviefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_LIST,sxmmoviefi_tclSemanticDomain::EN_MSG_LISTOFMOVIEDESCRIPTIONDATA));
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_U32,sxmmoviefi_tclSemanticDomain::EN_MSG_SERVERHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOSTATUS:
   {
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_E8_AUTHORISATIONSTATUS,sxmmoviefi_tclSemanticDomain::EN_MSG_MOVIEDATAAUTHSTATUS));
   } break;
   case sxmmoviefi_tclToken::EN_MSG_SIGNALINFOSTATUS:
   {
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_E8_SIGSTATUS,sxmmoviefi_tclSemanticDomain::EN_MSG_SIGNALSTATUS));
   } break;
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_U32,sxmmoviefi_tclSemanticDomain::EN_MSG_SERVERHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_U32,sxmmoviefi_tclSemanticDomain::EN_MSG_SERVERHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmmoviefi_tclToken::EN_BINCONTAINER:
   case sxmmoviefi_tclToken::EN_E8_AUTHORISATIONSTATUS:
   case sxmmoviefi_tclToken::EN_E8_SIGSTATUS:
   case sxmmoviefi_tclToken::EN_U8:   
   case sxmmoviefi_tclToken::EN_S8:   
   case sxmmoviefi_tclToken::EN_U16:   
   case sxmmoviefi_tclToken::EN_S16:   
   case sxmmoviefi_tclToken::EN_U24:   
   case sxmmoviefi_tclToken::EN_S24:   
   case sxmmoviefi_tclToken::EN_U32:   
   case sxmmoviefi_tclToken::EN_S32:   
   case sxmmoviefi_tclToken::EN_U64:   
   case sxmmoviefi_tclToken::EN_S64:   
   case sxmmoviefi_tclToken::EN_F32:   
   case sxmmoviefi_tclToken::EN_F64:   
   case sxmmoviefi_tclToken::EN_BOOL:   
   case sxmmoviefi_tclToken::EN_STRING:   
   case sxmmoviefi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(sxmmoviefi_tclKnot(enMsgToken,sxmmoviefi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sxmmoviefi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool sxmmoviefi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sxmmoviefi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sxmmoviefi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sxmmoviefi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sxmmoviefi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(sxmmoviefi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(sxmmoviefi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(sxmmoviefi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sxmmoviefi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sxmmoviefi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sxmmoviefi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(sxmmoviefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sxmmoviefi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(sxmmoviefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case sxmmoviefi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sxmmoviefi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmmoviefi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIETIMESDATAMETHODSTART:
   case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIETIMESDATAMETHODRESULT:
   case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIEDESCRIPTIONDATAMETHODSTART:
   case sxmmoviefi_tclToken::EN_MSG_TRANSFERMOVIEDESCRIPTIONDATAMETHODRESULT:
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOUPREG:
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFORELUPREG:
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOGET:
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDATAAUTHINFOSTATUS:
   case sxmmoviefi_tclToken::EN_MSG_SIGNALINFOUPREG:
   case sxmmoviefi_tclToken::EN_MSG_SIGNALINFORELUPREG:
   case sxmmoviefi_tclToken::EN_MSG_SIGNALINFOGET:
   case sxmmoviefi_tclToken::EN_MSG_SIGNALINFOSTATUS:
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATAUPREG:
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATARELUPREG:
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATAGET:
   case sxmmoviefi_tclToken::EN_MSG_MOVIEDESCRIPTIONDATASTATUS:
   case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATAUPREG:
   case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATARELUPREG:
   case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATAGET:
   case sxmmoviefi_tclToken::EN_MSG_MOVIETIMESDATASTATUS:
      bInitMessage(enToken);
      break;
   case sxmmoviefi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_END_OF_STRUCT,sxmmoviefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_U8,sxmmoviefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxmmoviefi_tclKnot(sxmmoviefi_tclToken::EN_LIST,sxmmoviefi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxmmoviefi_tclToken::EN_E8_AUTHORISATIONSTATUS:
   {
      fi_tcl_e8_AuthorisationStatus o_e8_AuthorisationStatus;
      if (!bDoIt(o_e8_AuthorisationStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxmmoviefi_tclToken::EN_E8_SIGSTATUS:
   {
      fi_tcl_e8_SigStatus o_e8_SigStatus;
      if (!bDoIt(o_e8_SigStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
      case sxmmoviefi_tclToken::EN_UNKNOWN:
      case sxmmoviefi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

