/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgRegionWishListMethodStart::sxmfuelfi_tclMsgRegionWishListMethodStart(const sxmfuelfi_tclMsgRegionWishListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LocnFilterSwitch = coRef.LocnFilterSwitch;
   ListOfRegions = coRef.ListOfRegions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgRegionWishListMethodStart& sxmfuelfi_tclMsgRegionWishListMethodStart::operator=(const sxmfuelfi_tclMsgRegionWishListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LocnFilterSwitch = coRef.LocnFilterSwitch;
   ListOfRegions = coRef.ListOfRegions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgRegionWishListMethodStart::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgRegionWishListMethodStart::u16GetFunctionID() const {return SXMFUELFI_C_U16_REGIONWISHLIST;}
tU8 sxmfuelfi_tclMsgRegionWishListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid sxmfuelfi_tclMsgRegionWishListMethodStart::vDestroy()
{
   ListOfRegions.clear();
}

tU32 sxmfuelfi_tclMsgRegionWishListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ListOfRegions.size()*2;
}

tBool sxmfuelfi_tclMsgRegionWishListMethodStart::operator==(const sxmfuelfi_tclMsgRegionWishListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LocnFilterSwitch == rfoCmp.LocnFilterSwitch);
      bResult = bResult && (ListOfRegions.size() == rfoCmp.ListOfRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfRegions.size()); ++u32Idx)
            bResult = bResult && (ListOfRegions[u32Idx] == rfoCmp.ListOfRegions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgRegionWishListMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LocnFilterSwitch;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ListOfRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfRegions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgRegionWishListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LocnFilterSwitch;
   oOut << (tU32)ListOfRegions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRegions.size(); ++u32Idx)
         oOut << ListOfRegions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgRegionWishListMethodResult::sxmfuelfi_tclMsgRegionWishListMethodResult(const sxmfuelfi_tclMsgRegionWishListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FilterAccepted = coRef.FilterAccepted;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgRegionWishListMethodResult& sxmfuelfi_tclMsgRegionWishListMethodResult::operator=(const sxmfuelfi_tclMsgRegionWishListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FilterAccepted = coRef.FilterAccepted;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgRegionWishListMethodResult::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgRegionWishListMethodResult::u16GetFunctionID() const {return SXMFUELFI_C_U16_REGIONWISHLIST;}
tU8 sxmfuelfi_tclMsgRegionWishListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 sxmfuelfi_tclMsgRegionWishListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmfuelfi_tclMsgRegionWishListMethodResult::operator==(const sxmfuelfi_tclMsgRegionWishListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FilterAccepted == rfoCmp.FilterAccepted);
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgRegionWishListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> FilterAccepted;
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgRegionWishListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FilterAccepted;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClientHighestAvailableUpdateId = coRef.ClientHighestAvailableUpdateId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart& sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::operator=(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ClientHighestAvailableUpdateId = coRef.ClientHighestAvailableUpdateId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::u16GetFunctionID() const {return SXMFUELFI_C_U16_TRANSFERFUELPRICEDATA;}
tU8 sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::operator==(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClientHighestAvailableUpdateId == rfoCmp.ClientHighestAvailableUpdateId);
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ClientHighestAvailableUpdateId;
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ClientHighestAvailableUpdateId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   ListOfFuelPriceData = coRef.ListOfFuelPriceData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult& sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::operator=(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   ListOfFuelPriceData = coRef.ListOfFuelPriceData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::u16GetFunctionID() const {return SXMFUELFI_C_U16_TRANSFERFUELPRICEDATA;}
tU8 sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfFuelPriceData.size(); ++u32Idx)
         ListOfFuelPriceData[u32Idx].vDestroy();
   }
   ListOfFuelPriceData.clear();
}

tU32 sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfFuelPriceData.size(); ++u32ListIdx)
      u32DynamicSize += ListOfFuelPriceData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::operator==(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServerHighestAvailableUpdateId == rfoCmp.ServerHighestAvailableUpdateId);
      bResult = bResult && (ListOfFuelPriceData.size() == rfoCmp.ListOfFuelPriceData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfFuelPriceData.size()); ++u32Idx)
            bResult = bResult && (ListOfFuelPriceData[u32Idx] == rfoCmp.ListOfFuelPriceData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ServerHighestAvailableUpdateId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfFuelPriceData.size(); ++u32Idx)
      {
         ListOfFuelPriceData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfFuelPriceData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfFuelPriceData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServerHighestAvailableUpdateId;
   oOut << (tU32)ListOfFuelPriceData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfFuelPriceData.size(); ++u32Idx)
         oOut << ListOfFuelPriceData[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::sxmfuelfi_tclMsgFuelDataAuthInfoUpReg(const sxmfuelfi_tclMsgFuelDataAuthInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelDataAuthInfoUpReg& sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::operator=(const sxmfuelfi_tclMsgFuelDataAuthInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELDATAAUTHINFO;}
tU8 sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::operator==(const sxmfuelfi_tclMsgFuelDataAuthInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelDataAuthInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg(const sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg& sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::operator=(const sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELDATAAUTHINFO;}
tU8 sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::operator==(const sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelDataAuthInfoGet::sxmfuelfi_tclMsgFuelDataAuthInfoGet(const sxmfuelfi_tclMsgFuelDataAuthInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelDataAuthInfoGet& sxmfuelfi_tclMsgFuelDataAuthInfoGet::operator=(const sxmfuelfi_tclMsgFuelDataAuthInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelDataAuthInfoGet::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelDataAuthInfoGet::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELDATAAUTHINFO;}
tU8 sxmfuelfi_tclMsgFuelDataAuthInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmfuelfi_tclMsgFuelDataAuthInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelDataAuthInfoGet::operator==(const sxmfuelfi_tclMsgFuelDataAuthInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelDataAuthInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelDataAuthInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelDataAuthInfoStatus::sxmfuelfi_tclMsgFuelDataAuthInfoStatus(const sxmfuelfi_tclMsgFuelDataAuthInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelDataAuthStatus = coRef.FuelDataAuthStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelDataAuthInfoStatus& sxmfuelfi_tclMsgFuelDataAuthInfoStatus::operator=(const sxmfuelfi_tclMsgFuelDataAuthInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   FuelDataAuthStatus = coRef.FuelDataAuthStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelDataAuthInfoStatus::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelDataAuthInfoStatus::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELDATAAUTHINFO;}
tU8 sxmfuelfi_tclMsgFuelDataAuthInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmfuelfi_tclMsgFuelDataAuthInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmfuelfi_tclMsgFuelDataAuthInfoStatus::operator==(const sxmfuelfi_tclMsgFuelDataAuthInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelDataAuthStatus == rfoCmp.FuelDataAuthStatus);
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelDataAuthInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> FuelDataAuthStatus;
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelDataAuthInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FuelDataAuthStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgSXMSignalInfoUpReg::sxmfuelfi_tclMsgSXMSignalInfoUpReg(const sxmfuelfi_tclMsgSXMSignalInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgSXMSignalInfoUpReg& sxmfuelfi_tclMsgSXMSignalInfoUpReg::operator=(const sxmfuelfi_tclMsgSXMSignalInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgSXMSignalInfoUpReg::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgSXMSignalInfoUpReg::u16GetFunctionID() const {return SXMFUELFI_C_U16_SXMSIGNALINFO;}
tU8 sxmfuelfi_tclMsgSXMSignalInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmfuelfi_tclMsgSXMSignalInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgSXMSignalInfoUpReg::operator==(const sxmfuelfi_tclMsgSXMSignalInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgSXMSignalInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgSXMSignalInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::sxmfuelfi_tclMsgSXMSignalInfoRelUpReg(const sxmfuelfi_tclMsgSXMSignalInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgSXMSignalInfoRelUpReg& sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::operator=(const sxmfuelfi_tclMsgSXMSignalInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::u16GetFunctionID() const {return SXMFUELFI_C_U16_SXMSIGNALINFO;}
tU8 sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::operator==(const sxmfuelfi_tclMsgSXMSignalInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgSXMSignalInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgSXMSignalInfoGet::sxmfuelfi_tclMsgSXMSignalInfoGet(const sxmfuelfi_tclMsgSXMSignalInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgSXMSignalInfoGet& sxmfuelfi_tclMsgSXMSignalInfoGet::operator=(const sxmfuelfi_tclMsgSXMSignalInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgSXMSignalInfoGet::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgSXMSignalInfoGet::u16GetFunctionID() const {return SXMFUELFI_C_U16_SXMSIGNALINFO;}
tU8 sxmfuelfi_tclMsgSXMSignalInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmfuelfi_tclMsgSXMSignalInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgSXMSignalInfoGet::operator==(const sxmfuelfi_tclMsgSXMSignalInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgSXMSignalInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgSXMSignalInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgSXMSignalInfoStatus::sxmfuelfi_tclMsgSXMSignalInfoStatus(const sxmfuelfi_tclMsgSXMSignalInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   SXMSignalStatus = coRef.SXMSignalStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgSXMSignalInfoStatus& sxmfuelfi_tclMsgSXMSignalInfoStatus::operator=(const sxmfuelfi_tclMsgSXMSignalInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   SXMSignalStatus = coRef.SXMSignalStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgSXMSignalInfoStatus::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgSXMSignalInfoStatus::u16GetFunctionID() const {return SXMFUELFI_C_U16_SXMSIGNALINFO;}
tU8 sxmfuelfi_tclMsgSXMSignalInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmfuelfi_tclMsgSXMSignalInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmfuelfi_tclMsgSXMSignalInfoStatus::operator==(const sxmfuelfi_tclMsgSXMSignalInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SXMSignalStatus == rfoCmp.SXMSignalStatus);
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgSXMSignalInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> SXMSignalStatus;
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgSXMSignalInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SXMSignalStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelTypeDataUpReg::sxmfuelfi_tclMsgFuelTypeDataUpReg(const sxmfuelfi_tclMsgFuelTypeDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelTypeDataUpReg& sxmfuelfi_tclMsgFuelTypeDataUpReg::operator=(const sxmfuelfi_tclMsgFuelTypeDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelTypeDataUpReg::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelTypeDataUpReg::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELTYPEDATA;}
tU8 sxmfuelfi_tclMsgFuelTypeDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmfuelfi_tclMsgFuelTypeDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelTypeDataUpReg::operator==(const sxmfuelfi_tclMsgFuelTypeDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelTypeDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelTypeDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelTypeDataRelUpReg::sxmfuelfi_tclMsgFuelTypeDataRelUpReg(const sxmfuelfi_tclMsgFuelTypeDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelTypeDataRelUpReg& sxmfuelfi_tclMsgFuelTypeDataRelUpReg::operator=(const sxmfuelfi_tclMsgFuelTypeDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelTypeDataRelUpReg::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelTypeDataRelUpReg::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELTYPEDATA;}
tU8 sxmfuelfi_tclMsgFuelTypeDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmfuelfi_tclMsgFuelTypeDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelTypeDataRelUpReg::operator==(const sxmfuelfi_tclMsgFuelTypeDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelTypeDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelTypeDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelTypeDataGet::sxmfuelfi_tclMsgFuelTypeDataGet(const sxmfuelfi_tclMsgFuelTypeDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelTypeDataGet& sxmfuelfi_tclMsgFuelTypeDataGet::operator=(const sxmfuelfi_tclMsgFuelTypeDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelTypeDataGet::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelTypeDataGet::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELTYPEDATA;}
tU8 sxmfuelfi_tclMsgFuelTypeDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmfuelfi_tclMsgFuelTypeDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelTypeDataGet::operator==(const sxmfuelfi_tclMsgFuelTypeDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelTypeDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelTypeDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelTypeDataStatus::sxmfuelfi_tclMsgFuelTypeDataStatus(const sxmfuelfi_tclMsgFuelTypeDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServcTextVer = coRef.ServcTextVer;
   ServcTextData = coRef.ServcTextData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelTypeDataStatus& sxmfuelfi_tclMsgFuelTypeDataStatus::operator=(const sxmfuelfi_tclMsgFuelTypeDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ServcTextVer = coRef.ServcTextVer;
   ServcTextData = coRef.ServcTextData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelTypeDataStatus::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelTypeDataStatus::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELTYPEDATA;}
tU8 sxmfuelfi_tclMsgFuelTypeDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid sxmfuelfi_tclMsgFuelTypeDataStatus::vDestroy()
{
   ServcTextData.clear();
}

tU32 sxmfuelfi_tclMsgFuelTypeDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ServcTextData.size()*1;
}

tBool sxmfuelfi_tclMsgFuelTypeDataStatus::operator==(const sxmfuelfi_tclMsgFuelTypeDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServcTextVer == rfoCmp.ServcTextVer);
      bResult = bResult && (ServcTextData.size() == rfoCmp.ServcTextData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ServcTextData.size()); ++u32Idx)
            bResult = bResult && (ServcTextData[u32Idx] == rfoCmp.ServcTextData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelTypeDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ServcTextVer;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ServcTextData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ServcTextData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelTypeDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServcTextVer;
   oOut << (tU32)ServcTextData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ServcTextData.size(); ++u32Idx)
         oOut << ServcTextData[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelPriceDataUpReg::sxmfuelfi_tclMsgFuelPriceDataUpReg(const sxmfuelfi_tclMsgFuelPriceDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelPriceDataUpReg& sxmfuelfi_tclMsgFuelPriceDataUpReg::operator=(const sxmfuelfi_tclMsgFuelPriceDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelPriceDataUpReg::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelPriceDataUpReg::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELPRICEDATA;}
tU8 sxmfuelfi_tclMsgFuelPriceDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmfuelfi_tclMsgFuelPriceDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelPriceDataUpReg::operator==(const sxmfuelfi_tclMsgFuelPriceDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelPriceDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelPriceDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelPriceDataRelUpReg::sxmfuelfi_tclMsgFuelPriceDataRelUpReg(const sxmfuelfi_tclMsgFuelPriceDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelPriceDataRelUpReg& sxmfuelfi_tclMsgFuelPriceDataRelUpReg::operator=(const sxmfuelfi_tclMsgFuelPriceDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelPriceDataRelUpReg::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelPriceDataRelUpReg::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELPRICEDATA;}
tU8 sxmfuelfi_tclMsgFuelPriceDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmfuelfi_tclMsgFuelPriceDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelPriceDataRelUpReg::operator==(const sxmfuelfi_tclMsgFuelPriceDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelPriceDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelPriceDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelPriceDataGet::sxmfuelfi_tclMsgFuelPriceDataGet(const sxmfuelfi_tclMsgFuelPriceDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelPriceDataGet& sxmfuelfi_tclMsgFuelPriceDataGet::operator=(const sxmfuelfi_tclMsgFuelPriceDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelPriceDataGet::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelPriceDataGet::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELPRICEDATA;}
tU8 sxmfuelfi_tclMsgFuelPriceDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmfuelfi_tclMsgFuelPriceDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmfuelfi_tclMsgFuelPriceDataGet::operator==(const sxmfuelfi_tclMsgFuelPriceDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelPriceDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelPriceDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelPriceDataStatus::sxmfuelfi_tclMsgFuelPriceDataStatus(const sxmfuelfi_tclMsgFuelPriceDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmfuelfi_tclMsgFuelPriceDataStatus& sxmfuelfi_tclMsgFuelPriceDataStatus::operator=(const sxmfuelfi_tclMsgFuelPriceDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ServerHighestAvailableUpdateId = coRef.ServerHighestAvailableUpdateId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmfuelfi_tclMsgFuelPriceDataStatus::u16GetServiceID() const {return SXMFUELFI_C_U16_SERVICE_ID;}
tU16 sxmfuelfi_tclMsgFuelPriceDataStatus::u16GetFunctionID() const {return SXMFUELFI_C_U16_FUELPRICEDATA;}
tU8 sxmfuelfi_tclMsgFuelPriceDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmfuelfi_tclMsgFuelPriceDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxmfuelfi_tclMsgFuelPriceDataStatus::operator==(const sxmfuelfi_tclMsgFuelPriceDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServerHighestAvailableUpdateId == rfoCmp.ServerHighestAvailableUpdateId);
   return bResult;
}

fi_tclInContext& sxmfuelfi_tclMsgFuelPriceDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ServerHighestAvailableUpdateId;
   return oIn;
}

fi_tclOutContext& sxmfuelfi_tclMsgFuelPriceDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServerHighestAvailableUpdateId;
   return oOut;
}

