/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SXM_SMS_WEATHERFITYPES_HEADER
#define SXM_SMS_WEATHERFITYPES_HEADER

// #include <vector>
// 


class sxm_sms_weatherfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart& operator=(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart& coRef);
   sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_SXMSharedMemoryDescription, std::allocator<fi_tcl_SXMSharedMemoryDescription> > SharedMemories;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART;}
};

class sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult& operator=(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult& coRef);
   sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_SXMSharedMemoryDescription, std::allocator<fi_tcl_SXMSharedMemoryDescription> > SharedMemories;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT;}
};

class sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart& operator=(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart& coRef);
   sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART;}
};

class sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult& operator=(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult& coRef);
   sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;
   std::vector<fi_tcl_SXMShape, std::allocator<fi_tcl_SXMShape> > Shapes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT;}
};

class sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart& operator=(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart& coRef);
   sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART;}
};

class sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult& operator=(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult& coRef);
   sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;
   std::vector<fi_tcl_SXMShape, std::allocator<fi_tcl_SXMShape> > Shapes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT;}
};

class sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart& operator=(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart& coRef);
   sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART;}
};

class sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult& operator=(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult& coRef);
   sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;
   std::vector<fi_tcl_SXMShape, std::allocator<fi_tcl_SXMShape> > Shapes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT;}
};

class sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart():TileType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart& operator=(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart& coRef);
   sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SXMTileType TileType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODSTART;}
};

class sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult():TileType(),AccessGranted(0),UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult& operator=(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult& coRef);
   sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SXMTileType TileType;
   tBool AccessGranted;
   tU32 UpdateCounter;
   std::vector<fi_tcl_SXMSharedMemoryTile, std::allocator<fi_tcl_SXMSharedMemoryTile> > TileList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODRESULT;}
};

class sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart():TileType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& operator=(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& coRef);
   sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SXMTileType TileType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODSTART;}
};

class sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& operator=(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& coRef);
   sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODRESULT;}
};

class sxm_sms_weatherfi_tclMsgNowradDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgNowradDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgNowradDataUpReg& operator=(const sxm_sms_weatherfi_tclMsgNowradDataUpReg& coRef);
   sxm_sms_weatherfi_tclMsgNowradDataUpReg(const sxm_sms_weatherfi_tclMsgNowradDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgNowradDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATAUPREG;}
};

class sxm_sms_weatherfi_tclMsgNowradDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgNowradDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgNowradDataRelUpReg& operator=(const sxm_sms_weatherfi_tclMsgNowradDataRelUpReg& coRef);
   sxm_sms_weatherfi_tclMsgNowradDataRelUpReg(const sxm_sms_weatherfi_tclMsgNowradDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgNowradDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATARELUPREG;}
};

class sxm_sms_weatherfi_tclMsgNowradDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgNowradDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgNowradDataGet& operator=(const sxm_sms_weatherfi_tclMsgNowradDataGet& coRef);
   sxm_sms_weatherfi_tclMsgNowradDataGet(const sxm_sms_weatherfi_tclMsgNowradDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgNowradDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATAGET;}
};

class sxm_sms_weatherfi_tclMsgNowradDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgNowradDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgNowradDataStatus& operator=(const sxm_sms_weatherfi_tclMsgNowradDataStatus& coRef);
   sxm_sms_weatherfi_tclMsgNowradDataStatus(const sxm_sms_weatherfi_tclMsgNowradDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgNowradDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATASTATUS;}
};

class sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg& operator=(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg& coRef);
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATAUPREG;}
};

class sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg& operator=(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg& coRef);
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATARELUPREG;}
};

class sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet& operator=(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet& coRef);
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATAGET;}
};

class sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus& operator=(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus& coRef);
   sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATASTATUS;}
};

class sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg& operator=(const sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg& coRef);
   sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg(const sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATAUPREG;}
};

class sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg& operator=(const sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg& coRef);
   sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg(const sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATARELUPREG;}
};

class sxm_sms_weatherfi_tclMsgWindDirectionDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgWindDirectionDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgWindDirectionDataGet& operator=(const sxm_sms_weatherfi_tclMsgWindDirectionDataGet& coRef);
   sxm_sms_weatherfi_tclMsgWindDirectionDataGet(const sxm_sms_weatherfi_tclMsgWindDirectionDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgWindDirectionDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATAGET;}
};

class sxm_sms_weatherfi_tclMsgWindDirectionDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgWindDirectionDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgWindDirectionDataStatus& operator=(const sxm_sms_weatherfi_tclMsgWindDirectionDataStatus& coRef);
   sxm_sms_weatherfi_tclMsgWindDirectionDataStatus(const sxm_sms_weatherfi_tclMsgWindDirectionDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgWindDirectionDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATASTATUS;}
};

class sxm_sms_weatherfi_tclMsgSurfaceDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgSurfaceDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgSurfaceDataUpReg& operator=(const sxm_sms_weatherfi_tclMsgSurfaceDataUpReg& coRef);
   sxm_sms_weatherfi_tclMsgSurfaceDataUpReg(const sxm_sms_weatherfi_tclMsgSurfaceDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgSurfaceDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATAUPREG;}
};

class sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg& operator=(const sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg& coRef);
   sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg(const sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATARELUPREG;}
};

class sxm_sms_weatherfi_tclMsgSurfaceDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgSurfaceDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgSurfaceDataGet& operator=(const sxm_sms_weatherfi_tclMsgSurfaceDataGet& coRef);
   sxm_sms_weatherfi_tclMsgSurfaceDataGet(const sxm_sms_weatherfi_tclMsgSurfaceDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgSurfaceDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATAGET;}
};

class sxm_sms_weatherfi_tclMsgSurfaceDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgSurfaceDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgSurfaceDataStatus& operator=(const sxm_sms_weatherfi_tclMsgSurfaceDataStatus& coRef);
   sxm_sms_weatherfi_tclMsgSurfaceDataStatus(const sxm_sms_weatherfi_tclMsgSurfaceDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgSurfaceDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATASTATUS;}
};

class sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg& operator=(const sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg& coRef);
   sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg(const sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG;}
};

class sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg& operator=(const sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg& coRef);
   sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg(const sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG;}
};

class sxm_sms_weatherfi_tclMsgStormAttributesDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgStormAttributesDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgStormAttributesDataGet& operator=(const sxm_sms_weatherfi_tclMsgStormAttributesDataGet& coRef);
   sxm_sms_weatherfi_tclMsgStormAttributesDataGet(const sxm_sms_weatherfi_tclMsgStormAttributesDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgStormAttributesDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET;}
};

class sxm_sms_weatherfi_tclMsgStormAttributesDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgStormAttributesDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgStormAttributesDataStatus& operator=(const sxm_sms_weatherfi_tclMsgStormAttributesDataStatus& coRef);
   sxm_sms_weatherfi_tclMsgStormAttributesDataStatus(const sxm_sms_weatherfi_tclMsgStormAttributesDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgStormAttributesDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS;}
};

class sxm_sms_weatherfi_tclMsgStormTrackDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgStormTrackDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgStormTrackDataUpReg& operator=(const sxm_sms_weatherfi_tclMsgStormTrackDataUpReg& coRef);
   sxm_sms_weatherfi_tclMsgStormTrackDataUpReg(const sxm_sms_weatherfi_tclMsgStormTrackDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgStormTrackDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATAUPREG;}
};

class sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg& operator=(const sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg& coRef);
   sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg(const sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG;}
};

class sxm_sms_weatherfi_tclMsgStormTrackDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgStormTrackDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgStormTrackDataGet& operator=(const sxm_sms_weatherfi_tclMsgStormTrackDataGet& coRef);
   sxm_sms_weatherfi_tclMsgStormTrackDataGet(const sxm_sms_weatherfi_tclMsgStormTrackDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgStormTrackDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATAGET;}
};

class sxm_sms_weatherfi_tclMsgStormTrackDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxm_sms_weatherfi_tclMsgStormTrackDataStatus():UpdateCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxm_sms_weatherfi_tclMsgStormTrackDataStatus& operator=(const sxm_sms_weatherfi_tclMsgStormTrackDataStatus& coRef);
   sxm_sms_weatherfi_tclMsgStormTrackDataStatus(const sxm_sms_weatherfi_tclMsgStormTrackDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UpdateCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxm_sms_weatherfi_tclMsgStormTrackDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATASTATUS;}
};


#endif
