/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SharedMemories = coRef.SharedMemories;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart& sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::operator=(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SharedMemories = coRef.SharedMemories;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_EXCHANGECAPABILITIES;}
tU8 sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         SharedMemories[u32Idx].vDestroy();
   }
   SharedMemories.clear();
}

tU32 sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SharedMemories.size(); ++u32ListIdx)
      u32DynamicSize += SharedMemories[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::operator==(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SharedMemories.size() == rfoCmp.SharedMemories.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SharedMemories.size()); ++u32Idx)
            bResult = bResult && (SharedMemories[u32Idx] == rfoCmp.SharedMemories[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
      {
         SharedMemories[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SharedMemories.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SharedMemories[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SharedMemories.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         oOut << SharedMemories[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   SharedMemories = coRef.SharedMemories;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult& sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::operator=(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SharedMemories = coRef.SharedMemories;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_EXCHANGECAPABILITIES;}
tU8 sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         SharedMemories[u32Idx].vDestroy();
   }
   SharedMemories.clear();
}

tU32 sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SharedMemories.size(); ++u32ListIdx)
      u32DynamicSize += SharedMemories[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::operator==(const sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SharedMemories.size() == rfoCmp.SharedMemories.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SharedMemories.size()); ++u32Idx)
            bResult = bResult && (SharedMemories[u32Idx] == rfoCmp.SharedMemories[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
      {
         SharedMemories[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SharedMemories.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SharedMemories[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgExchangeCapabilitiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SharedMemories.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         oOut << SharedMemories[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart& sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::operator=(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_GETSURFACEDATA;}
tU8 sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::operator==(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult& sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::operator=(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_GETSURFACEDATA;}
tU8 sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         Shapes[u32Idx].vDestroy();
   }
   Shapes.clear();
}

tU32 sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Shapes.size(); ++u32ListIdx)
      u32DynamicSize += Shapes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::operator==(const sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
      bResult = bResult && (Shapes.size() == rfoCmp.Shapes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Shapes.size()); ++u32Idx)
            bResult = bResult && (Shapes[u32Idx] == rfoCmp.Shapes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::oRead(fi_tclInContext& oIn)
{
   if (1 <= oIn.u16GetMajorVersion())
   {
      oIn >> UpdateCounter;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
      {
         Shapes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Shapes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Shapes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgGetSurfaceDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (1 <= oOut.u16GetMajorVersion())
   {
      oOut << UpdateCounter;
   }
   oOut << (tU32)Shapes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         oOut << Shapes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart& sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::operator=(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_GETSTORMATTRIBUTESDATA;}
tU8 sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::operator==(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult& sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::operator=(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_GETSTORMATTRIBUTESDATA;}
tU8 sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         Shapes[u32Idx].vDestroy();
   }
   Shapes.clear();
}

tU32 sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Shapes.size(); ++u32ListIdx)
      u32DynamicSize += Shapes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::operator==(const sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
      bResult = bResult && (Shapes.size() == rfoCmp.Shapes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Shapes.size()); ++u32Idx)
            bResult = bResult && (Shapes[u32Idx] == rfoCmp.Shapes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::oRead(fi_tclInContext& oIn)
{
   if (1 <= oIn.u16GetMajorVersion())
   {
      oIn >> UpdateCounter;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
      {
         Shapes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Shapes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Shapes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgGetStormAttributesDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (1 <= oOut.u16GetMajorVersion())
   {
      oOut << UpdateCounter;
   }
   oOut << (tU32)Shapes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         oOut << Shapes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart& sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::operator=(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_GETSTORMTRACKDATA;}
tU8 sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::operator==(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult& sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::operator=(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_GETSTORMTRACKDATA;}
tU8 sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         Shapes[u32Idx].vDestroy();
   }
   Shapes.clear();
}

tU32 sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Shapes.size(); ++u32ListIdx)
      u32DynamicSize += Shapes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::operator==(const sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
      bResult = bResult && (Shapes.size() == rfoCmp.Shapes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Shapes.size()); ++u32Idx)
            bResult = bResult && (Shapes[u32Idx] == rfoCmp.Shapes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::oRead(fi_tclInContext& oIn)
{
   if (1 <= oIn.u16GetMajorVersion())
   {
      oIn >> UpdateCounter;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
      {
         Shapes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Shapes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Shapes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgGetStormTrackDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (1 <= oOut.u16GetMajorVersion())
   {
      oOut << UpdateCounter;
   }
   oOut << (tU32)Shapes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         oOut << Shapes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TileType = coRef.TileType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart& sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::operator=(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TileType = coRef.TileType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_ACQUIREACCESSTOSHAREDMEMORY;}
tU8 sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::operator==(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TileType == rfoCmp.TileType);
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TileType;
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TileType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TileType = coRef.TileType;
   AccessGranted = coRef.AccessGranted;
   UpdateCounter = coRef.UpdateCounter;
   TileList = coRef.TileList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult& sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::operator=(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TileType = coRef.TileType;
   AccessGranted = coRef.AccessGranted;
   UpdateCounter = coRef.UpdateCounter;
   TileList = coRef.TileList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_ACQUIREACCESSTOSHAREDMEMORY;}
tU8 sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TileList.size(); ++u32Idx)
         TileList[u32Idx].vDestroy();
   }
   TileList.clear();
}

tU32 sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+5+TileList.size()*44;
}

tBool sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::operator==(const sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TileType == rfoCmp.TileType);
      bResult = bResult && (AccessGranted == rfoCmp.AccessGranted);
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
      bResult = bResult && (TileList.size() == rfoCmp.TileList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TileList.size()); ++u32Idx)
            bResult = bResult && (TileList[u32Idx] == rfoCmp.TileList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TileType;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> AccessGranted;
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> UpdateCounter;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TileList.size(); ++u32Idx)
      {
         TileList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TileList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TileList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgAcquireAccessToSharedMemoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TileType;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << AccessGranted;
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << UpdateCounter;
   }
   oOut << (tU32)TileList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TileList.size(); ++u32Idx)
         oOut << TileList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TileType = coRef.TileType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::operator=(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TileType = coRef.TileType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_RELEASEACCESSFROMSHAREDMEMORY;}
tU8 sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::operator==(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TileType == rfoCmp.TileType);
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TileType;
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TileType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::operator=(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_RELEASEACCESSFROMSHAREDMEMORY;}
tU8 sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::operator==(const sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgNowradDataUpReg::sxm_sms_weatherfi_tclMsgNowradDataUpReg(const sxm_sms_weatherfi_tclMsgNowradDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgNowradDataUpReg& sxm_sms_weatherfi_tclMsgNowradDataUpReg::operator=(const sxm_sms_weatherfi_tclMsgNowradDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgNowradDataUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgNowradDataUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_NOWRADDATA;}
tU8 sxm_sms_weatherfi_tclMsgNowradDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxm_sms_weatherfi_tclMsgNowradDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgNowradDataUpReg::operator==(const sxm_sms_weatherfi_tclMsgNowradDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgNowradDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgNowradDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::sxm_sms_weatherfi_tclMsgNowradDataRelUpReg(const sxm_sms_weatherfi_tclMsgNowradDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgNowradDataRelUpReg& sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::operator=(const sxm_sms_weatherfi_tclMsgNowradDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_NOWRADDATA;}
tU8 sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::operator==(const sxm_sms_weatherfi_tclMsgNowradDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgNowradDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgNowradDataGet::sxm_sms_weatherfi_tclMsgNowradDataGet(const sxm_sms_weatherfi_tclMsgNowradDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgNowradDataGet& sxm_sms_weatherfi_tclMsgNowradDataGet::operator=(const sxm_sms_weatherfi_tclMsgNowradDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgNowradDataGet::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgNowradDataGet::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_NOWRADDATA;}
tU8 sxm_sms_weatherfi_tclMsgNowradDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxm_sms_weatherfi_tclMsgNowradDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgNowradDataGet::operator==(const sxm_sms_weatherfi_tclMsgNowradDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgNowradDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgNowradDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgNowradDataStatus::sxm_sms_weatherfi_tclMsgNowradDataStatus(const sxm_sms_weatherfi_tclMsgNowradDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgNowradDataStatus& sxm_sms_weatherfi_tclMsgNowradDataStatus::operator=(const sxm_sms_weatherfi_tclMsgNowradDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgNowradDataStatus::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgNowradDataStatus::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_NOWRADDATA;}
tU8 sxm_sms_weatherfi_tclMsgNowradDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxm_sms_weatherfi_tclMsgNowradDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxm_sms_weatherfi_tclMsgNowradDataStatus::operator==(const sxm_sms_weatherfi_tclMsgNowradDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgNowradDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgNowradDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg& sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::operator=(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_WINDMAGNITUDEDATA;}
tU8 sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::operator==(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgWindMagnitudeDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg& sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::operator=(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_WINDMAGNITUDEDATA;}
tU8 sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::operator==(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgWindMagnitudeDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet& sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::operator=(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_WINDMAGNITUDEDATA;}
tU8 sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::operator==(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgWindMagnitudeDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus& sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::operator=(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_WINDMAGNITUDEDATA;}
tU8 sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::operator==(const sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgWindMagnitudeDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg(const sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg& sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::operator=(const sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_WINDDIRECTIONDATA;}
tU8 sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::operator==(const sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgWindDirectionDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg(const sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg& sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::operator=(const sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_WINDDIRECTIONDATA;}
tU8 sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::operator==(const sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgWindDirectionDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindDirectionDataGet::sxm_sms_weatherfi_tclMsgWindDirectionDataGet(const sxm_sms_weatherfi_tclMsgWindDirectionDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindDirectionDataGet& sxm_sms_weatherfi_tclMsgWindDirectionDataGet::operator=(const sxm_sms_weatherfi_tclMsgWindDirectionDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgWindDirectionDataGet::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgWindDirectionDataGet::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_WINDDIRECTIONDATA;}
tU8 sxm_sms_weatherfi_tclMsgWindDirectionDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxm_sms_weatherfi_tclMsgWindDirectionDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgWindDirectionDataGet::operator==(const sxm_sms_weatherfi_tclMsgWindDirectionDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgWindDirectionDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgWindDirectionDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::sxm_sms_weatherfi_tclMsgWindDirectionDataStatus(const sxm_sms_weatherfi_tclMsgWindDirectionDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgWindDirectionDataStatus& sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::operator=(const sxm_sms_weatherfi_tclMsgWindDirectionDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_WINDDIRECTIONDATA;}
tU8 sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::operator==(const sxm_sms_weatherfi_tclMsgWindDirectionDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgWindDirectionDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::sxm_sms_weatherfi_tclMsgSurfaceDataUpReg(const sxm_sms_weatherfi_tclMsgSurfaceDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgSurfaceDataUpReg& sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::operator=(const sxm_sms_weatherfi_tclMsgSurfaceDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_SURFACEDATA;}
tU8 sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::operator==(const sxm_sms_weatherfi_tclMsgSurfaceDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgSurfaceDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg(const sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg& sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::operator=(const sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_SURFACEDATA;}
tU8 sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::operator==(const sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgSurfaceDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgSurfaceDataGet::sxm_sms_weatherfi_tclMsgSurfaceDataGet(const sxm_sms_weatherfi_tclMsgSurfaceDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgSurfaceDataGet& sxm_sms_weatherfi_tclMsgSurfaceDataGet::operator=(const sxm_sms_weatherfi_tclMsgSurfaceDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgSurfaceDataGet::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgSurfaceDataGet::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_SURFACEDATA;}
tU8 sxm_sms_weatherfi_tclMsgSurfaceDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxm_sms_weatherfi_tclMsgSurfaceDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgSurfaceDataGet::operator==(const sxm_sms_weatherfi_tclMsgSurfaceDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgSurfaceDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgSurfaceDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgSurfaceDataStatus::sxm_sms_weatherfi_tclMsgSurfaceDataStatus(const sxm_sms_weatherfi_tclMsgSurfaceDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgSurfaceDataStatus& sxm_sms_weatherfi_tclMsgSurfaceDataStatus::operator=(const sxm_sms_weatherfi_tclMsgSurfaceDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgSurfaceDataStatus::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgSurfaceDataStatus::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_SURFACEDATA;}
tU8 sxm_sms_weatherfi_tclMsgSurfaceDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxm_sms_weatherfi_tclMsgSurfaceDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxm_sms_weatherfi_tclMsgSurfaceDataStatus::operator==(const sxm_sms_weatherfi_tclMsgSurfaceDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgSurfaceDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgSurfaceDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg(const sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg& sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::operator=(const sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_STORMATTRIBUTESDATA;}
tU8 sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::operator==(const sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgStormAttributesDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg(const sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg& sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::operator=(const sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_STORMATTRIBUTESDATA;}
tU8 sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::operator==(const sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgStormAttributesDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormAttributesDataGet::sxm_sms_weatherfi_tclMsgStormAttributesDataGet(const sxm_sms_weatherfi_tclMsgStormAttributesDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormAttributesDataGet& sxm_sms_weatherfi_tclMsgStormAttributesDataGet::operator=(const sxm_sms_weatherfi_tclMsgStormAttributesDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgStormAttributesDataGet::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgStormAttributesDataGet::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_STORMATTRIBUTESDATA;}
tU8 sxm_sms_weatherfi_tclMsgStormAttributesDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxm_sms_weatherfi_tclMsgStormAttributesDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgStormAttributesDataGet::operator==(const sxm_sms_weatherfi_tclMsgStormAttributesDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgStormAttributesDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgStormAttributesDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::sxm_sms_weatherfi_tclMsgStormAttributesDataStatus(const sxm_sms_weatherfi_tclMsgStormAttributesDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormAttributesDataStatus& sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::operator=(const sxm_sms_weatherfi_tclMsgStormAttributesDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_STORMATTRIBUTESDATA;}
tU8 sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::operator==(const sxm_sms_weatherfi_tclMsgStormAttributesDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgStormAttributesDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::sxm_sms_weatherfi_tclMsgStormTrackDataUpReg(const sxm_sms_weatherfi_tclMsgStormTrackDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormTrackDataUpReg& sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::operator=(const sxm_sms_weatherfi_tclMsgStormTrackDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_STORMTRACKDATA;}
tU8 sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::operator==(const sxm_sms_weatherfi_tclMsgStormTrackDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgStormTrackDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg(const sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg& sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::operator=(const sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_STORMTRACKDATA;}
tU8 sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::operator==(const sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgStormTrackDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormTrackDataGet::sxm_sms_weatherfi_tclMsgStormTrackDataGet(const sxm_sms_weatherfi_tclMsgStormTrackDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormTrackDataGet& sxm_sms_weatherfi_tclMsgStormTrackDataGet::operator=(const sxm_sms_weatherfi_tclMsgStormTrackDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgStormTrackDataGet::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgStormTrackDataGet::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_STORMTRACKDATA;}
tU8 sxm_sms_weatherfi_tclMsgStormTrackDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxm_sms_weatherfi_tclMsgStormTrackDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxm_sms_weatherfi_tclMsgStormTrackDataGet::operator==(const sxm_sms_weatherfi_tclMsgStormTrackDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgStormTrackDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgStormTrackDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormTrackDataStatus::sxm_sms_weatherfi_tclMsgStormTrackDataStatus(const sxm_sms_weatherfi_tclMsgStormTrackDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxm_sms_weatherfi_tclMsgStormTrackDataStatus& sxm_sms_weatherfi_tclMsgStormTrackDataStatus::operator=(const sxm_sms_weatherfi_tclMsgStormTrackDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxm_sms_weatherfi_tclMsgStormTrackDataStatus::u16GetServiceID() const {return SXM_SMS_WEATHERFI_C_U16_SERVICE_ID;}
tU16 sxm_sms_weatherfi_tclMsgStormTrackDataStatus::u16GetFunctionID() const {return SXM_SMS_WEATHERFI_C_U16_STORMTRACKDATA;}
tU8 sxm_sms_weatherfi_tclMsgStormTrackDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxm_sms_weatherfi_tclMsgStormTrackDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxm_sms_weatherfi_tclMsgStormTrackDataStatus::operator==(const sxm_sms_weatherfi_tclMsgStormTrackDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& sxm_sms_weatherfi_tclMsgStormTrackDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& sxm_sms_weatherfi_tclMsgStormTrackDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

