#include "precompiled.hh"

tBool sxm_sms_weatherfi_tclDescription::bInitMessage(sxm_sms_weatherfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sxm_sms_weatherfi_tclToken::EN_LAST_TOKEN:
   case sxm_sms_weatherfi_tclToken::EN_LIST:
   case sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT:
   case sxm_sms_weatherfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sxm_sms_weatherfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAREDMEMORYDESCRIPTION,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_SHAREDMEMORIES));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAREDMEMORYDESCRIPTION,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_SHAREDMEMORIES));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPE,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_SHAPES));
      if (1 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPE,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_SHAPES));
      if (1 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPE,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_SHAPES));
      if (1 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_SXMTILETYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_TILETYPE));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAREDMEMORYTILE,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_TILELIST));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
      }
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_BOOL,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_ACCESSGRANTED));
      }
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_SXMTILETYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_TILETYPE));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_SXMTILETYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_TILETYPE));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER));
   } break;
   case sxm_sms_weatherfi_tclToken::EN_RESERVED:
   case sxm_sms_weatherfi_tclToken::EN_S32_FOOT:
   case sxm_sms_weatherfi_tclToken::EN_S32_MILLISECOND:
   case sxm_sms_weatherfi_tclToken::EN_POSIXTIME:
   case sxm_sms_weatherfi_tclToken::EN_S16_KNOT:
   case sxm_sms_weatherfi_tclToken::EN_S32_PASCAL:
   case sxm_sms_weatherfi_tclToken::EN_S32_LONGITUDE:
   case sxm_sms_weatherfi_tclToken::EN_S32_LATITUDE:
   case sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84:
   case sxm_sms_weatherfi_tclToken::EN_S16_DEGREE:
   case sxm_sms_weatherfi_tclToken::EN_BINCONTAINER:
   case sxm_sms_weatherfi_tclToken::EN_E8_SXMTILETYPE:
   case sxm_sms_weatherfi_tclToken::EN_E8_SXMSHAPETYPE:
   case sxm_sms_weatherfi_tclToken::EN_E8_SXMTILEDATATYPE:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAREDMEMORYDESCRIPTION:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAREDMEMORYTILE:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPE:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPEUNION0:
   case sxm_sms_weatherfi_tclToken::EN_E8_FRONTTYPE:
   case sxm_sms_weatherfi_tclToken::EN_E8_PRESSURETYPE:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEISOBAR:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEWINDRADIUS:
   case sxm_sms_weatherfi_tclToken::EN_E8_STORMPOSITIONTYPE:
   case sxm_sms_weatherfi_tclToken::EN_E8_STORMTYPE:
   case sxm_sms_weatherfi_tclToken::EN_B8_STORMTYPE:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMATTRIBUTES:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEFRONT:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEPRESSURECENTER:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMPOSITION:
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMTRACK:
   case sxm_sms_weatherfi_tclToken::EN_U8:   
   case sxm_sms_weatherfi_tclToken::EN_S8:   
   case sxm_sms_weatherfi_tclToken::EN_U16:   
   case sxm_sms_weatherfi_tclToken::EN_S16:   
   case sxm_sms_weatherfi_tclToken::EN_U24:   
   case sxm_sms_weatherfi_tclToken::EN_S24:   
   case sxm_sms_weatherfi_tclToken::EN_U32:   
   case sxm_sms_weatherfi_tclToken::EN_S32:   
   case sxm_sms_weatherfi_tclToken::EN_U64:   
   case sxm_sms_weatherfi_tclToken::EN_S64:   
   case sxm_sms_weatherfi_tclToken::EN_F32:   
   case sxm_sms_weatherfi_tclToken::EN_F64:   
   case sxm_sms_weatherfi_tclToken::EN_BOOL:   
   case sxm_sms_weatherfi_tclToken::EN_STRING:   
   case sxm_sms_weatherfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(sxm_sms_weatherfi_tclKnot(enMsgToken,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sxm_sms_weatherfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool sxm_sms_weatherfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sxm_sms_weatherfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sxm_sms_weatherfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sxm_sms_weatherfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(sxm_sms_weatherfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sxm_sms_weatherfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sxm_sms_weatherfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sxm_sms_weatherfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case sxm_sms_weatherfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sxm_sms_weatherfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxm_sms_weatherfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case sxm_sms_weatherfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
   case sxm_sms_weatherfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART:
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART:
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART:
   case sxm_sms_weatherfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
   case sxm_sms_weatherfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODSTART:
   case sxm_sms_weatherfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODRESULT:
   case sxm_sms_weatherfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODSTART:
   case sxm_sms_weatherfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODRESULT:
   case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATAUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATARELUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATAGET:
   case sxm_sms_weatherfi_tclToken::EN_MSG_NOWRADDATASTATUS:
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATAUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATARELUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATAGET:
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDMAGNITUDEDATASTATUS:
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATAUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATARELUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATAGET:
   case sxm_sms_weatherfi_tclToken::EN_MSG_WINDDIRECTIONDATASTATUS:
   case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATAUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATARELUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATAGET:
   case sxm_sms_weatherfi_tclToken::EN_MSG_SURFACEDATASTATUS:
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET:
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATAUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG:
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATAGET:
   case sxm_sms_weatherfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
      bInitMessage(enToken);
      break;
   case sxm_sms_weatherfi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_S32_FOOT:
   {
      fi_tcl_s32_Foot o_s32_Foot;
      if (!bDoIt(o_s32_Foot))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_S32_MILLISECOND:
   {
      fi_tcl_s32_MilliSecond o_s32_MilliSecond;
      if (!bDoIt(o_s32_MilliSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32,sxm_sms_weatherfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_S16_KNOT:
   {
      fi_tcl_s16_Knot o_s16_Knot;
      if (!bDoIt(o_s16_Knot))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_S32_PASCAL:
   {
      fi_tcl_s32_Pascal o_s32_Pascal;
      if (!bDoIt(o_s32_Pascal))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32_LATITUDE,sxm_sms_weatherfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32_LONGITUDE,sxm_sms_weatherfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_S16_DEGREE:
   {
      fi_tcl_s16_Degree o_s16_Degree;
      if (!bDoIt(o_s16_Degree))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U8,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_E8_SXMTILETYPE:
   {
      fi_tcl_e8_SXMTileType o_e8_SXMTileType;
      if (!bDoIt(o_e8_SXMTileType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_E8_SXMSHAPETYPE:
   {
      fi_tcl_e8_SXMShapeType o_e8_SXMShapeType;
      if (!bDoIt(o_e8_SXMShapeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_E8_SXMTILEDATATYPE:
   {
      fi_tcl_e8_SXMTileDataType o_e8_SXMTileDataType;
      if (!bDoIt(o_e8_SXMTileDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAREDMEMORYDESCRIPTION:
   {
      if (poVisitor->bDoExpand_SXMSharedMemoryDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32_MILLISECOND,sxm_sms_weatherfi_tclSemanticDomain::EN_TIMEOUT));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAREDMEMORYSIZE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_STRING,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAREDMEMORYNAME));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_SXMTILEDATATYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_TILEDATATYPE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_SXMTILETYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_TILETYPE));
      }
      else
      {
         fi_tcl_SXMSharedMemoryDescription o_SXMSharedMemoryDescription;
         if (!bDoIt(o_SXMSharedMemoryDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMSharedMemoryDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMSharedMemoryDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAREDMEMORYTILE:
   {
      if (poVisitor->bDoExpand_SXMSharedMemoryTile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_TILESIZE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_ADDRESSOFFSET));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32,sxm_sms_weatherfi_tclSemanticDomain::EN_PIXELVALUEPRECISION));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32,sxm_sms_weatherfi_tclSemanticDomain::EN_PIXELVALUEOFFSET));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_HEIGHT));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U32,sxm_sms_weatherfi_tclSemanticDomain::EN_WIDTH));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84,sxm_sms_weatherfi_tclSemanticDomain::EN_LOWERRIGHTCORNER));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84,sxm_sms_weatherfi_tclSemanticDomain::EN_UPPERLEFTCORNER));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         fi_tcl_SXMSharedMemoryTile o_SXMSharedMemoryTile;
         if (!bDoIt(o_SXMSharedMemoryTile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMSharedMemoryTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMSharedMemoryTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPEUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_SXMShapeType oDataType;
      oCallStack.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_SXMSHAPETYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMTRACK) &&
          !(2 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_SXMShapeType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEWINDRADIUS) &&
          !(u16MajorVersion <= 1))
      {
         oDataType.enType = fi_tcl_e8_SXMShapeType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMPOSITION) &&
          !(u16MajorVersion <= 1))
      {
         oDataType.enType = fi_tcl_e8_SXMShapeType::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_SXMShapeType::FI_EN_T_RESERVED:
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_RESERVED,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEFRONT:
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEFRONT,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEPRESSURECENTER:
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEPRESSURECENTER,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEISOBAR:
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEISOBAR,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMPOSITION:
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMPOSITION,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEWINDRADIUS:
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEWINDRADIUS,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMATTRIBUTES:
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMATTRIBUTES,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMTRACK:
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMTRACK,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPE:
   {
      if (poVisitor->bDoExpand_SXMShape(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPEUNION0,sxm_sms_weatherfi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         fi_tcl_SXMShape o_SXMShape;
         if (!bDoIt(o_SXMShape))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_E8_FRONTTYPE:
   {
      fi_tcl_e8_FrontType o_e8_FrontType;
      if (!bDoIt(o_e8_FrontType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_E8_PRESSURETYPE:
   {
      fi_tcl_e8_PressureType o_e8_PressureType;
      if (!bDoIt(o_e8_PressureType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEISOBAR:
   {
      if (poVisitor->bDoExpand_SXMShapeTypeIsobar(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_GEOPOINTS));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32_PASCAL,sxm_sms_weatherfi_tclSemanticDomain::EN_PRESSURE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         fi_tcl_SXMShapeTypeIsobar o_SXMShapeTypeIsobar;
         if (!bDoIt(o_SXMShapeTypeIsobar))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeIsobar.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeIsobar.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEWINDRADIUS:
   {
      if (poVisitor->bDoExpand_SXMShapeTypeWindRadius(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_GEOPOINTS));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S16_KNOT,sxm_sms_weatherfi_tclSemanticDomain::EN_WINDSPEED));
         if (u16MajorVersion <= 1)
         {
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U16,sxm_sms_weatherfi_tclSemanticDomain::EN_SEQUENCEID));
         }
         if (u16MajorVersion <= 1)
         {
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_STRING,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMUNIQUEID));
         }
         if (u16MajorVersion <= 1)
         {
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_ISSUETIME));
         }
      }
      else
      {
         fi_tcl_SXMShapeTypeWindRadius o_SXMShapeTypeWindRadius;
         if (!bDoIt(o_SXMShapeTypeWindRadius))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeWindRadius.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeWindRadius.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_E8_STORMPOSITIONTYPE:
   {
      fi_tcl_e8_StormPositionType o_e8_StormPositionType;
      if (!bDoIt(o_e8_StormPositionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_E8_STORMTYPE:
   {
      fi_tcl_e8_StormType o_e8_StormType;
      if (!bDoIt(o_e8_StormType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_B8_STORMTYPE:
   {
      fi_tcl_b8_StormType o_b8_StormType;
      if (!bDoIt(o_b8_StormType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMATTRIBUTES:
   {
      if (poVisitor->bDoExpand_SXMShapeTypeStormAttributes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84,sxm_sms_weatherfi_tclSemanticDomain::EN_GEOPOINT));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_B8_STORMTYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMTYPE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S16_KNOT,sxm_sms_weatherfi_tclSemanticDomain::EN_MOVEMENTSPEED));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S16_DEGREE,sxm_sms_weatherfi_tclSemanticDomain::EN_MOVEMENTDIRECTION));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32_FOOT,sxm_sms_weatherfi_tclSemanticDomain::EN_ECHOTOPHEIGHT));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_OBSERVATIONTIME));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_STRING,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMUNIQUEID));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         fi_tcl_SXMShapeTypeStormAttributes o_SXMShapeTypeStormAttributes;
         if (!bDoIt(o_SXMShapeTypeStormAttributes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEFRONT:
   {
      if (poVisitor->bDoExpand_SXMShapeTypeFront(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_GEOPOINTS));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_FRONTTYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_FRONTTYPE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         fi_tcl_SXMShapeTypeFront o_SXMShapeTypeFront;
         if (!bDoIt(o_SXMShapeTypeFront))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeFront.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeFront.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEPRESSURECENTER:
   {
      if (poVisitor->bDoExpand_SXMShapeTypePressureCenter(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84,sxm_sms_weatherfi_tclSemanticDomain::EN_GEOPOINT));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32_PASCAL,sxm_sms_weatherfi_tclSemanticDomain::EN_PRESSURE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_PRESSURETYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_PRESSURETYPE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         fi_tcl_SXMShapeTypePressureCenter o_SXMShapeTypePressureCenter;
         if (!bDoIt(o_SXMShapeTypePressureCenter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypePressureCenter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypePressureCenter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMPOSITION:
   {
      if (poVisitor->bDoExpand_SXMShapeTypeStormPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         if (2 <= u16MajorVersion)
         {
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPEWINDRADIUS,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_WINDRADII));
         }
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSITIONWGS84,sxm_sms_weatherfi_tclSemanticDomain::EN_GEOPOINT));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_STORMTYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMTYPE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_TIMESTAMP));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S32_PASCAL,sxm_sms_weatherfi_tclSemanticDomain::EN_PRESSURE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S16_KNOT,sxm_sms_weatherfi_tclSemanticDomain::EN_GUSTS));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S16_KNOT,sxm_sms_weatherfi_tclSemanticDomain::EN_MAXSUSTAINEDWINDS));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S16_KNOT,sxm_sms_weatherfi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_S16_DEGREE,sxm_sms_weatherfi_tclSemanticDomain::EN_DIRECTION));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_E8_STORMPOSITIONTYPE,sxm_sms_weatherfi_tclSemanticDomain::EN_POSITIONTYPE));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_U16,sxm_sms_weatherfi_tclSemanticDomain::EN_SEQUENCEID));
         if (u16MajorVersion <= 1)
         {
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_STRING,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMNAME));
         }
         if (u16MajorVersion <= 1)
         {
            oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_STRING,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMUNIQUEID));
         }
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_POSIXTIME,sxm_sms_weatherfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         fi_tcl_SXMShapeTypeStormPosition o_SXMShapeTypeStormPosition;
         if (!bDoIt(o_SXMShapeTypeStormPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMTRACK:
   {
      if (poVisitor->bDoExpand_SXMShapeTypeStormTrack(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_END_OF_STRUCT,sxm_sms_weatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_SXMSHAPETYPESTORMPOSITION,sxm_sms_weatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_LIST,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMPOSITIONS));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_STRING,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMNAME));
         oPath.bGoDown(sxm_sms_weatherfi_tclKnot(sxm_sms_weatherfi_tclToken::EN_STRING,sxm_sms_weatherfi_tclSemanticDomain::EN_STORMUNIQUEID));
      }
      else
      {
         fi_tcl_SXMShapeTypeStormTrack o_SXMShapeTypeStormTrack;
         if (!bDoIt(o_SXMShapeTypeStormTrack))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormTrack.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormTrack.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case sxm_sms_weatherfi_tclToken::EN_UNKNOWN:
      case sxm_sms_weatherfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

