/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodStart::statfi_tclMsgGetRecordedDataMethodStart(const statfi_tclMsgGetRecordedDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavRectangle = coRef.NavRectangle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodStart& statfi_tclMsgGetRecordedDataMethodStart::operator=(const statfi_tclMsgGetRecordedDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavRectangle = coRef.NavRectangle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetRecordedDataMethodStart::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetRecordedDataMethodStart::u16GetFunctionID() const {return STATFI_C_U16_GETRECORDEDDATA;}
tU8 statfi_tclMsgGetRecordedDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid statfi_tclMsgGetRecordedDataMethodStart::vDestroy()
{
   NavRectangle.vDestroy(); 
}

tU32 statfi_tclMsgGetRecordedDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool statfi_tclMsgGetRecordedDataMethodStart::operator==(const statfi_tclMsgGetRecordedDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavRectangle == rfoCmp.NavRectangle);
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetRecordedDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavRectangle;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetRecordedDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavRectangle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodResult::statfi_tclMsgGetRecordedDataMethodResult(const statfi_tclMsgGetRecordedDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodResult& statfi_tclMsgGetRecordedDataMethodResult::operator=(const statfi_tclMsgGetRecordedDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetRecordedDataMethodResult::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetRecordedDataMethodResult::u16GetFunctionID() const {return STATFI_C_U16_GETRECORDEDDATA;}
tU8 statfi_tclMsgGetRecordedDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid statfi_tclMsgGetRecordedDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         OnroadOffroadPositionList[u32Idx].vDestroy();
   }
   OnroadOffroadPositionList.clear();
}

tU32 statfi_tclMsgGetRecordedDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OnroadOffroadPositionList.size(); ++u32ListIdx)
      u32DynamicSize += OnroadOffroadPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool statfi_tclMsgGetRecordedDataMethodResult::operator==(const statfi_tclMsgGetRecordedDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OnroadOffroadPositionList.size() == rfoCmp.OnroadOffroadPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnroadOffroadPositionList.size()); ++u32Idx)
            bResult = bResult && (OnroadOffroadPositionList[u32Idx] == rfoCmp.OnroadOffroadPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetRecordedDataMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
      {
         OnroadOffroadPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnroadOffroadPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnroadOffroadPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetRecordedDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OnroadOffroadPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         oOut << OnroadOffroadPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodResultFirst::statfi_tclMsgGetRecordedDataMethodResultFirst(const statfi_tclMsgGetRecordedDataMethodResultFirst& coRef):fi_tclVisitableTypeBase(coRef)
{
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodResultFirst& statfi_tclMsgGetRecordedDataMethodResultFirst::operator=(const statfi_tclMsgGetRecordedDataMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetRecordedDataMethodResultFirst::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetRecordedDataMethodResultFirst::u16GetFunctionID() const {return STATFI_C_U16_GETRECORDEDDATA;}
tU8 statfi_tclMsgGetRecordedDataMethodResultFirst::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTFIRST;}

tVoid statfi_tclMsgGetRecordedDataMethodResultFirst::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         OnroadOffroadPositionList[u32Idx].vDestroy();
   }
   OnroadOffroadPositionList.clear();
}

tU32 statfi_tclMsgGetRecordedDataMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OnroadOffroadPositionList.size(); ++u32ListIdx)
      u32DynamicSize += OnroadOffroadPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool statfi_tclMsgGetRecordedDataMethodResultFirst::operator==(const statfi_tclMsgGetRecordedDataMethodResultFirst& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OnroadOffroadPositionList.size() == rfoCmp.OnroadOffroadPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnroadOffroadPositionList.size()); ++u32Idx)
            bResult = bResult && (OnroadOffroadPositionList[u32Idx] == rfoCmp.OnroadOffroadPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetRecordedDataMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
      {
         OnroadOffroadPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnroadOffroadPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnroadOffroadPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetRecordedDataMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OnroadOffroadPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         oOut << OnroadOffroadPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodResultMiddle::statfi_tclMsgGetRecordedDataMethodResultMiddle(const statfi_tclMsgGetRecordedDataMethodResultMiddle& coRef):fi_tclVisitableTypeBase(coRef)
{
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodResultMiddle& statfi_tclMsgGetRecordedDataMethodResultMiddle::operator=(const statfi_tclMsgGetRecordedDataMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetRecordedDataMethodResultMiddle::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetRecordedDataMethodResultMiddle::u16GetFunctionID() const {return STATFI_C_U16_GETRECORDEDDATA;}
tU8 statfi_tclMsgGetRecordedDataMethodResultMiddle::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTMIDDLE;}

tVoid statfi_tclMsgGetRecordedDataMethodResultMiddle::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         OnroadOffroadPositionList[u32Idx].vDestroy();
   }
   OnroadOffroadPositionList.clear();
}

tU32 statfi_tclMsgGetRecordedDataMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OnroadOffroadPositionList.size(); ++u32ListIdx)
      u32DynamicSize += OnroadOffroadPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool statfi_tclMsgGetRecordedDataMethodResultMiddle::operator==(const statfi_tclMsgGetRecordedDataMethodResultMiddle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OnroadOffroadPositionList.size() == rfoCmp.OnroadOffroadPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnroadOffroadPositionList.size()); ++u32Idx)
            bResult = bResult && (OnroadOffroadPositionList[u32Idx] == rfoCmp.OnroadOffroadPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetRecordedDataMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
      {
         OnroadOffroadPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnroadOffroadPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnroadOffroadPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetRecordedDataMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OnroadOffroadPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         oOut << OnroadOffroadPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodResultLast::statfi_tclMsgGetRecordedDataMethodResultLast(const statfi_tclMsgGetRecordedDataMethodResultLast& coRef):fi_tclVisitableTypeBase(coRef)
{
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetRecordedDataMethodResultLast& statfi_tclMsgGetRecordedDataMethodResultLast::operator=(const statfi_tclMsgGetRecordedDataMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetRecordedDataMethodResultLast::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetRecordedDataMethodResultLast::u16GetFunctionID() const {return STATFI_C_U16_GETRECORDEDDATA;}
tU8 statfi_tclMsgGetRecordedDataMethodResultLast::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTLAST;}

tVoid statfi_tclMsgGetRecordedDataMethodResultLast::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         OnroadOffroadPositionList[u32Idx].vDestroy();
   }
   OnroadOffroadPositionList.clear();
}

tU32 statfi_tclMsgGetRecordedDataMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OnroadOffroadPositionList.size(); ++u32ListIdx)
      u32DynamicSize += OnroadOffroadPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool statfi_tclMsgGetRecordedDataMethodResultLast::operator==(const statfi_tclMsgGetRecordedDataMethodResultLast& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OnroadOffroadPositionList.size() == rfoCmp.OnroadOffroadPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnroadOffroadPositionList.size()); ++u32Idx)
            bResult = bResult && (OnroadOffroadPositionList[u32Idx] == rfoCmp.OnroadOffroadPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetRecordedDataMethodResultLast::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
      {
         OnroadOffroadPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnroadOffroadPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnroadOffroadPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetRecordedDataMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OnroadOffroadPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         oOut << OnroadOffroadPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   RecordedBreadCrumbTypes = coRef.RecordedBreadCrumbTypes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart& statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::operator=(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RecordedBreadCrumbTypes = coRef.RecordedBreadCrumbTypes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::u16GetFunctionID() const {return STATFI_C_U16_SETRECORDINGMODEANDSTARTRECORDING;}
tU8 statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::operator==(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RecordedBreadCrumbTypes == rfoCmp.RecordedBreadCrumbTypes);
   return bResult;
}

fi_tclInContext& statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> RecordedBreadCrumbTypes;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RecordedBreadCrumbTypes;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RecordedBreadCrumbTypes = coRef.RecordedBreadCrumbTypes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult& statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::operator=(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RecordedBreadCrumbTypes = coRef.RecordedBreadCrumbTypes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::u16GetFunctionID() const {return STATFI_C_U16_SETRECORDINGMODEANDSTARTRECORDING;}
tU8 statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::operator==(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RecordedBreadCrumbTypes == rfoCmp.RecordedBreadCrumbTypes);
   return bResult;
}

fi_tclInContext& statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> RecordedBreadCrumbTypes;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RecordedBreadCrumbTypes;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgDeleteAllBreadCrumbsMethodStart::statfi_tclMsgDeleteAllBreadCrumbsMethodStart(const statfi_tclMsgDeleteAllBreadCrumbsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgDeleteAllBreadCrumbsMethodStart& statfi_tclMsgDeleteAllBreadCrumbsMethodStart::operator=(const statfi_tclMsgDeleteAllBreadCrumbsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgDeleteAllBreadCrumbsMethodStart::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgDeleteAllBreadCrumbsMethodStart::u16GetFunctionID() const {return STATFI_C_U16_DELETEALLBREADCRUMBS;}
tU8 statfi_tclMsgDeleteAllBreadCrumbsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 statfi_tclMsgDeleteAllBreadCrumbsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgDeleteAllBreadCrumbsMethodStart::operator==(const statfi_tclMsgDeleteAllBreadCrumbsMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgDeleteAllBreadCrumbsMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgDeleteAllBreadCrumbsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgDeleteAllBreadCrumbsMethodResult::statfi_tclMsgDeleteAllBreadCrumbsMethodResult(const statfi_tclMsgDeleteAllBreadCrumbsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgDeleteAllBreadCrumbsMethodResult& statfi_tclMsgDeleteAllBreadCrumbsMethodResult::operator=(const statfi_tclMsgDeleteAllBreadCrumbsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgDeleteAllBreadCrumbsMethodResult::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgDeleteAllBreadCrumbsMethodResult::u16GetFunctionID() const {return STATFI_C_U16_DELETEALLBREADCRUMBS;}
tU8 statfi_tclMsgDeleteAllBreadCrumbsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 statfi_tclMsgDeleteAllBreadCrumbsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgDeleteAllBreadCrumbsMethodResult::operator==(const statfi_tclMsgDeleteAllBreadCrumbsMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgDeleteAllBreadCrumbsMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgDeleteAllBreadCrumbsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodStart::statfi_tclMsgGetDrivenRouteDataMethodStart(const statfi_tclMsgGetDrivenRouteDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavRectangle = coRef.NavRectangle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodStart& statfi_tclMsgGetDrivenRouteDataMethodStart::operator=(const statfi_tclMsgGetDrivenRouteDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavRectangle = coRef.NavRectangle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetDrivenRouteDataMethodStart::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetDrivenRouteDataMethodStart::u16GetFunctionID() const {return STATFI_C_U16_GETDRIVENROUTEDATA;}
tU8 statfi_tclMsgGetDrivenRouteDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid statfi_tclMsgGetDrivenRouteDataMethodStart::vDestroy()
{
   NavRectangle.vDestroy(); 
}

tU32 statfi_tclMsgGetDrivenRouteDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool statfi_tclMsgGetDrivenRouteDataMethodStart::operator==(const statfi_tclMsgGetDrivenRouteDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavRectangle == rfoCmp.NavRectangle);
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetDrivenRouteDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavRectangle;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetDrivenRouteDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavRectangle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodResult::statfi_tclMsgGetDrivenRouteDataMethodResult(const statfi_tclMsgGetDrivenRouteDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodResult& statfi_tclMsgGetDrivenRouteDataMethodResult::operator=(const statfi_tclMsgGetDrivenRouteDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetDrivenRouteDataMethodResult::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetDrivenRouteDataMethodResult::u16GetFunctionID() const {return STATFI_C_U16_GETDRIVENROUTEDATA;}
tU8 statfi_tclMsgGetDrivenRouteDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid statfi_tclMsgGetDrivenRouteDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         OnroadOffroadPositionList[u32Idx].vDestroy();
   }
   OnroadOffroadPositionList.clear();
}

tU32 statfi_tclMsgGetDrivenRouteDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OnroadOffroadPositionList.size(); ++u32ListIdx)
      u32DynamicSize += OnroadOffroadPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool statfi_tclMsgGetDrivenRouteDataMethodResult::operator==(const statfi_tclMsgGetDrivenRouteDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OnroadOffroadPositionList.size() == rfoCmp.OnroadOffroadPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnroadOffroadPositionList.size()); ++u32Idx)
            bResult = bResult && (OnroadOffroadPositionList[u32Idx] == rfoCmp.OnroadOffroadPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetDrivenRouteDataMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
      {
         OnroadOffroadPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnroadOffroadPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnroadOffroadPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetDrivenRouteDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OnroadOffroadPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         oOut << OnroadOffroadPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodResultFirst::statfi_tclMsgGetDrivenRouteDataMethodResultFirst(const statfi_tclMsgGetDrivenRouteDataMethodResultFirst& coRef):fi_tclVisitableTypeBase(coRef)
{
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodResultFirst& statfi_tclMsgGetDrivenRouteDataMethodResultFirst::operator=(const statfi_tclMsgGetDrivenRouteDataMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetDrivenRouteDataMethodResultFirst::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetDrivenRouteDataMethodResultFirst::u16GetFunctionID() const {return STATFI_C_U16_GETDRIVENROUTEDATA;}
tU8 statfi_tclMsgGetDrivenRouteDataMethodResultFirst::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTFIRST;}

tVoid statfi_tclMsgGetDrivenRouteDataMethodResultFirst::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         OnroadOffroadPositionList[u32Idx].vDestroy();
   }
   OnroadOffroadPositionList.clear();
}

tU32 statfi_tclMsgGetDrivenRouteDataMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OnroadOffroadPositionList.size(); ++u32ListIdx)
      u32DynamicSize += OnroadOffroadPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool statfi_tclMsgGetDrivenRouteDataMethodResultFirst::operator==(const statfi_tclMsgGetDrivenRouteDataMethodResultFirst& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OnroadOffroadPositionList.size() == rfoCmp.OnroadOffroadPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnroadOffroadPositionList.size()); ++u32Idx)
            bResult = bResult && (OnroadOffroadPositionList[u32Idx] == rfoCmp.OnroadOffroadPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetDrivenRouteDataMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
      {
         OnroadOffroadPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnroadOffroadPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnroadOffroadPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetDrivenRouteDataMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OnroadOffroadPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         oOut << OnroadOffroadPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::statfi_tclMsgGetDrivenRouteDataMethodResultMiddle(const statfi_tclMsgGetDrivenRouteDataMethodResultMiddle& coRef):fi_tclVisitableTypeBase(coRef)
{
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodResultMiddle& statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::operator=(const statfi_tclMsgGetDrivenRouteDataMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::u16GetFunctionID() const {return STATFI_C_U16_GETDRIVENROUTEDATA;}
tU8 statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTMIDDLE;}

tVoid statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         OnroadOffroadPositionList[u32Idx].vDestroy();
   }
   OnroadOffroadPositionList.clear();
}

tU32 statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OnroadOffroadPositionList.size(); ++u32ListIdx)
      u32DynamicSize += OnroadOffroadPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::operator==(const statfi_tclMsgGetDrivenRouteDataMethodResultMiddle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OnroadOffroadPositionList.size() == rfoCmp.OnroadOffroadPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnroadOffroadPositionList.size()); ++u32Idx)
            bResult = bResult && (OnroadOffroadPositionList[u32Idx] == rfoCmp.OnroadOffroadPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
      {
         OnroadOffroadPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnroadOffroadPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnroadOffroadPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetDrivenRouteDataMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OnroadOffroadPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         oOut << OnroadOffroadPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodResultLast::statfi_tclMsgGetDrivenRouteDataMethodResultLast(const statfi_tclMsgGetDrivenRouteDataMethodResultLast& coRef):fi_tclVisitableTypeBase(coRef)
{
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetDrivenRouteDataMethodResultLast& statfi_tclMsgGetDrivenRouteDataMethodResultLast::operator=(const statfi_tclMsgGetDrivenRouteDataMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   OnroadOffroadPositionList = coRef.OnroadOffroadPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetDrivenRouteDataMethodResultLast::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetDrivenRouteDataMethodResultLast::u16GetFunctionID() const {return STATFI_C_U16_GETDRIVENROUTEDATA;}
tU8 statfi_tclMsgGetDrivenRouteDataMethodResultLast::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTLAST;}

tVoid statfi_tclMsgGetDrivenRouteDataMethodResultLast::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         OnroadOffroadPositionList[u32Idx].vDestroy();
   }
   OnroadOffroadPositionList.clear();
}

tU32 statfi_tclMsgGetDrivenRouteDataMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OnroadOffroadPositionList.size(); ++u32ListIdx)
      u32DynamicSize += OnroadOffroadPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool statfi_tclMsgGetDrivenRouteDataMethodResultLast::operator==(const statfi_tclMsgGetDrivenRouteDataMethodResultLast& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OnroadOffroadPositionList.size() == rfoCmp.OnroadOffroadPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnroadOffroadPositionList.size()); ++u32Idx)
            bResult = bResult && (OnroadOffroadPositionList[u32Idx] == rfoCmp.OnroadOffroadPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetDrivenRouteDataMethodResultLast::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
      {
         OnroadOffroadPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnroadOffroadPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnroadOffroadPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetDrivenRouteDataMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OnroadOffroadPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnroadOffroadPositionList.size(); ++u32Idx)
         oOut << OnroadOffroadPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetProfileDataMethodStart::statfi_tclMsgGetProfileDataMethodStart(const statfi_tclMsgGetProfileDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   CountryTimeList = coRef.CountryTimeList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetProfileDataMethodStart& statfi_tclMsgGetProfileDataMethodStart::operator=(const statfi_tclMsgGetProfileDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   CountryTimeList = coRef.CountryTimeList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetProfileDataMethodStart::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetProfileDataMethodStart::u16GetFunctionID() const {return STATFI_C_U16_GETPROFILEDATA;}
tU8 statfi_tclMsgGetProfileDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid statfi_tclMsgGetProfileDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountryTimeList.size(); ++u32Idx)
         CountryTimeList[u32Idx].vDestroy();
   }
   CountryTimeList.clear();
}

tU32 statfi_tclMsgGetProfileDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+CountryTimeList.size()*10;
}

tBool statfi_tclMsgGetProfileDataMethodStart::operator==(const statfi_tclMsgGetProfileDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (CountryTimeList.size() == rfoCmp.CountryTimeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryTimeList.size()); ++u32Idx)
            bResult = bResult && (CountryTimeList[u32Idx] == rfoCmp.CountryTimeList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetProfileDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryTimeList.size(); ++u32Idx)
      {
         CountryTimeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CountryTimeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountryTimeList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetProfileDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << (tU32)CountryTimeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountryTimeList.size(); ++u32Idx)
         oOut << CountryTimeList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetProfileDataMethodResult::statfi_tclMsgGetProfileDataMethodResult(const statfi_tclMsgGetProfileDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   ProfileDataList = coRef.ProfileDataList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgGetProfileDataMethodResult& statfi_tclMsgGetProfileDataMethodResult::operator=(const statfi_tclMsgGetProfileDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   ProfileDataList = coRef.ProfileDataList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgGetProfileDataMethodResult::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgGetProfileDataMethodResult::u16GetFunctionID() const {return STATFI_C_U16_GETPROFILEDATA;}
tU8 statfi_tclMsgGetProfileDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid statfi_tclMsgGetProfileDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ProfileDataList.size(); ++u32Idx)
         ProfileDataList[u32Idx].vDestroy();
   }
   ProfileDataList.clear();
}

tU32 statfi_tclMsgGetProfileDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ProfileDataList.size(); ++u32ListIdx)
      u32DynamicSize += ProfileDataList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool statfi_tclMsgGetProfileDataMethodResult::operator==(const statfi_tclMsgGetProfileDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (ProfileDataList.size() == rfoCmp.ProfileDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ProfileDataList.size()); ++u32Idx)
            bResult = bResult && (ProfileDataList[u32Idx] == rfoCmp.ProfileDataList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& statfi_tclMsgGetProfileDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ProfileDataList.size(); ++u32Idx)
      {
         ProfileDataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ProfileDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ProfileDataList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& statfi_tclMsgGetProfileDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << (tU32)ProfileDataList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ProfileDataList.size(); ++u32Idx)
         oOut << ProfileDataList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgCurrentPositionGet::statfi_tclMsgCurrentPositionGet(const statfi_tclMsgCurrentPositionGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgCurrentPositionGet& statfi_tclMsgCurrentPositionGet::operator=(const statfi_tclMsgCurrentPositionGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgCurrentPositionGet::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgCurrentPositionGet::u16GetFunctionID() const {return STATFI_C_U16_CURRENTPOSITION;}
tU8 statfi_tclMsgCurrentPositionGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 statfi_tclMsgCurrentPositionGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgCurrentPositionGet::operator==(const statfi_tclMsgCurrentPositionGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgCurrentPositionGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgCurrentPositionGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgCurrentPositionUpReg::statfi_tclMsgCurrentPositionUpReg(const statfi_tclMsgCurrentPositionUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgCurrentPositionUpReg& statfi_tclMsgCurrentPositionUpReg::operator=(const statfi_tclMsgCurrentPositionUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgCurrentPositionUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgCurrentPositionUpReg::u16GetFunctionID() const {return STATFI_C_U16_CURRENTPOSITION;}
tU8 statfi_tclMsgCurrentPositionUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 statfi_tclMsgCurrentPositionUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgCurrentPositionUpReg::operator==(const statfi_tclMsgCurrentPositionUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgCurrentPositionUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgCurrentPositionUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgCurrentPositionRelUpReg::statfi_tclMsgCurrentPositionRelUpReg(const statfi_tclMsgCurrentPositionRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgCurrentPositionRelUpReg& statfi_tclMsgCurrentPositionRelUpReg::operator=(const statfi_tclMsgCurrentPositionRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgCurrentPositionRelUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgCurrentPositionRelUpReg::u16GetFunctionID() const {return STATFI_C_U16_CURRENTPOSITION;}
tU8 statfi_tclMsgCurrentPositionRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 statfi_tclMsgCurrentPositionRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgCurrentPositionRelUpReg::operator==(const statfi_tclMsgCurrentPositionRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgCurrentPositionRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgCurrentPositionRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgCurrentPositionStatus::statfi_tclMsgCurrentPositionStatus(const statfi_tclMsgCurrentPositionStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentPosition = coRef.CurrentPosition;
   bPositionIsOnroad = coRef.bPositionIsOnroad;
   b8StatusInfoBits = coRef.b8StatusInfoBits;
   bConnectedToPreviousPoint = coRef.bConnectedToPreviousPoint;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgCurrentPositionStatus& statfi_tclMsgCurrentPositionStatus::operator=(const statfi_tclMsgCurrentPositionStatus& coRef)
{
   if (this == &coRef) return *this;
   CurrentPosition = coRef.CurrentPosition;
   bPositionIsOnroad = coRef.bPositionIsOnroad;
   b8StatusInfoBits = coRef.b8StatusInfoBits;
   bConnectedToPreviousPoint = coRef.bConnectedToPreviousPoint;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgCurrentPositionStatus::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgCurrentPositionStatus::u16GetFunctionID() const {return STATFI_C_U16_CURRENTPOSITION;}
tU8 statfi_tclMsgCurrentPositionStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid statfi_tclMsgCurrentPositionStatus::vDestroy()
{
   CurrentPosition.vDestroy(); 
}

tU32 statfi_tclMsgCurrentPositionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 13)
   {
      u32DynamicSize += 1;
   }
   if (14 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+9;
}

tBool statfi_tclMsgCurrentPositionStatus::operator==(const statfi_tclMsgCurrentPositionStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentPosition == rfoCmp.CurrentPosition);
      bResult = bResult && (bPositionIsOnroad == rfoCmp.bPositionIsOnroad);
      bResult = bResult && (b8StatusInfoBits == rfoCmp.b8StatusInfoBits);
      bResult = bResult && (bConnectedToPreviousPoint == rfoCmp.bConnectedToPreviousPoint);
   return bResult;
}

fi_tclInContext& statfi_tclMsgCurrentPositionStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> CurrentPosition;
   if (oIn.u16GetMajorVersion() <= 13)
   {
      oIn >> bPositionIsOnroad;
   }
   if (14 <= oIn.u16GetMajorVersion())
   {
      oIn >> b8StatusInfoBits;
   }
   oIn >> bConnectedToPreviousPoint;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgCurrentPositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CurrentPosition;
   if (oOut.u16GetMajorVersion() <= 13)
   {
      oOut << bPositionIsOnroad;
   }
   if (14 <= oOut.u16GetMajorVersion())
   {
      oOut << b8StatusInfoBits;
   }
   oOut << bConnectedToPreviousPoint;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgRecordingStatusGet::statfi_tclMsgRecordingStatusGet(const statfi_tclMsgRecordingStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgRecordingStatusGet& statfi_tclMsgRecordingStatusGet::operator=(const statfi_tclMsgRecordingStatusGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgRecordingStatusGet::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgRecordingStatusGet::u16GetFunctionID() const {return STATFI_C_U16_RECORDINGSTATUS;}
tU8 statfi_tclMsgRecordingStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 statfi_tclMsgRecordingStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgRecordingStatusGet::operator==(const statfi_tclMsgRecordingStatusGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgRecordingStatusGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgRecordingStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgRecordingStatusUpReg::statfi_tclMsgRecordingStatusUpReg(const statfi_tclMsgRecordingStatusUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgRecordingStatusUpReg& statfi_tclMsgRecordingStatusUpReg::operator=(const statfi_tclMsgRecordingStatusUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgRecordingStatusUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgRecordingStatusUpReg::u16GetFunctionID() const {return STATFI_C_U16_RECORDINGSTATUS;}
tU8 statfi_tclMsgRecordingStatusUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 statfi_tclMsgRecordingStatusUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgRecordingStatusUpReg::operator==(const statfi_tclMsgRecordingStatusUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgRecordingStatusUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgRecordingStatusUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgRecordingStatusRelUpReg::statfi_tclMsgRecordingStatusRelUpReg(const statfi_tclMsgRecordingStatusRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgRecordingStatusRelUpReg& statfi_tclMsgRecordingStatusRelUpReg::operator=(const statfi_tclMsgRecordingStatusRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgRecordingStatusRelUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgRecordingStatusRelUpReg::u16GetFunctionID() const {return STATFI_C_U16_RECORDINGSTATUS;}
tU8 statfi_tclMsgRecordingStatusRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 statfi_tclMsgRecordingStatusRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgRecordingStatusRelUpReg::operator==(const statfi_tclMsgRecordingStatusRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgRecordingStatusRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgRecordingStatusRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgRecordingStatusStatus::statfi_tclMsgRecordingStatusStatus(const statfi_tclMsgRecordingStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   RecordedBreadCrumbTypes = coRef.RecordedBreadCrumbTypes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgRecordingStatusStatus& statfi_tclMsgRecordingStatusStatus::operator=(const statfi_tclMsgRecordingStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   RecordedBreadCrumbTypes = coRef.RecordedBreadCrumbTypes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgRecordingStatusStatus::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgRecordingStatusStatus::u16GetFunctionID() const {return STATFI_C_U16_RECORDINGSTATUS;}
tU8 statfi_tclMsgRecordingStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 statfi_tclMsgRecordingStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool statfi_tclMsgRecordingStatusStatus::operator==(const statfi_tclMsgRecordingStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RecordedBreadCrumbTypes == rfoCmp.RecordedBreadCrumbTypes);
   return bResult;
}

fi_tclInContext& statfi_tclMsgRecordingStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> RecordedBreadCrumbTypes;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgRecordingStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RecordedBreadCrumbTypes;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofFreeBreadCrumbsGet::statfi_tclMsgNbofFreeBreadCrumbsGet(const statfi_tclMsgNbofFreeBreadCrumbsGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofFreeBreadCrumbsGet& statfi_tclMsgNbofFreeBreadCrumbsGet::operator=(const statfi_tclMsgNbofFreeBreadCrumbsGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgNbofFreeBreadCrumbsGet::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgNbofFreeBreadCrumbsGet::u16GetFunctionID() const {return STATFI_C_U16_NBOFFREEBREADCRUMBS;}
tU8 statfi_tclMsgNbofFreeBreadCrumbsGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 statfi_tclMsgNbofFreeBreadCrumbsGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgNbofFreeBreadCrumbsGet::operator==(const statfi_tclMsgNbofFreeBreadCrumbsGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgNbofFreeBreadCrumbsGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgNbofFreeBreadCrumbsGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofFreeBreadCrumbsUpReg::statfi_tclMsgNbofFreeBreadCrumbsUpReg(const statfi_tclMsgNbofFreeBreadCrumbsUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofFreeBreadCrumbsUpReg& statfi_tclMsgNbofFreeBreadCrumbsUpReg::operator=(const statfi_tclMsgNbofFreeBreadCrumbsUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgNbofFreeBreadCrumbsUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgNbofFreeBreadCrumbsUpReg::u16GetFunctionID() const {return STATFI_C_U16_NBOFFREEBREADCRUMBS;}
tU8 statfi_tclMsgNbofFreeBreadCrumbsUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 statfi_tclMsgNbofFreeBreadCrumbsUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgNbofFreeBreadCrumbsUpReg::operator==(const statfi_tclMsgNbofFreeBreadCrumbsUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgNbofFreeBreadCrumbsUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgNbofFreeBreadCrumbsUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::statfi_tclMsgNbofFreeBreadCrumbsRelUpReg(const statfi_tclMsgNbofFreeBreadCrumbsRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofFreeBreadCrumbsRelUpReg& statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::operator=(const statfi_tclMsgNbofFreeBreadCrumbsRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::u16GetFunctionID() const {return STATFI_C_U16_NBOFFREEBREADCRUMBS;}
tU8 statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::operator==(const statfi_tclMsgNbofFreeBreadCrumbsRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgNbofFreeBreadCrumbsRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofFreeBreadCrumbsStatus::statfi_tclMsgNbofFreeBreadCrumbsStatus(const statfi_tclMsgNbofFreeBreadCrumbsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   NbofFreeBreadCrumbs = coRef.NbofFreeBreadCrumbs;
   RecordableDistance = coRef.RecordableDistance;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofFreeBreadCrumbsStatus& statfi_tclMsgNbofFreeBreadCrumbsStatus::operator=(const statfi_tclMsgNbofFreeBreadCrumbsStatus& coRef)
{
   if (this == &coRef) return *this;
   NbofFreeBreadCrumbs = coRef.NbofFreeBreadCrumbs;
   RecordableDistance = coRef.RecordableDistance;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgNbofFreeBreadCrumbsStatus::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgNbofFreeBreadCrumbsStatus::u16GetFunctionID() const {return STATFI_C_U16_NBOFFREEBREADCRUMBS;}
tU8 statfi_tclMsgNbofFreeBreadCrumbsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 statfi_tclMsgNbofFreeBreadCrumbsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool statfi_tclMsgNbofFreeBreadCrumbsStatus::operator==(const statfi_tclMsgNbofFreeBreadCrumbsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NbofFreeBreadCrumbs == rfoCmp.NbofFreeBreadCrumbs);
      bResult = bResult && (RecordableDistance == rfoCmp.RecordableDistance);
   return bResult;
}

fi_tclInContext& statfi_tclMsgNbofFreeBreadCrumbsStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> NbofFreeBreadCrumbs;
   oIn >> RecordableDistance;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgNbofFreeBreadCrumbsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NbofFreeBreadCrumbs;
   oOut << RecordableDistance;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofWrongCurrentPositionsUpReg::statfi_tclMsgNbofWrongCurrentPositionsUpReg(const statfi_tclMsgNbofWrongCurrentPositionsUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofWrongCurrentPositionsUpReg& statfi_tclMsgNbofWrongCurrentPositionsUpReg::operator=(const statfi_tclMsgNbofWrongCurrentPositionsUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgNbofWrongCurrentPositionsUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgNbofWrongCurrentPositionsUpReg::u16GetFunctionID() const {return STATFI_C_U16_NBOFWRONGCURRENTPOSITIONS;}
tU8 statfi_tclMsgNbofWrongCurrentPositionsUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 statfi_tclMsgNbofWrongCurrentPositionsUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgNbofWrongCurrentPositionsUpReg::operator==(const statfi_tclMsgNbofWrongCurrentPositionsUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgNbofWrongCurrentPositionsUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgNbofWrongCurrentPositionsUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::statfi_tclMsgNbofWrongCurrentPositionsRelUpReg(const statfi_tclMsgNbofWrongCurrentPositionsRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofWrongCurrentPositionsRelUpReg& statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::operator=(const statfi_tclMsgNbofWrongCurrentPositionsRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::u16GetFunctionID() const {return STATFI_C_U16_NBOFWRONGCURRENTPOSITIONS;}
tU8 statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::operator==(const statfi_tclMsgNbofWrongCurrentPositionsRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgNbofWrongCurrentPositionsRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofWrongCurrentPositionsStatus::statfi_tclMsgNbofWrongCurrentPositionsStatus(const statfi_tclMsgNbofWrongCurrentPositionsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   NbofPositionsToDelete = coRef.NbofPositionsToDelete;
   CorrectedPositions = coRef.CorrectedPositions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgNbofWrongCurrentPositionsStatus& statfi_tclMsgNbofWrongCurrentPositionsStatus::operator=(const statfi_tclMsgNbofWrongCurrentPositionsStatus& coRef)
{
   if (this == &coRef) return *this;
   NbofPositionsToDelete = coRef.NbofPositionsToDelete;
   CorrectedPositions = coRef.CorrectedPositions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgNbofWrongCurrentPositionsStatus::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgNbofWrongCurrentPositionsStatus::u16GetFunctionID() const {return STATFI_C_U16_NBOFWRONGCURRENTPOSITIONS;}
tU8 statfi_tclMsgNbofWrongCurrentPositionsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid statfi_tclMsgNbofWrongCurrentPositionsStatus::vDestroy()
{
   CorrectedPositions.vDestroy(); 
}

tU32 statfi_tclMsgNbofWrongCurrentPositionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+CorrectedPositions.u32GetSize(u16MajorVersion);
}

tBool statfi_tclMsgNbofWrongCurrentPositionsStatus::operator==(const statfi_tclMsgNbofWrongCurrentPositionsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NbofPositionsToDelete == rfoCmp.NbofPositionsToDelete);
      bResult = bResult && (CorrectedPositions == rfoCmp.CorrectedPositions);
   return bResult;
}

fi_tclInContext& statfi_tclMsgNbofWrongCurrentPositionsStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> NbofPositionsToDelete;
   oIn >> CorrectedPositions;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgNbofWrongCurrentPositionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NbofPositionsToDelete;
   oOut << CorrectedPositions;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgProfileDataAvailableUpReg::statfi_tclMsgProfileDataAvailableUpReg(const statfi_tclMsgProfileDataAvailableUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgProfileDataAvailableUpReg& statfi_tclMsgProfileDataAvailableUpReg::operator=(const statfi_tclMsgProfileDataAvailableUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgProfileDataAvailableUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgProfileDataAvailableUpReg::u16GetFunctionID() const {return STATFI_C_U16_PROFILEDATAAVAILABLE;}
tU8 statfi_tclMsgProfileDataAvailableUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 statfi_tclMsgProfileDataAvailableUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgProfileDataAvailableUpReg::operator==(const statfi_tclMsgProfileDataAvailableUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgProfileDataAvailableUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgProfileDataAvailableUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgProfileDataAvailableRelUpReg::statfi_tclMsgProfileDataAvailableRelUpReg(const statfi_tclMsgProfileDataAvailableRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgProfileDataAvailableRelUpReg& statfi_tclMsgProfileDataAvailableRelUpReg::operator=(const statfi_tclMsgProfileDataAvailableRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgProfileDataAvailableRelUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgProfileDataAvailableRelUpReg::u16GetFunctionID() const {return STATFI_C_U16_PROFILEDATAAVAILABLE;}
tU8 statfi_tclMsgProfileDataAvailableRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 statfi_tclMsgProfileDataAvailableRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgProfileDataAvailableRelUpReg::operator==(const statfi_tclMsgProfileDataAvailableRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgProfileDataAvailableRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgProfileDataAvailableRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgProfileDataAvailableStatus::statfi_tclMsgProfileDataAvailableStatus(const statfi_tclMsgProfileDataAvailableStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   AvailableProfileData = coRef.AvailableProfileData;
   NavDataSetID = coRef.NavDataSetID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgProfileDataAvailableStatus& statfi_tclMsgProfileDataAvailableStatus::operator=(const statfi_tclMsgProfileDataAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailableProfileData = coRef.AvailableProfileData;
   NavDataSetID = coRef.NavDataSetID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgProfileDataAvailableStatus::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgProfileDataAvailableStatus::u16GetFunctionID() const {return STATFI_C_U16_PROFILEDATAAVAILABLE;}
tU8 statfi_tclMsgProfileDataAvailableStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 statfi_tclMsgProfileDataAvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool statfi_tclMsgProfileDataAvailableStatus::operator==(const statfi_tclMsgProfileDataAvailableStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableProfileData == rfoCmp.AvailableProfileData);
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
   return bResult;
}

fi_tclInContext& statfi_tclMsgProfileDataAvailableStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> AvailableProfileData;
   oIn >> NavDataSetID;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgProfileDataAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AvailableProfileData;
   oOut << NavDataSetID;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgEngineeringTextGet::statfi_tclMsgEngineeringTextGet(const statfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgEngineeringTextGet& statfi_tclMsgEngineeringTextGet::operator=(const statfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return STATFI_C_U16_ENGINEERINGTEXT;}
tU8 statfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 statfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgEngineeringTextGet::operator==(const statfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgEngineeringTextUpReg::statfi_tclMsgEngineeringTextUpReg(const statfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgEngineeringTextUpReg& statfi_tclMsgEngineeringTextUpReg::operator=(const statfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return STATFI_C_U16_ENGINEERINGTEXT;}
tU8 statfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 statfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgEngineeringTextUpReg::operator==(const statfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgEngineeringTextRelUpReg::statfi_tclMsgEngineeringTextRelUpReg(const statfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgEngineeringTextRelUpReg& statfi_tclMsgEngineeringTextRelUpReg::operator=(const statfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return STATFI_C_U16_ENGINEERINGTEXT;}
tU8 statfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 statfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool statfi_tclMsgEngineeringTextRelUpReg::operator==(const statfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& statfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& statfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgEngineeringTextStatus::statfi_tclMsgEngineeringTextStatus(const statfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
statfi_tclMsgEngineeringTextStatus& statfi_tclMsgEngineeringTextStatus::operator=(const statfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 statfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return STATFI_C_U16_SERVICE_ID;}
tU16 statfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return STATFI_C_U16_ENGINEERINGTEXT;}
tU8 statfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid statfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 statfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool statfi_tclMsgEngineeringTextStatus::operator==(const statfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& statfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& statfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

