/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgConnectTaskMethodStart::rtffi_tclMsgConnectTaskMethodStart(const rtffi_tclMsgConnectTaskMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ThreadID = coRef.ThreadID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgConnectTaskMethodStart& rtffi_tclMsgConnectTaskMethodStart::operator=(const rtffi_tclMsgConnectTaskMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ThreadID = coRef.ThreadID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgConnectTaskMethodStart::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgConnectTaskMethodStart::u16GetFunctionID() const {return RTFFI_C_U16_CONNECTTASK;}
tU8 rtffi_tclMsgConnectTaskMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rtffi_tclMsgConnectTaskMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rtffi_tclMsgConnectTaskMethodStart::operator==(const rtffi_tclMsgConnectTaskMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ThreadID == rfoCmp.ThreadID);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgConnectTaskMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ThreadID;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgConnectTaskMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ThreadID;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgConnectTaskMethodResult::rtffi_tclMsgConnectTaskMethodResult(const rtffi_tclMsgConnectTaskMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   StateManagerHandle = coRef.StateManagerHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgConnectTaskMethodResult& rtffi_tclMsgConnectTaskMethodResult::operator=(const rtffi_tclMsgConnectTaskMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StateManagerHandle = coRef.StateManagerHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgConnectTaskMethodResult::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgConnectTaskMethodResult::u16GetFunctionID() const {return RTFFI_C_U16_CONNECTTASK;}
tU8 rtffi_tclMsgConnectTaskMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rtffi_tclMsgConnectTaskMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rtffi_tclMsgConnectTaskMethodResult::operator==(const rtffi_tclMsgConnectTaskMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StateManagerHandle == rfoCmp.StateManagerHandle);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgConnectTaskMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> StateManagerHandle;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgConnectTaskMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StateManagerHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgDisconnectTaskMethodStart::rtffi_tclMsgDisconnectTaskMethodStart(const rtffi_tclMsgDisconnectTaskMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   StateManagerHandle = coRef.StateManagerHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgDisconnectTaskMethodStart& rtffi_tclMsgDisconnectTaskMethodStart::operator=(const rtffi_tclMsgDisconnectTaskMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StateManagerHandle = coRef.StateManagerHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgDisconnectTaskMethodStart::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgDisconnectTaskMethodStart::u16GetFunctionID() const {return RTFFI_C_U16_DISCONNECTTASK;}
tU8 rtffi_tclMsgDisconnectTaskMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rtffi_tclMsgDisconnectTaskMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rtffi_tclMsgDisconnectTaskMethodStart::operator==(const rtffi_tclMsgDisconnectTaskMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StateManagerHandle == rfoCmp.StateManagerHandle);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgDisconnectTaskMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> StateManagerHandle;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgDisconnectTaskMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StateManagerHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgDisconnectTaskMethodResult::rtffi_tclMsgDisconnectTaskMethodResult(const rtffi_tclMsgDisconnectTaskMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ThreadID = coRef.ThreadID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgDisconnectTaskMethodResult& rtffi_tclMsgDisconnectTaskMethodResult::operator=(const rtffi_tclMsgDisconnectTaskMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ThreadID = coRef.ThreadID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgDisconnectTaskMethodResult::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgDisconnectTaskMethodResult::u16GetFunctionID() const {return RTFFI_C_U16_DISCONNECTTASK;}
tU8 rtffi_tclMsgDisconnectTaskMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rtffi_tclMsgDisconnectTaskMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rtffi_tclMsgDisconnectTaskMethodResult::operator==(const rtffi_tclMsgDisconnectTaskMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ThreadID == rfoCmp.ThreadID);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgDisconnectTaskMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ThreadID;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgDisconnectTaskMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ThreadID;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgConfirmStateReachedMethodStart::rtffi_tclMsgConfirmStateReachedMethodStart(const rtffi_tclMsgConfirmStateReachedMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   StateManagerHandle = coRef.StateManagerHandle;
   NewAppState = coRef.NewAppState;
   OldAppState = coRef.OldAppState;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgConfirmStateReachedMethodStart& rtffi_tclMsgConfirmStateReachedMethodStart::operator=(const rtffi_tclMsgConfirmStateReachedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StateManagerHandle = coRef.StateManagerHandle;
   NewAppState = coRef.NewAppState;
   OldAppState = coRef.OldAppState;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgConfirmStateReachedMethodStart::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgConfirmStateReachedMethodStart::u16GetFunctionID() const {return RTFFI_C_U16_CONFIRMSTATEREACHED;}
tU8 rtffi_tclMsgConfirmStateReachedMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rtffi_tclMsgConfirmStateReachedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

tBool rtffi_tclMsgConfirmStateReachedMethodStart::operator==(const rtffi_tclMsgConfirmStateReachedMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StateManagerHandle == rfoCmp.StateManagerHandle);
      bResult = bResult && (NewAppState == rfoCmp.NewAppState);
      bResult = bResult && (OldAppState == rfoCmp.OldAppState);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgConfirmStateReachedMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> StateManagerHandle;
   oIn >> NewAppState;
   oIn >> OldAppState;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgConfirmStateReachedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StateManagerHandle;
   oOut << NewAppState;
   oOut << OldAppState;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgConfirmStateReachedMethodResult::rtffi_tclMsgConfirmStateReachedMethodResult(const rtffi_tclMsgConfirmStateReachedMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NewAppState = coRef.NewAppState;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgConfirmStateReachedMethodResult& rtffi_tclMsgConfirmStateReachedMethodResult::operator=(const rtffi_tclMsgConfirmStateReachedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NewAppState = coRef.NewAppState;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgConfirmStateReachedMethodResult::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgConfirmStateReachedMethodResult::u16GetFunctionID() const {return RTFFI_C_U16_CONFIRMSTATEREACHED;}
tU8 rtffi_tclMsgConfirmStateReachedMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rtffi_tclMsgConfirmStateReachedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rtffi_tclMsgConfirmStateReachedMethodResult::operator==(const rtffi_tclMsgConfirmStateReachedMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NewAppState == rfoCmp.NewAppState);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgConfirmStateReachedMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NewAppState;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgConfirmStateReachedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NewAppState;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgRequestShutdownMethodStart::rtffi_tclMsgRequestShutdownMethodStart(const rtffi_tclMsgRequestShutdownMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   StateManagerHandle = coRef.StateManagerHandle;
   ShutdownLevel = coRef.ShutdownLevel;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgRequestShutdownMethodStart& rtffi_tclMsgRequestShutdownMethodStart::operator=(const rtffi_tclMsgRequestShutdownMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StateManagerHandle = coRef.StateManagerHandle;
   ShutdownLevel = coRef.ShutdownLevel;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgRequestShutdownMethodStart::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgRequestShutdownMethodStart::u16GetFunctionID() const {return RTFFI_C_U16_REQUESTSHUTDOWN;}
tU8 rtffi_tclMsgRequestShutdownMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rtffi_tclMsgRequestShutdownMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool rtffi_tclMsgRequestShutdownMethodStart::operator==(const rtffi_tclMsgRequestShutdownMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StateManagerHandle == rfoCmp.StateManagerHandle);
      bResult = bResult && (ShutdownLevel == rfoCmp.ShutdownLevel);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgRequestShutdownMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> StateManagerHandle;
   oIn >> ShutdownLevel;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgRequestShutdownMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StateManagerHandle;
   oOut << ShutdownLevel;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgRequestShutdownMethodResult::rtffi_tclMsgRequestShutdownMethodResult(const rtffi_tclMsgRequestShutdownMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   StateManagerHandle = coRef.StateManagerHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgRequestShutdownMethodResult& rtffi_tclMsgRequestShutdownMethodResult::operator=(const rtffi_tclMsgRequestShutdownMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StateManagerHandle = coRef.StateManagerHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgRequestShutdownMethodResult::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgRequestShutdownMethodResult::u16GetFunctionID() const {return RTFFI_C_U16_REQUESTSHUTDOWN;}
tU8 rtffi_tclMsgRequestShutdownMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rtffi_tclMsgRequestShutdownMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rtffi_tclMsgRequestShutdownMethodResult::operator==(const rtffi_tclMsgRequestShutdownMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StateManagerHandle == rfoCmp.StateManagerHandle);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgRequestShutdownMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> StateManagerHandle;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgRequestShutdownMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StateManagerHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgInternalMessageMethodStart::rtffi_tclMsgInternalMessageMethodStart(const rtffi_tclMsgInternalMessageMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataType = coRef.DataType;
   DataPointer = coRef.DataPointer;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgInternalMessageMethodStart& rtffi_tclMsgInternalMessageMethodStart::operator=(const rtffi_tclMsgInternalMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DataType = coRef.DataType;
   DataPointer = coRef.DataPointer;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgInternalMessageMethodStart::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgInternalMessageMethodStart::u16GetFunctionID() const {return RTFFI_C_U16_INTERNALMESSAGE;}
tU8 rtffi_tclMsgInternalMessageMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rtffi_tclMsgInternalMessageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool rtffi_tclMsgInternalMessageMethodStart::operator==(const rtffi_tclMsgInternalMessageMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataType == rfoCmp.DataType);
      bResult = bResult && (DataPointer == rfoCmp.DataPointer);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgInternalMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> DataType;
   oIn >> DataPointer;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgInternalMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataType;
   oOut << DataPointer;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgInternalMessageMethodResult::rtffi_tclMsgInternalMessageMethodResult(const rtffi_tclMsgInternalMessageMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgInternalMessageMethodResult& rtffi_tclMsgInternalMessageMethodResult::operator=(const rtffi_tclMsgInternalMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgInternalMessageMethodResult::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgInternalMessageMethodResult::u16GetFunctionID() const {return RTFFI_C_U16_INTERNALMESSAGE;}
tU8 rtffi_tclMsgInternalMessageMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rtffi_tclMsgInternalMessageMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rtffi_tclMsgInternalMessageMethodResult::operator==(const rtffi_tclMsgInternalMessageMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rtffi_tclMsgInternalMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgInternalMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgTransitionRequestGet::rtffi_tclMsgTransitionRequestGet(const rtffi_tclMsgTransitionRequestGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   StateManagerHandle = coRef.StateManagerHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgTransitionRequestGet& rtffi_tclMsgTransitionRequestGet::operator=(const rtffi_tclMsgTransitionRequestGet& coRef)
{
   if (this == &coRef) return *this;
   StateManagerHandle = coRef.StateManagerHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgTransitionRequestGet::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgTransitionRequestGet::u16GetFunctionID() const {return RTFFI_C_U16_TRANSITIONREQUEST;}
tU8 rtffi_tclMsgTransitionRequestGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rtffi_tclMsgTransitionRequestGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rtffi_tclMsgTransitionRequestGet::operator==(const rtffi_tclMsgTransitionRequestGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StateManagerHandle == rfoCmp.StateManagerHandle);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgTransitionRequestGet::oRead(fi_tclInContext& oIn)
{
   oIn >> StateManagerHandle;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgTransitionRequestGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StateManagerHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgTransitionRequestStatus::rtffi_tclMsgTransitionRequestStatus(const rtffi_tclMsgTransitionRequestStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ApplicationState = coRef.ApplicationState;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rtffi_tclMsgTransitionRequestStatus& rtffi_tclMsgTransitionRequestStatus::operator=(const rtffi_tclMsgTransitionRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   ApplicationState = coRef.ApplicationState;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rtffi_tclMsgTransitionRequestStatus::u16GetServiceID() const {return RTFFI_C_U16_SERVICE_ID;}
tU16 rtffi_tclMsgTransitionRequestStatus::u16GetFunctionID() const {return RTFFI_C_U16_TRANSITIONREQUEST;}
tU8 rtffi_tclMsgTransitionRequestStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rtffi_tclMsgTransitionRequestStatus::vDestroy()
{
   ApplicationState.vDestroy(); 
}

tU32 rtffi_tclMsgTransitionRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool rtffi_tclMsgTransitionRequestStatus::operator==(const rtffi_tclMsgTransitionRequestStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ApplicationState == rfoCmp.ApplicationState);
   return bResult;
}

fi_tclInContext& rtffi_tclMsgTransitionRequestStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ApplicationState;
   return oIn;
}

fi_tclOutContext& rtffi_tclMsgTransitionRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ApplicationState;
   return oOut;
}

