#include "precompiled.hh"

tBool rtffi_tclDescription::bInitMessage(rtffi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case rtffi_tclToken::EN_LAST_TOKEN:
   case rtffi_tclToken::EN_LIST:
   case rtffi_tclToken::EN_END_OF_STRUCT:
   case rtffi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case rtffi_tclToken::EN_MSG_CONNECTTASKMETHODSTART:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U32,rtffi_tclSemanticDomain::EN_MSG_THREADID));
   } break;
   case rtffi_tclToken::EN_MSG_CONNECTTASKMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U32_STATEMANAGERHANDLE,rtffi_tclSemanticDomain::EN_MSG_STATEMANAGERHANDLE));
   } break;
   case rtffi_tclToken::EN_MSG_DISCONNECTTASKMETHODSTART:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U32_STATEMANAGERHANDLE,rtffi_tclSemanticDomain::EN_MSG_STATEMANAGERHANDLE));
   } break;
   case rtffi_tclToken::EN_MSG_DISCONNECTTASKMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U32,rtffi_tclSemanticDomain::EN_MSG_THREADID));
   } break;
   case rtffi_tclToken::EN_MSG_CONFIRMSTATEREACHEDMETHODSTART:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_E32_SYSTEMSTATE,rtffi_tclSemanticDomain::EN_MSG_OLDAPPSTATE));
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_E32_SYSTEMSTATE,rtffi_tclSemanticDomain::EN_MSG_NEWAPPSTATE));
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U32_STATEMANAGERHANDLE,rtffi_tclSemanticDomain::EN_MSG_STATEMANAGERHANDLE));
   } break;
   case rtffi_tclToken::EN_MSG_CONFIRMSTATEREACHEDMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_E32_SYSTEMSTATE,rtffi_tclSemanticDomain::EN_MSG_NEWAPPSTATE));
   } break;
   case rtffi_tclToken::EN_MSG_REQUESTSHUTDOWNMETHODSTART:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_E32_SHUTDOWNLEVEL,rtffi_tclSemanticDomain::EN_MSG_SHUTDOWNLEVEL));
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U32_STATEMANAGERHANDLE,rtffi_tclSemanticDomain::EN_MSG_STATEMANAGERHANDLE));
   } break;
   case rtffi_tclToken::EN_MSG_REQUESTSHUTDOWNMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U32_STATEMANAGERHANDLE,rtffi_tclSemanticDomain::EN_MSG_STATEMANAGERHANDLE));
   } break;
   case rtffi_tclToken::EN_MSG_INTERNALMESSAGEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U64,rtffi_tclSemanticDomain::EN_MSG_DATAPOINTER));
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U16,rtffi_tclSemanticDomain::EN_MSG_DATATYPE));
   } break;
   case rtffi_tclToken::EN_MSG_TRANSITIONREQUESTGET:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U32_STATEMANAGERHANDLE,rtffi_tclSemanticDomain::EN_MSG_STATEMANAGERHANDLE));
   } break;
   case rtffi_tclToken::EN_MSG_TRANSITIONREQUESTSTATUS:
   {
      bResult &= oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_NAVAPPSTATE,rtffi_tclSemanticDomain::EN_MSG_APPLICATIONSTATE));
   } break;
   case rtffi_tclToken::EN_BINCONTAINER:
   case rtffi_tclToken::EN_U32_STATEMANAGERHANDLE:
   case rtffi_tclToken::EN_E32_SYSTEMSTATE:
   case rtffi_tclToken::EN_NAVAPPSTATE:
   case rtffi_tclToken::EN_E32_SHUTDOWNLEVEL:
   case rtffi_tclToken::EN_U8:   
   case rtffi_tclToken::EN_S8:   
   case rtffi_tclToken::EN_U16:   
   case rtffi_tclToken::EN_S16:   
   case rtffi_tclToken::EN_U24:   
   case rtffi_tclToken::EN_S24:   
   case rtffi_tclToken::EN_U32:   
   case rtffi_tclToken::EN_S32:   
   case rtffi_tclToken::EN_U64:   
   case rtffi_tclToken::EN_S64:   
   case rtffi_tclToken::EN_F32:   
   case rtffi_tclToken::EN_F64:   
   case rtffi_tclToken::EN_BOOL:   
   case rtffi_tclToken::EN_STRING:   
   case rtffi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(rtffi_tclKnot(enMsgToken,rtffi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool rtffi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool rtffi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      rtffi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      rtffi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      rtffi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == rtffi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(rtffi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(rtffi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(rtffi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case rtffi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == rtffi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case rtffi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            rtffi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(rtffi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            rtffi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(rtffi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case rtffi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case rtffi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rtffi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case rtffi_tclToken::EN_MSG_CONNECTTASKMETHODSTART:
   case rtffi_tclToken::EN_MSG_CONNECTTASKMETHODRESULT:
   case rtffi_tclToken::EN_MSG_DISCONNECTTASKMETHODSTART:
   case rtffi_tclToken::EN_MSG_DISCONNECTTASKMETHODRESULT:
   case rtffi_tclToken::EN_MSG_CONFIRMSTATEREACHEDMETHODSTART:
   case rtffi_tclToken::EN_MSG_CONFIRMSTATEREACHEDMETHODRESULT:
   case rtffi_tclToken::EN_MSG_REQUESTSHUTDOWNMETHODSTART:
   case rtffi_tclToken::EN_MSG_REQUESTSHUTDOWNMETHODRESULT:
   case rtffi_tclToken::EN_MSG_INTERNALMESSAGEMETHODSTART:
   case rtffi_tclToken::EN_MSG_INTERNALMESSAGEMETHODRESULT:
   case rtffi_tclToken::EN_MSG_TRANSITIONREQUESTGET:
   case rtffi_tclToken::EN_MSG_TRANSITIONREQUESTSTATUS:
      bInitMessage(enToken);
      break;
   case rtffi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_END_OF_STRUCT,rtffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_U8,rtffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_LIST,rtffi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rtffi_tclToken::EN_U32_STATEMANAGERHANDLE:
   {
      fi_tcl_u32_StateManagerHandle o_u32_StateManagerHandle;
      if (!bDoIt(o_u32_StateManagerHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rtffi_tclToken::EN_E32_SYSTEMSTATE:
   {
      fi_tcl_e32_SystemState o_e32_SystemState;
      if (!bDoIt(o_e32_SystemState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rtffi_tclToken::EN_NAVAPPSTATE:
   {
      if (poVisitor->bDoExpand_NavAppState(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_END_OF_STRUCT,rtffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_E32_SYSTEMSTATE,rtffi_tclSemanticDomain::EN_E32OLDAPPSTATE));
         oPath.bGoDown(rtffi_tclKnot(rtffi_tclToken::EN_E32_SYSTEMSTATE,rtffi_tclSemanticDomain::EN_E32NEWAPPSTATE));
      }
      else
      {
         fi_tcl_NavAppState o_NavAppState;
         if (!bDoIt(o_NavAppState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAppState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAppState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rtffi_tclToken::EN_E32_SHUTDOWNLEVEL:
   {
      fi_tcl_e32_ShutdownLevel o_e32_ShutdownLevel;
      if (!bDoIt(o_e32_ShutdownLevel))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
      case rtffi_tclToken::EN_UNKNOWN:
      case rtffi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

