#ifndef __RTFFIDEBUGVISITOR_H__
#define __RTFFIDEBUGVISITOR_H__

class MY_DECL rtffi_tclPrintVisitor : public rtffi_tclVisitorBase {

private:
   /* default constructor */ rtffi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   rtffi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(rtffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_StateManagerHandle(fi_tcl_u32_StateManagerHandle& o_u32_StateManagerHandle);
   virtual tVoid vVisit_e32_SystemState(fi_tcl_e32_SystemState& o_e32_SystemState);
   virtual tBool bDoExpand_NavAppState(rtffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e32_ShutdownLevel(fi_tcl_e32_ShutdownLevel& o_e32_ShutdownLevel);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL rtffi_tclRandomInitVisitor : public rtffi_tclVisitorBase {
public:

   rtffi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u32_StateManagerHandle(fi_tcl_u32_StateManagerHandle& o_u32_StateManagerHandle);
   virtual tVoid vVisit_e32_SystemState(fi_tcl_e32_SystemState& o_e32_SystemState);
   virtual tVoid vVisit_e32_ShutdownLevel(fi_tcl_e32_ShutdownLevel& o_e32_ShutdownLevel);
	tU32 u32ListSize;
};

#endif
