/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef RGFITYPES_HEADER
#define RGFITYPES_HEADER

// #include <vector>
// 


class rgfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class rgfi_tclMsgStartGuidanceMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgStartGuidanceMethodStart():TripHandle(),RouteHandle(),UserProfiles(),DestinationInfoLanguageID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgStartGuidanceMethodStart& operator=(const rgfi_tclMsgStartGuidanceMethodStart& coRef);
   rgfi_tclMsgStartGuidanceMethodStart(const rgfi_tclMsgStartGuidanceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_UserProfiles UserProfiles;
   std::vector<fi_tclString, std::allocator<fi_tclString> > DestinationInfoTexts;
   fi_tcl_LanguageID DestinationInfoLanguageID;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgStartGuidanceMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_STARTGUIDANCEMETHODSTART;}
};

class rgfi_tclMsgStartGuidanceMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgStartGuidanceMethodResult():TripHandle(),RouteHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgStartGuidanceMethodResult& operator=(const rgfi_tclMsgStartGuidanceMethodResult& coRef);
   rgfi_tclMsgStartGuidanceMethodResult(const rgfi_tclMsgStartGuidanceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgStartGuidanceMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_STARTGUIDANCEMETHODRESULT;}
};

class rgfi_tclMsgStopGuidanceMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgStopGuidanceMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgStopGuidanceMethodStart& operator=(const rgfi_tclMsgStopGuidanceMethodStart& coRef);
   rgfi_tclMsgStopGuidanceMethodStart(const rgfi_tclMsgStopGuidanceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgStopGuidanceMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_STOPGUIDANCEMETHODSTART;}
};

class rgfi_tclMsgStopGuidanceMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgStopGuidanceMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgStopGuidanceMethodResult& operator=(const rgfi_tclMsgStopGuidanceMethodResult& coRef);
   rgfi_tclMsgStopGuidanceMethodResult(const rgfi_tclMsgStopGuidanceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgStopGuidanceMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_STOPGUIDANCEMETHODRESULT;}
};

class rgfi_tclMsgChangeGuidanceModeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeGuidanceModeMethodStart():GuidanceMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeGuidanceModeMethodStart& operator=(const rgfi_tclMsgChangeGuidanceModeMethodStart& coRef);
   rgfi_tclMsgChangeGuidanceModeMethodStart(const rgfi_tclMsgChangeGuidanceModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_GuidanceMode GuidanceMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeGuidanceModeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGEGUIDANCEMODEMETHODSTART;}
};

class rgfi_tclMsgChangeGuidanceModeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeGuidanceModeMethodResult():GuidanceMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeGuidanceModeMethodResult& operator=(const rgfi_tclMsgChangeGuidanceModeMethodResult& coRef);
   rgfi_tclMsgChangeGuidanceModeMethodResult(const rgfi_tclMsgChangeGuidanceModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_GuidanceMode GuidanceMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeGuidanceModeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGEGUIDANCEMODEMETHODRESULT;}
};

class rgfi_tclMsgSetUserProfilesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSetUserProfilesMethodStart():UserProfiles() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSetUserProfilesMethodStart& operator=(const rgfi_tclMsgSetUserProfilesMethodStart& coRef);
   rgfi_tclMsgSetUserProfilesMethodStart(const rgfi_tclMsgSetUserProfilesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UserProfiles UserProfiles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSetUserProfilesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SETUSERPROFILESMETHODSTART;}
};

class rgfi_tclMsgSetUserProfilesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSetUserProfilesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSetUserProfilesMethodResult& operator=(const rgfi_tclMsgSetUserProfilesMethodResult& coRef);
   rgfi_tclMsgSetUserProfilesMethodResult(const rgfi_tclMsgSetUserProfilesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSetUserProfilesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SETUSERPROFILESMETHODRESULT;}
};

class rgfi_tclMsgRetriggerAcousticOutputMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgRetriggerAcousticOutputMethodStart():MessageClasses() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgRetriggerAcousticOutputMethodStart& operator=(const rgfi_tclMsgRetriggerAcousticOutputMethodStart& coRef);
   rgfi_tclMsgRetriggerAcousticOutputMethodStart(const rgfi_tclMsgRetriggerAcousticOutputMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_GuidanceMessageCategory MessageClasses;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgRetriggerAcousticOutputMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_RETRIGGERACOUSTICOUTPUTMETHODSTART;}
};

class rgfi_tclMsgRetriggerAcousticOutputMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgRetriggerAcousticOutputMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgRetriggerAcousticOutputMethodResult& operator=(const rgfi_tclMsgRetriggerAcousticOutputMethodResult& coRef);
   rgfi_tclMsgRetriggerAcousticOutputMethodResult(const rgfi_tclMsgRetriggerAcousticOutputMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgRetriggerAcousticOutputMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_RETRIGGERACOUSTICOUTPUTMETHODRESULT;}
};

class rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart():WarningsOnHorizonMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart& operator=(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart& coRef);
   rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_WarningsOnHorizonMode WarningsOnHorizonMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGEWARNINGSONHORIZONMODEMETHODSTART;}
};

class rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult():WarningsOnHorizonMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult& operator=(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult& coRef);
   rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_WarningsOnHorizonMode WarningsOnHorizonMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGEWARNINGSONHORIZONMODEMETHODRESULT;}
};

class rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart& operator=(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart& coRef);
   rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GETSUPPORTEDFUNCTIONALITYSTATESMETHODSTART;}
};

class rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult():RouteInfoAcoustic(),RouteInfoSymbolic(),DestinationInfoAcoustic(),DestinationInfoSymbolic(),DrivingRecommendationAcoustic(),DrivingRecommendationSymbolic(),CorridorInfoAcoustic(),CorridorInfoSymbolic(),HorizonInfoTrafficMessageAcoustic(),HorizonInfoTrafficMessageSymbolic(),HorizonInfoSpeedLimitAcoustic(),HorizonInfoSpeedLimitSymbolic(),HorizonInfoWarningSignAcoustic(),HorizonInfoWarningSignSymbolic(),HorizonInfoPOIAcoustic(),HorizonInfoPOISymbolic(),HorizonInfoRoadAttributeAcoustic(),HorizonInfoRoadAttributeSymbolic(),HorizonInfoCurveAcoustic(),HorizonInfoCurveSymbolic(),HorizonInfoUPOI(),DriverSpeedAdvice(),HorizonEvents() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult& operator=(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult& coRef);
   rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_FunctionalityGroupRouteInfo RouteInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupRouteInfo RouteInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupDestinationInfo DestinationInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupDestinationInfo DestinationInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupDrivingRecommendation DrivingRecommendationAcoustic;
   fi_tcl_b16_FunctionalityGroupDrivingRecommendation DrivingRecommendationSymbolic;
   fi_tcl_b16_FunctionalityGroupCorridorInfo CorridorInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupCorridorInfo CorridorInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage HorizonInfoTrafficMessageAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage HorizonInfoTrafficMessageSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit HorizonInfoSpeedLimitAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit HorizonInfoSpeedLimitSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign HorizonInfoWarningSignAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign HorizonInfoWarningSignSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoPOI HorizonInfoPOIAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoPOI HorizonInfoPOISymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute HorizonInfoRoadAttributeAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute HorizonInfoRoadAttributeSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoCurve HorizonInfoCurveAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoCurve HorizonInfoCurveSymbolic;
   fi_tcl_UPOI_CategoryConfigurationList HorizonInfoUPOI;
   fi_tcl_DriverSpeedAdviceConfiguration DriverSpeedAdvice;
   fi_tcl_HorizonEventsFilter HorizonEvents;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GETSUPPORTEDFUNCTIONALITYSTATESMETHODRESULT;}
};

class rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart& operator=(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart& coRef);
   rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHLANGUAGESMETHODSTART;}
};

class rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult& operator=(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult& coRef);
   rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_Language, std::allocator<fi_tcl_Language> > AvailableLanguages;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHLANGUAGESMETHODRESULT;}
};

class rgfi_tclMsgChangeSpeechLanguageMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeSpeechLanguageMethodStart():LanguageID(),SpeakerName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeSpeechLanguageMethodStart& operator=(const rgfi_tclMsgChangeSpeechLanguageMethodStart& coRef);
   rgfi_tclMsgChangeSpeechLanguageMethodStart(const rgfi_tclMsgChangeSpeechLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageID LanguageID;
   fi_tclString SpeakerName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeSpeechLanguageMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGESPEECHLANGUAGEMETHODSTART;}
};

class rgfi_tclMsgChangeSpeechLanguageMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeSpeechLanguageMethodResult():LanguageID(),SpeakerName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeSpeechLanguageMethodResult& operator=(const rgfi_tclMsgChangeSpeechLanguageMethodResult& coRef);
   rgfi_tclMsgChangeSpeechLanguageMethodResult(const rgfi_tclMsgChangeSpeechLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageID LanguageID;
   fi_tclString SpeakerName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeSpeechLanguageMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGESPEECHLANGUAGEMETHODRESULT;}
};

class rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart():LanguageID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart& operator=(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart& coRef);
   rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageID LanguageID;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHMETRICSYSTEMSMETHODSTART;}
};

class rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult& operator=(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult& coRef);
   rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e8_MetricSystem, std::allocator<fi_tcl_e8_MetricSystem> > AvailableMetricSystems;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHMETRICSYSTEMSMETHODRESULT;}
};

class rgfi_tclMsgChangeSpeechMetricSystemMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeSpeechMetricSystemMethodStart():MetricSystem() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeSpeechMetricSystemMethodStart& operator=(const rgfi_tclMsgChangeSpeechMetricSystemMethodStart& coRef);
   rgfi_tclMsgChangeSpeechMetricSystemMethodStart(const rgfi_tclMsgChangeSpeechMetricSystemMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MetricSystem MetricSystem;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeSpeechMetricSystemMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGESPEECHMETRICSYSTEMMETHODSTART;}
};

class rgfi_tclMsgChangeSpeechMetricSystemMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeSpeechMetricSystemMethodResult():MetricSystem() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeSpeechMetricSystemMethodResult& operator=(const rgfi_tclMsgChangeSpeechMetricSystemMethodResult& coRef);
   rgfi_tclMsgChangeSpeechMetricSystemMethodResult(const rgfi_tclMsgChangeSpeechMetricSystemMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MetricSystem MetricSystem;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeSpeechMetricSystemMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGESPEECHMETRICSYSTEMMETHODRESULT;}
};

class rgfi_tclMsgGetAvailableSpeechFeatureMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGetAvailableSpeechFeatureMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGetAvailableSpeechFeatureMethodStart& operator=(const rgfi_tclMsgGetAvailableSpeechFeatureMethodStart& coRef);
   rgfi_tclMsgGetAvailableSpeechFeatureMethodStart(const rgfi_tclMsgGetAvailableSpeechFeatureMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGetAvailableSpeechFeatureMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHFEATUREMETHODSTART;}
};

class rgfi_tclMsgGetAvailableSpeechFeatureMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGetAvailableSpeechFeatureMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGetAvailableSpeechFeatureMethodResult& operator=(const rgfi_tclMsgGetAvailableSpeechFeatureMethodResult& coRef);
   rgfi_tclMsgGetAvailableSpeechFeatureMethodResult(const rgfi_tclMsgGetAvailableSpeechFeatureMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e8_SpeechFeature, std::allocator<fi_tcl_e8_SpeechFeature> > AvailableFeature;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGetAvailableSpeechFeatureMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GETAVAILABLESPEECHFEATUREMETHODRESULT;}
};

class rgfi_tclMsgChangeSpeechFeatureMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeSpeechFeatureMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeSpeechFeatureMethodStart& operator=(const rgfi_tclMsgChangeSpeechFeatureMethodStart& coRef);
   rgfi_tclMsgChangeSpeechFeatureMethodStart(const rgfi_tclMsgChangeSpeechFeatureMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e8_SpeechFeature, std::allocator<fi_tcl_e8_SpeechFeature> > SpeechFeature;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeSpeechFeatureMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGESPEECHFEATUREMETHODSTART;}
};

class rgfi_tclMsgChangeSpeechFeatureMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgChangeSpeechFeatureMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgChangeSpeechFeatureMethodResult& operator=(const rgfi_tclMsgChangeSpeechFeatureMethodResult& coRef);
   rgfi_tclMsgChangeSpeechFeatureMethodResult(const rgfi_tclMsgChangeSpeechFeatureMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e8_SpeechFeature, std::allocator<fi_tcl_e8_SpeechFeature> > SpeechFeature;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgChangeSpeechFeatureMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CHANGESPEECHFEATUREMETHODRESULT;}
};

class rgfi_tclMsgSpeakSentenceMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeakSentenceMethodStart():SentenceId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeakSentenceMethodStart& operator=(const rgfi_tclMsgSpeakSentenceMethodStart& coRef);
   rgfi_tclMsgSpeakSentenceMethodStart(const rgfi_tclMsgSpeakSentenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_Sentence SentenceId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeakSentenceMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART;}
};

class rgfi_tclMsgSpeakSentenceMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeakSentenceMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeakSentenceMethodResult& operator=(const rgfi_tclMsgSpeakSentenceMethodResult& coRef);
   rgfi_tclMsgSpeakSentenceMethodResult(const rgfi_tclMsgSpeakSentenceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeakSentenceMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT;}
};

class rgfi_tclMsgSpeakTMInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeakTMInfoMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeakTMInfoMethodStart& operator=(const rgfi_tclMsgSpeakTMInfoMethodStart& coRef);
   rgfi_tclMsgSpeakTMInfoMethodStart(const rgfi_tclMsgSpeakTMInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TMInfo, std::allocator<fi_tcl_TMInfo> > TMInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeakTMInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEAKTMINFOMETHODSTART;}
};

class rgfi_tclMsgSpeakTMInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeakTMInfoMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeakTMInfoMethodResult& operator=(const rgfi_tclMsgSpeakTMInfoMethodResult& coRef);
   rgfi_tclMsgSpeakTMInfoMethodResult(const rgfi_tclMsgSpeakTMInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeakTMInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEAKTMINFOMETHODRESULT;}
};

class rgfi_tclMsgSpeakTMInfoMethodAbort : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeakTMInfoMethodAbort() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeakTMInfoMethodAbort& operator=(const rgfi_tclMsgSpeakTMInfoMethodAbort& coRef);
   rgfi_tclMsgSpeakTMInfoMethodAbort(const rgfi_tclMsgSpeakTMInfoMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeakTMInfoMethodAbort& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEAKTMINFOMETHODABORT;}
};

class rgfi_tclMsgSpeakTMInfoAbortResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeakTMInfoAbortResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeakTMInfoAbortResult& operator=(const rgfi_tclMsgSpeakTMInfoAbortResult& coRef);
   rgfi_tclMsgSpeakTMInfoAbortResult(const rgfi_tclMsgSpeakTMInfoAbortResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeakTMInfoAbortResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEAKTMINFOABORTRESULT;}
};

class rgfi_tclMsgPlayDebugSoundMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgPlayDebugSoundMethodStart():SentenceId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgPlayDebugSoundMethodStart& operator=(const rgfi_tclMsgPlayDebugSoundMethodStart& coRef);
   rgfi_tclMsgPlayDebugSoundMethodStart(const rgfi_tclMsgPlayDebugSoundMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DebugSound SentenceId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgPlayDebugSoundMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_PLAYDEBUGSOUNDMETHODSTART;}
};

class rgfi_tclMsgSetPredictiveCCModeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSetPredictiveCCModeMethodStart():OperationMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSetPredictiveCCModeMethodStart& operator=(const rgfi_tclMsgSetPredictiveCCModeMethodStart& coRef);
   rgfi_tclMsgSetPredictiveCCModeMethodStart(const rgfi_tclMsgSetPredictiveCCModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b32_PredictiveCCMode OperationMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSetPredictiveCCModeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SETPREDICTIVECCMODEMETHODSTART;}
};

class rgfi_tclMsgSetPredictiveCCModeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSetPredictiveCCModeMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSetPredictiveCCModeMethodResult& operator=(const rgfi_tclMsgSetPredictiveCCModeMethodResult& coRef);
   rgfi_tclMsgSetPredictiveCCModeMethodResult(const rgfi_tclMsgSetPredictiveCCModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSetPredictiveCCModeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SETPREDICTIVECCMODEMETHODRESULT;}
};

class rgfi_tclMsgGuidanceModeGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGuidanceModeGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGuidanceModeGet& operator=(const rgfi_tclMsgGuidanceModeGet& coRef);
   rgfi_tclMsgGuidanceModeGet(const rgfi_tclMsgGuidanceModeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGuidanceModeGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GUIDANCEMODEGET;}
};

class rgfi_tclMsgGuidanceModeStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGuidanceModeStatus():GuidanceMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGuidanceModeStatus& operator=(const rgfi_tclMsgGuidanceModeStatus& coRef);
   rgfi_tclMsgGuidanceModeStatus(const rgfi_tclMsgGuidanceModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_GuidanceMode GuidanceMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGuidanceModeStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GUIDANCEMODESTATUS;}
};

class rgfi_tclMsgGuidanceStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGuidanceStatusGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGuidanceStatusGet& operator=(const rgfi_tclMsgGuidanceStatusGet& coRef);
   rgfi_tclMsgGuidanceStatusGet(const rgfi_tclMsgGuidanceStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGuidanceStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GUIDANCESTATUSGET;}
};

class rgfi_tclMsgGuidanceStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgGuidanceStatusStatus():GuidanceStatus(),GuidedTripHandle(),GuidedRouteHandle(),CurrentTripSegment() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgGuidanceStatusStatus& operator=(const rgfi_tclMsgGuidanceStatusStatus& coRef);
   rgfi_tclMsgGuidanceStatusStatus(const rgfi_tclMsgGuidanceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_GuidanceStatus GuidanceStatus;
   fi_tcl_u16_TripHandle GuidedTripHandle;
   fi_tcl_u16_RouteHandle GuidedRouteHandle;
   fi_tcl_u16_TripSegmentNumber CurrentTripSegment;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgGuidanceStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_GUIDANCESTATUSSTATUS;}
};

class rgfi_tclMsgDataCarrierRequestGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDataCarrierRequestGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDataCarrierRequestGet& operator=(const rgfi_tclMsgDataCarrierRequestGet& coRef);
   rgfi_tclMsgDataCarrierRequestGet(const rgfi_tclMsgDataCarrierRequestGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDataCarrierRequestGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DATACARRIERREQUESTGET;}
};

class rgfi_tclMsgDataCarrierRequestStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDataCarrierRequestStatus():DataCarrierRequestStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDataCarrierRequestStatus& operator=(const rgfi_tclMsgDataCarrierRequestStatus& coRef);
   rgfi_tclMsgDataCarrierRequestStatus(const rgfi_tclMsgDataCarrierRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DataCarrierRequestStatus DataCarrierRequestStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDataCarrierRequestStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DATACARRIERREQUESTSTATUS;}
};

class rgfi_tclMsgDistanceToNextManeuverGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDistanceToNextManeuverGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDistanceToNextManeuverGet& operator=(const rgfi_tclMsgDistanceToNextManeuverGet& coRef);
   rgfi_tclMsgDistanceToNextManeuverGet(const rgfi_tclMsgDistanceToNextManeuverGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDistanceToNextManeuverGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DISTANCETONEXTMANEUVERGET;}
};

class rgfi_tclMsgDistanceToNextManeuverStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDistanceToNextManeuverStatus():ReleaseNumber(0),Distance(),BargraphFlag(0),Bargraph() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDistanceToNextManeuverStatus& operator=(const rgfi_tclMsgDistanceToNextManeuverStatus& coRef);
   rgfi_tclMsgDistanceToNextManeuverStatus(const rgfi_tclMsgDistanceToNextManeuverStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   fi_tcl_s32_Meter Distance;
   tBool BargraphFlag;
   fi_tcl_s16_PerThousand Bargraph;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDistanceToNextManeuverStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DISTANCETONEXTMANEUVERSTATUS;}
};

class rgfi_tclMsgTurnToInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTurnToInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTurnToInfoGet& operator=(const rgfi_tclMsgTurnToInfoGet& coRef);
   rgfi_tclMsgTurnToInfoGet(const rgfi_tclMsgTurnToInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTurnToInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TURNTOINFOGET;}
};

class rgfi_tclMsgTurnToInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTurnToInfoStatus():ReleaseNumber(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTurnToInfoStatus& operator=(const rgfi_tclMsgTurnToInfoStatus& coRef);
   rgfi_tclMsgTurnToInfoStatus(const rgfi_tclMsgTurnToInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> > TurnToInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTurnToInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TURNTOINFOSTATUS;}
};

class rgfi_tclMsgCurrentGuidanceDescriptorGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCurrentGuidanceDescriptorGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCurrentGuidanceDescriptorGet& operator=(const rgfi_tclMsgCurrentGuidanceDescriptorGet& coRef);
   rgfi_tclMsgCurrentGuidanceDescriptorGet(const rgfi_tclMsgCurrentGuidanceDescriptorGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCurrentGuidanceDescriptorGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CURRENTGUIDANCEDESCRIPTORGET;}
};

class rgfi_tclMsgCurrentGuidanceDescriptorStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCurrentGuidanceDescriptorStatus():ReleaseNumber(0),GuidanceElement(),DatasetId(0),TripHandle(),RouteHandle(),RouteInfoId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCurrentGuidanceDescriptorStatus& operator=(const rgfi_tclMsgCurrentGuidanceDescriptorStatus& coRef);
   rgfi_tclMsgCurrentGuidanceDescriptorStatus(const rgfi_tclMsgCurrentGuidanceDescriptorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   fi_tcl_GuidanceElement GuidanceElement;
   std::vector<fi_tcl_GuidanceDescriptorInfoCategory, std::allocator<fi_tcl_GuidanceDescriptorInfoCategory> > GuidanceDescriptorInfoCategoryList;
   tU32 DatasetId;
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   tU32 RouteInfoId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCurrentGuidanceDescriptorStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CURRENTGUIDANCEDESCRIPTORSTATUS;}
};

class rgfi_tclMsgNextGuidanceDescriptorsGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextGuidanceDescriptorsGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextGuidanceDescriptorsGet& operator=(const rgfi_tclMsgNextGuidanceDescriptorsGet& coRef);
   rgfi_tclMsgNextGuidanceDescriptorsGet(const rgfi_tclMsgNextGuidanceDescriptorsGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextGuidanceDescriptorsGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTGUIDANCEDESCRIPTORSGET;}
};

class rgfi_tclMsgNextGuidanceDescriptorsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextGuidanceDescriptorsStatus():ReleaseNumber(0),GuidanceManoeuvreSymbolList(),DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextGuidanceDescriptorsStatus& operator=(const rgfi_tclMsgNextGuidanceDescriptorsStatus& coRef);
   rgfi_tclMsgNextGuidanceDescriptorsStatus(const rgfi_tclMsgNextGuidanceDescriptorsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   fi_tcl_GuidanceManoeuvreSymbolList GuidanceManoeuvreSymbolList;
   std::vector<fi_tcl_GuidanceDescriptorInfoCategory, std::allocator<fi_tcl_GuidanceDescriptorInfoCategory> > GuidanceDescriptorInfoCategoryList;
   tU32 DatasetId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextGuidanceDescriptorsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTGUIDANCEDESCRIPTORSSTATUS;}
};

class rgfi_tclMsgDistanceToCurrentManoeuvreGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDistanceToCurrentManoeuvreGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDistanceToCurrentManoeuvreGet& operator=(const rgfi_tclMsgDistanceToCurrentManoeuvreGet& coRef);
   rgfi_tclMsgDistanceToCurrentManoeuvreGet(const rgfi_tclMsgDistanceToCurrentManoeuvreGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDistanceToCurrentManoeuvreGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DISTANCETOCURRENTMANOEUVREGET;}
};

class rgfi_tclMsgDistanceToCurrentManoeuvreStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDistanceToCurrentManoeuvreStatus():ReleaseNumber(0),DistanceToDecisionPoint(),DistanceToTrafficNodeBegin() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDistanceToCurrentManoeuvreStatus& operator=(const rgfi_tclMsgDistanceToCurrentManoeuvreStatus& coRef);
   rgfi_tclMsgDistanceToCurrentManoeuvreStatus(const rgfi_tclMsgDistanceToCurrentManoeuvreStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   fi_tcl_BargraphDistance DistanceToDecisionPoint;
   fi_tcl_BargraphDistance DistanceToTrafficNodeBegin;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDistanceToCurrentManoeuvreStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DISTANCETOCURRENTMANOEUVRESTATUS;}
};

class rgfi_tclMsgNextManeuverDescriptorGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextManeuverDescriptorGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextManeuverDescriptorGet& operator=(const rgfi_tclMsgNextManeuverDescriptorGet& coRef);
   rgfi_tclMsgNextManeuverDescriptorGet(const rgfi_tclMsgNextManeuverDescriptorGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextManeuverDescriptorGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTMANEUVERDESCRIPTORGET;}
};

class rgfi_tclMsgNextManeuverDescriptorStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextManeuverDescriptorStatus():ReleaseNumber(0),StartPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextManeuverDescriptorStatus& operator=(const rgfi_tclMsgNextManeuverDescriptorStatus& coRef);
   rgfi_tclMsgNextManeuverDescriptorStatus(const rgfi_tclMsgNextManeuverDescriptorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   fi_tcl_PositionWGS84 StartPosition;
   std::vector<fi_tcl_GuidanceManeuverElement, std::allocator<fi_tcl_GuidanceManeuverElement> > ManeuverDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextManeuverDescriptorStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTMANEUVERDESCRIPTORSTATUS;}
};

class rgfi_tclMsgNextMapManeuverDescriptorGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextMapManeuverDescriptorGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextMapManeuverDescriptorGet& operator=(const rgfi_tclMsgNextMapManeuverDescriptorGet& coRef);
   rgfi_tclMsgNextMapManeuverDescriptorGet(const rgfi_tclMsgNextMapManeuverDescriptorGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextMapManeuverDescriptorGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTMAPMANEUVERDESCRIPTORGET;}
};

class rgfi_tclMsgNextMapManeuverDescriptorStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextMapManeuverDescriptorStatus():ReleaseNumber(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextMapManeuverDescriptorStatus& operator=(const rgfi_tclMsgNextMapManeuverDescriptorStatus& coRef);
   rgfi_tclMsgNextMapManeuverDescriptorStatus(const rgfi_tclMsgNextMapManeuverDescriptorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   std::vector<fi_tcl_GuidanceMapManeuverElement, std::allocator<fi_tcl_GuidanceMapManeuverElement> > MapManeuverDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextMapManeuverDescriptorStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTMAPMANEUVERDESCRIPTORSTATUS;}
};

class rgfi_tclMsgSignPostAndLaneInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSignPostAndLaneInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSignPostAndLaneInfoGet& operator=(const rgfi_tclMsgSignPostAndLaneInfoGet& coRef);
   rgfi_tclMsgSignPostAndLaneInfoGet(const rgfi_tclMsgSignPostAndLaneInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSignPostAndLaneInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SIGNPOSTANDLANEINFOGET;}
};

class rgfi_tclMsgSignPostAndLaneInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSignPostAndLaneInfoStatus():SignPostInfoStatus(),ReleaseNumber(0),LaneInfoElement(),TrafficSense() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSignPostAndLaneInfoStatus& operator=(const rgfi_tclMsgSignPostAndLaneInfoStatus& coRef);
   rgfi_tclMsgSignPostAndLaneInfoStatus(const rgfi_tclMsgSignPostAndLaneInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_SignPostElement, std::allocator<fi_tcl_SignPostElement> > SignPostInfoList;
   fi_tcl_b8_SignPostInfoStatus SignPostInfoStatus;
   tU32 ReleaseNumber;
   fi_tcl_LaneInfoElement LaneInfoElement;
   std::vector<fi_tcl_LaneInfoElement, std::allocator<fi_tcl_LaneInfoElement> > NextLaneInfoElementList;
   fi_tcl_e8_SideInfo TrafficSense;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSignPostAndLaneInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SIGNPOSTANDLANEINFOSTATUS;}
};

class rgfi_tclMsgNextWarningPointDeltaGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextWarningPointDeltaGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextWarningPointDeltaGet& operator=(const rgfi_tclMsgNextWarningPointDeltaGet& coRef);
   rgfi_tclMsgNextWarningPointDeltaGet(const rgfi_tclMsgNextWarningPointDeltaGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextWarningPointDeltaGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTWARNINGPOINTDELTAGET;}
};

class rgfi_tclMsgNextWarningPointDeltaStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextWarningPointDeltaStatus():ReleaseId(0),DeltaDistanceFromFirstOutput() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextWarningPointDeltaStatus& operator=(const rgfi_tclMsgNextWarningPointDeltaStatus& coRef);
   rgfi_tclMsgNextWarningPointDeltaStatus(const rgfi_tclMsgNextWarningPointDeltaStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   fi_tcl_s32_Meter DeltaDistanceFromFirstOutput;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextWarningPointDeltaStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTWARNINGPOINTDELTASTATUS;}
};

class rgfi_tclMsgNextWarningPointGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextWarningPointGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextWarningPointGet& operator=(const rgfi_tclMsgNextWarningPointGet& coRef);
   rgfi_tclMsgNextWarningPointGet(const rgfi_tclMsgNextWarningPointGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextWarningPointGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTWARNINGPOINTGET;}
};

class rgfi_tclMsgNextWarningPointStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgNextWarningPointStatus():ReleaseId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgNextWarningPointStatus& operator=(const rgfi_tclMsgNextWarningPointStatus& coRef);
   rgfi_tclMsgNextWarningPointStatus(const rgfi_tclMsgNextWarningPointStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   std::vector<fi_tcl_NextWarningPoint, std::allocator<fi_tcl_NextWarningPoint> > NextWarningPoint;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgNextWarningPointStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_NEXTWARNINGPOINTSTATUS;}
};

class rgfi_tclMsgHorizonDeltaDistanceGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgHorizonDeltaDistanceGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgHorizonDeltaDistanceGet& operator=(const rgfi_tclMsgHorizonDeltaDistanceGet& coRef);
   rgfi_tclMsgHorizonDeltaDistanceGet(const rgfi_tclMsgHorizonDeltaDistanceGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgHorizonDeltaDistanceGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_HORIZONDELTADISTANCEGET;}
};

class rgfi_tclMsgHorizonDeltaDistanceStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgHorizonDeltaDistanceStatus():ReleaseId(0),DeltaDistance() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgHorizonDeltaDistanceStatus& operator=(const rgfi_tclMsgHorizonDeltaDistanceStatus& coRef);
   rgfi_tclMsgHorizonDeltaDistanceStatus(const rgfi_tclMsgHorizonDeltaDistanceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   fi_tcl_s32_Meter DeltaDistance;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgHorizonDeltaDistanceStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_HORIZONDELTADISTANCESTATUS;}
};

class rgfi_tclMsgHorizonEventsGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgHorizonEventsGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgHorizonEventsGet& operator=(const rgfi_tclMsgHorizonEventsGet& coRef);
   rgfi_tclMsgHorizonEventsGet(const rgfi_tclMsgHorizonEventsGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgHorizonEventsGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_HORIZONEVENTSGET;}
};

class rgfi_tclMsgHorizonEventsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgHorizonEventsStatus():ReleaseId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgHorizonEventsStatus& operator=(const rgfi_tclMsgHorizonEventsStatus& coRef);
   rgfi_tclMsgHorizonEventsStatus(const rgfi_tclMsgHorizonEventsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   std::vector<fi_tcl_HorizonEvent, std::allocator<fi_tcl_HorizonEvent> > HorizonEventList;
   std::vector<fi_tcl_TMProgramService, std::allocator<fi_tcl_TMProgramService> > ProgramServiceList;
   std::vector<fi_tcl_TMServiceProvider, std::allocator<fi_tcl_TMServiceProvider> > ServiceProviderList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgHorizonEventsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_HORIZONEVENTSSTATUS;}
};

class rgfi_tclMsgWarningsOnHorizonModeGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgWarningsOnHorizonModeGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgWarningsOnHorizonModeGet& operator=(const rgfi_tclMsgWarningsOnHorizonModeGet& coRef);
   rgfi_tclMsgWarningsOnHorizonModeGet(const rgfi_tclMsgWarningsOnHorizonModeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgWarningsOnHorizonModeGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_WARNINGSONHORIZONMODEGET;}
};

class rgfi_tclMsgWarningsOnHorizonModeStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgWarningsOnHorizonModeStatus():WarningsOnHorizonMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgWarningsOnHorizonModeStatus& operator=(const rgfi_tclMsgWarningsOnHorizonModeStatus& coRef);
   rgfi_tclMsgWarningsOnHorizonModeStatus(const rgfi_tclMsgWarningsOnHorizonModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_WarningsOnHorizonMode WarningsOnHorizonMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgWarningsOnHorizonModeStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_WARNINGSONHORIZONMODESTATUS;}
};

class rgfi_tclMsgDriverSpeedAdviceGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDriverSpeedAdviceGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDriverSpeedAdviceGet& operator=(const rgfi_tclMsgDriverSpeedAdviceGet& coRef);
   rgfi_tclMsgDriverSpeedAdviceGet(const rgfi_tclMsgDriverSpeedAdviceGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDriverSpeedAdviceGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DRIVERSPEEDADVICEGET;}
};

class rgfi_tclMsgDriverSpeedAdviceUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDriverSpeedAdviceUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDriverSpeedAdviceUpReg& operator=(const rgfi_tclMsgDriverSpeedAdviceUpReg& coRef);
   rgfi_tclMsgDriverSpeedAdviceUpReg(const rgfi_tclMsgDriverSpeedAdviceUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDriverSpeedAdviceUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DRIVERSPEEDADVICEUPREG;}
};

class rgfi_tclMsgDriverSpeedAdviceRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDriverSpeedAdviceRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDriverSpeedAdviceRelUpReg& operator=(const rgfi_tclMsgDriverSpeedAdviceRelUpReg& coRef);
   rgfi_tclMsgDriverSpeedAdviceRelUpReg(const rgfi_tclMsgDriverSpeedAdviceRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDriverSpeedAdviceRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DRIVERSPEEDADVICERELUPREG;}
};

class rgfi_tclMsgDriverSpeedAdviceStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDriverSpeedAdviceStatus():AdviceType(),DriverActionFeedback(),EcoProfit(),TargetSpeed(),CausingEvent(),EventId(),DistanceToStartOfEvent(),DistanceToEndOfEvent() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDriverSpeedAdviceStatus& operator=(const rgfi_tclMsgDriverSpeedAdviceStatus& coRef);
   rgfi_tclMsgDriverSpeedAdviceStatus(const rgfi_tclMsgDriverSpeedAdviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DriverAdviceType AdviceType;
   fi_tcl_e8_DriverActionFeedback DriverActionFeedback;
   fi_tcl_u8_Percent EcoProfit;
   fi_tcl_s16_KmPerHour TargetSpeed;
   fi_tcl_TrafficSignElement CausingEvent;
   fi_tcl_TEAEventID EventId;
   fi_tcl_s32_Meter DistanceToStartOfEvent;
   fi_tcl_s32_Meter DistanceToEndOfEvent;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDriverSpeedAdviceStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DRIVERSPEEDADVICESTATUS;}
};

class rgfi_tclMsgMultiMediaInformationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgMultiMediaInformationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgMultiMediaInformationGet& operator=(const rgfi_tclMsgMultiMediaInformationGet& coRef);
   rgfi_tclMsgMultiMediaInformationGet(const rgfi_tclMsgMultiMediaInformationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgMultiMediaInformationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_MULTIMEDIAINFORMATIONGET;}
};

class rgfi_tclMsgMultiMediaInformationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgMultiMediaInformationStatus():ReleaseNumber(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgMultiMediaInformationStatus& operator=(const rgfi_tclMsgMultiMediaInformationStatus& coRef);
   rgfi_tclMsgMultiMediaInformationStatus(const rgfi_tclMsgMultiMediaInformationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   std::vector<fi_tcl_MultiMediaElement, std::allocator<fi_tcl_MultiMediaElement> > MultiMediaElementList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgMultiMediaInformationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_MULTIMEDIAINFORMATIONSTATUS;}
};

class rgfi_tclMsgFunctionalityStatesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgFunctionalityStatesGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgFunctionalityStatesGet& operator=(const rgfi_tclMsgFunctionalityStatesGet& coRef);
   rgfi_tclMsgFunctionalityStatesGet(const rgfi_tclMsgFunctionalityStatesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgFunctionalityStatesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_FUNCTIONALITYSTATESGET;}
};

class rgfi_tclMsgFunctionalityStatesSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgFunctionalityStatesSet():RouteInfoAcoustic(),RouteInfoSymbolic(),DestinationInfoAcoustic(),DestinationInfoSymbolic(),DrivingRecommendationAcoustic(),DrivingRecommendationSymbolic(),CorridorInfoAcoustic(),CorridorInfoSymbolic(),HorizonInfoTrafficMessageAcoustic(),HorizonInfoTrafficMessageSymbolic(),HorizonInfoSpeedLimitAcoustic(),HorizonInfoSpeedLimitSymbolic(),HorizonInfoWarningSignAcoustic(),HorizonInfoWarningSignSymbolic(),HorizonInfoPOIAcoustic(),HorizonInfoPOISymbolic(),HorizonInfoRoadAttributeAcoustic(),HorizonInfoRoadAttributeSymbolic(),HorizonInfoCurveAcoustic(),HorizonInfoCurveSymbolic(),HorizonInfoUPOI(),DriverSpeedAdvice(),HorizonEvents() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgFunctionalityStatesSet& operator=(const rgfi_tclMsgFunctionalityStatesSet& coRef);
   rgfi_tclMsgFunctionalityStatesSet(const rgfi_tclMsgFunctionalityStatesSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_FunctionalityGroupRouteInfo RouteInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupRouteInfo RouteInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupDestinationInfo DestinationInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupDestinationInfo DestinationInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupDrivingRecommendation DrivingRecommendationAcoustic;
   fi_tcl_b16_FunctionalityGroupDrivingRecommendation DrivingRecommendationSymbolic;
   fi_tcl_b16_FunctionalityGroupCorridorInfo CorridorInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupCorridorInfo CorridorInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage HorizonInfoTrafficMessageAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage HorizonInfoTrafficMessageSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit HorizonInfoSpeedLimitAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit HorizonInfoSpeedLimitSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign HorizonInfoWarningSignAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign HorizonInfoWarningSignSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoPOI HorizonInfoPOIAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoPOI HorizonInfoPOISymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute HorizonInfoRoadAttributeAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute HorizonInfoRoadAttributeSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoCurve HorizonInfoCurveAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoCurve HorizonInfoCurveSymbolic;
   fi_tcl_UPOI_CategoryConfigurationList HorizonInfoUPOI;
   fi_tcl_DriverSpeedAdviceConfiguration DriverSpeedAdvice;
   fi_tcl_HorizonEventsFilter HorizonEvents;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgFunctionalityStatesSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_FUNCTIONALITYSTATESSET;}
};

class rgfi_tclMsgFunctionalityStatesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgFunctionalityStatesStatus():RouteInfoAcoustic(),RouteInfoSymbolic(),DestinationInfoAcoustic(),DestinationInfoSymbolic(),DrivingRecommendationAcoustic(),DrivingRecommendationSymbolic(),CorridorInfoAcoustic(),CorridorInfoSymbolic(),HorizonInfoTrafficMessageAcoustic(),HorizonInfoTrafficMessageSymbolic(),HorizonInfoSpeedLimitAcoustic(),HorizonInfoSpeedLimitSymbolic(),HorizonInfoWarningSignAcoustic(),HorizonInfoWarningSignSymbolic(),HorizonInfoPOIAcoustic(),HorizonInfoPOISymbolic(),HorizonInfoRoadAttributeAcoustic(),HorizonInfoRoadAttributeSymbolic(),HorizonInfoCurveAcoustic(),HorizonInfoCurveSymbolic(),HorizonInfoUPOI(),DriverSpeedAdvice(),HorizonEvents() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgFunctionalityStatesStatus& operator=(const rgfi_tclMsgFunctionalityStatesStatus& coRef);
   rgfi_tclMsgFunctionalityStatesStatus(const rgfi_tclMsgFunctionalityStatesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_FunctionalityGroupRouteInfo RouteInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupRouteInfo RouteInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupDestinationInfo DestinationInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupDestinationInfo DestinationInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupDrivingRecommendation DrivingRecommendationAcoustic;
   fi_tcl_b16_FunctionalityGroupDrivingRecommendation DrivingRecommendationSymbolic;
   fi_tcl_b16_FunctionalityGroupCorridorInfo CorridorInfoAcoustic;
   fi_tcl_b16_FunctionalityGroupCorridorInfo CorridorInfoSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage HorizonInfoTrafficMessageAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage HorizonInfoTrafficMessageSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit HorizonInfoSpeedLimitAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit HorizonInfoSpeedLimitSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign HorizonInfoWarningSignAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign HorizonInfoWarningSignSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoPOI HorizonInfoPOIAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoPOI HorizonInfoPOISymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute HorizonInfoRoadAttributeAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute HorizonInfoRoadAttributeSymbolic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoCurve HorizonInfoCurveAcoustic;
   fi_tcl_b16_FunctionalityGroupHorizonInfoCurve HorizonInfoCurveSymbolic;
   fi_tcl_UPOI_CategoryConfigurationList HorizonInfoUPOI;
   fi_tcl_DriverSpeedAdviceConfiguration DriverSpeedAdvice;
   fi_tcl_HorizonEventsFilter HorizonEvents;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgFunctionalityStatesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_FUNCTIONALITYSTATESSTATUS;}
};

class rgfi_tclMsgSpeedLimitExceedingConfigurationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeedLimitExceedingConfigurationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeedLimitExceedingConfigurationGet& operator=(const rgfi_tclMsgSpeedLimitExceedingConfigurationGet& coRef);
   rgfi_tclMsgSpeedLimitExceedingConfigurationGet(const rgfi_tclMsgSpeedLimitExceedingConfigurationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeedLimitExceedingConfigurationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEEDLIMITEXCEEDINGCONFIGURATIONGET;}
};

class rgfi_tclMsgSpeedLimitExceedingConfigurationSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeedLimitExceedingConfigurationSet():AcceptedSpeedLimitExceedingBuiltUp(),AcceptedSpeedLimitExceedingNonBuiltUp() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeedLimitExceedingConfigurationSet& operator=(const rgfi_tclMsgSpeedLimitExceedingConfigurationSet& coRef);
   rgfi_tclMsgSpeedLimitExceedingConfigurationSet(const rgfi_tclMsgSpeedLimitExceedingConfigurationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedLimitParameter AcceptedSpeedLimitExceedingBuiltUp;
   fi_tcl_SpeedLimitParameter AcceptedSpeedLimitExceedingNonBuiltUp;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeedLimitExceedingConfigurationSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEEDLIMITEXCEEDINGCONFIGURATIONSET;}
};

class rgfi_tclMsgSpeedLimitExceedingConfigurationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeedLimitExceedingConfigurationStatus():AcceptedSpeedLimitExceedingBuiltUp(),AcceptedSpeedLimitExceedingNonBuiltUp() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeedLimitExceedingConfigurationStatus& operator=(const rgfi_tclMsgSpeedLimitExceedingConfigurationStatus& coRef);
   rgfi_tclMsgSpeedLimitExceedingConfigurationStatus(const rgfi_tclMsgSpeedLimitExceedingConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_SpeedLimitParameter AcceptedSpeedLimitExceedingBuiltUp;
   fi_tcl_SpeedLimitParameter AcceptedSpeedLimitExceedingNonBuiltUp;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeedLimitExceedingConfigurationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEEDLIMITEXCEEDINGCONFIGURATIONSTATUS;}
};

class rgfi_tclMsgCoastingAdviceConfigurationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCoastingAdviceConfigurationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCoastingAdviceConfigurationGet& operator=(const rgfi_tclMsgCoastingAdviceConfigurationGet& coRef);
   rgfi_tclMsgCoastingAdviceConfigurationGet(const rgfi_tclMsgCoastingAdviceConfigurationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCoastingAdviceConfigurationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONGET;}
};

class rgfi_tclMsgCoastingAdviceConfigurationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCoastingAdviceConfigurationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCoastingAdviceConfigurationUpReg& operator=(const rgfi_tclMsgCoastingAdviceConfigurationUpReg& coRef);
   rgfi_tclMsgCoastingAdviceConfigurationUpReg(const rgfi_tclMsgCoastingAdviceConfigurationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCoastingAdviceConfigurationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONUPREG;}
};

class rgfi_tclMsgCoastingAdviceConfigurationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCoastingAdviceConfigurationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCoastingAdviceConfigurationRelUpReg& operator=(const rgfi_tclMsgCoastingAdviceConfigurationRelUpReg& coRef);
   rgfi_tclMsgCoastingAdviceConfigurationRelUpReg(const rgfi_tclMsgCoastingAdviceConfigurationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCoastingAdviceConfigurationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONRELUPREG;}
};

class rgfi_tclMsgCoastingAdviceConfigurationSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCoastingAdviceConfigurationSet():AcceptableTimeLoss() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCoastingAdviceConfigurationSet& operator=(const rgfi_tclMsgCoastingAdviceConfigurationSet& coRef);
   rgfi_tclMsgCoastingAdviceConfigurationSet(const rgfi_tclMsgCoastingAdviceConfigurationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u8_Percent AcceptableTimeLoss;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCoastingAdviceConfigurationSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONSET;}
};

class rgfi_tclMsgCoastingAdviceConfigurationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCoastingAdviceConfigurationStatus():AcceptableTimeLoss() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCoastingAdviceConfigurationStatus& operator=(const rgfi_tclMsgCoastingAdviceConfigurationStatus& coRef);
   rgfi_tclMsgCoastingAdviceConfigurationStatus(const rgfi_tclMsgCoastingAdviceConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u8_Percent AcceptableTimeLoss;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCoastingAdviceConfigurationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_COASTINGADVICECONFIGURATIONSTATUS;}
};

class rgfi_tclMsgSpeedAdviceConfigurationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeedAdviceConfigurationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeedAdviceConfigurationGet& operator=(const rgfi_tclMsgSpeedAdviceConfigurationGet& coRef);
   rgfi_tclMsgSpeedAdviceConfigurationGet(const rgfi_tclMsgSpeedAdviceConfigurationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeedAdviceConfigurationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONGET;}
};

class rgfi_tclMsgSpeedAdviceConfigurationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeedAdviceConfigurationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeedAdviceConfigurationUpReg& operator=(const rgfi_tclMsgSpeedAdviceConfigurationUpReg& coRef);
   rgfi_tclMsgSpeedAdviceConfigurationUpReg(const rgfi_tclMsgSpeedAdviceConfigurationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeedAdviceConfigurationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONUPREG;}
};

class rgfi_tclMsgSpeedAdviceConfigurationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeedAdviceConfigurationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeedAdviceConfigurationRelUpReg& operator=(const rgfi_tclMsgSpeedAdviceConfigurationRelUpReg& coRef);
   rgfi_tclMsgSpeedAdviceConfigurationRelUpReg(const rgfi_tclMsgSpeedAdviceConfigurationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeedAdviceConfigurationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONRELUPREG;}
};

class rgfi_tclMsgSpeedAdviceConfigurationSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeedAdviceConfigurationSet():CurveSensitivity(0),BrakeTiming(0),AcceptedCoastingTimeLoss() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeedAdviceConfigurationSet& operator=(const rgfi_tclMsgSpeedAdviceConfigurationSet& coRef);
   rgfi_tclMsgSpeedAdviceConfigurationSet(const rgfi_tclMsgSpeedAdviceConfigurationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_LocDepSpeedLimitExceeding, std::allocator<fi_tcl_LocDepSpeedLimitExceeding> > AcceptedSpeedLimitExceedingList;
   tS8 CurveSensitivity;
   tS8 BrakeTiming;
   fi_tcl_u8_Percent AcceptedCoastingTimeLoss;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeedAdviceConfigurationSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONSET;}
};

class rgfi_tclMsgSpeedAdviceConfigurationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeedAdviceConfigurationStatus():CurveSensitivity(0),BrakeTiming(0),AcceptedCoastingTimeLoss() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeedAdviceConfigurationStatus& operator=(const rgfi_tclMsgSpeedAdviceConfigurationStatus& coRef);
   rgfi_tclMsgSpeedAdviceConfigurationStatus(const rgfi_tclMsgSpeedAdviceConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_LocDepSpeedLimitExceeding, std::allocator<fi_tcl_LocDepSpeedLimitExceeding> > AcceptedSpeedLimitExceedingList;
   tS8 CurveSensitivity;
   tS8 BrakeTiming;
   fi_tcl_u8_Percent AcceptedCoastingTimeLoss;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeedAdviceConfigurationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEEDADVICECONFIGURATIONSTATUS;}
};

class rgfi_tclMsgCurrentLaneInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCurrentLaneInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCurrentLaneInfoGet& operator=(const rgfi_tclMsgCurrentLaneInfoGet& coRef);
   rgfi_tclMsgCurrentLaneInfoGet(const rgfi_tclMsgCurrentLaneInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCurrentLaneInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CURRENTLANEINFOGET;}
};

class rgfi_tclMsgCurrentLaneInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCurrentLaneInfoStatus():ReleaseNumber(0),TrafficSense(),LaneInfoElement() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCurrentLaneInfoStatus& operator=(const rgfi_tclMsgCurrentLaneInfoStatus& coRef);
   rgfi_tclMsgCurrentLaneInfoStatus(const rgfi_tclMsgCurrentLaneInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseNumber;
   fi_tcl_e8_SideInfo TrafficSense;
   fi_tcl_LaneInfoElement LaneInfoElement;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCurrentLaneInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CURRENTLANEINFOSTATUS;}
};

class rgfi_tclMsgCurveWarningConfigurationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCurveWarningConfigurationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCurveWarningConfigurationGet& operator=(const rgfi_tclMsgCurveWarningConfigurationGet& coRef);
   rgfi_tclMsgCurveWarningConfigurationGet(const rgfi_tclMsgCurveWarningConfigurationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCurveWarningConfigurationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CURVEWARNINGCONFIGURATIONGET;}
};

class rgfi_tclMsgCurveWarningConfigurationSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCurveWarningConfigurationSet():Sensitivity(0),Timing(0),AcousticalInformationAcceleration(0),AcousticalWarningAcceleration(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCurveWarningConfigurationSet& operator=(const rgfi_tclMsgCurveWarningConfigurationSet& coRef);
   rgfi_tclMsgCurveWarningConfigurationSet(const rgfi_tclMsgCurveWarningConfigurationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS8 Sensitivity;
   tS8 Timing;
   tF32 AcousticalInformationAcceleration;
   tF32 AcousticalWarningAcceleration;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCurveWarningConfigurationSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CURVEWARNINGCONFIGURATIONSET;}
};

class rgfi_tclMsgCurveWarningConfigurationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgCurveWarningConfigurationStatus():Sensitivity(0),Timing(0),AcousticalInformationAcceleration(0),AcousticalWarningAcceleration(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgCurveWarningConfigurationStatus& operator=(const rgfi_tclMsgCurveWarningConfigurationStatus& coRef);
   rgfi_tclMsgCurveWarningConfigurationStatus(const rgfi_tclMsgCurveWarningConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tS8 Sensitivity;
   tS8 Timing;
   tF32 AcousticalInformationAcceleration;
   tF32 AcousticalWarningAcceleration;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgCurveWarningConfigurationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_CURVEWARNINGCONFIGURATIONSTATUS;}
};

class rgfi_tclMsgUPOIAnnouncementCategoriesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgUPOIAnnouncementCategoriesGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgUPOIAnnouncementCategoriesGet& operator=(const rgfi_tclMsgUPOIAnnouncementCategoriesGet& coRef);
   rgfi_tclMsgUPOIAnnouncementCategoriesGet(const rgfi_tclMsgUPOIAnnouncementCategoriesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgUPOIAnnouncementCategoriesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_UPOIANNOUNCEMENTCATEGORIESGET;}
};

class rgfi_tclMsgUPOIAnnouncementCategoriesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgUPOIAnnouncementCategoriesStatus():Categories() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgUPOIAnnouncementCategoriesStatus& operator=(const rgfi_tclMsgUPOIAnnouncementCategoriesStatus& coRef);
   rgfi_tclMsgUPOIAnnouncementCategoriesStatus(const rgfi_tclMsgUPOIAnnouncementCategoriesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_FilterList Categories;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgUPOIAnnouncementCategoriesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_UPOIANNOUNCEMENTCATEGORIESSTATUS;}
};

class rgfi_tclMsgLastProcessedRouteInfoListUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedRouteInfoListUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedRouteInfoListUpReg& operator=(const rgfi_tclMsgLastProcessedRouteInfoListUpReg& coRef);
   rgfi_tclMsgLastProcessedRouteInfoListUpReg(const rgfi_tclMsgLastProcessedRouteInfoListUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedRouteInfoListUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDROUTEINFOLISTUPREG;}
};

class rgfi_tclMsgLastProcessedRouteInfoListRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedRouteInfoListRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedRouteInfoListRelUpReg& operator=(const rgfi_tclMsgLastProcessedRouteInfoListRelUpReg& coRef);
   rgfi_tclMsgLastProcessedRouteInfoListRelUpReg(const rgfi_tclMsgLastProcessedRouteInfoListRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedRouteInfoListRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDROUTEINFOLISTRELUPREG;}
};

class rgfi_tclMsgLastProcessedRouteInfoListGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedRouteInfoListGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedRouteInfoListGet& operator=(const rgfi_tclMsgLastProcessedRouteInfoListGet& coRef);
   rgfi_tclMsgLastProcessedRouteInfoListGet(const rgfi_tclMsgLastProcessedRouteInfoListGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedRouteInfoListGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDROUTEINFOLISTGET;}
};

class rgfi_tclMsgLastProcessedRouteInfoListStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedRouteInfoListStatus():TripHandle(),RouteHandle(),RouteInfoId(0),RouteInfoCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedRouteInfoListStatus& operator=(const rgfi_tclMsgLastProcessedRouteInfoListStatus& coRef);
   rgfi_tclMsgLastProcessedRouteInfoListStatus(const rgfi_tclMsgLastProcessedRouteInfoListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   tU32 RouteInfoId;
   tU16 RouteInfoCounter;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedRouteInfoListStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDROUTEINFOLISTSTATUS;}
};

class rgfi_tclMsgLastProcessedTEAHorizonUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedTEAHorizonUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedTEAHorizonUpReg& operator=(const rgfi_tclMsgLastProcessedTEAHorizonUpReg& coRef);
   rgfi_tclMsgLastProcessedTEAHorizonUpReg(const rgfi_tclMsgLastProcessedTEAHorizonUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedTEAHorizonUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAHORIZONUPREG;}
};

class rgfi_tclMsgLastProcessedTEAHorizonRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedTEAHorizonRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedTEAHorizonRelUpReg& operator=(const rgfi_tclMsgLastProcessedTEAHorizonRelUpReg& coRef);
   rgfi_tclMsgLastProcessedTEAHorizonRelUpReg(const rgfi_tclMsgLastProcessedTEAHorizonRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedTEAHorizonRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAHORIZONRELUPREG;}
};

class rgfi_tclMsgLastProcessedTEAHorizonGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedTEAHorizonGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedTEAHorizonGet& operator=(const rgfi_tclMsgLastProcessedTEAHorizonGet& coRef);
   rgfi_tclMsgLastProcessedTEAHorizonGet(const rgfi_tclMsgLastProcessedTEAHorizonGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedTEAHorizonGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAHORIZONGET;}
};

class rgfi_tclMsgLastProcessedTEAHorizonStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedTEAHorizonStatus():TEAHorizonReleaseId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedTEAHorizonStatus& operator=(const rgfi_tclMsgLastProcessedTEAHorizonStatus& coRef);
   rgfi_tclMsgLastProcessedTEAHorizonStatus(const rgfi_tclMsgLastProcessedTEAHorizonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 TEAHorizonReleaseId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedTEAHorizonStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAHORIZONSTATUS;}
};

class rgfi_tclMsgLastProcessedTEAMPPUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedTEAMPPUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedTEAMPPUpReg& operator=(const rgfi_tclMsgLastProcessedTEAMPPUpReg& coRef);
   rgfi_tclMsgLastProcessedTEAMPPUpReg(const rgfi_tclMsgLastProcessedTEAMPPUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedTEAMPPUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAMPPUPREG;}
};

class rgfi_tclMsgLastProcessedTEAMPPRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedTEAMPPRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedTEAMPPRelUpReg& operator=(const rgfi_tclMsgLastProcessedTEAMPPRelUpReg& coRef);
   rgfi_tclMsgLastProcessedTEAMPPRelUpReg(const rgfi_tclMsgLastProcessedTEAMPPRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedTEAMPPRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAMPPRELUPREG;}
};

class rgfi_tclMsgLastProcessedTEAMPPGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedTEAMPPGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedTEAMPPGet& operator=(const rgfi_tclMsgLastProcessedTEAMPPGet& coRef);
   rgfi_tclMsgLastProcessedTEAMPPGet(const rgfi_tclMsgLastProcessedTEAMPPGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedTEAMPPGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAMPPGET;}
};

class rgfi_tclMsgLastProcessedTEAMPPStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastProcessedTEAMPPStatus():TEAMPPReleaseId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastProcessedTEAMPPStatus& operator=(const rgfi_tclMsgLastProcessedTEAMPPStatus& coRef);
   rgfi_tclMsgLastProcessedTEAMPPStatus(const rgfi_tclMsgLastProcessedTEAMPPStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 TEAMPPReleaseId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastProcessedTEAMPPStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTPROCESSEDTEAMPPSTATUS;}
};

class rgfi_tclMsgSpeechLanguageGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeechLanguageGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeechLanguageGet& operator=(const rgfi_tclMsgSpeechLanguageGet& coRef);
   rgfi_tclMsgSpeechLanguageGet(const rgfi_tclMsgSpeechLanguageGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeechLanguageGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEECHLANGUAGEGET;}
};

class rgfi_tclMsgSpeechLanguageStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeechLanguageStatus():LanguageID(),Status(),SpeakerName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeechLanguageStatus& operator=(const rgfi_tclMsgSpeechLanguageStatus& coRef);
   rgfi_tclMsgSpeechLanguageStatus(const rgfi_tclMsgSpeechLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageID LanguageID;
   fi_tcl_e8_SpeechStatus Status;
   fi_tclString SpeakerName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeechLanguageStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEECHLANGUAGESTATUS;}
};

class rgfi_tclMsgSpeechMetricSystemGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeechMetricSystemGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeechMetricSystemGet& operator=(const rgfi_tclMsgSpeechMetricSystemGet& coRef);
   rgfi_tclMsgSpeechMetricSystemGet(const rgfi_tclMsgSpeechMetricSystemGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeechMetricSystemGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEECHMETRICSYSTEMGET;}
};

class rgfi_tclMsgSpeechMetricSystemStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeechMetricSystemStatus():MetricSystem_Nav() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeechMetricSystemStatus& operator=(const rgfi_tclMsgSpeechMetricSystemStatus& coRef);
   rgfi_tclMsgSpeechMetricSystemStatus(const rgfi_tclMsgSpeechMetricSystemStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MetricSystem MetricSystem_Nav;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeechMetricSystemStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEECHMETRICSYSTEMSTATUS;}
};

class rgfi_tclMsgSpeechFeatureGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeechFeatureGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeechFeatureGet& operator=(const rgfi_tclMsgSpeechFeatureGet& coRef);
   rgfi_tclMsgSpeechFeatureGet(const rgfi_tclMsgSpeechFeatureGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeechFeatureGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEECHFEATUREGET;}
};

class rgfi_tclMsgSpeechFeatureStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgSpeechFeatureStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgSpeechFeatureStatus& operator=(const rgfi_tclMsgSpeechFeatureStatus& coRef);
   rgfi_tclMsgSpeechFeatureStatus(const rgfi_tclMsgSpeechFeatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e8_SpeechFeature, std::allocator<fi_tcl_e8_SpeechFeature> > CurrentSpeechFeature;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgSpeechFeatureStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_SPEECHFEATURESTATUS;}
};

class rgfi_tclMsgLastDrivingRecommendationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastDrivingRecommendationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastDrivingRecommendationGet& operator=(const rgfi_tclMsgLastDrivingRecommendationGet& coRef);
   rgfi_tclMsgLastDrivingRecommendationGet(const rgfi_tclMsgLastDrivingRecommendationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastDrivingRecommendationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTDRIVINGRECOMMENDATIONGET;}
};

class rgfi_tclMsgLastDrivingRecommendationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgLastDrivingRecommendationStatus():SpeechLanguage(),DrivingRecommendation() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgLastDrivingRecommendationStatus& operator=(const rgfi_tclMsgLastDrivingRecommendationStatus& coRef);
   rgfi_tclMsgLastDrivingRecommendationStatus(const rgfi_tclMsgLastDrivingRecommendationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LanguageID SpeechLanguage;
   fi_tclString DrivingRecommendation;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgLastDrivingRecommendationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_LASTDRIVINGRECOMMENDATIONSTATUS;}
};

class rgfi_tclMsgDataProcessedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDataProcessedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDataProcessedUpReg& operator=(const rgfi_tclMsgDataProcessedUpReg& coRef);
   rgfi_tclMsgDataProcessedUpReg(const rgfi_tclMsgDataProcessedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDataProcessedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DATAPROCESSEDUPREG;}
};

class rgfi_tclMsgDataProcessedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDataProcessedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDataProcessedRelUpReg& operator=(const rgfi_tclMsgDataProcessedRelUpReg& coRef);
   rgfi_tclMsgDataProcessedRelUpReg(const rgfi_tclMsgDataProcessedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDataProcessedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DATAPROCESSEDRELUPREG;}
};

class rgfi_tclMsgDataProcessedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgDataProcessedStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgDataProcessedStatus& operator=(const rgfi_tclMsgDataProcessedStatus& coRef);
   rgfi_tclMsgDataProcessedStatus(const rgfi_tclMsgDataProcessedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgDataProcessedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_DATAPROCESSEDSTATUS;}
};

class rgfi_tclMsgPredictiveCCStateGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgPredictiveCCStateGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgPredictiveCCStateGet& operator=(const rgfi_tclMsgPredictiveCCStateGet& coRef);
   rgfi_tclMsgPredictiveCCStateGet(const rgfi_tclMsgPredictiveCCStateGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgPredictiveCCStateGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_PREDICTIVECCSTATEGET;}
};

class rgfi_tclMsgPredictiveCCStateUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgPredictiveCCStateUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgPredictiveCCStateUpReg& operator=(const rgfi_tclMsgPredictiveCCStateUpReg& coRef);
   rgfi_tclMsgPredictiveCCStateUpReg(const rgfi_tclMsgPredictiveCCStateUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgPredictiveCCStateUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_PREDICTIVECCSTATEUPREG;}
};

class rgfi_tclMsgPredictiveCCStateRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgPredictiveCCStateRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgPredictiveCCStateRelUpReg& operator=(const rgfi_tclMsgPredictiveCCStateRelUpReg& coRef);
   rgfi_tclMsgPredictiveCCStateRelUpReg(const rgfi_tclMsgPredictiveCCStateRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgPredictiveCCStateRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_PREDICTIVECCSTATERELUPREG;}
};

class rgfi_tclMsgPredictiveCCStateStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgPredictiveCCStateStatus():IsCruiseControlActive(0),OperationMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgPredictiveCCStateStatus& operator=(const rgfi_tclMsgPredictiveCCStateStatus& coRef);
   rgfi_tclMsgPredictiveCCStateStatus(const rgfi_tclMsgPredictiveCCStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool IsCruiseControlActive;
   fi_tcl_b32_PredictiveCCMode OperationMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgPredictiveCCStateStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_PREDICTIVECCSTATESTATUS;}
};

class rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg& operator=(const rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg& coRef);
   rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg(const rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_PREDICTIVECCSPEEDRECOMMENDATIONUPREG;}
};

class rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg& operator=(const rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg& coRef);
   rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg(const rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_PREDICTIVECCSPEEDRECOMMENDATIONRELUPREG;}
};

class rgfi_tclMsgPredictiveCCSpeedRecommendationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgPredictiveCCSpeedRecommendationStatus():ControlBits(),TargetSpeed(),Distance(),RecuperationPower() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgPredictiveCCSpeedRecommendationStatus& operator=(const rgfi_tclMsgPredictiveCCSpeedRecommendationStatus& coRef);
   rgfi_tclMsgPredictiveCCSpeedRecommendationStatus(const rgfi_tclMsgPredictiveCCSpeedRecommendationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b32_PredictiveCC_ControlBits ControlBits;
   fi_tcl_s16_KmPerHour TargetSpeed;
   fi_tcl_s32_Meter Distance;
   fi_tcl_s32_Watt RecuperationPower;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgPredictiveCCSpeedRecommendationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_PREDICTIVECCSPEEDRECOMMENDATIONSTATUS;}
};

class rgfi_tclMsgTrafficAnnouncementConfigurationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTrafficAnnouncementConfigurationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTrafficAnnouncementConfigurationUpReg& operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationUpReg& coRef);
   rgfi_tclMsgTrafficAnnouncementConfigurationUpReg(const rgfi_tclMsgTrafficAnnouncementConfigurationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONUPREG;}
};

class rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg& operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg& coRef);
   rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg(const rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONRELUPREG;}
};

class rgfi_tclMsgTrafficAnnouncementConfigurationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTrafficAnnouncementConfigurationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTrafficAnnouncementConfigurationGet& operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationGet& coRef);
   rgfi_tclMsgTrafficAnnouncementConfigurationGet(const rgfi_tclMsgTrafficAnnouncementConfigurationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONGET;}
};

class rgfi_tclMsgTrafficAnnouncementConfigurationSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTrafficAnnouncementConfigurationSet():WarningDistanceThreshold() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTrafficAnnouncementConfigurationSet& operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationSet& coRef);
   rgfi_tclMsgTrafficAnnouncementConfigurationSet(const rgfi_tclMsgTrafficAnnouncementConfigurationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Meter WarningDistanceThreshold;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONSET;}
};

class rgfi_tclMsgTrafficAnnouncementConfigurationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTrafficAnnouncementConfigurationStatus():WarningDistanceThreshold() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTrafficAnnouncementConfigurationStatus& operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationStatus& coRef);
   rgfi_tclMsgTrafficAnnouncementConfigurationStatus(const rgfi_tclMsgTrafficAnnouncementConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Meter WarningDistanceThreshold;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TRAFFICANNOUNCEMENTCONFIGURATIONSTATUS;}
};

class rgfi_tclMsgTM_HorizonEvents_FilterUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTM_HorizonEvents_FilterUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTM_HorizonEvents_FilterUpReg& operator=(const rgfi_tclMsgTM_HorizonEvents_FilterUpReg& coRef);
   rgfi_tclMsgTM_HorizonEvents_FilterUpReg(const rgfi_tclMsgTM_HorizonEvents_FilterUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTM_HorizonEvents_FilterUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERUPREG;}
};

class rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg& operator=(const rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg& coRef);
   rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg(const rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERRELUPREG;}
};

class rgfi_tclMsgTM_HorizonEvents_FilterGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTM_HorizonEvents_FilterGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTM_HorizonEvents_FilterGet& operator=(const rgfi_tclMsgTM_HorizonEvents_FilterGet& coRef);
   rgfi_tclMsgTM_HorizonEvents_FilterGet(const rgfi_tclMsgTM_HorizonEvents_FilterGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTM_HorizonEvents_FilterGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERGET;}
};

class rgfi_tclMsgTM_HorizonEvents_FilterSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTM_HorizonEvents_FilterSet():ReleaseId(0),NEVList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTM_HorizonEvents_FilterSet& operator=(const rgfi_tclMsgTM_HorizonEvents_FilterSet& coRef);
   rgfi_tclMsgTM_HorizonEvents_FilterSet(const rgfi_tclMsgTM_HorizonEvents_FilterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 ReleaseId;
   fi_tcl_NEVList NEVList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTM_HorizonEvents_FilterSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERSET;}
};

class rgfi_tclMsgTM_HorizonEvents_FilterStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgTM_HorizonEvents_FilterStatus():ReleaseId(0),NEVList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgTM_HorizonEvents_FilterStatus& operator=(const rgfi_tclMsgTM_HorizonEvents_FilterStatus& coRef);
   rgfi_tclMsgTM_HorizonEvents_FilterStatus(const rgfi_tclMsgTM_HorizonEvents_FilterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 ReleaseId;
   fi_tcl_NEVList NEVList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgTM_HorizonEvents_FilterStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_TM_HORIZONEVENTS_FILTERSTATUS;}
};

class rgfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgEngineeringTextGet& operator=(const rgfi_tclMsgEngineeringTextGet& coRef);
   rgfi_tclMsgEngineeringTextGet(const rgfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class rgfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgEngineeringTextUpReg& operator=(const rgfi_tclMsgEngineeringTextUpReg& coRef);
   rgfi_tclMsgEngineeringTextUpReg(const rgfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class rgfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgEngineeringTextRelUpReg& operator=(const rgfi_tclMsgEngineeringTextRelUpReg& coRef);
   rgfi_tclMsgEngineeringTextRelUpReg(const rgfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class rgfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rgfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rgfi_tclMsgEngineeringTextStatus& operator=(const rgfi_tclMsgEngineeringTextStatus& coRef);
   rgfi_tclMsgEngineeringTextStatus(const rgfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rgfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rgfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
