#ifndef RGFILANGUAGE_HEADER
#define RGFILANGUAGE_HEADER

class rgfi_tclInContext;
class rgfi_tclOutContext;
class rgfi_tclVisitorBase;

class MY_DECL rgfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  rgfi_tclDescription(fi_tclInContext* poIn, rgfi_tclVisitorBase* poVisit);
  rgfi_tclDescription(fi_tclOutContext* poOut, rgfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(rgfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ rgfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  rgfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<rgfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<rgfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline rgfi_tclDescription::rgfi_tclDescription(fi_tclInContext* poIn, rgfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline rgfi_tclDescription::rgfi_tclDescription(fi_tclOutContext* poOut, rgfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

