#ifndef RFDFILANGUAGE_HEADER
#define RFDFILANGUAGE_HEADER

class rfdfi_tclInContext;
class rfdfi_tclOutContext;
class rfdfi_tclVisitorBase;

class MY_DECL rfdfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  rfdfi_tclDescription(fi_tclInContext* poIn, rfdfi_tclVisitorBase* poVisit);
  rfdfi_tclDescription(fi_tclOutContext* poOut, rfdfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(rfdfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ rfdfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  rfdfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<rfdfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<rfdfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline rfdfi_tclDescription::rfdfi_tclDescription(fi_tclInContext* poIn, rfdfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline rfdfi_tclDescription::rfdfi_tclDescription(fi_tclOutContext* poOut, rfdfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

