#include "precompiled.hh"

tBool rfdfi_tclDescription::bInitMessage(rfdfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case rfdfi_tclToken::EN_LAST_TOKEN:
   case rfdfi_tclToken::EN_LIST:
   case rfdfi_tclToken::EN_END_OF_STRUCT:
   case rfdfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case rfdfi_tclToken::EN_MSG_CURRTABWEATHERDBINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_STRING,rfdfi_tclSemanticDomain::EN_MSG_CURRENTBASELINEPATH));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_U8,rfdfi_tclSemanticDomain::EN_MSG_PROTOCOLVERSION));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_U32,rfdfi_tclSemanticDomain::EN_MSG_BASELINEFILEVERSION));
   } break;
   case rfdfi_tclToken::EN_MSG_CURRTABWEATHERDBINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_RFD_SERVICESTATUS,rfdfi_tclSemanticDomain::EN_MSG_SERVICESTATUS));
   } break;
   case rfdfi_tclToken::EN_MSG_DELETETABWEATHERDBFILEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_RFD_BASELINEFILES,rfdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_LIST,rfdfi_tclSemanticDomain::EN_MSG_OLISTOFBASELINEFILES));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_UPDATESTATE,rfdfi_tclSemanticDomain::EN_MSG_UPDATESTATUS));
   } break;
   case rfdfi_tclToken::EN_MSG_DELETETABWEATHERDBFILEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_RFD_SERVICESTATUS,rfdfi_tclSemanticDomain::EN_MSG_SERVICESTATUS));
   } break;
   case rfdfi_tclToken::EN_MSG_ACQUIREDATAACCESSMETHODSTART:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_SXMPROTOCOL,rfdfi_tclSemanticDomain::EN_MSG_PROTOCOL));
   } break;
   case rfdfi_tclToken::EN_MSG_ACQUIREDATAACCESSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_BOOL,rfdfi_tclSemanticDomain::EN_MSG_ACCESSGIVEN));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_SXMPROTOCOL,rfdfi_tclSemanticDomain::EN_MSG_PROTOCOL));
   } break;
   case rfdfi_tclToken::EN_MSG_RELEASEDATAACCESSMETHODSTART:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_SXMFILE,rfdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_LIST,rfdfi_tclSemanticDomain::EN_MSG_CORRUPTFILES));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_SXMPROTOCOL,rfdfi_tclSemanticDomain::EN_MSG_PROTOCOL));
   } break;
   case rfdfi_tclToken::EN_MSG_RELEASEDATAACCESSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_SXMPROTOCOL,rfdfi_tclSemanticDomain::EN_MSG_PROTOCOL));
   } break;
   case rfdfi_tclToken::EN_MSG_REVERTEXISTINGDATABASEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_SXMPROTOCOL,rfdfi_tclSemanticDomain::EN_MSG_PROTOCOL));
   } break;
   case rfdfi_tclToken::EN_MSG_REVERTEXISTINGDATABASEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_BOOL,rfdfi_tclSemanticDomain::EN_MSG_DATABASEREVERTED));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_SXMPROTOCOL,rfdfi_tclSemanticDomain::EN_MSG_PROTOCOL));
   } break;
   case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDSTATUS:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_RFD_BASELINEFILES,rfdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_LIST,rfdfi_tclSemanticDomain::EN_MSG_OLISTOFBASELINEFILES));
   } break;
   case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTSTATUS:
   {
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_FILESFORPROTOCOL,rfdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_LIST,rfdfi_tclSemanticDomain::EN_MSG_LISTOFFILESPERPROTOCOL));
   } break;
   case rfdfi_tclToken::EN_BINCONTAINER:
   case rfdfi_tclToken::EN_RFD_BASELINEFILES:
   case rfdfi_tclToken::EN_E8_RFD_SERVICESTATUS:
   case rfdfi_tclToken::EN_E8_UPDATESTATE:
   case rfdfi_tclToken::EN_E8_SXMPROTOCOL:
   case rfdfi_tclToken::EN_DEVICEPATHFORPROTOCOL:
   case rfdfi_tclToken::EN_SXMFILE:
   case rfdfi_tclToken::EN_FILESFORPROTOCOL:
   case rfdfi_tclToken::EN_U8:   
   case rfdfi_tclToken::EN_S8:   
   case rfdfi_tclToken::EN_U16:   
   case rfdfi_tclToken::EN_S16:   
   case rfdfi_tclToken::EN_U24:   
   case rfdfi_tclToken::EN_S24:   
   case rfdfi_tclToken::EN_U32:   
   case rfdfi_tclToken::EN_S32:   
   case rfdfi_tclToken::EN_U64:   
   case rfdfi_tclToken::EN_S64:   
   case rfdfi_tclToken::EN_F32:   
   case rfdfi_tclToken::EN_F64:   
   case rfdfi_tclToken::EN_BOOL:   
   case rfdfi_tclToken::EN_STRING:   
   case rfdfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(rfdfi_tclKnot(enMsgToken,rfdfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool rfdfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool rfdfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      rfdfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      rfdfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      rfdfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == rfdfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(rfdfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(rfdfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(rfdfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case rfdfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == rfdfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case rfdfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            rfdfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(rfdfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            rfdfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(rfdfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case rfdfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case rfdfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rfdfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case rfdfi_tclToken::EN_MSG_CURRTABWEATHERDBINFOMETHODSTART:
   case rfdfi_tclToken::EN_MSG_CURRTABWEATHERDBINFOMETHODRESULT:
   case rfdfi_tclToken::EN_MSG_DELETETABWEATHERDBFILEMETHODSTART:
   case rfdfi_tclToken::EN_MSG_DELETETABWEATHERDBFILEMETHODRESULT:
   case rfdfi_tclToken::EN_MSG_ACQUIREDATAACCESSMETHODSTART:
   case rfdfi_tclToken::EN_MSG_ACQUIREDATAACCESSMETHODRESULT:
   case rfdfi_tclToken::EN_MSG_RELEASEDATAACCESSMETHODSTART:
   case rfdfi_tclToken::EN_MSG_RELEASEDATAACCESSMETHODRESULT:
   case rfdfi_tclToken::EN_MSG_REVERTEXISTINGDATABASEMETHODSTART:
   case rfdfi_tclToken::EN_MSG_REVERTEXISTINGDATABASEMETHODRESULT:
   case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDUPREG:
   case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDRELUPREG:
   case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDGET:
   case rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDSTATUS:
   case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTUPREG:
   case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTRELUPREG:
   case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTGET:
   case rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTSTATUS:
      bInitMessage(enToken);
      break;
   case rfdfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_END_OF_STRUCT,rfdfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_U8,rfdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_LIST,rfdfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rfdfi_tclToken::EN_RFD_BASELINEFILES:
   {
      if (poVisitor->bDoExpand_Rfd_BaselineFiles(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_END_OF_STRUCT,rfdfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_STRING,rfdfi_tclSemanticDomain::EN_BASELINEFILEPATH));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_STRING,rfdfi_tclSemanticDomain::EN_BASELINEFILENAME));
      }
      else
      {
         fi_tcl_Rfd_BaselineFiles o_Rfd_BaselineFiles;
         if (!bDoIt(o_Rfd_BaselineFiles))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Rfd_BaselineFiles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Rfd_BaselineFiles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rfdfi_tclToken::EN_E8_RFD_SERVICESTATUS:
   {
      fi_tcl_e8_Rfd_ServiceStatus o_e8_Rfd_ServiceStatus;
      if (!bDoIt(o_e8_Rfd_ServiceStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rfdfi_tclToken::EN_E8_UPDATESTATE:
   {
      fi_tcl_e8_UpdateState o_e8_UpdateState;
      if (!bDoIt(o_e8_UpdateState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rfdfi_tclToken::EN_E8_SXMPROTOCOL:
   {
      fi_tcl_e8_SxmProtocol o_e8_SxmProtocol;
      if (!bDoIt(o_e8_SxmProtocol))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rfdfi_tclToken::EN_DEVICEPATHFORPROTOCOL:
   {
      if (poVisitor->bDoExpand_DevicePathForProtocol(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_END_OF_STRUCT,rfdfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_STRING,rfdfi_tclSemanticDomain::EN_PATH));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_STRING,rfdfi_tclSemanticDomain::EN_DEVICE));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_E8_SXMPROTOCOL,rfdfi_tclSemanticDomain::EN_SXMPROTOCOL));
      }
      else
      {
         fi_tcl_DevicePathForProtocol o_DevicePathForProtocol;
         if (!bDoIt(o_DevicePathForProtocol))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevicePathForProtocol.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevicePathForProtocol.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rfdfi_tclToken::EN_SXMFILE:
   {
      if (poVisitor->bDoExpand_SxmFile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_END_OF_STRUCT,rfdfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_BOOL,rfdfi_tclSemanticDomain::EN_ISBASEFILE));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_U32,rfdfi_tclSemanticDomain::EN_VERSION));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_STRING,rfdfi_tclSemanticDomain::EN_FILENAME));
      }
      else
      {
         fi_tcl_SxmFile o_SxmFile;
         if (!bDoIt(o_SxmFile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmFile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmFile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rfdfi_tclToken::EN_FILESFORPROTOCOL:
   {
      if (poVisitor->bDoExpand_FilesForProtocol(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_END_OF_STRUCT,rfdfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_SXMFILE,rfdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_LIST,rfdfi_tclSemanticDomain::EN_FILES));
         oPath.bGoDown(rfdfi_tclKnot(rfdfi_tclToken::EN_DEVICEPATHFORPROTOCOL,rfdfi_tclSemanticDomain::EN_PATHFORPROTOCOL));
      }
      else
      {
         fi_tcl_FilesForProtocol o_FilesForProtocol;
         if (!bDoIt(o_FilesForProtocol))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FilesForProtocol.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FilesForProtocol.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case rfdfi_tclToken::EN_UNKNOWN:
      case rfdfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

