/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgKnitRegionMethodStart::regionknitterfi_tclMsgKnitRegionMethodStart(const regionknitterfi_tclMsgKnitRegionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RegionProductionDate = coRef.RegionProductionDate;
   OriginSourceMediumId = coRef.OriginSourceMediumId;
   SourceMediumId = coRef.SourceMediumId;
   SourceDevice = coRef.SourceDevice;
   KnitRegion = coRef.KnitRegion;
   NeighbourRegions = coRef.NeighbourRegions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgKnitRegionMethodStart& regionknitterfi_tclMsgKnitRegionMethodStart::operator=(const regionknitterfi_tclMsgKnitRegionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RegionProductionDate = coRef.RegionProductionDate;
   OriginSourceMediumId = coRef.OriginSourceMediumId;
   SourceMediumId = coRef.SourceMediumId;
   SourceDevice = coRef.SourceDevice;
   KnitRegion = coRef.KnitRegion;
   NeighbourRegions = coRef.NeighbourRegions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgKnitRegionMethodStart::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgKnitRegionMethodStart::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_KNITREGION;}
tU8 regionknitterfi_tclMsgKnitRegionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid regionknitterfi_tclMsgKnitRegionMethodStart::vDestroy()
{
   KnitDevice.vDestroy();
   SourceDevice.vDestroy();
   NeighbourRegions.clear();
}

tU32 regionknitterfi_tclMsgKnitRegionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 22+KnitDevice.u32GetSize(u16MajorVersion)+SourceDevice.u32GetSize(u16MajorVersion)+NeighbourRegions.size()*2;
}

tBool regionknitterfi_tclMsgKnitRegionMethodStart::operator==(const regionknitterfi_tclMsgKnitRegionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (KnitMediumId == rfoCmp.KnitMediumId);
      bResult = bResult && (KnitDevice == rfoCmp.KnitDevice);
      bResult = bResult && (RegionProductionDate == rfoCmp.RegionProductionDate);
      bResult = bResult && (OriginSourceMediumId == rfoCmp.OriginSourceMediumId);
      bResult = bResult && (SourceMediumId == rfoCmp.SourceMediumId);
      bResult = bResult && (SourceDevice == rfoCmp.SourceDevice);
      bResult = bResult && (KnitRegion == rfoCmp.KnitRegion);
      bResult = bResult && (NeighbourRegions.size() == rfoCmp.NeighbourRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NeighbourRegions.size()); ++u32Idx)
            bResult = bResult && (NeighbourRegions[u32Idx] == rfoCmp.NeighbourRegions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgKnitRegionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> KnitMediumId;
   oIn >> KnitDevice;
   oIn >> RegionProductionDate;
   oIn >> OriginSourceMediumId;
   oIn >> SourceMediumId;
   oIn >> SourceDevice;
   oIn >> KnitRegion;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      NeighbourRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> NeighbourRegions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgKnitRegionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << KnitMediumId;
   oOut << KnitDevice;
   oOut << RegionProductionDate;
   oOut << OriginSourceMediumId;
   oOut << SourceMediumId;
   oOut << SourceDevice;
   oOut << KnitRegion;
   oOut << (tU32)NeighbourRegions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < NeighbourRegions.size(); ++u32Idx)
         oOut << NeighbourRegions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgKnitRegionMethodResult::regionknitterfi_tclMsgKnitRegionMethodResult(const regionknitterfi_tclMsgKnitRegionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgKnitRegionMethodResult& regionknitterfi_tclMsgKnitRegionMethodResult::operator=(const regionknitterfi_tclMsgKnitRegionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgKnitRegionMethodResult::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgKnitRegionMethodResult::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_KNITREGION;}
tU8 regionknitterfi_tclMsgKnitRegionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 regionknitterfi_tclMsgKnitRegionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool regionknitterfi_tclMsgKnitRegionMethodResult::operator==(const regionknitterfi_tclMsgKnitRegionMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgKnitRegionMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgKnitRegionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgUnknitRegionsMethodStart::regionknitterfi_tclMsgUnknitRegionsMethodStart(const regionknitterfi_tclMsgUnknitRegionsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RemoveRegions = coRef.RemoveRegions;
   NeighbourRegions = coRef.NeighbourRegions;
   RegionProductionDates = coRef.RegionProductionDates;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgUnknitRegionsMethodStart& regionknitterfi_tclMsgUnknitRegionsMethodStart::operator=(const regionknitterfi_tclMsgUnknitRegionsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RemoveRegions = coRef.RemoveRegions;
   NeighbourRegions = coRef.NeighbourRegions;
   RegionProductionDates = coRef.RegionProductionDates;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgUnknitRegionsMethodStart::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgUnknitRegionsMethodStart::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_UNKNITREGIONS;}
tU8 regionknitterfi_tclMsgUnknitRegionsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid regionknitterfi_tclMsgUnknitRegionsMethodStart::vDestroy()
{
   KnitDevice.vDestroy();
   RemoveRegions.clear();
   NeighbourRegions.clear();
   RegionProductionDates.clear();
}

tU32 regionknitterfi_tclMsgUnknitRegionsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += RegionProductionDates.size()*4;
   }
   return u32DynamicSize+12+KnitDevice.u32GetSize(u16MajorVersion)+RemoveRegions.size()*2+NeighbourRegions.size()*2;
}

tBool regionknitterfi_tclMsgUnknitRegionsMethodStart::operator==(const regionknitterfi_tclMsgUnknitRegionsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (KnitMediumId == rfoCmp.KnitMediumId);
      bResult = bResult && (KnitDevice == rfoCmp.KnitDevice);
      bResult = bResult && (RemoveRegions.size() == rfoCmp.RemoveRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RemoveRegions.size()); ++u32Idx)
            bResult = bResult && (RemoveRegions[u32Idx] == rfoCmp.RemoveRegions[u32Idx]);
      }
      bResult = bResult && (NeighbourRegions.size() == rfoCmp.NeighbourRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NeighbourRegions.size()); ++u32Idx)
            bResult = bResult && (NeighbourRegions[u32Idx] == rfoCmp.NeighbourRegions[u32Idx]);
      }
      bResult = bResult && (RegionProductionDates.size() == rfoCmp.RegionProductionDates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionProductionDates.size()); ++u32Idx)
            bResult = bResult && (RegionProductionDates[u32Idx] == rfoCmp.RegionProductionDates[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgUnknitRegionsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> KnitMediumId;
   oIn >> KnitDevice;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RemoveRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RemoveRegions[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      NeighbourRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> NeighbourRegions[u32Idx];
      }
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         RegionProductionDates.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> RegionProductionDates[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgUnknitRegionsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << KnitMediumId;
   oOut << KnitDevice;
   oOut << (tU32)RemoveRegions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RemoveRegions.size(); ++u32Idx)
         oOut << RemoveRegions[u32Idx];
   }
   oOut << (tU32)NeighbourRegions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < NeighbourRegions.size(); ++u32Idx)
         oOut << NeighbourRegions[u32Idx];
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)RegionProductionDates.size();
      {
         for (tU32 u32Idx = 0; u32Idx < RegionProductionDates.size(); ++u32Idx)
            oOut << RegionProductionDates[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgUnknitRegionsMethodResult::regionknitterfi_tclMsgUnknitRegionsMethodResult(const regionknitterfi_tclMsgUnknitRegionsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgUnknitRegionsMethodResult& regionknitterfi_tclMsgUnknitRegionsMethodResult::operator=(const regionknitterfi_tclMsgUnknitRegionsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgUnknitRegionsMethodResult::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgUnknitRegionsMethodResult::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_UNKNITREGIONS;}
tU8 regionknitterfi_tclMsgUnknitRegionsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid regionknitterfi_tclMsgUnknitRegionsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
         Status[u32Idx].vDestroy();
   }
   Status.clear();
}

tU32 regionknitterfi_tclMsgUnknitRegionsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Status.size(); ++u32ListIdx)
      u32DynamicSize += Status[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool regionknitterfi_tclMsgUnknitRegionsMethodResult::operator==(const regionknitterfi_tclMsgUnknitRegionsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status.size() == rfoCmp.Status.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Status.size()); ++u32Idx)
            bResult = bResult && (Status[u32Idx] == rfoCmp.Status[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgUnknitRegionsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
      {
         Status[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Status.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Status[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgUnknitRegionsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Status.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
         oOut << Status[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgResumeMethodStart::regionknitterfi_tclMsgResumeMethodStart(const regionknitterfi_tclMsgResumeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   enMode = coRef.enMode;
   enOperation = coRef.enOperation;
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RegionProductionDate = coRef.RegionProductionDate;
   OriginSourceMediumId = coRef.OriginSourceMediumId;
   SourceMediumId = coRef.SourceMediumId;
   SourceDevice = coRef.SourceDevice;
   Regions = coRef.Regions;
   NeighbourRegions = coRef.NeighbourRegions;
   RegionProductionDates = coRef.RegionProductionDates;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgResumeMethodStart& regionknitterfi_tclMsgResumeMethodStart::operator=(const regionknitterfi_tclMsgResumeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enMode = coRef.enMode;
   enOperation = coRef.enOperation;
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RegionProductionDate = coRef.RegionProductionDate;
   OriginSourceMediumId = coRef.OriginSourceMediumId;
   SourceMediumId = coRef.SourceMediumId;
   SourceDevice = coRef.SourceDevice;
   Regions = coRef.Regions;
   NeighbourRegions = coRef.NeighbourRegions;
   RegionProductionDates = coRef.RegionProductionDates;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgResumeMethodStart::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgResumeMethodStart::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_RESUME;}
tU8 regionknitterfi_tclMsgResumeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid regionknitterfi_tclMsgResumeMethodStart::vDestroy()
{
   KnitDevice.vDestroy();
   SourceDevice.vDestroy();
   Regions.clear();
   NeighbourRegions.clear();
   RegionProductionDates.clear();
}

tU32 regionknitterfi_tclMsgResumeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += RegionProductionDates.size()*4;
   }
   return u32DynamicSize+26+KnitDevice.u32GetSize(u16MajorVersion)+SourceDevice.u32GetSize(u16MajorVersion)+Regions.size()*2+NeighbourRegions.size()*2;
}

tBool regionknitterfi_tclMsgResumeMethodStart::operator==(const regionknitterfi_tclMsgResumeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (enMode == rfoCmp.enMode);
      bResult = bResult && (enOperation == rfoCmp.enOperation);
      bResult = bResult && (KnitMediumId == rfoCmp.KnitMediumId);
      bResult = bResult && (KnitDevice == rfoCmp.KnitDevice);
      bResult = bResult && (RegionProductionDate == rfoCmp.RegionProductionDate);
      bResult = bResult && (OriginSourceMediumId == rfoCmp.OriginSourceMediumId);
      bResult = bResult && (SourceMediumId == rfoCmp.SourceMediumId);
      bResult = bResult && (SourceDevice == rfoCmp.SourceDevice);
      bResult = bResult && (Regions.size() == rfoCmp.Regions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Regions.size()); ++u32Idx)
            bResult = bResult && (Regions[u32Idx] == rfoCmp.Regions[u32Idx]);
      }
      bResult = bResult && (NeighbourRegions.size() == rfoCmp.NeighbourRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NeighbourRegions.size()); ++u32Idx)
            bResult = bResult && (NeighbourRegions[u32Idx] == rfoCmp.NeighbourRegions[u32Idx]);
      }
      bResult = bResult && (RegionProductionDates.size() == rfoCmp.RegionProductionDates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionProductionDates.size()); ++u32Idx)
            bResult = bResult && (RegionProductionDates[u32Idx] == rfoCmp.RegionProductionDates[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgResumeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> enMode;
   oIn >> enOperation;
   oIn >> KnitMediumId;
   oIn >> KnitDevice;
   oIn >> RegionProductionDate;
   oIn >> OriginSourceMediumId;
   oIn >> SourceMediumId;
   oIn >> SourceDevice;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      Regions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Regions[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      NeighbourRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> NeighbourRegions[u32Idx];
      }
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         RegionProductionDates.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> RegionProductionDates[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgResumeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << enMode;
   oOut << enOperation;
   oOut << KnitMediumId;
   oOut << KnitDevice;
   oOut << RegionProductionDate;
   oOut << OriginSourceMediumId;
   oOut << SourceMediumId;
   oOut << SourceDevice;
   oOut << (tU32)Regions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
         oOut << Regions[u32Idx];
   }
   oOut << (tU32)NeighbourRegions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < NeighbourRegions.size(); ++u32Idx)
         oOut << NeighbourRegions[u32Idx];
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)RegionProductionDates.size();
      {
         for (tU32 u32Idx = 0; u32Idx < RegionProductionDates.size(); ++u32Idx)
            oOut << RegionProductionDates[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgResumeMethodResult::regionknitterfi_tclMsgResumeMethodResult(const regionknitterfi_tclMsgResumeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgResumeMethodResult& regionknitterfi_tclMsgResumeMethodResult::operator=(const regionknitterfi_tclMsgResumeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgResumeMethodResult::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgResumeMethodResult::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_RESUME;}
tU8 regionknitterfi_tclMsgResumeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid regionknitterfi_tclMsgResumeMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
         Status[u32Idx].vDestroy();
   }
   Status.clear();
}

tU32 regionknitterfi_tclMsgResumeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < Status.size(); ++u32ListIdx)
         u32DynamicSize += Status[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+0;
}

tBool regionknitterfi_tclMsgResumeMethodResult::operator==(const regionknitterfi_tclMsgResumeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status.size() == rfoCmp.Status.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Status.size()); ++u32Idx)
            bResult = bResult && (Status[u32Idx] == rfoCmp.Status[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgResumeMethodResult::oRead(fi_tclInContext& oIn)
{
   if (1 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
         {
            Status[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         Status.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> Status[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgResumeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (1 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)Status.size();
      {
         for (tU32 u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
            oOut << Status[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgPreKnitRegionMethodStart::regionknitterfi_tclMsgPreKnitRegionMethodStart(const regionknitterfi_tclMsgPreKnitRegionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RegionProductionDate = coRef.RegionProductionDate;
   OriginSourceMediumId = coRef.OriginSourceMediumId;
   SourceMediumId = coRef.SourceMediumId;
   SourceDevice = coRef.SourceDevice;
   KnitRegion = coRef.KnitRegion;
   NeighbourRegions = coRef.NeighbourRegions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgPreKnitRegionMethodStart& regionknitterfi_tclMsgPreKnitRegionMethodStart::operator=(const regionknitterfi_tclMsgPreKnitRegionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RegionProductionDate = coRef.RegionProductionDate;
   OriginSourceMediumId = coRef.OriginSourceMediumId;
   SourceMediumId = coRef.SourceMediumId;
   SourceDevice = coRef.SourceDevice;
   KnitRegion = coRef.KnitRegion;
   NeighbourRegions = coRef.NeighbourRegions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgPreKnitRegionMethodStart::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgPreKnitRegionMethodStart::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_PREKNITREGION;}
tU8 regionknitterfi_tclMsgPreKnitRegionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid regionknitterfi_tclMsgPreKnitRegionMethodStart::vDestroy()
{
   KnitDevice.vDestroy();
   SourceDevice.vDestroy();
   NeighbourRegions.clear();
}

tU32 regionknitterfi_tclMsgPreKnitRegionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 22+KnitDevice.u32GetSize(u16MajorVersion)+SourceDevice.u32GetSize(u16MajorVersion)+NeighbourRegions.size()*2;
}

tBool regionknitterfi_tclMsgPreKnitRegionMethodStart::operator==(const regionknitterfi_tclMsgPreKnitRegionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (KnitMediumId == rfoCmp.KnitMediumId);
      bResult = bResult && (KnitDevice == rfoCmp.KnitDevice);
      bResult = bResult && (RegionProductionDate == rfoCmp.RegionProductionDate);
      bResult = bResult && (OriginSourceMediumId == rfoCmp.OriginSourceMediumId);
      bResult = bResult && (SourceMediumId == rfoCmp.SourceMediumId);
      bResult = bResult && (SourceDevice == rfoCmp.SourceDevice);
      bResult = bResult && (KnitRegion == rfoCmp.KnitRegion);
      bResult = bResult && (NeighbourRegions.size() == rfoCmp.NeighbourRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NeighbourRegions.size()); ++u32Idx)
            bResult = bResult && (NeighbourRegions[u32Idx] == rfoCmp.NeighbourRegions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgPreKnitRegionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> KnitMediumId;
   oIn >> KnitDevice;
   oIn >> RegionProductionDate;
   oIn >> OriginSourceMediumId;
   oIn >> SourceMediumId;
   oIn >> SourceDevice;
   oIn >> KnitRegion;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      NeighbourRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> NeighbourRegions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgPreKnitRegionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << KnitMediumId;
   oOut << KnitDevice;
   oOut << RegionProductionDate;
   oOut << OriginSourceMediumId;
   oOut << SourceMediumId;
   oOut << SourceDevice;
   oOut << KnitRegion;
   oOut << (tU32)NeighbourRegions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < NeighbourRegions.size(); ++u32Idx)
         oOut << NeighbourRegions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgPreKnitRegionMethodResult::regionknitterfi_tclMsgPreKnitRegionMethodResult(const regionknitterfi_tclMsgPreKnitRegionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgPreKnitRegionMethodResult& regionknitterfi_tclMsgPreKnitRegionMethodResult::operator=(const regionknitterfi_tclMsgPreKnitRegionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgPreKnitRegionMethodResult::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgPreKnitRegionMethodResult::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_PREKNITREGION;}
tU8 regionknitterfi_tclMsgPreKnitRegionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 regionknitterfi_tclMsgPreKnitRegionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool regionknitterfi_tclMsgPreKnitRegionMethodResult::operator==(const regionknitterfi_tclMsgPreKnitRegionMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgPreKnitRegionMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgPreKnitRegionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgPostUnknitRegionsMethodStart::regionknitterfi_tclMsgPostUnknitRegionsMethodStart(const regionknitterfi_tclMsgPostUnknitRegionsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RemoveRegions = coRef.RemoveRegions;
   NeighbourRegions = coRef.NeighbourRegions;
   RegionProductionDates = coRef.RegionProductionDates;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgPostUnknitRegionsMethodStart& regionknitterfi_tclMsgPostUnknitRegionsMethodStart::operator=(const regionknitterfi_tclMsgPostUnknitRegionsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   KnitMediumId = coRef.KnitMediumId;
   KnitDevice = coRef.KnitDevice;
   RemoveRegions = coRef.RemoveRegions;
   NeighbourRegions = coRef.NeighbourRegions;
   RegionProductionDates = coRef.RegionProductionDates;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgPostUnknitRegionsMethodStart::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgPostUnknitRegionsMethodStart::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_POSTUNKNITREGIONS;}
tU8 regionknitterfi_tclMsgPostUnknitRegionsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid regionknitterfi_tclMsgPostUnknitRegionsMethodStart::vDestroy()
{
   KnitDevice.vDestroy();
   RemoveRegions.clear();
   NeighbourRegions.clear();
   RegionProductionDates.clear();
}

tU32 regionknitterfi_tclMsgPostUnknitRegionsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += RegionProductionDates.size()*4;
   }
   return u32DynamicSize+12+KnitDevice.u32GetSize(u16MajorVersion)+RemoveRegions.size()*2+NeighbourRegions.size()*2;
}

tBool regionknitterfi_tclMsgPostUnknitRegionsMethodStart::operator==(const regionknitterfi_tclMsgPostUnknitRegionsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (KnitMediumId == rfoCmp.KnitMediumId);
      bResult = bResult && (KnitDevice == rfoCmp.KnitDevice);
      bResult = bResult && (RemoveRegions.size() == rfoCmp.RemoveRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RemoveRegions.size()); ++u32Idx)
            bResult = bResult && (RemoveRegions[u32Idx] == rfoCmp.RemoveRegions[u32Idx]);
      }
      bResult = bResult && (NeighbourRegions.size() == rfoCmp.NeighbourRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NeighbourRegions.size()); ++u32Idx)
            bResult = bResult && (NeighbourRegions[u32Idx] == rfoCmp.NeighbourRegions[u32Idx]);
      }
      bResult = bResult && (RegionProductionDates.size() == rfoCmp.RegionProductionDates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionProductionDates.size()); ++u32Idx)
            bResult = bResult && (RegionProductionDates[u32Idx] == rfoCmp.RegionProductionDates[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgPostUnknitRegionsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> KnitMediumId;
   oIn >> KnitDevice;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RemoveRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RemoveRegions[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      NeighbourRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> NeighbourRegions[u32Idx];
      }
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         RegionProductionDates.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> RegionProductionDates[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgPostUnknitRegionsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << KnitMediumId;
   oOut << KnitDevice;
   oOut << (tU32)RemoveRegions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RemoveRegions.size(); ++u32Idx)
         oOut << RemoveRegions[u32Idx];
   }
   oOut << (tU32)NeighbourRegions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < NeighbourRegions.size(); ++u32Idx)
         oOut << NeighbourRegions[u32Idx];
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)RegionProductionDates.size();
      {
         for (tU32 u32Idx = 0; u32Idx < RegionProductionDates.size(); ++u32Idx)
            oOut << RegionProductionDates[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgPostUnknitRegionsMethodResult::regionknitterfi_tclMsgPostUnknitRegionsMethodResult(const regionknitterfi_tclMsgPostUnknitRegionsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
regionknitterfi_tclMsgPostUnknitRegionsMethodResult& regionknitterfi_tclMsgPostUnknitRegionsMethodResult::operator=(const regionknitterfi_tclMsgPostUnknitRegionsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 regionknitterfi_tclMsgPostUnknitRegionsMethodResult::u16GetServiceID() const {return REGIONKNITTERFI_C_U16_SERVICE_ID;}
tU16 regionknitterfi_tclMsgPostUnknitRegionsMethodResult::u16GetFunctionID() const {return REGIONKNITTERFI_C_U16_POSTUNKNITREGIONS;}
tU8 regionknitterfi_tclMsgPostUnknitRegionsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid regionknitterfi_tclMsgPostUnknitRegionsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
         Status[u32Idx].vDestroy();
   }
   Status.clear();
}

tU32 regionknitterfi_tclMsgPostUnknitRegionsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Status.size(); ++u32ListIdx)
      u32DynamicSize += Status[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool regionknitterfi_tclMsgPostUnknitRegionsMethodResult::operator==(const regionknitterfi_tclMsgPostUnknitRegionsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status.size() == rfoCmp.Status.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Status.size()); ++u32Idx)
            bResult = bResult && (Status[u32Idx] == rfoCmp.Status[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& regionknitterfi_tclMsgPostUnknitRegionsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
      {
         Status[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Status.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Status[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& regionknitterfi_tclMsgPostUnknitRegionsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Status.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Status.size(); ++u32Idx)
         oOut << Status[u32Idx];
   }
   return oOut;
}

