#include "precompiled.hh"

tBool regionknitterfi_tclDescription::bInitMessage(regionknitterfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case regionknitterfi_tclToken::EN_LAST_TOKEN:
   case regionknitterfi_tclToken::EN_LIST:
   case regionknitterfi_tclToken::EN_END_OF_STRUCT:
   case regionknitterfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case regionknitterfi_tclToken::EN_MSG_KNITREGIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_NEIGHBOURREGIONS));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_MSG_KNITREGION));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_STRING,regionknitterfi_tclSemanticDomain::EN_MSG_SOURCEDEVICE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_SOURCEMEDIUMID));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_ORIGINSOURCEMEDIUMID));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_REGIONPRODUCTIONDATE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_STRING,regionknitterfi_tclSemanticDomain::EN_MSG_KNITDEVICE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_KNITMEDIUMID));
   } break;
   case regionknitterfi_tclToken::EN_MSG_UNKNITREGIONSMETHODSTART:
   {
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_REGIONPRODUCTIONDATES));
      }
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_NEIGHBOURREGIONS));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_REMOVEREGIONS));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_STRING,regionknitterfi_tclSemanticDomain::EN_MSG_KNITDEVICE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_KNITMEDIUMID));
   } break;
   case regionknitterfi_tclToken::EN_MSG_UNKNITREGIONSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_REGIONSTATUS,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_STATUS));
   } break;
   case regionknitterfi_tclToken::EN_MSG_RESUMEMETHODSTART:
   {
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_REGIONPRODUCTIONDATES));
      }
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_NEIGHBOURREGIONS));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_REGIONS));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_STRING,regionknitterfi_tclSemanticDomain::EN_MSG_SOURCEDEVICE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_SOURCEMEDIUMID));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_ORIGINSOURCEMEDIUMID));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_REGIONPRODUCTIONDATE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_STRING,regionknitterfi_tclSemanticDomain::EN_MSG_KNITDEVICE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_KNITMEDIUMID));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_E8_RESUMEDOPERATION,regionknitterfi_tclSemanticDomain::EN_MSG_ENOPERATION));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_E8_RESUMEMODE,regionknitterfi_tclSemanticDomain::EN_MSG_ENMODE));
   } break;
   case regionknitterfi_tclToken::EN_MSG_RESUMEMETHODRESULT:
   {
      if (1 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_REGIONSTATUS,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_STATUS));
      }
   } break;
   case regionknitterfi_tclToken::EN_MSG_PREKNITREGIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_NEIGHBOURREGIONS));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_MSG_KNITREGION));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_STRING,regionknitterfi_tclSemanticDomain::EN_MSG_SOURCEDEVICE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_SOURCEMEDIUMID));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_ORIGINSOURCEMEDIUMID));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_REGIONPRODUCTIONDATE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_STRING,regionknitterfi_tclSemanticDomain::EN_MSG_KNITDEVICE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_KNITMEDIUMID));
   } break;
   case regionknitterfi_tclToken::EN_MSG_POSTUNKNITREGIONSMETHODSTART:
   {
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_REGIONPRODUCTIONDATES));
      }
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_NEIGHBOURREGIONS));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_REMOVEREGIONS));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_STRING,regionknitterfi_tclSemanticDomain::EN_MSG_KNITDEVICE));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_MSG_KNITMEDIUMID));
   } break;
   case regionknitterfi_tclToken::EN_MSG_POSTUNKNITREGIONSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_REGIONSTATUS,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_MSG_STATUS));
   } break;
   case regionknitterfi_tclToken::EN_BINCONTAINER:
   case regionknitterfi_tclToken::EN_REGIONSTATUS:
   case regionknitterfi_tclToken::EN_E8_RESUMEMODE:
   case regionknitterfi_tclToken::EN_E8_RESUMEDOPERATION:
   case regionknitterfi_tclToken::EN_U8:   
   case regionknitterfi_tclToken::EN_S8:   
   case regionknitterfi_tclToken::EN_U16:   
   case regionknitterfi_tclToken::EN_S16:   
   case regionknitterfi_tclToken::EN_U24:   
   case regionknitterfi_tclToken::EN_S24:   
   case regionknitterfi_tclToken::EN_U32:   
   case regionknitterfi_tclToken::EN_S32:   
   case regionknitterfi_tclToken::EN_U64:   
   case regionknitterfi_tclToken::EN_S64:   
   case regionknitterfi_tclToken::EN_F32:   
   case regionknitterfi_tclToken::EN_F64:   
   case regionknitterfi_tclToken::EN_BOOL:   
   case regionknitterfi_tclToken::EN_STRING:   
   case regionknitterfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(regionknitterfi_tclKnot(enMsgToken,regionknitterfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool regionknitterfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool regionknitterfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      regionknitterfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      regionknitterfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      regionknitterfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(regionknitterfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(regionknitterfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(regionknitterfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case regionknitterfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == regionknitterfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            regionknitterfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(regionknitterfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            regionknitterfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(regionknitterfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case regionknitterfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case regionknitterfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case regionknitterfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case regionknitterfi_tclToken::EN_MSG_KNITREGIONMETHODSTART:
   case regionknitterfi_tclToken::EN_MSG_KNITREGIONMETHODRESULT:
   case regionknitterfi_tclToken::EN_MSG_UNKNITREGIONSMETHODSTART:
   case regionknitterfi_tclToken::EN_MSG_UNKNITREGIONSMETHODRESULT:
   case regionknitterfi_tclToken::EN_MSG_RESUMEMETHODSTART:
   case regionknitterfi_tclToken::EN_MSG_RESUMEMETHODRESULT:
   case regionknitterfi_tclToken::EN_MSG_PREKNITREGIONMETHODSTART:
   case regionknitterfi_tclToken::EN_MSG_PREKNITREGIONMETHODRESULT:
   case regionknitterfi_tclToken::EN_MSG_POSTUNKNITREGIONSMETHODSTART:
   case regionknitterfi_tclToken::EN_MSG_POSTUNKNITREGIONSMETHODRESULT:
      bInitMessage(enToken);
      break;
   case regionknitterfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_END_OF_STRUCT,regionknitterfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U8,regionknitterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_LIST,regionknitterfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case regionknitterfi_tclToken::EN_REGIONSTATUS:
   {
      if (poVisitor->bDoExpand_RegionStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_END_OF_STRUCT,regionknitterfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_ERROR));
         if (2 <= u16MajorVersion)
         {
            oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U32,regionknitterfi_tclSemanticDomain::EN_CREATIONDATE));
         }
         oPath.bGoDown(regionknitterfi_tclKnot(regionknitterfi_tclToken::EN_U16,regionknitterfi_tclSemanticDomain::EN_REGION));
      }
      else
      {
         fi_tcl_RegionStatus o_RegionStatus;
         if (!bDoIt(o_RegionStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case regionknitterfi_tclToken::EN_E8_RESUMEMODE:
   {
      fi_tcl_e8_ResumeMode o_e8_ResumeMode;
      if (!bDoIt(o_e8_ResumeMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case regionknitterfi_tclToken::EN_E8_RESUMEDOPERATION:
   {
      fi_tcl_e8_ResumedOperation o_e8_ResumedOperation;
      if (!bDoIt(o_e8_ResumedOperation))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
      case regionknitterfi_tclToken::EN_UNKNOWN:
      case regionknitterfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

