/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef RCFITYPES_HEADER
#define RCFITYPES_HEADER

// #include <vector>
// 


class rcfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class rcfi_tclMsgGetRouteCapabilitiesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetRouteCapabilitiesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetRouteCapabilitiesMethodStart& operator=(const rcfi_tclMsgGetRouteCapabilitiesMethodStart& coRef);
   rcfi_tclMsgGetRouteCapabilitiesMethodStart(const rcfi_tclMsgGetRouteCapabilitiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetRouteCapabilitiesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETROUTECAPABILITIESMETHODSTART;}
};

class rcfi_tclMsgGetRouteCapabilitiesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetRouteCapabilitiesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetRouteCapabilitiesMethodResult& operator=(const rcfi_tclMsgGetRouteCapabilitiesMethodResult& coRef);
   rcfi_tclMsgGetRouteCapabilitiesMethodResult(const rcfi_tclMsgGetRouteCapabilitiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RouteCapability, std::allocator<fi_tcl_RouteCapability> > CapabilityList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetRouteCapabilitiesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETROUTECAPABILITIESMETHODRESULT;}
};

class rcfi_tclMsgGetRouteCalcOptionsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetRouteCalcOptionsMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetRouteCalcOptionsMethodStart& operator=(const rcfi_tclMsgGetRouteCalcOptionsMethodStart& coRef);
   rcfi_tclMsgGetRouteCalcOptionsMethodStart(const rcfi_tclMsgGetRouteCalcOptionsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_CurrentRouteOption, std::allocator<fi_tcl_CurrentRouteOption> > CurrentRouteOptions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetRouteCalcOptionsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETROUTECALCOPTIONSMETHODSTART;}
};

class rcfi_tclMsgGetRouteCalcOptionsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetRouteCalcOptionsMethodResult():MinSumValue(0),MaxSumValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetRouteCalcOptionsMethodResult& operator=(const rcfi_tclMsgGetRouteCalcOptionsMethodResult& coRef);
   rcfi_tclMsgGetRouteCalcOptionsMethodResult(const rcfi_tclMsgGetRouteCalcOptionsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 MinSumValue;
   tU8 MaxSumValue;
   std::vector<fi_tcl_AvailableRouteOption, std::allocator<fi_tcl_AvailableRouteOption> > AvailableRouteOptions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetRouteCalcOptionsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETROUTECALCOPTIONSMETHODRESULT;}
};

class rcfi_tclMsgCheckProfileValidityMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgCheckProfileValidityMethodStart():SpeedProfiles() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgCheckProfileValidityMethodStart& operator=(const rcfi_tclMsgCheckProfileValidityMethodStart& coRef);
   rcfi_tclMsgCheckProfileValidityMethodStart(const rcfi_tclMsgCheckProfileValidityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UserProfiles SpeedProfiles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgCheckProfileValidityMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_CHECKPROFILEVALIDITYMETHODSTART;}
};

class rcfi_tclMsgCheckProfileValidityMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgCheckProfileValidityMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgCheckProfileValidityMethodResult& operator=(const rcfi_tclMsgCheckProfileValidityMethodResult& coRef);
   rcfi_tclMsgCheckProfileValidityMethodResult(const rcfi_tclMsgCheckProfileValidityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgCheckProfileValidityMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_CHECKPROFILEVALIDITYMETHODRESULT;}
};

class rcfi_tclMsgGetStandardSpeedHistogramMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetStandardSpeedHistogramMethodStart():NavDataSetID(),ProfileType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetStandardSpeedHistogramMethodStart& operator=(const rcfi_tclMsgGetStandardSpeedHistogramMethodStart& coRef);
   rcfi_tclMsgGetStandardSpeedHistogramMethodStart(const rcfi_tclMsgGetStandardSpeedHistogramMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_e8_ProfileType ProfileType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetStandardSpeedHistogramMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETSTANDARDSPEEDHISTOGRAMMETHODSTART;}
};

class rcfi_tclMsgGetStandardSpeedHistogramMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetStandardSpeedHistogramMethodResult():NavDataSetID(),UserProfile() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetStandardSpeedHistogramMethodResult& operator=(const rcfi_tclMsgGetStandardSpeedHistogramMethodResult& coRef);
   rcfi_tclMsgGetStandardSpeedHistogramMethodResult(const rcfi_tclMsgGetStandardSpeedHistogramMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_UserSpeedProfile UserProfile;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetStandardSpeedHistogramMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETSTANDARDSPEEDHISTOGRAMMETHODRESULT;}
};

class rcfi_tclMsgGetDefaultVehicleParameterMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetDefaultVehicleParameterMethodStart():VehicleClass() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetDefaultVehicleParameterMethodStart& operator=(const rcfi_tclMsgGetDefaultVehicleParameterMethodStart& coRef);
   rcfi_tclMsgGetDefaultVehicleParameterMethodStart(const rcfi_tclMsgGetDefaultVehicleParameterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_VehicleClass VehicleClass;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetDefaultVehicleParameterMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETDEFAULTVEHICLEPARAMETERMETHODSTART;}
};

class rcfi_tclMsgGetDefaultVehicleParameterMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetDefaultVehicleParameterMethodResult():VehicleParameter() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetDefaultVehicleParameterMethodResult& operator=(const rcfi_tclMsgGetDefaultVehicleParameterMethodResult& coRef);
   rcfi_tclMsgGetDefaultVehicleParameterMethodResult(const rcfi_tclMsgGetDefaultVehicleParameterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_VehicleParameter VehicleParameter;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetDefaultVehicleParameterMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETDEFAULTVEHICLEPARAMETERMETHODRESULT;}
};

class rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart():AutomaticDynamizationThresholdTTA(),AutomaticDynamizationThresholdTFA(),UserConfirmedDynamizationThresholdTTA(),UserConfirmedDynamizationThresholdTFA() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart& operator=(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart& coRef);
   rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Second AutomaticDynamizationThresholdTTA;
   fi_tcl_s32_Microliter AutomaticDynamizationThresholdTFA;
   fi_tcl_s32_Second UserConfirmedDynamizationThresholdTTA;
   fi_tcl_s32_Microliter UserConfirmedDynamizationThresholdTFA;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETTRAVELADVANTAGETHRESHOLDSMETHODSTART;}
};

class rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult& operator=(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult& coRef);
   rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETTRAVELADVANTAGETHRESHOLDSMETHODRESULT;}
};

class rcfi_tclMsgSetThresholdDefinitionProfileMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetThresholdDefinitionProfileMethodStart():ThresholdDefinitionProfile() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetThresholdDefinitionProfileMethodStart& operator=(const rcfi_tclMsgSetThresholdDefinitionProfileMethodStart& coRef);
   rcfi_tclMsgSetThresholdDefinitionProfileMethodStart(const rcfi_tclMsgSetThresholdDefinitionProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_ThresholdDefinitionProfile ThresholdDefinitionProfile;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetThresholdDefinitionProfileMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETTHRESHOLDDEFINITIONPROFILEMETHODSTART;}
};

class rcfi_tclMsgSetThresholdDefinitionProfileMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetThresholdDefinitionProfileMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetThresholdDefinitionProfileMethodResult& operator=(const rcfi_tclMsgSetThresholdDefinitionProfileMethodResult& coRef);
   rcfi_tclMsgSetThresholdDefinitionProfileMethodResult(const rcfi_tclMsgSetThresholdDefinitionProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetThresholdDefinitionProfileMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETTHRESHOLDDEFINITIONPROFILEMETHODRESULT;}
};

class rcfi_tclMsgCreateTripMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgCreateTripMethodStart():TrackedFlag(0),StartPosition(),SpeedProfiles(),UserProfiles() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgCreateTripMethodStart& operator=(const rcfi_tclMsgCreateTripMethodStart& coRef);
   rcfi_tclMsgCreateTripMethodStart(const rcfi_tclMsgCreateTripMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool TrackedFlag;
   fi_tcl_LocationDescription StartPosition;
   fi_tcl_SpeedProfiles SpeedProfiles;
   fi_tcl_UserProfiles UserProfiles;
   std::vector<fi_tcl_TripSegment, std::allocator<fi_tcl_TripSegment> > TripDefinition;
   std::vector<fi_tcl_RouteDefinition, std::allocator<fi_tcl_RouteDefinition> > RouteDefinition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgCreateTripMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_CREATETRIPMETHODSTART;}
};

class rcfi_tclMsgCreateTripMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgCreateTripMethodResult():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgCreateTripMethodResult& operator=(const rcfi_tclMsgCreateTripMethodResult& coRef);
   rcfi_tclMsgCreateTripMethodResult(const rcfi_tclMsgCreateTripMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_RouteHandleDescription, std::allocator<fi_tcl_RouteHandleDescription> > RouteHandleDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgCreateTripMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_CREATETRIPMETHODRESULT;}
};

class rcfi_tclMsgGetTripMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetTripMethodStart():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetTripMethodStart& operator=(const rcfi_tclMsgGetTripMethodStart& coRef);
   rcfi_tclMsgGetTripMethodStart(const rcfi_tclMsgGetTripMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetTripMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETTRIPMETHODSTART;}
};

class rcfi_tclMsgGetTripMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetTripMethodResult():TripHandle(),TrackedFlag(0),StartPosition(),SpeedProfiles(),UserProfiles() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetTripMethodResult& operator=(const rcfi_tclMsgGetTripMethodResult& coRef);
   rcfi_tclMsgGetTripMethodResult(const rcfi_tclMsgGetTripMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   tBool TrackedFlag;
   fi_tcl_LocationDescription StartPosition;
   fi_tcl_SpeedProfiles SpeedProfiles;
   fi_tcl_UserProfiles UserProfiles;
   std::vector<fi_tcl_TripSegment, std::allocator<fi_tcl_TripSegment> > TripDefinition;
   std::vector<fi_tcl_RouteHandleDescription, std::allocator<fi_tcl_RouteHandleDescription> > RouteDefinition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetTripMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETTRIPMETHODRESULT;}
};

class rcfi_tclMsgKillTripMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgKillTripMethodStart():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgKillTripMethodStart& operator=(const rcfi_tclMsgKillTripMethodStart& coRef);
   rcfi_tclMsgKillTripMethodStart(const rcfi_tclMsgKillTripMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgKillTripMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_KILLTRIPMETHODSTART;}
};

class rcfi_tclMsgKillTripMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgKillTripMethodResult():KilledTripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgKillTripMethodResult& operator=(const rcfi_tclMsgKillTripMethodResult& coRef);
   rcfi_tclMsgKillTripMethodResult(const rcfi_tclMsgKillTripMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle KilledTripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgKillTripMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_KILLTRIPMETHODRESULT;}
};

class rcfi_tclMsgGetExistingTripHandlesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetExistingTripHandlesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetExistingTripHandlesMethodStart& operator=(const rcfi_tclMsgGetExistingTripHandlesMethodStart& coRef);
   rcfi_tclMsgGetExistingTripHandlesMethodStart(const rcfi_tclMsgGetExistingTripHandlesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetExistingTripHandlesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETEXISTINGTRIPHANDLESMETHODSTART;}
};

class rcfi_tclMsgGetExistingTripHandlesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetExistingTripHandlesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetExistingTripHandlesMethodResult& operator=(const rcfi_tclMsgGetExistingTripHandlesMethodResult& coRef);
   rcfi_tclMsgGetExistingTripHandlesMethodResult(const rcfi_tclMsgGetExistingTripHandlesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_TripHandle, std::allocator<fi_tcl_u16_TripHandle> > ExistingTripHandles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetExistingTripHandlesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETEXISTINGTRIPHANDLESMETHODRESULT;}
};

class rcfi_tclMsgAddTripSegmentToTripMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgAddTripSegmentToTripMethodStart():SourceTripHandle(),SegmentNumber(),TripSegmentDefinition(),AddTripSegmentParameters() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgAddTripSegmentToTripMethodStart& operator=(const rcfi_tclMsgAddTripSegmentToTripMethodStart& coRef);
   rcfi_tclMsgAddTripSegmentToTripMethodStart(const rcfi_tclMsgAddTripSegmentToTripMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle SourceTripHandle;
   fi_tcl_u16_TripSegmentNumber SegmentNumber;
   fi_tcl_TripSegment TripSegmentDefinition;
   std::vector<fi_tcl_RouteHandleDescription, std::allocator<fi_tcl_RouteHandleDescription> > RouteHandleDescription;
   fi_tcl_b8_AddTripSegmentParameters AddTripSegmentParameters;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgAddTripSegmentToTripMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ADDTRIPSEGMENTTOTRIPMETHODSTART;}
};

class rcfi_tclMsgAddTripSegmentToTripMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgAddTripSegmentToTripMethodResult():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgAddTripSegmentToTripMethodResult& operator=(const rcfi_tclMsgAddTripSegmentToTripMethodResult& coRef);
   rcfi_tclMsgAddTripSegmentToTripMethodResult(const rcfi_tclMsgAddTripSegmentToTripMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgAddTripSegmentToTripMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ADDTRIPSEGMENTTOTRIPMETHODRESULT;}
};

class rcfi_tclMsgStartRouteCalculationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgStartRouteCalculationMethodStart():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgStartRouteCalculationMethodStart& operator=(const rcfi_tclMsgStartRouteCalculationMethodStart& coRef);
   rcfi_tclMsgStartRouteCalculationMethodStart(const rcfi_tclMsgStartRouteCalculationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_RouteHandleDescription, std::allocator<fi_tcl_RouteHandleDescription> > RouteHandleDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgStartRouteCalculationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_STARTROUTECALCULATIONMETHODSTART;}
};

class rcfi_tclMsgStartRouteCalculationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgStartRouteCalculationMethodResult():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgStartRouteCalculationMethodResult& operator=(const rcfi_tclMsgStartRouteCalculationMethodResult& coRef);
   rcfi_tclMsgStartRouteCalculationMethodResult(const rcfi_tclMsgStartRouteCalculationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_u16_RouteHandle, std::allocator<fi_tcl_u16_RouteHandle> > RouteHandle;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgStartRouteCalculationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_STARTROUTECALCULATIONMETHODRESULT;}
};

class rcfi_tclMsgStopRouteCalculationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgStopRouteCalculationMethodStart():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgStopRouteCalculationMethodStart& operator=(const rcfi_tclMsgStopRouteCalculationMethodStart& coRef);
   rcfi_tclMsgStopRouteCalculationMethodStart(const rcfi_tclMsgStopRouteCalculationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_u16_RouteHandle, std::allocator<fi_tcl_u16_RouteHandle> > RouteHandle;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgStopRouteCalculationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_STOPROUTECALCULATIONMETHODSTART;}
};

class rcfi_tclMsgStopRouteCalculationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgStopRouteCalculationMethodResult():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgStopRouteCalculationMethodResult& operator=(const rcfi_tclMsgStopRouteCalculationMethodResult& coRef);
   rcfi_tclMsgStopRouteCalculationMethodResult(const rcfi_tclMsgStopRouteCalculationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_u16_RouteHandle, std::allocator<fi_tcl_u16_RouteHandle> > RouteHandle;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgStopRouteCalculationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_STOPROUTECALCULATIONMETHODRESULT;}
};

class rcfi_tclMsgSetTrackedSegmentMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetTrackedSegmentMethodStart():TripHandle(),TripSegmentNumber(),SegmentSkippingMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetTrackedSegmentMethodStart& operator=(const rcfi_tclMsgSetTrackedSegmentMethodStart& coRef);
   rcfi_tclMsgSetTrackedSegmentMethodStart(const rcfi_tclMsgSetTrackedSegmentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   fi_tcl_e8_SegmentSkippingMode SegmentSkippingMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetTrackedSegmentMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETTRACKEDSEGMENTMETHODSTART;}
};

class rcfi_tclMsgSetTrackedSegmentMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetTrackedSegmentMethodResult():TripHandle(),TripSegmentNumber() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetTrackedSegmentMethodResult& operator=(const rcfi_tclMsgSetTrackedSegmentMethodResult& coRef);
   rcfi_tclMsgSetTrackedSegmentMethodResult(const rcfi_tclMsgSetTrackedSegmentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetTrackedSegmentMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETTRACKEDSEGMENTMETHODRESULT;}
};

class rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart& operator=(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart& coRef);
   rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_ActiveManipSourcesOfRoute, std::allocator<fi_tcl_ActiveManipSourcesOfRoute> > ActiveManipSourcesOfRoute;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_CHANGEDYNAMICROUTECALCMODEMETHODSTART;}
};

class rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult& operator=(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult& coRef);
   rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_u16_RouteHandle, std::allocator<fi_tcl_u16_RouteHandle> > RouteHandle;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_CHANGEDYNAMICROUTECALCMODEMETHODRESULT;}
};

class rcfi_tclMsgSelectTrafficScenarioMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSelectTrafficScenarioMethodStart():TripHandle(),RouteHandle(),TrafficMessageRevision(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSelectTrafficScenarioMethodStart& operator=(const rcfi_tclMsgSelectTrafficScenarioMethodStart& coRef);
   rcfi_tclMsgSelectTrafficScenarioMethodStart(const rcfi_tclMsgSelectTrafficScenarioMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   tU32 TrafficMessageRevision;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSelectTrafficScenarioMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SELECTTRAFFICSCENARIOMETHODSTART;}
};

class rcfi_tclMsgSelectTrafficScenarioMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSelectTrafficScenarioMethodResult():TrafficMessageRevision(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSelectTrafficScenarioMethodResult& operator=(const rcfi_tclMsgSelectTrafficScenarioMethodResult& coRef);
   rcfi_tclMsgSelectTrafficScenarioMethodResult(const rcfi_tclMsgSelectTrafficScenarioMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 TrafficMessageRevision;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSelectTrafficScenarioMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SELECTTRAFFICSCENARIOMETHODRESULT;}
};

class rcfi_tclMsgSetCalculationModeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetCalculationModeMethodStart():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetCalculationModeMethodStart& operator=(const rcfi_tclMsgSetCalculationModeMethodStart& coRef);
   rcfi_tclMsgSetCalculationModeMethodStart(const rcfi_tclMsgSetCalculationModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_CalculationMode, std::allocator<fi_tcl_CalculationMode> > CalculationModes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetCalculationModeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETCALCULATIONMODEMETHODSTART;}
};

class rcfi_tclMsgSetCalculationModeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetCalculationModeMethodResult():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetCalculationModeMethodResult& operator=(const rcfi_tclMsgSetCalculationModeMethodResult& coRef);
   rcfi_tclMsgSetCalculationModeMethodResult(const rcfi_tclMsgSetCalculationModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetCalculationModeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETCALCULATIONMODEMETHODRESULT;}
};

class rcfi_tclMsgGetCalculationModeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetCalculationModeMethodStart():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetCalculationModeMethodStart& operator=(const rcfi_tclMsgGetCalculationModeMethodStart& coRef);
   rcfi_tclMsgGetCalculationModeMethodStart(const rcfi_tclMsgGetCalculationModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetCalculationModeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETCALCULATIONMODEMETHODSTART;}
};

class rcfi_tclMsgGetCalculationModeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetCalculationModeMethodResult():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetCalculationModeMethodResult& operator=(const rcfi_tclMsgGetCalculationModeMethodResult& coRef);
   rcfi_tclMsgGetCalculationModeMethodResult(const rcfi_tclMsgGetCalculationModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_CalculationMode, std::allocator<fi_tcl_CalculationMode> > CalculationModes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetCalculationModeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETCALCULATIONMODEMETHODRESULT;}
};

class rcfi_tclMsgGetAvailableRouteInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetAvailableRouteInfoMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetAvailableRouteInfoMethodStart& operator=(const rcfi_tclMsgGetAvailableRouteInfoMethodStart& coRef);
   rcfi_tclMsgGetAvailableRouteInfoMethodStart(const rcfi_tclMsgGetAvailableRouteInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetAvailableRouteInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETAVAILABLEROUTEINFOMETHODSTART;}
};

class rcfi_tclMsgGetAvailableRouteInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetAvailableRouteInfoMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetAvailableRouteInfoMethodResult& operator=(const rcfi_tclMsgGetAvailableRouteInfoMethodResult& coRef);
   rcfi_tclMsgGetAvailableRouteInfoMethodResult(const rcfi_tclMsgGetAvailableRouteInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e8_RouteInfoCategory, std::allocator<fi_tcl_e8_RouteInfoCategory> > RouteInfoCategory;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetAvailableRouteInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETAVAILABLEROUTEINFOMETHODRESULT;}
};

class rcfi_tclMsgGetRouteInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetRouteInfoMethodStart():TripHandle(),RouteHandle(),LastRequiredTripSegment(),NavUTMBinContainerMajorVersion(0),MapRouteBinContainerMajorVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetRouteInfoMethodStart& operator=(const rcfi_tclMsgGetRouteInfoMethodStart& coRef);
   rcfi_tclMsgGetRouteInfoMethodStart(const rcfi_tclMsgGetRouteInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber LastRequiredTripSegment;
   tU16 NavUTMBinContainerMajorVersion;
   tU16 MapRouteBinContainerMajorVersion;
   std::vector<fi_tcl_e8_RouteInfoCategory, std::allocator<fi_tcl_e8_RouteInfoCategory> > RouteInfoCategory;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetRouteInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETROUTEINFOMETHODSTART;}
};

class rcfi_tclMsgGetRouteInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetRouteInfoMethodResult():TripHandle(),RouteHandle(),RouteInfoId(0),RouteInfoCounter(0),FirstElement(),RouteInfoStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetRouteInfoMethodResult& operator=(const rcfi_tclMsgGetRouteInfoMethodResult& coRef);
   rcfi_tclMsgGetRouteInfoMethodResult(const rcfi_tclMsgGetRouteInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   tU32 RouteInfoId;
   tU16 RouteInfoCounter;
   fi_tcl_FirstElement FirstElement;
   fi_tcl_SingleRouteInfoStatus RouteInfoStatus;
   std::vector<fi_tcl_RouteInfoElement, std::allocator<fi_tcl_RouteInfoElement> > RouteInfoElementList;
   std::vector<fi_tcl_RouteInfoCategory, std::allocator<fi_tcl_RouteInfoCategory> > RouteInfoCategoryList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetRouteInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETROUTEINFOMETHODRESULT;}
};

class rcfi_tclMsgGetNavRouteListDepictionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetNavRouteListDepictionMethodStart():TripHandle(),RouteHandle(),RouteListId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetNavRouteListDepictionMethodStart& operator=(const rcfi_tclMsgGetNavRouteListDepictionMethodStart& coRef);
   rcfi_tclMsgGetNavRouteListDepictionMethodStart(const rcfi_tclMsgGetNavRouteListDepictionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   tU32 RouteListId;
   std::vector<fi_tcl_PathListToDepict, std::allocator<fi_tcl_PathListToDepict> > TripSegmentListToDepict;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetNavRouteListDepictionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETNAVROUTELISTDEPICTIONMETHODSTART;}
};

class rcfi_tclMsgGetNavRouteListDepictionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetNavRouteListDepictionMethodResult():TripHandle(),RouteHandle(),RouteListId(0),NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetNavRouteListDepictionMethodResult& operator=(const rcfi_tclMsgGetNavRouteListDepictionMethodResult& coRef);
   rcfi_tclMsgGetNavRouteListDepictionMethodResult(const rcfi_tclMsgGetNavRouteListDepictionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   tU32 RouteListId;
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_DepictedDataPathListSet, std::allocator<fi_tcl_DepictedDataPathListSet> > DepictedTripSegmentList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetNavRouteListDepictionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETNAVROUTELISTDEPICTIONMETHODRESULT;}
};

class rcfi_tclMsgGetClusterListsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetClusterListsMethodStart():TripHandle(),RouteHandle(),ClusterListTypes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetClusterListsMethodStart& operator=(const rcfi_tclMsgGetClusterListsMethodStart& coRef);
   rcfi_tclMsgGetClusterListsMethodStart(const rcfi_tclMsgGetClusterListsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   std::vector<fi_tcl_u16_TripSegmentNumber, std::allocator<fi_tcl_u16_TripSegmentNumber> > TripSegmentNumberList;
   fi_tcl_b8_RouteSegmentCLTypes ClusterListTypes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetClusterListsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETCLUSTERLISTSMETHODSTART;}
};

class rcfi_tclMsgGetClusterListsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetClusterListsMethodResult():TripHandle(),RouteHandle(),NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetClusterListsMethodResult& operator=(const rcfi_tclMsgGetClusterListsMethodResult& coRef);
   rcfi_tclMsgGetClusterListsMethodResult(const rcfi_tclMsgGetClusterListsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_RouteSegmentCL, std::allocator<fi_tcl_RouteSegmentCL> > RouteSegmentClusterLists;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetClusterListsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETCLUSTERLISTSMETHODRESULT;}
};

class rcfi_tclMsgEvaluatePositionsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgEvaluatePositionsMethodStart():TripHandle(),RouteHandle(),CurrentTripSegment() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgEvaluatePositionsMethodStart& operator=(const rcfi_tclMsgEvaluatePositionsMethodStart& coRef);
   rcfi_tclMsgEvaluatePositionsMethodStart(const rcfi_tclMsgEvaluatePositionsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber CurrentTripSegment;
   std::vector<fi_tcl_PositionDescription, std::allocator<fi_tcl_PositionDescription> > Positions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgEvaluatePositionsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_EVALUATEPOSITIONSMETHODSTART;}
};

class rcfi_tclMsgEvaluatePositionsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgEvaluatePositionsMethodResult():TripHandle(),RouteHandle(),CurrentTripSegment() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgEvaluatePositionsMethodResult& operator=(const rcfi_tclMsgEvaluatePositionsMethodResult& coRef);
   rcfi_tclMsgEvaluatePositionsMethodResult(const rcfi_tclMsgEvaluatePositionsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber CurrentTripSegment;
   std::vector<fi_tcl_EvaluatedPosition, std::allocator<fi_tcl_EvaluatedPosition> > EvaluatedPositions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgEvaluatePositionsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_EVALUATEPOSITIONSMETHODRESULT;}
};

class rcfi_tclMsgVerifyNewTrafficMessagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgVerifyNewTrafficMessagesMethodStart():TrafficMessageStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgVerifyNewTrafficMessagesMethodStart& operator=(const rcfi_tclMsgVerifyNewTrafficMessagesMethodStart& coRef);
   rcfi_tclMsgVerifyNewTrafficMessagesMethodStart(const rcfi_tclMsgVerifyNewTrafficMessagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficMessageStatus TrafficMessageStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgVerifyNewTrafficMessagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_VERIFYNEWTRAFFICMESSAGESMETHODSTART;}
};

class rcfi_tclMsgVerifyNewTrafficMessagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgVerifyNewTrafficMessagesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgVerifyNewTrafficMessagesMethodResult& operator=(const rcfi_tclMsgVerifyNewTrafficMessagesMethodResult& coRef);
   rcfi_tclMsgVerifyNewTrafficMessagesMethodResult(const rcfi_tclMsgVerifyNewTrafficMessagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgVerifyNewTrafficMessagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_VERIFYNEWTRAFFICMESSAGESMETHODRESULT;}
};

class rcfi_tclMsgActivateRouteCalculationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgActivateRouteCalculationMethodStart():TripHandle(),RouteHandle(),TripSegmentNumber(),RouteCalcProperty(),SpeedProfiles(),UserProfiles(),SegmentStartPoint(),TripStartTime(),TrackedSegment(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgActivateRouteCalculationMethodStart& operator=(const rcfi_tclMsgActivateRouteCalculationMethodStart& coRef);
   rcfi_tclMsgActivateRouteCalculationMethodStart(const rcfi_tclMsgActivateRouteCalculationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   fi_tcl_NavRouteCalcProperty RouteCalcProperty;
   fi_tcl_SpeedProfiles SpeedProfiles;
   fi_tcl_UserProfiles UserProfiles;
   fi_tcl_NavRCalcRouteStartPointUnionType SegmentStartPoint;
   std::vector<fi_tcl_NavSubDestinationList, std::allocator<fi_tcl_NavSubDestinationList> > SegmentDestinationList;
   fi_tcl_POSIXTime TripStartTime;
   tBool TrackedSegment;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgActivateRouteCalculationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ACTIVATEROUTECALCULATIONMETHODSTART;}
};

class rcfi_tclMsgActivateRouteCalculationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgActivateRouteCalculationMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber(),JobId(0),GlueAreaDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgActivateRouteCalculationMethodResult& operator=(const rcfi_tclMsgActivateRouteCalculationMethodResult& coRef);
   rcfi_tclMsgActivateRouteCalculationMethodResult(const rcfi_tclMsgActivateRouteCalculationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 JobId;
   fi_tcl_GlueAreaDesc GlueAreaDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgActivateRouteCalculationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ACTIVATEROUTECALCULATIONMETHODRESULT;}
};

class rcfi_tclMsgDeactivateRouteCalculationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgDeactivateRouteCalculationMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgDeactivateRouteCalculationMethodStart& operator=(const rcfi_tclMsgDeactivateRouteCalculationMethodStart& coRef);
   rcfi_tclMsgDeactivateRouteCalculationMethodStart(const rcfi_tclMsgDeactivateRouteCalculationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgDeactivateRouteCalculationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_DEACTIVATEROUTECALCULATIONMETHODSTART;}
};

class rcfi_tclMsgDeactivateRouteCalculationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgDeactivateRouteCalculationMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber(),JobId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgDeactivateRouteCalculationMethodResult& operator=(const rcfi_tclMsgDeactivateRouteCalculationMethodResult& coRef);
   rcfi_tclMsgDeactivateRouteCalculationMethodResult(const rcfi_tclMsgDeactivateRouteCalculationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 JobId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgDeactivateRouteCalculationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_DEACTIVATEROUTECALCULATIONMETHODRESULT;}
};

class rcfi_tclMsgSetPositionAndUpdateRouteMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetPositionAndUpdateRouteMethodStart():NavDataSetID(),CalcCarPosition(),RealCarPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetPositionAndUpdateRouteMethodStart& operator=(const rcfi_tclMsgSetPositionAndUpdateRouteMethodStart& coRef);
   rcfi_tclMsgSetPositionAndUpdateRouteMethodStart(const rcfi_tclMsgSetPositionAndUpdateRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_NavRCalcPositionDesc CalcCarPosition;
   fi_tcl_NavRCalcPositionDesc RealCarPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetPositionAndUpdateRouteMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETPOSITIONANDUPDATEROUTEMETHODSTART;}
};

class rcfi_tclMsgSetPositionAndUpdateRouteMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetPositionAndUpdateRouteMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetPositionAndUpdateRouteMethodResult& operator=(const rcfi_tclMsgSetPositionAndUpdateRouteMethodResult& coRef);
   rcfi_tclMsgSetPositionAndUpdateRouteMethodResult(const rcfi_tclMsgSetPositionAndUpdateRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetPositionAndUpdateRouteMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETPOSITIONANDUPDATEROUTEMETHODRESULT;}
};

class rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart():RouteCalcProperty() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart& operator=(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart& coRef);
   rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavRouteCalcProperty RouteCalcProperty;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETCRITERIONANDUPDATEROUTEMETHODSTART;}
};

class rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber(),JobId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult& operator=(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult& coRef);
   rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 JobId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETCRITERIONANDUPDATEROUTEMETHODRESULT;}
};

class rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart():TrafficMessageStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart& operator=(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart& coRef);
   rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficMessageStatus TrafficMessageStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETTRAFFICMESSAGESANDUPDATEROUTEMETHODSTART;}
};

class rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber(),JobId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult& operator=(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult& coRef);
   rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 JobId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETTRAFFICMESSAGESANDUPDATEROUTEMETHODRESULT;}
};

class rcfi_tclMsgCopyCalculationJobMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgCopyCalculationJobMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgCopyCalculationJobMethodStart& operator=(const rcfi_tclMsgCopyCalculationJobMethodStart& coRef);
   rcfi_tclMsgCopyCalculationJobMethodStart(const rcfi_tclMsgCopyCalculationJobMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgCopyCalculationJobMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_COPYCALCULATIONJOBMETHODSTART;}
};

class rcfi_tclMsgCopyCalculationJobMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgCopyCalculationJobMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber(),GlueAreaTree(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgCopyCalculationJobMethodResult& operator=(const rcfi_tclMsgCopyCalculationJobMethodResult& coRef);
   rcfi_tclMsgCopyCalculationJobMethodResult(const rcfi_tclMsgCopyCalculationJobMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tS32 GlueAreaTree;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgCopyCalculationJobMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_COPYCALCULATIONJOBMETHODRESULT;}
};

class rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart():TripHandle(),RouteHandle(),TripSegmentNumber(),RouteCalcProperty(),UserProfiles(),SegmentStartPoint(),GlueAreaTree(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart& operator=(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart& coRef);
   rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   fi_tcl_NavRouteCalcProperty RouteCalcProperty;
   fi_tcl_UserProfiles UserProfiles;
   fi_tcl_NavRCalcRouteStartPointUnionType SegmentStartPoint;
   std::vector<fi_tcl_NavSubDestinationList, std::allocator<fi_tcl_NavSubDestinationList> > SegmentDestinationList;
   tS32 GlueAreaTree;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETCALCULATIONJOBANDACTIVATEROUTEMETHODSTART;}
};

class rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber(),JobId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult& operator=(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult& coRef);
   rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 JobId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETCALCULATIONJOBANDACTIVATEROUTEMETHODRESULT;}
};

class rcfi_tclMsgGetGlueAreaDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetGlueAreaDescriptionMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetGlueAreaDescriptionMethodStart& operator=(const rcfi_tclMsgGetGlueAreaDescriptionMethodStart& coRef);
   rcfi_tclMsgGetGlueAreaDescriptionMethodStart(const rcfi_tclMsgGetGlueAreaDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetGlueAreaDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETGLUEAREADESCRIPTIONMETHODSTART;}
};

class rcfi_tclMsgGetGlueAreaDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgGetGlueAreaDescriptionMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber(),GlueAreaTree(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgGetGlueAreaDescriptionMethodResult& operator=(const rcfi_tclMsgGetGlueAreaDescriptionMethodResult& coRef);
   rcfi_tclMsgGetGlueAreaDescriptionMethodResult(const rcfi_tclMsgGetGlueAreaDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tS32 GlueAreaTree;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgGetGlueAreaDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_GETGLUEAREADESCRIPTIONMETHODRESULT;}
};

class rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart():NavDataSetID(),OffroadCoordinates() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart& operator=(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart& coRef);
   rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_EntryPoint, std::allocator<fi_tcl_EntryPoint> > EntryPointList;
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_PositionWGS84 OffroadCoordinates;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETENTRYPOINTSANDUPDATEROUTEMETHODSTART;}
};

class rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult():TripHandle(),RouteHandle(),TripSegmentNumber(),EntryPointInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult& operator=(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult& coRef);
   rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   fi_tcl_EntryPointInfo EntryPointInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SETENTRYPOINTSANDUPDATEROUTEMETHODRESULT;}
};

class rcfi_tclMsgSwitchMissionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSwitchMissionMethodStart():TripHandle(),RouteHandle(),TripSegmentNumber() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSwitchMissionMethodStart& operator=(const rcfi_tclMsgSwitchMissionMethodStart& coRef);
   rcfi_tclMsgSwitchMissionMethodStart(const rcfi_tclMsgSwitchMissionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSwitchMissionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SWITCHMISSIONMETHODSTART;}
};

class rcfi_tclMsgSwitchMissionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgSwitchMissionMethodResult():OldTripHandle(),OldRouteHandle(),OldTripSegmentNumber(),NewTripHandle(),NewRouteHandle(),NewTripSegmentNumber(),JobId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgSwitchMissionMethodResult& operator=(const rcfi_tclMsgSwitchMissionMethodResult& coRef);
   rcfi_tclMsgSwitchMissionMethodResult(const rcfi_tclMsgSwitchMissionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle OldTripHandle;
   fi_tcl_u16_RouteHandle OldRouteHandle;
   fi_tcl_u16_TripSegmentNumber OldTripSegmentNumber;
   fi_tcl_u16_TripHandle NewTripHandle;
   fi_tcl_u16_RouteHandle NewRouteHandle;
   fi_tcl_u16_TripSegmentNumber NewTripSegmentNumber;
   tU32 JobId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgSwitchMissionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_SWITCHMISSIONMETHODRESULT;}
};

class rcfi_tclMsgUpdateRouteInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgUpdateRouteInfoMethodStart():TripHandle(),RouteHandle(),RouteList(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgUpdateRouteInfoMethodStart& operator=(const rcfi_tclMsgUpdateRouteInfoMethodStart& coRef);
   rcfi_tclMsgUpdateRouteInfoMethodStart(const rcfi_tclMsgUpdateRouteInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   tS32 RouteList;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgUpdateRouteInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_UPDATEROUTEINFOMETHODSTART;}
};

class rcfi_tclMsgUpdateRouteInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgUpdateRouteInfoMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgUpdateRouteInfoMethodResult& operator=(const rcfi_tclMsgUpdateRouteInfoMethodResult& coRef);
   rcfi_tclMsgUpdateRouteInfoMethodResult(const rcfi_tclMsgUpdateRouteInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgUpdateRouteInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_UPDATEROUTEINFOMETHODRESULT;}
};

class rcfi_tclMsgDepictNavDataListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgDepictNavDataListMethodStart():NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgDepictNavDataListMethodStart& operator=(const rcfi_tclMsgDepictNavDataListMethodStart& coRef);
   rcfi_tclMsgDepictNavDataListMethodStart(const rcfi_tclMsgDepictNavDataListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_PathDataListSetToDepict, std::allocator<fi_tcl_PathDataListSetToDepict> > PathDataListToDepict;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgDepictNavDataListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_DEPICTNAVDATALISTMETHODSTART;}
};

class rcfi_tclMsgDepictNavDataListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgDepictNavDataListMethodResult():NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgDepictNavDataListMethodResult& operator=(const rcfi_tclMsgDepictNavDataListMethodResult& coRef);
   rcfi_tclMsgDepictNavDataListMethodResult(const rcfi_tclMsgDepictNavDataListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_DepictedDataPathListSet, std::allocator<fi_tcl_DepictedDataPathListSet> > DepictedDataPathList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgDepictNavDataListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_DEPICTNAVDATALISTMETHODRESULT;}
};

class rcfi_tclMsgStartLoadingMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgStartLoadingMethodStart():Strategy(),NavDataSetID(),Location() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgStartLoadingMethodStart& operator=(const rcfi_tclMsgStartLoadingMethodStart& coRef);
   rcfi_tclMsgStartLoadingMethodStart(const rcfi_tclMsgStartLoadingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LoadStrategy Strategy;
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_NavRCalcRouteStartPointUnionType Location;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgStartLoadingMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_STARTLOADINGMETHODSTART;}
};

class rcfi_tclMsgStartLoadingMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgStartLoadingMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgStartLoadingMethodResult& operator=(const rcfi_tclMsgStartLoadingMethodResult& coRef);
   rcfi_tclMsgStartLoadingMethodResult(const rcfi_tclMsgStartLoadingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgStartLoadingMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_STARTLOADINGMETHODRESULT;}
};

class rcfi_tclMsgStopLoadingMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgStopLoadingMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgStopLoadingMethodStart& operator=(const rcfi_tclMsgStopLoadingMethodStart& coRef);
   rcfi_tclMsgStopLoadingMethodStart(const rcfi_tclMsgStopLoadingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgStopLoadingMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_STOPLOADINGMETHODSTART;}
};

class rcfi_tclMsgStopLoadingMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgStopLoadingMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgStopLoadingMethodResult& operator=(const rcfi_tclMsgStopLoadingMethodResult& coRef);
   rcfi_tclMsgStopLoadingMethodResult(const rcfi_tclMsgStopLoadingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgStopLoadingMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_STOPLOADINGMETHODRESULT;}
};

class rcfi_tclMsgUpdatePositionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgUpdatePositionMethodStart():NavDataSetID(),CalcCarPosition(),RealCarPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgUpdatePositionMethodStart& operator=(const rcfi_tclMsgUpdatePositionMethodStart& coRef);
   rcfi_tclMsgUpdatePositionMethodStart(const rcfi_tclMsgUpdatePositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_NavRCalcPositionDesc CalcCarPosition;
   fi_tcl_NavRCalcPositionDesc RealCarPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgUpdatePositionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_UPDATEPOSITIONMETHODSTART;}
};

class rcfi_tclMsgUpdatePositionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgUpdatePositionMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgUpdatePositionMethodResult& operator=(const rcfi_tclMsgUpdatePositionMethodResult& coRef);
   rcfi_tclMsgUpdatePositionMethodResult(const rcfi_tclMsgUpdatePositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgUpdatePositionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_UPDATEPOSITIONMETHODRESULT;}
};

class rcfi_tclMsgTripStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgTripStatusGet():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgTripStatusGet& operator=(const rcfi_tclMsgTripStatusGet& coRef);
   rcfi_tclMsgTripStatusGet(const rcfi_tclMsgTripStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgTripStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_TRIPSTATUSGET;}
};

class rcfi_tclMsgTripStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgTripStatusStatus():TripHandle(),CurrentTrackedSegment(),TrackedTrip(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgTripStatusStatus& operator=(const rcfi_tclMsgTripStatusStatus& coRef);
   rcfi_tclMsgTripStatusStatus(const rcfi_tclMsgTripStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_TripSegmentNumber CurrentTrackedSegment;
   tBool TrackedTrip;
   std::vector<fi_tcl_RouteStatus, std::allocator<fi_tcl_RouteStatus> > RouteStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgTripStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_TRIPSTATUSSTATUS;}
};

class rcfi_tclMsgRouteInfoStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRouteInfoStatusGet():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRouteInfoStatusGet& operator=(const rcfi_tclMsgRouteInfoStatusGet& coRef);
   rcfi_tclMsgRouteInfoStatusGet(const rcfi_tclMsgRouteInfoStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRouteInfoStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ROUTEINFOSTATUSGET;}
};

class rcfi_tclMsgRouteInfoStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRouteInfoStatusStatus():TripHandleIsValid(0),TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRouteInfoStatusStatus& operator=(const rcfi_tclMsgRouteInfoStatusStatus& coRef);
   rcfi_tclMsgRouteInfoStatusStatus(const rcfi_tclMsgRouteInfoStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool TripHandleIsValid;
   fi_tcl_u16_TripHandle TripHandle;
   std::vector<fi_tcl_SingleRouteInfoStatus, std::allocator<fi_tcl_SingleRouteInfoStatus> > SingleRouteInfoStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRouteInfoStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ROUTEINFOSTATUSSTATUS;}
};

class rcfi_tclMsgDistanceTimeInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgDistanceTimeInfoGet():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgDistanceTimeInfoGet& operator=(const rcfi_tclMsgDistanceTimeInfoGet& coRef);
   rcfi_tclMsgDistanceTimeInfoGet(const rcfi_tclMsgDistanceTimeInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgDistanceTimeInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_DISTANCETIMEINFOGET;}
};

class rcfi_tclMsgDistanceTimeInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgDistanceTimeInfoStatus():TripHandleIsValid(0),TripHandle(),CurrentTripSegment(),VehicleHeading() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgDistanceTimeInfoStatus& operator=(const rcfi_tclMsgDistanceTimeInfoStatus& coRef);
   rcfi_tclMsgDistanceTimeInfoStatus(const rcfi_tclMsgDistanceTimeInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool TripHandleIsValid;
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_TripSegmentNumber CurrentTripSegment;
   fi_tcl_u8_DirectionAbsolute VehicleHeading;
   std::vector<fi_tcl_RouteDistanceTimeInfo, std::allocator<fi_tcl_RouteDistanceTimeInfo> > RouteDistanceTimeInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgDistanceTimeInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_DISTANCETIMEINFOSTATUS;}
};

class rcfi_tclMsgTravelValuesChangeUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgTravelValuesChangeUpReg():TripHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgTravelValuesChangeUpReg& operator=(const rcfi_tclMsgTravelValuesChangeUpReg& coRef);
   rcfi_tclMsgTravelValuesChangeUpReg(const rcfi_tclMsgTravelValuesChangeUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgTravelValuesChangeUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_TRAVELVALUESCHANGEUPREG;}
};

class rcfi_tclMsgTravelValuesChangeStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgTravelValuesChangeStatus():TripHandleIsValid(0),TripHandle(),CurrentTrackedSegment() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgTravelValuesChangeStatus& operator=(const rcfi_tclMsgTravelValuesChangeStatus& coRef);
   rcfi_tclMsgTravelValuesChangeStatus(const rcfi_tclMsgTravelValuesChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool TripHandleIsValid;
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_TripSegmentNumber CurrentTrackedSegment;
   std::vector<fi_tcl_RouteValuesChange, std::allocator<fi_tcl_RouteValuesChange> > RouteValuesChange;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgTravelValuesChangeStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_TRAVELVALUESCHANGESTATUS;}
};

class rcfi_tclMsgRouteCalculationStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRouteCalculationStatusGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRouteCalculationStatusGet& operator=(const rcfi_tclMsgRouteCalculationStatusGet& coRef);
   rcfi_tclMsgRouteCalculationStatusGet(const rcfi_tclMsgRouteCalculationStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRouteCalculationStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ROUTECALCULATIONSTATUSGET;}
};

class rcfi_tclMsgRouteCalculationStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRouteCalculationStatusStatus():TripHandle(),RouteHandle(),TripSegmentNumber(),JobId(0),ProcessStatus(),Quality(0xFF) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRouteCalculationStatusStatus& operator=(const rcfi_tclMsgRouteCalculationStatusStatus& coRef);
   rcfi_tclMsgRouteCalculationStatusStatus(const rcfi_tclMsgRouteCalculationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 JobId;
   fi_tcl_e8_RCalcProcessStatus ProcessStatus;
   fi_tcl_u8_Percent Quality;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRouteCalculationStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ROUTECALCULATIONSTATUSSTATUS;}
};

class rcfi_tclMsgRouteStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRouteStatusGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRouteStatusGet& operator=(const rcfi_tclMsgRouteStatusGet& coRef);
   rcfi_tclMsgRouteStatusGet(const rcfi_tclMsgRouteStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRouteStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ROUTESTATUSGET;}
};

class rcfi_tclMsgRouteStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRouteStatusStatus():TripHandle(),RouteHandle(),TripSegmentNumber(),JobId(0),TripSegmentStatus(),NavDataSetID(),RouteList(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRouteStatusStatus& operator=(const rcfi_tclMsgRouteStatusStatus& coRef);
   rcfi_tclMsgRouteStatusStatus(const rcfi_tclMsgRouteStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 JobId;
   fi_tcl_TripSegmentStatus TripSegmentStatus;
   fi_tcl_u32_DataSetId NavDataSetID;
   tS32 RouteList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRouteStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ROUTESTATUSSTATUS;}
};

class rcfi_tclMsgRDBAccessibilityGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRDBAccessibilityGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRDBAccessibilityGet& operator=(const rcfi_tclMsgRDBAccessibilityGet& coRef);
   rcfi_tclMsgRDBAccessibilityGet(const rcfi_tclMsgRDBAccessibilityGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRDBAccessibilityGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_RDBACCESSIBILITYGET;}
};

class rcfi_tclMsgRDBAccessibilityStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRDBAccessibilityStatus():MediumId(0),DataSetId(0),DataAccessibility() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRDBAccessibilityStatus& operator=(const rcfi_tclMsgRDBAccessibilityStatus& coRef);
   rcfi_tclMsgRDBAccessibilityStatus(const rcfi_tclMsgRDBAccessibilityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MediumId;
   tU32 DataSetId;
   fi_tcl_e8_DataAccessibility DataAccessibility;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRDBAccessibilityStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_RDBACCESSIBILITYSTATUS;}
};

class rcfi_tclMsgRDBLoaderStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRDBLoaderStatusGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRDBLoaderStatusGet& operator=(const rcfi_tclMsgRDBLoaderStatusGet& coRef);
   rcfi_tclMsgRDBLoaderStatusGet(const rcfi_tclMsgRDBLoaderStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRDBLoaderStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_RDBLOADERSTATUSGET;}
};

class rcfi_tclMsgRDBLoaderStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgRDBLoaderStatusStatus():NavDataSetID(),StrategyStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgRDBLoaderStatusStatus& operator=(const rcfi_tclMsgRDBLoaderStatusStatus& coRef);
   rcfi_tclMsgRDBLoaderStatusStatus(const rcfi_tclMsgRDBLoaderStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_StrategyStatus StrategyStatus;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgRDBLoaderStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_RDBLOADERSTATUSSTATUS;}
};

class rcfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgEngineeringTextGet& operator=(const rcfi_tclMsgEngineeringTextGet& coRef);
   rcfi_tclMsgEngineeringTextGet(const rcfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class rcfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgEngineeringTextUpReg& operator=(const rcfi_tclMsgEngineeringTextUpReg& coRef);
   rcfi_tclMsgEngineeringTextUpReg(const rcfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class rcfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgEngineeringTextRelUpReg& operator=(const rcfi_tclMsgEngineeringTextRelUpReg& coRef);
   rcfi_tclMsgEngineeringTextRelUpReg(const rcfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class rcfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgEngineeringTextStatus& operator=(const rcfi_tclMsgEngineeringTextStatus& coRef);
   rcfi_tclMsgEngineeringTextStatus(const rcfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};

class rcfi_tclMsgUsedDatasetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgUsedDatasetGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgUsedDatasetGet& operator=(const rcfi_tclMsgUsedDatasetGet& coRef);
   rcfi_tclMsgUsedDatasetGet(const rcfi_tclMsgUsedDatasetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgUsedDatasetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_USEDDATASETGET;}
};

class rcfi_tclMsgUsedDatasetUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgUsedDatasetUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgUsedDatasetUpReg& operator=(const rcfi_tclMsgUsedDatasetUpReg& coRef);
   rcfi_tclMsgUsedDatasetUpReg(const rcfi_tclMsgUsedDatasetUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgUsedDatasetUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_USEDDATASETUPREG;}
};

class rcfi_tclMsgUsedDatasetRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgUsedDatasetRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgUsedDatasetRelUpReg& operator=(const rcfi_tclMsgUsedDatasetRelUpReg& coRef);
   rcfi_tclMsgUsedDatasetRelUpReg(const rcfi_tclMsgUsedDatasetRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgUsedDatasetRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_USEDDATASETRELUPREG;}
};

class rcfi_tclMsgUsedDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rcfi_tclMsgUsedDatasetStatus():MediaId(),DataSetId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rcfi_tclMsgUsedDatasetStatus& operator=(const rcfi_tclMsgUsedDatasetStatus& coRef);
   rcfi_tclMsgUsedDatasetStatus(const rcfi_tclMsgUsedDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_MediaId MediaId;
   fi_tcl_u32_DataSetId DataSetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rcfi_tclMsgUsedDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rcfi_tclToken::EN_MSG_USEDDATASETSTATUS;}
};


#endif
