/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetUsedPositionPathMethodStart::posfi_tclMsgSetUsedPositionPathMethodStart(const posfi_tclMsgSetUsedPositionPathMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   PathId = coRef.PathId;
   SensorTime = coRef.SensorTime;
   PlaceBackPathIdList = coRef.PlaceBackPathIdList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetUsedPositionPathMethodStart& posfi_tclMsgSetUsedPositionPathMethodStart::operator=(const posfi_tclMsgSetUsedPositionPathMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PathId = coRef.PathId;
   SensorTime = coRef.SensorTime;
   PlaceBackPathIdList = coRef.PlaceBackPathIdList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetUsedPositionPathMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetUsedPositionPathMethodStart::u16GetFunctionID() const {return POSFI_C_U16_SETUSEDPOSITIONPATH;}
tU8 posfi_tclMsgSetUsedPositionPathMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid posfi_tclMsgSetUsedPositionPathMethodStart::vDestroy()
{
   PlaceBackPathIdList.clear();
}

tU32 posfi_tclMsgSetUsedPositionPathMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += PlaceBackPathIdList.size()*4;
   }
   return u32DynamicSize+8;
}

tBool posfi_tclMsgSetUsedPositionPathMethodStart::operator==(const posfi_tclMsgSetUsedPositionPathMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PathId == rfoCmp.PathId);
      bResult = bResult && (SensorTime == rfoCmp.SensorTime);
      bResult = bResult && (PlaceBackPathIdList.size() == rfoCmp.PlaceBackPathIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PlaceBackPathIdList.size()); ++u32Idx)
            bResult = bResult && (PlaceBackPathIdList[u32Idx] == rfoCmp.PlaceBackPathIdList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetUsedPositionPathMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> PathId;
   oIn >> SensorTime;
   if (15 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         PlaceBackPathIdList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> PlaceBackPathIdList[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetUsedPositionPathMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PathId;
   oOut << SensorTime;
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)PlaceBackPathIdList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < PlaceBackPathIdList.size(); ++u32Idx)
            oOut << PlaceBackPathIdList[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetUsedPositionPathMethodResult::posfi_tclMsgSetUsedPositionPathMethodResult(const posfi_tclMsgSetUsedPositionPathMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetUsedPositionPathMethodResult& posfi_tclMsgSetUsedPositionPathMethodResult::operator=(const posfi_tclMsgSetUsedPositionPathMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetUsedPositionPathMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetUsedPositionPathMethodResult::u16GetFunctionID() const {return POSFI_C_U16_SETUSEDPOSITIONPATH;}
tU8 posfi_tclMsgSetUsedPositionPathMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgSetUsedPositionPathMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSetUsedPositionPathMethodResult::operator==(const posfi_tclMsgSetUsedPositionPathMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetUsedPositionPathMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetUsedPositionPathMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgGetPositionDescriptionMethodStart::posfi_tclMsgGetPositionDescriptionMethodStart(const posfi_tclMsgGetPositionDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavLocationBinContainerMajorVersion = coRef.NavLocationBinContainerMajorVersion;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgGetPositionDescriptionMethodStart& posfi_tclMsgGetPositionDescriptionMethodStart::operator=(const posfi_tclMsgGetPositionDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavLocationBinContainerMajorVersion = coRef.NavLocationBinContainerMajorVersion;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgGetPositionDescriptionMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgGetPositionDescriptionMethodStart::u16GetFunctionID() const {return POSFI_C_U16_GETPOSITIONDESCRIPTION;}
tU8 posfi_tclMsgGetPositionDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgGetPositionDescriptionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+0;
}

tBool posfi_tclMsgGetPositionDescriptionMethodStart::operator==(const posfi_tclMsgGetPositionDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavLocationBinContainerMajorVersion == rfoCmp.NavLocationBinContainerMajorVersion);
   return bResult;
}

fi_tclInContext& posfi_tclMsgGetPositionDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> NavLocationBinContainerMajorVersion;
   }
   return oIn;
}

fi_tclOutContext& posfi_tclMsgGetPositionDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << NavLocationBinContainerMajorVersion;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgGetPositionDescriptionMethodResult::posfi_tclMsgGetPositionDescriptionMethodResult(const posfi_tclMsgGetPositionDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionDescription = coRef.PositionDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgGetPositionDescriptionMethodResult& posfi_tclMsgGetPositionDescriptionMethodResult::operator=(const posfi_tclMsgGetPositionDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PositionDescription = coRef.PositionDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgGetPositionDescriptionMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgGetPositionDescriptionMethodResult::u16GetFunctionID() const {return POSFI_C_U16_GETPOSITIONDESCRIPTION;}
tU8 posfi_tclMsgGetPositionDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid posfi_tclMsgGetPositionDescriptionMethodResult::vDestroy()
{
   PositionDescription.vDestroy(); 
}

tU32 posfi_tclMsgGetPositionDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+PositionDescription.u32GetSize(u16MajorVersion);
}

tBool posfi_tclMsgGetPositionDescriptionMethodResult::operator==(const posfi_tclMsgGetPositionDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionDescription == rfoCmp.PositionDescription);
   return bResult;
}

fi_tclInContext& posfi_tclMsgGetPositionDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> PositionDescription;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgGetPositionDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PositionDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetPositionByCoordinatesMethodStart::posfi_tclMsgSetPositionByCoordinatesMethodStart(const posfi_tclMsgSetPositionByCoordinatesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   WGS84Position = coRef.WGS84Position;
   Heading = coRef.Heading;
   PositionTolerance = coRef.PositionTolerance;
   HeadingTolerance = coRef.HeadingTolerance;
   RoadClassFilter = coRef.RoadClassFilter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetPositionByCoordinatesMethodStart& posfi_tclMsgSetPositionByCoordinatesMethodStart::operator=(const posfi_tclMsgSetPositionByCoordinatesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   WGS84Position = coRef.WGS84Position;
   Heading = coRef.Heading;
   PositionTolerance = coRef.PositionTolerance;
   HeadingTolerance = coRef.HeadingTolerance;
   RoadClassFilter = coRef.RoadClassFilter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetPositionByCoordinatesMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetPositionByCoordinatesMethodStart::u16GetFunctionID() const {return POSFI_C_U16_SETPOSITIONBYCOORDINATES;}
tU8 posfi_tclMsgSetPositionByCoordinatesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid posfi_tclMsgSetPositionByCoordinatesMethodStart::vDestroy()
{
   WGS84Position.vDestroy(); 
}

tU32 posfi_tclMsgSetPositionByCoordinatesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

tBool posfi_tclMsgSetPositionByCoordinatesMethodStart::operator==(const posfi_tclMsgSetPositionByCoordinatesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WGS84Position == rfoCmp.WGS84Position);
      bResult = bResult && (Heading == rfoCmp.Heading);
      bResult = bResult && (PositionTolerance == rfoCmp.PositionTolerance);
      bResult = bResult && (HeadingTolerance == rfoCmp.HeadingTolerance);
      bResult = bResult && (RoadClassFilter == rfoCmp.RoadClassFilter);
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetPositionByCoordinatesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> WGS84Position;
   oIn >> Heading;
   oIn >> PositionTolerance;
   oIn >> HeadingTolerance;
   oIn >> RoadClassFilter;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetPositionByCoordinatesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WGS84Position;
   oOut << Heading;
   oOut << PositionTolerance;
   oOut << HeadingTolerance;
   oOut << RoadClassFilter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetPositionByCoordinatesMethodResult::posfi_tclMsgSetPositionByCoordinatesMethodResult(const posfi_tclMsgSetPositionByCoordinatesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Success = coRef.Success;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetPositionByCoordinatesMethodResult& posfi_tclMsgSetPositionByCoordinatesMethodResult::operator=(const posfi_tclMsgSetPositionByCoordinatesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetPositionByCoordinatesMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetPositionByCoordinatesMethodResult::u16GetFunctionID() const {return POSFI_C_U16_SETPOSITIONBYCOORDINATES;}
tU8 posfi_tclMsgSetPositionByCoordinatesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgSetPositionByCoordinatesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool posfi_tclMsgSetPositionByCoordinatesMethodResult::operator==(const posfi_tclMsgSetPositionByCoordinatesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Success == rfoCmp.Success);
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetPositionByCoordinatesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Success;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetPositionByCoordinatesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Success;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetPositionByLocationMethodStart::posfi_tclMsgSetPositionByLocationMethodStart(const posfi_tclMsgSetPositionByLocationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LocationInfo = coRef.LocationInfo;
   Heading = coRef.Heading;
   DistanceToLocationInfo = coRef.DistanceToLocationInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetPositionByLocationMethodStart& posfi_tclMsgSetPositionByLocationMethodStart::operator=(const posfi_tclMsgSetPositionByLocationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LocationInfo = coRef.LocationInfo;
   Heading = coRef.Heading;
   DistanceToLocationInfo = coRef.DistanceToLocationInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetPositionByLocationMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetPositionByLocationMethodStart::u16GetFunctionID() const {return POSFI_C_U16_SETPOSITIONBYLOCATION;}
tU8 posfi_tclMsgSetPositionByLocationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid posfi_tclMsgSetPositionByLocationMethodStart::vDestroy()
{
   LocationInfo.vDestroy(); 
}

tU32 posfi_tclMsgSetPositionByLocationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+LocationInfo.u32GetSize(u16MajorVersion);
}

tBool posfi_tclMsgSetPositionByLocationMethodStart::operator==(const posfi_tclMsgSetPositionByLocationMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LocationInfo == rfoCmp.LocationInfo);
      bResult = bResult && (Heading == rfoCmp.Heading);
      bResult = bResult && (DistanceToLocationInfo == rfoCmp.DistanceToLocationInfo);
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetPositionByLocationMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LocationInfo;
   oIn >> Heading;
   oIn >> DistanceToLocationInfo;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetPositionByLocationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LocationInfo;
   oOut << Heading;
   oOut << DistanceToLocationInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetPositionByLocationMethodResult::posfi_tclMsgSetPositionByLocationMethodResult(const posfi_tclMsgSetPositionByLocationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Success = coRef.Success;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetPositionByLocationMethodResult& posfi_tclMsgSetPositionByLocationMethodResult::operator=(const posfi_tclMsgSetPositionByLocationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetPositionByLocationMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetPositionByLocationMethodResult::u16GetFunctionID() const {return POSFI_C_U16_SETPOSITIONBYLOCATION;}
tU8 posfi_tclMsgSetPositionByLocationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgSetPositionByLocationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool posfi_tclMsgSetPositionByLocationMethodResult::operator==(const posfi_tclMsgSetPositionByLocationMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Success == rfoCmp.Success);
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetPositionByLocationMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Success;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetPositionByLocationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Success;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetMatchingPermissionMethodStart::posfi_tclMsgSetMatchingPermissionMethodStart(const posfi_tclMsgSetMatchingPermissionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MatchingPermission = coRef.MatchingPermission;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetMatchingPermissionMethodStart& posfi_tclMsgSetMatchingPermissionMethodStart::operator=(const posfi_tclMsgSetMatchingPermissionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MatchingPermission = coRef.MatchingPermission;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetMatchingPermissionMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetMatchingPermissionMethodStart::u16GetFunctionID() const {return POSFI_C_U16_SETMATCHINGPERMISSION;}
tU8 posfi_tclMsgSetMatchingPermissionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgSetMatchingPermissionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool posfi_tclMsgSetMatchingPermissionMethodStart::operator==(const posfi_tclMsgSetMatchingPermissionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MatchingPermission == rfoCmp.MatchingPermission);
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetMatchingPermissionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MatchingPermission;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetMatchingPermissionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MatchingPermission;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetMatchingPermissionMethodResult::posfi_tclMsgSetMatchingPermissionMethodResult(const posfi_tclMsgSetMatchingPermissionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetMatchingPermissionMethodResult& posfi_tclMsgSetMatchingPermissionMethodResult::operator=(const posfi_tclMsgSetMatchingPermissionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetMatchingPermissionMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetMatchingPermissionMethodResult::u16GetFunctionID() const {return POSFI_C_U16_SETMATCHINGPERMISSION;}
tU8 posfi_tclMsgSetMatchingPermissionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgSetMatchingPermissionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSetMatchingPermissionMethodResult::operator==(const posfi_tclMsgSetMatchingPermissionMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetMatchingPermissionMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetMatchingPermissionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionActivateMethodStart::posfi_tclMsgSwitchPositionActivateMethodStart(const posfi_tclMsgSwitchPositionActivateMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionActivateMethodStart& posfi_tclMsgSwitchPositionActivateMethodStart::operator=(const posfi_tclMsgSwitchPositionActivateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionActivateMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionActivateMethodStart::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONACTIVATE;}
tU8 posfi_tclMsgSwitchPositionActivateMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgSwitchPositionActivateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionActivateMethodStart::operator==(const posfi_tclMsgSwitchPositionActivateMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionActivateMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionActivateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionActivateMethodResult::posfi_tclMsgSwitchPositionActivateMethodResult(const posfi_tclMsgSwitchPositionActivateMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionActivateMethodResult& posfi_tclMsgSwitchPositionActivateMethodResult::operator=(const posfi_tclMsgSwitchPositionActivateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionActivateMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionActivateMethodResult::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONACTIVATE;}
tU8 posfi_tclMsgSwitchPositionActivateMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgSwitchPositionActivateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionActivateMethodResult::operator==(const posfi_tclMsgSwitchPositionActivateMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionActivateMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionActivateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionDeactivateMethodStart::posfi_tclMsgSwitchPositionDeactivateMethodStart(const posfi_tclMsgSwitchPositionDeactivateMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionDeactivateMethodStart& posfi_tclMsgSwitchPositionDeactivateMethodStart::operator=(const posfi_tclMsgSwitchPositionDeactivateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionDeactivateMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionDeactivateMethodStart::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONDEACTIVATE;}
tU8 posfi_tclMsgSwitchPositionDeactivateMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgSwitchPositionDeactivateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionDeactivateMethodStart::operator==(const posfi_tclMsgSwitchPositionDeactivateMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionDeactivateMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionDeactivateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionDeactivateMethodResult::posfi_tclMsgSwitchPositionDeactivateMethodResult(const posfi_tclMsgSwitchPositionDeactivateMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionDeactivateMethodResult& posfi_tclMsgSwitchPositionDeactivateMethodResult::operator=(const posfi_tclMsgSwitchPositionDeactivateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionDeactivateMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionDeactivateMethodResult::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONDEACTIVATE;}
tU8 posfi_tclMsgSwitchPositionDeactivateMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgSwitchPositionDeactivateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionDeactivateMethodResult::operator==(const posfi_tclMsgSwitchPositionDeactivateMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionDeactivateMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionDeactivateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart& posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::operator=(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONTONEXTPOSSIBLEPOSITION;}
tU8 posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::operator==(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult& posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::operator=(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONTONEXTPOSSIBLEPOSITION;}
tU8 posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::operator==(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgActivatePresentationMethodStart::posfi_tclMsgActivatePresentationMethodStart(const posfi_tclMsgActivatePresentationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   VehiclePosition = coRef.VehiclePosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgActivatePresentationMethodStart& posfi_tclMsgActivatePresentationMethodStart::operator=(const posfi_tclMsgActivatePresentationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VehiclePosition = coRef.VehiclePosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgActivatePresentationMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgActivatePresentationMethodStart::u16GetFunctionID() const {return POSFI_C_U16_ACTIVATEPRESENTATION;}
tU8 posfi_tclMsgActivatePresentationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid posfi_tclMsgActivatePresentationMethodStart::vDestroy()
{
   VehiclePosition.vDestroy(); 
}

tU32 posfi_tclMsgActivatePresentationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VehiclePosition.u32GetSize(u16MajorVersion);
}

tBool posfi_tclMsgActivatePresentationMethodStart::operator==(const posfi_tclMsgActivatePresentationMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (VehiclePosition == rfoCmp.VehiclePosition);
   return bResult;
}

fi_tclInContext& posfi_tclMsgActivatePresentationMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> VehiclePosition;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgActivatePresentationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << VehiclePosition;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgActivatePresentationMethodResult::posfi_tclMsgActivatePresentationMethodResult(const posfi_tclMsgActivatePresentationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgActivatePresentationMethodResult& posfi_tclMsgActivatePresentationMethodResult::operator=(const posfi_tclMsgActivatePresentationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgActivatePresentationMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgActivatePresentationMethodResult::u16GetFunctionID() const {return POSFI_C_U16_ACTIVATEPRESENTATION;}
tU8 posfi_tclMsgActivatePresentationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgActivatePresentationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgActivatePresentationMethodResult::operator==(const posfi_tclMsgActivatePresentationMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgActivatePresentationMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgActivatePresentationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeactivatePresentationMethodStart::posfi_tclMsgDeactivatePresentationMethodStart(const posfi_tclMsgDeactivatePresentationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeactivatePresentationMethodStart& posfi_tclMsgDeactivatePresentationMethodStart::operator=(const posfi_tclMsgDeactivatePresentationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgDeactivatePresentationMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgDeactivatePresentationMethodStart::u16GetFunctionID() const {return POSFI_C_U16_DEACTIVATEPRESENTATION;}
tU8 posfi_tclMsgDeactivatePresentationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgDeactivatePresentationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgDeactivatePresentationMethodStart::operator==(const posfi_tclMsgDeactivatePresentationMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgDeactivatePresentationMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgDeactivatePresentationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeactivatePresentationMethodResult::posfi_tclMsgDeactivatePresentationMethodResult(const posfi_tclMsgDeactivatePresentationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeactivatePresentationMethodResult& posfi_tclMsgDeactivatePresentationMethodResult::operator=(const posfi_tclMsgDeactivatePresentationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgDeactivatePresentationMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgDeactivatePresentationMethodResult::u16GetFunctionID() const {return POSFI_C_U16_DEACTIVATEPRESENTATION;}
tU8 posfi_tclMsgDeactivatePresentationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgDeactivatePresentationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgDeactivatePresentationMethodResult::operator==(const posfi_tclMsgDeactivatePresentationMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgDeactivatePresentationMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgDeactivatePresentationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUpdatePresentationPositionMethodStart::posfi_tclMsgUpdatePresentationPositionMethodStart(const posfi_tclMsgUpdatePresentationPositionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   UseScalableSpeedTable = coRef.UseScalableSpeedTable;
   SpeedValue = coRef.SpeedValue;
   Steps = coRef.Steps;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUpdatePresentationPositionMethodStart& posfi_tclMsgUpdatePresentationPositionMethodStart::operator=(const posfi_tclMsgUpdatePresentationPositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   UseScalableSpeedTable = coRef.UseScalableSpeedTable;
   SpeedValue = coRef.SpeedValue;
   Steps = coRef.Steps;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgUpdatePresentationPositionMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgUpdatePresentationPositionMethodStart::u16GetFunctionID() const {return POSFI_C_U16_UPDATEPRESENTATIONPOSITION;}
tU8 posfi_tclMsgUpdatePresentationPositionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgUpdatePresentationPositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool posfi_tclMsgUpdatePresentationPositionMethodStart::operator==(const posfi_tclMsgUpdatePresentationPositionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (UseScalableSpeedTable == rfoCmp.UseScalableSpeedTable);
      bResult = bResult && (SpeedValue == rfoCmp.SpeedValue);
      bResult = bResult && (Steps == rfoCmp.Steps);
   return bResult;
}

fi_tclInContext& posfi_tclMsgUpdatePresentationPositionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> UseScalableSpeedTable;
   oIn >> SpeedValue;
   oIn >> Steps;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgUpdatePresentationPositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << UseScalableSpeedTable;
   oOut << SpeedValue;
   oOut << Steps;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUpdatePresentationPositionMethodResult::posfi_tclMsgUpdatePresentationPositionMethodResult(const posfi_tclMsgUpdatePresentationPositionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUpdatePresentationPositionMethodResult& posfi_tclMsgUpdatePresentationPositionMethodResult::operator=(const posfi_tclMsgUpdatePresentationPositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgUpdatePresentationPositionMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgUpdatePresentationPositionMethodResult::u16GetFunctionID() const {return POSFI_C_U16_UPDATEPRESENTATIONPOSITION;}
tU8 posfi_tclMsgUpdatePresentationPositionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgUpdatePresentationPositionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgUpdatePresentationPositionMethodResult::operator==(const posfi_tclMsgUpdatePresentationPositionMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgUpdatePresentationPositionMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgUpdatePresentationPositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCancelPresentationUpdateMethodStart::posfi_tclMsgCancelPresentationUpdateMethodStart(const posfi_tclMsgCancelPresentationUpdateMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCancelPresentationUpdateMethodStart& posfi_tclMsgCancelPresentationUpdateMethodStart::operator=(const posfi_tclMsgCancelPresentationUpdateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgCancelPresentationUpdateMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgCancelPresentationUpdateMethodStart::u16GetFunctionID() const {return POSFI_C_U16_CANCELPRESENTATIONUPDATE;}
tU8 posfi_tclMsgCancelPresentationUpdateMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgCancelPresentationUpdateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgCancelPresentationUpdateMethodStart::operator==(const posfi_tclMsgCancelPresentationUpdateMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgCancelPresentationUpdateMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgCancelPresentationUpdateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCancelPresentationUpdateMethodResult::posfi_tclMsgCancelPresentationUpdateMethodResult(const posfi_tclMsgCancelPresentationUpdateMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCancelPresentationUpdateMethodResult& posfi_tclMsgCancelPresentationUpdateMethodResult::operator=(const posfi_tclMsgCancelPresentationUpdateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgCancelPresentationUpdateMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgCancelPresentationUpdateMethodResult::u16GetFunctionID() const {return POSFI_C_U16_CANCELPRESENTATIONUPDATE;}
tU8 posfi_tclMsgCancelPresentationUpdateMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgCancelPresentationUpdateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgCancelPresentationUpdateMethodResult::operator==(const posfi_tclMsgCancelPresentationUpdateMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgCancelPresentationUpdateMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgCancelPresentationUpdateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgControlAutomOdometerCalibrationMethodStart::posfi_tclMsgControlAutomOdometerCalibrationMethodStart(const posfi_tclMsgControlAutomOdometerCalibrationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Operation = coRef.Operation;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgControlAutomOdometerCalibrationMethodStart& posfi_tclMsgControlAutomOdometerCalibrationMethodStart::operator=(const posfi_tclMsgControlAutomOdometerCalibrationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Operation = coRef.Operation;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgControlAutomOdometerCalibrationMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgControlAutomOdometerCalibrationMethodStart::u16GetFunctionID() const {return POSFI_C_U16_CONTROLAUTOMODOMETERCALIBRATION;}
tU8 posfi_tclMsgControlAutomOdometerCalibrationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgControlAutomOdometerCalibrationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool posfi_tclMsgControlAutomOdometerCalibrationMethodStart::operator==(const posfi_tclMsgControlAutomOdometerCalibrationMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Operation == rfoCmp.Operation);
   return bResult;
}

fi_tclInContext& posfi_tclMsgControlAutomOdometerCalibrationMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Operation;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgControlAutomOdometerCalibrationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Operation;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgControlAutomOdometerCalibrationMethodResult::posfi_tclMsgControlAutomOdometerCalibrationMethodResult(const posfi_tclMsgControlAutomOdometerCalibrationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgControlAutomOdometerCalibrationMethodResult& posfi_tclMsgControlAutomOdometerCalibrationMethodResult::operator=(const posfi_tclMsgControlAutomOdometerCalibrationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgControlAutomOdometerCalibrationMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgControlAutomOdometerCalibrationMethodResult::u16GetFunctionID() const {return POSFI_C_U16_CONTROLAUTOMODOMETERCALIBRATION;}
tU8 posfi_tclMsgControlAutomOdometerCalibrationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgControlAutomOdometerCalibrationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgControlAutomOdometerCalibrationMethodResult::operator==(const posfi_tclMsgControlAutomOdometerCalibrationMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgControlAutomOdometerCalibrationMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgControlAutomOdometerCalibrationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetData2DefaultMethodStart::posfi_tclMsgSetData2DefaultMethodStart(const posfi_tclMsgSetData2DefaultMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   Heading = coRef.Heading;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetData2DefaultMethodStart& posfi_tclMsgSetData2DefaultMethodStart::operator=(const posfi_tclMsgSetData2DefaultMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   Heading = coRef.Heading;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetData2DefaultMethodStart::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetData2DefaultMethodStart::u16GetFunctionID() const {return POSFI_C_U16_SETDATA2DEFAULT;}
tU8 posfi_tclMsgSetData2DefaultMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 posfi_tclMsgSetData2DefaultMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool posfi_tclMsgSetData2DefaultMethodStart::operator==(const posfi_tclMsgSetData2DefaultMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Longitude == rfoCmp.Longitude);
      bResult = bResult && (Latitude == rfoCmp.Latitude);
      bResult = bResult && (Heading == rfoCmp.Heading);
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetData2DefaultMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Longitude;
   oIn >> Latitude;
   oIn >> Heading;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetData2DefaultMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Longitude;
   oOut << Latitude;
   oOut << Heading;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetData2DefaultMethodResult::posfi_tclMsgSetData2DefaultMethodResult(const posfi_tclMsgSetData2DefaultMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSetData2DefaultMethodResult& posfi_tclMsgSetData2DefaultMethodResult::operator=(const posfi_tclMsgSetData2DefaultMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSetData2DefaultMethodResult::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSetData2DefaultMethodResult::u16GetFunctionID() const {return POSFI_C_U16_SETDATA2DEFAULT;}
tU8 posfi_tclMsgSetData2DefaultMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 posfi_tclMsgSetData2DefaultMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSetData2DefaultMethodResult::operator==(const posfi_tclMsgSetData2DefaultMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSetData2DefaultMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSetData2DefaultMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionUpReg::posfi_tclMsgExtendedPositionUpReg(const posfi_tclMsgExtendedPositionUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionUpReg& posfi_tclMsgExtendedPositionUpReg::operator=(const posfi_tclMsgExtendedPositionUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtendedPositionUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtendedPositionUpReg::u16GetFunctionID() const {return POSFI_C_U16_EXTENDEDPOSITION;}
tU8 posfi_tclMsgExtendedPositionUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgExtendedPositionUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgExtendedPositionUpReg::operator==(const posfi_tclMsgExtendedPositionUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtendedPositionUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtendedPositionUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionRelUpReg::posfi_tclMsgExtendedPositionRelUpReg(const posfi_tclMsgExtendedPositionRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionRelUpReg& posfi_tclMsgExtendedPositionRelUpReg::operator=(const posfi_tclMsgExtendedPositionRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtendedPositionRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtendedPositionRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_EXTENDEDPOSITION;}
tU8 posfi_tclMsgExtendedPositionRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgExtendedPositionRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgExtendedPositionRelUpReg::operator==(const posfi_tclMsgExtendedPositionRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtendedPositionRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtendedPositionRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionStatus::posfi_tclMsgExtendedPositionStatus(const posfi_tclMsgExtendedPositionStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   StartPathList = coRef.StartPathList;
   SensorPosixTime = coRef.SensorPosixTime;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionStatus& posfi_tclMsgExtendedPositionStatus::operator=(const posfi_tclMsgExtendedPositionStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   StartPathList = coRef.StartPathList;
   SensorPosixTime = coRef.SensorPosixTime;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtendedPositionStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtendedPositionStatus::u16GetFunctionID() const {return POSFI_C_U16_EXTENDEDPOSITION;}
tU8 posfi_tclMsgExtendedPositionStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgExtendedPositionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StartPathList.size(); ++u32Idx)
         StartPathList[u32Idx].vDestroy();
   }
   StartPathList.clear();
   SensorPosixTime.vDestroy(); 
}

tU32 posfi_tclMsgExtendedPositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14+StartPathList.size()*15;
}

tBool posfi_tclMsgExtendedPositionStatus::operator==(const posfi_tclMsgExtendedPositionStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (StartPathList.size() == rfoCmp.StartPathList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StartPathList.size()); ++u32Idx)
            bResult = bResult && (StartPathList[u32Idx] == rfoCmp.StartPathList[u32Idx]);
      }
      bResult = bResult && (SensorPosixTime == rfoCmp.SensorPosixTime);
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtendedPositionStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StartPathList.size(); ++u32Idx)
      {
         StartPathList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StartPathList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StartPathList[u32Idx];
      }
   }
   oIn >> SensorPosixTime;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtendedPositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << (tU32)StartPathList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StartPathList.size(); ++u32Idx)
         oOut << StartPathList[u32Idx];
   }
   oOut << SensorPosixTime;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionHorizonUpReg::posfi_tclMsgExtendedPositionHorizonUpReg(const posfi_tclMsgExtendedPositionHorizonUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionHorizonUpReg& posfi_tclMsgExtendedPositionHorizonUpReg::operator=(const posfi_tclMsgExtendedPositionHorizonUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtendedPositionHorizonUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtendedPositionHorizonUpReg::u16GetFunctionID() const {return POSFI_C_U16_EXTENDEDPOSITIONHORIZON;}
tU8 posfi_tclMsgExtendedPositionHorizonUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgExtendedPositionHorizonUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgExtendedPositionHorizonUpReg::operator==(const posfi_tclMsgExtendedPositionHorizonUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtendedPositionHorizonUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtendedPositionHorizonUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionHorizonRelUpReg::posfi_tclMsgExtendedPositionHorizonRelUpReg(const posfi_tclMsgExtendedPositionHorizonRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionHorizonRelUpReg& posfi_tclMsgExtendedPositionHorizonRelUpReg::operator=(const posfi_tclMsgExtendedPositionHorizonRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtendedPositionHorizonRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtendedPositionHorizonRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_EXTENDEDPOSITIONHORIZON;}
tU8 posfi_tclMsgExtendedPositionHorizonRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgExtendedPositionHorizonRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgExtendedPositionHorizonRelUpReg::operator==(const posfi_tclMsgExtendedPositionHorizonRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtendedPositionHorizonRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtendedPositionHorizonRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionHorizonStatus::posfi_tclMsgExtendedPositionHorizonStatus(const posfi_tclMsgExtendedPositionHorizonStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   PositionHorizonState = coRef.PositionHorizonState;
   DataBaseId = coRef.DataBaseId;
   IndexOfRootInLastHorizon = coRef.IndexOfRootInLastHorizon;
   RootList = coRef.RootList;
   IndexOfLastRootInCurrentHorizon = coRef.IndexOfLastRootInCurrentHorizon;
   IndicesOfLastRootsInCurrentHorizon = coRef.IndicesOfLastRootsInCurrentHorizon;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteInfoId = coRef.RouteInfoId;
   PathSectionList = coRef.PathSectionList;
   OneCellRefList = coRef.OneCellRefList;
   ClusterRefList = coRef.ClusterRefList;
   MostProbablePathesList = coRef.MostProbablePathesList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtendedPositionHorizonStatus& posfi_tclMsgExtendedPositionHorizonStatus::operator=(const posfi_tclMsgExtendedPositionHorizonStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   PositionHorizonState = coRef.PositionHorizonState;
   DataBaseId = coRef.DataBaseId;
   IndexOfRootInLastHorizon = coRef.IndexOfRootInLastHorizon;
   RootList = coRef.RootList;
   IndexOfLastRootInCurrentHorizon = coRef.IndexOfLastRootInCurrentHorizon;
   IndicesOfLastRootsInCurrentHorizon = coRef.IndicesOfLastRootsInCurrentHorizon;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteInfoId = coRef.RouteInfoId;
   PathSectionList = coRef.PathSectionList;
   OneCellRefList = coRef.OneCellRefList;
   ClusterRefList = coRef.ClusterRefList;
   MostProbablePathesList = coRef.MostProbablePathesList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtendedPositionHorizonStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtendedPositionHorizonStatus::u16GetFunctionID() const {return POSFI_C_U16_EXTENDEDPOSITIONHORIZON;}
tU8 posfi_tclMsgExtendedPositionHorizonStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgExtendedPositionHorizonStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RootList.size(); ++u32Idx)
         RootList[u32Idx].vDestroy();
   }
   RootList.clear();
   IndicesOfLastRootsInCurrentHorizon.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
         PathSectionList[u32Idx].vDestroy();
   }
   PathSectionList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
         OneCellRefList[u32Idx].vDestroy();
   }
   OneCellRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   }
   ClusterRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < MostProbablePathesList.size(); ++u32Idx)
         MostProbablePathesList[u32Idx].vDestroy();
   }
   MostProbablePathesList.clear();
}

tU32 posfi_tclMsgExtendedPositionHorizonStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 2;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += RootList.size()*5;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += IndicesOfLastRootsInCurrentHorizon.size()*2;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PathSectionList.size(); ++u32ListIdx)
      u32DynamicSize += PathSectionList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < OneCellRefList.size(); ++u32ListIdx)
      u32DynamicSize += OneCellRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < MostProbablePathesList.size(); ++u32ListIdx)
         u32DynamicSize += MostProbablePathesList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+31+ClusterRefList.size()*9;
}

tBool posfi_tclMsgExtendedPositionHorizonStatus::operator==(const posfi_tclMsgExtendedPositionHorizonStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (PositionHorizonState == rfoCmp.PositionHorizonState);
      bResult = bResult && (DataBaseId == rfoCmp.DataBaseId);
      bResult = bResult && (IndexOfRootInLastHorizon == rfoCmp.IndexOfRootInLastHorizon);
      bResult = bResult && (RootList.size() == rfoCmp.RootList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RootList.size()); ++u32Idx)
            bResult = bResult && (RootList[u32Idx] == rfoCmp.RootList[u32Idx]);
      }
      bResult = bResult && (IndexOfLastRootInCurrentHorizon == rfoCmp.IndexOfLastRootInCurrentHorizon);
      bResult = bResult && (IndicesOfLastRootsInCurrentHorizon.size() == rfoCmp.IndicesOfLastRootsInCurrentHorizon.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IndicesOfLastRootsInCurrentHorizon.size()); ++u32Idx)
            bResult = bResult && (IndicesOfLastRootsInCurrentHorizon[u32Idx] == rfoCmp.IndicesOfLastRootsInCurrentHorizon[u32Idx]);
      }
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (RouteInfoId == rfoCmp.RouteInfoId);
      bResult = bResult && (PathSectionList.size() == rfoCmp.PathSectionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathSectionList.size()); ++u32Idx)
            bResult = bResult && (PathSectionList[u32Idx] == rfoCmp.PathSectionList[u32Idx]);
      }
      bResult = bResult && (OneCellRefList.size() == rfoCmp.OneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OneCellRefList.size()); ++u32Idx)
            bResult = bResult && (OneCellRefList[u32Idx] == rfoCmp.OneCellRefList[u32Idx]);
      }
      bResult = bResult && (ClusterRefList.size() == rfoCmp.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == rfoCmp.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (MostProbablePathesList.size() == rfoCmp.MostProbablePathesList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MostProbablePathesList.size()); ++u32Idx)
            bResult = bResult && (MostProbablePathesList[u32Idx] == rfoCmp.MostProbablePathesList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtendedPositionHorizonStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   oIn >> PositionHorizonState;
   oIn >> DataBaseId;
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> IndexOfRootInLastHorizon;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < RootList.size(); ++u32Idx)
         {
            RootList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         RootList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> RootList[u32Idx];
         }
      }
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> IndexOfLastRootInCurrentHorizon;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         IndicesOfLastRootsInCurrentHorizon.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> IndicesOfLastRootsInCurrentHorizon[u32Idx];
         }
      }
   }
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> RouteInfoId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
      {
         PathSectionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PathSectionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PathSectionList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
      {
         OneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OneCellRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterRefList[u32Idx];
      }
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < MostProbablePathesList.size(); ++u32Idx)
         {
            MostProbablePathesList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         MostProbablePathesList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> MostProbablePathesList[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtendedPositionHorizonStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << PositionHorizonState;
   oOut << DataBaseId;
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << IndexOfRootInLastHorizon;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)RootList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < RootList.size(); ++u32Idx)
            oOut << RootList[u32Idx];
      }
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << IndexOfLastRootInCurrentHorizon;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)IndicesOfLastRootsInCurrentHorizon.size();
      {
         for (tU32 u32Idx = 0; u32Idx < IndicesOfLastRootsInCurrentHorizon.size(); ++u32Idx)
            oOut << IndicesOfLastRootsInCurrentHorizon[u32Idx];
      }
   }
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << RouteInfoId;
   oOut << (tU32)PathSectionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
         oOut << PathSectionList[u32Idx];
   }
   oOut << (tU32)OneCellRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
         oOut << OneCellRefList[u32Idx];
   }
   oOut << (tU32)ClusterRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         oOut << ClusterRefList[u32Idx];
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)MostProbablePathesList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < MostProbablePathesList.size(); ++u32Idx)
            oOut << MostProbablePathesList[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgMostStraightPathGet::posfi_tclMsgMostStraightPathGet(const posfi_tclMsgMostStraightPathGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgMostStraightPathGet& posfi_tclMsgMostStraightPathGet::operator=(const posfi_tclMsgMostStraightPathGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgMostStraightPathGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgMostStraightPathGet::u16GetFunctionID() const {return POSFI_C_U16_MOSTSTRAIGHTPATH;}
tU8 posfi_tclMsgMostStraightPathGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgMostStraightPathGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgMostStraightPathGet::operator==(const posfi_tclMsgMostStraightPathGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgMostStraightPathGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgMostStraightPathGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgMostStraightPathUpReg::posfi_tclMsgMostStraightPathUpReg(const posfi_tclMsgMostStraightPathUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgMostStraightPathUpReg& posfi_tclMsgMostStraightPathUpReg::operator=(const posfi_tclMsgMostStraightPathUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgMostStraightPathUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgMostStraightPathUpReg::u16GetFunctionID() const {return POSFI_C_U16_MOSTSTRAIGHTPATH;}
tU8 posfi_tclMsgMostStraightPathUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgMostStraightPathUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgMostStraightPathUpReg::operator==(const posfi_tclMsgMostStraightPathUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgMostStraightPathUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgMostStraightPathUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgMostStraightPathRelUpReg::posfi_tclMsgMostStraightPathRelUpReg(const posfi_tclMsgMostStraightPathRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgMostStraightPathRelUpReg& posfi_tclMsgMostStraightPathRelUpReg::operator=(const posfi_tclMsgMostStraightPathRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgMostStraightPathRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgMostStraightPathRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_MOSTSTRAIGHTPATH;}
tU8 posfi_tclMsgMostStraightPathRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgMostStraightPathRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgMostStraightPathRelUpReg::operator==(const posfi_tclMsgMostStraightPathRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgMostStraightPathRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgMostStraightPathRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgMostStraightPathStatus::posfi_tclMsgMostStraightPathStatus(const posfi_tclMsgMostStraightPathStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   PathSectionListIndices = coRef.PathSectionListIndices;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgMostStraightPathStatus& posfi_tclMsgMostStraightPathStatus::operator=(const posfi_tclMsgMostStraightPathStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   PathSectionListIndices = coRef.PathSectionListIndices;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgMostStraightPathStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgMostStraightPathStatus::u16GetFunctionID() const {return POSFI_C_U16_MOSTSTRAIGHTPATH;}
tU8 posfi_tclMsgMostStraightPathStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgMostStraightPathStatus::vDestroy()
{
   PathSectionListIndices.clear();
}

tU32 posfi_tclMsgMostStraightPathStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+PathSectionListIndices.size()*2;
}

tBool posfi_tclMsgMostStraightPathStatus::operator==(const posfi_tclMsgMostStraightPathStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (PathSectionListIndices.size() == rfoCmp.PathSectionListIndices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathSectionListIndices.size()); ++u32Idx)
            bResult = bResult && (PathSectionListIndices[u32Idx] == rfoCmp.PathSectionListIndices[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& posfi_tclMsgMostStraightPathStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      PathSectionListIndices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PathSectionListIndices[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& posfi_tclMsgMostStraightPathStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << (tU32)PathSectionListIndices.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionListIndices.size(); ++u32Idx)
         oOut << PathSectionListIndices[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgNavPositionGet::posfi_tclMsgNavPositionGet(const posfi_tclMsgNavPositionGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgNavPositionGet& posfi_tclMsgNavPositionGet::operator=(const posfi_tclMsgNavPositionGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgNavPositionGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgNavPositionGet::u16GetFunctionID() const {return POSFI_C_U16_NAVPOSITION;}
tU8 posfi_tclMsgNavPositionGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgNavPositionGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgNavPositionGet::operator==(const posfi_tclMsgNavPositionGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgNavPositionGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgNavPositionGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgNavPositionUpReg::posfi_tclMsgNavPositionUpReg(const posfi_tclMsgNavPositionUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgNavPositionUpReg& posfi_tclMsgNavPositionUpReg::operator=(const posfi_tclMsgNavPositionUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgNavPositionUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgNavPositionUpReg::u16GetFunctionID() const {return POSFI_C_U16_NAVPOSITION;}
tU8 posfi_tclMsgNavPositionUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgNavPositionUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgNavPositionUpReg::operator==(const posfi_tclMsgNavPositionUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgNavPositionUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgNavPositionUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgNavPositionRelUpReg::posfi_tclMsgNavPositionRelUpReg(const posfi_tclMsgNavPositionRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgNavPositionRelUpReg& posfi_tclMsgNavPositionRelUpReg::operator=(const posfi_tclMsgNavPositionRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgNavPositionRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgNavPositionRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_NAVPOSITION;}
tU8 posfi_tclMsgNavPositionRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgNavPositionRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgNavPositionRelUpReg::operator==(const posfi_tclMsgNavPositionRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgNavPositionRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgNavPositionRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgNavPositionStatus::posfi_tclMsgNavPositionStatus(const posfi_tclMsgNavPositionStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataSetId = coRef.DataSetId;
   RealPosition = coRef.RealPosition;
   NonComplexPosition = coRef.NonComplexPosition;
   Speed = coRef.Speed;
   PositionStatus = coRef.PositionStatus;
   ExtendedPositionStatus = coRef.ExtendedPositionStatus;
   SensorTime = coRef.SensorTime;
   SensorPosixTime = coRef.SensorPosixTime;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteInfoId = coRef.RouteInfoId;
   EntryPointStatus = coRef.EntryPointStatus;
   EntryPoint = coRef.EntryPoint;
   Height = coRef.Height;
   Inclination = coRef.Inclination;
   Acceleration = coRef.Acceleration;
   HorizonReleaseId = coRef.HorizonReleaseId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgNavPositionStatus& posfi_tclMsgNavPositionStatus::operator=(const posfi_tclMsgNavPositionStatus& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   RealPosition = coRef.RealPosition;
   NonComplexPosition = coRef.NonComplexPosition;
   Speed = coRef.Speed;
   PositionStatus = coRef.PositionStatus;
   ExtendedPositionStatus = coRef.ExtendedPositionStatus;
   SensorTime = coRef.SensorTime;
   SensorPosixTime = coRef.SensorPosixTime;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteInfoId = coRef.RouteInfoId;
   EntryPointStatus = coRef.EntryPointStatus;
   EntryPoint = coRef.EntryPoint;
   Height = coRef.Height;
   Inclination = coRef.Inclination;
   Acceleration = coRef.Acceleration;
   HorizonReleaseId = coRef.HorizonReleaseId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgNavPositionStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgNavPositionStatus::u16GetFunctionID() const {return POSFI_C_U16_NAVPOSITION;}
tU8 posfi_tclMsgNavPositionStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgNavPositionStatus::vDestroy()
{
   RealPosition.vDestroy(); 
   NonComplexPosition.vDestroy(); 
   SensorPosixTime.vDestroy(); 
   EntryPoint.vDestroy(); 
}

tU32 posfi_tclMsgNavPositionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += EntryPoint.u32GetSize(u16MajorVersion);
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+28+RealPosition.u32GetSize(u16MajorVersion)+NonComplexPosition.u32GetSize(u16MajorVersion);
}

tBool posfi_tclMsgNavPositionStatus::operator==(const posfi_tclMsgNavPositionStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RealPosition == rfoCmp.RealPosition);
      bResult = bResult && (NonComplexPosition == rfoCmp.NonComplexPosition);
      bResult = bResult && (Speed == rfoCmp.Speed);
      bResult = bResult && (PositionStatus == rfoCmp.PositionStatus);
      bResult = bResult && (ExtendedPositionStatus == rfoCmp.ExtendedPositionStatus);
      bResult = bResult && (SensorTime == rfoCmp.SensorTime);
      bResult = bResult && (SensorPosixTime == rfoCmp.SensorPosixTime);
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (RouteInfoId == rfoCmp.RouteInfoId);
      bResult = bResult && (EntryPointStatus == rfoCmp.EntryPointStatus);
      bResult = bResult && (EntryPoint == rfoCmp.EntryPoint);
      bResult = bResult && (Height == rfoCmp.Height);
      bResult = bResult && (Inclination == rfoCmp.Inclination);
      bResult = bResult && (Acceleration == rfoCmp.Acceleration);
      bResult = bResult && (HorizonReleaseId == rfoCmp.HorizonReleaseId);
   return bResult;
}

fi_tclInContext& posfi_tclMsgNavPositionStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DataSetId;
   oIn >> RealPosition;
   oIn >> NonComplexPosition;
   oIn >> Speed;
   oIn >> PositionStatus;
   oIn >> ExtendedPositionStatus;
   oIn >> SensorTime;
   oIn >> SensorPosixTime;
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> RouteInfoId;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> EntryPointStatus;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> EntryPoint;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Height;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Inclination;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Acceleration;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> HorizonReleaseId;
   }
   return oIn;
}

fi_tclOutContext& posfi_tclMsgNavPositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataSetId;
   oOut << RealPosition;
   oOut << NonComplexPosition;
   oOut << Speed;
   oOut << PositionStatus;
   oOut << ExtendedPositionStatus;
   oOut << SensorTime;
   oOut << SensorPosixTime;
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << RouteInfoId;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << EntryPointStatus;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << EntryPoint;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Height;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Inclination;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Acceleration;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << HorizonReleaseId;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionPathesGet::posfi_tclMsgPositionPathesGet(const posfi_tclMsgPositionPathesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionPathesGet& posfi_tclMsgPositionPathesGet::operator=(const posfi_tclMsgPositionPathesGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionPathesGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionPathesGet::u16GetFunctionID() const {return POSFI_C_U16_POSITIONPATHES;}
tU8 posfi_tclMsgPositionPathesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgPositionPathesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionPathesGet::operator==(const posfi_tclMsgPositionPathesGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionPathesGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionPathesGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionPathesUpReg::posfi_tclMsgPositionPathesUpReg(const posfi_tclMsgPositionPathesUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionPathesUpReg& posfi_tclMsgPositionPathesUpReg::operator=(const posfi_tclMsgPositionPathesUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionPathesUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionPathesUpReg::u16GetFunctionID() const {return POSFI_C_U16_POSITIONPATHES;}
tU8 posfi_tclMsgPositionPathesUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgPositionPathesUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionPathesUpReg::operator==(const posfi_tclMsgPositionPathesUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionPathesUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionPathesUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionPathesRelUpReg::posfi_tclMsgPositionPathesRelUpReg(const posfi_tclMsgPositionPathesRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionPathesRelUpReg& posfi_tclMsgPositionPathesRelUpReg::operator=(const posfi_tclMsgPositionPathesRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionPathesRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionPathesRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_POSITIONPATHES;}
tU8 posfi_tclMsgPositionPathesRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgPositionPathesRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionPathesRelUpReg::operator==(const posfi_tclMsgPositionPathesRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionPathesRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionPathesRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionPathesStatus::posfi_tclMsgPositionPathesStatus(const posfi_tclMsgPositionPathesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavPosition = coRef.NavPosition;
   NavRectangle = coRef.NavRectangle;
   SensorTime = coRef.SensorTime;
   SensorPosixTime = coRef.SensorPosixTime;
   VehicleSystemParameter = coRef.VehicleSystemParameter;
   VehicleCovarianceMatrix = coRef.VehicleCovarianceMatrix;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionPathesStatus& posfi_tclMsgPositionPathesStatus::operator=(const posfi_tclMsgPositionPathesStatus& coRef)
{
   if (this == &coRef) return *this;
   NavPosition = coRef.NavPosition;
   NavRectangle = coRef.NavRectangle;
   SensorTime = coRef.SensorTime;
   SensorPosixTime = coRef.SensorPosixTime;
   VehicleSystemParameter = coRef.VehicleSystemParameter;
   VehicleCovarianceMatrix = coRef.VehicleCovarianceMatrix;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionPathesStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionPathesStatus::u16GetFunctionID() const {return POSFI_C_U16_POSITIONPATHES;}
tU8 posfi_tclMsgPositionPathesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgPositionPathesStatus::vDestroy()
{
   NavPosition.vDestroy(); 
   NavRectangle.vDestroy(); 
   SensorPosixTime.vDestroy(); 
   VehicleSystemParameter.vDestroy(); 
   VehicleCovarianceMatrix.vDestroy(); 
}

tU32 posfi_tclMsgPositionPathesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 210+NavPosition.u32GetSize(u16MajorVersion);
}

tBool posfi_tclMsgPositionPathesStatus::operator==(const posfi_tclMsgPositionPathesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavPosition == rfoCmp.NavPosition);
      bResult = bResult && (NavRectangle == rfoCmp.NavRectangle);
      bResult = bResult && (SensorTime == rfoCmp.SensorTime);
      bResult = bResult && (SensorPosixTime == rfoCmp.SensorPosixTime);
      bResult = bResult && (VehicleSystemParameter == rfoCmp.VehicleSystemParameter);
      bResult = bResult && (VehicleCovarianceMatrix == rfoCmp.VehicleCovarianceMatrix);
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionPathesStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> NavPosition;
   oIn >> NavRectangle;
   oIn >> SensorTime;
   oIn >> SensorPosixTime;
   oIn >> VehicleSystemParameter;
   oIn >> VehicleCovarianceMatrix;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionPathesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavPosition;
   oOut << NavRectangle;
   oOut << SensorTime;
   oOut << SensorPosixTime;
   oOut << VehicleSystemParameter;
   oOut << VehicleCovarianceMatrix;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtrapolatedPositionsGet::posfi_tclMsgExtrapolatedPositionsGet(const posfi_tclMsgExtrapolatedPositionsGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtrapolatedPositionsGet& posfi_tclMsgExtrapolatedPositionsGet::operator=(const posfi_tclMsgExtrapolatedPositionsGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtrapolatedPositionsGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtrapolatedPositionsGet::u16GetFunctionID() const {return POSFI_C_U16_EXTRAPOLATEDPOSITIONS;}
tU8 posfi_tclMsgExtrapolatedPositionsGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgExtrapolatedPositionsGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgExtrapolatedPositionsGet::operator==(const posfi_tclMsgExtrapolatedPositionsGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtrapolatedPositionsGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtrapolatedPositionsGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtrapolatedPositionsUpReg::posfi_tclMsgExtrapolatedPositionsUpReg(const posfi_tclMsgExtrapolatedPositionsUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtrapolatedPositionsUpReg& posfi_tclMsgExtrapolatedPositionsUpReg::operator=(const posfi_tclMsgExtrapolatedPositionsUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtrapolatedPositionsUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtrapolatedPositionsUpReg::u16GetFunctionID() const {return POSFI_C_U16_EXTRAPOLATEDPOSITIONS;}
tU8 posfi_tclMsgExtrapolatedPositionsUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgExtrapolatedPositionsUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgExtrapolatedPositionsUpReg::operator==(const posfi_tclMsgExtrapolatedPositionsUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtrapolatedPositionsUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtrapolatedPositionsUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtrapolatedPositionsRelUpReg::posfi_tclMsgExtrapolatedPositionsRelUpReg(const posfi_tclMsgExtrapolatedPositionsRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtrapolatedPositionsRelUpReg& posfi_tclMsgExtrapolatedPositionsRelUpReg::operator=(const posfi_tclMsgExtrapolatedPositionsRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtrapolatedPositionsRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtrapolatedPositionsRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_EXTRAPOLATEDPOSITIONS;}
tU8 posfi_tclMsgExtrapolatedPositionsRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgExtrapolatedPositionsRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgExtrapolatedPositionsRelUpReg::operator==(const posfi_tclMsgExtrapolatedPositionsRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtrapolatedPositionsRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtrapolatedPositionsRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtrapolatedPositionsStatus::posfi_tclMsgExtrapolatedPositionsStatus(const posfi_tclMsgExtrapolatedPositionsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataSetId = coRef.DataSetId;
   HorizonReleaseId = coRef.HorizonReleaseId;
   ExtrapolationReliability = coRef.ExtrapolationReliability;
   TimestampOfFirstPosition = coRef.TimestampOfFirstPosition;
   ExtrapolationIntervall = coRef.ExtrapolationIntervall;
   ExtrapolatedPositionList = coRef.ExtrapolatedPositionList;
   ExtrapolatedOCRefList = coRef.ExtrapolatedOCRefList;
   ClusterRefList = coRef.ClusterRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgExtrapolatedPositionsStatus& posfi_tclMsgExtrapolatedPositionsStatus::operator=(const posfi_tclMsgExtrapolatedPositionsStatus& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   HorizonReleaseId = coRef.HorizonReleaseId;
   ExtrapolationReliability = coRef.ExtrapolationReliability;
   TimestampOfFirstPosition = coRef.TimestampOfFirstPosition;
   ExtrapolationIntervall = coRef.ExtrapolationIntervall;
   ExtrapolatedPositionList = coRef.ExtrapolatedPositionList;
   ExtrapolatedOCRefList = coRef.ExtrapolatedOCRefList;
   ClusterRefList = coRef.ClusterRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgExtrapolatedPositionsStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgExtrapolatedPositionsStatus::u16GetFunctionID() const {return POSFI_C_U16_EXTRAPOLATEDPOSITIONS;}
tU8 posfi_tclMsgExtrapolatedPositionsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgExtrapolatedPositionsStatus::vDestroy()
{
   TimestampOfFirstPosition.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ExtrapolatedPositionList.size(); ++u32Idx)
         ExtrapolatedPositionList[u32Idx].vDestroy();
   }
   ExtrapolatedPositionList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ExtrapolatedOCRefList.size(); ++u32Idx)
         ExtrapolatedOCRefList[u32Idx].vDestroy();
   }
   ExtrapolatedOCRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   }
   ClusterRefList.clear();
}

tU32 posfi_tclMsgExtrapolatedPositionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ExtrapolatedOCRefList.size(); ++u32ListIdx)
      u32DynamicSize += ExtrapolatedOCRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+25+ExtrapolatedPositionList.size()*28+ClusterRefList.size()*9;
}

tBool posfi_tclMsgExtrapolatedPositionsStatus::operator==(const posfi_tclMsgExtrapolatedPositionsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (HorizonReleaseId == rfoCmp.HorizonReleaseId);
      bResult = bResult && (ExtrapolationReliability == rfoCmp.ExtrapolationReliability);
      bResult = bResult && (TimestampOfFirstPosition == rfoCmp.TimestampOfFirstPosition);
      bResult = bResult && (ExtrapolationIntervall == rfoCmp.ExtrapolationIntervall);
      bResult = bResult && (ExtrapolatedPositionList.size() == rfoCmp.ExtrapolatedPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ExtrapolatedPositionList.size()); ++u32Idx)
            bResult = bResult && (ExtrapolatedPositionList[u32Idx] == rfoCmp.ExtrapolatedPositionList[u32Idx]);
      }
      bResult = bResult && (ExtrapolatedOCRefList.size() == rfoCmp.ExtrapolatedOCRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ExtrapolatedOCRefList.size()); ++u32Idx)
            bResult = bResult && (ExtrapolatedOCRefList[u32Idx] == rfoCmp.ExtrapolatedOCRefList[u32Idx]);
      }
      bResult = bResult && (ClusterRefList.size() == rfoCmp.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == rfoCmp.ClusterRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& posfi_tclMsgExtrapolatedPositionsStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DataSetId;
   if (15 <= oIn.u16GetMajorVersion())
   {
      oIn >> HorizonReleaseId;
   }
   oIn >> ExtrapolationReliability;
   oIn >> TimestampOfFirstPosition;
   oIn >> ExtrapolationIntervall;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ExtrapolatedPositionList.size(); ++u32Idx)
      {
         ExtrapolatedPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ExtrapolatedPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ExtrapolatedPositionList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ExtrapolatedOCRefList.size(); ++u32Idx)
      {
         ExtrapolatedOCRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ExtrapolatedOCRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ExtrapolatedOCRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& posfi_tclMsgExtrapolatedPositionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataSetId;
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << HorizonReleaseId;
   }
   oOut << ExtrapolationReliability;
   oOut << TimestampOfFirstPosition;
   oOut << ExtrapolationIntervall;
   oOut << (tU32)ExtrapolatedPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ExtrapolatedPositionList.size(); ++u32Idx)
         oOut << ExtrapolatedPositionList[u32Idx];
   }
   oOut << (tU32)ExtrapolatedOCRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ExtrapolatedOCRefList.size(); ++u32Idx)
         oOut << ExtrapolatedOCRefList[u32Idx];
   }
   oOut << (tU32)ClusterRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         oOut << ClusterRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionGet::posfi_tclMsgPositionGet(const posfi_tclMsgPositionGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionGet& posfi_tclMsgPositionGet::operator=(const posfi_tclMsgPositionGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionGet::u16GetFunctionID() const {return POSFI_C_U16_POSITION;}
tU8 posfi_tclMsgPositionGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgPositionGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionGet::operator==(const posfi_tclMsgPositionGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionUpReg::posfi_tclMsgPositionUpReg(const posfi_tclMsgPositionUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionUpReg& posfi_tclMsgPositionUpReg::operator=(const posfi_tclMsgPositionUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionUpReg::u16GetFunctionID() const {return POSFI_C_U16_POSITION;}
tU8 posfi_tclMsgPositionUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgPositionUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionUpReg::operator==(const posfi_tclMsgPositionUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionRelUpReg::posfi_tclMsgPositionRelUpReg(const posfi_tclMsgPositionRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionRelUpReg& posfi_tclMsgPositionRelUpReg::operator=(const posfi_tclMsgPositionRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_POSITION;}
tU8 posfi_tclMsgPositionRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgPositionRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionRelUpReg::operator==(const posfi_tclMsgPositionRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionStatus::posfi_tclMsgPositionStatus(const posfi_tclMsgPositionStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionElementBlock = coRef.PositionElementBlock;
   PositionStatus = coRef.PositionStatus;
   SensorPosixTime = coRef.SensorPosixTime;
   Height = coRef.Height;
   Inclination = coRef.Inclination;
   Acceleration = coRef.Acceleration;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionStatus& posfi_tclMsgPositionStatus::operator=(const posfi_tclMsgPositionStatus& coRef)
{
   if (this == &coRef) return *this;
   PositionElementBlock = coRef.PositionElementBlock;
   PositionStatus = coRef.PositionStatus;
   SensorPosixTime = coRef.SensorPosixTime;
   Height = coRef.Height;
   Inclination = coRef.Inclination;
   Acceleration = coRef.Acceleration;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionStatus::u16GetFunctionID() const {return POSFI_C_U16_POSITION;}
tU8 posfi_tclMsgPositionStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgPositionStatus::vDestroy()
{
   PositionElementBlock.vDestroy(); 
   SensorPosixTime.vDestroy(); 
}

tU32 posfi_tclMsgPositionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+20;
}

tBool posfi_tclMsgPositionStatus::operator==(const posfi_tclMsgPositionStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionElementBlock == rfoCmp.PositionElementBlock);
      bResult = bResult && (PositionStatus == rfoCmp.PositionStatus);
      bResult = bResult && (SensorPosixTime == rfoCmp.SensorPosixTime);
      bResult = bResult && (Height == rfoCmp.Height);
      bResult = bResult && (Inclination == rfoCmp.Inclination);
      bResult = bResult && (Acceleration == rfoCmp.Acceleration);
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> PositionElementBlock;
   oIn >> PositionStatus;
   oIn >> SensorPosixTime;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Height;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Inclination;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Acceleration;
   }
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PositionElementBlock;
   oOut << PositionStatus;
   oOut << SensorPosixTime;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Height;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Inclination;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Acceleration;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionInfoGet::posfi_tclMsgPositionInfoGet(const posfi_tclMsgPositionInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionInfoGet& posfi_tclMsgPositionInfoGet::operator=(const posfi_tclMsgPositionInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionInfoGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionInfoGet::u16GetFunctionID() const {return POSFI_C_U16_POSITIONINFO;}
tU8 posfi_tclMsgPositionInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgPositionInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionInfoGet::operator==(const posfi_tclMsgPositionInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionInfoUpReg::posfi_tclMsgPositionInfoUpReg(const posfi_tclMsgPositionInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionInfoUpReg& posfi_tclMsgPositionInfoUpReg::operator=(const posfi_tclMsgPositionInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionInfoUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionInfoUpReg::u16GetFunctionID() const {return POSFI_C_U16_POSITIONINFO;}
tU8 posfi_tclMsgPositionInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgPositionInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionInfoUpReg::operator==(const posfi_tclMsgPositionInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionInfoRelUpReg::posfi_tclMsgPositionInfoRelUpReg(const posfi_tclMsgPositionInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionInfoRelUpReg& posfi_tclMsgPositionInfoRelUpReg::operator=(const posfi_tclMsgPositionInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionInfoRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionInfoRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_POSITIONINFO;}
tU8 posfi_tclMsgPositionInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgPositionInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionInfoRelUpReg::operator==(const posfi_tclMsgPositionInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionInfoStatus::posfi_tclMsgPositionInfoStatus(const posfi_tclMsgPositionInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadAttributes = coRef.RoadAttributes;
   PositionInfo = coRef.PositionInfo;
   PositionCoord = coRef.PositionCoord;
   Course = coRef.Course;
   IsEntryPoint = coRef.IsEntryPoint;
   SensorPosixTime = coRef.SensorPosixTime;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionInfoStatus& posfi_tclMsgPositionInfoStatus::operator=(const posfi_tclMsgPositionInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   RoadAttributes = coRef.RoadAttributes;
   PositionInfo = coRef.PositionInfo;
   PositionCoord = coRef.PositionCoord;
   Course = coRef.Course;
   IsEntryPoint = coRef.IsEntryPoint;
   SensorPosixTime = coRef.SensorPosixTime;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionInfoStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionInfoStatus::u16GetFunctionID() const {return POSFI_C_U16_POSITIONINFO;}
tU8 posfi_tclMsgPositionInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgPositionInfoStatus::vDestroy()
{
   RoadAttributes.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < PositionInfo.size(); ++u32Idx)
         PositionInfo[u32Idx].vDestroy();
   }
   PositionInfo.clear();
   PositionCoord.vDestroy(); 
   SensorPosixTime.vDestroy(); 
}

tU32 posfi_tclMsgPositionInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PositionInfo.size(); ++u32ListIdx)
      u32DynamicSize += PositionInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 8;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+10+RoadAttributes.u32GetSize(u16MajorVersion);
}

tBool posfi_tclMsgPositionInfoStatus::operator==(const posfi_tclMsgPositionInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadAttributes == rfoCmp.RoadAttributes);
      bResult = bResult && (PositionInfo.size() == rfoCmp.PositionInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionInfo.size()); ++u32Idx)
            bResult = bResult && (PositionInfo[u32Idx] == rfoCmp.PositionInfo[u32Idx]);
      }
      bResult = bResult && (PositionCoord == rfoCmp.PositionCoord);
      bResult = bResult && (Course == rfoCmp.Course);
      bResult = bResult && (IsEntryPoint == rfoCmp.IsEntryPoint);
      bResult = bResult && (SensorPosixTime == rfoCmp.SensorPosixTime);
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadAttributes;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PositionInfo.size(); ++u32Idx)
      {
         PositionInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PositionInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PositionInfo[u32Idx];
      }
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> PositionCoord;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Course;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> IsEntryPoint;
   }
   oIn >> SensorPosixTime;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadAttributes;
   oOut << (tU32)PositionInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PositionInfo.size(); ++u32Idx)
         oOut << PositionInfo[u32Idx];
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << PositionCoord;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Course;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << IsEntryPoint;
   }
   oOut << SensorPosixTime;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCountryCodeGet::posfi_tclMsgCountryCodeGet(const posfi_tclMsgCountryCodeGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCountryCodeGet& posfi_tclMsgCountryCodeGet::operator=(const posfi_tclMsgCountryCodeGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgCountryCodeGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgCountryCodeGet::u16GetFunctionID() const {return POSFI_C_U16_COUNTRYCODE;}
tU8 posfi_tclMsgCountryCodeGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgCountryCodeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgCountryCodeGet::operator==(const posfi_tclMsgCountryCodeGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgCountryCodeGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgCountryCodeGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCountryCodeUpReg::posfi_tclMsgCountryCodeUpReg(const posfi_tclMsgCountryCodeUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCountryCodeUpReg& posfi_tclMsgCountryCodeUpReg::operator=(const posfi_tclMsgCountryCodeUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgCountryCodeUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgCountryCodeUpReg::u16GetFunctionID() const {return POSFI_C_U16_COUNTRYCODE;}
tU8 posfi_tclMsgCountryCodeUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgCountryCodeUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgCountryCodeUpReg::operator==(const posfi_tclMsgCountryCodeUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgCountryCodeUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgCountryCodeUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCountryCodeRelUpReg::posfi_tclMsgCountryCodeRelUpReg(const posfi_tclMsgCountryCodeRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCountryCodeRelUpReg& posfi_tclMsgCountryCodeRelUpReg::operator=(const posfi_tclMsgCountryCodeRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgCountryCodeRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgCountryCodeRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_COUNTRYCODE;}
tU8 posfi_tclMsgCountryCodeRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgCountryCodeRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgCountryCodeRelUpReg::operator==(const posfi_tclMsgCountryCodeRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgCountryCodeRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgCountryCodeRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCountryCodeStatus::posfi_tclMsgCountryCodeStatus(const posfi_tclMsgCountryCodeStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgCountryCodeStatus& posfi_tclMsgCountryCodeStatus::operator=(const posfi_tclMsgCountryCodeStatus& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgCountryCodeStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgCountryCodeStatus::u16GetFunctionID() const {return POSFI_C_U16_COUNTRYCODE;}
tU8 posfi_tclMsgCountryCodeStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 posfi_tclMsgCountryCodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool posfi_tclMsgCountryCodeStatus::operator==(const posfi_tclMsgCountryCodeStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountryCode == rfoCmp.CountryCode);
   return bResult;
}

fi_tclInContext& posfi_tclMsgCountryCodeStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> CountryCode;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgCountryCodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountryCode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPossibleEntryPointsGet::posfi_tclMsgPossibleEntryPointsGet(const posfi_tclMsgPossibleEntryPointsGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPossibleEntryPointsGet& posfi_tclMsgPossibleEntryPointsGet::operator=(const posfi_tclMsgPossibleEntryPointsGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPossibleEntryPointsGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPossibleEntryPointsGet::u16GetFunctionID() const {return POSFI_C_U16_POSSIBLEENTRYPOINTS;}
tU8 posfi_tclMsgPossibleEntryPointsGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgPossibleEntryPointsGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPossibleEntryPointsGet::operator==(const posfi_tclMsgPossibleEntryPointsGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPossibleEntryPointsGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPossibleEntryPointsGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPossibleEntryPointsUpReg::posfi_tclMsgPossibleEntryPointsUpReg(const posfi_tclMsgPossibleEntryPointsUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPossibleEntryPointsUpReg& posfi_tclMsgPossibleEntryPointsUpReg::operator=(const posfi_tclMsgPossibleEntryPointsUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPossibleEntryPointsUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPossibleEntryPointsUpReg::u16GetFunctionID() const {return POSFI_C_U16_POSSIBLEENTRYPOINTS;}
tU8 posfi_tclMsgPossibleEntryPointsUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgPossibleEntryPointsUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPossibleEntryPointsUpReg::operator==(const posfi_tclMsgPossibleEntryPointsUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPossibleEntryPointsUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPossibleEntryPointsUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPossibleEntryPointsRelUpReg::posfi_tclMsgPossibleEntryPointsRelUpReg(const posfi_tclMsgPossibleEntryPointsRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPossibleEntryPointsRelUpReg& posfi_tclMsgPossibleEntryPointsRelUpReg::operator=(const posfi_tclMsgPossibleEntryPointsRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPossibleEntryPointsRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPossibleEntryPointsRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_POSSIBLEENTRYPOINTS;}
tU8 posfi_tclMsgPossibleEntryPointsRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgPossibleEntryPointsRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPossibleEntryPointsRelUpReg::operator==(const posfi_tclMsgPossibleEntryPointsRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPossibleEntryPointsRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPossibleEntryPointsRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPossibleEntryPointsStatus::posfi_tclMsgPossibleEntryPointsStatus(const posfi_tclMsgPossibleEntryPointsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   EntryPoints = coRef.EntryPoints;
   DataSetId = coRef.DataSetId;
   OffPosition = coRef.OffPosition;
   SensorTime = coRef.SensorTime;
   SensorPosixTime = coRef.SensorPosixTime;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPossibleEntryPointsStatus& posfi_tclMsgPossibleEntryPointsStatus::operator=(const posfi_tclMsgPossibleEntryPointsStatus& coRef)
{
   if (this == &coRef) return *this;
   EntryPoints = coRef.EntryPoints;
   DataSetId = coRef.DataSetId;
   OffPosition = coRef.OffPosition;
   SensorTime = coRef.SensorTime;
   SensorPosixTime = coRef.SensorPosixTime;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPossibleEntryPointsStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPossibleEntryPointsStatus::u16GetFunctionID() const {return POSFI_C_U16_POSSIBLEENTRYPOINTS;}
tU8 posfi_tclMsgPossibleEntryPointsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgPossibleEntryPointsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < EntryPoints.size(); ++u32Idx)
         EntryPoints[u32Idx].vDestroy();
   }
   EntryPoints.clear();
   OffPosition.vDestroy(); 
   SensorPosixTime.vDestroy(); 
}

tU32 posfi_tclMsgPossibleEntryPointsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < EntryPoints.size(); ++u32ListIdx)
      u32DynamicSize += EntryPoints[u32ListIdx].u32GetSize(u16MajorVersion);
   if (10 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (10 <= u16MajorVersion)
   {
      u32DynamicSize += 6;
   }
   return u32DynamicSize+21;
}

tBool posfi_tclMsgPossibleEntryPointsStatus::operator==(const posfi_tclMsgPossibleEntryPointsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (EntryPoints.size() == rfoCmp.EntryPoints.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EntryPoints.size()); ++u32Idx)
            bResult = bResult && (EntryPoints[u32Idx] == rfoCmp.EntryPoints[u32Idx]);
      }
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (OffPosition == rfoCmp.OffPosition);
      bResult = bResult && (SensorTime == rfoCmp.SensorTime);
      bResult = bResult && (SensorPosixTime == rfoCmp.SensorPosixTime);
   return bResult;
}

fi_tclInContext& posfi_tclMsgPossibleEntryPointsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EntryPoints.size(); ++u32Idx)
      {
         EntryPoints[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      EntryPoints.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> EntryPoints[u32Idx];
      }
   }
   oIn >> DataSetId;
   oIn >> OffPosition;
   if (10 <= oIn.u16GetMajorVersion())
   {
      oIn >> SensorTime;
   }
   if (10 <= oIn.u16GetMajorVersion())
   {
      oIn >> SensorPosixTime;
   }
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPossibleEntryPointsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)EntryPoints.size();
   {
      for (tU32 u32Idx = 0; u32Idx < EntryPoints.size(); ++u32Idx)
         oOut << EntryPoints[u32Idx];
   }
   oOut << DataSetId;
   oOut << OffPosition;
   if (10 <= oOut.u16GetMajorVersion())
   {
      oOut << SensorTime;
   }
   if (10 <= oOut.u16GetMajorVersion())
   {
      oOut << SensorPosixTime;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeadReckoningPositionGet::posfi_tclMsgDeadReckoningPositionGet(const posfi_tclMsgDeadReckoningPositionGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeadReckoningPositionGet& posfi_tclMsgDeadReckoningPositionGet::operator=(const posfi_tclMsgDeadReckoningPositionGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgDeadReckoningPositionGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgDeadReckoningPositionGet::u16GetFunctionID() const {return POSFI_C_U16_DEADRECKONINGPOSITION;}
tU8 posfi_tclMsgDeadReckoningPositionGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgDeadReckoningPositionGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgDeadReckoningPositionGet::operator==(const posfi_tclMsgDeadReckoningPositionGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgDeadReckoningPositionGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgDeadReckoningPositionGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeadReckoningPositionUpReg::posfi_tclMsgDeadReckoningPositionUpReg(const posfi_tclMsgDeadReckoningPositionUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeadReckoningPositionUpReg& posfi_tclMsgDeadReckoningPositionUpReg::operator=(const posfi_tclMsgDeadReckoningPositionUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgDeadReckoningPositionUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgDeadReckoningPositionUpReg::u16GetFunctionID() const {return POSFI_C_U16_DEADRECKONINGPOSITION;}
tU8 posfi_tclMsgDeadReckoningPositionUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgDeadReckoningPositionUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgDeadReckoningPositionUpReg::operator==(const posfi_tclMsgDeadReckoningPositionUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgDeadReckoningPositionUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgDeadReckoningPositionUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeadReckoningPositionRelUpReg::posfi_tclMsgDeadReckoningPositionRelUpReg(const posfi_tclMsgDeadReckoningPositionRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeadReckoningPositionRelUpReg& posfi_tclMsgDeadReckoningPositionRelUpReg::operator=(const posfi_tclMsgDeadReckoningPositionRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgDeadReckoningPositionRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgDeadReckoningPositionRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_DEADRECKONINGPOSITION;}
tU8 posfi_tclMsgDeadReckoningPositionRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgDeadReckoningPositionRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgDeadReckoningPositionRelUpReg::operator==(const posfi_tclMsgDeadReckoningPositionRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgDeadReckoningPositionRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgDeadReckoningPositionRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeadReckoningPositionStatus::posfi_tclMsgDeadReckoningPositionStatus(const posfi_tclMsgDeadReckoningPositionStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   SensorTime = coRef.SensorTime;
   SensorPosixTime = coRef.SensorPosixTime;
   Position = coRef.Position;
   PositionError = coRef.PositionError;
   Heading = coRef.Heading;
   HeadingError = coRef.HeadingError;
   Turnrate = coRef.Turnrate;
   TurnrateError = coRef.TurnrateError;
   Speed = coRef.Speed;
   SpeedError = coRef.SpeedError;
   Acceleration = coRef.Acceleration;
   AccelerationError = coRef.AccelerationError;
   Height = coRef.Height;
   HeightError = coRef.HeightError;
   ProvidedSensors = coRef.ProvidedSensors;
   DeterminedSensors = coRef.DeterminedSensors;
   CurrentlyUsedSensors = coRef.CurrentlyUsedSensors;
   CalibratedSensors = coRef.CalibratedSensors;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgDeadReckoningPositionStatus& posfi_tclMsgDeadReckoningPositionStatus::operator=(const posfi_tclMsgDeadReckoningPositionStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SensorTime = coRef.SensorTime;
   SensorPosixTime = coRef.SensorPosixTime;
   Position = coRef.Position;
   PositionError = coRef.PositionError;
   Heading = coRef.Heading;
   HeadingError = coRef.HeadingError;
   Turnrate = coRef.Turnrate;
   TurnrateError = coRef.TurnrateError;
   Speed = coRef.Speed;
   SpeedError = coRef.SpeedError;
   Acceleration = coRef.Acceleration;
   AccelerationError = coRef.AccelerationError;
   Height = coRef.Height;
   HeightError = coRef.HeightError;
   ProvidedSensors = coRef.ProvidedSensors;
   DeterminedSensors = coRef.DeterminedSensors;
   CurrentlyUsedSensors = coRef.CurrentlyUsedSensors;
   CalibratedSensors = coRef.CalibratedSensors;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgDeadReckoningPositionStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgDeadReckoningPositionStatus::u16GetFunctionID() const {return POSFI_C_U16_DEADRECKONINGPOSITION;}
tU8 posfi_tclMsgDeadReckoningPositionStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgDeadReckoningPositionStatus::vDestroy()
{
   SensorPosixTime.vDestroy(); 
   Position.vDestroy(); 
   PositionError.vDestroy(); 
}

tU32 posfi_tclMsgDeadReckoningPositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 61;
}

tBool posfi_tclMsgDeadReckoningPositionStatus::operator==(const posfi_tclMsgDeadReckoningPositionStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (SensorTime == rfoCmp.SensorTime);
      bResult = bResult && (SensorPosixTime == rfoCmp.SensorPosixTime);
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (PositionError == rfoCmp.PositionError);
      bResult = bResult && (Heading == rfoCmp.Heading);
      bResult = bResult && (HeadingError == rfoCmp.HeadingError);
      bResult = bResult && (Turnrate == rfoCmp.Turnrate);
      bResult = bResult && (TurnrateError == rfoCmp.TurnrateError);
      bResult = bResult && (Speed == rfoCmp.Speed);
      bResult = bResult && (SpeedError == rfoCmp.SpeedError);
      bResult = bResult && (Acceleration == rfoCmp.Acceleration);
      bResult = bResult && (AccelerationError == rfoCmp.AccelerationError);
      bResult = bResult && (Height == rfoCmp.Height);
      bResult = bResult && (HeightError == rfoCmp.HeightError);
      bResult = bResult && (ProvidedSensors == rfoCmp.ProvidedSensors);
      bResult = bResult && (DeterminedSensors == rfoCmp.DeterminedSensors);
      bResult = bResult && (CurrentlyUsedSensors == rfoCmp.CurrentlyUsedSensors);
      bResult = bResult && (CalibratedSensors == rfoCmp.CalibratedSensors);
   return bResult;
}

fi_tclInContext& posfi_tclMsgDeadReckoningPositionStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Status;
   oIn >> SensorTime;
   oIn >> SensorPosixTime;
   oIn >> Position;
   oIn >> PositionError;
   oIn >> Heading;
   oIn >> HeadingError;
   oIn >> Turnrate;
   oIn >> TurnrateError;
   oIn >> Speed;
   oIn >> SpeedError;
   oIn >> Acceleration;
   oIn >> AccelerationError;
   oIn >> Height;
   oIn >> HeightError;
   oIn >> ProvidedSensors;
   oIn >> DeterminedSensors;
   oIn >> CurrentlyUsedSensors;
   oIn >> CalibratedSensors;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgDeadReckoningPositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Status;
   oOut << SensorTime;
   oOut << SensorPosixTime;
   oOut << Position;
   oOut << PositionError;
   oOut << Heading;
   oOut << HeadingError;
   oOut << Turnrate;
   oOut << TurnrateError;
   oOut << Speed;
   oOut << SpeedError;
   oOut << Acceleration;
   oOut << AccelerationError;
   oOut << Height;
   oOut << HeightError;
   oOut << ProvidedSensors;
   oOut << DeterminedSensors;
   oOut << CurrentlyUsedSensors;
   oOut << CalibratedSensors;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionHorizon_CallbackStatus::posfi_tclMsgPositionHorizon_CallbackStatus(const posfi_tclMsgPositionHorizon_CallbackStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPositionHorizon_CallbackStatus& posfi_tclMsgPositionHorizon_CallbackStatus::operator=(const posfi_tclMsgPositionHorizon_CallbackStatus& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPositionHorizon_CallbackStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPositionHorizon_CallbackStatus::u16GetFunctionID() const {return POSFI_C_U16_POSITIONHORIZON_CALLBACK;}
tU8 posfi_tclMsgPositionHorizon_CallbackStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 posfi_tclMsgPositionHorizon_CallbackStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPositionHorizon_CallbackStatus::operator==(const posfi_tclMsgPositionHorizon_CallbackStatus& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPositionHorizon_CallbackStatus::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPositionHorizon_CallbackStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgWakeUpStatus::posfi_tclMsgWakeUpStatus(const posfi_tclMsgWakeUpStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgWakeUpStatus& posfi_tclMsgWakeUpStatus::operator=(const posfi_tclMsgWakeUpStatus& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgWakeUpStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgWakeUpStatus::u16GetFunctionID() const {return POSFI_C_U16_WAKEUP;}
tU8 posfi_tclMsgWakeUpStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 posfi_tclMsgWakeUpStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgWakeUpStatus::operator==(const posfi_tclMsgWakeUpStatus& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgWakeUpStatus::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgWakeUpStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionListCountGet::posfi_tclMsgSwitchPositionListCountGet(const posfi_tclMsgSwitchPositionListCountGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionListCountGet& posfi_tclMsgSwitchPositionListCountGet::operator=(const posfi_tclMsgSwitchPositionListCountGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionListCountGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionListCountGet::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONLISTCOUNT;}
tU8 posfi_tclMsgSwitchPositionListCountGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgSwitchPositionListCountGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionListCountGet::operator==(const posfi_tclMsgSwitchPositionListCountGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionListCountGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionListCountGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionListCountUpReg::posfi_tclMsgSwitchPositionListCountUpReg(const posfi_tclMsgSwitchPositionListCountUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionListCountUpReg& posfi_tclMsgSwitchPositionListCountUpReg::operator=(const posfi_tclMsgSwitchPositionListCountUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionListCountUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionListCountUpReg::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONLISTCOUNT;}
tU8 posfi_tclMsgSwitchPositionListCountUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgSwitchPositionListCountUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionListCountUpReg::operator==(const posfi_tclMsgSwitchPositionListCountUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionListCountUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionListCountUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionListCountRelUpReg::posfi_tclMsgSwitchPositionListCountRelUpReg(const posfi_tclMsgSwitchPositionListCountRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionListCountRelUpReg& posfi_tclMsgSwitchPositionListCountRelUpReg::operator=(const posfi_tclMsgSwitchPositionListCountRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionListCountRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionListCountRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONLISTCOUNT;}
tU8 posfi_tclMsgSwitchPositionListCountRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgSwitchPositionListCountRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgSwitchPositionListCountRelUpReg::operator==(const posfi_tclMsgSwitchPositionListCountRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionListCountRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionListCountRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionListCountStatus::posfi_tclMsgSwitchPositionListCountStatus(const posfi_tclMsgSwitchPositionListCountStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   NumberSwitchablePositions = coRef.NumberSwitchablePositions;
   SubPositionsPossibleDependingOnRoute = coRef.SubPositionsPossibleDependingOnRoute;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgSwitchPositionListCountStatus& posfi_tclMsgSwitchPositionListCountStatus::operator=(const posfi_tclMsgSwitchPositionListCountStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   NumberSwitchablePositions = coRef.NumberSwitchablePositions;
   SubPositionsPossibleDependingOnRoute = coRef.SubPositionsPossibleDependingOnRoute;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgSwitchPositionListCountStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgSwitchPositionListCountStatus::u16GetFunctionID() const {return POSFI_C_U16_SWITCHPOSITIONLISTCOUNT;}
tU8 posfi_tclMsgSwitchPositionListCountStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 posfi_tclMsgSwitchPositionListCountStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool posfi_tclMsgSwitchPositionListCountStatus::operator==(const posfi_tclMsgSwitchPositionListCountStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (NumberSwitchablePositions == rfoCmp.NumberSwitchablePositions);
      bResult = bResult && (SubPositionsPossibleDependingOnRoute == rfoCmp.SubPositionsPossibleDependingOnRoute);
   return bResult;
}

fi_tclInContext& posfi_tclMsgSwitchPositionListCountStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Status;
   oIn >> NumberSwitchablePositions;
   oIn >> SubPositionsPossibleDependingOnRoute;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgSwitchPositionListCountStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Status;
   oOut << NumberSwitchablePositions;
   oOut << SubPositionsPossibleDependingOnRoute;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPresentationGet::posfi_tclMsgPresentationGet(const posfi_tclMsgPresentationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPresentationGet& posfi_tclMsgPresentationGet::operator=(const posfi_tclMsgPresentationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPresentationGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPresentationGet::u16GetFunctionID() const {return POSFI_C_U16_PRESENTATION;}
tU8 posfi_tclMsgPresentationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgPresentationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPresentationGet::operator==(const posfi_tclMsgPresentationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPresentationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPresentationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPresentationUpReg::posfi_tclMsgPresentationUpReg(const posfi_tclMsgPresentationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPresentationUpReg& posfi_tclMsgPresentationUpReg::operator=(const posfi_tclMsgPresentationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPresentationUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPresentationUpReg::u16GetFunctionID() const {return POSFI_C_U16_PRESENTATION;}
tU8 posfi_tclMsgPresentationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgPresentationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPresentationUpReg::operator==(const posfi_tclMsgPresentationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPresentationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPresentationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPresentationRelUpReg::posfi_tclMsgPresentationRelUpReg(const posfi_tclMsgPresentationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPresentationRelUpReg& posfi_tclMsgPresentationRelUpReg::operator=(const posfi_tclMsgPresentationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPresentationRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPresentationRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_PRESENTATION;}
tU8 posfi_tclMsgPresentationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgPresentationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgPresentationRelUpReg::operator==(const posfi_tclMsgPresentationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgPresentationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPresentationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPresentationStatus::posfi_tclMsgPresentationStatus(const posfi_tclMsgPresentationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgPresentationStatus& posfi_tclMsgPresentationStatus::operator=(const posfi_tclMsgPresentationStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgPresentationStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgPresentationStatus::u16GetFunctionID() const {return POSFI_C_U16_PRESENTATION;}
tU8 posfi_tclMsgPresentationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 posfi_tclMsgPresentationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool posfi_tclMsgPresentationStatus::operator==(const posfi_tclMsgPresentationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status == rfoCmp.Status);
   return bResult;
}

fi_tclInContext& posfi_tclMsgPresentationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Status;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgPresentationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Status;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgAutomOdometerCalibrationGet::posfi_tclMsgAutomOdometerCalibrationGet(const posfi_tclMsgAutomOdometerCalibrationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgAutomOdometerCalibrationGet& posfi_tclMsgAutomOdometerCalibrationGet::operator=(const posfi_tclMsgAutomOdometerCalibrationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgAutomOdometerCalibrationGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgAutomOdometerCalibrationGet::u16GetFunctionID() const {return POSFI_C_U16_AUTOMODOMETERCALIBRATION;}
tU8 posfi_tclMsgAutomOdometerCalibrationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgAutomOdometerCalibrationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgAutomOdometerCalibrationGet::operator==(const posfi_tclMsgAutomOdometerCalibrationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgAutomOdometerCalibrationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgAutomOdometerCalibrationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgAutomOdometerCalibrationUpReg::posfi_tclMsgAutomOdometerCalibrationUpReg(const posfi_tclMsgAutomOdometerCalibrationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgAutomOdometerCalibrationUpReg& posfi_tclMsgAutomOdometerCalibrationUpReg::operator=(const posfi_tclMsgAutomOdometerCalibrationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgAutomOdometerCalibrationUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgAutomOdometerCalibrationUpReg::u16GetFunctionID() const {return POSFI_C_U16_AUTOMODOMETERCALIBRATION;}
tU8 posfi_tclMsgAutomOdometerCalibrationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgAutomOdometerCalibrationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgAutomOdometerCalibrationUpReg::operator==(const posfi_tclMsgAutomOdometerCalibrationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgAutomOdometerCalibrationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgAutomOdometerCalibrationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgAutomOdometerCalibrationRelUpReg::posfi_tclMsgAutomOdometerCalibrationRelUpReg(const posfi_tclMsgAutomOdometerCalibrationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgAutomOdometerCalibrationRelUpReg& posfi_tclMsgAutomOdometerCalibrationRelUpReg::operator=(const posfi_tclMsgAutomOdometerCalibrationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgAutomOdometerCalibrationRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgAutomOdometerCalibrationRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_AUTOMODOMETERCALIBRATION;}
tU8 posfi_tclMsgAutomOdometerCalibrationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgAutomOdometerCalibrationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgAutomOdometerCalibrationRelUpReg::operator==(const posfi_tclMsgAutomOdometerCalibrationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgAutomOdometerCalibrationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgAutomOdometerCalibrationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgAutomOdometerCalibrationStatus::posfi_tclMsgAutomOdometerCalibrationStatus(const posfi_tclMsgAutomOdometerCalibrationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   State = coRef.State;
   Progress = coRef.Progress;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgAutomOdometerCalibrationStatus& posfi_tclMsgAutomOdometerCalibrationStatus::operator=(const posfi_tclMsgAutomOdometerCalibrationStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   Progress = coRef.Progress;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgAutomOdometerCalibrationStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgAutomOdometerCalibrationStatus::u16GetFunctionID() const {return POSFI_C_U16_AUTOMODOMETERCALIBRATION;}
tU8 posfi_tclMsgAutomOdometerCalibrationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 posfi_tclMsgAutomOdometerCalibrationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool posfi_tclMsgAutomOdometerCalibrationStatus::operator==(const posfi_tclMsgAutomOdometerCalibrationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (State == rfoCmp.State);
      bResult = bResult && (Progress == rfoCmp.Progress);
   return bResult;
}

fi_tclInContext& posfi_tclMsgAutomOdometerCalibrationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> State;
   oIn >> Progress;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgAutomOdometerCalibrationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << State;
   oOut << Progress;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgEngineeringTextGet::posfi_tclMsgEngineeringTextGet(const posfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgEngineeringTextGet& posfi_tclMsgEngineeringTextGet::operator=(const posfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return POSFI_C_U16_ENGINEERINGTEXT;}
tU8 posfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgEngineeringTextGet::operator==(const posfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgEngineeringTextUpReg::posfi_tclMsgEngineeringTextUpReg(const posfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgEngineeringTextUpReg& posfi_tclMsgEngineeringTextUpReg::operator=(const posfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return POSFI_C_U16_ENGINEERINGTEXT;}
tU8 posfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgEngineeringTextUpReg::operator==(const posfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgEngineeringTextRelUpReg::posfi_tclMsgEngineeringTextRelUpReg(const posfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgEngineeringTextRelUpReg& posfi_tclMsgEngineeringTextRelUpReg::operator=(const posfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_ENGINEERINGTEXT;}
tU8 posfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgEngineeringTextRelUpReg::operator==(const posfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgEngineeringTextStatus::posfi_tclMsgEngineeringTextStatus(const posfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgEngineeringTextStatus& posfi_tclMsgEngineeringTextStatus::operator=(const posfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return POSFI_C_U16_ENGINEERINGTEXT;}
tU8 posfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid posfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 posfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool posfi_tclMsgEngineeringTextStatus::operator==(const posfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& posfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUsedDatasetGet::posfi_tclMsgUsedDatasetGet(const posfi_tclMsgUsedDatasetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUsedDatasetGet& posfi_tclMsgUsedDatasetGet::operator=(const posfi_tclMsgUsedDatasetGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgUsedDatasetGet::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgUsedDatasetGet::u16GetFunctionID() const {return POSFI_C_U16_USEDDATASET;}
tU8 posfi_tclMsgUsedDatasetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 posfi_tclMsgUsedDatasetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgUsedDatasetGet::operator==(const posfi_tclMsgUsedDatasetGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgUsedDatasetGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgUsedDatasetGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUsedDatasetUpReg::posfi_tclMsgUsedDatasetUpReg(const posfi_tclMsgUsedDatasetUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUsedDatasetUpReg& posfi_tclMsgUsedDatasetUpReg::operator=(const posfi_tclMsgUsedDatasetUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgUsedDatasetUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgUsedDatasetUpReg::u16GetFunctionID() const {return POSFI_C_U16_USEDDATASET;}
tU8 posfi_tclMsgUsedDatasetUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 posfi_tclMsgUsedDatasetUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgUsedDatasetUpReg::operator==(const posfi_tclMsgUsedDatasetUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgUsedDatasetUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgUsedDatasetUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUsedDatasetRelUpReg::posfi_tclMsgUsedDatasetRelUpReg(const posfi_tclMsgUsedDatasetRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUsedDatasetRelUpReg& posfi_tclMsgUsedDatasetRelUpReg::operator=(const posfi_tclMsgUsedDatasetRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgUsedDatasetRelUpReg::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgUsedDatasetRelUpReg::u16GetFunctionID() const {return POSFI_C_U16_USEDDATASET;}
tU8 posfi_tclMsgUsedDatasetRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 posfi_tclMsgUsedDatasetRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool posfi_tclMsgUsedDatasetRelUpReg::operator==(const posfi_tclMsgUsedDatasetRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& posfi_tclMsgUsedDatasetRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& posfi_tclMsgUsedDatasetRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUsedDatasetStatus::posfi_tclMsgUsedDatasetStatus(const posfi_tclMsgUsedDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
posfi_tclMsgUsedDatasetStatus& posfi_tclMsgUsedDatasetStatus::operator=(const posfi_tclMsgUsedDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 posfi_tclMsgUsedDatasetStatus::u16GetServiceID() const {return POSFI_C_U16_SERVICE_ID;}
tU16 posfi_tclMsgUsedDatasetStatus::u16GetFunctionID() const {return POSFI_C_U16_USEDDATASET;}
tU8 posfi_tclMsgUsedDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 posfi_tclMsgUsedDatasetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool posfi_tclMsgUsedDatasetStatus::operator==(const posfi_tclMsgUsedDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
   return bResult;
}

fi_tclInContext& posfi_tclMsgUsedDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   oIn >> DataSetId;
   return oIn;
}

fi_tclOutContext& posfi_tclMsgUsedDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   oOut << DataSetId;
   return oOut;
}

