/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef NAVIFITYPES_HEADER
#define NAVIFITYPES_HEADER

// #include <vector>
// 


class navifi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class navifi_tclMsgGetAvailablePermissionsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetAvailablePermissionsMethodStart():NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetAvailablePermissionsMethodStart& operator=(const navifi_tclMsgGetAvailablePermissionsMethodStart& coRef);
   navifi_tclMsgGetAvailablePermissionsMethodStart(const navifi_tclMsgGetAvailablePermissionsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetAvailablePermissionsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETAVAILABLEPERMISSIONSMETHODSTART;}
};

class navifi_tclMsgGetAvailablePermissionsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetAvailablePermissionsMethodResult():NavDataSetID(),AvailablePermissions() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetAvailablePermissionsMethodResult& operator=(const navifi_tclMsgGetAvailablePermissionsMethodResult& coRef);
   navifi_tclMsgGetAvailablePermissionsMethodResult(const navifi_tclMsgGetAvailablePermissionsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_RequiredPermissionList AvailablePermissions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetAvailablePermissionsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETAVAILABLEPERMISSIONSMETHODRESULT;}
};

class navifi_tclMsgGetGlobalAnnotationTablesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetGlobalAnnotationTablesMethodStart():NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetGlobalAnnotationTablesMethodStart& operator=(const navifi_tclMsgGetGlobalAnnotationTablesMethodStart& coRef);
   navifi_tclMsgGetGlobalAnnotationTablesMethodStart(const navifi_tclMsgGetGlobalAnnotationTablesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_e16_ISOCountryCode, std::allocator<fi_tcl_e16_ISOCountryCode> > RequiredCountryCodes;
   std::vector<fi_tcl_e8_GlobalAnnotationCategory, std::allocator<fi_tcl_e8_GlobalAnnotationCategory> > RequiredAnnotationTables;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetGlobalAnnotationTablesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETGLOBALANNOTATIONTABLESMETHODSTART;}
};

class navifi_tclMsgGetGlobalAnnotationTablesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetGlobalAnnotationTablesMethodResult():NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetGlobalAnnotationTablesMethodResult& operator=(const navifi_tclMsgGetGlobalAnnotationTablesMethodResult& coRef);
   navifi_tclMsgGetGlobalAnnotationTablesMethodResult(const navifi_tclMsgGetGlobalAnnotationTablesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_GlobalAnnotationTablesUnion, std::allocator<fi_tcl_GlobalAnnotationTablesUnion> > GlobalAnnotationTables;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetGlobalAnnotationTablesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETGLOBALANNOTATIONTABLESMETHODRESULT;}
};

class navifi_tclMsgGetAllTrafficMessagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetAllTrafficMessagesMethodStart():WantedBinContainer(),TMCodedMapMajorVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetAllTrafficMessagesMethodStart& operator=(const navifi_tclMsgGetAllTrafficMessagesMethodStart& coRef);
   navifi_tclMsgGetAllTrafficMessagesMethodStart(const navifi_tclMsgGetAllTrafficMessagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_TrafficMessageContent WantedBinContainer;
   tU16 TMCodedMapMajorVersion;
   std::vector<tU32, std::allocator<tU32> > TMCurrentIDList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetAllTrafficMessagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETALLTRAFFICMESSAGESMETHODSTART;}
};

class navifi_tclMsgGetAllTrafficMessagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetAllTrafficMessagesMethodResult():CurrentTrafficMessageRevision(0),WantedBinContainer(),TMContentComplete(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetAllTrafficMessagesMethodResult& operator=(const navifi_tclMsgGetAllTrafficMessagesMethodResult& coRef);
   navifi_tclMsgGetAllTrafficMessagesMethodResult(const navifi_tclMsgGetAllTrafficMessagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CurrentTrafficMessageRevision;
   fi_tcl_b8_TrafficMessageContent WantedBinContainer;
   tBool TMContentComplete;
   std::vector<tU32, std::allocator<tU32> > DeletedIDList;
   std::vector<fi_tcl_TMInfo, std::allocator<fi_tcl_TMInfo> > TMInfo;
   std::vector<fi_tcl_TMProgramService, std::allocator<fi_tcl_TMProgramService> > ProgramServiceList;
   std::vector<fi_tcl_TMServiceProvider, std::allocator<fi_tcl_TMServiceProvider> > ServiceProviderList;
   std::vector<fi_tcl_BinContainer, std::allocator<fi_tcl_BinContainer> > CodedTextMessages;
   std::vector<fi_tcl_BinContainer, std::allocator<fi_tcl_BinContainer> > CodedMapMessages;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetAllTrafficMessagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETALLTRAFFICMESSAGESMETHODRESULT;}
};

class navifi_tclMsgGetAllTMCLocationsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetAllTMCLocationsMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetAllTMCLocationsMethodStart& operator=(const navifi_tclMsgGetAllTMCLocationsMethodStart& coRef);
   navifi_tclMsgGetAllTMCLocationsMethodStart(const navifi_tclMsgGetAllTMCLocationsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetAllTMCLocationsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETALLTMCLOCATIONSMETHODSTART;}
};

class navifi_tclMsgGetAllTMCLocationsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetAllTMCLocationsMethodResult():CurrentTrafficMessageRevision(0),LocationElementCount(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetAllTMCLocationsMethodResult& operator=(const navifi_tclMsgGetAllTMCLocationsMethodResult& coRef);
   navifi_tclMsgGetAllTMCLocationsMethodResult(const navifi_tclMsgGetAllTMCLocationsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CurrentTrafficMessageRevision;
   tU32 LocationElementCount;
   std::vector<fi_tcl_CountryLocationList, std::allocator<fi_tcl_CountryLocationList> > LocationTableList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetAllTMCLocationsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETALLTMCLOCATIONSMETHODRESULT;}
};

class navifi_tclMsgChangeTrafficMessageHandlingMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgChangeTrafficMessageHandlingMethodStart():AmbiguousClosing(),AmbiguousDynamicDisruption(),AmbiguousArea() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgChangeTrafficMessageHandlingMethodStart& operator=(const navifi_tclMsgChangeTrafficMessageHandlingMethodStart& coRef);
   navifi_tclMsgChangeTrafficMessageHandlingMethodStart(const navifi_tclMsgChangeTrafficMessageHandlingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TMParamAmbiguousClosing AmbiguousClosing;
   fi_tcl_TMParamAmbiguousDynamicDisruption AmbiguousDynamicDisruption;
   fi_tcl_TMParamAmbiguousArea AmbiguousArea;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgChangeTrafficMessageHandlingMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_CHANGETRAFFICMESSAGEHANDLINGMETHODSTART;}
};

class navifi_tclMsgChangeTrafficMessageHandlingMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgChangeTrafficMessageHandlingMethodResult():AmbiguousClosing(),AmbiguousDynamicDisruption(),AmbiguousArea() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgChangeTrafficMessageHandlingMethodResult& operator=(const navifi_tclMsgChangeTrafficMessageHandlingMethodResult& coRef);
   navifi_tclMsgChangeTrafficMessageHandlingMethodResult(const navifi_tclMsgChangeTrafficMessageHandlingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TMParamAmbiguousClosing AmbiguousClosing;
   fi_tcl_TMParamAmbiguousDynamicDisruption AmbiguousDynamicDisruption;
   fi_tcl_TMParamAmbiguousArea AmbiguousArea;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgChangeTrafficMessageHandlingMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_CHANGETRAFFICMESSAGEHANDLINGMETHODRESULT;}
};

class navifi_tclMsgGetTrafficMessagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetTrafficMessagesMethodStart():WantedBinContainer(),TMCodedMapMajorVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetTrafficMessagesMethodStart& operator=(const navifi_tclMsgGetTrafficMessagesMethodStart& coRef);
   navifi_tclMsgGetTrafficMessagesMethodStart(const navifi_tclMsgGetTrafficMessagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_TrafficMessageContent WantedBinContainer;
   tU16 TMCodedMapMajorVersion;
   std::vector<tU32, std::allocator<tU32> > TMCurrentIDList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetTrafficMessagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETTRAFFICMESSAGESMETHODSTART;}
};

class navifi_tclMsgGetTrafficMessagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetTrafficMessagesMethodResult():CurrentTrafficMessageRevision(0),WantedBinContainer(),TMContentComplete(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetTrafficMessagesMethodResult& operator=(const navifi_tclMsgGetTrafficMessagesMethodResult& coRef);
   navifi_tclMsgGetTrafficMessagesMethodResult(const navifi_tclMsgGetTrafficMessagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CurrentTrafficMessageRevision;
   fi_tcl_b8_TrafficMessageContent WantedBinContainer;
   tBool TMContentComplete;
   std::vector<tU32, std::allocator<tU32> > DeletedIDList;
   std::vector<fi_tcl_TMBaseInfo, std::allocator<fi_tcl_TMBaseInfo> > TMBaseInfoList;
   std::vector<fi_tcl_TMProgramService, std::allocator<fi_tcl_TMProgramService> > ProgramServiceList;
   std::vector<fi_tcl_TMServiceProvider, std::allocator<fi_tcl_TMServiceProvider> > ServiceProviderList;
   std::vector<fi_tcl_TMInfoReference, std::allocator<fi_tcl_TMInfoReference> > TMInfoRefList;
   std::vector<fi_tcl_TMCodedTextReference, std::allocator<fi_tcl_TMCodedTextReference> > TMCodedTextRefList;
   std::vector<fi_tcl_TMCodedMapReference, std::allocator<fi_tcl_TMCodedMapReference> > TMCodedMapRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetTrafficMessagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETTRAFFICMESSAGESMETHODRESULT;}
};

class navifi_tclMsgDeleteUserTrafficMessagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgDeleteUserTrafficMessagesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgDeleteUserTrafficMessagesMethodStart& operator=(const navifi_tclMsgDeleteUserTrafficMessagesMethodStart& coRef);
   navifi_tclMsgDeleteUserTrafficMessagesMethodStart(const navifi_tclMsgDeleteUserTrafficMessagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_UserTrafficMessageHandle, std::allocator<fi_tcl_u16_UserTrafficMessageHandle> > UTMHandles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgDeleteUserTrafficMessagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_DELETEUSERTRAFFICMESSAGESMETHODSTART;}
};

class navifi_tclMsgDeleteUserTrafficMessagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgDeleteUserTrafficMessagesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgDeleteUserTrafficMessagesMethodResult& operator=(const navifi_tclMsgDeleteUserTrafficMessagesMethodResult& coRef);
   navifi_tclMsgDeleteUserTrafficMessagesMethodResult(const navifi_tclMsgDeleteUserTrafficMessagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_u16_ErrorCode, std::allocator<fi_tcl_u16_ErrorCode> > Result;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgDeleteUserTrafficMessagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_DELETEUSERTRAFFICMESSAGESMETHODRESULT;}
};

class navifi_tclMsgCreateUserTrafficMessagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgCreateUserTrafficMessagesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgCreateUserTrafficMessagesMethodStart& operator=(const navifi_tclMsgCreateUserTrafficMessagesMethodStart& coRef);
   navifi_tclMsgCreateUserTrafficMessagesMethodStart(const navifi_tclMsgCreateUserTrafficMessagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_UTMDesc, std::allocator<fi_tcl_UTMDesc> > UTMDesc;
   std::vector<fi_tcl_UTMDescByTM, std::allocator<fi_tcl_UTMDescByTM> > UTMDescByTM;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgCreateUserTrafficMessagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_CREATEUSERTRAFFICMESSAGESMETHODSTART;}
};

class navifi_tclMsgCreateUserTrafficMessagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgCreateUserTrafficMessagesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgCreateUserTrafficMessagesMethodResult& operator=(const navifi_tclMsgCreateUserTrafficMessagesMethodResult& coRef);
   navifi_tclMsgCreateUserTrafficMessagesMethodResult(const navifi_tclMsgCreateUserTrafficMessagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_UTMHandleContainer, std::allocator<fi_tcl_UTMHandleContainer> > UTMHandles;
   std::vector<fi_tcl_UTMHandleContainer, std::allocator<fi_tcl_UTMHandleContainer> > UTMHandlesByTM;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgCreateUserTrafficMessagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_CREATEUSERTRAFFICMESSAGESMETHODRESULT;}
};

class navifi_tclMsgGetTimeZoneInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetTimeZoneInfoMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetTimeZoneInfoMethodStart& operator=(const navifi_tclMsgGetTimeZoneInfoMethodStart& coRef);
   navifi_tclMsgGetTimeZoneInfoMethodStart(const navifi_tclMsgGetTimeZoneInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_BinContainer, std::allocator<fi_tcl_BinContainer> > Locations;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetTimeZoneInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETTIMEZONEINFOMETHODSTART;}
};

class navifi_tclMsgGetTimeZoneInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgGetTimeZoneInfoMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgGetTimeZoneInfoMethodResult& operator=(const navifi_tclMsgGetTimeZoneInfoMethodResult& coRef);
   navifi_tclMsgGetTimeZoneInfoMethodResult(const navifi_tclMsgGetTimeZoneInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TimeZoneElement, std::allocator<fi_tcl_TimeZoneElement> > TimeZoneElementList;
   std::vector<fi_tcl_TimeZoneName, std::allocator<fi_tcl_TimeZoneName> > TimeZoneNameList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgGetTimeZoneInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_GETTIMEZONEINFOMETHODRESULT;}
};

class navifi_tclMsgVersionInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgVersionInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgVersionInfoGet& operator=(const navifi_tclMsgVersionInfoGet& coRef);
   navifi_tclMsgVersionInfoGet(const navifi_tclMsgVersionInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgVersionInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_VERSIONINFOGET;}
};

class navifi_tclMsgVersionInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgVersionInfoStatus():ProductVersionInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgVersionInfoStatus& operator=(const navifi_tclMsgVersionInfoStatus& coRef);
   navifi_tclMsgVersionInfoStatus(const navifi_tclMsgVersionInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_VersionInfo ProductVersionInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgVersionInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_VERSIONINFOSTATUS;}
};

class navifi_tclMsgAvailablePOISourcesUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgAvailablePOISourcesUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgAvailablePOISourcesUpReg& operator=(const navifi_tclMsgAvailablePOISourcesUpReg& coRef);
   navifi_tclMsgAvailablePOISourcesUpReg(const navifi_tclMsgAvailablePOISourcesUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgAvailablePOISourcesUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESUPREG;}
};

class navifi_tclMsgAvailablePOISourcesRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgAvailablePOISourcesRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgAvailablePOISourcesRelUpReg& operator=(const navifi_tclMsgAvailablePOISourcesRelUpReg& coRef);
   navifi_tclMsgAvailablePOISourcesRelUpReg(const navifi_tclMsgAvailablePOISourcesRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgAvailablePOISourcesRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESRELUPREG;}
};

class navifi_tclMsgAvailablePOISourcesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgAvailablePOISourcesGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgAvailablePOISourcesGet& operator=(const navifi_tclMsgAvailablePOISourcesGet& coRef);
   navifi_tclMsgAvailablePOISourcesGet(const navifi_tclMsgAvailablePOISourcesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgAvailablePOISourcesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESGET;}
};

class navifi_tclMsgAvailablePOISourcesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgAvailablePOISourcesStatus():AvailablePOISource(),ChangedPOISource() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgAvailablePOISourcesStatus& operator=(const navifi_tclMsgAvailablePOISourcesStatus& coRef);
   navifi_tclMsgAvailablePOISourcesStatus(const navifi_tclMsgAvailablePOISourcesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_UPOI_Source AvailablePOISource;
   fi_tcl_b16_UPOI_Source ChangedPOISource;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgAvailablePOISourcesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESSTATUS;}
};

class navifi_tclMsgTrafficMessageSourceAvailableGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgTrafficMessageSourceAvailableGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgTrafficMessageSourceAvailableGet& operator=(const navifi_tclMsgTrafficMessageSourceAvailableGet& coRef);
   navifi_tclMsgTrafficMessageSourceAvailableGet(const navifi_tclMsgTrafficMessageSourceAvailableGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgTrafficMessageSourceAvailableGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_TRAFFICMESSAGESOURCEAVAILABLEGET;}
};

class navifi_tclMsgTrafficMessageSourceAvailableStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgTrafficMessageSourceAvailableStatus():TrafficMessageSourceAvailable(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgTrafficMessageSourceAvailableStatus& operator=(const navifi_tclMsgTrafficMessageSourceAvailableStatus& coRef);
   navifi_tclMsgTrafficMessageSourceAvailableStatus(const navifi_tclMsgTrafficMessageSourceAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool TrafficMessageSourceAvailable;
   std::vector<fi_tcl_ISORDBIdAvailability, std::allocator<fi_tcl_ISORDBIdAvailability> > SupportedRDBIDs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgTrafficMessageSourceAvailableStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_TRAFFICMESSAGESOURCEAVAILABLESTATUS;}
};

class navifi_tclMsgAllTrafficMessagesStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgAllTrafficMessagesStatusGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgAllTrafficMessagesStatusGet& operator=(const navifi_tclMsgAllTrafficMessagesStatusGet& coRef);
   navifi_tclMsgAllTrafficMessagesStatusGet(const navifi_tclMsgAllTrafficMessagesStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgAllTrafficMessagesStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_ALLTRAFFICMESSAGESSTATUSGET;}
};

class navifi_tclMsgAllTrafficMessagesStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgAllTrafficMessagesStatusStatus():Status(),CurrentTrafficMessageRevision(0),TMStatistics() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgAllTrafficMessagesStatusStatus& operator=(const navifi_tclMsgAllTrafficMessagesStatusStatus& coRef);
   navifi_tclMsgAllTrafficMessagesStatusStatus(const navifi_tclMsgAllTrafficMessagesStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_InfoStatus Status;
   tU32 CurrentTrafficMessageRevision;
   fi_tcl_TMStatistics TMStatistics;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgAllTrafficMessagesStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_ALLTRAFFICMESSAGESSTATUSSTATUS;}
};

class navifi_tclMsgTrafficMsgMemoryStatisticsUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgTrafficMsgMemoryStatisticsUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgTrafficMsgMemoryStatisticsUpReg& operator=(const navifi_tclMsgTrafficMsgMemoryStatisticsUpReg& coRef);
   navifi_tclMsgTrafficMsgMemoryStatisticsUpReg(const navifi_tclMsgTrafficMsgMemoryStatisticsUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgTrafficMsgMemoryStatisticsUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSUPREG;}
};

class navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg& operator=(const navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg& coRef);
   navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg(const navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSRELUPREG;}
};

class navifi_tclMsgTrafficMsgMemoryStatisticsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgTrafficMsgMemoryStatisticsStatus():TrafficMsgMemoryStatisticsAll(),TrafficMsgMemoryStatisticsSelected() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgTrafficMsgMemoryStatisticsStatus& operator=(const navifi_tclMsgTrafficMsgMemoryStatisticsStatus& coRef);
   navifi_tclMsgTrafficMsgMemoryStatisticsStatus(const navifi_tclMsgTrafficMsgMemoryStatisticsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficMsgMemoryStatistics TrafficMsgMemoryStatisticsAll;
   fi_tcl_TrafficMsgMemoryStatistics TrafficMsgMemoryStatisticsSelected;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgTrafficMsgMemoryStatisticsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSSTATUS;}
};

class navifi_tclMsgUserTrafficMessagesStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgUserTrafficMessagesStatusGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgUserTrafficMessagesStatusGet& operator=(const navifi_tclMsgUserTrafficMessagesStatusGet& coRef);
   navifi_tclMsgUserTrafficMessagesStatusGet(const navifi_tclMsgUserTrafficMessagesStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgUserTrafficMessagesStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_USERTRAFFICMESSAGESSTATUSGET;}
};

class navifi_tclMsgUserTrafficMessagesStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgUserTrafficMessagesStatusStatus():FreeUTMHandleCount(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgUserTrafficMessagesStatusStatus& operator=(const navifi_tclMsgUserTrafficMessagesStatusStatus& coRef);
   navifi_tclMsgUserTrafficMessagesStatusStatus(const navifi_tclMsgUserTrafficMessagesStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 FreeUTMHandleCount;
   std::vector<fi_tcl_u16_UserTrafficMessageHandle, std::allocator<fi_tcl_u16_UserTrafficMessageHandle> > UsedUTMHandles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgUserTrafficMessagesStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_USERTRAFFICMESSAGESSTATUSSTATUS;}
};

class navifi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgEngineeringTextGet& operator=(const navifi_tclMsgEngineeringTextGet& coRef);
   navifi_tclMsgEngineeringTextGet(const navifi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class navifi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgEngineeringTextUpReg& operator=(const navifi_tclMsgEngineeringTextUpReg& coRef);
   navifi_tclMsgEngineeringTextUpReg(const navifi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class navifi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgEngineeringTextRelUpReg& operator=(const navifi_tclMsgEngineeringTextRelUpReg& coRef);
   navifi_tclMsgEngineeringTextRelUpReg(const navifi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class navifi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgEngineeringTextStatus& operator=(const navifi_tclMsgEngineeringTextStatus& coRef);
   navifi_tclMsgEngineeringTextStatus(const navifi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};

class navifi_tclMsgUsedDatasetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgUsedDatasetGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgUsedDatasetGet& operator=(const navifi_tclMsgUsedDatasetGet& coRef);
   navifi_tclMsgUsedDatasetGet(const navifi_tclMsgUsedDatasetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgUsedDatasetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_USEDDATASETGET;}
};

class navifi_tclMsgUsedDatasetUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgUsedDatasetUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgUsedDatasetUpReg& operator=(const navifi_tclMsgUsedDatasetUpReg& coRef);
   navifi_tclMsgUsedDatasetUpReg(const navifi_tclMsgUsedDatasetUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgUsedDatasetUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_USEDDATASETUPREG;}
};

class navifi_tclMsgUsedDatasetRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgUsedDatasetRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgUsedDatasetRelUpReg& operator=(const navifi_tclMsgUsedDatasetRelUpReg& coRef);
   navifi_tclMsgUsedDatasetRelUpReg(const navifi_tclMsgUsedDatasetRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgUsedDatasetRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_USEDDATASETRELUPREG;}
};

class navifi_tclMsgUsedDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   navifi_tclMsgUsedDatasetStatus():MediaId(),DataSetId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   navifi_tclMsgUsedDatasetStatus& operator=(const navifi_tclMsgUsedDatasetStatus& coRef);
   navifi_tclMsgUsedDatasetStatus(const navifi_tclMsgUsedDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_MediaId MediaId;
   fi_tcl_u32_DataSetId DataSetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const navifi_tclMsgUsedDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return navifi_tclToken::EN_MSG_USEDDATASETSTATUS;}
};


#endif
