/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetMovieListMethodStart::movietimesfi_tclMsgGetMovieListMethodStart(const movietimesfi_tclMsgGetMovieListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MovieIdList = coRef.MovieIdList;
   DetailGrade = coRef.DetailGrade;
   PreferredLanguage = coRef.PreferredLanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetMovieListMethodStart& movietimesfi_tclMsgGetMovieListMethodStart::operator=(const movietimesfi_tclMsgGetMovieListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MovieIdList = coRef.MovieIdList;
   DetailGrade = coRef.DetailGrade;
   PreferredLanguage = coRef.PreferredLanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 movietimesfi_tclMsgGetMovieListMethodStart::u16GetServiceID() const {return MOVIETIMESFI_C_U16_SERVICE_ID;}
tU16 movietimesfi_tclMsgGetMovieListMethodStart::u16GetFunctionID() const {return MOVIETIMESFI_C_U16_GETMOVIELIST;}
tU8 movietimesfi_tclMsgGetMovieListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid movietimesfi_tclMsgGetMovieListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MovieIdList.size(); ++u32Idx)
         MovieIdList[u32Idx].vDestroy();
   }
   MovieIdList.clear();
}

tU32 movietimesfi_tclMsgGetMovieListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7+MovieIdList.size()*1;
}

tBool movietimesfi_tclMsgGetMovieListMethodStart::operator==(const movietimesfi_tclMsgGetMovieListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MovieIdList.size() == rfoCmp.MovieIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MovieIdList.size()); ++u32Idx)
            bResult = bResult && (MovieIdList[u32Idx] == rfoCmp.MovieIdList[u32Idx]);
      }
      bResult = bResult && (DetailGrade == rfoCmp.DetailGrade);
      bResult = bResult && (PreferredLanguage == rfoCmp.PreferredLanguage);
   return bResult;
}

fi_tclInContext& movietimesfi_tclMsgGetMovieListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MovieIdList.size(); ++u32Idx)
      {
         MovieIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MovieIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MovieIdList[u32Idx];
      }
   }
   oIn >> DetailGrade;
   oIn >> PreferredLanguage;
   return oIn;
}

fi_tclOutContext& movietimesfi_tclMsgGetMovieListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)MovieIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MovieIdList.size(); ++u32Idx)
         oOut << MovieIdList[u32Idx];
   }
   oOut << DetailGrade;
   oOut << PreferredLanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetMovieListMethodResult::movietimesfi_tclMsgGetMovieListMethodResult(const movietimesfi_tclMsgGetMovieListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MovieList = coRef.MovieList;
   MovieListComplete = coRef.MovieListComplete;
   TimeStamp = coRef.TimeStamp;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetMovieListMethodResult& movietimesfi_tclMsgGetMovieListMethodResult::operator=(const movietimesfi_tclMsgGetMovieListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MovieList = coRef.MovieList;
   MovieListComplete = coRef.MovieListComplete;
   TimeStamp = coRef.TimeStamp;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 movietimesfi_tclMsgGetMovieListMethodResult::u16GetServiceID() const {return MOVIETIMESFI_C_U16_SERVICE_ID;}
tU16 movietimesfi_tclMsgGetMovieListMethodResult::u16GetFunctionID() const {return MOVIETIMESFI_C_U16_GETMOVIELIST;}
tU8 movietimesfi_tclMsgGetMovieListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid movietimesfi_tclMsgGetMovieListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MovieList.size(); ++u32Idx)
         MovieList[u32Idx].vDestroy();
   }
   MovieList.clear();
   TimeStamp.vDestroy(); 
}

tU32 movietimesfi_tclMsgGetMovieListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MovieList.size(); ++u32ListIdx)
      u32DynamicSize += MovieList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool movietimesfi_tclMsgGetMovieListMethodResult::operator==(const movietimesfi_tclMsgGetMovieListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MovieList.size() == rfoCmp.MovieList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MovieList.size()); ++u32Idx)
            bResult = bResult && (MovieList[u32Idx] == rfoCmp.MovieList[u32Idx]);
      }
      bResult = bResult && (MovieListComplete == rfoCmp.MovieListComplete);
      bResult = bResult && (TimeStamp == rfoCmp.TimeStamp);
   return bResult;
}

fi_tclInContext& movietimesfi_tclMsgGetMovieListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MovieList.size(); ++u32Idx)
      {
         MovieList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MovieList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MovieList[u32Idx];
      }
   }
   oIn >> MovieListComplete;
   oIn >> TimeStamp;
   return oIn;
}

fi_tclOutContext& movietimesfi_tclMsgGetMovieListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)MovieList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MovieList.size(); ++u32Idx)
         oOut << MovieList[u32Idx];
   }
   oOut << MovieListComplete;
   oOut << TimeStamp;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetMovieTimesMethodStart::movietimesfi_tclMsgGetMovieTimesMethodStart(const movietimesfi_tclMsgGetMovieTimesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TheaterList = coRef.TheaterList;
   PreferredLanguage = coRef.PreferredLanguage;
   ListOfMovies = coRef.ListOfMovies;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetMovieTimesMethodStart& movietimesfi_tclMsgGetMovieTimesMethodStart::operator=(const movietimesfi_tclMsgGetMovieTimesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TheaterList = coRef.TheaterList;
   PreferredLanguage = coRef.PreferredLanguage;
   ListOfMovies = coRef.ListOfMovies;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 movietimesfi_tclMsgGetMovieTimesMethodStart::u16GetServiceID() const {return MOVIETIMESFI_C_U16_SERVICE_ID;}
tU16 movietimesfi_tclMsgGetMovieTimesMethodStart::u16GetFunctionID() const {return MOVIETIMESFI_C_U16_GETMOVIETIMES;}
tU8 movietimesfi_tclMsgGetMovieTimesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid movietimesfi_tclMsgGetMovieTimesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterList.size(); ++u32Idx)
         TheaterList[u32Idx].vDestroy();
   }
   TheaterList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfMovies.size(); ++u32Idx)
         ListOfMovies[u32Idx].vDestroy();
   }
   ListOfMovies.clear();
}

tU32 movietimesfi_tclMsgGetMovieTimesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TheaterList.size(); ++u32ListIdx)
      u32DynamicSize += TheaterList[u32ListIdx].u32GetSize(u16MajorVersion);
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += ListOfMovies.size()*1;
   }
   return u32DynamicSize+6;
}

tBool movietimesfi_tclMsgGetMovieTimesMethodStart::operator==(const movietimesfi_tclMsgGetMovieTimesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TheaterList.size() == rfoCmp.TheaterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TheaterList.size()); ++u32Idx)
            bResult = bResult && (TheaterList[u32Idx] == rfoCmp.TheaterList[u32Idx]);
      }
      bResult = bResult && (PreferredLanguage == rfoCmp.PreferredLanguage);
      bResult = bResult && (ListOfMovies.size() == rfoCmp.ListOfMovies.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfMovies.size()); ++u32Idx)
            bResult = bResult && (ListOfMovies[u32Idx] == rfoCmp.ListOfMovies[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& movietimesfi_tclMsgGetMovieTimesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TheaterList.size(); ++u32Idx)
      {
         TheaterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TheaterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TheaterList[u32Idx];
      }
   }
   oIn >> PreferredLanguage;
   if (3 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < ListOfMovies.size(); ++u32Idx)
         {
            ListOfMovies[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         ListOfMovies.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> ListOfMovies[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& movietimesfi_tclMsgGetMovieTimesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)TheaterList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterList.size(); ++u32Idx)
         oOut << TheaterList[u32Idx];
   }
   oOut << PreferredLanguage;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)ListOfMovies.size();
      {
         for (tU32 u32Idx = 0; u32Idx < ListOfMovies.size(); ++u32Idx)
            oOut << ListOfMovies[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetMovieTimesMethodResult::movietimesfi_tclMsgGetMovieTimesMethodResult(const movietimesfi_tclMsgGetMovieTimesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MovieTimesList = coRef.MovieTimesList;
   BriefMovieList = coRef.BriefMovieList;
   TimeStamp = coRef.TimeStamp;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetMovieTimesMethodResult& movietimesfi_tclMsgGetMovieTimesMethodResult::operator=(const movietimesfi_tclMsgGetMovieTimesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MovieTimesList = coRef.MovieTimesList;
   BriefMovieList = coRef.BriefMovieList;
   TimeStamp = coRef.TimeStamp;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 movietimesfi_tclMsgGetMovieTimesMethodResult::u16GetServiceID() const {return MOVIETIMESFI_C_U16_SERVICE_ID;}
tU16 movietimesfi_tclMsgGetMovieTimesMethodResult::u16GetFunctionID() const {return MOVIETIMESFI_C_U16_GETMOVIETIMES;}
tU8 movietimesfi_tclMsgGetMovieTimesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid movietimesfi_tclMsgGetMovieTimesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MovieTimesList.size(); ++u32Idx)
         MovieTimesList[u32Idx].vDestroy();
   }
   MovieTimesList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < BriefMovieList.size(); ++u32Idx)
         BriefMovieList[u32Idx].vDestroy();
   }
   BriefMovieList.clear();
   TimeStamp.vDestroy(); 
}

tU32 movietimesfi_tclMsgGetMovieTimesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MovieTimesList.size(); ++u32ListIdx)
      u32DynamicSize += MovieTimesList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < BriefMovieList.size(); ++u32ListIdx)
      u32DynamicSize += BriefMovieList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool movietimesfi_tclMsgGetMovieTimesMethodResult::operator==(const movietimesfi_tclMsgGetMovieTimesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MovieTimesList.size() == rfoCmp.MovieTimesList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MovieTimesList.size()); ++u32Idx)
            bResult = bResult && (MovieTimesList[u32Idx] == rfoCmp.MovieTimesList[u32Idx]);
      }
      bResult = bResult && (BriefMovieList.size() == rfoCmp.BriefMovieList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BriefMovieList.size()); ++u32Idx)
            bResult = bResult && (BriefMovieList[u32Idx] == rfoCmp.BriefMovieList[u32Idx]);
      }
      bResult = bResult && (TimeStamp == rfoCmp.TimeStamp);
   return bResult;
}

fi_tclInContext& movietimesfi_tclMsgGetMovieTimesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MovieTimesList.size(); ++u32Idx)
      {
         MovieTimesList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MovieTimesList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MovieTimesList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BriefMovieList.size(); ++u32Idx)
      {
         BriefMovieList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      BriefMovieList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> BriefMovieList[u32Idx];
      }
   }
   oIn >> TimeStamp;
   return oIn;
}

fi_tclOutContext& movietimesfi_tclMsgGetMovieTimesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)MovieTimesList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MovieTimesList.size(); ++u32Idx)
         oOut << MovieTimesList[u32Idx];
   }
   oOut << (tU32)BriefMovieList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < BriefMovieList.size(); ++u32Idx)
         oOut << BriefMovieList[u32Idx];
   }
   oOut << TimeStamp;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TheaterList = coRef.TheaterList;
   DescriptionRequest = coRef.DescriptionRequest;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart& movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::operator=(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TheaterList = coRef.TheaterList;
   DescriptionRequest = coRef.DescriptionRequest;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::u16GetServiceID() const {return MOVIETIMESFI_C_U16_SERVICE_ID;}
tU16 movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::u16GetFunctionID() const {return MOVIETIMESFI_C_U16_GETLISTOFTHEATERDESCRIPTION;}
tU8 movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterList.size(); ++u32Idx)
         TheaterList[u32Idx].vDestroy();
   }
   TheaterList.clear();
}

tU32 movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TheaterList.size(); ++u32ListIdx)
      u32DynamicSize += TheaterList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::operator==(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TheaterList.size() == rfoCmp.TheaterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TheaterList.size()); ++u32Idx)
            bResult = bResult && (TheaterList[u32Idx] == rfoCmp.TheaterList[u32Idx]);
      }
      bResult = bResult && (DescriptionRequest == rfoCmp.DescriptionRequest);
   return bResult;
}

fi_tclInContext& movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TheaterList.size(); ++u32Idx)
      {
         TheaterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TheaterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TheaterList[u32Idx];
      }
   }
   oIn >> DescriptionRequest;
   return oIn;
}

fi_tclOutContext& movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)TheaterList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterList.size(); ++u32Idx)
         oOut << TheaterList[u32Idx];
   }
   oOut << DescriptionRequest;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TheaterDescription = coRef.TheaterDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult& movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::operator=(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TheaterDescription = coRef.TheaterDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::u16GetServiceID() const {return MOVIETIMESFI_C_U16_SERVICE_ID;}
tU16 movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::u16GetFunctionID() const {return MOVIETIMESFI_C_U16_GETLISTOFTHEATERDESCRIPTION;}
tU8 movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterDescription.size(); ++u32Idx)
         TheaterDescription[u32Idx].vDestroy();
   }
   TheaterDescription.clear();
}

tU32 movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TheaterDescription.size(); ++u32ListIdx)
      u32DynamicSize += TheaterDescription[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::operator==(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TheaterDescription.size() == rfoCmp.TheaterDescription.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TheaterDescription.size()); ++u32Idx)
            bResult = bResult && (TheaterDescription[u32Idx] == rfoCmp.TheaterDescription[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TheaterDescription.size(); ++u32Idx)
      {
         TheaterDescription[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TheaterDescription.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TheaterDescription[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)TheaterDescription.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterDescription.size(); ++u32Idx)
         oOut << TheaterDescription[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfPosition = coRef.ListOfPosition;
   Distance = coRef.Distance;
   MaxNumberOfTheaters = coRef.MaxNumberOfTheaters;
   PreferredLanguage = coRef.PreferredLanguage;
   ListOfMovies = coRef.ListOfMovies;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart& movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::operator=(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListOfPosition = coRef.ListOfPosition;
   Distance = coRef.Distance;
   MaxNumberOfTheaters = coRef.MaxNumberOfTheaters;
   PreferredLanguage = coRef.PreferredLanguage;
   ListOfMovies = coRef.ListOfMovies;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::u16GetServiceID() const {return MOVIETIMESFI_C_U16_SERVICE_ID;}
tU16 movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::u16GetFunctionID() const {return MOVIETIMESFI_C_U16_GETLISTOFMOVIETIMESBYPOSITION;}
tU8 movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfPosition.size(); ++u32Idx)
         ListOfPosition[u32Idx].vDestroy();
   }
   ListOfPosition.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfMovies.size(); ++u32Idx)
         ListOfMovies[u32Idx].vDestroy();
   }
   ListOfMovies.clear();
}

tU32 movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16+ListOfPosition.size()*8+ListOfMovies.size()*1;
}

tBool movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::operator==(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfPosition.size() == rfoCmp.ListOfPosition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfPosition.size()); ++u32Idx)
            bResult = bResult && (ListOfPosition[u32Idx] == rfoCmp.ListOfPosition[u32Idx]);
      }
      bResult = bResult && (Distance == rfoCmp.Distance);
      bResult = bResult && (MaxNumberOfTheaters == rfoCmp.MaxNumberOfTheaters);
      bResult = bResult && (PreferredLanguage == rfoCmp.PreferredLanguage);
      bResult = bResult && (ListOfMovies.size() == rfoCmp.ListOfMovies.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfMovies.size()); ++u32Idx)
            bResult = bResult && (ListOfMovies[u32Idx] == rfoCmp.ListOfMovies[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfPosition.size(); ++u32Idx)
      {
         ListOfPosition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfPosition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfPosition[u32Idx];
      }
   }
   oIn >> Distance;
   oIn >> MaxNumberOfTheaters;
   oIn >> PreferredLanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfMovies.size(); ++u32Idx)
      {
         ListOfMovies[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfMovies.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfMovies[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfPosition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfPosition.size(); ++u32Idx)
         oOut << ListOfPosition[u32Idx];
   }
   oOut << Distance;
   oOut << MaxNumberOfTheaters;
   oOut << PreferredLanguage;
   oOut << (tU32)ListOfMovies.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfMovies.size(); ++u32Idx)
         oOut << ListOfMovies[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MovieTimesForPositionList = coRef.MovieTimesForPositionList;
   BriefMovieList = coRef.BriefMovieList;
   TimeStamp = coRef.TimeStamp;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult& movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::operator=(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MovieTimesForPositionList = coRef.MovieTimesForPositionList;
   BriefMovieList = coRef.BriefMovieList;
   TimeStamp = coRef.TimeStamp;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::u16GetServiceID() const {return MOVIETIMESFI_C_U16_SERVICE_ID;}
tU16 movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::u16GetFunctionID() const {return MOVIETIMESFI_C_U16_GETLISTOFMOVIETIMESBYPOSITION;}
tU8 movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MovieTimesForPositionList.size(); ++u32Idx)
         MovieTimesForPositionList[u32Idx].vDestroy();
   }
   MovieTimesForPositionList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < BriefMovieList.size(); ++u32Idx)
         BriefMovieList[u32Idx].vDestroy();
   }
   BriefMovieList.clear();
   TimeStamp.vDestroy(); 
}

tU32 movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MovieTimesForPositionList.size(); ++u32ListIdx)
      u32DynamicSize += MovieTimesForPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < BriefMovieList.size(); ++u32ListIdx)
      u32DynamicSize += BriefMovieList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::operator==(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MovieTimesForPositionList.size() == rfoCmp.MovieTimesForPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MovieTimesForPositionList.size()); ++u32Idx)
            bResult = bResult && (MovieTimesForPositionList[u32Idx] == rfoCmp.MovieTimesForPositionList[u32Idx]);
      }
      bResult = bResult && (BriefMovieList.size() == rfoCmp.BriefMovieList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BriefMovieList.size()); ++u32Idx)
            bResult = bResult && (BriefMovieList[u32Idx] == rfoCmp.BriefMovieList[u32Idx]);
      }
      bResult = bResult && (TimeStamp == rfoCmp.TimeStamp);
   return bResult;
}

fi_tclInContext& movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MovieTimesForPositionList.size(); ++u32Idx)
      {
         MovieTimesForPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MovieTimesForPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MovieTimesForPositionList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BriefMovieList.size(); ++u32Idx)
      {
         BriefMovieList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      BriefMovieList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> BriefMovieList[u32Idx];
      }
   }
   oIn >> TimeStamp;
   return oIn;
}

fi_tclOutContext& movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)MovieTimesForPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MovieTimesForPositionList.size(); ++u32Idx)
         oOut << MovieTimesForPositionList[u32Idx];
   }
   oOut << (tU32)BriefMovieList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < BriefMovieList.size(); ++u32Idx)
         oOut << BriefMovieList[u32Idx];
   }
   oOut << TimeStamp;
   return oOut;
}

