#ifndef MOVIETIMESFILANGUAGE_HEADER
#define MOVIETIMESFILANGUAGE_HEADER

class movietimesfi_tclInContext;
class movietimesfi_tclOutContext;
class movietimesfi_tclVisitorBase;

class MY_DECL movietimesfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  movietimesfi_tclDescription(fi_tclInContext* poIn, movietimesfi_tclVisitorBase* poVisit);
  movietimesfi_tclDescription(fi_tclOutContext* poOut, movietimesfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(movietimesfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ movietimesfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  movietimesfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<movietimesfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<movietimesfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline movietimesfi_tclDescription::movietimesfi_tclDescription(fi_tclInContext* poIn, movietimesfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline movietimesfi_tclDescription::movietimesfi_tclDescription(fi_tclOutContext* poOut, movietimesfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

