#include "precompiled.hh"

tBool movietimesfi_tclDescription::bInitMessage(movietimesfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case movietimesfi_tclToken::EN_LAST_TOKEN:
   case movietimesfi_tclToken::EN_LIST:
   case movietimesfi_tclToken::EN_END_OF_STRUCT:
   case movietimesfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case movietimesfi_tclToken::EN_MSG_GETMOVIELISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_E16_ISOLANGUAGECODE,movietimesfi_tclSemanticDomain::EN_MSG_PREFERREDLANGUAGE));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_E8_DETAILGRADE,movietimesfi_tclSemanticDomain::EN_MSG_DETAILGRADE));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIEID,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_MOVIEIDLIST));
   } break;
   case movietimesfi_tclToken::EN_MSG_GETMOVIELISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_POSIXTIME,movietimesfi_tclSemanticDomain::EN_MSG_TIMESTAMP));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_BOOL,movietimesfi_tclSemanticDomain::EN_MSG_MOVIELISTCOMPLETE));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIEDESCRIPTION,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_MOVIELIST));
   } break;
   case movietimesfi_tclToken::EN_MSG_GETMOVIETIMESMETHODSTART:
   {
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIEID,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_LISTOFMOVIES));
      }
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_E16_ISOLANGUAGECODE,movietimesfi_tclSemanticDomain::EN_MSG_PREFERREDLANGUAGE));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERID,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_THEATERLIST));
   } break;
   case movietimesfi_tclToken::EN_MSG_GETMOVIETIMESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_POSIXTIME,movietimesfi_tclSemanticDomain::EN_MSG_TIMESTAMP));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_BRIEFMOVIEDESCRIPTION,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_BRIEFMOVIELIST));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERMOVIETIMES,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_MOVIETIMESLIST));
   } break;
   case movietimesfi_tclToken::EN_MSG_GETLISTOFTHEATERDESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_B16_THEATERDESCRIPTIONREQUEST,movietimesfi_tclSemanticDomain::EN_MSG_DESCRIPTIONREQUEST));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERID,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_THEATERLIST));
   } break;
   case movietimesfi_tclToken::EN_MSG_GETLISTOFTHEATERDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERDESCRIPTION,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_THEATERDESCRIPTION));
   } break;
   case movietimesfi_tclToken::EN_MSG_GETLISTOFMOVIETIMESBYPOSITIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIEID,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_LISTOFMOVIES));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_E16_ISOLANGUAGECODE,movietimesfi_tclSemanticDomain::EN_MSG_PREFERREDLANGUAGE));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_U16,movietimesfi_tclSemanticDomain::EN_MSG_MAXNUMBEROFTHEATERS));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_S32_METER,movietimesfi_tclSemanticDomain::EN_MSG_DISTANCE));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_POSITIONWGS84,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_LISTOFPOSITION));
   } break;
   case movietimesfi_tclToken::EN_MSG_GETLISTOFMOVIETIMESBYPOSITIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_POSIXTIME,movietimesfi_tclSemanticDomain::EN_MSG_TIMESTAMP));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_BRIEFMOVIEDESCRIPTION,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_BRIEFMOVIELIST));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERMOVIETIMESFORPOSITION,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MSG_MOVIETIMESFORPOSITIONLIST));
   } break;
   case movietimesfi_tclToken::EN_BINCONTAINER:
   case movietimesfi_tclToken::EN_S32_METER:
   case movietimesfi_tclToken::EN_POSIXTIME:
   case movietimesfi_tclToken::EN_S32_LONGITUDE:
   case movietimesfi_tclToken::EN_S32_LATITUDE:
   case movietimesfi_tclToken::EN_POSITIONWGS84:
   case movietimesfi_tclToken::EN_E16_ISOLANGUAGECODE:
   case movietimesfi_tclToken::EN_STATE:
   case movietimesfi_tclToken::EN_E8_AMENITY:
   case movietimesfi_tclToken::EN_AMENITY:
   case movietimesfi_tclToken::EN_B16_THEATERDESCRIPTIONREQUEST:
   case movietimesfi_tclToken::EN_THEATERINFO:
   case movietimesfi_tclToken::EN_MOVIEID:
   case movietimesfi_tclToken::EN_RATING:
   case movietimesfi_tclToken::EN_RUNTIME:
   case movietimesfi_tclToken::EN_MOVIENAME:
   case movietimesfi_tclToken::EN_MOVIEDESCRIPTION:
   case movietimesfi_tclToken::EN_THEATERID:
   case movietimesfi_tclToken::EN_SHOWING:
   case movietimesfi_tclToken::EN_MOVIETIMES:
   case movietimesfi_tclToken::EN_THEATERMOVIETIMES:
   case movietimesfi_tclToken::EN_THEATERMOVIETIMESFORPOSITION:
   case movietimesfi_tclToken::EN_E8_DETAILGRADE:
   case movietimesfi_tclToken::EN_BRIEFMOVIEDESCRIPTION:
   case movietimesfi_tclToken::EN_THEATERDESCRIPTION:
   case movietimesfi_tclToken::EN_U8:   
   case movietimesfi_tclToken::EN_S8:   
   case movietimesfi_tclToken::EN_U16:   
   case movietimesfi_tclToken::EN_S16:   
   case movietimesfi_tclToken::EN_U24:   
   case movietimesfi_tclToken::EN_S24:   
   case movietimesfi_tclToken::EN_U32:   
   case movietimesfi_tclToken::EN_S32:   
   case movietimesfi_tclToken::EN_U64:   
   case movietimesfi_tclToken::EN_S64:   
   case movietimesfi_tclToken::EN_F32:   
   case movietimesfi_tclToken::EN_F64:   
   case movietimesfi_tclToken::EN_BOOL:   
   case movietimesfi_tclToken::EN_STRING:   
   case movietimesfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(movietimesfi_tclKnot(enMsgToken,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool movietimesfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool movietimesfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      movietimesfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      movietimesfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      movietimesfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(movietimesfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(movietimesfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(movietimesfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case movietimesfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == movietimesfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            movietimesfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(movietimesfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            movietimesfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(movietimesfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case movietimesfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case movietimesfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case movietimesfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case movietimesfi_tclToken::EN_MSG_GETMOVIELISTMETHODSTART:
   case movietimesfi_tclToken::EN_MSG_GETMOVIELISTMETHODRESULT:
   case movietimesfi_tclToken::EN_MSG_GETMOVIETIMESMETHODSTART:
   case movietimesfi_tclToken::EN_MSG_GETMOVIETIMESMETHODRESULT:
   case movietimesfi_tclToken::EN_MSG_GETLISTOFTHEATERDESCRIPTIONMETHODSTART:
   case movietimesfi_tclToken::EN_MSG_GETLISTOFTHEATERDESCRIPTIONMETHODRESULT:
   case movietimesfi_tclToken::EN_MSG_GETLISTOFMOVIETIMESBYPOSITIONMETHODSTART:
   case movietimesfi_tclToken::EN_MSG_GETLISTOFMOVIETIMESBYPOSITIONMETHODRESULT:
      bInitMessage(enToken);
      break;
   case movietimesfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_U8,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case movietimesfi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_S32,movietimesfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case movietimesfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case movietimesfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_S32_LATITUDE,movietimesfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_S32_LONGITUDE,movietimesfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case movietimesfi_tclToken::EN_STATE:
   {
      if (poVisitor->bDoExpand_State(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_STATENAME));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_STATEID));
      }
      else
      {
         fi_tcl_State o_State;
         if (!bDoIt(o_State))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_E8_AMENITY:
   {
      fi_tcl_e8_Amenity o_e8_Amenity;
      if (!bDoIt(o_e8_Amenity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case movietimesfi_tclToken::EN_AMENITY:
   {
      if (poVisitor->bDoExpand_Amenity(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_E8_AMENITY,movietimesfi_tclSemanticDomain::EN_AMENITY));
      }
      else
      {
         fi_tcl_Amenity o_Amenity;
         if (!bDoIt(o_Amenity))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Amenity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Amenity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_B16_THEATERDESCRIPTIONREQUEST:
   {
      fi_tcl_b16_TheaterDescriptionRequest o_b16_TheaterDescriptionRequest;
      if (!bDoIt(o_b16_TheaterDescriptionRequest))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case movietimesfi_tclToken::EN_THEATERINFO:
   {
      if (poVisitor->bDoExpand_TheaterInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_AMENITY,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_LISTOFAMENITIES));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_POSITIONWGS84,movietimesfi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_PHONE));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_ZIP));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_CITY));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_ADDRESS));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STATE,movietimesfi_tclSemanticDomain::EN_STATE));
      }
      else
      {
         fi_tcl_TheaterInfo o_TheaterInfo;
         if (!bDoIt(o_TheaterInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_MOVIEID:
   {
      if (poVisitor->bDoExpand_MovieId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_U8,movietimesfi_tclSemanticDomain::EN_MOVIEID));
      }
      else
      {
         fi_tcl_MovieId o_MovieId;
         if (!bDoIt(o_MovieId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MovieId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MovieId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_RATING:
   {
      if (poVisitor->bDoExpand_Rating(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_RATING));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_SYSTEM));
      }
      else
      {
         fi_tcl_Rating o_Rating;
         if (!bDoIt(o_Rating))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Rating.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Rating.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_RUNTIME:
   {
      if (poVisitor->bDoExpand_RunTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_U8,movietimesfi_tclSemanticDomain::EN_RUNTIME));
      }
      else
      {
         fi_tcl_RunTime o_RunTime;
         if (!bDoIt(o_RunTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RunTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RunTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_MOVIENAME:
   {
      if (poVisitor->bDoExpand_MovieName(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_MovieName o_MovieName;
         if (!bDoIt(o_MovieName))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MovieName.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MovieName.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_MOVIEDESCRIPTION:
   {
      if (poVisitor->bDoExpand_MovieDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_SYNOPSIS));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_U32,movietimesfi_tclSemanticDomain::EN_SIZEOFCOMPLETESYNOPSIS));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_ACTORS));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_U32,movietimesfi_tclSemanticDomain::EN_SIZEOFCOMPLETEACTORLIST));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_RUNTIME,movietimesfi_tclSemanticDomain::EN_RUNTIME));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_RATING,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_RATING));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIENAME,movietimesfi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIEID,movietimesfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         fi_tcl_MovieDescription o_MovieDescription;
         if (!bDoIt(o_MovieDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MovieDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MovieDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_THEATERID:
   {
      if (poVisitor->bDoExpand_TheaterId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STATE,movietimesfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_U32,movietimesfi_tclSemanticDomain::EN_THEATERID));
      }
      else
      {
         fi_tcl_TheaterId o_TheaterId;
         if (!bDoIt(o_TheaterId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_SHOWING:
   {
      if (poVisitor->bDoExpand_Showing(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_POSIXTIME,movietimesfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_Showing o_Showing;
         if (!bDoIt(o_Showing))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Showing.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Showing.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_MOVIETIMES:
   {
      if (poVisitor->bDoExpand_MovieTimes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_SHOWING,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_SHOWINGS));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_STRING,movietimesfi_tclSemanticDomain::EN_RATING));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIEID,movietimesfi_tclSemanticDomain::EN_MOVIEID));
      }
      else
      {
         fi_tcl_MovieTimes o_MovieTimes;
         if (!bDoIt(o_MovieTimes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MovieTimes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MovieTimes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_THEATERMOVIETIMES:
   {
      if (poVisitor->bDoExpand_TheaterMovieTimes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIETIMES,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_MOVIETIMES));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERID,movietimesfi_tclSemanticDomain::EN_THEATER));
      }
      else
      {
         fi_tcl_TheaterMovieTimes o_TheaterMovieTimes;
         if (!bDoIt(o_TheaterMovieTimes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterMovieTimes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterMovieTimes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_THEATERMOVIETIMESFORPOSITION:
   {
      if (poVisitor->bDoExpand_TheaterMovieTimesForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERMOVIETIMES,movietimesfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_LIST,movietimesfi_tclSemanticDomain::EN_THEATERMOVIETIMES));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_POSITIONWGS84,movietimesfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_TheaterMovieTimesForPosition o_TheaterMovieTimesForPosition;
         if (!bDoIt(o_TheaterMovieTimesForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterMovieTimesForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterMovieTimesForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_E8_DETAILGRADE:
   {
      fi_tcl_e8_DetailGrade o_e8_DetailGrade;
      if (!bDoIt(o_e8_DetailGrade))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case movietimesfi_tclToken::EN_BRIEFMOVIEDESCRIPTION:
   {
      if (poVisitor->bDoExpand_BriefMovieDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_RUNTIME,movietimesfi_tclSemanticDomain::EN_RUNTIME));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIENAME,movietimesfi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_MOVIEID,movietimesfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         fi_tcl_BriefMovieDescription o_BriefMovieDescription;
         if (!bDoIt(o_BriefMovieDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BriefMovieDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BriefMovieDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case movietimesfi_tclToken::EN_THEATERDESCRIPTION:
   {
      if (poVisitor->bDoExpand_TheaterDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_END_OF_STRUCT,movietimesfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERINFO,movietimesfi_tclSemanticDomain::EN_THEATERDESCRIPTION));
         oPath.bGoDown(movietimesfi_tclKnot(movietimesfi_tclToken::EN_THEATERID,movietimesfi_tclSemanticDomain::EN_THEATER));
      }
      else
      {
         fi_tcl_TheaterDescription o_TheaterDescription;
         if (!bDoIt(o_TheaterDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TheaterDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case movietimesfi_tclToken::EN_UNKNOWN:
      case movietimesfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

