/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MAPCTRLFITYPES_HEADER
#define MAPCTRLFITYPES_HEADER

// #include <vector>
// 


class mapctrlfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class mapctrlfi_tclMsgInitMapScreenMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgInitMapScreenMethodStart():LowerLeft(),UpperRight(),PixelWidth(0),PixelHeight(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgInitMapScreenMethodStart& operator=(const mapctrlfi_tclMsgInitMapScreenMethodStart& coRef);
   mapctrlfi_tclMsgInitMapScreenMethodStart(const mapctrlfi_tclMsgInitMapScreenMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen LowerLeft;
   fi_tcl_PositionScreen UpperRight;
   tU8 PixelWidth;
   tU8 PixelHeight;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgInitMapScreenMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_INITMAPSCREENMETHODSTART;}
};

class mapctrlfi_tclMsgInitMapScreenMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgInitMapScreenMethodResult():LowerLeft(),UpperRight(),PixelWidth(0),PixelHeight(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgInitMapScreenMethodResult& operator=(const mapctrlfi_tclMsgInitMapScreenMethodResult& coRef);
   mapctrlfi_tclMsgInitMapScreenMethodResult(const mapctrlfi_tclMsgInitMapScreenMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen LowerLeft;
   fi_tcl_PositionScreen UpperRight;
   tU8 PixelWidth;
   tU8 PixelHeight;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgInitMapScreenMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_INITMAPSCREENMETHODRESULT;}
};

class mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart():LowerLeft(),UpperRight(),PixelWidth(0),PixelHeight(0),StartScale() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart& operator=(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart& coRef);
   mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen LowerLeft;
   fi_tcl_PositionScreen UpperRight;
   tU8 PixelWidth;
   tU8 PixelHeight;
   fi_tcl_e8_MapScale StartScale;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_INITMAPSCREENINTERSECTIONZOOMMETHODSTART;}
};

class mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult():LowerLeft(),UpperRight(),PixelWidth(0),PixelHeight(0),StartScale() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult& operator=(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult& coRef);
   mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen LowerLeft;
   fi_tcl_PositionScreen UpperRight;
   tU8 PixelWidth;
   tU8 PixelHeight;
   fi_tcl_e8_MapScale StartScale;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_INITMAPSCREENINTERSECTIONZOOMMETHODRESULT;}
};

class mapctrlfi_tclMsgLabelFilterMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgLabelFilterMethodStart():GlobPref(),Areas(),Channels(),RiverClasses(),Borders(),ParkFacilities(),Freeways(),Streets(),Services(),Services2(),Services3(),POIs1(),POIs2() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgLabelFilterMethodStart& operator=(const mapctrlfi_tclMsgLabelFilterMethodStart& coRef);
   mapctrlfi_tclMsgLabelFilterMethodStart(const mapctrlfi_tclMsgLabelFilterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_GlobalPreferences GlobPref;
   fi_tcl_b8_Areas Areas;
   fi_tcl_b8_Channels Channels;
   fi_tcl_b8_RiverClass RiverClasses;
   fi_tcl_b8_BorderLines Borders;
   fi_tcl_b8_ParkingAreas ParkFacilities;
   fi_tcl_b8_FreewayFacilities Freeways;
   fi_tcl_b32_Streets Streets;
   fi_tcl_b32_ServiceStations Services;
   fi_tcl_b32_ServiceStations2 Services2;
   fi_tcl_b32_ServiceStations3 Services3;
   fi_tcl_b32_POI1 POIs1;
   fi_tcl_b32_POI2 POIs2;
   std::vector<fi_tcl_b32_CityCenters, std::allocator<fi_tcl_b32_CityCenters> > CityCenterPoints;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgLabelFilterMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_LABELFILTERMETHODSTART;}
};

class mapctrlfi_tclMsgLabelFilterMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgLabelFilterMethodResult():FilterAccepted() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgLabelFilterMethodResult& operator=(const mapctrlfi_tclMsgLabelFilterMethodResult& coRef);
   mapctrlfi_tclMsgLabelFilterMethodResult(const mapctrlfi_tclMsgLabelFilterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_FilterAcceptance FilterAccepted;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgLabelFilterMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_LABELFILTERMETHODRESULT;}
};

class mapctrlfi_tclMsgScalebarSizesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgScalebarSizesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgScalebarSizesMethodStart& operator=(const mapctrlfi_tclMsgScalebarSizesMethodStart& coRef);
   mapctrlfi_tclMsgScalebarSizesMethodStart(const mapctrlfi_tclMsgScalebarSizesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU8, std::allocator<tU8> > ScaleBarSizes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgScalebarSizesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SCALEBARSIZESMETHODSTART;}
};

class mapctrlfi_tclMsgScalebarSizesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgScalebarSizesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgScalebarSizesMethodResult& operator=(const mapctrlfi_tclMsgScalebarSizesMethodResult& coRef);
   mapctrlfi_tclMsgScalebarSizesMethodResult(const mapctrlfi_tclMsgScalebarSizesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU8, std::allocator<tU8> > ScaleBarSizes;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgScalebarSizesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SCALEBARSIZESMETHODRESULT;}
};

class mapctrlfi_tclMsgMapDrawMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgMapDrawMethodStart():DrawMode(),MapState(),MapScale(),MapAngle(),MapMode(),IntTime(0),RefPos(),IndexPosition(),CameraDistance(0),ZOffSet(0),MapTiltAngle(0x40),Options(),CmdID(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgMapDrawMethodStart& operator=(const mapctrlfi_tclMsgMapDrawMethodStart& coRef);
   mapctrlfi_tclMsgMapDrawMethodStart(const mapctrlfi_tclMsgMapDrawMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DrawMode DrawMode;
   fi_tcl_e8_MapState MapState;
   fi_tcl_e8_MapScale MapScale;
   fi_tcl_e8_MapAngle MapAngle;
   fi_tcl_e8_MapMode MapMode;
   tU16 IntTime;
   fi_tcl_PositionScreen RefPos;
   fi_tcl_PositionWGS84 IndexPosition;
   tS8 CameraDistance;
   tS8 ZOffSet;
   fi_tcl_u8_DirectionAbsolute MapTiltAngle;
   fi_tcl_b8_DrawOptions Options;
   tU8 CmdID;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgMapDrawMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_MAPDRAWMETHODSTART;}
};

class mapctrlfi_tclMsgMapDrawMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgMapDrawMethodResult():DrawMode(),MapState(),MapScale(),MapAngle(),MapMode(),IntTime(0),RefPos(),IndexPosition(),CameraDistance(0),ZOffSet(0),MapTiltAngle(0x40),Options(),CmdID(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgMapDrawMethodResult& operator=(const mapctrlfi_tclMsgMapDrawMethodResult& coRef);
   mapctrlfi_tclMsgMapDrawMethodResult(const mapctrlfi_tclMsgMapDrawMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DrawMode DrawMode;
   fi_tcl_e8_MapState MapState;
   fi_tcl_e8_MapScale MapScale;
   fi_tcl_e8_MapAngle MapAngle;
   fi_tcl_e8_MapMode MapMode;
   tU16 IntTime;
   fi_tcl_PositionScreen RefPos;
   fi_tcl_PositionWGS84 IndexPosition;
   tS8 CameraDistance;
   tS8 ZOffSet;
   fi_tcl_u8_DirectionAbsolute MapTiltAngle;
   fi_tcl_b8_DrawOptions Options;
   tU8 CmdID;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgMapDrawMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_MAPDRAWMETHODRESULT;}
};

class mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart():MapScale(),MapAngleMode(),MapMode(),RefPos(),MapCenter(),RoadId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart& operator=(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart& coRef);
   mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MapScale MapScale;
   fi_tcl_e8_MapAngle MapAngleMode;
   fi_tcl_e8_MapMode MapMode;
   fi_tcl_PositionScreen RefPos;
   fi_tcl_PositionWGS84 MapCenter;
   fi_tcl_RoadId RoadId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_MAPDRAWINTERSECTIONZOOMMETHODSTART;}
};

class mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult():MapScale(),MapAngleMode(),MapMode(),RefPos(),MapCenter(),MapAngleValue(),MapTransMatrix() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult& operator=(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult& coRef);
   mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MapScale MapScale;
   fi_tcl_e8_MapAngle MapAngleMode;
   fi_tcl_e8_MapMode MapMode;
   fi_tcl_PositionScreen RefPos;
   fi_tcl_PositionWGS84 MapCenter;
   fi_tcl_u16_Direction MapAngleValue;
   fi_tcl_MapTransMatrix MapTransMatrix;
   std::vector<tU8, std::allocator<tU8> > MapByteStream;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_MAPDRAWINTERSECTIONZOOMMETHODRESULT;}
};

class mapctrlfi_tclMsgSetCursorMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgSetCursorMethodStart():ScreenPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgSetCursorMethodStart& operator=(const mapctrlfi_tclMsgSetCursorMethodStart& coRef);
   mapctrlfi_tclMsgSetCursorMethodStart(const mapctrlfi_tclMsgSetCursorMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen ScreenPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgSetCursorMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SETCURSORMETHODSTART;}
};

class mapctrlfi_tclMsgSetCursorMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgSetCursorMethodResult():WGS84Position() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgSetCursorMethodResult& operator=(const mapctrlfi_tclMsgSetCursorMethodResult& coRef);
   mapctrlfi_tclMsgSetCursorMethodResult(const mapctrlfi_tclMsgSetCursorMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 WGS84Position;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgSetCursorMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SETCURSORMETHODRESULT;}
};

class mapctrlfi_tclMsgGetCursorInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgGetCursorInfoMethodStart():CursorPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgGetCursorInfoMethodStart& operator=(const mapctrlfi_tclMsgGetCursorInfoMethodStart& coRef);
   mapctrlfi_tclMsgGetCursorInfoMethodStart(const mapctrlfi_tclMsgGetCursorInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen CursorPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgGetCursorInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_GETCURSORINFOMETHODSTART;}
};

class mapctrlfi_tclMsgGetCursorInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgGetCursorInfoMethodResult():WGS84Position() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgGetCursorInfoMethodResult& operator=(const mapctrlfi_tclMsgGetCursorInfoMethodResult& coRef);
   mapctrlfi_tclMsgGetCursorInfoMethodResult(const mapctrlfi_tclMsgGetCursorInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 WGS84Position;
   std::vector<fi_tcl_IndexInfo, std::allocator<fi_tcl_IndexInfo> > IndexInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgGetCursorInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_GETCURSORINFOMETHODRESULT;}
};

class mapctrlfi_tclMsgUpdateMapSizeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgUpdateMapSizeMethodStart():LowerLeftUpdateBoundary(),UpperRightUpdateBoundary(),LowerLeftUpdateFrame(),UpperRightUpdateFrame() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgUpdateMapSizeMethodStart& operator=(const mapctrlfi_tclMsgUpdateMapSizeMethodStart& coRef);
   mapctrlfi_tclMsgUpdateMapSizeMethodStart(const mapctrlfi_tclMsgUpdateMapSizeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen LowerLeftUpdateBoundary;
   fi_tcl_PositionScreen UpperRightUpdateBoundary;
   fi_tcl_PositionScreen LowerLeftUpdateFrame;
   fi_tcl_PositionScreen UpperRightUpdateFrame;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgUpdateMapSizeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_UPDATEMAPSIZEMETHODSTART;}
};

class mapctrlfi_tclMsgUpdateMapSizeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgUpdateMapSizeMethodResult():LowerLeftBoundary(),UpperRightBoundary(),LowerLeftFrame(),UpperRightFrame() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgUpdateMapSizeMethodResult& operator=(const mapctrlfi_tclMsgUpdateMapSizeMethodResult& coRef);
   mapctrlfi_tclMsgUpdateMapSizeMethodResult(const mapctrlfi_tclMsgUpdateMapSizeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen LowerLeftBoundary;
   fi_tcl_PositionScreen UpperRightBoundary;
   fi_tcl_PositionScreen LowerLeftFrame;
   fi_tcl_PositionScreen UpperRightFrame;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgUpdateMapSizeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_UPDATEMAPSIZEMETHODRESULT;}
};

class mapctrlfi_tclMsgGetScreenInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgGetScreenInfoMethodStart():WGS84Position() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgGetScreenInfoMethodStart& operator=(const mapctrlfi_tclMsgGetScreenInfoMethodStart& coRef);
   mapctrlfi_tclMsgGetScreenInfoMethodStart(const mapctrlfi_tclMsgGetScreenInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 WGS84Position;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgGetScreenInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_GETSCREENINFOMETHODSTART;}
};

class mapctrlfi_tclMsgGetScreenInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgGetScreenInfoMethodResult():ScreenPosition(),LiesInFrame(0),MapSeqNum(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgGetScreenInfoMethodResult& operator=(const mapctrlfi_tclMsgGetScreenInfoMethodResult& coRef);
   mapctrlfi_tclMsgGetScreenInfoMethodResult(const mapctrlfi_tclMsgGetScreenInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionScreen ScreenPosition;
   tBool LiesInFrame;
   tU8 MapSeqNum;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgGetScreenInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_GETSCREENINFOMETHODRESULT;}
};

class mapctrlfi_tclMsgSelectVisibleRoutesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgSelectVisibleRoutesMethodStart():DisplayType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgSelectVisibleRoutesMethodStart& operator=(const mapctrlfi_tclMsgSelectVisibleRoutesMethodStart& coRef);
   mapctrlfi_tclMsgSelectVisibleRoutesMethodStart(const mapctrlfi_tclMsgSelectVisibleRoutesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RouteDescriptor, std::allocator<fi_tcl_RouteDescriptor> > SelectedRoutes;
   fi_tcl_e8_RouteDisplayType DisplayType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgSelectVisibleRoutesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SELECTVISIBLEROUTESMETHODSTART;}
};

class mapctrlfi_tclMsgSelectVisibleRoutesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgSelectVisibleRoutesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgSelectVisibleRoutesMethodResult& operator=(const mapctrlfi_tclMsgSelectVisibleRoutesMethodResult& coRef);
   mapctrlfi_tclMsgSelectVisibleRoutesMethodResult(const mapctrlfi_tclMsgSelectVisibleRoutesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgSelectVisibleRoutesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SELECTVISIBLEROUTESMETHODRESULT;}
};

class mapctrlfi_tclMsgSetMapLanguageMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgSetMapLanguageMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgSetMapLanguageMethodStart& operator=(const mapctrlfi_tclMsgSetMapLanguageMethodStart& coRef);
   mapctrlfi_tclMsgSetMapLanguageMethodStart(const mapctrlfi_tclMsgSetMapLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_LanguageFilter, std::allocator<fi_tcl_LanguageFilter> > LanguageFilterList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgSetMapLanguageMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SETMAPLANGUAGEMETHODSTART;}
};

class mapctrlfi_tclMsgSetMapLanguageMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgSetMapLanguageMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgSetMapLanguageMethodResult& operator=(const mapctrlfi_tclMsgSetMapLanguageMethodResult& coRef);
   mapctrlfi_tclMsgSetMapLanguageMethodResult(const mapctrlfi_tclMsgSetMapLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgSetMapLanguageMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SETMAPLANGUAGEMETHODRESULT;}
};

class mapctrlfi_tclMsgClearUsedTrackMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgClearUsedTrackMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgClearUsedTrackMethodStart& operator=(const mapctrlfi_tclMsgClearUsedTrackMethodStart& coRef);
   mapctrlfi_tclMsgClearUsedTrackMethodStart(const mapctrlfi_tclMsgClearUsedTrackMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgClearUsedTrackMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_CLEARUSEDTRACKMETHODSTART;}
};

class mapctrlfi_tclMsgClearUsedTrackMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgClearUsedTrackMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgClearUsedTrackMethodResult& operator=(const mapctrlfi_tclMsgClearUsedTrackMethodResult& coRef);
   mapctrlfi_tclMsgClearUsedTrackMethodResult(const mapctrlfi_tclMsgClearUsedTrackMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgClearUsedTrackMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_CLEARUSEDTRACKMETHODRESULT;}
};

class mapctrlfi_tclMsgSetDestinationFlagMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgSetDestinationFlagMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgSetDestinationFlagMethodStart& operator=(const mapctrlfi_tclMsgSetDestinationFlagMethodStart& coRef);
   mapctrlfi_tclMsgSetDestinationFlagMethodStart(const mapctrlfi_tclMsgSetDestinationFlagMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DestinationFlag, std::allocator<fi_tcl_DestinationFlag> > Destinations;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgSetDestinationFlagMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SETDESTINATIONFLAGMETHODSTART;}
};

class mapctrlfi_tclMsgSetDestinationFlagMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgSetDestinationFlagMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgSetDestinationFlagMethodResult& operator=(const mapctrlfi_tclMsgSetDestinationFlagMethodResult& coRef);
   mapctrlfi_tclMsgSetDestinationFlagMethodResult(const mapctrlfi_tclMsgSetDestinationFlagMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgSetDestinationFlagMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_SETDESTINATIONFLAGMETHODRESULT;}
};

class mapctrlfi_tclMsgGetZoomLevelConfigMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgGetZoomLevelConfigMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgGetZoomLevelConfigMethodStart& operator=(const mapctrlfi_tclMsgGetZoomLevelConfigMethodStart& coRef);
   mapctrlfi_tclMsgGetZoomLevelConfigMethodStart(const mapctrlfi_tclMsgGetZoomLevelConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgGetZoomLevelConfigMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_GETZOOMLEVELCONFIGMETHODSTART;}
};

class mapctrlfi_tclMsgGetZoomLevelConfigMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgGetZoomLevelConfigMethodResult():MinAutoZoomLevel(0),MaxAutoZoomLevel(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgGetZoomLevelConfigMethodResult& operator=(const mapctrlfi_tclMsgGetZoomLevelConfigMethodResult& coRef);
   mapctrlfi_tclMsgGetZoomLevelConfigMethodResult(const mapctrlfi_tclMsgGetZoomLevelConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ZoomLevelConfig, std::allocator<fi_tcl_ZoomLevelConfig> > ZoomLevelConfig;
   tU8 MinAutoZoomLevel;
   tU8 MaxAutoZoomLevel;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgGetZoomLevelConfigMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_GETZOOMLEVELCONFIGMETHODRESULT;}
};

class mapctrlfi_tclMsgMapDirectionGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgMapDirectionGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgMapDirectionGet& operator=(const mapctrlfi_tclMsgMapDirectionGet& coRef);
   mapctrlfi_tclMsgMapDirectionGet(const mapctrlfi_tclMsgMapDirectionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgMapDirectionGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_MAPDIRECTIONGET;}
};

class mapctrlfi_tclMsgMapDirectionStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgMapDirectionStatus():DirStatus(),NorthDirection(),DestDirection(),MapSeqNum(0),CmdID(0),Scale(),ScaleBarSize(0),ZoomLevel(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgMapDirectionStatus& operator=(const mapctrlfi_tclMsgMapDirectionStatus& coRef);
   mapctrlfi_tclMsgMapDirectionStatus(const mapctrlfi_tclMsgMapDirectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_DirInfoStatus DirStatus;
   fi_tcl_u8_DirectionRelative NorthDirection;
   fi_tcl_u8_DirectionRelative DestDirection;
   tU8 MapSeqNum;
   tU8 CmdID;
   fi_tcl_e8_MapScale Scale;
   tU8 ScaleBarSize;
   tU8 ZoomLevel;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgMapDirectionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_MAPDIRECTIONSTATUS;}
};

class mapctrlfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgEngineeringTextGet& operator=(const mapctrlfi_tclMsgEngineeringTextGet& coRef);
   mapctrlfi_tclMsgEngineeringTextGet(const mapctrlfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class mapctrlfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgEngineeringTextUpReg& operator=(const mapctrlfi_tclMsgEngineeringTextUpReg& coRef);
   mapctrlfi_tclMsgEngineeringTextUpReg(const mapctrlfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class mapctrlfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgEngineeringTextRelUpReg& operator=(const mapctrlfi_tclMsgEngineeringTextRelUpReg& coRef);
   mapctrlfi_tclMsgEngineeringTextRelUpReg(const mapctrlfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class mapctrlfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgEngineeringTextStatus& operator=(const mapctrlfi_tclMsgEngineeringTextStatus& coRef);
   mapctrlfi_tclMsgEngineeringTextStatus(const mapctrlfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};

class mapctrlfi_tclMsgUsedDatasetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgUsedDatasetGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgUsedDatasetGet& operator=(const mapctrlfi_tclMsgUsedDatasetGet& coRef);
   mapctrlfi_tclMsgUsedDatasetGet(const mapctrlfi_tclMsgUsedDatasetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgUsedDatasetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_USEDDATASETGET;}
};

class mapctrlfi_tclMsgUsedDatasetUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgUsedDatasetUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgUsedDatasetUpReg& operator=(const mapctrlfi_tclMsgUsedDatasetUpReg& coRef);
   mapctrlfi_tclMsgUsedDatasetUpReg(const mapctrlfi_tclMsgUsedDatasetUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgUsedDatasetUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_USEDDATASETUPREG;}
};

class mapctrlfi_tclMsgUsedDatasetRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgUsedDatasetRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgUsedDatasetRelUpReg& operator=(const mapctrlfi_tclMsgUsedDatasetRelUpReg& coRef);
   mapctrlfi_tclMsgUsedDatasetRelUpReg(const mapctrlfi_tclMsgUsedDatasetRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgUsedDatasetRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_USEDDATASETRELUPREG;}
};

class mapctrlfi_tclMsgUsedDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   mapctrlfi_tclMsgUsedDatasetStatus():MediaId(),DataSetId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mapctrlfi_tclMsgUsedDatasetStatus& operator=(const mapctrlfi_tclMsgUsedDatasetStatus& coRef);
   mapctrlfi_tclMsgUsedDatasetStatus(const mapctrlfi_tclMsgUsedDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_MediaId MediaId;
   fi_tcl_u32_DataSetId DataSetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const mapctrlfi_tclMsgUsedDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return mapctrlfi_tclToken::EN_MSG_USEDDATASETSTATUS;}
};


#endif
