/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgInitMapScreenMethodStart::mapctrlfi_tclMsgInitMapScreenMethodStart(const mapctrlfi_tclMsgInitMapScreenMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LowerLeft = coRef.LowerLeft;
   UpperRight = coRef.UpperRight;
   PixelWidth = coRef.PixelWidth;
   PixelHeight = coRef.PixelHeight;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgInitMapScreenMethodStart& mapctrlfi_tclMsgInitMapScreenMethodStart::operator=(const mapctrlfi_tclMsgInitMapScreenMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LowerLeft = coRef.LowerLeft;
   UpperRight = coRef.UpperRight;
   PixelWidth = coRef.PixelWidth;
   PixelHeight = coRef.PixelHeight;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgInitMapScreenMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgInitMapScreenMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_INITMAPSCREEN;}
tU8 mapctrlfi_tclMsgInitMapScreenMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgInitMapScreenMethodStart::vDestroy()
{
   LowerLeft.vDestroy(); 
   UpperRight.vDestroy(); 
}

tU32 mapctrlfi_tclMsgInitMapScreenMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool mapctrlfi_tclMsgInitMapScreenMethodStart::operator==(const mapctrlfi_tclMsgInitMapScreenMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LowerLeft == rfoCmp.LowerLeft);
      bResult = bResult && (UpperRight == rfoCmp.UpperRight);
      bResult = bResult && (PixelWidth == rfoCmp.PixelWidth);
      bResult = bResult && (PixelHeight == rfoCmp.PixelHeight);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgInitMapScreenMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LowerLeft;
   oIn >> UpperRight;
   oIn >> PixelWidth;
   oIn >> PixelHeight;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgInitMapScreenMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LowerLeft;
   oOut << UpperRight;
   oOut << PixelWidth;
   oOut << PixelHeight;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgInitMapScreenMethodResult::mapctrlfi_tclMsgInitMapScreenMethodResult(const mapctrlfi_tclMsgInitMapScreenMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   LowerLeft = coRef.LowerLeft;
   UpperRight = coRef.UpperRight;
   PixelWidth = coRef.PixelWidth;
   PixelHeight = coRef.PixelHeight;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgInitMapScreenMethodResult& mapctrlfi_tclMsgInitMapScreenMethodResult::operator=(const mapctrlfi_tclMsgInitMapScreenMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LowerLeft = coRef.LowerLeft;
   UpperRight = coRef.UpperRight;
   PixelWidth = coRef.PixelWidth;
   PixelHeight = coRef.PixelHeight;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgInitMapScreenMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgInitMapScreenMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_INITMAPSCREEN;}
tU8 mapctrlfi_tclMsgInitMapScreenMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgInitMapScreenMethodResult::vDestroy()
{
   LowerLeft.vDestroy(); 
   UpperRight.vDestroy(); 
}

tU32 mapctrlfi_tclMsgInitMapScreenMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool mapctrlfi_tclMsgInitMapScreenMethodResult::operator==(const mapctrlfi_tclMsgInitMapScreenMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LowerLeft == rfoCmp.LowerLeft);
      bResult = bResult && (UpperRight == rfoCmp.UpperRight);
      bResult = bResult && (PixelWidth == rfoCmp.PixelWidth);
      bResult = bResult && (PixelHeight == rfoCmp.PixelHeight);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgInitMapScreenMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> LowerLeft;
   oIn >> UpperRight;
   oIn >> PixelWidth;
   oIn >> PixelHeight;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgInitMapScreenMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LowerLeft;
   oOut << UpperRight;
   oOut << PixelWidth;
   oOut << PixelHeight;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LowerLeft = coRef.LowerLeft;
   UpperRight = coRef.UpperRight;
   PixelWidth = coRef.PixelWidth;
   PixelHeight = coRef.PixelHeight;
   StartScale = coRef.StartScale;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart& mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::operator=(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LowerLeft = coRef.LowerLeft;
   UpperRight = coRef.UpperRight;
   PixelWidth = coRef.PixelWidth;
   PixelHeight = coRef.PixelHeight;
   StartScale = coRef.StartScale;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_INITMAPSCREENINTERSECTIONZOOM;}
tU8 mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::vDestroy()
{
   LowerLeft.vDestroy(); 
   UpperRight.vDestroy(); 
}

tU32 mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::operator==(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LowerLeft == rfoCmp.LowerLeft);
      bResult = bResult && (UpperRight == rfoCmp.UpperRight);
      bResult = bResult && (PixelWidth == rfoCmp.PixelWidth);
      bResult = bResult && (PixelHeight == rfoCmp.PixelHeight);
      bResult = bResult && (StartScale == rfoCmp.StartScale);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LowerLeft;
   oIn >> UpperRight;
   oIn >> PixelWidth;
   oIn >> PixelHeight;
   oIn >> StartScale;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LowerLeft;
   oOut << UpperRight;
   oOut << PixelWidth;
   oOut << PixelHeight;
   oOut << StartScale;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   LowerLeft = coRef.LowerLeft;
   UpperRight = coRef.UpperRight;
   PixelWidth = coRef.PixelWidth;
   PixelHeight = coRef.PixelHeight;
   StartScale = coRef.StartScale;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult& mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::operator=(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LowerLeft = coRef.LowerLeft;
   UpperRight = coRef.UpperRight;
   PixelWidth = coRef.PixelWidth;
   PixelHeight = coRef.PixelHeight;
   StartScale = coRef.StartScale;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_INITMAPSCREENINTERSECTIONZOOM;}
tU8 mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::vDestroy()
{
   LowerLeft.vDestroy(); 
   UpperRight.vDestroy(); 
}

tU32 mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::operator==(const mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LowerLeft == rfoCmp.LowerLeft);
      bResult = bResult && (UpperRight == rfoCmp.UpperRight);
      bResult = bResult && (PixelWidth == rfoCmp.PixelWidth);
      bResult = bResult && (PixelHeight == rfoCmp.PixelHeight);
      bResult = bResult && (StartScale == rfoCmp.StartScale);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> LowerLeft;
   oIn >> UpperRight;
   oIn >> PixelWidth;
   oIn >> PixelHeight;
   oIn >> StartScale;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgInitMapScreenIntersectionZoomMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LowerLeft;
   oOut << UpperRight;
   oOut << PixelWidth;
   oOut << PixelHeight;
   oOut << StartScale;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgLabelFilterMethodStart::mapctrlfi_tclMsgLabelFilterMethodStart(const mapctrlfi_tclMsgLabelFilterMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   GlobPref = coRef.GlobPref;
   Areas = coRef.Areas;
   Channels = coRef.Channels;
   RiverClasses = coRef.RiverClasses;
   Borders = coRef.Borders;
   ParkFacilities = coRef.ParkFacilities;
   Freeways = coRef.Freeways;
   Streets = coRef.Streets;
   Services = coRef.Services;
   Services2 = coRef.Services2;
   Services3 = coRef.Services3;
   POIs1 = coRef.POIs1;
   POIs2 = coRef.POIs2;
   CityCenterPoints = coRef.CityCenterPoints;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgLabelFilterMethodStart& mapctrlfi_tclMsgLabelFilterMethodStart::operator=(const mapctrlfi_tclMsgLabelFilterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   GlobPref = coRef.GlobPref;
   Areas = coRef.Areas;
   Channels = coRef.Channels;
   RiverClasses = coRef.RiverClasses;
   Borders = coRef.Borders;
   ParkFacilities = coRef.ParkFacilities;
   Freeways = coRef.Freeways;
   Streets = coRef.Streets;
   Services = coRef.Services;
   Services2 = coRef.Services2;
   Services3 = coRef.Services3;
   POIs1 = coRef.POIs1;
   POIs2 = coRef.POIs2;
   CityCenterPoints = coRef.CityCenterPoints;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgLabelFilterMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgLabelFilterMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_LABELFILTER;}
tU8 mapctrlfi_tclMsgLabelFilterMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgLabelFilterMethodStart::vDestroy()
{
   CityCenterPoints.clear();
}

tU32 mapctrlfi_tclMsgLabelFilterMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (6 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (6 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+28+CityCenterPoints.size()*4;
}

tBool mapctrlfi_tclMsgLabelFilterMethodStart::operator==(const mapctrlfi_tclMsgLabelFilterMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (GlobPref == rfoCmp.GlobPref);
      bResult = bResult && (Areas == rfoCmp.Areas);
      bResult = bResult && (Channels == rfoCmp.Channels);
      bResult = bResult && (RiverClasses == rfoCmp.RiverClasses);
      bResult = bResult && (Borders == rfoCmp.Borders);
      bResult = bResult && (ParkFacilities == rfoCmp.ParkFacilities);
      bResult = bResult && (Freeways == rfoCmp.Freeways);
      bResult = bResult && (Streets == rfoCmp.Streets);
      bResult = bResult && (Services == rfoCmp.Services);
      bResult = bResult && (Services2 == rfoCmp.Services2);
      bResult = bResult && (Services3 == rfoCmp.Services3);
      bResult = bResult && (POIs1 == rfoCmp.POIs1);
      bResult = bResult && (POIs2 == rfoCmp.POIs2);
      bResult = bResult && (CityCenterPoints.size() == rfoCmp.CityCenterPoints.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CityCenterPoints.size()); ++u32Idx)
            bResult = bResult && (CityCenterPoints[u32Idx] == rfoCmp.CityCenterPoints[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgLabelFilterMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> GlobPref;
   oIn >> Areas;
   oIn >> Channels;
   oIn >> RiverClasses;
   oIn >> Borders;
   oIn >> ParkFacilities;
   oIn >> Freeways;
   oIn >> Streets;
   oIn >> Services;
   if (6 <= oIn.u16GetMajorVersion())
   {
      oIn >> Services2;
   }
   if (6 <= oIn.u16GetMajorVersion())
   {
      oIn >> Services3;
   }
   oIn >> POIs1;
   oIn >> POIs2;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CityCenterPoints.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CityCenterPoints[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgLabelFilterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << GlobPref;
   oOut << Areas;
   oOut << Channels;
   oOut << RiverClasses;
   oOut << Borders;
   oOut << ParkFacilities;
   oOut << Freeways;
   oOut << Streets;
   oOut << Services;
   if (6 <= oOut.u16GetMajorVersion())
   {
      oOut << Services2;
   }
   if (6 <= oOut.u16GetMajorVersion())
   {
      oOut << Services3;
   }
   oOut << POIs1;
   oOut << POIs2;
   oOut << (tU32)CityCenterPoints.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CityCenterPoints.size(); ++u32Idx)
         oOut << CityCenterPoints[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgLabelFilterMethodResult::mapctrlfi_tclMsgLabelFilterMethodResult(const mapctrlfi_tclMsgLabelFilterMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FilterAccepted = coRef.FilterAccepted;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgLabelFilterMethodResult& mapctrlfi_tclMsgLabelFilterMethodResult::operator=(const mapctrlfi_tclMsgLabelFilterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FilterAccepted = coRef.FilterAccepted;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgLabelFilterMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgLabelFilterMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_LABELFILTER;}
tU8 mapctrlfi_tclMsgLabelFilterMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 mapctrlfi_tclMsgLabelFilterMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool mapctrlfi_tclMsgLabelFilterMethodResult::operator==(const mapctrlfi_tclMsgLabelFilterMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FilterAccepted == rfoCmp.FilterAccepted);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgLabelFilterMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> FilterAccepted;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgLabelFilterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FilterAccepted;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgScalebarSizesMethodStart::mapctrlfi_tclMsgScalebarSizesMethodStart(const mapctrlfi_tclMsgScalebarSizesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ScaleBarSizes = coRef.ScaleBarSizes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgScalebarSizesMethodStart& mapctrlfi_tclMsgScalebarSizesMethodStart::operator=(const mapctrlfi_tclMsgScalebarSizesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ScaleBarSizes = coRef.ScaleBarSizes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgScalebarSizesMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgScalebarSizesMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SCALEBARSIZES;}
tU8 mapctrlfi_tclMsgScalebarSizesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgScalebarSizesMethodStart::vDestroy()
{
   ScaleBarSizes.clear();
}

tU32 mapctrlfi_tclMsgScalebarSizesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ScaleBarSizes.size()*1;
}

tBool mapctrlfi_tclMsgScalebarSizesMethodStart::operator==(const mapctrlfi_tclMsgScalebarSizesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ScaleBarSizes.size() == rfoCmp.ScaleBarSizes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ScaleBarSizes.size()); ++u32Idx)
            bResult = bResult && (ScaleBarSizes[u32Idx] == rfoCmp.ScaleBarSizes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgScalebarSizesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ScaleBarSizes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ScaleBarSizes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgScalebarSizesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ScaleBarSizes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ScaleBarSizes.size(); ++u32Idx)
         oOut << ScaleBarSizes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgScalebarSizesMethodResult::mapctrlfi_tclMsgScalebarSizesMethodResult(const mapctrlfi_tclMsgScalebarSizesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ScaleBarSizes = coRef.ScaleBarSizes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgScalebarSizesMethodResult& mapctrlfi_tclMsgScalebarSizesMethodResult::operator=(const mapctrlfi_tclMsgScalebarSizesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ScaleBarSizes = coRef.ScaleBarSizes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgScalebarSizesMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgScalebarSizesMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SCALEBARSIZES;}
tU8 mapctrlfi_tclMsgScalebarSizesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgScalebarSizesMethodResult::vDestroy()
{
   ScaleBarSizes.clear();
}

tU32 mapctrlfi_tclMsgScalebarSizesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ScaleBarSizes.size()*1;
}

tBool mapctrlfi_tclMsgScalebarSizesMethodResult::operator==(const mapctrlfi_tclMsgScalebarSizesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ScaleBarSizes.size() == rfoCmp.ScaleBarSizes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ScaleBarSizes.size()); ++u32Idx)
            bResult = bResult && (ScaleBarSizes[u32Idx] == rfoCmp.ScaleBarSizes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgScalebarSizesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ScaleBarSizes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ScaleBarSizes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgScalebarSizesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ScaleBarSizes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ScaleBarSizes.size(); ++u32Idx)
         oOut << ScaleBarSizes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDrawMethodStart::mapctrlfi_tclMsgMapDrawMethodStart(const mapctrlfi_tclMsgMapDrawMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   DrawMode = coRef.DrawMode;
   MapState = coRef.MapState;
   MapScale = coRef.MapScale;
   MapAngle = coRef.MapAngle;
   MapMode = coRef.MapMode;
   IntTime = coRef.IntTime;
   RefPos = coRef.RefPos;
   IndexPosition = coRef.IndexPosition;
   CameraDistance = coRef.CameraDistance;
   ZOffSet = coRef.ZOffSet;
   MapTiltAngle = coRef.MapTiltAngle;
   Options = coRef.Options;
   CmdID = coRef.CmdID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDrawMethodStart& mapctrlfi_tclMsgMapDrawMethodStart::operator=(const mapctrlfi_tclMsgMapDrawMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DrawMode = coRef.DrawMode;
   MapState = coRef.MapState;
   MapScale = coRef.MapScale;
   MapAngle = coRef.MapAngle;
   MapMode = coRef.MapMode;
   IntTime = coRef.IntTime;
   RefPos = coRef.RefPos;
   IndexPosition = coRef.IndexPosition;
   CameraDistance = coRef.CameraDistance;
   ZOffSet = coRef.ZOffSet;
   MapTiltAngle = coRef.MapTiltAngle;
   Options = coRef.Options;
   CmdID = coRef.CmdID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgMapDrawMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgMapDrawMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_MAPDRAW;}
tU8 mapctrlfi_tclMsgMapDrawMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgMapDrawMethodStart::vDestroy()
{
   RefPos.vDestroy(); 
   IndexPosition.vDestroy(); 
}

tU32 mapctrlfi_tclMsgMapDrawMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 2;
   }
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 1;
   }
   if (5 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+18;
}

tBool mapctrlfi_tclMsgMapDrawMethodStart::operator==(const mapctrlfi_tclMsgMapDrawMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DrawMode == rfoCmp.DrawMode);
      bResult = bResult && (MapState == rfoCmp.MapState);
      bResult = bResult && (MapScale == rfoCmp.MapScale);
      bResult = bResult && (MapAngle == rfoCmp.MapAngle);
      bResult = bResult && (MapMode == rfoCmp.MapMode);
      bResult = bResult && (IntTime == rfoCmp.IntTime);
      bResult = bResult && (RefPos == rfoCmp.RefPos);
      bResult = bResult && (IndexPosition == rfoCmp.IndexPosition);
      bResult = bResult && (CameraDistance == rfoCmp.CameraDistance);
      bResult = bResult && (ZOffSet == rfoCmp.ZOffSet);
      bResult = bResult && (MapTiltAngle == rfoCmp.MapTiltAngle);
      bResult = bResult && (Options == rfoCmp.Options);
      bResult = bResult && (CmdID == rfoCmp.CmdID);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgMapDrawMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> DrawMode;
   oIn >> MapState;
   oIn >> MapScale;
   oIn >> MapAngle;
   oIn >> MapMode;
   if (oIn.u16GetMajorVersion() <= 4)
   {
      oIn >> IntTime;
   }
   oIn >> RefPos;
   oIn >> IndexPosition;
   if (oIn.u16GetMajorVersion() <= 4)
   {
      oIn >> CameraDistance;
   }
   if (oIn.u16GetMajorVersion() <= 4)
   {
      oIn >> ZOffSet;
   }
   if (oIn.u16GetMajorVersion() <= 4)
   {
      oIn >> MapTiltAngle;
   }
   oIn >> Options;
   if (5 <= oIn.u16GetMajorVersion())
   {
      oIn >> CmdID;
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgMapDrawMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DrawMode;
   oOut << MapState;
   oOut << MapScale;
   oOut << MapAngle;
   oOut << MapMode;
   if (oOut.u16GetMajorVersion() <= 4)
   {
      oOut << IntTime;
   }
   oOut << RefPos;
   oOut << IndexPosition;
   if (oOut.u16GetMajorVersion() <= 4)
   {
      oOut << CameraDistance;
   }
   if (oOut.u16GetMajorVersion() <= 4)
   {
      oOut << ZOffSet;
   }
   if (oOut.u16GetMajorVersion() <= 4)
   {
      oOut << MapTiltAngle;
   }
   oOut << Options;
   if (5 <= oOut.u16GetMajorVersion())
   {
      oOut << CmdID;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDrawMethodResult::mapctrlfi_tclMsgMapDrawMethodResult(const mapctrlfi_tclMsgMapDrawMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   DrawMode = coRef.DrawMode;
   MapState = coRef.MapState;
   MapScale = coRef.MapScale;
   MapAngle = coRef.MapAngle;
   MapMode = coRef.MapMode;
   IntTime = coRef.IntTime;
   RefPos = coRef.RefPos;
   IndexPosition = coRef.IndexPosition;
   CameraDistance = coRef.CameraDistance;
   ZOffSet = coRef.ZOffSet;
   MapTiltAngle = coRef.MapTiltAngle;
   Options = coRef.Options;
   CmdID = coRef.CmdID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDrawMethodResult& mapctrlfi_tclMsgMapDrawMethodResult::operator=(const mapctrlfi_tclMsgMapDrawMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DrawMode = coRef.DrawMode;
   MapState = coRef.MapState;
   MapScale = coRef.MapScale;
   MapAngle = coRef.MapAngle;
   MapMode = coRef.MapMode;
   IntTime = coRef.IntTime;
   RefPos = coRef.RefPos;
   IndexPosition = coRef.IndexPosition;
   CameraDistance = coRef.CameraDistance;
   ZOffSet = coRef.ZOffSet;
   MapTiltAngle = coRef.MapTiltAngle;
   Options = coRef.Options;
   CmdID = coRef.CmdID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgMapDrawMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgMapDrawMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_MAPDRAW;}
tU8 mapctrlfi_tclMsgMapDrawMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgMapDrawMethodResult::vDestroy()
{
   RefPos.vDestroy(); 
   IndexPosition.vDestroy(); 
}

tU32 mapctrlfi_tclMsgMapDrawMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 2;
   }
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 1;
   }
   if (5 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+18;
}

tBool mapctrlfi_tclMsgMapDrawMethodResult::operator==(const mapctrlfi_tclMsgMapDrawMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DrawMode == rfoCmp.DrawMode);
      bResult = bResult && (MapState == rfoCmp.MapState);
      bResult = bResult && (MapScale == rfoCmp.MapScale);
      bResult = bResult && (MapAngle == rfoCmp.MapAngle);
      bResult = bResult && (MapMode == rfoCmp.MapMode);
      bResult = bResult && (IntTime == rfoCmp.IntTime);
      bResult = bResult && (RefPos == rfoCmp.RefPos);
      bResult = bResult && (IndexPosition == rfoCmp.IndexPosition);
      bResult = bResult && (CameraDistance == rfoCmp.CameraDistance);
      bResult = bResult && (ZOffSet == rfoCmp.ZOffSet);
      bResult = bResult && (MapTiltAngle == rfoCmp.MapTiltAngle);
      bResult = bResult && (Options == rfoCmp.Options);
      bResult = bResult && (CmdID == rfoCmp.CmdID);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgMapDrawMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> DrawMode;
   oIn >> MapState;
   oIn >> MapScale;
   oIn >> MapAngle;
   oIn >> MapMode;
   if (oIn.u16GetMajorVersion() <= 4)
   {
      oIn >> IntTime;
   }
   oIn >> RefPos;
   oIn >> IndexPosition;
   if (oIn.u16GetMajorVersion() <= 4)
   {
      oIn >> CameraDistance;
   }
   if (oIn.u16GetMajorVersion() <= 4)
   {
      oIn >> ZOffSet;
   }
   if (oIn.u16GetMajorVersion() <= 4)
   {
      oIn >> MapTiltAngle;
   }
   oIn >> Options;
   if (5 <= oIn.u16GetMajorVersion())
   {
      oIn >> CmdID;
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgMapDrawMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DrawMode;
   oOut << MapState;
   oOut << MapScale;
   oOut << MapAngle;
   oOut << MapMode;
   if (oOut.u16GetMajorVersion() <= 4)
   {
      oOut << IntTime;
   }
   oOut << RefPos;
   oOut << IndexPosition;
   if (oOut.u16GetMajorVersion() <= 4)
   {
      oOut << CameraDistance;
   }
   if (oOut.u16GetMajorVersion() <= 4)
   {
      oOut << ZOffSet;
   }
   if (oOut.u16GetMajorVersion() <= 4)
   {
      oOut << MapTiltAngle;
   }
   oOut << Options;
   if (5 <= oOut.u16GetMajorVersion())
   {
      oOut << CmdID;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MapScale = coRef.MapScale;
   MapAngleMode = coRef.MapAngleMode;
   MapMode = coRef.MapMode;
   RefPos = coRef.RefPos;
   MapCenter = coRef.MapCenter;
   RoadId = coRef.RoadId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart& mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::operator=(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MapScale = coRef.MapScale;
   MapAngleMode = coRef.MapAngleMode;
   MapMode = coRef.MapMode;
   RefPos = coRef.RefPos;
   MapCenter = coRef.MapCenter;
   RoadId = coRef.RoadId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_MAPDRAWINTERSECTIONZOOM;}
tU8 mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::vDestroy()
{
   RefPos.vDestroy(); 
   MapCenter.vDestroy(); 
   RoadId.vDestroy(); 
}

tU32 mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 29;
}

tBool mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::operator==(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MapScale == rfoCmp.MapScale);
      bResult = bResult && (MapAngleMode == rfoCmp.MapAngleMode);
      bResult = bResult && (MapMode == rfoCmp.MapMode);
      bResult = bResult && (RefPos == rfoCmp.RefPos);
      bResult = bResult && (MapCenter == rfoCmp.MapCenter);
      bResult = bResult && (RoadId == rfoCmp.RoadId);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MapScale;
   oIn >> MapAngleMode;
   oIn >> MapMode;
   oIn >> RefPos;
   oIn >> MapCenter;
   oIn >> RoadId;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgMapDrawIntersectionZoomMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MapScale;
   oOut << MapAngleMode;
   oOut << MapMode;
   oOut << RefPos;
   oOut << MapCenter;
   oOut << RoadId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MapScale = coRef.MapScale;
   MapAngleMode = coRef.MapAngleMode;
   MapMode = coRef.MapMode;
   RefPos = coRef.RefPos;
   MapCenter = coRef.MapCenter;
   MapAngleValue = coRef.MapAngleValue;
   MapTransMatrix = coRef.MapTransMatrix;
   MapByteStream = coRef.MapByteStream;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult& mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::operator=(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MapScale = coRef.MapScale;
   MapAngleMode = coRef.MapAngleMode;
   MapMode = coRef.MapMode;
   RefPos = coRef.RefPos;
   MapCenter = coRef.MapCenter;
   MapAngleValue = coRef.MapAngleValue;
   MapTransMatrix = coRef.MapTransMatrix;
   MapByteStream = coRef.MapByteStream;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_MAPDRAWINTERSECTIONZOOM;}
tU8 mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::vDestroy()
{
   RefPos.vDestroy(); 
   MapCenter.vDestroy(); 
   MapTransMatrix.vDestroy(); 
   MapByteStream.clear();
}

tU32 mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 37+MapByteStream.size()*1;
}

tBool mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::operator==(const mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MapScale == rfoCmp.MapScale);
      bResult = bResult && (MapAngleMode == rfoCmp.MapAngleMode);
      bResult = bResult && (MapMode == rfoCmp.MapMode);
      bResult = bResult && (RefPos == rfoCmp.RefPos);
      bResult = bResult && (MapCenter == rfoCmp.MapCenter);
      bResult = bResult && (MapAngleValue == rfoCmp.MapAngleValue);
      bResult = bResult && (MapTransMatrix == rfoCmp.MapTransMatrix);
      bResult = bResult && (MapByteStream.size() == rfoCmp.MapByteStream.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MapByteStream.size()); ++u32Idx)
            bResult = bResult && (MapByteStream[u32Idx] == rfoCmp.MapByteStream[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MapScale;
   oIn >> MapAngleMode;
   oIn >> MapMode;
   oIn >> RefPos;
   oIn >> MapCenter;
   oIn >> MapAngleValue;
   oIn >> MapTransMatrix;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      MapByteStream.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MapByteStream[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgMapDrawIntersectionZoomMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MapScale;
   oOut << MapAngleMode;
   oOut << MapMode;
   oOut << RefPos;
   oOut << MapCenter;
   oOut << MapAngleValue;
   oOut << MapTransMatrix;
   oOut << (tU32)MapByteStream.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MapByteStream.size(); ++u32Idx)
         oOut << MapByteStream[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetCursorMethodStart::mapctrlfi_tclMsgSetCursorMethodStart(const mapctrlfi_tclMsgSetCursorMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ScreenPosition = coRef.ScreenPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetCursorMethodStart& mapctrlfi_tclMsgSetCursorMethodStart::operator=(const mapctrlfi_tclMsgSetCursorMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ScreenPosition = coRef.ScreenPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgSetCursorMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgSetCursorMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SETCURSOR;}
tU8 mapctrlfi_tclMsgSetCursorMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgSetCursorMethodStart::vDestroy()
{
   ScreenPosition.vDestroy(); 
}

tU32 mapctrlfi_tclMsgSetCursorMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool mapctrlfi_tclMsgSetCursorMethodStart::operator==(const mapctrlfi_tclMsgSetCursorMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ScreenPosition == rfoCmp.ScreenPosition);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgSetCursorMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ScreenPosition;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgSetCursorMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ScreenPosition;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetCursorMethodResult::mapctrlfi_tclMsgSetCursorMethodResult(const mapctrlfi_tclMsgSetCursorMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   WGS84Position = coRef.WGS84Position;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetCursorMethodResult& mapctrlfi_tclMsgSetCursorMethodResult::operator=(const mapctrlfi_tclMsgSetCursorMethodResult& coRef)
{
   if (this == &coRef) return *this;
   WGS84Position = coRef.WGS84Position;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgSetCursorMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgSetCursorMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SETCURSOR;}
tU8 mapctrlfi_tclMsgSetCursorMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgSetCursorMethodResult::vDestroy()
{
   WGS84Position.vDestroy(); 
}

tU32 mapctrlfi_tclMsgSetCursorMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool mapctrlfi_tclMsgSetCursorMethodResult::operator==(const mapctrlfi_tclMsgSetCursorMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WGS84Position == rfoCmp.WGS84Position);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgSetCursorMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> WGS84Position;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgSetCursorMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WGS84Position;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetCursorInfoMethodStart::mapctrlfi_tclMsgGetCursorInfoMethodStart(const mapctrlfi_tclMsgGetCursorInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   CursorPosition = coRef.CursorPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetCursorInfoMethodStart& mapctrlfi_tclMsgGetCursorInfoMethodStart::operator=(const mapctrlfi_tclMsgGetCursorInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CursorPosition = coRef.CursorPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgGetCursorInfoMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgGetCursorInfoMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_GETCURSORINFO;}
tU8 mapctrlfi_tclMsgGetCursorInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgGetCursorInfoMethodStart::vDestroy()
{
   CursorPosition.vDestroy(); 
}

tU32 mapctrlfi_tclMsgGetCursorInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool mapctrlfi_tclMsgGetCursorInfoMethodStart::operator==(const mapctrlfi_tclMsgGetCursorInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CursorPosition == rfoCmp.CursorPosition);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgGetCursorInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> CursorPosition;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgGetCursorInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CursorPosition;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetCursorInfoMethodResult::mapctrlfi_tclMsgGetCursorInfoMethodResult(const mapctrlfi_tclMsgGetCursorInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   WGS84Position = coRef.WGS84Position;
   IndexInfo = coRef.IndexInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetCursorInfoMethodResult& mapctrlfi_tclMsgGetCursorInfoMethodResult::operator=(const mapctrlfi_tclMsgGetCursorInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   WGS84Position = coRef.WGS84Position;
   IndexInfo = coRef.IndexInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgGetCursorInfoMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgGetCursorInfoMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_GETCURSORINFO;}
tU8 mapctrlfi_tclMsgGetCursorInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgGetCursorInfoMethodResult::vDestroy()
{
   WGS84Position.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < IndexInfo.size(); ++u32Idx)
         IndexInfo[u32Idx].vDestroy();
   }
   IndexInfo.clear();
}

tU32 mapctrlfi_tclMsgGetCursorInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IndexInfo.size(); ++u32ListIdx)
      u32DynamicSize += IndexInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool mapctrlfi_tclMsgGetCursorInfoMethodResult::operator==(const mapctrlfi_tclMsgGetCursorInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WGS84Position == rfoCmp.WGS84Position);
      bResult = bResult && (IndexInfo.size() == rfoCmp.IndexInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IndexInfo.size()); ++u32Idx)
            bResult = bResult && (IndexInfo[u32Idx] == rfoCmp.IndexInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgGetCursorInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> WGS84Position;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IndexInfo.size(); ++u32Idx)
      {
         IndexInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IndexInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IndexInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgGetCursorInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WGS84Position;
   oOut << (tU32)IndexInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IndexInfo.size(); ++u32Idx)
         oOut << IndexInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUpdateMapSizeMethodStart::mapctrlfi_tclMsgUpdateMapSizeMethodStart(const mapctrlfi_tclMsgUpdateMapSizeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LowerLeftUpdateBoundary = coRef.LowerLeftUpdateBoundary;
   UpperRightUpdateBoundary = coRef.UpperRightUpdateBoundary;
   LowerLeftUpdateFrame = coRef.LowerLeftUpdateFrame;
   UpperRightUpdateFrame = coRef.UpperRightUpdateFrame;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUpdateMapSizeMethodStart& mapctrlfi_tclMsgUpdateMapSizeMethodStart::operator=(const mapctrlfi_tclMsgUpdateMapSizeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LowerLeftUpdateBoundary = coRef.LowerLeftUpdateBoundary;
   UpperRightUpdateBoundary = coRef.UpperRightUpdateBoundary;
   LowerLeftUpdateFrame = coRef.LowerLeftUpdateFrame;
   UpperRightUpdateFrame = coRef.UpperRightUpdateFrame;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgUpdateMapSizeMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgUpdateMapSizeMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_UPDATEMAPSIZE;}
tU8 mapctrlfi_tclMsgUpdateMapSizeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgUpdateMapSizeMethodStart::vDestroy()
{
   LowerLeftUpdateBoundary.vDestroy(); 
   UpperRightUpdateBoundary.vDestroy(); 
   LowerLeftUpdateFrame.vDestroy(); 
   UpperRightUpdateFrame.vDestroy(); 
}

tU32 mapctrlfi_tclMsgUpdateMapSizeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool mapctrlfi_tclMsgUpdateMapSizeMethodStart::operator==(const mapctrlfi_tclMsgUpdateMapSizeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LowerLeftUpdateBoundary == rfoCmp.LowerLeftUpdateBoundary);
      bResult = bResult && (UpperRightUpdateBoundary == rfoCmp.UpperRightUpdateBoundary);
      bResult = bResult && (LowerLeftUpdateFrame == rfoCmp.LowerLeftUpdateFrame);
      bResult = bResult && (UpperRightUpdateFrame == rfoCmp.UpperRightUpdateFrame);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgUpdateMapSizeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LowerLeftUpdateBoundary;
   oIn >> UpperRightUpdateBoundary;
   oIn >> LowerLeftUpdateFrame;
   oIn >> UpperRightUpdateFrame;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgUpdateMapSizeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LowerLeftUpdateBoundary;
   oOut << UpperRightUpdateBoundary;
   oOut << LowerLeftUpdateFrame;
   oOut << UpperRightUpdateFrame;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUpdateMapSizeMethodResult::mapctrlfi_tclMsgUpdateMapSizeMethodResult(const mapctrlfi_tclMsgUpdateMapSizeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   LowerLeftBoundary = coRef.LowerLeftBoundary;
   UpperRightBoundary = coRef.UpperRightBoundary;
   LowerLeftFrame = coRef.LowerLeftFrame;
   UpperRightFrame = coRef.UpperRightFrame;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUpdateMapSizeMethodResult& mapctrlfi_tclMsgUpdateMapSizeMethodResult::operator=(const mapctrlfi_tclMsgUpdateMapSizeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LowerLeftBoundary = coRef.LowerLeftBoundary;
   UpperRightBoundary = coRef.UpperRightBoundary;
   LowerLeftFrame = coRef.LowerLeftFrame;
   UpperRightFrame = coRef.UpperRightFrame;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgUpdateMapSizeMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgUpdateMapSizeMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_UPDATEMAPSIZE;}
tU8 mapctrlfi_tclMsgUpdateMapSizeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgUpdateMapSizeMethodResult::vDestroy()
{
   LowerLeftBoundary.vDestroy(); 
   UpperRightBoundary.vDestroy(); 
   LowerLeftFrame.vDestroy(); 
   UpperRightFrame.vDestroy(); 
}

tU32 mapctrlfi_tclMsgUpdateMapSizeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool mapctrlfi_tclMsgUpdateMapSizeMethodResult::operator==(const mapctrlfi_tclMsgUpdateMapSizeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LowerLeftBoundary == rfoCmp.LowerLeftBoundary);
      bResult = bResult && (UpperRightBoundary == rfoCmp.UpperRightBoundary);
      bResult = bResult && (LowerLeftFrame == rfoCmp.LowerLeftFrame);
      bResult = bResult && (UpperRightFrame == rfoCmp.UpperRightFrame);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgUpdateMapSizeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> LowerLeftBoundary;
   oIn >> UpperRightBoundary;
   oIn >> LowerLeftFrame;
   oIn >> UpperRightFrame;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgUpdateMapSizeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LowerLeftBoundary;
   oOut << UpperRightBoundary;
   oOut << LowerLeftFrame;
   oOut << UpperRightFrame;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetScreenInfoMethodStart::mapctrlfi_tclMsgGetScreenInfoMethodStart(const mapctrlfi_tclMsgGetScreenInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   WGS84Position = coRef.WGS84Position;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetScreenInfoMethodStart& mapctrlfi_tclMsgGetScreenInfoMethodStart::operator=(const mapctrlfi_tclMsgGetScreenInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   WGS84Position = coRef.WGS84Position;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgGetScreenInfoMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgGetScreenInfoMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_GETSCREENINFO;}
tU8 mapctrlfi_tclMsgGetScreenInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgGetScreenInfoMethodStart::vDestroy()
{
   WGS84Position.vDestroy(); 
}

tU32 mapctrlfi_tclMsgGetScreenInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool mapctrlfi_tclMsgGetScreenInfoMethodStart::operator==(const mapctrlfi_tclMsgGetScreenInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WGS84Position == rfoCmp.WGS84Position);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgGetScreenInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> WGS84Position;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgGetScreenInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WGS84Position;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetScreenInfoMethodResult::mapctrlfi_tclMsgGetScreenInfoMethodResult(const mapctrlfi_tclMsgGetScreenInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ScreenPosition = coRef.ScreenPosition;
   LiesInFrame = coRef.LiesInFrame;
   MapSeqNum = coRef.MapSeqNum;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetScreenInfoMethodResult& mapctrlfi_tclMsgGetScreenInfoMethodResult::operator=(const mapctrlfi_tclMsgGetScreenInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ScreenPosition = coRef.ScreenPosition;
   LiesInFrame = coRef.LiesInFrame;
   MapSeqNum = coRef.MapSeqNum;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgGetScreenInfoMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgGetScreenInfoMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_GETSCREENINFO;}
tU8 mapctrlfi_tclMsgGetScreenInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgGetScreenInfoMethodResult::vDestroy()
{
   ScreenPosition.vDestroy(); 
}

tU32 mapctrlfi_tclMsgGetScreenInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool mapctrlfi_tclMsgGetScreenInfoMethodResult::operator==(const mapctrlfi_tclMsgGetScreenInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ScreenPosition == rfoCmp.ScreenPosition);
      bResult = bResult && (LiesInFrame == rfoCmp.LiesInFrame);
      bResult = bResult && (MapSeqNum == rfoCmp.MapSeqNum);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgGetScreenInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ScreenPosition;
   oIn >> LiesInFrame;
   oIn >> MapSeqNum;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgGetScreenInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ScreenPosition;
   oOut << LiesInFrame;
   oOut << MapSeqNum;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::mapctrlfi_tclMsgSelectVisibleRoutesMethodStart(const mapctrlfi_tclMsgSelectVisibleRoutesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectedRoutes = coRef.SelectedRoutes;
   DisplayType = coRef.DisplayType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSelectVisibleRoutesMethodStart& mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::operator=(const mapctrlfi_tclMsgSelectVisibleRoutesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectedRoutes = coRef.SelectedRoutes;
   DisplayType = coRef.DisplayType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SELECTVISIBLEROUTES;}
tU8 mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SelectedRoutes.size(); ++u32Idx)
         SelectedRoutes[u32Idx].vDestroy();
   }
   SelectedRoutes.clear();
}

tU32 mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+SelectedRoutes.size()*4;
}

tBool mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::operator==(const mapctrlfi_tclMsgSelectVisibleRoutesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectedRoutes.size() == rfoCmp.SelectedRoutes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SelectedRoutes.size()); ++u32Idx)
            bResult = bResult && (SelectedRoutes[u32Idx] == rfoCmp.SelectedRoutes[u32Idx]);
      }
      bResult = bResult && (DisplayType == rfoCmp.DisplayType);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SelectedRoutes.size(); ++u32Idx)
      {
         SelectedRoutes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SelectedRoutes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SelectedRoutes[u32Idx];
      }
   }
   oIn >> DisplayType;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgSelectVisibleRoutesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SelectedRoutes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SelectedRoutes.size(); ++u32Idx)
         oOut << SelectedRoutes[u32Idx];
   }
   oOut << DisplayType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::mapctrlfi_tclMsgSelectVisibleRoutesMethodResult(const mapctrlfi_tclMsgSelectVisibleRoutesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSelectVisibleRoutesMethodResult& mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::operator=(const mapctrlfi_tclMsgSelectVisibleRoutesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SELECTVISIBLEROUTES;}
tU8 mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::operator==(const mapctrlfi_tclMsgSelectVisibleRoutesMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgSelectVisibleRoutesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetMapLanguageMethodStart::mapctrlfi_tclMsgSetMapLanguageMethodStart(const mapctrlfi_tclMsgSetMapLanguageMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageFilterList = coRef.LanguageFilterList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetMapLanguageMethodStart& mapctrlfi_tclMsgSetMapLanguageMethodStart::operator=(const mapctrlfi_tclMsgSetMapLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageFilterList = coRef.LanguageFilterList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgSetMapLanguageMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgSetMapLanguageMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SETMAPLANGUAGE;}
tU8 mapctrlfi_tclMsgSetMapLanguageMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgSetMapLanguageMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageFilterList.size(); ++u32Idx)
         LanguageFilterList[u32Idx].vDestroy();
   }
   LanguageFilterList.clear();
}

tU32 mapctrlfi_tclMsgSetMapLanguageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LanguageFilterList.size(); ++u32ListIdx)
      u32DynamicSize += LanguageFilterList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool mapctrlfi_tclMsgSetMapLanguageMethodStart::operator==(const mapctrlfi_tclMsgSetMapLanguageMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageFilterList.size() == rfoCmp.LanguageFilterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LanguageFilterList.size()); ++u32Idx)
            bResult = bResult && (LanguageFilterList[u32Idx] == rfoCmp.LanguageFilterList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgSetMapLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LanguageFilterList.size(); ++u32Idx)
      {
         LanguageFilterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LanguageFilterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LanguageFilterList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgSetMapLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)LanguageFilterList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageFilterList.size(); ++u32Idx)
         oOut << LanguageFilterList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetMapLanguageMethodResult::mapctrlfi_tclMsgSetMapLanguageMethodResult(const mapctrlfi_tclMsgSetMapLanguageMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetMapLanguageMethodResult& mapctrlfi_tclMsgSetMapLanguageMethodResult::operator=(const mapctrlfi_tclMsgSetMapLanguageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgSetMapLanguageMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgSetMapLanguageMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SETMAPLANGUAGE;}
tU8 mapctrlfi_tclMsgSetMapLanguageMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 mapctrlfi_tclMsgSetMapLanguageMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgSetMapLanguageMethodResult::operator==(const mapctrlfi_tclMsgSetMapLanguageMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgSetMapLanguageMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgSetMapLanguageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgClearUsedTrackMethodStart::mapctrlfi_tclMsgClearUsedTrackMethodStart(const mapctrlfi_tclMsgClearUsedTrackMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgClearUsedTrackMethodStart& mapctrlfi_tclMsgClearUsedTrackMethodStart::operator=(const mapctrlfi_tclMsgClearUsedTrackMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgClearUsedTrackMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgClearUsedTrackMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_CLEARUSEDTRACK;}
tU8 mapctrlfi_tclMsgClearUsedTrackMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 mapctrlfi_tclMsgClearUsedTrackMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgClearUsedTrackMethodStart::operator==(const mapctrlfi_tclMsgClearUsedTrackMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgClearUsedTrackMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgClearUsedTrackMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgClearUsedTrackMethodResult::mapctrlfi_tclMsgClearUsedTrackMethodResult(const mapctrlfi_tclMsgClearUsedTrackMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgClearUsedTrackMethodResult& mapctrlfi_tclMsgClearUsedTrackMethodResult::operator=(const mapctrlfi_tclMsgClearUsedTrackMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgClearUsedTrackMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgClearUsedTrackMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_CLEARUSEDTRACK;}
tU8 mapctrlfi_tclMsgClearUsedTrackMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 mapctrlfi_tclMsgClearUsedTrackMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgClearUsedTrackMethodResult::operator==(const mapctrlfi_tclMsgClearUsedTrackMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgClearUsedTrackMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgClearUsedTrackMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetDestinationFlagMethodStart::mapctrlfi_tclMsgSetDestinationFlagMethodStart(const mapctrlfi_tclMsgSetDestinationFlagMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Destinations = coRef.Destinations;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetDestinationFlagMethodStart& mapctrlfi_tclMsgSetDestinationFlagMethodStart::operator=(const mapctrlfi_tclMsgSetDestinationFlagMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Destinations = coRef.Destinations;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgSetDestinationFlagMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgSetDestinationFlagMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SETDESTINATIONFLAG;}
tU8 mapctrlfi_tclMsgSetDestinationFlagMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid mapctrlfi_tclMsgSetDestinationFlagMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Destinations.size(); ++u32Idx)
         Destinations[u32Idx].vDestroy();
   }
   Destinations.clear();
}

tU32 mapctrlfi_tclMsgSetDestinationFlagMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Destinations.size()*9;
}

tBool mapctrlfi_tclMsgSetDestinationFlagMethodStart::operator==(const mapctrlfi_tclMsgSetDestinationFlagMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Destinations.size() == rfoCmp.Destinations.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Destinations.size()); ++u32Idx)
            bResult = bResult && (Destinations[u32Idx] == rfoCmp.Destinations[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgSetDestinationFlagMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Destinations.size(); ++u32Idx)
      {
         Destinations[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Destinations.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Destinations[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgSetDestinationFlagMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Destinations.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Destinations.size(); ++u32Idx)
         oOut << Destinations[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetDestinationFlagMethodResult::mapctrlfi_tclMsgSetDestinationFlagMethodResult(const mapctrlfi_tclMsgSetDestinationFlagMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgSetDestinationFlagMethodResult& mapctrlfi_tclMsgSetDestinationFlagMethodResult::operator=(const mapctrlfi_tclMsgSetDestinationFlagMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgSetDestinationFlagMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgSetDestinationFlagMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_SETDESTINATIONFLAG;}
tU8 mapctrlfi_tclMsgSetDestinationFlagMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 mapctrlfi_tclMsgSetDestinationFlagMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgSetDestinationFlagMethodResult::operator==(const mapctrlfi_tclMsgSetDestinationFlagMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgSetDestinationFlagMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgSetDestinationFlagMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::mapctrlfi_tclMsgGetZoomLevelConfigMethodStart(const mapctrlfi_tclMsgGetZoomLevelConfigMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetZoomLevelConfigMethodStart& mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::operator=(const mapctrlfi_tclMsgGetZoomLevelConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::u16GetFunctionID() const {return MAPCTRLFI_C_U16_GETZOOMLEVELCONFIG;}
tU8 mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::operator==(const mapctrlfi_tclMsgGetZoomLevelConfigMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgGetZoomLevelConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::mapctrlfi_tclMsgGetZoomLevelConfigMethodResult(const mapctrlfi_tclMsgGetZoomLevelConfigMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ZoomLevelConfig = coRef.ZoomLevelConfig;
   MinAutoZoomLevel = coRef.MinAutoZoomLevel;
   MaxAutoZoomLevel = coRef.MaxAutoZoomLevel;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgGetZoomLevelConfigMethodResult& mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::operator=(const mapctrlfi_tclMsgGetZoomLevelConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ZoomLevelConfig = coRef.ZoomLevelConfig;
   MinAutoZoomLevel = coRef.MinAutoZoomLevel;
   MaxAutoZoomLevel = coRef.MaxAutoZoomLevel;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::u16GetFunctionID() const {return MAPCTRLFI_C_U16_GETZOOMLEVELCONFIG;}
tU8 mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ZoomLevelConfig.size(); ++u32Idx)
         ZoomLevelConfig[u32Idx].vDestroy();
   }
   ZoomLevelConfig.clear();
}

tU32 mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ZoomLevelConfig.size()*2;
}

tBool mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::operator==(const mapctrlfi_tclMsgGetZoomLevelConfigMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ZoomLevelConfig.size() == rfoCmp.ZoomLevelConfig.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ZoomLevelConfig.size()); ++u32Idx)
            bResult = bResult && (ZoomLevelConfig[u32Idx] == rfoCmp.ZoomLevelConfig[u32Idx]);
      }
      bResult = bResult && (MinAutoZoomLevel == rfoCmp.MinAutoZoomLevel);
      bResult = bResult && (MaxAutoZoomLevel == rfoCmp.MaxAutoZoomLevel);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ZoomLevelConfig.size(); ++u32Idx)
      {
         ZoomLevelConfig[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ZoomLevelConfig.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ZoomLevelConfig[u32Idx];
      }
   }
   oIn >> MinAutoZoomLevel;
   oIn >> MaxAutoZoomLevel;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgGetZoomLevelConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ZoomLevelConfig.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ZoomLevelConfig.size(); ++u32Idx)
         oOut << ZoomLevelConfig[u32Idx];
   }
   oOut << MinAutoZoomLevel;
   oOut << MaxAutoZoomLevel;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDirectionGet::mapctrlfi_tclMsgMapDirectionGet(const mapctrlfi_tclMsgMapDirectionGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDirectionGet& mapctrlfi_tclMsgMapDirectionGet::operator=(const mapctrlfi_tclMsgMapDirectionGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgMapDirectionGet::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgMapDirectionGet::u16GetFunctionID() const {return MAPCTRLFI_C_U16_MAPDIRECTION;}
tU8 mapctrlfi_tclMsgMapDirectionGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 mapctrlfi_tclMsgMapDirectionGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgMapDirectionGet::operator==(const mapctrlfi_tclMsgMapDirectionGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgMapDirectionGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgMapDirectionGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDirectionStatus::mapctrlfi_tclMsgMapDirectionStatus(const mapctrlfi_tclMsgMapDirectionStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DirStatus = coRef.DirStatus;
   NorthDirection = coRef.NorthDirection;
   DestDirection = coRef.DestDirection;
   MapSeqNum = coRef.MapSeqNum;
   CmdID = coRef.CmdID;
   Scale = coRef.Scale;
   ScaleBarSize = coRef.ScaleBarSize;
   ZoomLevel = coRef.ZoomLevel;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgMapDirectionStatus& mapctrlfi_tclMsgMapDirectionStatus::operator=(const mapctrlfi_tclMsgMapDirectionStatus& coRef)
{
   if (this == &coRef) return *this;
   DirStatus = coRef.DirStatus;
   NorthDirection = coRef.NorthDirection;
   DestDirection = coRef.DestDirection;
   MapSeqNum = coRef.MapSeqNum;
   CmdID = coRef.CmdID;
   Scale = coRef.Scale;
   ScaleBarSize = coRef.ScaleBarSize;
   ZoomLevel = coRef.ZoomLevel;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgMapDirectionStatus::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgMapDirectionStatus::u16GetFunctionID() const {return MAPCTRLFI_C_U16_MAPDIRECTION;}
tU8 mapctrlfi_tclMsgMapDirectionStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 mapctrlfi_tclMsgMapDirectionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (5 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (5 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (5 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (5 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4;
}

tBool mapctrlfi_tclMsgMapDirectionStatus::operator==(const mapctrlfi_tclMsgMapDirectionStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DirStatus == rfoCmp.DirStatus);
      bResult = bResult && (NorthDirection == rfoCmp.NorthDirection);
      bResult = bResult && (DestDirection == rfoCmp.DestDirection);
      bResult = bResult && (MapSeqNum == rfoCmp.MapSeqNum);
      bResult = bResult && (CmdID == rfoCmp.CmdID);
      bResult = bResult && (Scale == rfoCmp.Scale);
      bResult = bResult && (ScaleBarSize == rfoCmp.ScaleBarSize);
      bResult = bResult && (ZoomLevel == rfoCmp.ZoomLevel);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgMapDirectionStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DirStatus;
   oIn >> NorthDirection;
   oIn >> DestDirection;
   oIn >> MapSeqNum;
   if (5 <= oIn.u16GetMajorVersion())
   {
      oIn >> CmdID;
   }
   if (5 <= oIn.u16GetMajorVersion())
   {
      oIn >> Scale;
   }
   if (5 <= oIn.u16GetMajorVersion())
   {
      oIn >> ScaleBarSize;
   }
   if (5 <= oIn.u16GetMajorVersion())
   {
      oIn >> ZoomLevel;
   }
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgMapDirectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DirStatus;
   oOut << NorthDirection;
   oOut << DestDirection;
   oOut << MapSeqNum;
   if (5 <= oOut.u16GetMajorVersion())
   {
      oOut << CmdID;
   }
   if (5 <= oOut.u16GetMajorVersion())
   {
      oOut << Scale;
   }
   if (5 <= oOut.u16GetMajorVersion())
   {
      oOut << ScaleBarSize;
   }
   if (5 <= oOut.u16GetMajorVersion())
   {
      oOut << ZoomLevel;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgEngineeringTextGet::mapctrlfi_tclMsgEngineeringTextGet(const mapctrlfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgEngineeringTextGet& mapctrlfi_tclMsgEngineeringTextGet::operator=(const mapctrlfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return MAPCTRLFI_C_U16_ENGINEERINGTEXT;}
tU8 mapctrlfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 mapctrlfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgEngineeringTextGet::operator==(const mapctrlfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgEngineeringTextUpReg::mapctrlfi_tclMsgEngineeringTextUpReg(const mapctrlfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgEngineeringTextUpReg& mapctrlfi_tclMsgEngineeringTextUpReg::operator=(const mapctrlfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return MAPCTRLFI_C_U16_ENGINEERINGTEXT;}
tU8 mapctrlfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 mapctrlfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgEngineeringTextUpReg::operator==(const mapctrlfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgEngineeringTextRelUpReg::mapctrlfi_tclMsgEngineeringTextRelUpReg(const mapctrlfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgEngineeringTextRelUpReg& mapctrlfi_tclMsgEngineeringTextRelUpReg::operator=(const mapctrlfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return MAPCTRLFI_C_U16_ENGINEERINGTEXT;}
tU8 mapctrlfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 mapctrlfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgEngineeringTextRelUpReg::operator==(const mapctrlfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgEngineeringTextStatus::mapctrlfi_tclMsgEngineeringTextStatus(const mapctrlfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgEngineeringTextStatus& mapctrlfi_tclMsgEngineeringTextStatus::operator=(const mapctrlfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return MAPCTRLFI_C_U16_ENGINEERINGTEXT;}
tU8 mapctrlfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid mapctrlfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 mapctrlfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool mapctrlfi_tclMsgEngineeringTextStatus::operator==(const mapctrlfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUsedDatasetGet::mapctrlfi_tclMsgUsedDatasetGet(const mapctrlfi_tclMsgUsedDatasetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUsedDatasetGet& mapctrlfi_tclMsgUsedDatasetGet::operator=(const mapctrlfi_tclMsgUsedDatasetGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgUsedDatasetGet::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgUsedDatasetGet::u16GetFunctionID() const {return MAPCTRLFI_C_U16_USEDDATASET;}
tU8 mapctrlfi_tclMsgUsedDatasetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 mapctrlfi_tclMsgUsedDatasetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgUsedDatasetGet::operator==(const mapctrlfi_tclMsgUsedDatasetGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgUsedDatasetGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgUsedDatasetGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUsedDatasetUpReg::mapctrlfi_tclMsgUsedDatasetUpReg(const mapctrlfi_tclMsgUsedDatasetUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUsedDatasetUpReg& mapctrlfi_tclMsgUsedDatasetUpReg::operator=(const mapctrlfi_tclMsgUsedDatasetUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgUsedDatasetUpReg::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgUsedDatasetUpReg::u16GetFunctionID() const {return MAPCTRLFI_C_U16_USEDDATASET;}
tU8 mapctrlfi_tclMsgUsedDatasetUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 mapctrlfi_tclMsgUsedDatasetUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgUsedDatasetUpReg::operator==(const mapctrlfi_tclMsgUsedDatasetUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgUsedDatasetUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgUsedDatasetUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUsedDatasetRelUpReg::mapctrlfi_tclMsgUsedDatasetRelUpReg(const mapctrlfi_tclMsgUsedDatasetRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUsedDatasetRelUpReg& mapctrlfi_tclMsgUsedDatasetRelUpReg::operator=(const mapctrlfi_tclMsgUsedDatasetRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgUsedDatasetRelUpReg::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgUsedDatasetRelUpReg::u16GetFunctionID() const {return MAPCTRLFI_C_U16_USEDDATASET;}
tU8 mapctrlfi_tclMsgUsedDatasetRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 mapctrlfi_tclMsgUsedDatasetRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool mapctrlfi_tclMsgUsedDatasetRelUpReg::operator==(const mapctrlfi_tclMsgUsedDatasetRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgUsedDatasetRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgUsedDatasetRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUsedDatasetStatus::mapctrlfi_tclMsgUsedDatasetStatus(const mapctrlfi_tclMsgUsedDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mapctrlfi_tclMsgUsedDatasetStatus& mapctrlfi_tclMsgUsedDatasetStatus::operator=(const mapctrlfi_tclMsgUsedDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 mapctrlfi_tclMsgUsedDatasetStatus::u16GetServiceID() const {return MAPCTRLFI_C_U16_SERVICE_ID;}
tU16 mapctrlfi_tclMsgUsedDatasetStatus::u16GetFunctionID() const {return MAPCTRLFI_C_U16_USEDDATASET;}
tU8 mapctrlfi_tclMsgUsedDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 mapctrlfi_tclMsgUsedDatasetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool mapctrlfi_tclMsgUsedDatasetStatus::operator==(const mapctrlfi_tclMsgUsedDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
   return bResult;
}

fi_tclInContext& mapctrlfi_tclMsgUsedDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   oIn >> DataSetId;
   return oIn;
}

fi_tclOutContext& mapctrlfi_tclMsgUsedDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   oOut << DataSetId;
   return oOut;
}

