#ifndef MAPCTRLFILANGUAGE_HEADER
#define MAPCTRLFILANGUAGE_HEADER

class mapctrlfi_tclInContext;
class mapctrlfi_tclOutContext;
class mapctrlfi_tclVisitorBase;

class MY_DECL mapctrlfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  mapctrlfi_tclDescription(fi_tclInContext* poIn, mapctrlfi_tclVisitorBase* poVisit);
  mapctrlfi_tclDescription(fi_tclOutContext* poOut, mapctrlfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(mapctrlfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ mapctrlfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  mapctrlfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<mapctrlfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<mapctrlfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline mapctrlfi_tclDescription::mapctrlfi_tclDescription(fi_tclInContext* poIn, mapctrlfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline mapctrlfi_tclDescription::mapctrlfi_tclDescription(fi_tclOutContext* poOut, mapctrlfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

