#include "precompiled.hh"

tBool mapctrlfi_tclDescription::bInitMessage(mapctrlfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case mapctrlfi_tclToken::EN_LAST_TOKEN:
   case mapctrlfi_tclToken::EN_LIST:
   case mapctrlfi_tclToken::EN_END_OF_STRUCT:
   case mapctrlfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_PIXELHEIGHT));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_PIXELWIDTH));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_UPPERRIGHT));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_LOWERLEFT));
   } break;
   case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_PIXELHEIGHT));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_PIXELWIDTH));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_UPPERRIGHT));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_LOWERLEFT));
   } break;
   case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENINTERSECTIONZOOMMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSCALE,mapctrlfi_tclSemanticDomain::EN_MSG_STARTSCALE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_PIXELHEIGHT));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_PIXELWIDTH));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_UPPERRIGHT));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_LOWERLEFT));
   } break;
   case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENINTERSECTIONZOOMMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSCALE,mapctrlfi_tclSemanticDomain::EN_MSG_STARTSCALE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_PIXELHEIGHT));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_PIXELWIDTH));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_UPPERRIGHT));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_LOWERLEFT));
   } break;
   case mapctrlfi_tclToken::EN_MSG_LABELFILTERMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B32_CITYCENTERS,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_CITYCENTERPOINTS));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B32_POI2,mapctrlfi_tclSemanticDomain::EN_MSG_POIS2));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B32_POI1,mapctrlfi_tclSemanticDomain::EN_MSG_POIS1));
      if (6 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B32_SERVICESTATIONS3,mapctrlfi_tclSemanticDomain::EN_MSG_SERVICES3));
      }
      if (6 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B32_SERVICESTATIONS2,mapctrlfi_tclSemanticDomain::EN_MSG_SERVICES2));
      }
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B32_SERVICESTATIONS,mapctrlfi_tclSemanticDomain::EN_MSG_SERVICES));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B32_STREETS,mapctrlfi_tclSemanticDomain::EN_MSG_STREETS));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_FREEWAYFACILITIES,mapctrlfi_tclSemanticDomain::EN_MSG_FREEWAYS));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_PARKINGAREAS,mapctrlfi_tclSemanticDomain::EN_MSG_PARKFACILITIES));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_BORDERLINES,mapctrlfi_tclSemanticDomain::EN_MSG_BORDERS));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_RIVERCLASS,mapctrlfi_tclSemanticDomain::EN_MSG_RIVERCLASSES));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_CHANNELS,mapctrlfi_tclSemanticDomain::EN_MSG_CHANNELS));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_AREAS,mapctrlfi_tclSemanticDomain::EN_MSG_AREAS));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B16_GLOBALPREFERENCES,mapctrlfi_tclSemanticDomain::EN_MSG_GLOBPREF));
   } break;
   case mapctrlfi_tclToken::EN_MSG_LABELFILTERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_FILTERACCEPTANCE,mapctrlfi_tclSemanticDomain::EN_MSG_FILTERACCEPTED));
   } break;
   case mapctrlfi_tclToken::EN_MSG_SCALEBARSIZESMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_SCALEBARSIZES));
   } break;
   case mapctrlfi_tclToken::EN_MSG_SCALEBARSIZESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_SCALEBARSIZES));
   } break;
   case mapctrlfi_tclToken::EN_MSG_MAPDRAWMETHODSTART:
   {
      if (5 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_CMDID));
      }
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_DRAWOPTIONS,mapctrlfi_tclSemanticDomain::EN_MSG_OPTIONS));
      if (poOutContext->u16GetMajorVersion() <= 4)
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8_DIRECTIONABSOLUTE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPTILTANGLE));
      }
      if (poOutContext->u16GetMajorVersion() <= 4)
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S8,mapctrlfi_tclSemanticDomain::EN_MSG_ZOFFSET));
      }
      if (poOutContext->u16GetMajorVersion() <= 4)
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S8,mapctrlfi_tclSemanticDomain::EN_MSG_CAMERADISTANCE));
      }
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONWGS84,mapctrlfi_tclSemanticDomain::EN_MSG_INDEXPOSITION));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_REFPOS));
      if (poOutContext->u16GetMajorVersion() <= 4)
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U16,mapctrlfi_tclSemanticDomain::EN_MSG_INTTIME));
      }
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPMODE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPMODE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPANGLE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPANGLE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSCALE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPSCALE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSTATE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPSTATE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_DRAWMODE,mapctrlfi_tclSemanticDomain::EN_MSG_DRAWMODE));
   } break;
   case mapctrlfi_tclToken::EN_MSG_MAPDRAWMETHODRESULT:
   {
      if (5 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_CMDID));
      }
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_DRAWOPTIONS,mapctrlfi_tclSemanticDomain::EN_MSG_OPTIONS));
      if (poOutContext->u16GetMajorVersion() <= 4)
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8_DIRECTIONABSOLUTE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPTILTANGLE));
      }
      if (poOutContext->u16GetMajorVersion() <= 4)
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S8,mapctrlfi_tclSemanticDomain::EN_MSG_ZOFFSET));
      }
      if (poOutContext->u16GetMajorVersion() <= 4)
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S8,mapctrlfi_tclSemanticDomain::EN_MSG_CAMERADISTANCE));
      }
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONWGS84,mapctrlfi_tclSemanticDomain::EN_MSG_INDEXPOSITION));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_REFPOS));
      if (poOutContext->u16GetMajorVersion() <= 4)
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U16,mapctrlfi_tclSemanticDomain::EN_MSG_INTTIME));
      }
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPMODE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPMODE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPANGLE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPANGLE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSCALE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPSCALE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSTATE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPSTATE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_DRAWMODE,mapctrlfi_tclSemanticDomain::EN_MSG_DRAWMODE));
   } break;
   case mapctrlfi_tclToken::EN_MSG_MAPDRAWINTERSECTIONZOOMMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_ROADID,mapctrlfi_tclSemanticDomain::EN_MSG_ROADID));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONWGS84,mapctrlfi_tclSemanticDomain::EN_MSG_MAPCENTER));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_REFPOS));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPMODE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPMODE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPANGLE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPANGLEMODE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSCALE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPSCALE));
   } break;
   case mapctrlfi_tclToken::EN_MSG_MAPDRAWINTERSECTIONZOOMMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_MAPBYTESTREAM));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_MAPTRANSMATRIX,mapctrlfi_tclSemanticDomain::EN_MSG_MAPTRANSMATRIX));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U16_DIRECTION,mapctrlfi_tclSemanticDomain::EN_MSG_MAPANGLEVALUE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONWGS84,mapctrlfi_tclSemanticDomain::EN_MSG_MAPCENTER));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_REFPOS));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPMODE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPMODE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPANGLE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPANGLEMODE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSCALE,mapctrlfi_tclSemanticDomain::EN_MSG_MAPSCALE));
   } break;
   case mapctrlfi_tclToken::EN_MSG_SETCURSORMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_SCREENPOSITION));
   } break;
   case mapctrlfi_tclToken::EN_MSG_SETCURSORMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONWGS84,mapctrlfi_tclSemanticDomain::EN_MSG_WGS84POSITION));
   } break;
   case mapctrlfi_tclToken::EN_MSG_GETCURSORINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_CURSORPOSITION));
   } break;
   case mapctrlfi_tclToken::EN_MSG_GETCURSORINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_INDEXINFO,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_INDEXINFO));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONWGS84,mapctrlfi_tclSemanticDomain::EN_MSG_WGS84POSITION));
   } break;
   case mapctrlfi_tclToken::EN_MSG_UPDATEMAPSIZEMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_UPPERRIGHTUPDATEFRAME));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_LOWERLEFTUPDATEFRAME));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_UPPERRIGHTUPDATEBOUNDARY));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_LOWERLEFTUPDATEBOUNDARY));
   } break;
   case mapctrlfi_tclToken::EN_MSG_UPDATEMAPSIZEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_UPPERRIGHTFRAME));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_LOWERLEFTFRAME));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_UPPERRIGHTBOUNDARY));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_LOWERLEFTBOUNDARY));
   } break;
   case mapctrlfi_tclToken::EN_MSG_GETSCREENINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONWGS84,mapctrlfi_tclSemanticDomain::EN_MSG_WGS84POSITION));
   } break;
   case mapctrlfi_tclToken::EN_MSG_GETSCREENINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_MAPSEQNUM));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_BOOL,mapctrlfi_tclSemanticDomain::EN_MSG_LIESINFRAME));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONSCREEN,mapctrlfi_tclSemanticDomain::EN_MSG_SCREENPOSITION));
   } break;
   case mapctrlfi_tclToken::EN_MSG_SELECTVISIBLEROUTESMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_ROUTEDISPLAYTYPE,mapctrlfi_tclSemanticDomain::EN_MSG_DISPLAYTYPE));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_ROUTEDESCRIPTOR,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_SELECTEDROUTES));
   } break;
   case mapctrlfi_tclToken::EN_MSG_SETMAPLANGUAGEMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LANGUAGEFILTER,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_LANGUAGEFILTERLIST));
   } break;
   case mapctrlfi_tclToken::EN_MSG_SETDESTINATIONFLAGMETHODSTART:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_DESTINATIONFLAG,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_DESTINATIONS));
   } break;
   case mapctrlfi_tclToken::EN_MSG_GETZOOMLEVELCONFIGMETHODRESULT:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_MAXAUTOZOOMLEVEL));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_MINAUTOZOOMLEVEL));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_ZOOMLEVELCONFIG,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_MSG_ZOOMLEVELCONFIG));
   } break;
   case mapctrlfi_tclToken::EN_MSG_MAPDIRECTIONSTATUS:
   {
      if (5 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_ZOOMLEVEL));
      }
      if (5 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_SCALEBARSIZE));
      }
      if (5 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSCALE,mapctrlfi_tclSemanticDomain::EN_MSG_SCALE));
      }
      if (5 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_CMDID));
      }
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_MSG_MAPSEQNUM));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8_DIRECTIONRELATIVE,mapctrlfi_tclSemanticDomain::EN_MSG_DESTDIRECTION));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8_DIRECTIONRELATIVE,mapctrlfi_tclSemanticDomain::EN_MSG_NORTHDIRECTION));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_B8_DIRINFOSTATUS,mapctrlfi_tclSemanticDomain::EN_MSG_DIRSTATUS));
   } break;
   case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_STRING,mapctrlfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case mapctrlfi_tclToken::EN_MSG_USEDDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U32_DATASETID,mapctrlfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U32_MEDIAID,mapctrlfi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case mapctrlfi_tclToken::EN_BINCONTAINER:
   case mapctrlfi_tclToken::EN_S32_LONGITUDE:
   case mapctrlfi_tclToken::EN_S32_LATITUDE:
   case mapctrlfi_tclToken::EN_POSITIONWGS84:
   case mapctrlfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case mapctrlfi_tclToken::EN_U8_DIRECTIONRELATIVE:
   case mapctrlfi_tclToken::EN_U32_DATASETID:
   case mapctrlfi_tclToken::EN_U32_MEDIAID:
   case mapctrlfi_tclToken::EN_ROADID:
   case mapctrlfi_tclToken::EN_U16_TRIPHANDLE:
   case mapctrlfi_tclToken::EN_U16_ROUTEHANDLE:
   case mapctrlfi_tclToken::EN_S16_XPOSSCREEN:
   case mapctrlfi_tclToken::EN_S16_YPOSSCREEN:
   case mapctrlfi_tclToken::EN_U16_DIRECTION:
   case mapctrlfi_tclToken::EN_B16_GLOBALPREFERENCES:
   case mapctrlfi_tclToken::EN_B32_POI1:
   case mapctrlfi_tclToken::EN_B32_POI2:
   case mapctrlfi_tclToken::EN_B32_SERVICESTATIONS:
   case mapctrlfi_tclToken::EN_B32_SERVICESTATIONS2:
   case mapctrlfi_tclToken::EN_B32_SERVICESTATIONS3:
   case mapctrlfi_tclToken::EN_B8_FREEWAYFACILITIES:
   case mapctrlfi_tclToken::EN_B8_PARKINGAREAS:
   case mapctrlfi_tclToken::EN_B8_BORDERLINES:
   case mapctrlfi_tclToken::EN_B8_RIVERCLASS:
   case mapctrlfi_tclToken::EN_B8_CHANNELS:
   case mapctrlfi_tclToken::EN_B32_STREETS:
   case mapctrlfi_tclToken::EN_B8_AREAS:
   case mapctrlfi_tclToken::EN_B32_CITYCENTERS:
   case mapctrlfi_tclToken::EN_B8_DIRINFOSTATUS:
   case mapctrlfi_tclToken::EN_E8_FILTERACCEPTANCE:
   case mapctrlfi_tclToken::EN_E8_DRAWMODE:
   case mapctrlfi_tclToken::EN_E8_MAPSTATE:
   case mapctrlfi_tclToken::EN_E8_MAPMODE:
   case mapctrlfi_tclToken::EN_E8_MAPSCALE:
   case mapctrlfi_tclToken::EN_E8_MAPANGLE:
   case mapctrlfi_tclToken::EN_MAPTRANSMATRIX:
   case mapctrlfi_tclToken::EN_E16_IDXTYPE:
   case mapctrlfi_tclToken::EN_POSITIONSCREEN:
   case mapctrlfi_tclToken::EN_INDEXINFO:
   case mapctrlfi_tclToken::EN_B8_DRAWOPTIONS:
   case mapctrlfi_tclToken::EN_ROUTEDESCRIPTOR:
   case mapctrlfi_tclToken::EN_E8_ROUTEDISPLAYTYPE:
   case mapctrlfi_tclToken::EN_E16_USMARCLANGUAGECODE:
   case mapctrlfi_tclToken::EN_U32CODEPAGE:
   case mapctrlfi_tclToken::EN_E8_LANGUAGEDEFAULTFLAG:
   case mapctrlfi_tclToken::EN_LANGUAGEFILTER:
   case mapctrlfi_tclToken::EN_ZOOMLEVELCONFIG:
   case mapctrlfi_tclToken::EN_DESTINATIONFLAG:
   case mapctrlfi_tclToken::EN_U8:   
   case mapctrlfi_tclToken::EN_S8:   
   case mapctrlfi_tclToken::EN_U16:   
   case mapctrlfi_tclToken::EN_S16:   
   case mapctrlfi_tclToken::EN_U24:   
   case mapctrlfi_tclToken::EN_S24:   
   case mapctrlfi_tclToken::EN_U32:   
   case mapctrlfi_tclToken::EN_S32:   
   case mapctrlfi_tclToken::EN_U64:   
   case mapctrlfi_tclToken::EN_S64:   
   case mapctrlfi_tclToken::EN_F32:   
   case mapctrlfi_tclToken::EN_F64:   
   case mapctrlfi_tclToken::EN_BOOL:   
   case mapctrlfi_tclToken::EN_STRING:   
   case mapctrlfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(mapctrlfi_tclKnot(enMsgToken,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool mapctrlfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool mapctrlfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      mapctrlfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      mapctrlfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      mapctrlfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(mapctrlfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(mapctrlfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(mapctrlfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case mapctrlfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == mapctrlfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            mapctrlfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(mapctrlfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            mapctrlfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(mapctrlfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case mapctrlfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case mapctrlfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case mapctrlfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENINTERSECTIONZOOMMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_INITMAPSCREENINTERSECTIONZOOMMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_LABELFILTERMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_LABELFILTERMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_SCALEBARSIZESMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_SCALEBARSIZESMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_MAPDRAWMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_MAPDRAWMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_MAPDRAWINTERSECTIONZOOMMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_MAPDRAWINTERSECTIONZOOMMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_SETCURSORMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_SETCURSORMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_GETCURSORINFOMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_GETCURSORINFOMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_UPDATEMAPSIZEMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_UPDATEMAPSIZEMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_GETSCREENINFOMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_GETSCREENINFOMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_SELECTVISIBLEROUTESMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_SELECTVISIBLEROUTESMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_SETMAPLANGUAGEMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_SETMAPLANGUAGEMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_CLEARUSEDTRACKMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_CLEARUSEDTRACKMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_SETDESTINATIONFLAGMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_SETDESTINATIONFLAGMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_GETZOOMLEVELCONFIGMETHODSTART:
   case mapctrlfi_tclToken::EN_MSG_GETZOOMLEVELCONFIGMETHODRESULT:
   case mapctrlfi_tclToken::EN_MSG_MAPDIRECTIONGET:
   case mapctrlfi_tclToken::EN_MSG_MAPDIRECTIONSTATUS:
   case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case mapctrlfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   case mapctrlfi_tclToken::EN_MSG_USEDDATASETGET:
   case mapctrlfi_tclToken::EN_MSG_USEDDATASETUPREG:
   case mapctrlfi_tclToken::EN_MSG_USEDDATASETRELUPREG:
   case mapctrlfi_tclToken::EN_MSG_USEDDATASETSTATUS:
      bInitMessage(enToken);
      break;
   case mapctrlfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S32_LATITUDE,mapctrlfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S32_LONGITUDE,mapctrlfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_U8_DIRECTIONRELATIVE:
   {
      fi_tcl_u8_DirectionRelative o_u8_DirectionRelative;
      if (!bDoIt(o_u8_DirectionRelative))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_U32_MEDIAID:
   {
      fi_tcl_u32_MediaId o_u32_MediaId;
      if (!bDoIt(o_u32_MediaId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_ROADID:
   {
      if (poVisitor->bDoExpand_RoadId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U32_DATASETID,mapctrlfi_tclSemanticDomain::EN_NAVDATASETID));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U32,mapctrlfi_tclSemanticDomain::EN_CLUSTERFILEOFFSET));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U16,mapctrlfi_tclSemanticDomain::EN_CLUSTERLENGTH));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U16,mapctrlfi_tclSemanticDomain::EN_CLUSTERFILEID));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U16,mapctrlfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_RoadId o_RoadId;
         if (!bDoIt(o_RoadId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_U16_TRIPHANDLE:
   {
      fi_tcl_u16_TripHandle o_u16_TripHandle;
      if (!bDoIt(o_u16_TripHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_U16_ROUTEHANDLE:
   {
      fi_tcl_u16_RouteHandle o_u16_RouteHandle;
      if (!bDoIt(o_u16_RouteHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_S16_XPOSSCREEN:
   {
      fi_tcl_s16_XPosScreen o_s16_XPosScreen;
      if (!bDoIt(o_s16_XPosScreen))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_S16_YPOSSCREEN:
   {
      fi_tcl_s16_YPosScreen o_s16_YPosScreen;
      if (!bDoIt(o_s16_YPosScreen))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_U16_DIRECTION:
   {
      fi_tcl_u16_Direction o_u16_Direction;
      if (!bDoIt(o_u16_Direction))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B16_GLOBALPREFERENCES:
   {
      fi_tcl_b16_GlobalPreferences o_b16_GlobalPreferences;
      if (!bDoIt(o_b16_GlobalPreferences))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B32_POI1:
   {
      fi_tcl_b32_POI1 o_b32_POI1;
      if (!bDoIt(o_b32_POI1))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B32_POI2:
   {
      fi_tcl_b32_POI2 o_b32_POI2;
      if (!bDoIt(o_b32_POI2))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B32_SERVICESTATIONS:
   {
      fi_tcl_b32_ServiceStations o_b32_ServiceStations;
      if (!bDoIt(o_b32_ServiceStations))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B32_SERVICESTATIONS2:
   {
      fi_tcl_b32_ServiceStations2 o_b32_ServiceStations2;
      if (!bDoIt(o_b32_ServiceStations2))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B32_SERVICESTATIONS3:
   {
      fi_tcl_b32_ServiceStations3 o_b32_ServiceStations3;
      if (!bDoIt(o_b32_ServiceStations3))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B8_FREEWAYFACILITIES:
   {
      fi_tcl_b8_FreewayFacilities o_b8_FreewayFacilities;
      if (!bDoIt(o_b8_FreewayFacilities))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B8_PARKINGAREAS:
   {
      fi_tcl_b8_ParkingAreas o_b8_ParkingAreas;
      if (!bDoIt(o_b8_ParkingAreas))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B8_BORDERLINES:
   {
      fi_tcl_b8_BorderLines o_b8_BorderLines;
      if (!bDoIt(o_b8_BorderLines))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B8_RIVERCLASS:
   {
      fi_tcl_b8_RiverClass o_b8_RiverClass;
      if (!bDoIt(o_b8_RiverClass))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B8_CHANNELS:
   {
      fi_tcl_b8_Channels o_b8_Channels;
      if (!bDoIt(o_b8_Channels))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B32_STREETS:
   {
      fi_tcl_b32_Streets o_b32_Streets;
      if (!bDoIt(o_b32_Streets))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B8_AREAS:
   {
      fi_tcl_b8_Areas o_b8_Areas;
      if (!bDoIt(o_b8_Areas))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B32_CITYCENTERS:
   {
      fi_tcl_b32_CityCenters o_b32_CityCenters;
      if (!bDoIt(o_b32_CityCenters))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_B8_DIRINFOSTATUS:
   {
      fi_tcl_b8_DirInfoStatus o_b8_DirInfoStatus;
      if (!bDoIt(o_b8_DirInfoStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_E8_FILTERACCEPTANCE:
   {
      fi_tcl_e8_FilterAcceptance o_e8_FilterAcceptance;
      if (!bDoIt(o_e8_FilterAcceptance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_E8_DRAWMODE:
   {
      fi_tcl_e8_DrawMode o_e8_DrawMode;
      if (!bDoIt(o_e8_DrawMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_E8_MAPSTATE:
   {
      fi_tcl_e8_MapState o_e8_MapState;
      if (!bDoIt(o_e8_MapState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_E8_MAPMODE:
   {
      fi_tcl_e8_MapMode o_e8_MapMode;
      if (!bDoIt(o_e8_MapMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_E8_MAPSCALE:
   {
      fi_tcl_e8_MapScale o_e8_MapScale;
      if (!bDoIt(o_e8_MapScale))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_E8_MAPANGLE:
   {
      fi_tcl_e8_MapAngle o_e8_MapAngle;
      if (!bDoIt(o_e8_MapAngle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_MAPTRANSMATRIX:
   {
      if (poVisitor->bDoExpand_MapTransMatrix(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S32,mapctrlfi_tclSemanticDomain::EN_M22));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S32,mapctrlfi_tclSemanticDomain::EN_M21));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S32,mapctrlfi_tclSemanticDomain::EN_M12));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S32,mapctrlfi_tclSemanticDomain::EN_M11));
      }
      else
      {
         fi_tcl_MapTransMatrix o_MapTransMatrix;
         if (!bDoIt(o_MapTransMatrix))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapTransMatrix.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapTransMatrix.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_E16_IDXTYPE:
   {
      fi_tcl_e16_IdxType o_e16_IdxType;
      if (!bDoIt(o_e16_IdxType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_POSITIONSCREEN:
   {
      if (poVisitor->bDoExpand_PositionScreen(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S16_YPOSSCREEN,mapctrlfi_tclSemanticDomain::EN_YPOS));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_S16_XPOSSCREEN,mapctrlfi_tclSemanticDomain::EN_XPOS));
      }
      else
      {
         fi_tcl_PositionScreen o_PositionScreen;
         if (!bDoIt(o_PositionScreen))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionScreen.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionScreen.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_INDEXINFO:
   {
      if (poVisitor->bDoExpand_IndexInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_STRING,mapctrlfi_tclSemanticDomain::EN_IDXSTRING));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E16_IDXTYPE,mapctrlfi_tclSemanticDomain::EN_IDXTYPE));
      }
      else
      {
         fi_tcl_IndexInfo o_IndexInfo;
         if (!bDoIt(o_IndexInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_B8_DRAWOPTIONS:
   {
      fi_tcl_b8_DrawOptions o_b8_DrawOptions;
      if (!bDoIt(o_b8_DrawOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_ROUTEDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_RouteDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U16_ROUTEHANDLE,mapctrlfi_tclSemanticDomain::EN_ROUTEHANDLE));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U16_TRIPHANDLE,mapctrlfi_tclSemanticDomain::EN_TRIPHANDLE));
      }
      else
      {
         fi_tcl_RouteDescriptor o_RouteDescriptor;
         if (!bDoIt(o_RouteDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_E8_ROUTEDISPLAYTYPE:
   {
      fi_tcl_e8_RouteDisplayType o_e8_RouteDisplayType;
      if (!bDoIt(o_e8_RouteDisplayType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_E16_USMARCLANGUAGECODE:
   {
      fi_tcl_e16_USMarcLanguageCode o_e16_USMarcLanguageCode;
      if (!bDoIt(o_e16_USMarcLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_U32CODEPAGE:
   {
      fi_tcl_u32CodePage o_u32CodePage;
      if (!bDoIt(o_u32CodePage))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_E8_LANGUAGEDEFAULTFLAG:
   {
      fi_tcl_e8_LanguageDefaultFlag o_e8_LanguageDefaultFlag;
      if (!bDoIt(o_e8_LanguageDefaultFlag))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case mapctrlfi_tclToken::EN_LANGUAGEFILTER:
   {
      if (poVisitor->bDoExpand_LanguageFilter(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U32CODEPAGE,mapctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_LIST,mapctrlfi_tclSemanticDomain::EN_CODEPAGELIST));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E16_USMARCLANGUAGECODE,mapctrlfi_tclSemanticDomain::EN_LANGUAGE));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_LANGUAGEDEFAULTFLAG,mapctrlfi_tclSemanticDomain::EN_DEFAULTFLAG));
      }
      else
      {
         fi_tcl_LanguageFilter o_LanguageFilter;
         if (!bDoIt(o_LanguageFilter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageFilter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageFilter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_ZOOMLEVELCONFIG:
   {
      if (poVisitor->bDoExpand_ZoomLevelConfig(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_SCALEBARSIZE));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_E8_MAPSCALE,mapctrlfi_tclSemanticDomain::EN_SOURCESCALE));
      }
      else
      {
         fi_tcl_ZoomLevelConfig o_ZoomLevelConfig;
         if (!bDoIt(o_ZoomLevelConfig))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ZoomLevelConfig.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ZoomLevelConfig.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case mapctrlfi_tclToken::EN_DESTINATIONFLAG:
   {
      if (poVisitor->bDoExpand_DestinationFlag(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_END_OF_STRUCT,mapctrlfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_U8,mapctrlfi_tclSemanticDomain::EN_DESTINATIONTYPE));
         oPath.bGoDown(mapctrlfi_tclKnot(mapctrlfi_tclToken::EN_POSITIONWGS84,mapctrlfi_tclSemanticDomain::EN_DESTPOSITION));
      }
      else
      {
         fi_tcl_DestinationFlag o_DestinationFlag;
         if (!bDoIt(o_DestinationFlag))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DestinationFlag.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DestinationFlag.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case mapctrlfi_tclToken::EN_UNKNOWN:
      case mapctrlfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

