#ifndef LIFILANGUAGE_HEADER
#define LIFILANGUAGE_HEADER

class lifi_tclInContext;
class lifi_tclOutContext;
class lifi_tclVisitorBase;

class MY_DECL lifi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  lifi_tclDescription(fi_tclInContext* poIn, lifi_tclVisitorBase* poVisit);
  lifi_tclDescription(fi_tclOutContext* poOut, lifi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(lifi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ lifi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  lifi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<lifi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<lifi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline lifi_tclDescription::lifi_tclDescription(fi_tclInContext* poIn, lifi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline lifi_tclDescription::lifi_tclDescription(fi_tclOutContext* poOut, lifi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

