#include "precompiled.hh"

tBool lifi_tclDescription::bInitMessage(lifi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case lifi_tclToken::EN_LAST_TOKEN:
   case lifi_tclToken::EN_LIST:
   case lifi_tclToken::EN_END_OF_STRUCT:
   case lifi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIADESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_SELECTIONCRITERIA));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIADESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_SELECTIONCRITERIONDESCRIPTION,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_SELECTIONCRITERIADESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIAMETHODSTART:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B8_CRITERIAGETOPTIONS,lifi_tclSemanticDomain::EN_MSG_GETOPTION));
      }
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
   } break;
   case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_BOOL,lifi_tclSemanticDomain::EN_MSG_DATABASEINCOMPLETE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_SELECTABLECRITERION,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_SELECTIONCRITERIALIST));
   } break;
   case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_TRANSFORMMODE,lifi_tclSemanticDomain::EN_MSG_MODE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETELEMENTCOUNTMETHODSTART:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_ATTRIBUTECODES));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32,lifi_tclSemanticDomain::EN_MSG_LIMIT));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
   } break;
   case lifi_tclToken::EN_MSG_GETELEMENTCOUNTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32,lifi_tclSemanticDomain::EN_MSG_COUNT));
   } break;
   case lifi_tclToken::EN_MSG_GETELEMENTNAMELISTMETHODSTART:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_METER,lifi_tclSemanticDomain::EN_MSG_MAXRADIUS));
      }
      if (15 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32,lifi_tclSemanticDomain::EN_MSG_NOMATCHINGCHARS));
      }
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_ATTRIBUTECODES));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32,lifi_tclSemanticDomain::EN_MSG_LISTOFFSET));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B8_LISTSORTOPTIONS,lifi_tclSemanticDomain::EN_MSG_SORTOPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B8_LISTGETOPTIONS,lifi_tclSemanticDomain::EN_MSG_GETOPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32,lifi_tclSemanticDomain::EN_MSG_LIMIT));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETELEMENTNAMELISTMETHODRESULT:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      }
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONVALUELISTUNION,lifi_tclSemanticDomain::EN_MSG_ELEMENTLIST));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B8_LISTRESULTOPTIONS,lifi_tclSemanticDomain::EN_MSG_RESULTOPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETSPELLERCHARACTERSMETHODSTART:
   {
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_BOOL,lifi_tclSemanticDomain::EN_MSG_LOWERCASELETTERS));
      }
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_BOOL,lifi_tclSemanticDomain::EN_MSG_PARTIALNAMEROTATION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_ATTRIBUTECODES));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETSPELLERCHARACTERSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_MSG_MATCHINGELEMENTS));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_BOOL,lifi_tclSemanticDomain::EN_MSG_FULLMATCH));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_MSG_VALIDCHARACTERS));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_MSG_UNIQUECHARACTERS));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETDETAILEDELEMENTDESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETDETAILEDELEMENTDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_DESCRIPTIONS));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETATTRIBUTEHIERARCHYMETHODSTART:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETATTRIBUTEHIERARCHYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_FILTERATTRIBUTE,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_LIST));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETAVAILABLEUILANGUAGESMETHODSTART:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
   } break;
   case lifi_tclToken::EN_MSG_GETAVAILABLEUILANGUAGESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_LANGUAGELIST));
   } break;
   case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOSMETHODSTART:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_MSG_LOCATIONBINCONTAINERVERSION));
      }
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_TRANSFORMMODE,lifi_tclSemanticDomain::EN_MSG_MODE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_MSG_TRANSFORMEDPOSITION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETALLSPELLERCHARACTERSMETHODSTART:
   {
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_BOOL,lifi_tclSemanticDomain::EN_MSG_LOWERCASELETTERS));
      }
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_ATTRIBUTECODES));
      }
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      }
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
   } break;
   case lifi_tclToken::EN_MSG_GETALLSPELLERCHARACTERSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_MSG_VALIDCHARACTERS));
   } break;
   case lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODSTART:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
   } break;
   case lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_SELECTIONCRITERIALIST));
   } break;
   case lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODSTART:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_METER,lifi_tclSemanticDomain::EN_MSG_MAXRADIUS));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONVALUELISTUNION,lifi_tclSemanticDomain::EN_MSG_ELEMENTLIST));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_ADDRESSTEMPLATE,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_MSG_TEMPLATES));
   } break;
   case lifi_tclToken::EN_MSG_DESTINATIONINPUTINPROGRESSSTATUS:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_BOOL,lifi_tclSemanticDomain::EN_MSG_DESTINATIONINPUTISINPROGRESS));
   } break;
   case lifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case lifi_tclToken::EN_MSG_USEDDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32_DATASETID,lifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32_MEDIAID,lifi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSSTATUS:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTION,lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      }
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONVALUELISTUNION,lifi_tclSemanticDomain::EN_MSG_ELEMENTLIST));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOLANGUAGECODE,lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_METER,lifi_tclSemanticDomain::EN_MSG_RADIUS));
   } break;
   case lifi_tclToken::EN_BINCONTAINER:
   case lifi_tclToken::EN_RESERVED:
   case lifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case lifi_tclToken::EN_S32_METER:
   case lifi_tclToken::EN_S16_CENTIMETERSECOND:
   case lifi_tclToken::EN_FIVERSION:
   case lifi_tclToken::EN_S32_LONGITUDE:
   case lifi_tclToken::EN_S32_LATITUDE:
   case lifi_tclToken::EN_POSITIONWGS84:
   case lifi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case lifi_tclToken::EN_E16_ISOLANGUAGECODE:
   case lifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case lifi_tclToken::EN_E8_BINCONTAINERTYPES:
   case lifi_tclToken::EN_B16_POSITIONRELIABILITY:
   case lifi_tclToken::EN_POSITIONHEADINGSPEED:
   case lifi_tclToken::EN_U32_DATASETID:
   case lifi_tclToken::EN_U32_MEDIAID:
   case lifi_tclToken::EN_NAVCLUSTERDESC:
   case lifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case lifi_tclToken::EN_NAVONECELLDESC:
   case lifi_tclToken::EN_E8_SIDEINFO:
   case lifi_tclToken::EN_S32_EMU:
   case lifi_tclToken::EN_NAVZEROCELLDESC:
   case lifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   case lifi_tclToken::EN_NAVLOCATIONDESC:
   case lifi_tclToken::EN_NAVLOCATIONDESCUNION0:
   case lifi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   case lifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   case lifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   case lifi_tclToken::EN_NAVLOCATIONDATADESC:
   case lifi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   case lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   case lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   case lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   case lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   case lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   case lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   case lifi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   case lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   case lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   case lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   case lifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   case lifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   case lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   case lifi_tclToken::EN_ADDRESSTEMPLATE:
   case lifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   case lifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   case lifi_tclToken::EN_LOCATIONDESCRIPTOR:
   case lifi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   case lifi_tclToken::EN_LOCATIONDESCRIPTION:
   case lifi_tclToken::EN_STRINGPOSITION:
   case lifi_tclToken::EN_STRINGID:
   case lifi_tclToken::EN_FLISTRING:
   case lifi_tclToken::EN_B8_POSITIONSTATUS:
   case lifi_tclToken::EN_LISTOFPOSITIONS:
   case lifi_tclToken::EN_E8_FILTERATTRIBUTETYPE:
   case lifi_tclToken::EN_FILTERATTRIBUTE:
   case lifi_tclToken::EN_E8_LOCATIONVALUELISTTYPE:
   case lifi_tclToken::EN_B8_LISTRESULTOPTIONS:
   case lifi_tclToken::EN_B8_LISTGETOPTIONS:
   case lifi_tclToken::EN_LOCATIONVALUELISTUNION:
   case lifi_tclToken::EN_LOCATIONVALUELISTUNIONUNION0:
   case lifi_tclToken::EN_B16_ELEMENTPROPERTIES:
   case lifi_tclToken::EN_STRINGELEMENT:
   case lifi_tclToken::EN_STRINGLIST:
   case lifi_tclToken::EN_STRINGDESCRIPTIONELEMENT:
   case lifi_tclToken::EN_STRINGDESCRIPTIONLIST:
   case lifi_tclToken::EN_STRINGIDELEMENT:
   case lifi_tclToken::EN_STRINGIDLIST:
   case lifi_tclToken::EN_POSITIONWGS84ELEMENT:
   case lifi_tclToken::EN_POSITIONWGS84LIST:
   case lifi_tclToken::EN_STRINGPOSITIONELEMENT:
   case lifi_tclToken::EN_STRINGPOSITIONLIST:
   case lifi_tclToken::EN_STRINGPOSITIONDESCRIPTIONELEMENT:
   case lifi_tclToken::EN_STRINGPOSITIONDESCRIPTIONLIST:
   case lifi_tclToken::EN_B8_CRITERIONSTATUS:
   case lifi_tclToken::EN_B8_LISTSORTOPTIONS:
   case lifi_tclToken::EN_SELECTIONCRITERIONDESCRIPTION:
   case lifi_tclToken::EN_B8_CRITERIAGETOPTIONS:
   case lifi_tclToken::EN_SELECTABLECRITERION:
   case lifi_tclToken::EN_E8_TRANSFORMMODE:
   case lifi_tclToken::EN_U8:   
   case lifi_tclToken::EN_S8:   
   case lifi_tclToken::EN_U16:   
   case lifi_tclToken::EN_S16:   
   case lifi_tclToken::EN_U24:   
   case lifi_tclToken::EN_S24:   
   case lifi_tclToken::EN_U32:   
   case lifi_tclToken::EN_S32:   
   case lifi_tclToken::EN_U64:   
   case lifi_tclToken::EN_S64:   
   case lifi_tclToken::EN_F32:   
   case lifi_tclToken::EN_F64:   
   case lifi_tclToken::EN_BOOL:   
   case lifi_tclToken::EN_STRING:   
   case lifi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(lifi_tclKnot(enMsgToken,lifi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool lifi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool lifi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      lifi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      lifi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      lifi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == lifi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(lifi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(lifi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(lifi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case lifi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == lifi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case lifi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            lifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(lifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            lifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(lifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case lifi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case lifi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case lifi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIADESCRIPTIONMETHODSTART:
   case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIADESCRIPTIONMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIAMETHODSTART:
   case lifi_tclToken::EN_MSG_GETSELECTIONCRITERIAMETHODRESULT:
   case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMETHODSTART:
   case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETELEMENTCOUNTMETHODSTART:
   case lifi_tclToken::EN_MSG_GETELEMENTCOUNTMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETELEMENTNAMELISTMETHODSTART:
   case lifi_tclToken::EN_MSG_GETELEMENTNAMELISTMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETSPELLERCHARACTERSMETHODSTART:
   case lifi_tclToken::EN_MSG_GETSPELLERCHARACTERSMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETDETAILEDELEMENTDESCRIPTIONMETHODSTART:
   case lifi_tclToken::EN_MSG_GETDETAILEDELEMENTDESCRIPTIONMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETATTRIBUTEHIERARCHYMETHODSTART:
   case lifi_tclToken::EN_MSG_GETATTRIBUTEHIERARCHYMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETAVAILABLEUILANGUAGESMETHODSTART:
   case lifi_tclToken::EN_MSG_GETAVAILABLEUILANGUAGESMETHODRESULT:
   case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOSMETHODSTART:
   case lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOSMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETALLSPELLERCHARACTERSMETHODSTART:
   case lifi_tclToken::EN_MSG_GETALLSPELLERCHARACTERSMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODSTART:
   case lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODSTART:
   case lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODRESULT:
   case lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODSTART:
   case lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODRESULT:
   case lifi_tclToken::EN_MSG_DESTINATIONINPUTINPROGRESSGET:
   case lifi_tclToken::EN_MSG_DESTINATIONINPUTINPROGRESSSTATUS:
   case lifi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case lifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case lifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case lifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   case lifi_tclToken::EN_MSG_USEDDATASETGET:
   case lifi_tclToken::EN_MSG_USEDDATASETUPREG:
   case lifi_tclToken::EN_MSG_USEDDATASETRELUPREG:
   case lifi_tclToken::EN_MSG_USEDDATASETSTATUS:
   case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSGET:
   case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSUPREG:
   case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSRELUPREG:
   case lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSSTATUS:
      bInitMessage(enToken);
      break;
   case lifi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U8,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U8,lifi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U8,lifi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U8,lifi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_LATITUDE,lifi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_LONGITUDE,lifi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_B16_POSITIONRELIABILITY:
   {
      fi_tcl_b16_PositionReliability o_b16_PositionReliability;
      if (!bDoIt(o_b16_PositionReliability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_POSITIONHEADINGSPEED:
   {
      if (poVisitor->bDoExpand_PositionHeadingSpeed(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U8_DIRECTIONABSOLUTE,lifi_tclSemanticDomain::EN_HEADING));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S16_CENTIMETERSECOND,lifi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B16_POSITIONRELIABILITY,lifi_tclSemanticDomain::EN_POSITIONRELIABILITY));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_POSITIONWGS84));
      }
      else
      {
         fi_tcl_PositionHeadingSpeed o_PositionHeadingSpeed;
         if (!bDoIt(o_PositionHeadingSpeed))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_U32_MEDIAID:
   {
      fi_tcl_u32_MediaId o_u32_MediaId;
      if (!bDoIt(o_u32_MediaId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32,lifi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U8,lifi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16_INDEXINREFERENCELIST,lifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_NAVONECELLDIRECTION,lifi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E8_SIDEINFO:
   {
      fi_tcl_e8_SideInfo o_e8_SideInfo;
      if (!bDoIt(o_e8_SideInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_S32_EMU:
   {
      fi_tcl_s32_EMU o_s32_EMU;
      if (!bDoIt(o_s32_EMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_NAVZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16_INDEXINREFERENCELIST,lifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_ZEROCELLID));
      }
      else
      {
         fi_tcl_NavZeroCellDesc o_NavZeroCellDesc;
         if (!bDoIt(o_NavZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   {
      fi_tcl_e8_NavLocationDescType o_e8_NavLocationDescType;
      if (!bDoIt(o_e8_NavLocationDescType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_NAVLOCATIONDESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationDescType oDataType;
      oCallStack.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE,lifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_RESERVED,lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVLOCATIONDATADESC,lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE,lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON,lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      }
   } break;
   case lifi_tclToken::EN_NAVLOCATIONDESC:
   {
      if (poVisitor->bDoExpand_NavLocationDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVLOCATIONDESCUNION0,lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
      }
      else
      {
         fi_tcl_NavLocationDesc o_NavLocationDesc;
         if (!bDoIt(o_NavLocationDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case lifi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavLocationBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVLOCATIONDESC,lifi_tclSemanticDomain::EN_CONTAINERDATA));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_BINCONTAINERTYPES,lifi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_FIVERSION,lifi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32,lifi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavLocationBinContainer o_NavLocationBinContainer;
         if (!bDoIt(o_NavLocationBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case lifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   {
      fi_tcl_e8_NavIndexZFDestinationType o_e8_NavIndexZFDestinationType;
      if (!bDoIt(o_e8_NavIndexZFDestinationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   {
      fi_tcl_e8_NavLocationNavDataType o_e8_NavLocationNavDataType;
      if (!bDoIt(o_e8_NavLocationNavDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationNavDataType oDataType;
      oCallStack.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE,lifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_RESERVED,lifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET,lifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET,lifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET,lifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      }
   } break;
   case lifi_tclToken::EN_NAVLOCATIONDATADESC:
   {
      if (poVisitor->bDoExpand_NavLocationDataDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVLOCATIONDATADESCUNION0,lifi_tclSemanticDomain::EN_NAVDATATYPE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_ACCESSPOINTREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_OBJECTPOINTREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE,lifi_tclSemanticDomain::EN_INDEXZFDESTTYPE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32_DATASETID,lifi_tclSemanticDomain::EN_NAVDATASETID));
      }
      else
      {
         fi_tcl_NavLocationDataDesc o_NavLocationDataDesc;
         if (!bDoIt(o_NavLocationDataDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16_INDEXINREFERENCELIST,lifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16_INDEXINREFERENCELIST,lifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_DECISIONPOINT));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_EMU,lifi_tclSemanticDomain::EN_DESTDISTANCE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_EMU,lifi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_EMU,lifi_tclSemanticDomain::EN_FROMZEROCELLTOSPOTLENGTH));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_SIDEINFO,lifi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellProperty o_NavSpotDestinationOneCellProperty;
         if (!bDoIt(o_NavSpotDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY,lifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVONECELLDESC,lifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellDesc o_NavSpotDestinationOneCellDesc;
         if (!bDoIt(o_NavSpotDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_SPOTDESTINATIONONECELLREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVCLUSTERDESC,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellListSet o_NavSpotDestinationOneCellListSet;
         if (!bDoIt(o_NavSpotDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16_INDEXINREFERENCELIST,lifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16_INDEXINREFERENCELIST,lifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_SIDEINFO,lifi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellProperty o_NavStreetDestinationOneCellProperty;
         if (!bDoIt(o_NavStreetDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY,lifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVONECELLDESC,lifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellDesc o_NavStreetDestinationOneCellDesc;
         if (!bDoIt(o_NavStreetDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_STREETDESTINATIONONECELLREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVCLUSTERDESC,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellListSet o_NavStreetDestinationOneCellListSet;
         if (!bDoIt(o_NavStreetDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   {
      fi_tcl_e8_NavIntersectionType o_e8_NavIntersectionType;
      if (!bDoIt(o_e8_NavIntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16_INDEXINREFERENCELIST,lifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16_INDEXINREFERENCELIST,lifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_NAVINTERSECTIONTYPE,lifi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellProperty o_NavIntersectionDestinationZeroCellProperty;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY,lifi_tclSemanticDomain::EN_ZEROCELLPROPERTY));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVZEROCELLDESC,lifi_tclSemanticDomain::EN_ZEROCELLDESC));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellDesc o_NavIntersectionDestinationZeroCellDesc;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_INTERSECTIONDESTINATIONZEROCELLREFLIST));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVCLUSTERDESC,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellListSet o_NavIntersectionDestinationZeroCellListSet;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionCircle(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_COORDINATE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_S32_METER,lifi_tclSemanticDomain::EN_RADIUS));
      }
      else
      {
         fi_tcl_NavAreaDescriptionCircle o_NavAreaDescriptionCircle;
         if (!bDoIt(o_NavAreaDescriptionCircle))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionPolygon(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_COORDINATELIST));
      }
      else
      {
         fi_tcl_NavAreaDescriptionPolygon o_NavAreaDescriptionPolygon;
         if (!bDoIt(o_NavAreaDescriptionPolygon))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   {
      fi_tcl_e16_SelectionCriterionType o_e16_SelectionCriterionType;
      if (!bDoIt(o_e16_SelectionCriterionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_ADDRESSTEMPLATE:
   {
      if (poVisitor->bDoExpand_AddressTemplate(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_SELECTIONCRITERIA));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_ISOCOUNTRYCODE,lifi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_AddressTemplate o_AddressTemplate;
         if (!bDoIt(o_AddressTemplate))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AddressTemplate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AddressTemplate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   {
      fi_tcl_e8_LocationDescriptionDataType o_e8_LocationDescriptionDataType;
      if (!bDoIt(o_e8_LocationDescriptionDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   {
      fi_tcl_b8_LocationDescriptorStatus o_b8_LocationDescriptorStatus;
      if (!bDoIt(o_b8_LocationDescriptorStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LocationDescriptionDataType oDataType;
      oCallStack.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE,lifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS) &&
          !(17 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING) &&
          !(11 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_RESERVED,lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGID,lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONHEADINGSPEED,lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         #ifndef FI_S_EXTERNAL_FI
         if (bUseSpecialBinContainer)
         {
            oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_NAVLOCATIONBINCONTAINER,lifi_tclSemanticDomain::EN_DATA));
         }
         else
         #endif // FI_S_EXTERNAL_FI
         {
            oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_BINCONTAINER,lifi_tclSemanticDomain::EN_DATA));
         }
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGPOSITION,lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_FLISTRING,lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LISTOFPOSITIONS,lifi_tclSemanticDomain::EN_DATA));
         break;
      }
   } break;
   case lifi_tclToken::EN_LOCATIONDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_LocationDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS,lifi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTORUNION0,lifi_tclSemanticDomain::EN_DATA));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,lifi_tclSemanticDomain::EN_SELECTIONCRITERION));
      }
      else
      {
         fi_tcl_LocationDescriptor o_LocationDescriptor;
         if (!bDoIt(o_LocationDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_LOCATIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_LocationDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONDESCRIPTOR,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_DESCRIPTORS));
      }
      else
      {
         fi_tcl_LocationDescription o_LocationDescription;
         if (!bDoIt(o_LocationDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGPOSITION:
   {
      if (poVisitor->bDoExpand_StringPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringPosition o_StringPosition;
         if (!bDoIt(o_StringPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGID:
   {
      if (poVisitor->bDoExpand_StringID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32,lifi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringID o_StringID;
         if (!bDoIt(o_StringID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_FLISTRING:
   {
      if (poVisitor->bDoExpand_FLIString(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_FLIString o_FLIString;
         if (!bDoIt(o_FLIString))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_B8_POSITIONSTATUS:
   {
      fi_tcl_b8_PositionStatus o_b8_PositionStatus;
      if (!bDoIt(o_b8_PositionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_LISTOFPOSITIONS:
   {
      if (poVisitor->bDoExpand_ListOfPositions(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_CURRENTPOSITION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U32,lifi_tclSemanticDomain::EN_ID));
         if (26 <= u16MajorVersion)
         {
            oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B8_POSITIONSTATUS,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_POSITIONSTATI));
         }
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_POSITIONS));
      }
      else
      {
         fi_tcl_ListOfPositions o_ListOfPositions;
         if (!bDoIt(o_ListOfPositions))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E8_FILTERATTRIBUTETYPE:
   {
      fi_tcl_e8_FilterAttributeType o_e8_FilterAttributeType;
      if (!bDoIt(o_e8_FilterAttributeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_FILTERATTRIBUTE:
   {
      if (poVisitor->bDoExpand_FilterAttribute(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_CODE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_FILTERATTRIBUTETYPE,lifi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_FilterAttribute o_FilterAttribute;
         if (!bDoIt(o_FilterAttribute))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FilterAttribute.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FilterAttribute.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E8_LOCATIONVALUELISTTYPE:
   {
      fi_tcl_e8_LocationValueListType o_e8_LocationValueListType;
      if (!bDoIt(o_e8_LocationValueListType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_B8_LISTRESULTOPTIONS:
   {
      fi_tcl_b8_ListResultOptions o_b8_ListResultOptions;
      if (!bDoIt(o_b8_ListResultOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_B8_LISTGETOPTIONS:
   {
      fi_tcl_b8_ListGetOptions o_b8_ListGetOptions;
      if (!bDoIt(o_b8_ListGetOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_LOCATIONVALUELISTUNIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LocationValueListType oDataType;
      oCallStack.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_LOCATIONVALUELISTTYPE,lifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_RESERVED,lifi_tclSemanticDomain::EN_VALUELIST));
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGLIST,lifi_tclSemanticDomain::EN_VALUELIST));
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGDESCRIPTIONLIST,lifi_tclSemanticDomain::EN_VALUELIST));
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGIDLIST,lifi_tclSemanticDomain::EN_VALUELIST));
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84LIST,lifi_tclSemanticDomain::EN_VALUELIST));
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGPOSITIONLIST,lifi_tclSemanticDomain::EN_VALUELIST));
         break;
      case fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGPOSITIONDESCRIPTIONLIST,lifi_tclSemanticDomain::EN_VALUELIST));
         break;
      }
   } break;
   case lifi_tclToken::EN_LOCATIONVALUELISTUNION:
   {
      if (poVisitor->bDoExpand_LocationValueListUnion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LOCATIONVALUELISTUNIONUNION0,lifi_tclSemanticDomain::EN_VALUELIST));
      }
      else
      {
         fi_tcl_LocationValueListUnion o_LocationValueListUnion;
         if (!bDoIt(o_LocationValueListUnion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationValueListUnion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationValueListUnion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_B16_ELEMENTPROPERTIES:
   {
      fi_tcl_b16_ElementProperties o_b16_ElementProperties;
      if (!bDoIt(o_b16_ElementProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_STRINGELEMENT:
   {
      if (poVisitor->bDoExpand_StringElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_STRING));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B16_ELEMENTPROPERTIES,lifi_tclSemanticDomain::EN_PROPERTIES));
      }
      else
      {
         fi_tcl_StringElement o_StringElement;
         if (!bDoIt(o_StringElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGLIST:
   {
      if (poVisitor->bDoExpand_StringList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGELEMENT,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_STRINGLIST));
      }
      else
      {
         fi_tcl_StringList o_StringList;
         if (!bDoIt(o_StringList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGDESCRIPTIONELEMENT:
   {
      if (poVisitor->bDoExpand_StringDescriptionElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_DESCRIPTIONSTRING));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_ELEMENTSTRING));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B16_ELEMENTPROPERTIES,lifi_tclSemanticDomain::EN_PROPERTIES));
      }
      else
      {
         fi_tcl_StringDescriptionElement o_StringDescriptionElement;
         if (!bDoIt(o_StringDescriptionElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringDescriptionElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringDescriptionElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGDESCRIPTIONLIST:
   {
      if (poVisitor->bDoExpand_StringDescriptionList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGDESCRIPTIONELEMENT,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_STRINGDESCRIPTIONLIST));
      }
      else
      {
         fi_tcl_StringDescriptionList o_StringDescriptionList;
         if (!bDoIt(o_StringDescriptionList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringDescriptionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringDescriptionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGIDELEMENT:
   {
      if (poVisitor->bDoExpand_StringIDElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGID,lifi_tclSemanticDomain::EN_STRINGID));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B16_ELEMENTPROPERTIES,lifi_tclSemanticDomain::EN_PROPERTIES));
      }
      else
      {
         fi_tcl_StringIDElement o_StringIDElement;
         if (!bDoIt(o_StringIDElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringIDElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringIDElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGIDLIST:
   {
      if (poVisitor->bDoExpand_StringIDList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGIDELEMENT,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_STRINGIDLIST));
      }
      else
      {
         fi_tcl_StringIDList o_StringIDList;
         if (!bDoIt(o_StringIDList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringIDList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringIDList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_POSITIONWGS84ELEMENT:
   {
      if (poVisitor->bDoExpand_PositionWGS84Element(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84,lifi_tclSemanticDomain::EN_POSITIONWGS84));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B16_ELEMENTPROPERTIES,lifi_tclSemanticDomain::EN_PROPERTIES));
      }
      else
      {
         fi_tcl_PositionWGS84Element o_PositionWGS84Element;
         if (!bDoIt(o_PositionWGS84Element))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84Element.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84Element.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_POSITIONWGS84LIST:
   {
      if (poVisitor->bDoExpand_PositionWGS84List(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_POSITIONWGS84ELEMENT,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_POSITIONWGS84LIST));
      }
      else
      {
         fi_tcl_PositionWGS84List o_PositionWGS84List;
         if (!bDoIt(o_PositionWGS84List))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGPOSITIONELEMENT:
   {
      if (poVisitor->bDoExpand_StringPositionElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGPOSITION,lifi_tclSemanticDomain::EN_STRINGPOSITION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B16_ELEMENTPROPERTIES,lifi_tclSemanticDomain::EN_PROPERTIES));
      }
      else
      {
         fi_tcl_StringPositionElement o_StringPositionElement;
         if (!bDoIt(o_StringPositionElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPositionElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPositionElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGPOSITIONLIST:
   {
      if (poVisitor->bDoExpand_StringPositionList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGPOSITIONELEMENT,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_STRINGPOSITIONLIST));
      }
      else
      {
         fi_tcl_StringPositionList o_StringPositionList;
         if (!bDoIt(o_StringPositionList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPositionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPositionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGPOSITIONDESCRIPTIONELEMENT:
   {
      if (poVisitor->bDoExpand_StringPositionDescriptionElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_DESCRIPTIONSTRING));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGPOSITION,lifi_tclSemanticDomain::EN_ELEMENTSTRINGPOSITION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B16_ELEMENTPROPERTIES,lifi_tclSemanticDomain::EN_PROPERTIES));
      }
      else
      {
         fi_tcl_StringPositionDescriptionElement o_StringPositionDescriptionElement;
         if (!bDoIt(o_StringPositionDescriptionElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPositionDescriptionElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPositionDescriptionElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_STRINGPOSITIONDESCRIPTIONLIST:
   {
      if (poVisitor->bDoExpand_StringPositionDescriptionList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRINGPOSITIONDESCRIPTIONELEMENT,lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_LIST,lifi_tclSemanticDomain::EN_STRINGPOSITIONDESCRIPTIONLIST));
      }
      else
      {
         fi_tcl_StringPositionDescriptionList o_StringPositionDescriptionList;
         if (!bDoIt(o_StringPositionDescriptionList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPositionDescriptionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPositionDescriptionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_B8_CRITERIONSTATUS:
   {
      fi_tcl_b8_CriterionStatus o_b8_CriterionStatus;
      if (!bDoIt(o_b8_CriterionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_B8_LISTSORTOPTIONS:
   {
      fi_tcl_b8_ListSortOptions o_b8_ListSortOptions;
      if (!bDoIt(o_b8_ListSortOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_SELECTIONCRITERIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_SelectionCriterionDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_STRING,lifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,lifi_tclSemanticDomain::EN_SELECTIONCRITERION));
      }
      else
      {
         fi_tcl_SelectionCriterionDescription o_SelectionCriterionDescription;
         if (!bDoIt(o_SelectionCriterionDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SelectionCriterionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SelectionCriterionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_B8_CRITERIAGETOPTIONS:
   {
      fi_tcl_b8_CriteriaGetOptions o_b8_CriteriaGetOptions;
      if (!bDoIt(o_b8_CriteriaGetOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case lifi_tclToken::EN_SELECTABLECRITERION:
   {
      if (poVisitor->bDoExpand_SelectableCriterion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_END_OF_STRUCT,lifi_tclSemanticDomain::EN_UNKNOWN));
         if (19 <= u16MajorVersion)
         {
            oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_U16,lifi_tclSemanticDomain::EN_NUMOFPOI));
         }
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B8_CRITERIONSTATUS,lifi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_BOOL,lifi_tclSemanticDomain::EN_ATTRIBUTESAVAILABLE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_B8_LISTSORTOPTIONS,lifi_tclSemanticDomain::EN_SORTOPTION));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE,lifi_tclSemanticDomain::EN_DATATYPE));
         oPath.bGoDown(lifi_tclKnot(lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,lifi_tclSemanticDomain::EN_SELECTIONCRITERION));
      }
      else
      {
         fi_tcl_SelectableCriterion o_SelectableCriterion;
         if (!bDoIt(o_SelectableCriterion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SelectableCriterion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SelectableCriterion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case lifi_tclToken::EN_E8_TRANSFORMMODE:
   {
      fi_tcl_e8_TransformMode o_e8_TransformMode;
      if (!bDoIt(o_e8_TransformMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
      case lifi_tclToken::EN_UNKNOWN:
      case lifi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

