/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef INTWDBFITYPES_HEADER
#define INTWDBFITYPES_HEADER

// #include <vector>
// 


class intwdbfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class intwdbfi_tclMsgDataAvailabilityChangedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgDataAvailabilityChangedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgDataAvailabilityChangedGet& operator=(const intwdbfi_tclMsgDataAvailabilityChangedGet& coRef);
   intwdbfi_tclMsgDataAvailabilityChangedGet(const intwdbfi_tclMsgDataAvailabilityChangedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgDataAvailabilityChangedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDGET;}
};

class intwdbfi_tclMsgDataAvailabilityChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgDataAvailabilityChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgDataAvailabilityChangedUpReg& operator=(const intwdbfi_tclMsgDataAvailabilityChangedUpReg& coRef);
   intwdbfi_tclMsgDataAvailabilityChangedUpReg(const intwdbfi_tclMsgDataAvailabilityChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgDataAvailabilityChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDUPREG;}
};

class intwdbfi_tclMsgDataAvailabilityChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgDataAvailabilityChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgDataAvailabilityChangedRelUpReg& operator=(const intwdbfi_tclMsgDataAvailabilityChangedRelUpReg& coRef);
   intwdbfi_tclMsgDataAvailabilityChangedRelUpReg(const intwdbfi_tclMsgDataAvailabilityChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgDataAvailabilityChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDRELUPREG;}
};

class intwdbfi_tclMsgDataAvailabilityChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgDataAvailabilityChangedStatus():DataAvailable(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgDataAvailabilityChangedStatus& operator=(const intwdbfi_tclMsgDataAvailabilityChangedStatus& coRef);
   intwdbfi_tclMsgDataAvailabilityChangedStatus(const intwdbfi_tclMsgDataAvailabilityChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool DataAvailable;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgDataAvailabilityChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDSTATUS;}
};

class intwdbfi_tclMsgWeatherDataChangedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgWeatherDataChangedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgWeatherDataChangedGet& operator=(const intwdbfi_tclMsgWeatherDataChangedGet& coRef);
   intwdbfi_tclMsgWeatherDataChangedGet(const intwdbfi_tclMsgWeatherDataChangedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgWeatherDataChangedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDGET;}
};

class intwdbfi_tclMsgWeatherDataChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgWeatherDataChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgWeatherDataChangedUpReg& operator=(const intwdbfi_tclMsgWeatherDataChangedUpReg& coRef);
   intwdbfi_tclMsgWeatherDataChangedUpReg(const intwdbfi_tclMsgWeatherDataChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgWeatherDataChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDUPREG;}
};

class intwdbfi_tclMsgWeatherDataChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgWeatherDataChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgWeatherDataChangedRelUpReg& operator=(const intwdbfi_tclMsgWeatherDataChangedRelUpReg& coRef);
   intwdbfi_tclMsgWeatherDataChangedRelUpReg(const intwdbfi_tclMsgWeatherDataChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgWeatherDataChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDRELUPREG;}
};

class intwdbfi_tclMsgWeatherDataChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgWeatherDataChangedStatus():WeatherProtocol(),BlockId(0),SubId(0),SubstantialChange(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgWeatherDataChangedStatus& operator=(const intwdbfi_tclMsgWeatherDataChangedStatus& coRef);
   intwdbfi_tclMsgWeatherDataChangedStatus(const intwdbfi_tclMsgWeatherDataChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_WeatherProtocol WeatherProtocol;
   tU32 BlockId;
   tU32 SubId;
   tBool SubstantialChange;
   std::vector<fi_tcl_VersionPerForecast, std::allocator<fi_tcl_VersionPerForecast> > VersionsForForecasts;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > JustWrittenTiles;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > UsedTiles;
   std::vector<fi_tcl_VersionsOfTile, std::allocator<fi_tcl_VersionsOfTile> > BackgroundTiles;
   std::vector<fi_tcl_StatesAndAreasPerLanguage, std::allocator<fi_tcl_StatesAndAreasPerLanguage> > StatesAndAreasPerLanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgWeatherDataChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDSTATUS;}
};

class intwdbfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgEngineeringTextGet& operator=(const intwdbfi_tclMsgEngineeringTextGet& coRef);
   intwdbfi_tclMsgEngineeringTextGet(const intwdbfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class intwdbfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgEngineeringTextUpReg& operator=(const intwdbfi_tclMsgEngineeringTextUpReg& coRef);
   intwdbfi_tclMsgEngineeringTextUpReg(const intwdbfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class intwdbfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgEngineeringTextRelUpReg& operator=(const intwdbfi_tclMsgEngineeringTextRelUpReg& coRef);
   intwdbfi_tclMsgEngineeringTextRelUpReg(const intwdbfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class intwdbfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intwdbfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intwdbfi_tclMsgEngineeringTextStatus& operator=(const intwdbfi_tclMsgEngineeringTextStatus& coRef);
   intwdbfi_tclMsgEngineeringTextStatus(const intwdbfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intwdbfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
