/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgDataAvailabilityChangedGet::intwdbfi_tclMsgDataAvailabilityChangedGet(const intwdbfi_tclMsgDataAvailabilityChangedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgDataAvailabilityChangedGet& intwdbfi_tclMsgDataAvailabilityChangedGet::operator=(const intwdbfi_tclMsgDataAvailabilityChangedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgDataAvailabilityChangedGet::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgDataAvailabilityChangedGet::u16GetFunctionID() const {return INTWDBFI_C_U16_DATAAVAILABILITYCHANGED;}
tU8 intwdbfi_tclMsgDataAvailabilityChangedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intwdbfi_tclMsgDataAvailabilityChangedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgDataAvailabilityChangedGet::operator==(const intwdbfi_tclMsgDataAvailabilityChangedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgDataAvailabilityChangedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgDataAvailabilityChangedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgDataAvailabilityChangedUpReg::intwdbfi_tclMsgDataAvailabilityChangedUpReg(const intwdbfi_tclMsgDataAvailabilityChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgDataAvailabilityChangedUpReg& intwdbfi_tclMsgDataAvailabilityChangedUpReg::operator=(const intwdbfi_tclMsgDataAvailabilityChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgDataAvailabilityChangedUpReg::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgDataAvailabilityChangedUpReg::u16GetFunctionID() const {return INTWDBFI_C_U16_DATAAVAILABILITYCHANGED;}
tU8 intwdbfi_tclMsgDataAvailabilityChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 intwdbfi_tclMsgDataAvailabilityChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgDataAvailabilityChangedUpReg::operator==(const intwdbfi_tclMsgDataAvailabilityChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgDataAvailabilityChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgDataAvailabilityChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::intwdbfi_tclMsgDataAvailabilityChangedRelUpReg(const intwdbfi_tclMsgDataAvailabilityChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgDataAvailabilityChangedRelUpReg& intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::operator=(const intwdbfi_tclMsgDataAvailabilityChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::u16GetFunctionID() const {return INTWDBFI_C_U16_DATAAVAILABILITYCHANGED;}
tU8 intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::operator==(const intwdbfi_tclMsgDataAvailabilityChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgDataAvailabilityChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgDataAvailabilityChangedStatus::intwdbfi_tclMsgDataAvailabilityChangedStatus(const intwdbfi_tclMsgDataAvailabilityChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataAvailable = coRef.DataAvailable;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgDataAvailabilityChangedStatus& intwdbfi_tclMsgDataAvailabilityChangedStatus::operator=(const intwdbfi_tclMsgDataAvailabilityChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   DataAvailable = coRef.DataAvailable;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgDataAvailabilityChangedStatus::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgDataAvailabilityChangedStatus::u16GetFunctionID() const {return INTWDBFI_C_U16_DATAAVAILABILITYCHANGED;}
tU8 intwdbfi_tclMsgDataAvailabilityChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intwdbfi_tclMsgDataAvailabilityChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool intwdbfi_tclMsgDataAvailabilityChangedStatus::operator==(const intwdbfi_tclMsgDataAvailabilityChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataAvailable == rfoCmp.DataAvailable);
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgDataAvailabilityChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DataAvailable;
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgDataAvailabilityChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataAvailable;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgWeatherDataChangedGet::intwdbfi_tclMsgWeatherDataChangedGet(const intwdbfi_tclMsgWeatherDataChangedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgWeatherDataChangedGet& intwdbfi_tclMsgWeatherDataChangedGet::operator=(const intwdbfi_tclMsgWeatherDataChangedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgWeatherDataChangedGet::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgWeatherDataChangedGet::u16GetFunctionID() const {return INTWDBFI_C_U16_WEATHERDATACHANGED;}
tU8 intwdbfi_tclMsgWeatherDataChangedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intwdbfi_tclMsgWeatherDataChangedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgWeatherDataChangedGet::operator==(const intwdbfi_tclMsgWeatherDataChangedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgWeatherDataChangedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgWeatherDataChangedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgWeatherDataChangedUpReg::intwdbfi_tclMsgWeatherDataChangedUpReg(const intwdbfi_tclMsgWeatherDataChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgWeatherDataChangedUpReg& intwdbfi_tclMsgWeatherDataChangedUpReg::operator=(const intwdbfi_tclMsgWeatherDataChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgWeatherDataChangedUpReg::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgWeatherDataChangedUpReg::u16GetFunctionID() const {return INTWDBFI_C_U16_WEATHERDATACHANGED;}
tU8 intwdbfi_tclMsgWeatherDataChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 intwdbfi_tclMsgWeatherDataChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgWeatherDataChangedUpReg::operator==(const intwdbfi_tclMsgWeatherDataChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgWeatherDataChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgWeatherDataChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgWeatherDataChangedRelUpReg::intwdbfi_tclMsgWeatherDataChangedRelUpReg(const intwdbfi_tclMsgWeatherDataChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgWeatherDataChangedRelUpReg& intwdbfi_tclMsgWeatherDataChangedRelUpReg::operator=(const intwdbfi_tclMsgWeatherDataChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgWeatherDataChangedRelUpReg::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgWeatherDataChangedRelUpReg::u16GetFunctionID() const {return INTWDBFI_C_U16_WEATHERDATACHANGED;}
tU8 intwdbfi_tclMsgWeatherDataChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 intwdbfi_tclMsgWeatherDataChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgWeatherDataChangedRelUpReg::operator==(const intwdbfi_tclMsgWeatherDataChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgWeatherDataChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgWeatherDataChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgWeatherDataChangedStatus::intwdbfi_tclMsgWeatherDataChangedStatus(const intwdbfi_tclMsgWeatherDataChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   WeatherProtocol = coRef.WeatherProtocol;
   BlockId = coRef.BlockId;
   SubId = coRef.SubId;
   SubstantialChange = coRef.SubstantialChange;
   VersionsForForecasts = coRef.VersionsForForecasts;
   JustWrittenTiles = coRef.JustWrittenTiles;
   UsedTiles = coRef.UsedTiles;
   BackgroundTiles = coRef.BackgroundTiles;
   StatesAndAreasPerLanguage = coRef.StatesAndAreasPerLanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgWeatherDataChangedStatus& intwdbfi_tclMsgWeatherDataChangedStatus::operator=(const intwdbfi_tclMsgWeatherDataChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   WeatherProtocol = coRef.WeatherProtocol;
   BlockId = coRef.BlockId;
   SubId = coRef.SubId;
   SubstantialChange = coRef.SubstantialChange;
   VersionsForForecasts = coRef.VersionsForForecasts;
   JustWrittenTiles = coRef.JustWrittenTiles;
   UsedTiles = coRef.UsedTiles;
   BackgroundTiles = coRef.BackgroundTiles;
   StatesAndAreasPerLanguage = coRef.StatesAndAreasPerLanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgWeatherDataChangedStatus::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgWeatherDataChangedStatus::u16GetFunctionID() const {return INTWDBFI_C_U16_WEATHERDATACHANGED;}
tU8 intwdbfi_tclMsgWeatherDataChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid intwdbfi_tclMsgWeatherDataChangedStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
         VersionsForForecasts[u32Idx].vDestroy();
   }
   VersionsForForecasts.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < JustWrittenTiles.size(); ++u32Idx)
         JustWrittenTiles[u32Idx].vDestroy();
   }
   JustWrittenTiles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
         UsedTiles[u32Idx].vDestroy();
   }
   UsedTiles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
         BackgroundTiles[u32Idx].vDestroy();
   }
   BackgroundTiles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < StatesAndAreasPerLanguage.size(); ++u32Idx)
         StatesAndAreasPerLanguage[u32Idx].vDestroy();
   }
   StatesAndAreasPerLanguage.clear();
}

tU32 intwdbfi_tclMsgWeatherDataChangedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += VersionsForForecasts.size()*5;
   }
   tU32 u32ListIdx;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < JustWrittenTiles.size(); ++u32ListIdx)
         u32DynamicSize += JustWrittenTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < UsedTiles.size(); ++u32ListIdx)
         u32DynamicSize += UsedTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < BackgroundTiles.size(); ++u32ListIdx)
         u32DynamicSize += BackgroundTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < StatesAndAreasPerLanguage.size(); ++u32ListIdx)
         u32DynamicSize += StatesAndAreasPerLanguage[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+6;
}

tBool intwdbfi_tclMsgWeatherDataChangedStatus::operator==(const intwdbfi_tclMsgWeatherDataChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WeatherProtocol == rfoCmp.WeatherProtocol);
      bResult = bResult && (BlockId == rfoCmp.BlockId);
      bResult = bResult && (SubId == rfoCmp.SubId);
      bResult = bResult && (SubstantialChange == rfoCmp.SubstantialChange);
      bResult = bResult && (VersionsForForecasts.size() == rfoCmp.VersionsForForecasts.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VersionsForForecasts.size()); ++u32Idx)
            bResult = bResult && (VersionsForForecasts[u32Idx] == rfoCmp.VersionsForForecasts[u32Idx]);
      }
      bResult = bResult && (JustWrittenTiles.size() == rfoCmp.JustWrittenTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < JustWrittenTiles.size()); ++u32Idx)
            bResult = bResult && (JustWrittenTiles[u32Idx] == rfoCmp.JustWrittenTiles[u32Idx]);
      }
      bResult = bResult && (UsedTiles.size() == rfoCmp.UsedTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UsedTiles.size()); ++u32Idx)
            bResult = bResult && (UsedTiles[u32Idx] == rfoCmp.UsedTiles[u32Idx]);
      }
      bResult = bResult && (BackgroundTiles.size() == rfoCmp.BackgroundTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BackgroundTiles.size()); ++u32Idx)
            bResult = bResult && (BackgroundTiles[u32Idx] == rfoCmp.BackgroundTiles[u32Idx]);
      }
      bResult = bResult && (StatesAndAreasPerLanguage.size() == rfoCmp.StatesAndAreasPerLanguage.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StatesAndAreasPerLanguage.size()); ++u32Idx)
            bResult = bResult && (StatesAndAreasPerLanguage[u32Idx] == rfoCmp.StatesAndAreasPerLanguage[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgWeatherDataChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> WeatherProtocol;
   oIn >> BlockId;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> SubId;
   }
   oIn >> SubstantialChange;
   if (3 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
         {
            VersionsForForecasts[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         VersionsForForecasts.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> VersionsForForecasts[u32Idx];
         }
      }
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < JustWrittenTiles.size(); ++u32Idx)
         {
            JustWrittenTiles[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         JustWrittenTiles.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> JustWrittenTiles[u32Idx];
         }
      }
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
         {
            UsedTiles[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         UsedTiles.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> UsedTiles[u32Idx];
         }
      }
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
         {
            BackgroundTiles[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         BackgroundTiles.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> BackgroundTiles[u32Idx];
         }
      }
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < StatesAndAreasPerLanguage.size(); ++u32Idx)
         {
            StatesAndAreasPerLanguage[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         StatesAndAreasPerLanguage.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> StatesAndAreasPerLanguage[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgWeatherDataChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WeatherProtocol;
   oOut << BlockId;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << SubId;
   }
   oOut << SubstantialChange;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)VersionsForForecasts.size();
      {
         for (tU32 u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
            oOut << VersionsForForecasts[u32Idx];
      }
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)JustWrittenTiles.size();
      {
         for (tU32 u32Idx = 0; u32Idx < JustWrittenTiles.size(); ++u32Idx)
            oOut << JustWrittenTiles[u32Idx];
      }
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)UsedTiles.size();
      {
         for (tU32 u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
            oOut << UsedTiles[u32Idx];
      }
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)BackgroundTiles.size();
      {
         for (tU32 u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
            oOut << BackgroundTiles[u32Idx];
      }
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)StatesAndAreasPerLanguage.size();
      {
         for (tU32 u32Idx = 0; u32Idx < StatesAndAreasPerLanguage.size(); ++u32Idx)
            oOut << StatesAndAreasPerLanguage[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgEngineeringTextGet::intwdbfi_tclMsgEngineeringTextGet(const intwdbfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgEngineeringTextGet& intwdbfi_tclMsgEngineeringTextGet::operator=(const intwdbfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return INTWDBFI_C_U16_ENGINEERINGTEXT;}
tU8 intwdbfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intwdbfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgEngineeringTextGet::operator==(const intwdbfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgEngineeringTextUpReg::intwdbfi_tclMsgEngineeringTextUpReg(const intwdbfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgEngineeringTextUpReg& intwdbfi_tclMsgEngineeringTextUpReg::operator=(const intwdbfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return INTWDBFI_C_U16_ENGINEERINGTEXT;}
tU8 intwdbfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 intwdbfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgEngineeringTextUpReg::operator==(const intwdbfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgEngineeringTextRelUpReg::intwdbfi_tclMsgEngineeringTextRelUpReg(const intwdbfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgEngineeringTextRelUpReg& intwdbfi_tclMsgEngineeringTextRelUpReg::operator=(const intwdbfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return INTWDBFI_C_U16_ENGINEERINGTEXT;}
tU8 intwdbfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 intwdbfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intwdbfi_tclMsgEngineeringTextRelUpReg::operator==(const intwdbfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgEngineeringTextStatus::intwdbfi_tclMsgEngineeringTextStatus(const intwdbfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intwdbfi_tclMsgEngineeringTextStatus& intwdbfi_tclMsgEngineeringTextStatus::operator=(const intwdbfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intwdbfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return INTWDBFI_C_U16_SERVICE_ID;}
tU16 intwdbfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return INTWDBFI_C_U16_ENGINEERINGTEXT;}
tU8 intwdbfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid intwdbfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 intwdbfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool intwdbfi_tclMsgEngineeringTextStatus::operator==(const intwdbfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& intwdbfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& intwdbfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

