#include "precompiled.hh"

tBool intwdbfi_tclDescription::bInitMessage(intwdbfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case intwdbfi_tclToken::EN_LAST_TOKEN:
   case intwdbfi_tclToken::EN_LIST:
   case intwdbfi_tclToken::EN_END_OF_STRUCT:
   case intwdbfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_BOOL,intwdbfi_tclSemanticDomain::EN_MSG_DATAAVAILABLE));
   } break;
   case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDSTATUS:
   {
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_STATESANDAREASPERLANGUAGE,intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_LIST,intwdbfi_tclSemanticDomain::EN_MSG_STATESANDAREASPERLANGUAGE));
      }
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_VERSIONSOFTILE,intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_LIST,intwdbfi_tclSemanticDomain::EN_MSG_BACKGROUNDTILES));
      }
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_VERSIONSOFTILE,intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_LIST,intwdbfi_tclSemanticDomain::EN_MSG_USEDTILES));
      }
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_VERSIONSOFTILE,intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_LIST,intwdbfi_tclSemanticDomain::EN_MSG_JUSTWRITTENTILES));
      }
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_VERSIONPERFORECAST,intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_LIST,intwdbfi_tclSemanticDomain::EN_MSG_VERSIONSFORFORECASTS));
      }
      bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_BOOL,intwdbfi_tclSemanticDomain::EN_MSG_SUBSTANTIALCHANGE));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U32,intwdbfi_tclSemanticDomain::EN_MSG_SUBID));
      }
      bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U32,intwdbfi_tclSemanticDomain::EN_MSG_BLOCKID));
      bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_E8_WEATHERPROTOCOL,intwdbfi_tclSemanticDomain::EN_MSG_WEATHERPROTOCOL));
   } break;
   case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_STRING,intwdbfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case intwdbfi_tclToken::EN_BINCONTAINER:
   case intwdbfi_tclToken::EN_S32_LONGITUDE:
   case intwdbfi_tclToken::EN_S32_LATITUDE:
   case intwdbfi_tclToken::EN_POSITIONWGS84:
   case intwdbfi_tclToken::EN_E16_ISOLANGUAGECODE:
   case intwdbfi_tclToken::EN_E8_WEATHERPROTOCOL:
   case intwdbfi_tclToken::EN_E8_FORECASTTYPE:
   case intwdbfi_tclToken::EN_VERSIONPERFORECAST:
   case intwdbfi_tclToken::EN_STATEORZONE:
   case intwdbfi_tclToken::EN_VERSIONPERSTATE:
   case intwdbfi_tclToken::EN_AREABOUNDINGBOX:
   case intwdbfi_tclToken::EN_AREAINSTATE:
   case intwdbfi_tclToken::EN_STATESANDAREASPERLANGUAGE:
   case intwdbfi_tclToken::EN_VERSIONSOFTILE:
   case intwdbfi_tclToken::EN_U8:   
   case intwdbfi_tclToken::EN_S8:   
   case intwdbfi_tclToken::EN_U16:   
   case intwdbfi_tclToken::EN_S16:   
   case intwdbfi_tclToken::EN_U24:   
   case intwdbfi_tclToken::EN_S24:   
   case intwdbfi_tclToken::EN_U32:   
   case intwdbfi_tclToken::EN_S32:   
   case intwdbfi_tclToken::EN_U64:   
   case intwdbfi_tclToken::EN_S64:   
   case intwdbfi_tclToken::EN_F32:   
   case intwdbfi_tclToken::EN_F64:   
   case intwdbfi_tclToken::EN_BOOL:   
   case intwdbfi_tclToken::EN_STRING:   
   case intwdbfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(intwdbfi_tclKnot(enMsgToken,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool intwdbfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool intwdbfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      intwdbfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      intwdbfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      intwdbfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(intwdbfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(intwdbfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(intwdbfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case intwdbfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == intwdbfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            intwdbfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(intwdbfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            intwdbfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(intwdbfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case intwdbfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case intwdbfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intwdbfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDGET:
   case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDUPREG:
   case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDRELUPREG:
   case intwdbfi_tclToken::EN_MSG_DATAAVAILABILITYCHANGEDSTATUS:
   case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDGET:
   case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDUPREG:
   case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDRELUPREG:
   case intwdbfi_tclToken::EN_MSG_WEATHERDATACHANGEDSTATUS:
   case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case intwdbfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case intwdbfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U8,intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_LIST,intwdbfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intwdbfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intwdbfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intwdbfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_S32_LATITUDE,intwdbfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_S32_LONGITUDE,intwdbfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intwdbfi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intwdbfi_tclToken::EN_E8_WEATHERPROTOCOL:
   {
      fi_tcl_e8_WeatherProtocol o_e8_WeatherProtocol;
      if (!bDoIt(o_e8_WeatherProtocol))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intwdbfi_tclToken::EN_E8_FORECASTTYPE:
   {
      fi_tcl_e8_ForecastType o_e8_ForecastType;
      if (!bDoIt(o_e8_ForecastType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intwdbfi_tclToken::EN_VERSIONPERFORECAST:
   {
      if (poVisitor->bDoExpand_VersionPerForecast(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U32,intwdbfi_tclSemanticDomain::EN_VERSIONID));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_E8_FORECASTTYPE,intwdbfi_tclSemanticDomain::EN_FORECASTTYPE));
      }
      else
      {
         fi_tcl_VersionPerForecast o_VersionPerForecast;
         if (!bDoIt(o_VersionPerForecast))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionPerForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionPerForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intwdbfi_tclToken::EN_STATEORZONE:
   {
      if (poVisitor->bDoExpand_StateOrZone(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U16,intwdbfi_tclSemanticDomain::EN_STATEORZONEIDNUMERIC));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_BOOL,intwdbfi_tclSemanticDomain::EN_ISMARINEZONE));
      }
      else
      {
         fi_tcl_StateOrZone o_StateOrZone;
         if (!bDoIt(o_StateOrZone))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateOrZone.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateOrZone.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intwdbfi_tclToken::EN_VERSIONPERSTATE:
   {
      if (poVisitor->bDoExpand_VersionPerState(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U32,intwdbfi_tclSemanticDomain::EN_VERSION));
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_STATEORZONE,intwdbfi_tclSemanticDomain::EN_STATEORZONEIDENTIFIER));
         }
         if (u16MajorVersion <= 3)
         {
            oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U32,intwdbfi_tclSemanticDomain::EN_STATEIDNUMERIC));
         }
      }
      else
      {
         fi_tcl_VersionPerState o_VersionPerState;
         if (!bDoIt(o_VersionPerState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionPerState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionPerState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intwdbfi_tclToken::EN_AREABOUNDINGBOX:
   {
      if (poVisitor->bDoExpand_AreaBoundingBox(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_POSITIONWGS84,intwdbfi_tclSemanticDomain::EN_UPPERRIGTHPOSITION));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_POSITIONWGS84,intwdbfi_tclSemanticDomain::EN_LOWERLEFTPOSITION));
      }
      else
      {
         fi_tcl_AreaBoundingBox o_AreaBoundingBox;
         if (!bDoIt(o_AreaBoundingBox))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AreaBoundingBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AreaBoundingBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intwdbfi_tclToken::EN_AREAINSTATE:
   {
      if (poVisitor->bDoExpand_AreaInState(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_VERSIONPERSTATE,intwdbfi_tclSemanticDomain::EN_VERSIONPERSTATE));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_AREABOUNDINGBOX,intwdbfi_tclSemanticDomain::EN_AREA));
      }
      else
      {
         fi_tcl_AreaInState o_AreaInState;
         if (!bDoIt(o_AreaInState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AreaInState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AreaInState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intwdbfi_tclToken::EN_STATESANDAREASPERLANGUAGE:
   {
      if (poVisitor->bDoExpand_StatesAndAreasPerLanguage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_E16_ISOLANGUAGECODE,intwdbfi_tclSemanticDomain::EN_LANGUAGE));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_AREAINSTATE,intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_LIST,intwdbfi_tclSemanticDomain::EN_AFFECTEDAREASINSTATES));
      }
      else
      {
         fi_tcl_StatesAndAreasPerLanguage o_StatesAndAreasPerLanguage;
         if (!bDoIt(o_StatesAndAreasPerLanguage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StatesAndAreasPerLanguage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StatesAndAreasPerLanguage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intwdbfi_tclToken::EN_VERSIONSOFTILE:
   {
      if (poVisitor->bDoExpand_VersionsOfTile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_END_OF_STRUCT,intwdbfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U32,intwdbfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_LIST,intwdbfi_tclSemanticDomain::EN_TILEVERSIONLIST));
         oPath.bGoDown(intwdbfi_tclKnot(intwdbfi_tclToken::EN_U32,intwdbfi_tclSemanticDomain::EN_INDEXINTILEARRAY));
      }
      else
      {
         fi_tcl_VersionsOfTile o_VersionsOfTile;
         if (!bDoIt(o_VersionsOfTile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionsOfTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionsOfTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case intwdbfi_tclToken::EN_UNKNOWN:
      case intwdbfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

