#ifndef __INTWDBFIDEBUGVISITOR_H__
#define __INTWDBFIDEBUGVISITOR_H__

class MY_DECL intwdbfi_tclPrintVisitor : public intwdbfi_tclVisitorBase {

private:
   /* default constructor */ intwdbfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   intwdbfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(intwdbfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(intwdbfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_e8_WeatherProtocol(fi_tcl_e8_WeatherProtocol& o_e8_WeatherProtocol);
   virtual tVoid vVisit_e8_ForecastType(fi_tcl_e8_ForecastType& o_e8_ForecastType);
   virtual tBool bDoExpand_VersionPerForecast(intwdbfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateOrZone(intwdbfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VersionPerState(intwdbfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AreaBoundingBox(intwdbfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AreaInState(intwdbfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StatesAndAreasPerLanguage(intwdbfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VersionsOfTile(intwdbfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL intwdbfi_tclRandomInitVisitor : public intwdbfi_tclVisitorBase {
public:

   intwdbfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_e8_WeatherProtocol(fi_tcl_e8_WeatherProtocol& o_e8_WeatherProtocol);
   virtual tVoid vVisit_e8_ForecastType(fi_tcl_e8_ForecastType& o_e8_ForecastType);
	tU32 u32ListSize;
};

#endif
