/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef INTNAVIFITYPES_HEADER
#define INTNAVIFITYPES_HEADER

// #include <vector>
// 


class intnavifi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class intnavifi_tclMsgUpdateMediaIdMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgUpdateMediaIdMethodStart():MediaId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgUpdateMediaIdMethodStart& operator=(const intnavifi_tclMsgUpdateMediaIdMethodStart& coRef);
   intnavifi_tclMsgUpdateMediaIdMethodStart(const intnavifi_tclMsgUpdateMediaIdMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MediaId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgUpdateMediaIdMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_UPDATEMEDIAIDMETHODSTART;}
};

class intnavifi_tclMsgUpdateMediaIdMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgUpdateMediaIdMethodResult():MediaId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgUpdateMediaIdMethodResult& operator=(const intnavifi_tclMsgUpdateMediaIdMethodResult& coRef);
   intnavifi_tclMsgUpdateMediaIdMethodResult(const intnavifi_tclMsgUpdateMediaIdMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MediaId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgUpdateMediaIdMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_UPDATEMEDIAIDMETHODRESULT;}
};

class intnavifi_tclMsgSMTimeOutMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgSMTimeOutMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgSMTimeOutMethodStart& operator=(const intnavifi_tclMsgSMTimeOutMethodStart& coRef);
   intnavifi_tclMsgSMTimeOutMethodStart(const intnavifi_tclMsgSMTimeOutMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgSMTimeOutMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_SMTIMEOUTMETHODSTART;}
};

class intnavifi_tclMsgSMTimeOutMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgSMTimeOutMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgSMTimeOutMethodResult& operator=(const intnavifi_tclMsgSMTimeOutMethodResult& coRef);
   intnavifi_tclMsgSMTimeOutMethodResult(const intnavifi_tclMsgSMTimeOutMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgSMTimeOutMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_SMTIMEOUTMETHODRESULT;}
};

class intnavifi_tclMsgForceLocDatabaseUpdateMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgForceLocDatabaseUpdateMethodStart():NavRectangle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgForceLocDatabaseUpdateMethodStart& operator=(const intnavifi_tclMsgForceLocDatabaseUpdateMethodStart& coRef);
   intnavifi_tclMsgForceLocDatabaseUpdateMethodStart(const intnavifi_tclMsgForceLocDatabaseUpdateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RectangleWGS84 NavRectangle;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgForceLocDatabaseUpdateMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_FORCELOCDATABASEUPDATEMETHODSTART;}
};

class intnavifi_tclMsgForceLocDatabaseUpdateMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgForceLocDatabaseUpdateMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgForceLocDatabaseUpdateMethodResult& operator=(const intnavifi_tclMsgForceLocDatabaseUpdateMethodResult& coRef);
   intnavifi_tclMsgForceLocDatabaseUpdateMethodResult(const intnavifi_tclMsgForceLocDatabaseUpdateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgForceLocDatabaseUpdateMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_FORCELOCDATABASEUPDATEMETHODRESULT;}
};

class intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart():NavDataSetID(),Path(),PathNumber(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart& operator=(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart& coRef);
   intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_NavPlainPathListSet Path;
   tU16 PathNumber;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETSPECIFICTRAFFICMESSAGESMETHODSTART;}
};

class intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult():CurrentTrafficMessageRevision(0),NavDataSetID(),Path(),TMInfoListSet(),PathNumber(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult& operator=(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult& coRef);
   intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 CurrentTrafficMessageRevision;
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_NavPlainPathListSet Path;
   fi_tcl_TMInfoListSet TMInfoListSet;
   tU16 PathNumber;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETSPECIFICTRAFFICMESSAGESMETHODRESULT;}
};

class intnavifi_tclMsgGetRoadPathInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetRoadPathInfoMethodStart():RoadInfoPriority(),DataSetId(),RoadPathListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetRoadPathInfoMethodStart& operator=(const intnavifi_tclMsgGetRoadPathInfoMethodStart& coRef);
   intnavifi_tclMsgGetRoadPathInfoMethodStart(const intnavifi_tclMsgGetRoadPathInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_RoadInfoPriority RoadInfoPriority;
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_NavPlainPathListSet RoadPathListSet;
   std::vector<fi_tcl_e8_RoadPathInfoCategory, std::allocator<fi_tcl_e8_RoadPathInfoCategory> > RoadPathInfoCategory;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetRoadPathInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODSTART;}
};

class intnavifi_tclMsgGetRoadPathInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetRoadPathInfoMethodResult():DataSetId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetRoadPathInfoMethodResult& operator=(const intnavifi_tclMsgGetRoadPathInfoMethodResult& coRef);
   intnavifi_tclMsgGetRoadPathInfoMethodResult(const intnavifi_tclMsgGetRoadPathInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId DataSetId;
   std::vector<fi_tcl_RoadPathInfoListSet, std::allocator<fi_tcl_RoadPathInfoListSet> > RoadPathInfoListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetRoadPathInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULT;}
};

class intnavifi_tclMsgGetRoadPathInfoMethodResultFirst : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetRoadPathInfoMethodResultFirst():DataSetId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetRoadPathInfoMethodResultFirst& operator=(const intnavifi_tclMsgGetRoadPathInfoMethodResultFirst& coRef);
   intnavifi_tclMsgGetRoadPathInfoMethodResultFirst(const intnavifi_tclMsgGetRoadPathInfoMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId DataSetId;
   std::vector<fi_tcl_RoadPathInfoListSet, std::allocator<fi_tcl_RoadPathInfoListSet> > RoadPathInfoListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetRoadPathInfoMethodResultFirst& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTFIRST;}
};

class intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle& operator=(const intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle& coRef);
   intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle(const intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RoadPathInfoListSet, std::allocator<fi_tcl_RoadPathInfoListSet> > RoadPathInfoListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTMIDDLE;}
};

class intnavifi_tclMsgGetRoadPathInfoMethodResultLast : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetRoadPathInfoMethodResultLast() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetRoadPathInfoMethodResultLast& operator=(const intnavifi_tclMsgGetRoadPathInfoMethodResultLast& coRef);
   intnavifi_tclMsgGetRoadPathInfoMethodResultLast(const intnavifi_tclMsgGetRoadPathInfoMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RoadPathInfoListSet, std::allocator<fi_tcl_RoadPathInfoListSet> > RoadPathInfoListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetRoadPathInfoMethodResultLast& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTLAST;}
};

class intnavifi_tclMsgGetUPOIsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetUPOIsMethodStart():RequestId(0),DataSetId(),RoadPathListSet(),FilterList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetUPOIsMethodStart& operator=(const intnavifi_tclMsgGetUPOIsMethodStart& coRef);
   intnavifi_tclMsgGetUPOIsMethodStart(const intnavifi_tclMsgGetUPOIsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 RequestId;
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_NavPlainPathListSet RoadPathListSet;
   fi_tcl_UPOI_FilterList FilterList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetUPOIsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETUPOISMETHODSTART;}
};

class intnavifi_tclMsgGetUPOIsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetUPOIsMethodResult():RequestId(0),DataSetId(),RoadPathListSet(),UPOIListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetUPOIsMethodResult& operator=(const intnavifi_tclMsgGetUPOIsMethodResult& coRef);
   intnavifi_tclMsgGetUPOIsMethodResult(const intnavifi_tclMsgGetUPOIsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 RequestId;
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_NavPlainPathListSet RoadPathListSet;
   fi_tcl_UPOI_ListSet UPOIListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetUPOIsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULT;}
};

class intnavifi_tclMsgGetUPOIsMethodResultFirst : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetUPOIsMethodResultFirst():RequestId(0),DataSetId(),RoadPathListSet(),UPOIListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetUPOIsMethodResultFirst& operator=(const intnavifi_tclMsgGetUPOIsMethodResultFirst& coRef);
   intnavifi_tclMsgGetUPOIsMethodResultFirst(const intnavifi_tclMsgGetUPOIsMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 RequestId;
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_NavPlainPathListSet RoadPathListSet;
   fi_tcl_UPOI_ListSet UPOIListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetUPOIsMethodResultFirst& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTFIRST;}
};

class intnavifi_tclMsgGetUPOIsMethodResultMiddle : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetUPOIsMethodResultMiddle():RequestId(0),DataSetId(),RoadPathListSet(),UPOIListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetUPOIsMethodResultMiddle& operator=(const intnavifi_tclMsgGetUPOIsMethodResultMiddle& coRef);
   intnavifi_tclMsgGetUPOIsMethodResultMiddle(const intnavifi_tclMsgGetUPOIsMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 RequestId;
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_NavPlainPathListSet RoadPathListSet;
   fi_tcl_UPOI_ListSet UPOIListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetUPOIsMethodResultMiddle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTMIDDLE;}
};

class intnavifi_tclMsgGetUPOIsMethodResultLast : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgGetUPOIsMethodResultLast():RequestId(0),DataSetId(),RoadPathListSet(),UPOIListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgGetUPOIsMethodResultLast& operator=(const intnavifi_tclMsgGetUPOIsMethodResultLast& coRef);
   intnavifi_tclMsgGetUPOIsMethodResultLast(const intnavifi_tclMsgGetUPOIsMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 RequestId;
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_NavPlainPathListSet RoadPathListSet;
   fi_tcl_UPOI_ListSet UPOIListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgGetUPOIsMethodResultLast& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTLAST;}
};

class intnavifi_tclMsgMediumAvailGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgMediumAvailGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgMediumAvailGet& operator=(const intnavifi_tclMsgMediumAvailGet& coRef);
   intnavifi_tclMsgMediumAvailGet(const intnavifi_tclMsgMediumAvailGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgMediumAvailGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_MEDIUMAVAILGET;}
};

class intnavifi_tclMsgMediumAvailStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgMediumAvailStatus():MediumId(0),DataSetId(0),DataAvailability(),DataAccessEnabled(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgMediumAvailStatus& operator=(const intnavifi_tclMsgMediumAvailStatus& coRef);
   intnavifi_tclMsgMediumAvailStatus(const intnavifi_tclMsgMediumAvailStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MediumId;
   tU32 DataSetId;
   fi_tcl_e8_DataAvailable DataAvailability;
   tBool DataAccessEnabled;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgMediumAvailStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_MEDIUMAVAILSTATUS;}
};

class intnavifi_tclMsgLocDatabaseGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgLocDatabaseGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgLocDatabaseGet& operator=(const intnavifi_tclMsgLocDatabaseGet& coRef);
   intnavifi_tclMsgLocDatabaseGet(const intnavifi_tclMsgLocDatabaseGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgLocDatabaseGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_LOCDATABASEGET;}
};

class intnavifi_tclMsgLocDatabaseStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgLocDatabaseStatus():DataSetId(),u32UpdateCounter(0),bDataExist(0),bDataComplete(0),bLimitCorridor(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgLocDatabaseStatus& operator=(const intnavifi_tclMsgLocDatabaseStatus& coRef);
   intnavifi_tclMsgLocDatabaseStatus(const intnavifi_tclMsgLocDatabaseStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId DataSetId;
   tU32 u32UpdateCounter;
   tBool bDataExist;
   tBool bDataComplete;
   tBool bLimitCorridor;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgLocDatabaseStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_LOCDATABASESTATUS;}
};

class intnavifi_tclMsgWakeUpStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgWakeUpStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgWakeUpStatus& operator=(const intnavifi_tclMsgWakeUpStatus& coRef);
   intnavifi_tclMsgWakeUpStatus(const intnavifi_tclMsgWakeUpStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgWakeUpStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_WAKEUPSTATUS;}
};

class intnavifi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgEngineeringTextGet& operator=(const intnavifi_tclMsgEngineeringTextGet& coRef);
   intnavifi_tclMsgEngineeringTextGet(const intnavifi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class intnavifi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgEngineeringTextUpReg& operator=(const intnavifi_tclMsgEngineeringTextUpReg& coRef);
   intnavifi_tclMsgEngineeringTextUpReg(const intnavifi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class intnavifi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgEngineeringTextRelUpReg& operator=(const intnavifi_tclMsgEngineeringTextRelUpReg& coRef);
   intnavifi_tclMsgEngineeringTextRelUpReg(const intnavifi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class intnavifi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intnavifi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intnavifi_tclMsgEngineeringTextStatus& operator=(const intnavifi_tclMsgEngineeringTextStatus& coRef);
   intnavifi_tclMsgEngineeringTextStatus(const intnavifi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intnavifi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
