/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgUpdateMediaIdMethodStart::intnavifi_tclMsgUpdateMediaIdMethodStart(const intnavifi_tclMsgUpdateMediaIdMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgUpdateMediaIdMethodStart& intnavifi_tclMsgUpdateMediaIdMethodStart::operator=(const intnavifi_tclMsgUpdateMediaIdMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgUpdateMediaIdMethodStart::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgUpdateMediaIdMethodStart::u16GetFunctionID() const {return INTNAVIFI_C_U16_UPDATEMEDIAID;}
tU8 intnavifi_tclMsgUpdateMediaIdMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 intnavifi_tclMsgUpdateMediaIdMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool intnavifi_tclMsgUpdateMediaIdMethodStart::operator==(const intnavifi_tclMsgUpdateMediaIdMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgUpdateMediaIdMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgUpdateMediaIdMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgUpdateMediaIdMethodResult::intnavifi_tclMsgUpdateMediaIdMethodResult(const intnavifi_tclMsgUpdateMediaIdMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgUpdateMediaIdMethodResult& intnavifi_tclMsgUpdateMediaIdMethodResult::operator=(const intnavifi_tclMsgUpdateMediaIdMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgUpdateMediaIdMethodResult::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgUpdateMediaIdMethodResult::u16GetFunctionID() const {return INTNAVIFI_C_U16_UPDATEMEDIAID;}
tU8 intnavifi_tclMsgUpdateMediaIdMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 intnavifi_tclMsgUpdateMediaIdMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool intnavifi_tclMsgUpdateMediaIdMethodResult::operator==(const intnavifi_tclMsgUpdateMediaIdMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgUpdateMediaIdMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgUpdateMediaIdMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgSMTimeOutMethodStart::intnavifi_tclMsgSMTimeOutMethodStart(const intnavifi_tclMsgSMTimeOutMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgSMTimeOutMethodStart& intnavifi_tclMsgSMTimeOutMethodStart::operator=(const intnavifi_tclMsgSMTimeOutMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgSMTimeOutMethodStart::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgSMTimeOutMethodStart::u16GetFunctionID() const {return INTNAVIFI_C_U16_SMTIMEOUT;}
tU8 intnavifi_tclMsgSMTimeOutMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 intnavifi_tclMsgSMTimeOutMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgSMTimeOutMethodStart::operator==(const intnavifi_tclMsgSMTimeOutMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgSMTimeOutMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgSMTimeOutMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgSMTimeOutMethodResult::intnavifi_tclMsgSMTimeOutMethodResult(const intnavifi_tclMsgSMTimeOutMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgSMTimeOutMethodResult& intnavifi_tclMsgSMTimeOutMethodResult::operator=(const intnavifi_tclMsgSMTimeOutMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgSMTimeOutMethodResult::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgSMTimeOutMethodResult::u16GetFunctionID() const {return INTNAVIFI_C_U16_SMTIMEOUT;}
tU8 intnavifi_tclMsgSMTimeOutMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 intnavifi_tclMsgSMTimeOutMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgSMTimeOutMethodResult::operator==(const intnavifi_tclMsgSMTimeOutMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgSMTimeOutMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgSMTimeOutMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::intnavifi_tclMsgForceLocDatabaseUpdateMethodStart(const intnavifi_tclMsgForceLocDatabaseUpdateMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavRectangle = coRef.NavRectangle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgForceLocDatabaseUpdateMethodStart& intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::operator=(const intnavifi_tclMsgForceLocDatabaseUpdateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavRectangle = coRef.NavRectangle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::u16GetFunctionID() const {return INTNAVIFI_C_U16_FORCELOCDATABASEUPDATE;}
tU8 intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::vDestroy()
{
   NavRectangle.vDestroy(); 
}

tU32 intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::operator==(const intnavifi_tclMsgForceLocDatabaseUpdateMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavRectangle == rfoCmp.NavRectangle);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavRectangle;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgForceLocDatabaseUpdateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavRectangle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::intnavifi_tclMsgForceLocDatabaseUpdateMethodResult(const intnavifi_tclMsgForceLocDatabaseUpdateMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgForceLocDatabaseUpdateMethodResult& intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::operator=(const intnavifi_tclMsgForceLocDatabaseUpdateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::u16GetFunctionID() const {return INTNAVIFI_C_U16_FORCELOCDATABASEUPDATE;}
tU8 intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::operator==(const intnavifi_tclMsgForceLocDatabaseUpdateMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgForceLocDatabaseUpdateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   Path = coRef.Path;
   PathNumber = coRef.PathNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart& intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::operator=(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   Path = coRef.Path;
   PathNumber = coRef.PathNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETSPECIFICTRAFFICMESSAGES;}
tU8 intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::vDestroy()
{
   Path.vDestroy(); 
}

tU32 intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+Path.u32GetSize(u16MajorVersion);
}

tBool intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::operator==(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (Path == rfoCmp.Path);
      bResult = bResult && (PathNumber == rfoCmp.PathNumber);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> Path;
   oIn >> PathNumber;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetSpecificTrafficMessagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << Path;
   oOut << PathNumber;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   NavDataSetID = coRef.NavDataSetID;
   Path = coRef.Path;
   TMInfoListSet = coRef.TMInfoListSet;
   PathNumber = coRef.PathNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult& intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::operator=(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   NavDataSetID = coRef.NavDataSetID;
   Path = coRef.Path;
   TMInfoListSet = coRef.TMInfoListSet;
   PathNumber = coRef.PathNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETSPECIFICTRAFFICMESSAGES;}
tU8 intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::vDestroy()
{
   Path.vDestroy(); 
   TMInfoListSet.vDestroy(); 
}

tU32 intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+Path.u32GetSize(u16MajorVersion)+TMInfoListSet.u32GetSize(u16MajorVersion);
}

tBool intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::operator==(const intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentTrafficMessageRevision == rfoCmp.CurrentTrafficMessageRevision);
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (Path == rfoCmp.Path);
      bResult = bResult && (TMInfoListSet == rfoCmp.TMInfoListSet);
      bResult = bResult && (PathNumber == rfoCmp.PathNumber);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CurrentTrafficMessageRevision;
   oIn >> NavDataSetID;
   oIn >> Path;
   oIn >> TMInfoListSet;
   oIn >> PathNumber;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetSpecificTrafficMessagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CurrentTrafficMessageRevision;
   oOut << NavDataSetID;
   oOut << Path;
   oOut << TMInfoListSet;
   oOut << PathNumber;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodStart::intnavifi_tclMsgGetRoadPathInfoMethodStart(const intnavifi_tclMsgGetRoadPathInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadInfoPriority = coRef.RoadInfoPriority;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   RoadPathInfoCategory = coRef.RoadPathInfoCategory;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodStart& intnavifi_tclMsgGetRoadPathInfoMethodStart::operator=(const intnavifi_tclMsgGetRoadPathInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RoadInfoPriority = coRef.RoadInfoPriority;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   RoadPathInfoCategory = coRef.RoadPathInfoCategory;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetRoadPathInfoMethodStart::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetRoadPathInfoMethodStart::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETROADPATHINFO;}
tU8 intnavifi_tclMsgGetRoadPathInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intnavifi_tclMsgGetRoadPathInfoMethodStart::vDestroy()
{
   RoadPathListSet.vDestroy(); 
   RoadPathInfoCategory.clear();
}

tU32 intnavifi_tclMsgGetRoadPathInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+RoadPathListSet.u32GetSize(u16MajorVersion)+RoadPathInfoCategory.size()*1;
}

tBool intnavifi_tclMsgGetRoadPathInfoMethodStart::operator==(const intnavifi_tclMsgGetRoadPathInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadInfoPriority == rfoCmp.RoadInfoPriority);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RoadPathListSet == rfoCmp.RoadPathListSet);
      bResult = bResult && (RoadPathInfoCategory.size() == rfoCmp.RoadPathInfoCategory.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadPathInfoCategory.size()); ++u32Idx)
            bResult = bResult && (RoadPathInfoCategory[u32Idx] == rfoCmp.RoadPathInfoCategory[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetRoadPathInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> RoadInfoPriority;
   oIn >> DataSetId;
   oIn >> RoadPathListSet;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RoadPathInfoCategory.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadPathInfoCategory[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetRoadPathInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RoadInfoPriority;
   oOut << DataSetId;
   oOut << RoadPathListSet;
   oOut << (tU32)RoadPathInfoCategory.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoCategory.size(); ++u32Idx)
         oOut << RoadPathInfoCategory[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodResult::intnavifi_tclMsgGetRoadPathInfoMethodResult(const intnavifi_tclMsgGetRoadPathInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataSetId = coRef.DataSetId;
   RoadPathInfoListSet = coRef.RoadPathInfoListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodResult& intnavifi_tclMsgGetRoadPathInfoMethodResult::operator=(const intnavifi_tclMsgGetRoadPathInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   RoadPathInfoListSet = coRef.RoadPathInfoListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetRoadPathInfoMethodResult::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetRoadPathInfoMethodResult::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETROADPATHINFO;}
tU8 intnavifi_tclMsgGetRoadPathInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intnavifi_tclMsgGetRoadPathInfoMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
         RoadPathInfoListSet[u32Idx].vDestroy();
   }
   RoadPathInfoListSet.clear();
}

tU32 intnavifi_tclMsgGetRoadPathInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadPathInfoListSet.size(); ++u32ListIdx)
      u32DynamicSize += RoadPathInfoListSet[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool intnavifi_tclMsgGetRoadPathInfoMethodResult::operator==(const intnavifi_tclMsgGetRoadPathInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RoadPathInfoListSet.size() == rfoCmp.RoadPathInfoListSet.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadPathInfoListSet.size()); ++u32Idx)
            bResult = bResult && (RoadPathInfoListSet[u32Idx] == rfoCmp.RoadPathInfoListSet[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetRoadPathInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> DataSetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
      {
         RoadPathInfoListSet[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadPathInfoListSet.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadPathInfoListSet[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetRoadPathInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataSetId;
   oOut << (tU32)RoadPathInfoListSet.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
         oOut << RoadPathInfoListSet[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::intnavifi_tclMsgGetRoadPathInfoMethodResultFirst(const intnavifi_tclMsgGetRoadPathInfoMethodResultFirst& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataSetId = coRef.DataSetId;
   RoadPathInfoListSet = coRef.RoadPathInfoListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodResultFirst& intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::operator=(const intnavifi_tclMsgGetRoadPathInfoMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   RoadPathInfoListSet = coRef.RoadPathInfoListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETROADPATHINFO;}
tU8 intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTFIRST;}

tVoid intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
         RoadPathInfoListSet[u32Idx].vDestroy();
   }
   RoadPathInfoListSet.clear();
}

tU32 intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadPathInfoListSet.size(); ++u32ListIdx)
      u32DynamicSize += RoadPathInfoListSet[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::operator==(const intnavifi_tclMsgGetRoadPathInfoMethodResultFirst& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RoadPathInfoListSet.size() == rfoCmp.RoadPathInfoListSet.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadPathInfoListSet.size()); ++u32Idx)
            bResult = bResult && (RoadPathInfoListSet[u32Idx] == rfoCmp.RoadPathInfoListSet[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   oIn >> DataSetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
      {
         RoadPathInfoListSet[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadPathInfoListSet.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadPathInfoListSet[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetRoadPathInfoMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataSetId;
   oOut << (tU32)RoadPathInfoListSet.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
         oOut << RoadPathInfoListSet[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle(const intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadPathInfoListSet = coRef.RoadPathInfoListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle& intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::operator=(const intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   RoadPathInfoListSet = coRef.RoadPathInfoListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETROADPATHINFO;}
tU8 intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTMIDDLE;}

tVoid intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
         RoadPathInfoListSet[u32Idx].vDestroy();
   }
   RoadPathInfoListSet.clear();
}

tU32 intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadPathInfoListSet.size(); ++u32ListIdx)
      u32DynamicSize += RoadPathInfoListSet[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::operator==(const intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadPathInfoListSet.size() == rfoCmp.RoadPathInfoListSet.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadPathInfoListSet.size()); ++u32Idx)
            bResult = bResult && (RoadPathInfoListSet[u32Idx] == rfoCmp.RoadPathInfoListSet[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
      {
         RoadPathInfoListSet[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadPathInfoListSet.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadPathInfoListSet[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetRoadPathInfoMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RoadPathInfoListSet.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
         oOut << RoadPathInfoListSet[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodResultLast::intnavifi_tclMsgGetRoadPathInfoMethodResultLast(const intnavifi_tclMsgGetRoadPathInfoMethodResultLast& coRef):fi_tclVisitableTypeBase(coRef)
{
   RoadPathInfoListSet = coRef.RoadPathInfoListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetRoadPathInfoMethodResultLast& intnavifi_tclMsgGetRoadPathInfoMethodResultLast::operator=(const intnavifi_tclMsgGetRoadPathInfoMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   RoadPathInfoListSet = coRef.RoadPathInfoListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetRoadPathInfoMethodResultLast::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetRoadPathInfoMethodResultLast::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETROADPATHINFO;}
tU8 intnavifi_tclMsgGetRoadPathInfoMethodResultLast::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTLAST;}

tVoid intnavifi_tclMsgGetRoadPathInfoMethodResultLast::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
         RoadPathInfoListSet[u32Idx].vDestroy();
   }
   RoadPathInfoListSet.clear();
}

tU32 intnavifi_tclMsgGetRoadPathInfoMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RoadPathInfoListSet.size(); ++u32ListIdx)
      u32DynamicSize += RoadPathInfoListSet[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool intnavifi_tclMsgGetRoadPathInfoMethodResultLast::operator==(const intnavifi_tclMsgGetRoadPathInfoMethodResultLast& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RoadPathInfoListSet.size() == rfoCmp.RoadPathInfoListSet.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadPathInfoListSet.size()); ++u32Idx)
            bResult = bResult && (RoadPathInfoListSet[u32Idx] == rfoCmp.RoadPathInfoListSet[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetRoadPathInfoMethodResultLast::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
      {
         RoadPathInfoListSet[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadPathInfoListSet.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadPathInfoListSet[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetRoadPathInfoMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RoadPathInfoListSet.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadPathInfoListSet.size(); ++u32Idx)
         oOut << RoadPathInfoListSet[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodStart::intnavifi_tclMsgGetUPOIsMethodStart(const intnavifi_tclMsgGetUPOIsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   FilterList = coRef.FilterList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodStart& intnavifi_tclMsgGetUPOIsMethodStart::operator=(const intnavifi_tclMsgGetUPOIsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   FilterList = coRef.FilterList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetUPOIsMethodStart::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetUPOIsMethodStart::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETUPOIS;}
tU8 intnavifi_tclMsgGetUPOIsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intnavifi_tclMsgGetUPOIsMethodStart::vDestroy()
{
   RoadPathListSet.vDestroy(); 
   FilterList.vDestroy(); 
}

tU32 intnavifi_tclMsgGetUPOIsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+RoadPathListSet.u32GetSize(u16MajorVersion)+FilterList.u32GetSize(u16MajorVersion);
}

tBool intnavifi_tclMsgGetUPOIsMethodStart::operator==(const intnavifi_tclMsgGetUPOIsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequestId == rfoCmp.RequestId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RoadPathListSet == rfoCmp.RoadPathListSet);
      bResult = bResult && (FilterList == rfoCmp.FilterList);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetUPOIsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> RequestId;
   oIn >> DataSetId;
   oIn >> RoadPathListSet;
   oIn >> FilterList;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetUPOIsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RequestId;
   oOut << DataSetId;
   oOut << RoadPathListSet;
   oOut << FilterList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodResult::intnavifi_tclMsgGetUPOIsMethodResult(const intnavifi_tclMsgGetUPOIsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   UPOIListSet = coRef.UPOIListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodResult& intnavifi_tclMsgGetUPOIsMethodResult::operator=(const intnavifi_tclMsgGetUPOIsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   UPOIListSet = coRef.UPOIListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetUPOIsMethodResult::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetUPOIsMethodResult::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETUPOIS;}
tU8 intnavifi_tclMsgGetUPOIsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intnavifi_tclMsgGetUPOIsMethodResult::vDestroy()
{
   RoadPathListSet.vDestroy(); 
   UPOIListSet.vDestroy(); 
}

tU32 intnavifi_tclMsgGetUPOIsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+RoadPathListSet.u32GetSize(u16MajorVersion)+UPOIListSet.u32GetSize(u16MajorVersion);
}

tBool intnavifi_tclMsgGetUPOIsMethodResult::operator==(const intnavifi_tclMsgGetUPOIsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequestId == rfoCmp.RequestId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RoadPathListSet == rfoCmp.RoadPathListSet);
      bResult = bResult && (UPOIListSet == rfoCmp.UPOIListSet);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetUPOIsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> RequestId;
   oIn >> DataSetId;
   oIn >> RoadPathListSet;
   oIn >> UPOIListSet;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetUPOIsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RequestId;
   oOut << DataSetId;
   oOut << RoadPathListSet;
   oOut << UPOIListSet;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodResultFirst::intnavifi_tclMsgGetUPOIsMethodResultFirst(const intnavifi_tclMsgGetUPOIsMethodResultFirst& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   UPOIListSet = coRef.UPOIListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodResultFirst& intnavifi_tclMsgGetUPOIsMethodResultFirst::operator=(const intnavifi_tclMsgGetUPOIsMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   UPOIListSet = coRef.UPOIListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetUPOIsMethodResultFirst::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetUPOIsMethodResultFirst::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETUPOIS;}
tU8 intnavifi_tclMsgGetUPOIsMethodResultFirst::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTFIRST;}

tVoid intnavifi_tclMsgGetUPOIsMethodResultFirst::vDestroy()
{
   RoadPathListSet.vDestroy(); 
   UPOIListSet.vDestroy(); 
}

tU32 intnavifi_tclMsgGetUPOIsMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+RoadPathListSet.u32GetSize(u16MajorVersion)+UPOIListSet.u32GetSize(u16MajorVersion);
}

tBool intnavifi_tclMsgGetUPOIsMethodResultFirst::operator==(const intnavifi_tclMsgGetUPOIsMethodResultFirst& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequestId == rfoCmp.RequestId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RoadPathListSet == rfoCmp.RoadPathListSet);
      bResult = bResult && (UPOIListSet == rfoCmp.UPOIListSet);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetUPOIsMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   oIn >> RequestId;
   oIn >> DataSetId;
   oIn >> RoadPathListSet;
   oIn >> UPOIListSet;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetUPOIsMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RequestId;
   oOut << DataSetId;
   oOut << RoadPathListSet;
   oOut << UPOIListSet;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodResultMiddle::intnavifi_tclMsgGetUPOIsMethodResultMiddle(const intnavifi_tclMsgGetUPOIsMethodResultMiddle& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   UPOIListSet = coRef.UPOIListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodResultMiddle& intnavifi_tclMsgGetUPOIsMethodResultMiddle::operator=(const intnavifi_tclMsgGetUPOIsMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   UPOIListSet = coRef.UPOIListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetUPOIsMethodResultMiddle::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetUPOIsMethodResultMiddle::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETUPOIS;}
tU8 intnavifi_tclMsgGetUPOIsMethodResultMiddle::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTMIDDLE;}

tVoid intnavifi_tclMsgGetUPOIsMethodResultMiddle::vDestroy()
{
   RoadPathListSet.vDestroy(); 
   UPOIListSet.vDestroy(); 
}

tU32 intnavifi_tclMsgGetUPOIsMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+RoadPathListSet.u32GetSize(u16MajorVersion)+UPOIListSet.u32GetSize(u16MajorVersion);
}

tBool intnavifi_tclMsgGetUPOIsMethodResultMiddle::operator==(const intnavifi_tclMsgGetUPOIsMethodResultMiddle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequestId == rfoCmp.RequestId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RoadPathListSet == rfoCmp.RoadPathListSet);
      bResult = bResult && (UPOIListSet == rfoCmp.UPOIListSet);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetUPOIsMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   oIn >> RequestId;
   oIn >> DataSetId;
   oIn >> RoadPathListSet;
   oIn >> UPOIListSet;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetUPOIsMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RequestId;
   oOut << DataSetId;
   oOut << RoadPathListSet;
   oOut << UPOIListSet;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodResultLast::intnavifi_tclMsgGetUPOIsMethodResultLast(const intnavifi_tclMsgGetUPOIsMethodResultLast& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   UPOIListSet = coRef.UPOIListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgGetUPOIsMethodResultLast& intnavifi_tclMsgGetUPOIsMethodResultLast::operator=(const intnavifi_tclMsgGetUPOIsMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   DataSetId = coRef.DataSetId;
   RoadPathListSet = coRef.RoadPathListSet;
   UPOIListSet = coRef.UPOIListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgGetUPOIsMethodResultLast::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgGetUPOIsMethodResultLast::u16GetFunctionID() const {return INTNAVIFI_C_U16_GETUPOIS;}
tU8 intnavifi_tclMsgGetUPOIsMethodResultLast::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTLAST;}

tVoid intnavifi_tclMsgGetUPOIsMethodResultLast::vDestroy()
{
   RoadPathListSet.vDestroy(); 
   UPOIListSet.vDestroy(); 
}

tU32 intnavifi_tclMsgGetUPOIsMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+RoadPathListSet.u32GetSize(u16MajorVersion)+UPOIListSet.u32GetSize(u16MajorVersion);
}

tBool intnavifi_tclMsgGetUPOIsMethodResultLast::operator==(const intnavifi_tclMsgGetUPOIsMethodResultLast& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequestId == rfoCmp.RequestId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (RoadPathListSet == rfoCmp.RoadPathListSet);
      bResult = bResult && (UPOIListSet == rfoCmp.UPOIListSet);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgGetUPOIsMethodResultLast::oRead(fi_tclInContext& oIn)
{
   oIn >> RequestId;
   oIn >> DataSetId;
   oIn >> RoadPathListSet;
   oIn >> UPOIListSet;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgGetUPOIsMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RequestId;
   oOut << DataSetId;
   oOut << RoadPathListSet;
   oOut << UPOIListSet;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgMediumAvailGet::intnavifi_tclMsgMediumAvailGet(const intnavifi_tclMsgMediumAvailGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgMediumAvailGet& intnavifi_tclMsgMediumAvailGet::operator=(const intnavifi_tclMsgMediumAvailGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgMediumAvailGet::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgMediumAvailGet::u16GetFunctionID() const {return INTNAVIFI_C_U16_MEDIUMAVAIL;}
tU8 intnavifi_tclMsgMediumAvailGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intnavifi_tclMsgMediumAvailGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgMediumAvailGet::operator==(const intnavifi_tclMsgMediumAvailGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgMediumAvailGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgMediumAvailGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgMediumAvailStatus::intnavifi_tclMsgMediumAvailStatus(const intnavifi_tclMsgMediumAvailStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediumId = coRef.MediumId;
   DataSetId = coRef.DataSetId;
   DataAvailability = coRef.DataAvailability;
   DataAccessEnabled = coRef.DataAccessEnabled;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgMediumAvailStatus& intnavifi_tclMsgMediumAvailStatus::operator=(const intnavifi_tclMsgMediumAvailStatus& coRef)
{
   if (this == &coRef) return *this;
   MediumId = coRef.MediumId;
   DataSetId = coRef.DataSetId;
   DataAvailability = coRef.DataAvailability;
   DataAccessEnabled = coRef.DataAccessEnabled;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgMediumAvailStatus::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgMediumAvailStatus::u16GetFunctionID() const {return INTNAVIFI_C_U16_MEDIUMAVAIL;}
tU8 intnavifi_tclMsgMediumAvailStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intnavifi_tclMsgMediumAvailStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool intnavifi_tclMsgMediumAvailStatus::operator==(const intnavifi_tclMsgMediumAvailStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediumId == rfoCmp.MediumId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (DataAvailability == rfoCmp.DataAvailability);
      bResult = bResult && (DataAccessEnabled == rfoCmp.DataAccessEnabled);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgMediumAvailStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediumId;
   oIn >> DataSetId;
   oIn >> DataAvailability;
   oIn >> DataAccessEnabled;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgMediumAvailStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediumId;
   oOut << DataSetId;
   oOut << DataAvailability;
   oOut << DataAccessEnabled;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgLocDatabaseGet::intnavifi_tclMsgLocDatabaseGet(const intnavifi_tclMsgLocDatabaseGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgLocDatabaseGet& intnavifi_tclMsgLocDatabaseGet::operator=(const intnavifi_tclMsgLocDatabaseGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgLocDatabaseGet::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgLocDatabaseGet::u16GetFunctionID() const {return INTNAVIFI_C_U16_LOCDATABASE;}
tU8 intnavifi_tclMsgLocDatabaseGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intnavifi_tclMsgLocDatabaseGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgLocDatabaseGet::operator==(const intnavifi_tclMsgLocDatabaseGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgLocDatabaseGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgLocDatabaseGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgLocDatabaseStatus::intnavifi_tclMsgLocDatabaseStatus(const intnavifi_tclMsgLocDatabaseStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataSetId = coRef.DataSetId;
   u32UpdateCounter = coRef.u32UpdateCounter;
   bDataExist = coRef.bDataExist;
   bDataComplete = coRef.bDataComplete;
   bLimitCorridor = coRef.bLimitCorridor;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgLocDatabaseStatus& intnavifi_tclMsgLocDatabaseStatus::operator=(const intnavifi_tclMsgLocDatabaseStatus& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   u32UpdateCounter = coRef.u32UpdateCounter;
   bDataExist = coRef.bDataExist;
   bDataComplete = coRef.bDataComplete;
   bLimitCorridor = coRef.bLimitCorridor;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgLocDatabaseStatus::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgLocDatabaseStatus::u16GetFunctionID() const {return INTNAVIFI_C_U16_LOCDATABASE;}
tU8 intnavifi_tclMsgLocDatabaseStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intnavifi_tclMsgLocDatabaseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool intnavifi_tclMsgLocDatabaseStatus::operator==(const intnavifi_tclMsgLocDatabaseStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (u32UpdateCounter == rfoCmp.u32UpdateCounter);
      bResult = bResult && (bDataExist == rfoCmp.bDataExist);
      bResult = bResult && (bDataComplete == rfoCmp.bDataComplete);
      bResult = bResult && (bLimitCorridor == rfoCmp.bLimitCorridor);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgLocDatabaseStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DataSetId;
   oIn >> u32UpdateCounter;
   oIn >> bDataExist;
   oIn >> bDataComplete;
   oIn >> bLimitCorridor;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgLocDatabaseStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataSetId;
   oOut << u32UpdateCounter;
   oOut << bDataExist;
   oOut << bDataComplete;
   oOut << bLimitCorridor;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgWakeUpStatus::intnavifi_tclMsgWakeUpStatus(const intnavifi_tclMsgWakeUpStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgWakeUpStatus& intnavifi_tclMsgWakeUpStatus::operator=(const intnavifi_tclMsgWakeUpStatus& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgWakeUpStatus::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgWakeUpStatus::u16GetFunctionID() const {return INTNAVIFI_C_U16_WAKEUP;}
tU8 intnavifi_tclMsgWakeUpStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intnavifi_tclMsgWakeUpStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgWakeUpStatus::operator==(const intnavifi_tclMsgWakeUpStatus& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgWakeUpStatus::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgWakeUpStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgEngineeringTextGet::intnavifi_tclMsgEngineeringTextGet(const intnavifi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgEngineeringTextGet& intnavifi_tclMsgEngineeringTextGet::operator=(const intnavifi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgEngineeringTextGet::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return INTNAVIFI_C_U16_ENGINEERINGTEXT;}
tU8 intnavifi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intnavifi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgEngineeringTextGet::operator==(const intnavifi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgEngineeringTextUpReg::intnavifi_tclMsgEngineeringTextUpReg(const intnavifi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgEngineeringTextUpReg& intnavifi_tclMsgEngineeringTextUpReg::operator=(const intnavifi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return INTNAVIFI_C_U16_ENGINEERINGTEXT;}
tU8 intnavifi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 intnavifi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgEngineeringTextUpReg::operator==(const intnavifi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgEngineeringTextRelUpReg::intnavifi_tclMsgEngineeringTextRelUpReg(const intnavifi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgEngineeringTextRelUpReg& intnavifi_tclMsgEngineeringTextRelUpReg::operator=(const intnavifi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return INTNAVIFI_C_U16_ENGINEERINGTEXT;}
tU8 intnavifi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 intnavifi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intnavifi_tclMsgEngineeringTextRelUpReg::operator==(const intnavifi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgEngineeringTextStatus::intnavifi_tclMsgEngineeringTextStatus(const intnavifi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intnavifi_tclMsgEngineeringTextStatus& intnavifi_tclMsgEngineeringTextStatus::operator=(const intnavifi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intnavifi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return INTNAVIFI_C_U16_SERVICE_ID;}
tU16 intnavifi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return INTNAVIFI_C_U16_ENGINEERINGTEXT;}
tU8 intnavifi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid intnavifi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 intnavifi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool intnavifi_tclMsgEngineeringTextStatus::operator==(const intnavifi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& intnavifi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& intnavifi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

