#ifndef INTNAVIFILANGUAGE_HEADER
#define INTNAVIFILANGUAGE_HEADER

class intnavifi_tclInContext;
class intnavifi_tclOutContext;
class intnavifi_tclVisitorBase;

class MY_DECL intnavifi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  intnavifi_tclDescription(fi_tclInContext* poIn, intnavifi_tclVisitorBase* poVisit);
  intnavifi_tclDescription(fi_tclOutContext* poOut, intnavifi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(intnavifi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ intnavifi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  intnavifi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<intnavifi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<intnavifi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline intnavifi_tclDescription::intnavifi_tclDescription(fi_tclInContext* poIn, intnavifi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline intnavifi_tclDescription::intnavifi_tclDescription(fi_tclOutContext* poOut, intnavifi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

