#include "precompiled.hh"

tBool intnavifi_tclDescription::bInitMessage(intnavifi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case intnavifi_tclToken::EN_LAST_TOKEN:
   case intnavifi_tclToken::EN_LIST:
   case intnavifi_tclToken::EN_END_OF_STRUCT:
   case intnavifi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case intnavifi_tclToken::EN_MSG_UPDATEMEDIAIDMETHODSTART:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case intnavifi_tclToken::EN_MSG_UPDATEMEDIAIDMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case intnavifi_tclToken::EN_MSG_FORCELOCDATABASEUPDATEMETHODSTART:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RECTANGLEWGS84,intnavifi_tclSemanticDomain::EN_MSG_NAVRECTANGLE));
   } break;
   case intnavifi_tclToken::EN_MSG_GETSPECIFICTRAFFICMESSAGESMETHODSTART:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_MSG_PATHNUMBER));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_MSG_PATH));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case intnavifi_tclToken::EN_MSG_GETSPECIFICTRAFFICMESSAGESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_MSG_PATHNUMBER));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMINFOLISTSET,intnavifi_tclSemanticDomain::EN_MSG_TMINFOLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_MSG_PATH));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_CURRENTTRAFFICMESSAGEREVISION));
   } break;
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_ROADPATHINFOCATEGORY,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHINFOCATEGORY));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_ROADINFOPRIORITY,intnavifi_tclSemanticDomain::EN_MSG_ROADINFOPRIORITY));
   } break;
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADPATHINFOLISTSET,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHINFOLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
   } break;
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTFIRST:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADPATHINFOLISTSET,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHINFOLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
   } break;
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTMIDDLE:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADPATHINFOLISTSET,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHINFOLISTSET));
   } break;
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTLAST:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADPATHINFOLISTSET,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHINFOLISTSET));
   } break;
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODSTART:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_FILTERLIST,intnavifi_tclSemanticDomain::EN_MSG_FILTERLIST));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_REQUESTID));
   } break;
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_LISTSET,intnavifi_tclSemanticDomain::EN_MSG_UPOILISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_REQUESTID));
   } break;
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTFIRST:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_LISTSET,intnavifi_tclSemanticDomain::EN_MSG_UPOILISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_REQUESTID));
   } break;
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTMIDDLE:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_LISTSET,intnavifi_tclSemanticDomain::EN_MSG_UPOILISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_REQUESTID));
   } break;
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTLAST:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_LISTSET,intnavifi_tclSemanticDomain::EN_MSG_UPOILISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_MSG_ROADPATHLISTSET));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_REQUESTID));
   } break;
   case intnavifi_tclToken::EN_MSG_MEDIUMAVAILSTATUS:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_MSG_DATAACCESSENABLED));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_DATAAVAILABLE,intnavifi_tclSemanticDomain::EN_MSG_DATAAVAILABILITY));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_MEDIUMID));
   } break;
   case intnavifi_tclToken::EN_MSG_LOCDATABASESTATUS:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_MSG_BLIMITCORRIDOR));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_MSG_BDATACOMPLETE));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_MSG_BDATAEXIST));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_MSG_U32UPDATECOUNTER));
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32_DATASETID,intnavifi_tclSemanticDomain::EN_MSG_DATASETID));
   } break;
   case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case intnavifi_tclToken::EN_BINCONTAINER:
   case intnavifi_tclToken::EN_RESERVED:
   case intnavifi_tclToken::EN_U8_PERCENT:
   case intnavifi_tclToken::EN_S16_PERTHOUSAND:
   case intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case intnavifi_tclToken::EN_S32_KILOGRAM:
   case intnavifi_tclToken::EN_S32_POUND:
   case intnavifi_tclToken::EN_S32_METER:
   case intnavifi_tclToken::EN_S32_YARDS:
   case intnavifi_tclToken::EN_S32_CENTIMETER:
   case intnavifi_tclToken::EN_S32_INCH:
   case intnavifi_tclToken::EN_S32_SECOND:
   case intnavifi_tclToken::EN_POSIXTIME:
   case intnavifi_tclToken::EN_E8_DST_STATE:
   case intnavifi_tclToken::EN_TIMEZONEELEMENT:
   case intnavifi_tclToken::EN_S16_KMPERHOUR:
   case intnavifi_tclToken::EN_S16_MILESPERHOUR:
   case intnavifi_tclToken::EN_S16_CENTIMETERSECOND:
   case intnavifi_tclToken::EN_FIVERSION:
   case intnavifi_tclToken::EN_S32_LONGITUDE:
   case intnavifi_tclToken::EN_S32_LATITUDE:
   case intnavifi_tclToken::EN_POSITIONWGS84:
   case intnavifi_tclToken::EN_RECTANGLEWGS84:
   case intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case intnavifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case intnavifi_tclToken::EN_E8_BINCONTAINERTYPES:
   case intnavifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   case intnavifi_tclToken::EN_E16_NAVIEVENTVALUE:
   case intnavifi_tclToken::EN_E8_TRAFFICMSGTYPE:
   case intnavifi_tclToken::EN_E8_TMLOCATIONTYPE:
   case intnavifi_tclToken::EN_E8_EVENTTYPE:
   case intnavifi_tclToken::EN_E16_EFFECTCODE:
   case intnavifi_tclToken::EN_E16_CAUSECODE:
   case intnavifi_tclToken::EN_E8_TENDENCY:
   case intnavifi_tclToken::EN_RDBID:
   case intnavifi_tclToken::EN_TMEVENT:
   case intnavifi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   case intnavifi_tclToken::EN_E8_TMURGENCY:
   case intnavifi_tclToken::EN_TMCODEDMESSAGE:
   case intnavifi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   case intnavifi_tclToken::EN_TMPROGRAMSERVICE:
   case intnavifi_tclToken::EN_MAPCOORDINATES:
   case intnavifi_tclToken::EN_B8_PRESENCEINDICATOR:
   case intnavifi_tclToken::EN_S8_MAPDISPLAYZLEVEL:
   case intnavifi_tclToken::EN_S8_MAPDISPLAYPRIORITY:
   case intnavifi_tclToken::EN_MAPCODEDELEMENT:
   case intnavifi_tclToken::EN_MAPCODEDELEMENTUNION0:
   case intnavifi_tclToken::EN_E8_MAPELEMENTDESCRTYPE:
   case intnavifi_tclToken::EN_MAPELEMENTDESCRIPTOR:
   case intnavifi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0:
   case intnavifi_tclToken::EN_MAPELEMENTDESCRIPTION:
   case intnavifi_tclToken::EN_E8_MAPGEOMETRICTYPE:
   case intnavifi_tclToken::EN_MAPGEOGRAPHICTYPE:
   case intnavifi_tclToken::EN_E8_SURFACECOVERCODE:
   case intnavifi_tclToken::EN_E8_SIGNPOSTDESTTYPE:
   case intnavifi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY:
   case intnavifi_tclToken::EN_E8_SIGNPOSTDESTSTATUS:
   case intnavifi_tclToken::EN_E8_DIRECTIONSTATUS:
   case intnavifi_tclToken::EN_SIGNPOSTDESTDIRECTION:
   case intnavifi_tclToken::EN_E8_DIRECTIONCATEGORY:
   case intnavifi_tclToken::EN_B8_DIRECTIONINFOSTATUS:
   case intnavifi_tclToken::EN_DIRECTIONCATEGORY:
   case intnavifi_tclToken::EN_DIRECTIONCATEGORYUNION0:
   case intnavifi_tclToken::EN_DIRECTIONINFO:
   case intnavifi_tclToken::EN_SIGNPOSTDESTINATION:
   case intnavifi_tclToken::EN_SIGNPOSTDESTINATIONUNION0:
   case intnavifi_tclToken::EN_REFERENCEELEMENT:
   case intnavifi_tclToken::EN_DIRECTIONINFOLISTSET:
   case intnavifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE:
   case intnavifi_tclToken::EN_E8_LANESTATUS:
   case intnavifi_tclToken::EN_B8_LANETYPE:
   case intnavifi_tclToken::EN_B8_LANECHANGERESTRICTION:
   case intnavifi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST:
   case intnavifi_tclToken::EN_U8_INDEXINLANEINFOLIST:
   case intnavifi_tclToken::EN_U8_DRIVINGDIRECTION:
   case intnavifi_tclToken::EN_LANEDIRECTION:
   case intnavifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case intnavifi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE:
   case intnavifi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE:
   case intnavifi_tclToken::EN_LANEINFOELEMENTREFERENCE:
   case intnavifi_tclToken::EN_E8_LANEREFERENCECATEGORY:
   case intnavifi_tclToken::EN_LANEREFERENCE:
   case intnavifi_tclToken::EN_LANEREFERENCEUNION0:
   case intnavifi_tclToken::EN_LANEINFO:
   case intnavifi_tclToken::EN_S32_EMU:
   case intnavifi_tclToken::EN_LANEINFOSEGMENT:
   case intnavifi_tclToken::EN_LANEINFOSEGMENTLIST:
   case intnavifi_tclToken::EN_WGS84COORDINATELIST:
   case intnavifi_tclToken::EN_SHAPEPOINTLISTSET:
   case intnavifi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE:
   case intnavifi_tclToken::EN_NAVONECELLDESC:
   case intnavifi_tclToken::EN_E8_ROADCLASSCODE:
   case intnavifi_tclToken::EN_UPOI_CATEGORY:
   case intnavifi_tclToken::EN_E8_UPOI_SOURCE:
   case intnavifi_tclToken::EN_B8_UPOI_FILTERSETSTATUS:
   case intnavifi_tclToken::EN_B8_UPOI_VALIDITY:
   case intnavifi_tclToken::EN_UPOI_ELEMENT:
   case intnavifi_tclToken::EN_B8_UPOI_FILTERSET_FIELDRELEVANCE:
   case intnavifi_tclToken::EN_UPOI_FILTERSET:
   case intnavifi_tclToken::EN_UPOI_FILTERLIST:
   case intnavifi_tclToken::EN_B8_UPOI_STATUS:
   case intnavifi_tclToken::EN_UPOI_COMBINATION:
   case intnavifi_tclToken::EN_UPOI_LISTSET:
   case intnavifi_tclToken::EN_E8_NAVONECELLCATEGORY:
   case intnavifi_tclToken::EN_REFERENCEELEMENTWITHID:
   case intnavifi_tclToken::EN_STATENAMEELEMENT:
   case intnavifi_tclToken::EN_COUNTYNAMEELEMENT:
   case intnavifi_tclToken::EN_CITYDISTRICTNAMEELEMENT:
   case intnavifi_tclToken::EN_BUILDUPAREANAMEELEMENT:
   case intnavifi_tclToken::EN_B8_ROADNUMBERSTATUS:
   case intnavifi_tclToken::EN_REQUIREDTAXDISC:
   case intnavifi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   case intnavifi_tclToken::EN_E8_REQUIREDPERMISSION:
   case intnavifi_tclToken::EN_GENERICREQUIREDPERMISSION:
   case intnavifi_tclToken::EN_REQUIREDPERMISSION:
   case intnavifi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   case intnavifi_tclToken::EN_COUNTRYNAMEELEMENT:
   case intnavifi_tclToken::EN_STATENAMELISTSET:
   case intnavifi_tclToken::EN_COUNTYNAMELISTSET:
   case intnavifi_tclToken::EN_CITYNAMEELEMENT:
   case intnavifi_tclToken::EN_INDEXINREFERENCELIST:
   case intnavifi_tclToken::EN_BUILDUPAREANAMELISTSET:
   case intnavifi_tclToken::EN_ROADNAMELISTSET:
   case intnavifi_tclToken::EN_COMPASSDIRECTION:
   case intnavifi_tclToken::EN_REQUIREDPERMISSIONLISTSET:
   case intnavifi_tclToken::EN_E8_INTERSECTIONTYPE:
   case intnavifi_tclToken::EN_TIMEZONELISTSET:
   case intnavifi_tclToken::EN_INTERSECTIONNAMEELEMENT:
   case intnavifi_tclToken::EN_ROADNAMEELEMENT:
   case intnavifi_tclToken::EN_ROADNUMBER:
   case intnavifi_tclToken::EN_INTERSECTIONNUMBERELEMENT:
   case intnavifi_tclToken::EN_MAPDESCRIPTIONLISTSET:
   case intnavifi_tclToken::EN_COUNTRYNAMELISTSET:
   case intnavifi_tclToken::EN_CITYNAMELISTSET:
   case intnavifi_tclToken::EN_SIGNPOSTELEMENT:
   case intnavifi_tclToken::EN_SIGNPOSTELEMENTUNION0:
   case intnavifi_tclToken::EN_ROADNUMBERLISTSET:
   case intnavifi_tclToken::EN_B16_ROADATTRIBUTE:
   case intnavifi_tclToken::EN_B32_ROADPROPERTY:
   case intnavifi_tclToken::EN_E8_NAVSTREETTYPE:
   case intnavifi_tclToken::EN_E8_ROADNETWORKCLASS:
   case intnavifi_tclToken::EN_ROADATTRIBUTES:
   case intnavifi_tclToken::EN_U32_DATASETID:
   case intnavifi_tclToken::EN_E8_EXTRADESCELEMENTTYPE:
   case intnavifi_tclToken::EN_EXTRADESCELEMENT:
   case intnavifi_tclToken::EN_EXTRADESCLISTSET:
   case intnavifi_tclToken::EN_B32_DATAPROPERTIES:
   case intnavifi_tclToken::EN_DATADESCELEMENT:
   case intnavifi_tclToken::EN_DATADESCLISTSET:
   case intnavifi_tclToken::EN_B8_CROSSROADPROPERTIES:
   case intnavifi_tclToken::EN_CROSSROADDESC:
   case intnavifi_tclToken::EN_E8_CROSSROADINFOCATEGORY:
   case intnavifi_tclToken::EN_CROSSROADINFO:
   case intnavifi_tclToken::EN_CROSSROADINFOUNION0:
   case intnavifi_tclToken::EN_INTERSECTIONDENOTATION:
   case intnavifi_tclToken::EN_INTERSECTIONPATHDENOTATION:
   case intnavifi_tclToken::EN_INTERSECTIONPATHDESC:
   case intnavifi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   case intnavifi_tclToken::EN_E8_SPEEDSIGN:
   case intnavifi_tclToken::EN_E16_WARNINGSIGN:
   case intnavifi_tclToken::EN_E16_REGULATORYSIGN:
   case intnavifi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   case intnavifi_tclToken::EN_TIMEDEPENDENTSTRING:
   case intnavifi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   case intnavifi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   case intnavifi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   case intnavifi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   case intnavifi_tclToken::EN_TRAFFICSIGNELEMENT:
   case intnavifi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   case intnavifi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   case intnavifi_tclToken::EN_ROADINFOCOMBINATION:
   case intnavifi_tclToken::EN_TRAFFICSIGNLISTSET:
   case intnavifi_tclToken::EN_B32_POICATEGORY:
   case intnavifi_tclToken::EN_POIELEMENT:
   case intnavifi_tclToken::EN_POILISTSET:
   case intnavifi_tclToken::EN_TOLLBOOTHELEMENT:
   case intnavifi_tclToken::EN_TOLLBOOTHLISTSET:
   case intnavifi_tclToken::EN_CITYDISTRICTNAMELISTSET:
   case intnavifi_tclToken::EN_POINTOFINTERESTELEMENT:
   case intnavifi_tclToken::EN_UNSPECIFIEDTEXT:
   case intnavifi_tclToken::EN_E8_SHAPETYPE:
   case intnavifi_tclToken::EN_SHAPE:
   case intnavifi_tclToken::EN_TMSERVICEPROVIDER:
   case intnavifi_tclToken::EN_E8_TMCATEGORY:
   case intnavifi_tclToken::EN_E8_TMFLOWIMPACT:
   case intnavifi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY:
   case intnavifi_tclToken::EN_B8_TMMAPPINGSTATUS:
   case intnavifi_tclToken::EN_E8_TMAFFECTIONTYPE:
   case intnavifi_tclToken::EN_B8_TMONECELLATTRIBUTE:
   case intnavifi_tclToken::EN_TMONECELLPORTION:
   case intnavifi_tclToken::EN_E8_TMVALUESTATUS:
   case intnavifi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE:
   case intnavifi_tclToken::EN_TMCSTRUCTUREDTEXT:
   case intnavifi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE:
   case intnavifi_tclToken::EN_B8_TMRELEVANCE:
   case intnavifi_tclToken::EN_TMINFO:
   case intnavifi_tclToken::EN_TMCOMBINATION:
   case intnavifi_tclToken::EN_NAVCLUSTERDESC:
   case intnavifi_tclToken::EN_NAVONECELL:
   case intnavifi_tclToken::EN_LANEINFOLISTSET:
   case intnavifi_tclToken::EN_LANEINFOONECELLREFERENCE:
   case intnavifi_tclToken::EN_SIGNPOSTLISTSET:
   case intnavifi_tclToken::EN_NAVPLAINPATHLISTSET:
   case intnavifi_tclToken::EN_E8_ROADINFOPRIORITY:
   case intnavifi_tclToken::EN_E8_ROADPATHINFOCATEGORY:
   case intnavifi_tclToken::EN_NAVINTERSECTIONLISTSET:
   case intnavifi_tclToken::EN_ROADPATHINFOCATEGORY:
   case intnavifi_tclToken::EN_ROADPATHINFOCATEGORYUNION0:
   case intnavifi_tclToken::EN_ROADPATHINFOLISTSET:
   case intnavifi_tclToken::EN_E8_DATAAVAILABLE:
   case intnavifi_tclToken::EN_TMINFOLISTSET:
   case intnavifi_tclToken::EN_U8:   
   case intnavifi_tclToken::EN_S8:   
   case intnavifi_tclToken::EN_U16:   
   case intnavifi_tclToken::EN_S16:   
   case intnavifi_tclToken::EN_U24:   
   case intnavifi_tclToken::EN_S24:   
   case intnavifi_tclToken::EN_U32:   
   case intnavifi_tclToken::EN_S32:   
   case intnavifi_tclToken::EN_U64:   
   case intnavifi_tclToken::EN_S64:   
   case intnavifi_tclToken::EN_F32:   
   case intnavifi_tclToken::EN_F64:   
   case intnavifi_tclToken::EN_BOOL:   
   case intnavifi_tclToken::EN_STRING:   
   case intnavifi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(intnavifi_tclKnot(enMsgToken,intnavifi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool intnavifi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool intnavifi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      intnavifi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      intnavifi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      intnavifi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == intnavifi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(intnavifi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(intnavifi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(intnavifi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case intnavifi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == intnavifi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case intnavifi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            intnavifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(intnavifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            intnavifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(intnavifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case intnavifi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case intnavifi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intnavifi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case intnavifi_tclToken::EN_MSG_UPDATEMEDIAIDMETHODSTART:
   case intnavifi_tclToken::EN_MSG_UPDATEMEDIAIDMETHODRESULT:
   case intnavifi_tclToken::EN_MSG_SMTIMEOUTMETHODSTART:
   case intnavifi_tclToken::EN_MSG_SMTIMEOUTMETHODRESULT:
   case intnavifi_tclToken::EN_MSG_FORCELOCDATABASEUPDATEMETHODSTART:
   case intnavifi_tclToken::EN_MSG_FORCELOCDATABASEUPDATEMETHODRESULT:
   case intnavifi_tclToken::EN_MSG_GETSPECIFICTRAFFICMESSAGESMETHODSTART:
   case intnavifi_tclToken::EN_MSG_GETSPECIFICTRAFFICMESSAGESMETHODRESULT:
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODSTART:
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULT:
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTFIRST:
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTMIDDLE:
   case intnavifi_tclToken::EN_MSG_GETROADPATHINFOMETHODRESULTLAST:
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODSTART:
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULT:
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTFIRST:
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTMIDDLE:
   case intnavifi_tclToken::EN_MSG_GETUPOISMETHODRESULTLAST:
   case intnavifi_tclToken::EN_MSG_MEDIUMAVAILGET:
   case intnavifi_tclToken::EN_MSG_MEDIUMAVAILSTATUS:
   case intnavifi_tclToken::EN_MSG_LOCDATABASEGET:
   case intnavifi_tclToken::EN_MSG_LOCDATABASESTATUS:
   case intnavifi_tclToken::EN_MSG_WAKEUPSTATUS:
   case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case intnavifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case intnavifi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S16_PERTHOUSAND:
   {
      fi_tcl_s16_PerThousand o_s16_PerThousand;
      if (!bDoIt(o_s16_PerThousand))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S32_KILOGRAM:
   {
      fi_tcl_s32_Kilogram o_s32_Kilogram;
      if (!bDoIt(o_s32_Kilogram))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S32_POUND:
   {
      fi_tcl_s32_Pound o_s32_Pound;
      if (!bDoIt(o_s32_Pound))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S32_YARDS:
   {
      fi_tcl_s32_Yards o_s32_Yards;
      if (!bDoIt(o_s32_Yards))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S32_CENTIMETER:
   {
      fi_tcl_s32_Centimeter o_s32_Centimeter;
      if (!bDoIt(o_s32_Centimeter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S32_INCH:
   {
      fi_tcl_s32_Inch o_s32_Inch;
      if (!bDoIt(o_s32_Inch))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S32_SECOND:
   {
      fi_tcl_s32_Second o_s32_Second;
      if (!bDoIt(o_s32_Second))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32,intnavifi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_DST_STATE:
   {
      fi_tcl_e8_DST_State o_e8_DST_State;
      if (!bDoIt(o_e8_DST_State))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_TIMEZONEELEMENT:
   {
      if (poVisitor->bDoExpand_TimeZoneElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_DST_TIMEDOMAIN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_SECOND,intnavifi_tclSemanticDomain::EN_DSTDIFFERENCE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_DST_STATE,intnavifi_tclSemanticDomain::EN_DST_STATE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_SECOND,intnavifi_tclSemanticDomain::EN_TIMEZONEDIFFERENCE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_ABBREVIATION_DST_IN_EFFECT));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_ABBREVIATION_STANDARDTIME));
      }
      else
      {
         fi_tcl_TimeZoneElement o_TimeZoneElement;
         if (!bDoIt(o_TimeZoneElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S16_MILESPERHOUR:
   {
      fi_tcl_s16_MilesPerHour o_s16_MilesPerHour;
      if (!bDoIt(o_s16_MilesPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_LATITUDE,intnavifi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_LONGITUDE,intnavifi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_RECTANGLEWGS84:
   {
      if (poVisitor->bDoExpand_RectangleWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_LATITUDE,intnavifi_tclSemanticDomain::EN_LATITUDEMAX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_LONGITUDE,intnavifi_tclSemanticDomain::EN_LONGITUDEMAX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_LATITUDE,intnavifi_tclSemanticDomain::EN_LATITUDEMIN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_LONGITUDE,intnavifi_tclSemanticDomain::EN_LONGITUDEMIN));
      }
      else
      {
         fi_tcl_RectangleWGS84 o_RectangleWGS84;
         if (!bDoIt(o_RectangleWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RectangleWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RectangleWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   {
      fi_tcl_e16_SelectionCriterionType o_e16_SelectionCriterionType;
      if (!bDoIt(o_e16_SelectionCriterionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E16_NAVIEVENTVALUE:
   {
      fi_tcl_e16_NaviEventValue o_e16_NaviEventValue;
      if (!bDoIt(o_e16_NaviEventValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_TRAFFICMSGTYPE:
   {
      fi_tcl_e8_TrafficMsgType o_e8_TrafficMsgType;
      if (!bDoIt(o_e8_TrafficMsgType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_TMLOCATIONTYPE:
   {
      fi_tcl_e8_TMLocationType o_e8_TMLocationType;
      if (!bDoIt(o_e8_TMLocationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_EVENTTYPE:
   {
      fi_tcl_e8_EventType o_e8_EventType;
      if (!bDoIt(o_e8_EventType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E16_EFFECTCODE:
   {
      fi_tcl_e16_EffectCode o_e16_EffectCode;
      if (!bDoIt(o_e16_EffectCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E16_CAUSECODE:
   {
      fi_tcl_e16_CauseCode o_e16_CauseCode;
      if (!bDoIt(o_e16_CauseCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_TENDENCY:
   {
      fi_tcl_e8_Tendency o_e8_Tendency;
      if (!bDoIt(o_e8_Tendency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_RDBID:
   {
      if (poVisitor->bDoExpand_RDBId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_BSA));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_TABLENO));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_TMCCOUNTRYCODE));
      }
      else
      {
         fi_tcl_RDBId o_RDBId;
         if (!bDoIt(o_RDBId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_TMEVENT:
   {
      if (poVisitor->bDoExpand_TMEvent(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_PRIORITY));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_CENTIMETERSECOND,intnavifi_tclSemanticDomain::EN_AVERAGESPEEDCMPERSEC));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_KMPERHOUR,intnavifi_tclSemanticDomain::EN_AVERAGESPEED));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_CENTIMETERSECOND,intnavifi_tclSemanticDomain::EN_SPEEDLIMITADVICECMPERSEC));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_KMPERHOUR,intnavifi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_SECOND,intnavifi_tclSemanticDomain::EN_DELAYINFORMATION));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_METER,intnavifi_tclSemanticDomain::EN_LENGTHINFORMATION));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_CAUSECODE,intnavifi_tclSemanticDomain::EN_CAUSE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TENDENCY,intnavifi_tclSemanticDomain::EN_TENDENCY));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_EFFECTCODE,intnavifi_tclSemanticDomain::EN_EFFECT));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_NAVIEVENTVALUE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_EVENTTYPE,intnavifi_tclSemanticDomain::EN_EVENTTYPE));
         }
      }
      else
      {
         fi_tcl_TMEvent o_TMEvent;
         if (!bDoIt(o_TMEvent))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   {
      fi_tcl_b32_TrafficMessageSource o_b32_TrafficMessageSource;
      if (!bDoIt(o_b32_TrafficMessageSource))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_TMURGENCY:
   {
      fi_tcl_e8_TMUrgency o_e8_TMUrgency;
      if (!bDoIt(o_e8_TMUrgency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_TMCODEDMESSAGE:
   {
      if (poVisitor->bDoExpand_TMCodedMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RDBID,intnavifi_tclSemanticDomain::EN_RDBID));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMEVENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_EVENTS));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_BIDIRECTIONAL));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_EXTENT));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMLOCATIONTYPE,intnavifi_tclSemanticDomain::EN_PRIMARYLOCATIONTYPE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_SECONDARYLOCATIONCODE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_PRIMARYLOCATIONCODE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_AVERAGESPEED));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_LENGTHINFOANDLABEL2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_ROADNUMBERSUFFIX));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_ROADNUMBER));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_ROADCLASS));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_ADDITIONALNEV7));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_ADDITIONALNEV6));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_ADDITIONALNEV5));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_ADDITIONALNEV4));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_ADDITIONALNEV3));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_ADDITIONALNEV2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_ADDITIONALNEV1));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_MAINNEV));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_DIRECTIONALITY));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_DIRANDEXTENT));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_LOCATIONTYPE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_LOCATION2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_LOCATION1));
         }
      }
      else
      {
         fi_tcl_TMCodedMessage o_TMCodedMessage;
         if (!bDoIt(o_TMCodedMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case intnavifi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   {
      if (poVisitor->bDoExpand_TMCodedMessageBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMCODEDMESSAGE,intnavifi_tclSemanticDomain::EN_TMCODEDMESSAGE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_BINCONTAINERTYPES,intnavifi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_FIVERSION,intnavifi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_TMCodedMessageBinContainer o_TMCodedMessageBinContainer;
         if (!bDoIt(o_TMCodedMessageBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case intnavifi_tclToken::EN_TMPROGRAMSERVICE:
   {
      if (poVisitor->bDoExpand_TMProgramService(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_PROGRAMSERVICENAME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE,intnavifi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_EXTENDEDPROGRAMID));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_PROGRAMID));
      }
      else
      {
         fi_tcl_TMProgramService o_TMProgramService;
         if (!bDoIt(o_TMProgramService))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_MAPCOORDINATES:
   {
      if (poVisitor->bDoExpand_MapCoordinates(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSITIONWGS84,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_COORDINATES));
      }
      else
      {
         fi_tcl_MapCoordinates o_MapCoordinates;
         if (!bDoIt(o_MapCoordinates))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCoordinates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCoordinates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B8_PRESENCEINDICATOR:
   {
      fi_tcl_b8_PresenceIndicator o_b8_PresenceIndicator;
      if (!bDoIt(o_b8_PresenceIndicator))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S8_MAPDISPLAYZLEVEL:
   {
      fi_tcl_s8_MapDisplayZLevel o_s8_MapDisplayZLevel;
      if (!bDoIt(o_s8_MapDisplayZLevel))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_S8_MAPDISPLAYPRIORITY:
   {
      fi_tcl_s8_MapDisplayPriority o_s8_MapDisplayPriority;
      if (!bDoIt(o_s8_MapDisplayPriority))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_MAPCODEDELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_b8_PresenceIndicator oDataMask;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_PRESENCEINDICATOR,intnavifi_tclSemanticDomain::EN_DATA_MASK));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataMask);
      oCallStack.bGoUp();
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES)
      {
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPCOORDINATES,intnavifi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL)
      {
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S8_MAPDISPLAYZLEVEL,intnavifi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY)
      {
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S8_MAPDISPLAYPRIORITY,intnavifi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION)
      {
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPELEMENTDESCRIPTION,intnavifi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE)
      {
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPGEOGRAPHICTYPE,intnavifi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE)
      {
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_MAPGEOMETRICTYPE,intnavifi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE)
      {
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE,intnavifi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
   } break;
   case intnavifi_tclToken::EN_MAPCODEDELEMENT:
   {
      if (poVisitor->bDoExpand_MapCodedElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPCODEDELEMENTUNION0,intnavifi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      else
      {
         fi_tcl_MapCodedElement o_MapCodedElement;
         if (!bDoIt(o_MapCodedElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCodedElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCodedElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_MAPELEMENTDESCRTYPE:
   {
      fi_tcl_e8_MapElementDescrType o_e8_MapElementDescrType;
      if (!bDoIt(o_e8_MapElementDescrType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_MapElementDescrType oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_MAPELEMENTDESCRTYPE,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TSTRING:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_MAPGEOGRAPHICTYPE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPGEOGRAPHICTYPE,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_ROADCLASSCODE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_ROADCLASSCODE,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_B16_ROADATTRIBUTE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B16_ROADATTRIBUTE,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBER,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_SURFACECOVERCODE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_SURFACECOVERCODE,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E16_NAVIEVENTVALUE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_NAVIEVENTVALUE,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_MAPELEMENTDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_MapElementDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0,intnavifi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
      }
      else
      {
         fi_tcl_MapElementDescriptor o_MapElementDescriptor;
         if (!bDoIt(o_MapElementDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_MAPELEMENTDESCRIPTION:
   {
      if (poVisitor->bDoExpand_MapElementDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPELEMENTDESCRIPTOR,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_DESCRIPTION));
      }
      else
      {
         fi_tcl_MapElementDescription o_MapElementDescription;
         if (!bDoIt(o_MapElementDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_MAPGEOMETRICTYPE:
   {
      fi_tcl_e8_MapGeometricType o_e8_MapGeometricType;
      if (!bDoIt(o_e8_MapGeometricType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_MAPGEOGRAPHICTYPE:
   {
      if (poVisitor->bDoExpand_MapGeographicType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,intnavifi_tclSemanticDomain::EN_MAPGEOGRAPHICTYPE));
      }
      else
      {
         fi_tcl_MapGeographicType o_MapGeographicType;
         if (!bDoIt(o_MapGeographicType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapGeographicType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapGeographicType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_SURFACECOVERCODE:
   {
      fi_tcl_e8_SurfaceCoverCode o_e8_SurfaceCoverCode;
      if (!bDoIt(o_e8_SurfaceCoverCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_SIGNPOSTDESTTYPE:
   {
      fi_tcl_e8_SignPostDestType o_e8_SignPostDestType;
      if (!bDoIt(o_e8_SignPostDestType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY:
   {
      fi_tcl_e8_SignPostDestinationCategory o_e8_SignPostDestinationCategory;
      if (!bDoIt(o_e8_SignPostDestinationCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_SIGNPOSTDESTSTATUS:
   {
      fi_tcl_e8_SignPostDestStatus o_e8_SignPostDestStatus;
      if (!bDoIt(o_e8_SignPostDestStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_DIRECTIONSTATUS:
   {
      fi_tcl_e8_DirectionStatus o_e8_DirectionStatus;
      if (!bDoIt(o_e8_DirectionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_SIGNPOSTDESTDIRECTION:
   {
      if (poVisitor->bDoExpand_SignPostDestDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_DIRECTIONABSOLUTE,intnavifi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_SignPostDestDirection o_SignPostDestDirection;
         if (!bDoIt(o_SignPostDestDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_DIRECTIONCATEGORY:
   {
      fi_tcl_e8_DirectionCategory o_e8_DirectionCategory;
      if (!bDoIt(o_e8_DirectionCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_DIRECTIONINFOSTATUS:
   {
      fi_tcl_b8_DirectionInfoStatus o_b8_DirectionInfoStatus;
      if (!bDoIt(o_b8_DirectionInfoStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_DIRECTIONCATEGORYUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_DirectionCategory oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_DIRECTIONCATEGORY,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COUNTRYNAMEELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STATENAMEELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COUNTYNAMEELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CITYNAMEELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CITYDISTRICTNAMEELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BUILDUPAREANAMEELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNAMEELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBER,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INTERSECTIONNAMEELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INTERSECTIONNUMBERELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POINTOFINTERESTELEMENT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UNSPECIFIEDTEXT,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COMPASSDIRECTION,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_DIRECTIONCATEGORY:
   {
      if (poVisitor->bDoExpand_DirectionCategory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_DIRECTIONCATEGORYUNION0,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
      }
      else
      {
         fi_tcl_DirectionCategory o_DirectionCategory;
         if (!bDoIt(o_DirectionCategory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_DIRECTIONINFO:
   {
      if (poVisitor->bDoExpand_DirectionInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_DIRECTIONINFOSTATUS,intnavifi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_DIRECTIONSTATUS,intnavifi_tclSemanticDomain::EN_DIRECTIONSTATUS));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_DIRECTIONCATEGORY,intnavifi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_DIRECTIONID));
      }
      else
      {
         fi_tcl_DirectionInfo o_DirectionInfo;
         if (!bDoIt(o_DirectionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_SIGNPOSTDESTINATIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_SignPostDestinationCategory oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COUNTRYNAMEELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STATENAMEELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COUNTYNAMEELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CITYNAMEELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CITYDISTRICTNAMEELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BUILDUPAREANAMEELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNAMEELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBER,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INTERSECTIONNAMEELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INTERSECTIONNUMBERELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POINTOFINTERESTELEMENT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UNSPECIFIEDTEXT,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COMPASSDIRECTION,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_SIGNPOSTDESTINATION:
   {
      if (poVisitor->bDoExpand_SignPostDestination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_DIRECTIONINFO,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_DIRECTIONINFOLIST));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_SIGNPOSTDESTDIRECTION,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONDIRECTION));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_SIGNPOSTDESTINATIONUNION0,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_SIGNPOSTDESTTYPE,intnavifi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_SignPostDestination o_SignPostDestination;
         if (!bDoIt(o_SignPostDestination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_REFERENCEELEMENT:
   {
      if (poVisitor->bDoExpand_ReferenceElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_ReferenceElement o_ReferenceElement;
         if (!bDoIt(o_ReferenceElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_DIRECTIONINFOLISTSET:
   {
      if (poVisitor->bDoExpand_DirectionInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_DIRECTIONINFO,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_DIRECTIONINFOLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_DirectionInfoListSet o_DirectionInfoListSet;
         if (!bDoIt(o_DirectionInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE:
   {
      fi_tcl_u16_UserTrafficMessageHandle o_u16_UserTrafficMessageHandle;
      if (!bDoIt(o_u16_UserTrafficMessageHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_LANESTATUS:
   {
      fi_tcl_e8_LaneStatus o_e8_LaneStatus;
      if (!bDoIt(o_e8_LaneStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_LANETYPE:
   {
      fi_tcl_b8_LaneType o_b8_LaneType;
      if (!bDoIt(o_b8_LaneType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_LANECHANGERESTRICTION:
   {
      fi_tcl_b8_LaneChangeRestriction o_b8_LaneChangeRestriction;
      if (!bDoIt(o_b8_LaneChangeRestriction))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST:
   {
      fi_tcl_u8_IndexInLaneInfoSegmentList o_u8_IndexInLaneInfoSegmentList;
      if (!bDoIt(o_u8_IndexInLaneInfoSegmentList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_U8_INDEXINLANEINFOLIST:
   {
      fi_tcl_u8_IndexInLaneInfoList o_u8_IndexInLaneInfoList;
      if (!bDoIt(o_u8_IndexInLaneInfoList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_U8_DRIVINGDIRECTION:
   {
      fi_tcl_u8_DrivingDirection o_u8_DrivingDirection;
      if (!bDoIt(o_u8_DrivingDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_LANEDIRECTION:
   {
      if (poVisitor->bDoExpand_LaneDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_LANETYPE,intnavifi_tclSemanticDomain::EN_FOLLOWINGLANETYPE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_LANESTATUS,intnavifi_tclSemanticDomain::EN_FOLLOWINGLANESTATUS));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_DRIVINGDIRECTION,intnavifi_tclSemanticDomain::EN_DIRECTIONTOFOLLOWINGLANE));
      }
      else
      {
         fi_tcl_LaneDirection o_LaneDirection;
         if (!bDoIt(o_LaneDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoOneCellIndexReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_INDEXINLANEINFOLIST,intnavifi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,intnavifi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_ONECELLINDEX));
      }
      else
      {
         fi_tcl_LaneInfoOneCellIndexReference o_LaneInfoOneCellIndexReference;
         if (!bDoIt(o_LaneInfoOneCellIndexReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoPathSectionIndexReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_INDEXINLANEINFOLIST,intnavifi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,intnavifi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_PATHSECTIONINDEX));
      }
      else
      {
         fi_tcl_LaneInfoPathSectionIndexReference o_LaneInfoPathSectionIndexReference;
         if (!bDoIt(o_LaneInfoPathSectionIndexReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoPathSectionIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoPathSectionIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_LANEINFOELEMENTREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoElementReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_INDEXINLANEINFOLIST,intnavifi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_ELEMENTID));
      }
      else
      {
         fi_tcl_LaneInfoElementReference o_LaneInfoElementReference;
         if (!bDoIt(o_LaneInfoElementReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoElementReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoElementReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_LANEREFERENCECATEGORY:
   {
      fi_tcl_e8_LaneReferenceCategory o_e8_LaneReferenceCategory;
      if (!bDoIt(o_e8_LaneReferenceCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_LANEREFERENCEUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LaneReferenceCategory oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_LANEREFERENCECATEGORY,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE) &&
          !(11 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEINFOONECELLREFERENCE,intnavifi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE,intnavifi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEINFOELEMENTREFERENCE,intnavifi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE,intnavifi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_LANEREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEDIRECTION,intnavifi_tclSemanticDomain::EN_LANEDIRECTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEREFERENCEUNION0,intnavifi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
      }
      else
      {
         fi_tcl_LaneReference o_LaneReference;
         if (!bDoIt(o_LaneReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_LANEINFO:
   {
      if (poVisitor->bDoExpand_LaneInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEREFERENCE,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_FOLLOWINGLANELIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_LANECHANGERESTRICTION,intnavifi_tclSemanticDomain::EN_CHANGERESTRICTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_LANETYPE,intnavifi_tclSemanticDomain::EN_TYPE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_LANESTATUS,intnavifi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_LaneInfo o_LaneInfo;
         if (!bDoIt(o_LaneInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_S32_EMU:
   {
      fi_tcl_s32_EMU o_s32_EMU;
      if (!bDoIt(o_s32_EMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_LANEINFOSEGMENT:
   {
      if (poVisitor->bDoExpand_LaneInfoSegment(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEINFO,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_LANEINFOLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_EMU,intnavifi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_LaneInfoSegment o_LaneInfoSegment;
         if (!bDoIt(o_LaneInfoSegment))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_LANEINFOSEGMENTLIST:
   {
      if (poVisitor->bDoExpand_LaneInfoSegmentList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEINFOSEGMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_LANEINFOSEGMENTLIST));
      }
      else
      {
         fi_tcl_LaneInfoSegmentList o_LaneInfoSegmentList;
         if (!bDoIt(o_LaneInfoSegmentList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegmentList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegmentList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_WGS84COORDINATELIST:
   {
      if (poVisitor->bDoExpand_WGS84CoordinateList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSITIONWGS84,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_WGS84COORDINATELIST));
      }
      else
      {
         fi_tcl_WGS84CoordinateList o_WGS84CoordinateList;
         if (!bDoIt(o_WGS84CoordinateList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WGS84CoordinateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WGS84CoordinateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_SHAPEPOINTLISTSET:
   {
      if (poVisitor->bDoExpand_ShapePointListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_WGS84COORDINATELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_SHAPEPOINTLISTLIST));
      }
      else
      {
         fi_tcl_ShapePointListSet o_ShapePointListSet;
         if (!bDoIt(o_ShapePointListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ShapePointListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ShapePointListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE:
   {
      fi_tcl_e8_TMGeometricMessageType o_e8_TMGeometricMessageType;
      if (!bDoIt(o_e8_TMGeometricMessageType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_NAVONECELLDIRECTION,intnavifi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_ROADCLASSCODE:
   {
      fi_tcl_e8_RoadClassCode o_e8_RoadClassCode;
      if (!bDoIt(o_e8_RoadClassCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_UPOI_CATEGORY:
   {
      if (poVisitor->bDoExpand_UPOI_Category(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_VALUE));
      }
      else
      {
         fi_tcl_UPOI_Category o_UPOI_Category;
         if (!bDoIt(o_UPOI_Category))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Category.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Category.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_UPOI_SOURCE:
   {
      fi_tcl_e8_UPOI_Source o_e8_UPOI_Source;
      if (!bDoIt(o_e8_UPOI_Source))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_UPOI_FILTERSETSTATUS:
   {
      fi_tcl_b8_UPOI_FilterSetStatus o_b8_UPOI_FilterSetStatus;
      if (!bDoIt(o_b8_UPOI_FilterSetStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_UPOI_VALIDITY:
   {
      fi_tcl_b8_UPOI_Validity o_b8_UPOI_Validity;
      if (!bDoIt(o_b8_UPOI_Validity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_UPOI_ELEMENT:
   {
      if (poVisitor->bDoExpand_UPOI_Element(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (17 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSITIONWGS84,intnavifi_tclSemanticDomain::EN_PERPENDICULARPOINTPOSITION));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSITIONWGS84,intnavifi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_SHORTDESCRIPTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_UPOI_SOURCE,intnavifi_tclSemanticDomain::EN_SOURCE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_CATEGORY,intnavifi_tclSemanticDomain::EN_CATEGORY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_UNIQUEID));
      }
      else
      {
         fi_tcl_UPOI_Element o_UPOI_Element;
         if (!bDoIt(o_UPOI_Element))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Element.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Element.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B8_UPOI_FILTERSET_FIELDRELEVANCE:
   {
      fi_tcl_b8_UPOI_FilterSet_FieldRelevance o_b8_UPOI_FilterSet_FieldRelevance;
      if (!bDoIt(o_b8_UPOI_FilterSet_FieldRelevance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_UPOI_FILTERSET:
   {
      if (poVisitor->bDoExpand_UPOI_FilterSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_UPOI_FILTERSETSTATUS,intnavifi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_CATEGORY,intnavifi_tclSemanticDomain::EN_CATEGORY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_UPOI_SOURCE,intnavifi_tclSemanticDomain::EN_SOURCE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_UPOI_FILTERSET_FIELDRELEVANCE,intnavifi_tclSemanticDomain::EN_RELEVANCE));
      }
      else
      {
         fi_tcl_UPOI_FilterSet o_UPOI_FilterSet;
         if (!bDoIt(o_UPOI_FilterSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_FilterSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_FilterSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_UPOI_FILTERLIST:
   {
      if (poVisitor->bDoExpand_UPOI_FilterList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_FILTERSET,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_LIST));
      }
      else
      {
         fi_tcl_UPOI_FilterList o_UPOI_FilterList;
         if (!bDoIt(o_UPOI_FilterList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_FilterList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_FilterList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B8_UPOI_STATUS:
   {
      fi_tcl_b8_UPOI_Status o_b8_UPOI_Status;
      if (!bDoIt(o_b8_UPOI_Status))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_UPOI_COMBINATION:
   {
      if (poVisitor->bDoExpand_UPOI_Combination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (17 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_UPOI_STATUS,intnavifi_tclSemanticDomain::EN_UPOISTATUS));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSITIONWGS84,intnavifi_tclSemanticDomain::EN_PERPENDICULARPOINTPOSITION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_PERTHOUSAND,intnavifi_tclSemanticDomain::EN_ONROADOFFSET));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_UPOI_VALIDITY,intnavifi_tclSemanticDomain::EN_DATAVALIDITY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_UPOI_Combination o_UPOI_Combination;
         if (!bDoIt(o_UPOI_Combination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Combination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_Combination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_UPOI_LISTSET:
   {
      if (poVisitor->bDoExpand_UPOI_ListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_ELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_UPOI_REFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_UPOI_COMBINATION,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_COMBINATIONLIST));
      }
      else
      {
         fi_tcl_UPOI_ListSet o_UPOI_ListSet;
         if (!bDoIt(o_UPOI_ListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_ListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UPOI_ListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_NAVONECELLCATEGORY:
   {
      fi_tcl_e8_NavOneCellCategory o_e8_NavOneCellCategory;
      if (!bDoIt(o_e8_NavOneCellCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_REFERENCEELEMENTWITHID:
   {
      if (poVisitor->bDoExpand_ReferenceElementWithID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_ReferenceElementWithID o_ReferenceElementWithID;
         if (!bDoIt(o_ReferenceElementWithID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElementWithID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElementWithID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_STATENAMEELEMENT:
   {
      if (poVisitor->bDoExpand_StateNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_STATECODE_OLD));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_STATENAME));
      }
      else
      {
         fi_tcl_StateNameElement o_StateNameElement;
         if (!bDoIt(o_StateNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_COUNTYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CountyNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_COUNTYNAME));
      }
      else
      {
         fi_tcl_CountyNameElement o_CountyNameElement;
         if (!bDoIt(o_CountyNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_CITYDISTRICTNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CityDistrictNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S8,intnavifi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_CityDistrictNameElement o_CityDistrictNameElement;
         if (!bDoIt(o_CityDistrictNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_BUILDUPAREANAMEELEMENT:
   {
      if (poVisitor->bDoExpand_BuildUpAreaNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S8,intnavifi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_BuildUpAreaNameElement o_BuildUpAreaNameElement;
         if (!bDoIt(o_BuildUpAreaNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B8_ROADNUMBERSTATUS:
   {
      fi_tcl_b8_RoadNumberStatus o_b8_RoadNumberStatus;
      if (!bDoIt(o_b8_RoadNumberStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_REQUIREDTAXDISC:
   {
      if (poVisitor->bDoExpand_RequiredTaxDisc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_REGION));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE,intnavifi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32,intnavifi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_RequiredTaxDisc o_RequiredTaxDisc;
         if (!bDoIt(o_RequiredTaxDisc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   {
      fi_tcl_e8_RequiredPermissionType o_e8_RequiredPermissionType;
      if (!bDoIt(o_e8_RequiredPermissionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_REQUIREDPERMISSION:
   {
      fi_tcl_e8_RequiredPermission o_e8_RequiredPermission;
      if (!bDoIt(o_e8_RequiredPermission))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_GENERICREQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_GenericRequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE,intnavifi_tclSemanticDomain::EN_REQUIREDPERMISSIONTYPE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_REGIONID));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE,intnavifi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32,intnavifi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_GenericRequiredPermission o_GenericRequiredPermission;
         if (!bDoIt(o_GenericRequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_RequiredPermission oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_REQUIREDPERMISSION,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION) &&
          !(13 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC) &&
          !(u16MajorVersion <= 12))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REQUIREDTAXDISC,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_GENERICREQUIREDPERMISSION,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_REQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_RequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REQUIREDPERMISSIONUNION0,intnavifi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_RequiredPermission o_RequiredPermission;
         if (!bDoIt(o_RequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_COUNTRYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CountryNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE,intnavifi_tclSemanticDomain::EN_CODE));
      }
      else
      {
         fi_tcl_CountryNameElement o_CountryNameElement;
         if (!bDoIt(o_CountryNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_STATENAMELISTSET:
   {
      if (poVisitor->bDoExpand_StateNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STATENAMEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_STATENAMEREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_StateNameListSet o_StateNameListSet;
         if (!bDoIt(o_StateNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_COUNTYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CountyNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_COUNTYNAMEREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_CountyNameListSet o_CountyNameListSet;
         if (!bDoIt(o_CountyNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_CITYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CityNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S8,intnavifi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_CityNameElement o_CityNameElement;
         if (!bDoIt(o_CityNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_INDEXINREFERENCELIST:
   {
      if (poVisitor->bDoExpand_IndexInReferenceList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_DESCRIPTIONONNEXTNODE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_REFELEMENT));
      }
      else
      {
         fi_tcl_IndexInReferenceList o_IndexInReferenceList;
         if (!bDoIt(o_IndexInReferenceList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexInReferenceList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexInReferenceList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_BUILDUPAREANAMELISTSET:
   {
      if (poVisitor->bDoExpand_BuildUpAreaNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BUILDUPAREANAMEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_BUILDUPAREANAMEREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_BuildUpAreaNameListSet o_BuildUpAreaNameListSet;
         if (!bDoIt(o_BuildUpAreaNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_ROADNAMELISTSET:
   {
      if (poVisitor->bDoExpand_RoadNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ROADNAMEREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_RoadNameListSet o_RoadNameListSet;
         if (!bDoIt(o_RoadNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_COMPASSDIRECTION:
   {
      if (poVisitor->bDoExpand_CompassDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_DIRECTIONABSOLUTE,intnavifi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_CompassDirection o_CompassDirection;
         if (!bDoIt(o_CompassDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_REQUIREDPERMISSIONLISTSET:
   {
      if (poVisitor->bDoExpand_RequiredPermissionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REQUIREDPERMISSION,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_REQUIREDPERMISSIONREFLIST));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENTWITHID,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         }
      }
      else
      {
         fi_tcl_RequiredPermissionListSet o_RequiredPermissionListSet;
         if (!bDoIt(o_RequiredPermissionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_INTERSECTIONTYPE:
   {
      fi_tcl_e8_IntersectionType o_e8_IntersectionType;
      if (!bDoIt(o_e8_IntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_TIMEZONELISTSET:
   {
      if (poVisitor->bDoExpand_TimeZoneListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TIMEZONEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_TIMEZONELIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_TimeZoneListSet o_TimeZoneListSet;
         if (!bDoIt(o_TimeZoneListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_INTERSECTIONNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_INTERSECTIONSUFFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_INTERSECTIONNAME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_INTERSECTIONPREFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_INTERSECTIONTYPE,intnavifi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionNameElement o_IntersectionNameElement;
         if (!bDoIt(o_IntersectionNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_ROADNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_RoadNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_ROADNAME));
      }
      else
      {
         fi_tcl_RoadNameElement o_RoadNameElement;
         if (!bDoIt(o_RoadNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_ROADNUMBER:
   {
      if (poVisitor->bDoExpand_RoadNumber(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COMPASSDIRECTION,intnavifi_tclSemanticDomain::EN_COMPASSDIRECTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_NUMBERSUFFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_NUMBERPREFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_NUMBERHIERARCHY));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_STATE));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE,intnavifi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_ROADNUMBERSTATUS,intnavifi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_RoadNumber o_RoadNumber;
         if (!bDoIt(o_RoadNumber))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_INTERSECTIONNUMBERELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionNumberElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBER,intnavifi_tclSemanticDomain::EN_INTERSECTIONNUMBER));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_INTERSECTIONTYPE,intnavifi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionNumberElement o_IntersectionNumberElement;
         if (!bDoIt(o_IntersectionNumberElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNumberElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNumberElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_MAPDESCRIPTIONLISTSET:
   {
      if (poVisitor->bDoExpand_MapDescriptionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPCODEDELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_MAPELEMENTREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_MapDescriptionListSet o_MapDescriptionListSet;
         if (!bDoIt(o_MapDescriptionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDescriptionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDescriptionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_COUNTRYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CountryNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COUNTRYNAMEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_COUNTRYNAMEREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_CountryNameListSet o_CountryNameListSet;
         if (!bDoIt(o_CountryNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_CITYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CityNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CITYNAMEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_CITYNAMEREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_CityNameListSet o_CityNameListSet;
         if (!bDoIt(o_CityNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_SIGNPOSTELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavOneCellCategory oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_NAVONECELLCATEGORY,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_NAVONECELL:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVONECELL,intnavifi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_U16_INDEXINREFERENCELIST:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_SIGNPOSTELEMENT:
   {
      if (poVisitor->bDoExpand_SignPostElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_SIGNPOSTDESTINATION,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_SIGNPOSTDESTINATION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_SIGNPOSTDESTSTATUS,intnavifi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_SIGNPOSTELEMENTUNION0,intnavifi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
      }
      else
      {
         fi_tcl_SignPostElement o_SignPostElement;
         if (!bDoIt(o_SignPostElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_ROADNUMBERLISTSET:
   {
      if (poVisitor->bDoExpand_RoadNumberListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBER,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ROADNUMBERREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_RoadNumberListSet o_RoadNumberListSet;
         if (!bDoIt(o_RoadNumberListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B16_ROADATTRIBUTE:
   {
      fi_tcl_b16_RoadAttribute o_b16_RoadAttribute;
      if (!bDoIt(o_b16_RoadAttribute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B32_ROADPROPERTY:
   {
      fi_tcl_b32_RoadProperty o_b32_RoadProperty;
      if (!bDoIt(o_b32_RoadProperty))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_NAVSTREETTYPE:
   {
      fi_tcl_e8_NavStreetType o_e8_NavStreetType;
      if (!bDoIt(o_e8_NavStreetType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_ROADNETWORKCLASS:
   {
      fi_tcl_e8_RoadNetworkClass o_e8_RoadNetworkClass;
      if (!bDoIt(o_e8_RoadNetworkClass))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_ROADATTRIBUTES:
   {
      if (poVisitor->bDoExpand_RoadAttributes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_ROADNETWORKCLASS,intnavifi_tclSemanticDomain::EN_ROADNETWORKCLASS));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_NAVSTREETTYPE,intnavifi_tclSemanticDomain::EN_ROADTYPE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B32_ROADPROPERTY,intnavifi_tclSemanticDomain::EN_ROADPROPERTY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_ROADCLASSCODE,intnavifi_tclSemanticDomain::EN_ROADCLASS));
      }
      else
      {
         fi_tcl_RoadAttributes o_RoadAttributes;
         if (!bDoIt(o_RoadAttributes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_EXTRADESCELEMENTTYPE:
   {
      fi_tcl_e8_ExtraDescElementType o_e8_ExtraDescElementType;
      if (!bDoIt(o_e8_ExtraDescElementType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_EXTRADESCELEMENT:
   {
      if (poVisitor->bDoExpand_ExtraDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_LONGDESCRIPTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_SHORTDESCRIPTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_EXTRADESCELEMENTTYPE,intnavifi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_ExtraDescElement o_ExtraDescElement;
         if (!bDoIt(o_ExtraDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_EXTRADESCLISTSET:
   {
      if (poVisitor->bDoExpand_ExtraDescListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_EXTRADESCELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_EXTRADESCREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_ExtraDescListSet o_ExtraDescListSet;
         if (!bDoIt(o_ExtraDescListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B32_DATAPROPERTIES:
   {
      fi_tcl_b32_DataProperties o_b32_DataProperties;
      if (!bDoIt(o_b32_DataProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_DATADESCELEMENT:
   {
      if (poVisitor->bDoExpand_DataDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_CANDYPRODUCTCODE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B32_DATAPROPERTIES,intnavifi_tclSemanticDomain::EN_RNWDATAPROPERTIES));
      }
      else
      {
         fi_tcl_DataDescElement o_DataDescElement;
         if (!bDoIt(o_DataDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_DATADESCLISTSET:
   {
      if (poVisitor->bDoExpand_DataDescListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_DATADESCELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_DATADESCREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_DataDescListSet o_DataDescListSet;
         if (!bDoIt(o_DataDescListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B8_CROSSROADPROPERTIES:
   {
      fi_tcl_b8_CrossroadProperties o_b8_CrossroadProperties;
      if (!bDoIt(o_b8_CrossroadProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_CROSSROADDESC:
   {
      if (poVisitor->bDoExpand_CrossroadDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_INDEXOFTWINELEMENT));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADATTRIBUTES,intnavifi_tclSemanticDomain::EN_CROSSROADATTRIBUTES));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_CROSSROADINFOREFELEMENT));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_CROSSROADPROPERTIES,intnavifi_tclSemanticDomain::EN_CROSSROADPROPERTY));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_DIRECTIONABSOLUTE,intnavifi_tclSemanticDomain::EN_DIRECTIONOFCONNECTEDELEMENT));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_DIRECTIONABSOLUTE,intnavifi_tclSemanticDomain::EN_DIRECTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_ISDIRECTIONVALID));
      }
      else
      {
         fi_tcl_CrossroadDesc o_CrossroadDesc;
         if (!bDoIt(o_CrossroadDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_CROSSROADINFOCATEGORY:
   {
      fi_tcl_e8_CrossroadInfoCategory o_e8_CrossroadInfoCategory;
      if (!bDoIt(o_e8_CrossroadInfoCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_CROSSROADINFOUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_CrossroadInfoCategory oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_CROSSROADINFOCATEGORY,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNAMELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNAMELISTSET,intnavifi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBERLISTSET,intnavifi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_CROSSROADINFO:
   {
      if (poVisitor->bDoExpand_CrossroadInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CROSSROADINFOUNION0,intnavifi_tclSemanticDomain::EN_CROSSROADINFO));
      }
      else
      {
         fi_tcl_CrossroadInfo o_CrossroadInfo;
         if (!bDoIt(o_CrossroadInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_INTERSECTIONDENOTATION:
   {
      if (poVisitor->bDoExpand_IntersectionDenotation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_INTERSECTIONNAMESUFFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_INTERSECTIONNAMEBODY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_INTERSECTIONNAMEPREFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBER,intnavifi_tclSemanticDomain::EN_INTERSECTIONNUMBER));
      }
      else
      {
         fi_tcl_IntersectionDenotation o_IntersectionDenotation;
         if (!bDoIt(o_IntersectionDenotation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_INTERSECTIONPATHDENOTATION:
   {
      if (poVisitor->bDoExpand_IntersectionPathDenotation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INTERSECTIONDENOTATION,intnavifi_tclSemanticDomain::EN_INTERSECTIONDENOTATION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_EXITMASK));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_ENTRANCEMASK));
      }
      else
      {
         fi_tcl_IntersectionPathDenotation o_IntersectionPathDenotation;
         if (!bDoIt(o_IntersectionPathDenotation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionPathDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionPathDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_INTERSECTIONPATHDESC:
   {
      if (poVisitor->bDoExpand_IntersectionPathDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CROSSROADDESC,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_CROSSROADLIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSITIONWGS84,intnavifi_tclSemanticDomain::EN_INTERSECTIONCENTERCOORDINATES));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_EMU,intnavifi_tclSemanticDomain::EN_INTERSECTIONDIAMETER));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INTERSECTIONPATHDENOTATION,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_INTERSECTIONDENOTATIONLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_INTERSECTIONTYPE,intnavifi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionPathDesc o_IntersectionPathDesc;
         if (!bDoIt(o_IntersectionPathDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionPathDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionPathDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   {
      fi_tcl_e8_BaseTrafficSignCategory o_e8_BaseTrafficSignCategory;
      if (!bDoIt(o_e8_BaseTrafficSignCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_SPEEDSIGN:
   {
      fi_tcl_e8_SpeedSign o_e8_SpeedSign;
      if (!bDoIt(o_e8_SpeedSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E16_WARNINGSIGN:
   {
      fi_tcl_e16_WarningSign o_e16_WarningSign;
      if (!bDoIt(o_e16_WarningSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E16_REGULATORYSIGN:
   {
      fi_tcl_e16_RegulatorySign o_e16_RegulatorySign;
      if (!bDoIt(o_e16_RegulatorySign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   {
      fi_tcl_e16_AdditionalTrafficSign o_e16_AdditionalTrafficSign;
      if (!bDoIt(o_e16_AdditionalTrafficSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_TIMEDEPENDENTSTRING:
   {
      fi_tcl_TimeDependentString o_TimeDependentString;
      if (!bDoIt(o_TimeDependentString))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   {
      fi_tcl_b8_LaneDependentValidity o_b8_LaneDependentValidity;
      if (!bDoIt(o_b8_LaneDependentValidity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   {
      fi_tcl_e8_TrafficSignQuantifier o_e8_TrafficSignQuantifier;
      if (!bDoIt(o_e8_TrafficSignQuantifier))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_KMPERHOUR,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_MILESPERHOUR,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_PERCENT,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TIMEDEPENDENTSTRING,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_METER,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_YARDS,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_CENTIMETER,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_INCH,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_KILOGRAM,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_POUND,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   {
      if (poVisitor->bDoExpand_AdditionalTrafficSign(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN,intnavifi_tclSemanticDomain::EN_ADDITIONALSIGN));
      }
      else
      {
         fi_tcl_AdditionalTrafficSign o_AdditionalTrafficSign;
         if (!bDoIt(o_AdditionalTrafficSign))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_BaseTrafficSignCategory oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_SPEEDSIGN,intnavifi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_WARNINGSIGN,intnavifi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_REGULATORYSIGN,intnavifi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_KMPERHOUR,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S16_MILESPERHOUR,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_PERCENT,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TIMEDEPENDENTSTRING,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_METER,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_YARDS,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_CENTIMETER,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_INCH,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_KILOGRAM,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_POUND,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_TRAFFICSIGNELEMENT:
   {
      if (poVisitor->bDoExpand_TrafficSignElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ADDITIONALTRAFFICSIGN,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ADDITIONALSIGNLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TRAFFICSIGNELEMENTUNION1,intnavifi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TRAFFICSIGNELEMENTUNION0,intnavifi_tclSemanticDomain::EN_BASESIGNUNION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_VIRTUALTRAFFICSIGN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_DYNAMICTRAFFICSIGN));
      }
      else
      {
         fi_tcl_TrafficSignElement o_TrafficSignElement;
         if (!bDoIt(o_TrafficSignElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_ROADINFOCOMBINATION:
   {
      if (poVisitor->bDoExpand_RoadInfoCombination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_ID));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_METER,intnavifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_METER,intnavifi_tclSemanticDomain::EN_STARTOFFSET));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_INFOELEMENT));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_ROADELEMENT));
      }
      else
      {
         fi_tcl_RoadInfoCombination o_RoadInfoCombination;
         if (!bDoIt(o_RoadInfoCombination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadInfoCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadInfoCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_TRAFFICSIGNLISTSET:
   {
      if (poVisitor->bDoExpand_TrafficSignListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TRAFFICSIGNELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_TRAFFICSIGNLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADINFOCOMBINATION,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_COMBINATIONLIST));
      }
      else
      {
         fi_tcl_TrafficSignListSet o_TrafficSignListSet;
         if (!bDoIt(o_TrafficSignListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_B32_POICATEGORY:
   {
      fi_tcl_b32_POICategory o_b32_POICategory;
      if (!bDoIt(o_b32_POICategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_POIELEMENT:
   {
      if (poVisitor->bDoExpand_POIElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSITIONWGS84,intnavifi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_METER,intnavifi_tclSemanticDomain::EN_LOCATION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_ISLOCATIONVALID));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B32_POICATEGORY,intnavifi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_POIElement o_POIElement;
         if (!bDoIt(o_POIElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_POILISTSET:
   {
      if (poVisitor->bDoExpand_POIListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POIELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_POILIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENTWITHID,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         }
      }
      else
      {
         fi_tcl_POIListSet o_POIListSet;
         if (!bDoIt(o_POIListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_TOLLBOOTHELEMENT:
   {
      if (poVisitor->bDoExpand_TollBoothElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_METER,intnavifi_tclSemanticDomain::EN_TOLLBOOTHPOSITION));
      }
      else
      {
         fi_tcl_TollBoothElement o_TollBoothElement;
         if (!bDoIt(o_TollBoothElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_TOLLBOOTHLISTSET:
   {
      if (poVisitor->bDoExpand_TollBoothListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TOLLBOOTHELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_TOLLBOOTHELEMENTLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENTWITHID,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
      }
      else
      {
         fi_tcl_TollBoothListSet o_TollBoothListSet;
         if (!bDoIt(o_TollBoothListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_CITYDISTRICTNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CityDistrictNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CITYDISTRICTNAMEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_CITYDISTRICTNAMEREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_CityDistrictNameListSet o_CityDistrictNameListSet;
         if (!bDoIt(o_CityDistrictNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_POINTOFINTERESTELEMENT:
   {
      if (poVisitor->bDoExpand_PointOfInterestElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B32_POICATEGORY,intnavifi_tclSemanticDomain::EN_CATEGORY));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_PointOfInterestElement o_PointOfInterestElement;
         if (!bDoIt(o_PointOfInterestElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PointOfInterestElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PointOfInterestElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_UNSPECIFIEDTEXT:
   {
      if (poVisitor->bDoExpand_UnspecifiedText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MULTILANGUAGESTRING,intnavifi_tclSemanticDomain::EN_DESCRIPTION));
      }
      else
      {
         fi_tcl_UnspecifiedText o_UnspecifiedText;
         if (!bDoIt(o_UnspecifiedText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UnspecifiedText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UnspecifiedText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_SHAPETYPE:
   {
      fi_tcl_e8_ShapeType o_e8_ShapeType;
      if (!bDoIt(o_e8_ShapeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_SHAPE:
   {
      if (poVisitor->bDoExpand_Shape(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSITIONWGS84,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_SHAPEPOINTS));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_SHAPETYPE,intnavifi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         fi_tcl_Shape o_Shape;
         if (!bDoIt(o_Shape))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_TMSERVICEPROVIDER:
   {
      if (poVisitor->bDoExpand_TMServiceProvider(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_SERVICEPROVIDERNAME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E16_ISOCOUNTRYCODE,intnavifi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_EXTENDEDSERVICEID));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_SERVICEID));
      }
      else
      {
         fi_tcl_TMServiceProvider o_TMServiceProvider;
         if (!bDoIt(o_TMServiceProvider))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_TMCATEGORY:
   {
      fi_tcl_e8_TMCategory o_e8_TMCategory;
      if (!bDoIt(o_e8_TMCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_TMFLOWIMPACT:
   {
      fi_tcl_e8_TMFlowImpact o_e8_TMFlowImpact;
      if (!bDoIt(o_e8_TMFlowImpact))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY:
   {
      fi_tcl_b8_TMMappingPossibility o_b8_TMMappingPossibility;
      if (!bDoIt(o_b8_TMMappingPossibility))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_TMMAPPINGSTATUS:
   {
      fi_tcl_b8_TMMappingStatus o_b8_TMMappingStatus;
      if (!bDoIt(o_b8_TMMappingStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_TMAFFECTIONTYPE:
   {
      fi_tcl_e8_TMAffectionType o_e8_TMAffectionType;
      if (!bDoIt(o_e8_TMAffectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_TMONECELLATTRIBUTE:
   {
      fi_tcl_b8_TMOneCellAttribute o_b8_TMOneCellAttribute;
      if (!bDoIt(o_b8_TMOneCellAttribute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_TMONECELLPORTION:
   {
      if (poVisitor->bDoExpand_TMOneCellPortion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_PERCENT,intnavifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_PERCENT,intnavifi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_TMOneCellPortion o_TMOneCellPortion;
         if (!bDoIt(o_TMOneCellPortion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_TMVALUESTATUS:
   {
      fi_tcl_e8_TMValueStatus o_e8_TMValueStatus;
      if (!bDoIt(o_e8_TMValueStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE:
   {
      fi_tcl_e8_TMCIntersectionPathType o_e8_TMCIntersectionPathType;
      if (!bDoIt(o_e8_TMCIntersectionPathType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_TMCSTRUCTUREDTEXT:
   {
      if (poVisitor->bDoExpand_TMCStructuredText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_LONGSUFFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_SHORTSUFFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_LONGBODY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_SHORTBODY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_LONGPREFIX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STRING,intnavifi_tclSemanticDomain::EN_SHORTPREFIX));
      }
      else
      {
         fi_tcl_TMCStructuredText o_TMCStructuredText;
         if (!bDoIt(o_TMCStructuredText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE:
   {
      fi_tcl_e8_TMGeographicalPathRelationType o_e8_TMGeographicalPathRelationType;
      if (!bDoIt(o_e8_TMGeographicalPathRelationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_B8_TMRELEVANCE:
   {
      fi_tcl_b8_TMRelevance o_b8_TMRelevance;
      if (!bDoIt(o_b8_TMRelevance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_TMINFO:
   {
      if (poVisitor->bDoExpand_TMInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE,intnavifi_tclSemanticDomain::EN_GEOGRAPHICALPATHRELATION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSIXTIME,intnavifi_tclSemanticDomain::EN_LATESTDECODETIME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSIXTIME,intnavifi_tclSemanticDomain::EN_STOPTIME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POSIXTIME,intnavifi_tclSemanticDomain::EN_STARTTIME));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_INDEXINSERVICEPROVIDERLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_INDICESINPROGRAMSERVICELIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_BIDIRECTIONAL));
         if (32 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BOOL,intnavifi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RDBID,intnavifi_tclSemanticDomain::EN_RDBID));
         if (32 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMCSTRUCTUREDTEXT,intnavifi_tclSemanticDomain::EN_ROADNAME));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBER,intnavifi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_ROADCLASSCODE,intnavifi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_PREFIXPRIORITY));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_LOCATIONSEGMENTIDX));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_SEGMENTID));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMURGENCY,intnavifi_tclSemanticDomain::EN_URGENCYOFEVENT));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE,intnavifi_tclSemanticDomain::EN_UTMHANDLE));
         if (15 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_TMRELEVANCE,intnavifi_tclSemanticDomain::EN_TMRELEVANCE));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,intnavifi_tclSemanticDomain::EN_TRAFFICINFOSOURCE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMVALUESTATUS,intnavifi_tclSemanticDomain::EN_LENGTHSTATUS));
         }
         if (30 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_METER,intnavifi_tclSemanticDomain::EN_LENGTH));
         }
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMVALUESTATUS,intnavifi_tclSemanticDomain::EN_DELAYSTATUS));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_S32_SECOND,intnavifi_tclSemanticDomain::EN_DELAY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_SHAPE,intnavifi_tclSemanticDomain::EN_SHAPE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE,intnavifi_tclSemanticDomain::EN_GEOMETRICMESSAGETYPE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_FLOWVALUE));
         }
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMFLOWIMPACT,intnavifi_tclSemanticDomain::EN_TMFLOWIMPACT));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMCATEGORY,intnavifi_tclSemanticDomain::EN_TMCATEGORY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_TMMAPPINGSTATUS,intnavifi_tclSemanticDomain::EN_TMMAPPINGSTATUS));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY,intnavifi_tclSemanticDomain::EN_TMMAPPINGPOSSIBILITY));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMEVENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_EVENTLIST));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TRAFFICMSGTYPE,intnavifi_tclSemanticDomain::EN_MESSAGETYPE));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_TRAFFICMESSAGEID));
      }
      else
      {
         fi_tcl_TMInfo o_TMInfo;
         if (!bDoIt(o_TMInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_TMCOMBINATION:
   {
      if (poVisitor->bDoExpand_TMCombination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE,intnavifi_tclSemanticDomain::EN_INTERSECTIONPATHTYPE));
         }
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_TMAFFECTIONTYPE,intnavifi_tclSemanticDomain::EN_AFFECTIONTYPE));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMONECELLPORTION,intnavifi_tclSemanticDomain::EN_PORTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_B8_TMONECELLATTRIBUTE,intnavifi_tclSemanticDomain::EN_TMATTRIBUTES));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_INDEXINTMINFOLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_INDEXINTMPATHLIST));
      }
      else
      {
         fi_tcl_TMCombination o_TMCombination;
         if (!bDoIt(o_TMCombination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8,intnavifi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_NAVONECELL:
   {
      if (poVisitor->bDoExpand_NavOneCell(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_CLUSTERLENGTH));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U32,intnavifi_tclSemanticDomain::EN_CLUSTERFILEOFFSET));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_CLUSTERFILEID));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_NAVONECELLDIRECTION,intnavifi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U16,intnavifi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCell o_NavOneCell;
         if (!bDoIt(o_NavOneCell))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_LANEINFOLISTSET:
   {
      if (poVisitor->bDoExpand_LaneInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEINFOSEGMENTLIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_LANEINFOSEGMENTLISTLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_LaneInfoListSet o_LaneInfoListSet;
         if (!bDoIt(o_LaneInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_LANEINFOONECELLREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoOneCellReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_INDEXINLANEINFOLIST,intnavifi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,intnavifi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVONECELL,intnavifi_tclSemanticDomain::EN_ONECELL));
      }
      else
      {
         fi_tcl_LaneInfoOneCellReference o_LaneInfoOneCellReference;
         if (!bDoIt(o_LaneInfoOneCellReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_SIGNPOSTLISTSET:
   {
      if (poVisitor->bDoExpand_SignPostListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_SIGNPOSTELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_SIGNPOSTELEMENT));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REFERENCEELEMENT,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_SignPostListSet o_SignPostListSet;
         if (!bDoIt(o_SignPostListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_NAVPLAINPATHLISTSET:
   {
      if (poVisitor->bDoExpand_NavPlainPathListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVONECELLDESC,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ONECELL));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVCLUSTERDESC,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_CLUSTER));
      }
      else
      {
         fi_tcl_NavPlainPathListSet o_NavPlainPathListSet;
         if (!bDoIt(o_NavPlainPathListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPlainPathListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPlainPathListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_ROADINFOPRIORITY:
   {
      fi_tcl_e8_RoadInfoPriority o_e8_RoadInfoPriority;
      if (!bDoIt(o_e8_RoadInfoPriority))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_E8_ROADPATHINFOCATEGORY:
   {
      fi_tcl_e8_RoadPathInfoCategory o_e8_RoadPathInfoCategory;
      if (!bDoIt(o_e8_RoadPathInfoCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_NAVINTERSECTIONLISTSET:
   {
      if (poVisitor->bDoExpand_NavIntersectionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CROSSROADINFO,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_CROSSROADINFOLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_CROSSROADINFOELEMENTREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INTERSECTIONPATHDESC,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_INTERSECTIONPATHREFLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_INDEXINREFERENCELIST,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_NavIntersectionListSet o_NavIntersectionListSet;
         if (!bDoIt(o_NavIntersectionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_ROADPATHINFOCATEGORYUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_RoadPathInfoCategory oDataType;
      oCallStack.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_E8_ROADPATHINFOCATEGORY,intnavifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TIMEZONELISTSET) &&
          !(21 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TOLLBOOTHLISTSET) &&
          !(34 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SHAPEPOINTLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_RESERVED,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTRYNAMELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COUNTRYNAMELISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_STATENAMELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_STATENAMELISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_COUNTYNAMELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_COUNTYNAMELISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYNAMELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CITYNAMELISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_CITYDISTRICTNAMELISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BUILDUPAREANAMELISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNAMELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNAMELISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADNUMBERLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_MAPDESCRIPTIONLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_MAPDESCRIPTIONLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SIGNPOSTLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_SIGNPOSTLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_EXTRADESCLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_EXTRADESCLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DATADESCLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_DATADESCLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_NAVINTERSECTIONLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVINTERSECTIONLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TRAFFICSIGNLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_POILISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_POILISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_LANEINFOLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LANEINFOLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_DIRECTIONINFOLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_SHAPEPOINTLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_SHAPEPOINTLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_REQUIREDPERMISSIONLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TOLLBOOTHLISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TOLLBOOTHLISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RoadPathInfoCategory::FI_EN_T_TIMEZONELISTSET:
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TIMEZONELISTSET,intnavifi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case intnavifi_tclToken::EN_ROADPATHINFOCATEGORY:
   {
      if (poVisitor->bDoExpand_RoadPathInfoCategory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADPATHINFOCATEGORYUNION0,intnavifi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_RoadPathInfoCategory o_RoadPathInfoCategory;
         if (!bDoIt(o_RoadPathInfoCategory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadPathInfoCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadPathInfoCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_ROADPATHINFOLISTSET:
   {
      if (poVisitor->bDoExpand_RoadPathInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_ROADPATHINFOCATEGORY,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_ROADPATHINFOCATEGORYLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_NAVPLAINPATHLISTSET,intnavifi_tclSemanticDomain::EN_ROADPATHLISTSET));
      }
      else
      {
         fi_tcl_RoadPathInfoListSet o_RoadPathInfoListSet;
         if (!bDoIt(o_RoadPathInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadPathInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadPathInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intnavifi_tclToken::EN_E8_DATAAVAILABLE:
   {
      fi_tcl_e8_DataAvailable o_e8_DataAvailable;
      if (!bDoIt(o_e8_DataAvailable))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intnavifi_tclToken::EN_TMINFOLISTSET:
   {
      if (poVisitor->bDoExpand_TMInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_END_OF_STRUCT,intnavifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMCOMBINATION,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_TMCOMBINATION));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMSERVICEPROVIDER,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_SERVICEPROVIDERLIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMPROGRAMSERVICE,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_PROGRAMSERVICELIST));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_TMINFO,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_TMINFO));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_BINCONTAINER,intnavifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intnavifi_tclKnot(intnavifi_tclToken::EN_LIST,intnavifi_tclSemanticDomain::EN_TMCODEDTEXTMESSAGE));
      }
      else
      {
         fi_tcl_TMInfoListSet o_TMInfoListSet;
         if (!bDoIt(o_TMInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case intnavifi_tclToken::EN_UNKNOWN:
      case intnavifi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

