/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef INTMAPFITYPES_HEADER
#define INTMAPFITYPES_HEADER

// #include <vector>
// 


class intmapfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class intmapfi_tclMsgGetDirectoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgGetDirectoryMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgGetDirectoryMethodStart& operator=(const intmapfi_tclMsgGetDirectoryMethodStart& coRef);
   intmapfi_tclMsgGetDirectoryMethodStart(const intmapfi_tclMsgGetDirectoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgGetDirectoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_GETDIRECTORYMETHODSTART;}
};

class intmapfi_tclMsgGetDirectoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgGetDirectoryMethodResult():MapDirectory() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgGetDirectoryMethodResult& operator=(const intmapfi_tclMsgGetDirectoryMethodResult& coRef);
   intmapfi_tclMsgGetDirectoryMethodResult(const intmapfi_tclMsgGetDirectoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MapDirectory MapDirectory;
   std::vector<fi_tcl_MapDataLevelDirectory, std::allocator<fi_tcl_MapDataLevelDirectory> > MapDataLevelDirectoryList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgGetDirectoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_GETDIRECTORYMETHODRESULT;}
};

class intmapfi_tclMsgGetRegionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgGetRegionMethodStart():DataBaseLanguage(),DataLevel(),ExtPosNorthWest(),ExtPosSouthEast(),ExcludePosNorthWest(),ExcludePosSouthEast() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgGetRegionMethodStart& operator=(const intmapfi_tclMsgGetRegionMethodStart& coRef);
   intmapfi_tclMsgGetRegionMethodStart(const intmapfi_tclMsgGetRegionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode DataBaseLanguage;
   fi_tcl_e8_MapDataLevel DataLevel;
   fi_tcl_PositionWGS84 ExtPosNorthWest;
   fi_tcl_PositionWGS84 ExtPosSouthEast;
   fi_tcl_PositionWGS84 ExcludePosNorthWest;
   fi_tcl_PositionWGS84 ExcludePosSouthEast;
   std::vector<fi_tcl_MapRegion, std::allocator<fi_tcl_MapRegion> > Regions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgGetRegionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_GETREGIONMETHODSTART;}
};

class intmapfi_tclMsgGetRegionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgGetRegionMethodResult():DataBaseLanguage(),Region() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgGetRegionMethodResult& operator=(const intmapfi_tclMsgGetRegionMethodResult& coRef);
   intmapfi_tclMsgGetRegionMethodResult(const intmapfi_tclMsgGetRegionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode DataBaseLanguage;
   std::vector<fi_tcl_MapContainer, std::allocator<fi_tcl_MapContainer> > RegionData;
   fi_tcl_MapRegion Region;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgGetRegionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_GETREGIONMETHODRESULT;}
};

class intmapfi_tclMsgSetReservedCachingAreasMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgSetReservedCachingAreasMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgSetReservedCachingAreasMethodStart& operator=(const intmapfi_tclMsgSetReservedCachingAreasMethodStart& coRef);
   intmapfi_tclMsgSetReservedCachingAreasMethodStart(const intmapfi_tclMsgSetReservedCachingAreasMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_MapRegion, std::allocator<fi_tcl_MapRegion> > Regions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgSetReservedCachingAreasMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_SETRESERVEDCACHINGAREASMETHODSTART;}
};

class intmapfi_tclMsgSetReservedCachingAreasMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgSetReservedCachingAreasMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgSetReservedCachingAreasMethodResult& operator=(const intmapfi_tclMsgSetReservedCachingAreasMethodResult& coRef);
   intmapfi_tclMsgSetReservedCachingAreasMethodResult(const intmapfi_tclMsgSetReservedCachingAreasMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_MapRegion, std::allocator<fi_tcl_MapRegion> > Regions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgSetReservedCachingAreasMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_SETRESERVEDCACHINGAREASMETHODRESULT;}
};

class intmapfi_tclMsgDrawMapMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgDrawMapMethodStart():DrawMode(),MapState(),MapScale(),MapAngle(),MapMode(),RefPos(),IndexPosition(),Options(),CmdID(0),LowerLeftUpdateBoundary(),UpperRightUpdateBoundary(),LowerLeftUpdateFrame(),UpperRightUpdateFrame(),ScaleBarSize(0),Position(),MapDirection(0),CustomZoomLevel(0),SceneDirection(0),MoreOptions(0),Value1(0),Value2(0),TiltAngle(0),LowerLeftScreenBoundary(),UpperRightScreenBoundary(),LowerLeftMapBoundary(),UpperRightMapBoundary(),ScaleFactor(0),CityCentre_YLimit(0),POI_YLimit(0),OneWayMarks_YLimit(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgDrawMapMethodStart& operator=(const intmapfi_tclMsgDrawMapMethodStart& coRef);
   intmapfi_tclMsgDrawMapMethodStart(const intmapfi_tclMsgDrawMapMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DrawMode DrawMode;
   fi_tcl_e8_MapState MapState;
   fi_tcl_e8_MapScale MapScale;
   fi_tcl_e8_MapAngle MapAngle;
   fi_tcl_e8_MapMode MapMode;
   fi_tcl_PositionScreen RefPos;
   fi_tcl_PositionWGS84 IndexPosition;
   fi_tcl_b8_DrawOptions Options;
   tU8 CmdID;
   fi_tcl_PositionScreen LowerLeftUpdateBoundary;
   fi_tcl_PositionScreen UpperRightUpdateBoundary;
   fi_tcl_PositionScreen LowerLeftUpdateFrame;
   fi_tcl_PositionScreen UpperRightUpdateFrame;
   tU16 ScaleBarSize;
   fi_tcl_PositionWGS84 Position;
   tU16 MapDirection;
   tU8 CustomZoomLevel;
   tU16 SceneDirection;
   tU16 MoreOptions;
   tU32 Value1;
   tU32 Value2;
   tU16 TiltAngle;
   fi_tcl_PositionScreen LowerLeftScreenBoundary;
   fi_tcl_PositionScreen UpperRightScreenBoundary;
   fi_tcl_PositionScreen LowerLeftMapBoundary;
   fi_tcl_PositionScreen UpperRightMapBoundary;
   tU8 ScaleFactor;
   std::vector<tS16, std::allocator<tS16> > MapStreetFilterLimit;
   tS16 CityCentre_YLimit;
   tS16 POI_YLimit;
   tS16 OneWayMarks_YLimit;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgDrawMapMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_DRAWMAPMETHODSTART;}
};

class intmapfi_tclMsgDrawMapMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgDrawMapMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgDrawMapMethodResult& operator=(const intmapfi_tclMsgDrawMapMethodResult& coRef);
   intmapfi_tclMsgDrawMapMethodResult(const intmapfi_tclMsgDrawMapMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgDrawMapMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_DRAWMAPMETHODRESULT;}
};

class intmapfi_tclMsgSetScaleConfigMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgSetScaleConfigMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgSetScaleConfigMethodStart& operator=(const intmapfi_tclMsgSetScaleConfigMethodStart& coRef);
   intmapfi_tclMsgSetScaleConfigMethodStart(const intmapfi_tclMsgSetScaleConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ScaleConfig, std::allocator<fi_tcl_ScaleConfig> > T_ScaleConfig;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgSetScaleConfigMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_SETSCALECONFIGMETHODSTART;}
};

class intmapfi_tclMsgSetScaleConfigMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgSetScaleConfigMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgSetScaleConfigMethodResult& operator=(const intmapfi_tclMsgSetScaleConfigMethodResult& coRef);
   intmapfi_tclMsgSetScaleConfigMethodResult(const intmapfi_tclMsgSetScaleConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgSetScaleConfigMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_SETSCALECONFIGMETHODRESULT;}
};

class intmapfi_tclMsgEngEnableFeatureMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgEngEnableFeatureMethodStart():FeatureMask(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgEngEnableFeatureMethodStart& operator=(const intmapfi_tclMsgEngEnableFeatureMethodStart& coRef);
   intmapfi_tclMsgEngEnableFeatureMethodStart(const intmapfi_tclMsgEngEnableFeatureMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 FeatureMask;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgEngEnableFeatureMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_ENGENABLEFEATUREMETHODSTART;}
};

class intmapfi_tclMsgEngEnableFeatureMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgEngEnableFeatureMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgEngEnableFeatureMethodResult& operator=(const intmapfi_tclMsgEngEnableFeatureMethodResult& coRef);
   intmapfi_tclMsgEngEnableFeatureMethodResult(const intmapfi_tclMsgEngEnableFeatureMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgEngEnableFeatureMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_ENGENABLEFEATUREMETHODRESULT;}
};

class intmapfi_tclMsgEngConfigFeatureMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgEngConfigFeatureMethodStart():Key(0),Value(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgEngConfigFeatureMethodStart& operator=(const intmapfi_tclMsgEngConfigFeatureMethodStart& coRef);
   intmapfi_tclMsgEngConfigFeatureMethodStart(const intmapfi_tclMsgEngConfigFeatureMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Key;
   tU32 Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgEngConfigFeatureMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_ENGCONFIGFEATUREMETHODSTART;}
};

class intmapfi_tclMsgEngConfigFeatureMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgEngConfigFeatureMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgEngConfigFeatureMethodResult& operator=(const intmapfi_tclMsgEngConfigFeatureMethodResult& coRef);
   intmapfi_tclMsgEngConfigFeatureMethodResult(const intmapfi_tclMsgEngConfigFeatureMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgEngConfigFeatureMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_ENGCONFIGFEATUREMETHODRESULT;}
};

class intmapfi_tclMsgDirectoryGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgDirectoryGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgDirectoryGet& operator=(const intmapfi_tclMsgDirectoryGet& coRef);
   intmapfi_tclMsgDirectoryGet(const intmapfi_tclMsgDirectoryGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgDirectoryGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_DIRECTORYGET;}
};

class intmapfi_tclMsgDirectoryStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgDirectoryStatus():DataBaseId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgDirectoryStatus& operator=(const intmapfi_tclMsgDirectoryStatus& coRef);
   intmapfi_tclMsgDirectoryStatus(const intmapfi_tclMsgDirectoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 DataBaseId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgDirectoryStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_DIRECTORYSTATUS;}
};

class intmapfi_tclMsgParameterChangeGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgParameterChangeGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgParameterChangeGet& operator=(const intmapfi_tclMsgParameterChangeGet& coRef);
   intmapfi_tclMsgParameterChangeGet(const intmapfi_tclMsgParameterChangeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgParameterChangeGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_PARAMETERCHANGEGET;}
};

class intmapfi_tclMsgParameterChangeStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgParameterChangeStatus():Counter(0),Detail(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgParameterChangeStatus& operator=(const intmapfi_tclMsgParameterChangeStatus& coRef);
   intmapfi_tclMsgParameterChangeStatus(const intmapfi_tclMsgParameterChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Counter;
   tU8 Detail;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgParameterChangeStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_PARAMETERCHANGESTATUS;}
};

class intmapfi_tclMsgDataUpdateGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgDataUpdateGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgDataUpdateGet& operator=(const intmapfi_tclMsgDataUpdateGet& coRef);
   intmapfi_tclMsgDataUpdateGet(const intmapfi_tclMsgDataUpdateGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgDataUpdateGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_DATAUPDATEGET;}
};

class intmapfi_tclMsgDataUpdateStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgDataUpdateStatus():Counter(0),UpdateCause(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgDataUpdateStatus& operator=(const intmapfi_tclMsgDataUpdateStatus& coRef);
   intmapfi_tclMsgDataUpdateStatus(const intmapfi_tclMsgDataUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Counter;
   tU8 UpdateCause;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgDataUpdateStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_DATAUPDATESTATUS;}
};

class intmapfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgEngineeringTextGet& operator=(const intmapfi_tclMsgEngineeringTextGet& coRef);
   intmapfi_tclMsgEngineeringTextGet(const intmapfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class intmapfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgEngineeringTextUpReg& operator=(const intmapfi_tclMsgEngineeringTextUpReg& coRef);
   intmapfi_tclMsgEngineeringTextUpReg(const intmapfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class intmapfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgEngineeringTextRelUpReg& operator=(const intmapfi_tclMsgEngineeringTextRelUpReg& coRef);
   intmapfi_tclMsgEngineeringTextRelUpReg(const intmapfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class intmapfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgEngineeringTextStatus& operator=(const intmapfi_tclMsgEngineeringTextStatus& coRef);
   intmapfi_tclMsgEngineeringTextStatus(const intmapfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};

class intmapfi_tclMsgUsedDatasetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgUsedDatasetGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgUsedDatasetGet& operator=(const intmapfi_tclMsgUsedDatasetGet& coRef);
   intmapfi_tclMsgUsedDatasetGet(const intmapfi_tclMsgUsedDatasetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgUsedDatasetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_USEDDATASETGET;}
};

class intmapfi_tclMsgUsedDatasetUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgUsedDatasetUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgUsedDatasetUpReg& operator=(const intmapfi_tclMsgUsedDatasetUpReg& coRef);
   intmapfi_tclMsgUsedDatasetUpReg(const intmapfi_tclMsgUsedDatasetUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgUsedDatasetUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_USEDDATASETUPREG;}
};

class intmapfi_tclMsgUsedDatasetRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgUsedDatasetRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgUsedDatasetRelUpReg& operator=(const intmapfi_tclMsgUsedDatasetRelUpReg& coRef);
   intmapfi_tclMsgUsedDatasetRelUpReg(const intmapfi_tclMsgUsedDatasetRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgUsedDatasetRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_USEDDATASETRELUPREG;}
};

class intmapfi_tclMsgUsedDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intmapfi_tclMsgUsedDatasetStatus():MediaId(),DataSetId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intmapfi_tclMsgUsedDatasetStatus& operator=(const intmapfi_tclMsgUsedDatasetStatus& coRef);
   intmapfi_tclMsgUsedDatasetStatus(const intmapfi_tclMsgUsedDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_MediaId MediaId;
   fi_tcl_u32_DataSetId DataSetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intmapfi_tclMsgUsedDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intmapfi_tclToken::EN_MSG_USEDDATASETSTATUS;}
};


#endif
