/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgGetDirectoryMethodStart::intmapfi_tclMsgGetDirectoryMethodStart(const intmapfi_tclMsgGetDirectoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgGetDirectoryMethodStart& intmapfi_tclMsgGetDirectoryMethodStart::operator=(const intmapfi_tclMsgGetDirectoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgGetDirectoryMethodStart::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgGetDirectoryMethodStart::u16GetFunctionID() const {return INTMAPFI_C_U16_GETDIRECTORY;}
tU8 intmapfi_tclMsgGetDirectoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 intmapfi_tclMsgGetDirectoryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgGetDirectoryMethodStart::operator==(const intmapfi_tclMsgGetDirectoryMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgGetDirectoryMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgGetDirectoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgGetDirectoryMethodResult::intmapfi_tclMsgGetDirectoryMethodResult(const intmapfi_tclMsgGetDirectoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MapDirectory = coRef.MapDirectory;
   MapDataLevelDirectoryList = coRef.MapDataLevelDirectoryList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgGetDirectoryMethodResult& intmapfi_tclMsgGetDirectoryMethodResult::operator=(const intmapfi_tclMsgGetDirectoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MapDirectory = coRef.MapDirectory;
   MapDataLevelDirectoryList = coRef.MapDataLevelDirectoryList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgGetDirectoryMethodResult::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgGetDirectoryMethodResult::u16GetFunctionID() const {return INTMAPFI_C_U16_GETDIRECTORY;}
tU8 intmapfi_tclMsgGetDirectoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intmapfi_tclMsgGetDirectoryMethodResult::vDestroy()
{
   MapDirectory.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < MapDataLevelDirectoryList.size(); ++u32Idx)
         MapDataLevelDirectoryList[u32Idx].vDestroy();
   }
   MapDataLevelDirectoryList.clear();
}

tU32 intmapfi_tclMsgGetDirectoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20+MapDataLevelDirectoryList.size()*5;
}

tBool intmapfi_tclMsgGetDirectoryMethodResult::operator==(const intmapfi_tclMsgGetDirectoryMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MapDirectory == rfoCmp.MapDirectory);
      bResult = bResult && (MapDataLevelDirectoryList.size() == rfoCmp.MapDataLevelDirectoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MapDataLevelDirectoryList.size()); ++u32Idx)
            bResult = bResult && (MapDataLevelDirectoryList[u32Idx] == rfoCmp.MapDataLevelDirectoryList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgGetDirectoryMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MapDirectory;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MapDataLevelDirectoryList.size(); ++u32Idx)
      {
         MapDataLevelDirectoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MapDataLevelDirectoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MapDataLevelDirectoryList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgGetDirectoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MapDirectory;
   oOut << (tU32)MapDataLevelDirectoryList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MapDataLevelDirectoryList.size(); ++u32Idx)
         oOut << MapDataLevelDirectoryList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgGetRegionMethodStart::intmapfi_tclMsgGetRegionMethodStart(const intmapfi_tclMsgGetRegionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataBaseLanguage = coRef.DataBaseLanguage;
   DataLevel = coRef.DataLevel;
   ExtPosNorthWest = coRef.ExtPosNorthWest;
   ExtPosSouthEast = coRef.ExtPosSouthEast;
   ExcludePosNorthWest = coRef.ExcludePosNorthWest;
   ExcludePosSouthEast = coRef.ExcludePosSouthEast;
   Regions = coRef.Regions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgGetRegionMethodStart& intmapfi_tclMsgGetRegionMethodStart::operator=(const intmapfi_tclMsgGetRegionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DataBaseLanguage = coRef.DataBaseLanguage;
   DataLevel = coRef.DataLevel;
   ExtPosNorthWest = coRef.ExtPosNorthWest;
   ExtPosSouthEast = coRef.ExtPosSouthEast;
   ExcludePosNorthWest = coRef.ExcludePosNorthWest;
   ExcludePosSouthEast = coRef.ExcludePosSouthEast;
   Regions = coRef.Regions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgGetRegionMethodStart::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgGetRegionMethodStart::u16GetFunctionID() const {return INTMAPFI_C_U16_GETREGION;}
tU8 intmapfi_tclMsgGetRegionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intmapfi_tclMsgGetRegionMethodStart::vDestroy()
{
   ExtPosNorthWest.vDestroy(); 
   ExtPosSouthEast.vDestroy(); 
   ExcludePosNorthWest.vDestroy(); 
   ExcludePosSouthEast.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
         Regions[u32Idx].vDestroy();
   }
   Regions.clear();
}

tU32 intmapfi_tclMsgGetRegionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += 2;
   }
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += 8;
   }
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += 8;
   }
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += 8;
   }
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += 8;
   }
   tU32 u32ListIdx;
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < Regions.size(); ++u32ListIdx)
         u32DynamicSize += Regions[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+0;
}

tBool intmapfi_tclMsgGetRegionMethodStart::operator==(const intmapfi_tclMsgGetRegionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataBaseLanguage == rfoCmp.DataBaseLanguage);
      bResult = bResult && (DataLevel == rfoCmp.DataLevel);
      bResult = bResult && (ExtPosNorthWest == rfoCmp.ExtPosNorthWest);
      bResult = bResult && (ExtPosSouthEast == rfoCmp.ExtPosSouthEast);
      bResult = bResult && (ExcludePosNorthWest == rfoCmp.ExcludePosNorthWest);
      bResult = bResult && (ExcludePosSouthEast == rfoCmp.ExcludePosSouthEast);
      bResult = bResult && (Regions.size() == rfoCmp.Regions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Regions.size()); ++u32Idx)
            bResult = bResult && (Regions[u32Idx] == rfoCmp.Regions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgGetRegionMethodStart::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> DataBaseLanguage;
   }
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> DataLevel;
   }
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> ExtPosNorthWest;
   }
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> ExtPosSouthEast;
   }
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> ExcludePosNorthWest;
   }
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> ExcludePosSouthEast;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
         {
            Regions[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         Regions.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> Regions[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgGetRegionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << DataBaseLanguage;
   }
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << DataLevel;
   }
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << ExtPosNorthWest;
   }
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << ExtPosSouthEast;
   }
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << ExcludePosNorthWest;
   }
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << ExcludePosSouthEast;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)Regions.size();
      {
         for (tU32 u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
            oOut << Regions[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgGetRegionMethodResult::intmapfi_tclMsgGetRegionMethodResult(const intmapfi_tclMsgGetRegionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataBaseLanguage = coRef.DataBaseLanguage;
   RegionData = coRef.RegionData;
   Region = coRef.Region;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgGetRegionMethodResult& intmapfi_tclMsgGetRegionMethodResult::operator=(const intmapfi_tclMsgGetRegionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DataBaseLanguage = coRef.DataBaseLanguage;
   RegionData = coRef.RegionData;
   Region = coRef.Region;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgGetRegionMethodResult::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgGetRegionMethodResult::u16GetFunctionID() const {return INTMAPFI_C_U16_GETREGION;}
tU8 intmapfi_tclMsgGetRegionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intmapfi_tclMsgGetRegionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RegionData.size(); ++u32Idx)
         RegionData[u32Idx].vDestroy();
   }
   RegionData.clear();
   Region.vDestroy(); 
}

tU32 intmapfi_tclMsgGetRegionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += 2;
   }
   tU32 u32ListIdx;
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < RegionData.size(); ++u32ListIdx)
         u32DynamicSize += RegionData[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += Region.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+0;
}

tBool intmapfi_tclMsgGetRegionMethodResult::operator==(const intmapfi_tclMsgGetRegionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataBaseLanguage == rfoCmp.DataBaseLanguage);
      bResult = bResult && (RegionData.size() == rfoCmp.RegionData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionData.size()); ++u32Idx)
            bResult = bResult && (RegionData[u32Idx] == rfoCmp.RegionData[u32Idx]);
      }
      bResult = bResult && (Region == rfoCmp.Region);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgGetRegionMethodResult::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> DataBaseLanguage;
   }
   if (oIn.u16GetMajorVersion() <= 6)
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < RegionData.size(); ++u32Idx)
         {
            RegionData[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         RegionData.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> RegionData[u32Idx];
         }
      }
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> Region;
   }
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgGetRegionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << DataBaseLanguage;
   }
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << (tU32)RegionData.size();
      {
         for (tU32 u32Idx = 0; u32Idx < RegionData.size(); ++u32Idx)
            oOut << RegionData[u32Idx];
      }
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << Region;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgSetReservedCachingAreasMethodStart::intmapfi_tclMsgSetReservedCachingAreasMethodStart(const intmapfi_tclMsgSetReservedCachingAreasMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Regions = coRef.Regions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgSetReservedCachingAreasMethodStart& intmapfi_tclMsgSetReservedCachingAreasMethodStart::operator=(const intmapfi_tclMsgSetReservedCachingAreasMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Regions = coRef.Regions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgSetReservedCachingAreasMethodStart::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgSetReservedCachingAreasMethodStart::u16GetFunctionID() const {return INTMAPFI_C_U16_SETRESERVEDCACHINGAREAS;}
tU8 intmapfi_tclMsgSetReservedCachingAreasMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intmapfi_tclMsgSetReservedCachingAreasMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
         Regions[u32Idx].vDestroy();
   }
   Regions.clear();
}

tU32 intmapfi_tclMsgSetReservedCachingAreasMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Regions.size(); ++u32ListIdx)
      u32DynamicSize += Regions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool intmapfi_tclMsgSetReservedCachingAreasMethodStart::operator==(const intmapfi_tclMsgSetReservedCachingAreasMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Regions.size() == rfoCmp.Regions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Regions.size()); ++u32Idx)
            bResult = bResult && (Regions[u32Idx] == rfoCmp.Regions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgSetReservedCachingAreasMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
      {
         Regions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Regions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Regions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgSetReservedCachingAreasMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Regions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
         oOut << Regions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgSetReservedCachingAreasMethodResult::intmapfi_tclMsgSetReservedCachingAreasMethodResult(const intmapfi_tclMsgSetReservedCachingAreasMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Regions = coRef.Regions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgSetReservedCachingAreasMethodResult& intmapfi_tclMsgSetReservedCachingAreasMethodResult::operator=(const intmapfi_tclMsgSetReservedCachingAreasMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Regions = coRef.Regions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgSetReservedCachingAreasMethodResult::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgSetReservedCachingAreasMethodResult::u16GetFunctionID() const {return INTMAPFI_C_U16_SETRESERVEDCACHINGAREAS;}
tU8 intmapfi_tclMsgSetReservedCachingAreasMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intmapfi_tclMsgSetReservedCachingAreasMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
         Regions[u32Idx].vDestroy();
   }
   Regions.clear();
}

tU32 intmapfi_tclMsgSetReservedCachingAreasMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Regions.size(); ++u32ListIdx)
      u32DynamicSize += Regions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool intmapfi_tclMsgSetReservedCachingAreasMethodResult::operator==(const intmapfi_tclMsgSetReservedCachingAreasMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Regions.size() == rfoCmp.Regions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Regions.size()); ++u32Idx)
            bResult = bResult && (Regions[u32Idx] == rfoCmp.Regions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgSetReservedCachingAreasMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
      {
         Regions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Regions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Regions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgSetReservedCachingAreasMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Regions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Regions.size(); ++u32Idx)
         oOut << Regions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDrawMapMethodStart::intmapfi_tclMsgDrawMapMethodStart(const intmapfi_tclMsgDrawMapMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   DrawMode = coRef.DrawMode;
   MapState = coRef.MapState;
   MapScale = coRef.MapScale;
   MapAngle = coRef.MapAngle;
   MapMode = coRef.MapMode;
   RefPos = coRef.RefPos;
   IndexPosition = coRef.IndexPosition;
   Options = coRef.Options;
   CmdID = coRef.CmdID;
   LowerLeftUpdateBoundary = coRef.LowerLeftUpdateBoundary;
   UpperRightUpdateBoundary = coRef.UpperRightUpdateBoundary;
   LowerLeftUpdateFrame = coRef.LowerLeftUpdateFrame;
   UpperRightUpdateFrame = coRef.UpperRightUpdateFrame;
   ScaleBarSize = coRef.ScaleBarSize;
   Position = coRef.Position;
   MapDirection = coRef.MapDirection;
   CustomZoomLevel = coRef.CustomZoomLevel;
   SceneDirection = coRef.SceneDirection;
   MoreOptions = coRef.MoreOptions;
   Value1 = coRef.Value1;
   Value2 = coRef.Value2;
   TiltAngle = coRef.TiltAngle;
   LowerLeftScreenBoundary = coRef.LowerLeftScreenBoundary;
   UpperRightScreenBoundary = coRef.UpperRightScreenBoundary;
   LowerLeftMapBoundary = coRef.LowerLeftMapBoundary;
   UpperRightMapBoundary = coRef.UpperRightMapBoundary;
   ScaleFactor = coRef.ScaleFactor;
   MapStreetFilterLimit = coRef.MapStreetFilterLimit;
   CityCentre_YLimit = coRef.CityCentre_YLimit;
   POI_YLimit = coRef.POI_YLimit;
   OneWayMarks_YLimit = coRef.OneWayMarks_YLimit;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDrawMapMethodStart& intmapfi_tclMsgDrawMapMethodStart::operator=(const intmapfi_tclMsgDrawMapMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DrawMode = coRef.DrawMode;
   MapState = coRef.MapState;
   MapScale = coRef.MapScale;
   MapAngle = coRef.MapAngle;
   MapMode = coRef.MapMode;
   RefPos = coRef.RefPos;
   IndexPosition = coRef.IndexPosition;
   Options = coRef.Options;
   CmdID = coRef.CmdID;
   LowerLeftUpdateBoundary = coRef.LowerLeftUpdateBoundary;
   UpperRightUpdateBoundary = coRef.UpperRightUpdateBoundary;
   LowerLeftUpdateFrame = coRef.LowerLeftUpdateFrame;
   UpperRightUpdateFrame = coRef.UpperRightUpdateFrame;
   ScaleBarSize = coRef.ScaleBarSize;
   Position = coRef.Position;
   MapDirection = coRef.MapDirection;
   CustomZoomLevel = coRef.CustomZoomLevel;
   SceneDirection = coRef.SceneDirection;
   MoreOptions = coRef.MoreOptions;
   Value1 = coRef.Value1;
   Value2 = coRef.Value2;
   TiltAngle = coRef.TiltAngle;
   LowerLeftScreenBoundary = coRef.LowerLeftScreenBoundary;
   UpperRightScreenBoundary = coRef.UpperRightScreenBoundary;
   LowerLeftMapBoundary = coRef.LowerLeftMapBoundary;
   UpperRightMapBoundary = coRef.UpperRightMapBoundary;
   ScaleFactor = coRef.ScaleFactor;
   MapStreetFilterLimit = coRef.MapStreetFilterLimit;
   CityCentre_YLimit = coRef.CityCentre_YLimit;
   POI_YLimit = coRef.POI_YLimit;
   OneWayMarks_YLimit = coRef.OneWayMarks_YLimit;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgDrawMapMethodStart::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgDrawMapMethodStart::u16GetFunctionID() const {return INTMAPFI_C_U16_DRAWMAP;}
tU8 intmapfi_tclMsgDrawMapMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intmapfi_tclMsgDrawMapMethodStart::vDestroy()
{
   RefPos.vDestroy(); 
   IndexPosition.vDestroy(); 
   LowerLeftUpdateBoundary.vDestroy(); 
   UpperRightUpdateBoundary.vDestroy(); 
   LowerLeftUpdateFrame.vDestroy(); 
   UpperRightUpdateFrame.vDestroy(); 
   Position.vDestroy(); 
   LowerLeftScreenBoundary.vDestroy(); 
   UpperRightScreenBoundary.vDestroy(); 
   LowerLeftMapBoundary.vDestroy(); 
   UpperRightMapBoundary.vDestroy(); 
   MapStreetFilterLimit.clear();
}

tU32 intmapfi_tclMsgDrawMapMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (8 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += MapStreetFilterLimit.size()*2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+47;
}

tBool intmapfi_tclMsgDrawMapMethodStart::operator==(const intmapfi_tclMsgDrawMapMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DrawMode == rfoCmp.DrawMode);
      bResult = bResult && (MapState == rfoCmp.MapState);
      bResult = bResult && (MapScale == rfoCmp.MapScale);
      bResult = bResult && (MapAngle == rfoCmp.MapAngle);
      bResult = bResult && (MapMode == rfoCmp.MapMode);
      bResult = bResult && (RefPos == rfoCmp.RefPos);
      bResult = bResult && (IndexPosition == rfoCmp.IndexPosition);
      bResult = bResult && (Options == rfoCmp.Options);
      bResult = bResult && (CmdID == rfoCmp.CmdID);
      bResult = bResult && (LowerLeftUpdateBoundary == rfoCmp.LowerLeftUpdateBoundary);
      bResult = bResult && (UpperRightUpdateBoundary == rfoCmp.UpperRightUpdateBoundary);
      bResult = bResult && (LowerLeftUpdateFrame == rfoCmp.LowerLeftUpdateFrame);
      bResult = bResult && (UpperRightUpdateFrame == rfoCmp.UpperRightUpdateFrame);
      bResult = bResult && (ScaleBarSize == rfoCmp.ScaleBarSize);
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (MapDirection == rfoCmp.MapDirection);
      bResult = bResult && (CustomZoomLevel == rfoCmp.CustomZoomLevel);
      bResult = bResult && (SceneDirection == rfoCmp.SceneDirection);
      bResult = bResult && (MoreOptions == rfoCmp.MoreOptions);
      bResult = bResult && (Value1 == rfoCmp.Value1);
      bResult = bResult && (Value2 == rfoCmp.Value2);
      bResult = bResult && (TiltAngle == rfoCmp.TiltAngle);
      bResult = bResult && (LowerLeftScreenBoundary == rfoCmp.LowerLeftScreenBoundary);
      bResult = bResult && (UpperRightScreenBoundary == rfoCmp.UpperRightScreenBoundary);
      bResult = bResult && (LowerLeftMapBoundary == rfoCmp.LowerLeftMapBoundary);
      bResult = bResult && (UpperRightMapBoundary == rfoCmp.UpperRightMapBoundary);
      bResult = bResult && (ScaleFactor == rfoCmp.ScaleFactor);
      bResult = bResult && (MapStreetFilterLimit.size() == rfoCmp.MapStreetFilterLimit.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MapStreetFilterLimit.size()); ++u32Idx)
            bResult = bResult && (MapStreetFilterLimit[u32Idx] == rfoCmp.MapStreetFilterLimit[u32Idx]);
      }
      bResult = bResult && (CityCentre_YLimit == rfoCmp.CityCentre_YLimit);
      bResult = bResult && (POI_YLimit == rfoCmp.POI_YLimit);
      bResult = bResult && (OneWayMarks_YLimit == rfoCmp.OneWayMarks_YLimit);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgDrawMapMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> DrawMode;
   oIn >> MapState;
   oIn >> MapScale;
   oIn >> MapAngle;
   oIn >> MapMode;
   oIn >> RefPos;
   oIn >> IndexPosition;
   oIn >> Options;
   oIn >> CmdID;
   oIn >> LowerLeftUpdateBoundary;
   oIn >> UpperRightUpdateBoundary;
   oIn >> LowerLeftUpdateFrame;
   oIn >> UpperRightUpdateFrame;
   oIn >> ScaleBarSize;
   oIn >> Position;
   oIn >> MapDirection;
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> CustomZoomLevel;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> SceneDirection;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> MoreOptions;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> Value1;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> Value2;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> TiltAngle;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> LowerLeftScreenBoundary;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> UpperRightScreenBoundary;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> LowerLeftMapBoundary;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> UpperRightMapBoundary;
   }
   if (8 <= oIn.u16GetMajorVersion())
   {
      oIn >> ScaleFactor;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         MapStreetFilterLimit.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> MapStreetFilterLimit[u32Idx];
         }
      }
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> CityCentre_YLimit;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> POI_YLimit;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> OneWayMarks_YLimit;
   }
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgDrawMapMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DrawMode;
   oOut << MapState;
   oOut << MapScale;
   oOut << MapAngle;
   oOut << MapMode;
   oOut << RefPos;
   oOut << IndexPosition;
   oOut << Options;
   oOut << CmdID;
   oOut << LowerLeftUpdateBoundary;
   oOut << UpperRightUpdateBoundary;
   oOut << LowerLeftUpdateFrame;
   oOut << UpperRightUpdateFrame;
   oOut << ScaleBarSize;
   oOut << Position;
   oOut << MapDirection;
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << CustomZoomLevel;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << SceneDirection;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << MoreOptions;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << Value1;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << Value2;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << TiltAngle;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << LowerLeftScreenBoundary;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << UpperRightScreenBoundary;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << LowerLeftMapBoundary;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << UpperRightMapBoundary;
   }
   if (8 <= oOut.u16GetMajorVersion())
   {
      oOut << ScaleFactor;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)MapStreetFilterLimit.size();
      {
         for (tU32 u32Idx = 0; u32Idx < MapStreetFilterLimit.size(); ++u32Idx)
            oOut << MapStreetFilterLimit[u32Idx];
      }
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << CityCentre_YLimit;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << POI_YLimit;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << OneWayMarks_YLimit;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDrawMapMethodResult::intmapfi_tclMsgDrawMapMethodResult(const intmapfi_tclMsgDrawMapMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDrawMapMethodResult& intmapfi_tclMsgDrawMapMethodResult::operator=(const intmapfi_tclMsgDrawMapMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgDrawMapMethodResult::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgDrawMapMethodResult::u16GetFunctionID() const {return INTMAPFI_C_U16_DRAWMAP;}
tU8 intmapfi_tclMsgDrawMapMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 intmapfi_tclMsgDrawMapMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgDrawMapMethodResult::operator==(const intmapfi_tclMsgDrawMapMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgDrawMapMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgDrawMapMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgSetScaleConfigMethodStart::intmapfi_tclMsgSetScaleConfigMethodStart(const intmapfi_tclMsgSetScaleConfigMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   T_ScaleConfig = coRef.T_ScaleConfig;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgSetScaleConfigMethodStart& intmapfi_tclMsgSetScaleConfigMethodStart::operator=(const intmapfi_tclMsgSetScaleConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   T_ScaleConfig = coRef.T_ScaleConfig;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgSetScaleConfigMethodStart::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgSetScaleConfigMethodStart::u16GetFunctionID() const {return INTMAPFI_C_U16_SETSCALECONFIG;}
tU8 intmapfi_tclMsgSetScaleConfigMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intmapfi_tclMsgSetScaleConfigMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < T_ScaleConfig.size(); ++u32Idx)
         T_ScaleConfig[u32Idx].vDestroy();
   }
   T_ScaleConfig.clear();
}

tU32 intmapfi_tclMsgSetScaleConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+T_ScaleConfig.size()*6;
}

tBool intmapfi_tclMsgSetScaleConfigMethodStart::operator==(const intmapfi_tclMsgSetScaleConfigMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (T_ScaleConfig.size() == rfoCmp.T_ScaleConfig.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < T_ScaleConfig.size()); ++u32Idx)
            bResult = bResult && (T_ScaleConfig[u32Idx] == rfoCmp.T_ScaleConfig[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgSetScaleConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < T_ScaleConfig.size(); ++u32Idx)
      {
         T_ScaleConfig[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      T_ScaleConfig.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> T_ScaleConfig[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgSetScaleConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)T_ScaleConfig.size();
   {
      for (tU32 u32Idx = 0; u32Idx < T_ScaleConfig.size(); ++u32Idx)
         oOut << T_ScaleConfig[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgSetScaleConfigMethodResult::intmapfi_tclMsgSetScaleConfigMethodResult(const intmapfi_tclMsgSetScaleConfigMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgSetScaleConfigMethodResult& intmapfi_tclMsgSetScaleConfigMethodResult::operator=(const intmapfi_tclMsgSetScaleConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgSetScaleConfigMethodResult::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgSetScaleConfigMethodResult::u16GetFunctionID() const {return INTMAPFI_C_U16_SETSCALECONFIG;}
tU8 intmapfi_tclMsgSetScaleConfigMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 intmapfi_tclMsgSetScaleConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgSetScaleConfigMethodResult::operator==(const intmapfi_tclMsgSetScaleConfigMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgSetScaleConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgSetScaleConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngEnableFeatureMethodStart::intmapfi_tclMsgEngEnableFeatureMethodStart(const intmapfi_tclMsgEngEnableFeatureMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   FeatureMask = coRef.FeatureMask;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngEnableFeatureMethodStart& intmapfi_tclMsgEngEnableFeatureMethodStart::operator=(const intmapfi_tclMsgEngEnableFeatureMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FeatureMask = coRef.FeatureMask;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgEngEnableFeatureMethodStart::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgEngEnableFeatureMethodStart::u16GetFunctionID() const {return INTMAPFI_C_U16_ENGENABLEFEATURE;}
tU8 intmapfi_tclMsgEngEnableFeatureMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 intmapfi_tclMsgEngEnableFeatureMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool intmapfi_tclMsgEngEnableFeatureMethodStart::operator==(const intmapfi_tclMsgEngEnableFeatureMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FeatureMask == rfoCmp.FeatureMask);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgEngEnableFeatureMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> FeatureMask;
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgEngEnableFeatureMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FeatureMask;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngEnableFeatureMethodResult::intmapfi_tclMsgEngEnableFeatureMethodResult(const intmapfi_tclMsgEngEnableFeatureMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngEnableFeatureMethodResult& intmapfi_tclMsgEngEnableFeatureMethodResult::operator=(const intmapfi_tclMsgEngEnableFeatureMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgEngEnableFeatureMethodResult::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgEngEnableFeatureMethodResult::u16GetFunctionID() const {return INTMAPFI_C_U16_ENGENABLEFEATURE;}
tU8 intmapfi_tclMsgEngEnableFeatureMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 intmapfi_tclMsgEngEnableFeatureMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgEngEnableFeatureMethodResult::operator==(const intmapfi_tclMsgEngEnableFeatureMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgEngEnableFeatureMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgEngEnableFeatureMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngConfigFeatureMethodStart::intmapfi_tclMsgEngConfigFeatureMethodStart(const intmapfi_tclMsgEngConfigFeatureMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Key = coRef.Key;
   Value = coRef.Value;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngConfigFeatureMethodStart& intmapfi_tclMsgEngConfigFeatureMethodStart::operator=(const intmapfi_tclMsgEngConfigFeatureMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Key = coRef.Key;
   Value = coRef.Value;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgEngConfigFeatureMethodStart::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgEngConfigFeatureMethodStart::u16GetFunctionID() const {return INTMAPFI_C_U16_ENGCONFIGFEATURE;}
tU8 intmapfi_tclMsgEngConfigFeatureMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 intmapfi_tclMsgEngConfigFeatureMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool intmapfi_tclMsgEngConfigFeatureMethodStart::operator==(const intmapfi_tclMsgEngConfigFeatureMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Key == rfoCmp.Key);
      bResult = bResult && (Value == rfoCmp.Value);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgEngConfigFeatureMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Key;
   oIn >> Value;
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgEngConfigFeatureMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Key;
   oOut << Value;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngConfigFeatureMethodResult::intmapfi_tclMsgEngConfigFeatureMethodResult(const intmapfi_tclMsgEngConfigFeatureMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngConfigFeatureMethodResult& intmapfi_tclMsgEngConfigFeatureMethodResult::operator=(const intmapfi_tclMsgEngConfigFeatureMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgEngConfigFeatureMethodResult::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgEngConfigFeatureMethodResult::u16GetFunctionID() const {return INTMAPFI_C_U16_ENGCONFIGFEATURE;}
tU8 intmapfi_tclMsgEngConfigFeatureMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 intmapfi_tclMsgEngConfigFeatureMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgEngConfigFeatureMethodResult::operator==(const intmapfi_tclMsgEngConfigFeatureMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgEngConfigFeatureMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgEngConfigFeatureMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDirectoryGet::intmapfi_tclMsgDirectoryGet(const intmapfi_tclMsgDirectoryGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDirectoryGet& intmapfi_tclMsgDirectoryGet::operator=(const intmapfi_tclMsgDirectoryGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgDirectoryGet::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgDirectoryGet::u16GetFunctionID() const {return INTMAPFI_C_U16_DIRECTORY;}
tU8 intmapfi_tclMsgDirectoryGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intmapfi_tclMsgDirectoryGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgDirectoryGet::operator==(const intmapfi_tclMsgDirectoryGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgDirectoryGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgDirectoryGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDirectoryStatus::intmapfi_tclMsgDirectoryStatus(const intmapfi_tclMsgDirectoryStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataBaseId = coRef.DataBaseId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDirectoryStatus& intmapfi_tclMsgDirectoryStatus::operator=(const intmapfi_tclMsgDirectoryStatus& coRef)
{
   if (this == &coRef) return *this;
   DataBaseId = coRef.DataBaseId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgDirectoryStatus::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgDirectoryStatus::u16GetFunctionID() const {return INTMAPFI_C_U16_DIRECTORY;}
tU8 intmapfi_tclMsgDirectoryStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intmapfi_tclMsgDirectoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool intmapfi_tclMsgDirectoryStatus::operator==(const intmapfi_tclMsgDirectoryStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataBaseId == rfoCmp.DataBaseId);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgDirectoryStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DataBaseId;
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgDirectoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataBaseId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgParameterChangeGet::intmapfi_tclMsgParameterChangeGet(const intmapfi_tclMsgParameterChangeGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgParameterChangeGet& intmapfi_tclMsgParameterChangeGet::operator=(const intmapfi_tclMsgParameterChangeGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgParameterChangeGet::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgParameterChangeGet::u16GetFunctionID() const {return INTMAPFI_C_U16_PARAMETERCHANGE;}
tU8 intmapfi_tclMsgParameterChangeGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intmapfi_tclMsgParameterChangeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgParameterChangeGet::operator==(const intmapfi_tclMsgParameterChangeGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgParameterChangeGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgParameterChangeGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgParameterChangeStatus::intmapfi_tclMsgParameterChangeStatus(const intmapfi_tclMsgParameterChangeStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Counter = coRef.Counter;
   Detail = coRef.Detail;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgParameterChangeStatus& intmapfi_tclMsgParameterChangeStatus::operator=(const intmapfi_tclMsgParameterChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   Counter = coRef.Counter;
   Detail = coRef.Detail;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgParameterChangeStatus::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgParameterChangeStatus::u16GetFunctionID() const {return INTMAPFI_C_U16_PARAMETERCHANGE;}
tU8 intmapfi_tclMsgParameterChangeStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intmapfi_tclMsgParameterChangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool intmapfi_tclMsgParameterChangeStatus::operator==(const intmapfi_tclMsgParameterChangeStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Counter == rfoCmp.Counter);
      bResult = bResult && (Detail == rfoCmp.Detail);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgParameterChangeStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Counter;
   oIn >> Detail;
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgParameterChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Counter;
   oOut << Detail;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDataUpdateGet::intmapfi_tclMsgDataUpdateGet(const intmapfi_tclMsgDataUpdateGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDataUpdateGet& intmapfi_tclMsgDataUpdateGet::operator=(const intmapfi_tclMsgDataUpdateGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgDataUpdateGet::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgDataUpdateGet::u16GetFunctionID() const {return INTMAPFI_C_U16_DATAUPDATE;}
tU8 intmapfi_tclMsgDataUpdateGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intmapfi_tclMsgDataUpdateGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgDataUpdateGet::operator==(const intmapfi_tclMsgDataUpdateGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgDataUpdateGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgDataUpdateGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDataUpdateStatus::intmapfi_tclMsgDataUpdateStatus(const intmapfi_tclMsgDataUpdateStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Counter = coRef.Counter;
   UpdateCause = coRef.UpdateCause;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgDataUpdateStatus& intmapfi_tclMsgDataUpdateStatus::operator=(const intmapfi_tclMsgDataUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   Counter = coRef.Counter;
   UpdateCause = coRef.UpdateCause;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgDataUpdateStatus::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgDataUpdateStatus::u16GetFunctionID() const {return INTMAPFI_C_U16_DATAUPDATE;}
tU8 intmapfi_tclMsgDataUpdateStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intmapfi_tclMsgDataUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool intmapfi_tclMsgDataUpdateStatus::operator==(const intmapfi_tclMsgDataUpdateStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Counter == rfoCmp.Counter);
      bResult = bResult && (UpdateCause == rfoCmp.UpdateCause);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgDataUpdateStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Counter;
   oIn >> UpdateCause;
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgDataUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Counter;
   oOut << UpdateCause;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngineeringTextGet::intmapfi_tclMsgEngineeringTextGet(const intmapfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngineeringTextGet& intmapfi_tclMsgEngineeringTextGet::operator=(const intmapfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return INTMAPFI_C_U16_ENGINEERINGTEXT;}
tU8 intmapfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intmapfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgEngineeringTextGet::operator==(const intmapfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngineeringTextUpReg::intmapfi_tclMsgEngineeringTextUpReg(const intmapfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngineeringTextUpReg& intmapfi_tclMsgEngineeringTextUpReg::operator=(const intmapfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return INTMAPFI_C_U16_ENGINEERINGTEXT;}
tU8 intmapfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 intmapfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgEngineeringTextUpReg::operator==(const intmapfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngineeringTextRelUpReg::intmapfi_tclMsgEngineeringTextRelUpReg(const intmapfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngineeringTextRelUpReg& intmapfi_tclMsgEngineeringTextRelUpReg::operator=(const intmapfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return INTMAPFI_C_U16_ENGINEERINGTEXT;}
tU8 intmapfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 intmapfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgEngineeringTextRelUpReg::operator==(const intmapfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngineeringTextStatus::intmapfi_tclMsgEngineeringTextStatus(const intmapfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgEngineeringTextStatus& intmapfi_tclMsgEngineeringTextStatus::operator=(const intmapfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return INTMAPFI_C_U16_ENGINEERINGTEXT;}
tU8 intmapfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid intmapfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 intmapfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool intmapfi_tclMsgEngineeringTextStatus::operator==(const intmapfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgUsedDatasetGet::intmapfi_tclMsgUsedDatasetGet(const intmapfi_tclMsgUsedDatasetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgUsedDatasetGet& intmapfi_tclMsgUsedDatasetGet::operator=(const intmapfi_tclMsgUsedDatasetGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgUsedDatasetGet::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgUsedDatasetGet::u16GetFunctionID() const {return INTMAPFI_C_U16_USEDDATASET;}
tU8 intmapfi_tclMsgUsedDatasetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intmapfi_tclMsgUsedDatasetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgUsedDatasetGet::operator==(const intmapfi_tclMsgUsedDatasetGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgUsedDatasetGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgUsedDatasetGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgUsedDatasetUpReg::intmapfi_tclMsgUsedDatasetUpReg(const intmapfi_tclMsgUsedDatasetUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgUsedDatasetUpReg& intmapfi_tclMsgUsedDatasetUpReg::operator=(const intmapfi_tclMsgUsedDatasetUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgUsedDatasetUpReg::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgUsedDatasetUpReg::u16GetFunctionID() const {return INTMAPFI_C_U16_USEDDATASET;}
tU8 intmapfi_tclMsgUsedDatasetUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 intmapfi_tclMsgUsedDatasetUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgUsedDatasetUpReg::operator==(const intmapfi_tclMsgUsedDatasetUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgUsedDatasetUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgUsedDatasetUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgUsedDatasetRelUpReg::intmapfi_tclMsgUsedDatasetRelUpReg(const intmapfi_tclMsgUsedDatasetRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgUsedDatasetRelUpReg& intmapfi_tclMsgUsedDatasetRelUpReg::operator=(const intmapfi_tclMsgUsedDatasetRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgUsedDatasetRelUpReg::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgUsedDatasetRelUpReg::u16GetFunctionID() const {return INTMAPFI_C_U16_USEDDATASET;}
tU8 intmapfi_tclMsgUsedDatasetRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 intmapfi_tclMsgUsedDatasetRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intmapfi_tclMsgUsedDatasetRelUpReg::operator==(const intmapfi_tclMsgUsedDatasetRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgUsedDatasetRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgUsedDatasetRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgUsedDatasetStatus::intmapfi_tclMsgUsedDatasetStatus(const intmapfi_tclMsgUsedDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intmapfi_tclMsgUsedDatasetStatus& intmapfi_tclMsgUsedDatasetStatus::operator=(const intmapfi_tclMsgUsedDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intmapfi_tclMsgUsedDatasetStatus::u16GetServiceID() const {return INTMAPFI_C_U16_SERVICE_ID;}
tU16 intmapfi_tclMsgUsedDatasetStatus::u16GetFunctionID() const {return INTMAPFI_C_U16_USEDDATASET;}
tU8 intmapfi_tclMsgUsedDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intmapfi_tclMsgUsedDatasetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool intmapfi_tclMsgUsedDatasetStatus::operator==(const intmapfi_tclMsgUsedDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
   return bResult;
}

fi_tclInContext& intmapfi_tclMsgUsedDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   oIn >> DataSetId;
   return oIn;
}

fi_tclOutContext& intmapfi_tclMsgUsedDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   oOut << DataSetId;
   return oOut;
}

