/* --DO NOT PROTECT THIS FILE AGAINST DOUBLE INCLUDE !!! */
/************************************************************* +IHDR * .IA *

 .DATEI                [ fi_if.h       ]

 .BESCHREIBUNG

  ---General Information to the Component Maintainer

     Please remind that a modification of an interface can cause some trouble
     to the components which import the interface. The interface file may only
     export files from the component or another interface file.

 ---COMPONENT INTERFACE(S)

     Interface: MESSAGE
                access to message handling functions

     Interface: STDVISITORS
                provides two predefined visitors, a random initializer,
                and a message printer.

 .COPYRIGHT            [ (c) 2002 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [ J. Bruns                                         ]

  Datum    | Name          Modifikation
 ----------|---------------------------------------------------------------
  01.03.02 | CM-DI/ESN1-Br neu
************************************************************** -IHDR * .IE */

#include "fi_msgfw_if.h"

#include "fi_if_gen.h"

/*
 *   Interface: LIFI_TAGS
 *              definition of the tags for string parsing
 */
#ifdef FI_S_IMPORT_INTERFACE_LIFI_TAGS
   #undef FI_S_NO_IMPORT_INTERFACE

   /* --Protection against double include of the interface. */
   #ifndef FI_S_ALREADY_INCLUDE_LIFI_TAGS
      #define FI_S_ALREADY_INCLUDE_LIFI_TAGS
      /* -- Dependencies on other Interfaces */

      /* --Includes. */
      #include "../li_fi/source/Tags.h"
      #include "../li_fi/source/XMLTags.h"

   #endif /* --FI_S_ALREADY_INCLUDE_LIFI_TAGS */
#endif /* --FI_S_IMPORT_INTERFACE_LIFI_TAGS */

/* -- TMData_FI: ------------------------------------------------------------ */


/*
 *    Interface: TMDATAFI_MESSAGE
 *               access to message handling functions of TMData_FI
 */

#ifdef FI_S_IMPORT_INTERFACE_TMDATAFI_MESSAGE

   #undef FI_S_NO_IMPORT_INTERFACE

   /* Protection against double include of the interface: */
   #ifndef FI_S_ALREADY_INCLUDE_TMDATAFI_MESSAGE
      #define FI_S_ALREADY_INCLUDE_TMDATAFI_MESSAGE

      /* Dependencies on other interfaces: */
      #define S_IMPORT_SUB_INTERFACE
      #define AMT_S_IMPORT_INTERFACE_GENERIC
      #include "amt_if.h"
      #undef S_IMPORT_SUB_INTERFACE

      /* Includes: */
		#define FI_S_IMPORT_INTERFACE_BASE_TYPES
		#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
		#include "fi_msgfw_if.h"
      #include "../types/source/alltoken.h"
      #include "../types/source/alltypes.h"
      #include "../types/source/allvisitor.h"
      #include "../tmdata_fi/source/tmdatafitoken.h"
      #include "../tmdata_fi/source/tmdatafitypes.h"
      #include "../tmdata_fi/source/tmdatafistack.h"
      #include "../tmdata_fi/source/tmdatafivisitor.h"
      #include "../tmdata_fi/source/tmdatafilanguage.h"
      #include "../tmdata_fi/source/tmdatafierr.h"

   #endif /* FI_S_ALREADY_INCLUDE_TMDATAFI_MESSAGE */

#endif /* FI_S_IMPORT_INTERFACE_TMDATAFI_MESSAGE */


/*
 *   Interface: TMDATAFI_FUNCTIONID
 *              definition of TMData_FI function-IDs
 */

#ifdef FI_S_IMPORT_INTERFACE_TMDATAFI_FUNCTIONID

   #undef FI_S_NO_IMPORT_INTERFACE

   /* Protection against double include of the interface: */
   #ifndef FI_S_ALREADY_INCLUDE_TMDATAFI_FUNCTIONID
      #define FI_S_ALREADY_INCLUDE_TMDATAFI_FUNCTIONID

      /* Dependencies on other interfaces: */
      /* none */

      /* Includes: */
      #include "../tmdata_fi/source/tmdatafifctid.h"
      #include "../tmdata_fi/source/tmdatafierr.h"

   #endif /* FI_S_ALREADY_INCLUDE_TMDATAFI_FUNCTIONID */

#endif /* FI_S_IMPORT_INTERFACE_TMDATAFI_FUNCTIONID */


/*
 *   Interface: TMDATAFI_ERRORCODES
 *              definition of TMData_FI error codes
 */

#ifdef FI_S_IMPORT_INTERFACE_TMDATAFI_ERRORCODES

   #undef FI_S_NO_IMPORT_INTERFACE

   /* Protection against double include of the interface: */
   #ifndef FI_S_ALREADY_INCLUDE_TMDATAFI_ERRORCODES
      #define FI_S_ALREADY_INCLUDE_TMDATAFI_ERRORCODES

      /* Dependencies on other interfaces: */
      /* none */

      /* Includes: */
      #include "../tmdata_fi/source/tmdatafierr.h"

   #endif /* FI_S_ALREADY_INCLUDE_TMDATAFI_ERRORCODES */

#endif /* FI_S_IMPORT_INTERFACE_TMDATAFI_ERRORCODES */


/*
 *   Interface: TMDATAFI_SERVICEINFO
 *              provides information about the TMData service
 */

#ifdef FI_S_IMPORT_INTERFACE_TMDATAFI_SERVICEINFO

   #undef FI_S_NO_IMPORT_INTERFACE

   /* Protection against double include of the interface: */
   #ifndef FI_S_ALREADY_INCLUDE_TMDATAFI_SERVICEINFO
      #define FI_S_ALREADY_INCLUDE_TMDATAFI_SERVICEINFO

      /* Dependencies on other interfaces: */
      /* none */

      /* Includes: */
      #include "../tmdata_fi/source/tmdatafiserviceinfo.h"

   #endif /* FI_S_ALREADY_INCLUDE_TMDATAFI_SERVICEINFO */

#endif /* FI_S_IMPORT_INTERFACE_TMDATAFI_SERVICEINFO */


/* -------------------------------------------------------------------------- */




/* -- TMPres_FI: ------------------------------------------------------------ */


/*
 *    Interface: TMPRESFI_MESSAGE
 *               access to message handling functions of TMPres_FI
 */


#ifdef FI_S_IMPORT_INTERFACE_TMPRESFI_MESSAGE

   #undef FI_S_NO_IMPORT_INTERFACE

   /* Protection against double include of the interface: */
   #ifndef FI_S_ALREADY_INCLUDE_TMPRESFI_MESSAGE
      #define FI_S_ALREADY_INCLUDE_TMPRESFI_MESSAGE

      /* Dependencies on other interfaces: */
      #define S_IMPORT_SUB_INTERFACE
      #define AMT_S_IMPORT_INTERFACE_GENERIC
      #include "amt_if.h"
      #undef S_IMPORT_SUB_INTERFACE

      /* Includes: */
		#define FI_S_IMPORT_INTERFACE_BASE_TYPES
		#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
		#include "fi_msgfw_if.h"
      #include "../types/source/alltoken.h"
      #include "../types/source/alltypes.h"
      #include "../types/source/allvisitor.h"
      #include "../tmpres_fi/source/tmpresfitoken.h"
      #include "../tmpres_fi/source/tmpresfitypes.h"
      #include "../tmpres_fi/source/tmpresfistack.h"
      #include "../tmpres_fi/source/tmpresfivisitor.h"
      #include "../tmpres_fi/source/tmpresfilanguage.h"
      #include "../tmpres_fi/source/tmpresfierr.h"

   #endif /* FI_S_ALREADY_INCLUDE_TMPRESFI_MESSAGE */

#endif /* FI_S_IMPORT_INTERFACE_TMPRESFI_MESSAGE */


/*
 *   Interface: TMPRESFI_FUNCTIONID
 *              definition of TMPres_FI function-IDs
 */

#ifdef FI_S_IMPORT_INTERFACE_TMPRESFI_FUNCTIONID
   #undef FI_S_NO_IMPORT_INTERFACE

   /* Protection against double include of the interface: */
   #ifndef FI_S_ALREADY_INCLUDE_TMPRESFI_FUNCTIONID
      #define FI_S_ALREADY_INCLUDE_TMPRESFI_FUNCTIONID

      /* Dependencies on other interfaces: */
      /* none */

      /* Includes: */
      #include "../tmpres_fi/source/tmpresfifctid.h"
      #include "../tmpres_fi/source/tmpresfierr.h"

   #endif /* FI_S_ALREADY_INCLUDE_TMPRESFI_FUNCTIONID */

#endif /* FI_S_IMPORT_INTERFACE_TMPRESFI_FUNCTIONID */


/*
 *   Interface: TMPRESFI_ERRORCODES
 *              definition of TMPres_FI error codes
 */

#ifdef FI_S_IMPORT_INTERFACE_TMPRESFI_ERRORCODES

   #undef FI_S_NO_IMPORT_INTERFACE

   /* Protection against double include of the interface: */
   #ifndef FI_S_ALREADY_INCLUDE_TMPRESFI_ERRORCODES
      #define FI_S_ALREADY_INCLUDE_TMPRESFI_ERRORCODES

      /* Dependencies on other interfaces: */
      /* none */

      /* Includes: */
      #include "../tmpres_fi/source/tmpresfierr.h"

   #endif /* FI_S_ALREADY_INCLUDE_TMPRESFI_ERRORCODES */

#endif /* FI_S_IMPORT_INTERFACE_TMPRESFI_ERRORCODES */


/*
 *   Interface: TMPRESFI_SERVICEINFO
 *              provides information about the TMPres service
 */

#ifdef FI_S_IMPORT_INTERFACE_TMPRESFI_SERVICEINFO

   #undef FI_S_NO_IMPORT_INTERFACE

   /* Protection against double include of the interface: */
   #ifndef FI_S_ALREADY_INCLUDE_TMPRESFI_SERVICEINFO
      #define FI_S_ALREADY_INCLUDE_TMPRESFI_SERVICEINFO

      /* Dependencies on other interfaces: */
      /* none */

      /* Includes: */
      #include "../tmpres_fi/source/tmpresfiserviceinfo.h"

   #endif /* FI_S_ALREADY_INCLUDE_TMPRESFI_SERVICEINFO */

#endif /* FI_S_IMPORT_INTERFACE_TMPRESFI_SERVICEINFO */


/* -------------------------------------------------------------------------- */

/*
 *   Interface: FI_TYPEFACTORY
 *              factory for all types of the navi fi group
 */
#ifdef FI_S_IMPORT_INTERFACE_TYPEFACTORY
   #undef FI_S_NO_IMPORT_INTERFACE

/* --Protection against double include of the interface. */
#ifndef FI_S_ALREADY_INCLUDE_TYPEFACTORY
   #define FI_S_ALREADY_INCLUDE_TYPEFACTORY
   /* -- Dependencies on other Interfaces */

   /* --Includes. */
   #include "../types/source/alltypefactory.h"

#endif /* --FI_S_ALREADY_INCLUDE_TYPEFACTORY */
#endif /* --FI_S_IMPORT_INTERFACE_TYPEFACTORY */


/* --Check */
#if (defined FI_S_NO_IMPORT_INTERFACE)
   #pragma message ( "You have to define an interface for the component: FI." )
#endif


/* end of file */
