/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   RDBId = coRef.RDBId;
   CountryCodeOfMessage = coRef.CountryCodeOfMessage;
   LocationType = coRef.LocationType;
   PrimaryLocation = coRef.PrimaryLocation;
   SecondaryLocation = coRef.SecondaryLocation;
   Extent = coRef.Extent;
   Direction = coRef.Direction;
   BiDirectional = coRef.BiDirectional;
   IntersectionPath = coRef.IntersectionPath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart& intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::operator=(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   RDBId = coRef.RDBId;
   CountryCodeOfMessage = coRef.CountryCodeOfMessage;
   LocationType = coRef.LocationType;
   PrimaryLocation = coRef.PrimaryLocation;
   SecondaryLocation = coRef.SecondaryLocation;
   Extent = coRef.Extent;
   Direction = coRef.Direction;
   BiDirectional = coRef.BiDirectional;
   IntersectionPath = coRef.IntersectionPath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::u16GetFunctionID() const {return INTEDMFI_C_U16_GETTRAFFICMESSAGEINTERSECTIONONECELLS;}
tU8 intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::vDestroy()
{
   RDBId.vDestroy(); 
}

tU32 intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+RDBId.u32GetSize(u16MajorVersion);
}

tBool intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::operator==(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (RDBId == rfoCmp.RDBId);
      bResult = bResult && (CountryCodeOfMessage == rfoCmp.CountryCodeOfMessage);
      bResult = bResult && (LocationType == rfoCmp.LocationType);
      bResult = bResult && (PrimaryLocation == rfoCmp.PrimaryLocation);
      bResult = bResult && (SecondaryLocation == rfoCmp.SecondaryLocation);
      bResult = bResult && (Extent == rfoCmp.Extent);
      bResult = bResult && (Direction == rfoCmp.Direction);
      bResult = bResult && (BiDirectional == rfoCmp.BiDirectional);
      bResult = bResult && (IntersectionPath == rfoCmp.IntersectionPath);
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> RDBId;
   oIn >> CountryCodeOfMessage;
   oIn >> LocationType;
   oIn >> PrimaryLocation;
   oIn >> SecondaryLocation;
   oIn >> Extent;
   oIn >> Direction;
   oIn >> BiDirectional;
   oIn >> IntersectionPath;
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << RDBId;
   oOut << CountryCodeOfMessage;
   oOut << LocationType;
   oOut << PrimaryLocation;
   oOut << SecondaryLocation;
   oOut << Extent;
   oOut << Direction;
   oOut << BiDirectional;
   oOut << IntersectionPath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   Shape = coRef.Shape;
   RoadClass = coRef.RoadClass;
   PrefixPriority = coRef.PrefixPriority;
   RoadNumberPrefix = coRef.RoadNumberPrefix;
   RoadNumber = coRef.RoadNumber;
   RoadNumberSuffix = coRef.RoadNumberSuffix;
   RoadName = coRef.RoadName;
   StateCode = coRef.StateCode;
   NumberHierarchy = coRef.NumberHierarchy;
   SegmentId = coRef.SegmentId;
   LocationSegmentIdx = coRef.LocationSegmentIdx;
   Delay = coRef.Delay;
   Length = coRef.Length;
   IntersectionPath = coRef.IntersectionPath;
   Cluster = coRef.Cluster;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult& intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::operator=(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   Shape = coRef.Shape;
   RoadClass = coRef.RoadClass;
   PrefixPriority = coRef.PrefixPriority;
   RoadNumberPrefix = coRef.RoadNumberPrefix;
   RoadNumber = coRef.RoadNumber;
   RoadNumberSuffix = coRef.RoadNumberSuffix;
   RoadName = coRef.RoadName;
   StateCode = coRef.StateCode;
   NumberHierarchy = coRef.NumberHierarchy;
   SegmentId = coRef.SegmentId;
   LocationSegmentIdx = coRef.LocationSegmentIdx;
   Delay = coRef.Delay;
   Length = coRef.Length;
   IntersectionPath = coRef.IntersectionPath;
   Cluster = coRef.Cluster;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::u16GetFunctionID() const {return INTEDMFI_C_U16_GETTRAFFICMESSAGEINTERSECTIONONECELLS;}
tU8 intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::vDestroy()
{
   Shape.vDestroy(); 
   RoadNumberPrefix.vDestroy();
   RoadNumber.vDestroy();
   RoadNumberSuffix.vDestroy();
   RoadName.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionPath.size(); ++u32Idx)
         IntersectionPath[u32Idx].vDestroy();
   }
   IntersectionPath.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
         Cluster[u32Idx].vDestroy();
   }
   Cluster.clear();
}

tU32 intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IntersectionPath.size(); ++u32ListIdx)
      u32DynamicSize += IntersectionPath[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+26+Shape.u32GetSize(u16MajorVersion)+RoadNumberPrefix.u32GetSize(u16MajorVersion)+RoadNumber.u32GetSize(u16MajorVersion)+RoadNumberSuffix.u32GetSize(u16MajorVersion)+RoadName.u32GetSize(u16MajorVersion)+Cluster.size()*9;
}

tBool intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::operator==(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (Shape == rfoCmp.Shape);
      bResult = bResult && (RoadClass == rfoCmp.RoadClass);
      bResult = bResult && (PrefixPriority == rfoCmp.PrefixPriority);
      bResult = bResult && (RoadNumberPrefix == rfoCmp.RoadNumberPrefix);
      bResult = bResult && (RoadNumber == rfoCmp.RoadNumber);
      bResult = bResult && (RoadNumberSuffix == rfoCmp.RoadNumberSuffix);
      bResult = bResult && (RoadName == rfoCmp.RoadName);
      bResult = bResult && (StateCode == rfoCmp.StateCode);
      bResult = bResult && (NumberHierarchy == rfoCmp.NumberHierarchy);
      bResult = bResult && (SegmentId == rfoCmp.SegmentId);
      bResult = bResult && (LocationSegmentIdx == rfoCmp.LocationSegmentIdx);
      bResult = bResult && (Delay == rfoCmp.Delay);
      bResult = bResult && (Length == rfoCmp.Length);
      bResult = bResult && (IntersectionPath.size() == rfoCmp.IntersectionPath.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionPath.size()); ++u32Idx)
            bResult = bResult && (IntersectionPath[u32Idx] == rfoCmp.IntersectionPath[u32Idx]);
      }
      bResult = bResult && (Cluster.size() == rfoCmp.Cluster.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Cluster.size()); ++u32Idx)
            bResult = bResult && (Cluster[u32Idx] == rfoCmp.Cluster[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> Shape;
   oIn >> RoadClass;
   oIn >> PrefixPriority;
   oIn >> RoadNumberPrefix;
   oIn >> RoadNumber;
   oIn >> RoadNumberSuffix;
   oIn >> RoadName;
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> StateCode;
   }
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> NumberHierarchy;
   }
   oIn >> SegmentId;
   oIn >> LocationSegmentIdx;
   oIn >> Delay;
   oIn >> Length;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionPath.size(); ++u32Idx)
      {
         IntersectionPath[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IntersectionPath.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IntersectionPath[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
      {
         Cluster[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Cluster.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Cluster[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << Shape;
   oOut << RoadClass;
   oOut << PrefixPriority;
   oOut << RoadNumberPrefix;
   oOut << RoadNumber;
   oOut << RoadNumberSuffix;
   oOut << RoadName;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << StateCode;
   }
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << NumberHierarchy;
   }
   oOut << SegmentId;
   oOut << LocationSegmentIdx;
   oOut << Delay;
   oOut << Length;
   oOut << (tU32)IntersectionPath.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionPath.size(); ++u32Idx)
         oOut << IntersectionPath[u32Idx];
   }
   oOut << (tU32)Cluster.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Cluster.size(); ++u32Idx)
         oOut << Cluster[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   RDBId = coRef.RDBId;
   CountryCodeOfMessage = coRef.CountryCodeOfMessage;
   LocationType = coRef.LocationType;
   PrimaryLocation = coRef.PrimaryLocation;
   SecondaryLocation = coRef.SecondaryLocation;
   Extent = coRef.Extent;
   Direction = coRef.Direction;
   BiDirectional = coRef.BiDirectional;
   PreciseLocationDescription = coRef.PreciseLocationDescription;
   TMFlowImpact = coRef.TMFlowImpact;
   Speed = coRef.Speed;
   VLI = coRef.VLI;
   Delay = coRef.Delay;
   EventLength = coRef.EventLength;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart& intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::operator=(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   RDBId = coRef.RDBId;
   CountryCodeOfMessage = coRef.CountryCodeOfMessage;
   LocationType = coRef.LocationType;
   PrimaryLocation = coRef.PrimaryLocation;
   SecondaryLocation = coRef.SecondaryLocation;
   Extent = coRef.Extent;
   Direction = coRef.Direction;
   BiDirectional = coRef.BiDirectional;
   PreciseLocationDescription = coRef.PreciseLocationDescription;
   TMFlowImpact = coRef.TMFlowImpact;
   Speed = coRef.Speed;
   VLI = coRef.VLI;
   Delay = coRef.Delay;
   EventLength = coRef.EventLength;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::u16GetFunctionID() const {return INTEDMFI_C_U16_GETTRAFFICMESSAGEONECELLS;}
tU8 intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::vDestroy()
{
   RDBId.vDestroy(); 
   PreciseLocationDescription.vDestroy(); 
}

tU32 intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 33+RDBId.u32GetSize(u16MajorVersion);
}

tBool intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::operator==(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (RDBId == rfoCmp.RDBId);
      bResult = bResult && (CountryCodeOfMessage == rfoCmp.CountryCodeOfMessage);
      bResult = bResult && (LocationType == rfoCmp.LocationType);
      bResult = bResult && (PrimaryLocation == rfoCmp.PrimaryLocation);
      bResult = bResult && (SecondaryLocation == rfoCmp.SecondaryLocation);
      bResult = bResult && (Extent == rfoCmp.Extent);
      bResult = bResult && (Direction == rfoCmp.Direction);
      bResult = bResult && (BiDirectional == rfoCmp.BiDirectional);
      bResult = bResult && (PreciseLocationDescription == rfoCmp.PreciseLocationDescription);
      bResult = bResult && (TMFlowImpact == rfoCmp.TMFlowImpact);
      bResult = bResult && (Speed == rfoCmp.Speed);
      bResult = bResult && (VLI == rfoCmp.VLI);
      bResult = bResult && (Delay == rfoCmp.Delay);
      bResult = bResult && (EventLength == rfoCmp.EventLength);
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> RDBId;
   oIn >> CountryCodeOfMessage;
   oIn >> LocationType;
   oIn >> PrimaryLocation;
   oIn >> SecondaryLocation;
   oIn >> Extent;
   oIn >> Direction;
   oIn >> BiDirectional;
   oIn >> PreciseLocationDescription;
   oIn >> TMFlowImpact;
   oIn >> Speed;
   oIn >> VLI;
   oIn >> Delay;
   oIn >> EventLength;
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << RDBId;
   oOut << CountryCodeOfMessage;
   oOut << LocationType;
   oOut << PrimaryLocation;
   oOut << SecondaryLocation;
   oOut << Extent;
   oOut << Direction;
   oOut << BiDirectional;
   oOut << PreciseLocationDescription;
   oOut << TMFlowImpact;
   oOut << Speed;
   oOut << VLI;
   oOut << Delay;
   oOut << EventLength;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   Shape = coRef.Shape;
   RoadClass = coRef.RoadClass;
   PrefixPriority = coRef.PrefixPriority;
   RoadNumberPrefix = coRef.RoadNumberPrefix;
   RoadNumber = coRef.RoadNumber;
   RoadNumberSuffix = coRef.RoadNumberSuffix;
   RoadName = coRef.RoadName;
   StateCode = coRef.StateCode;
   NumberHierarchy = coRef.NumberHierarchy;
   SegmentId = coRef.SegmentId;
   LocationSegmentIdx = coRef.LocationSegmentIdx;
   Delay = coRef.Delay;
   DelayStatus = coRef.DelayStatus;
   Length = coRef.Length;
   LengthStatus = coRef.LengthStatus;
   FlowValue = coRef.FlowValue;
   NonGeneralisedExtent = coRef.NonGeneralisedExtent;
   EDMLevelOCList = coRef.EDMLevelOCList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult& intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::operator=(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   Shape = coRef.Shape;
   RoadClass = coRef.RoadClass;
   PrefixPriority = coRef.PrefixPriority;
   RoadNumberPrefix = coRef.RoadNumberPrefix;
   RoadNumber = coRef.RoadNumber;
   RoadNumberSuffix = coRef.RoadNumberSuffix;
   RoadName = coRef.RoadName;
   StateCode = coRef.StateCode;
   NumberHierarchy = coRef.NumberHierarchy;
   SegmentId = coRef.SegmentId;
   LocationSegmentIdx = coRef.LocationSegmentIdx;
   Delay = coRef.Delay;
   DelayStatus = coRef.DelayStatus;
   Length = coRef.Length;
   LengthStatus = coRef.LengthStatus;
   FlowValue = coRef.FlowValue;
   NonGeneralisedExtent = coRef.NonGeneralisedExtent;
   EDMLevelOCList = coRef.EDMLevelOCList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::u16GetFunctionID() const {return INTEDMFI_C_U16_GETTRAFFICMESSAGEONECELLS;}
tU8 intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::vDestroy()
{
   Shape.vDestroy(); 
   RoadNumberPrefix.vDestroy();
   RoadNumber.vDestroy();
   RoadNumberSuffix.vDestroy();
   RoadName.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < EDMLevelOCList.size(); ++u32Idx)
         EDMLevelOCList[u32Idx].vDestroy();
   }
   EDMLevelOCList.clear();
}

tU32 intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < EDMLevelOCList.size(); ++u32ListIdx)
      u32DynamicSize += EDMLevelOCList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+29+Shape.u32GetSize(u16MajorVersion)+RoadNumberPrefix.u32GetSize(u16MajorVersion)+RoadNumber.u32GetSize(u16MajorVersion)+RoadNumberSuffix.u32GetSize(u16MajorVersion)+RoadName.u32GetSize(u16MajorVersion);
}

tBool intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::operator==(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (Shape == rfoCmp.Shape);
      bResult = bResult && (RoadClass == rfoCmp.RoadClass);
      bResult = bResult && (PrefixPriority == rfoCmp.PrefixPriority);
      bResult = bResult && (RoadNumberPrefix == rfoCmp.RoadNumberPrefix);
      bResult = bResult && (RoadNumber == rfoCmp.RoadNumber);
      bResult = bResult && (RoadNumberSuffix == rfoCmp.RoadNumberSuffix);
      bResult = bResult && (RoadName == rfoCmp.RoadName);
      bResult = bResult && (StateCode == rfoCmp.StateCode);
      bResult = bResult && (NumberHierarchy == rfoCmp.NumberHierarchy);
      bResult = bResult && (SegmentId == rfoCmp.SegmentId);
      bResult = bResult && (LocationSegmentIdx == rfoCmp.LocationSegmentIdx);
      bResult = bResult && (Delay == rfoCmp.Delay);
      bResult = bResult && (DelayStatus == rfoCmp.DelayStatus);
      bResult = bResult && (Length == rfoCmp.Length);
      bResult = bResult && (LengthStatus == rfoCmp.LengthStatus);
      bResult = bResult && (FlowValue == rfoCmp.FlowValue);
      bResult = bResult && (NonGeneralisedExtent == rfoCmp.NonGeneralisedExtent);
      bResult = bResult && (EDMLevelOCList.size() == rfoCmp.EDMLevelOCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EDMLevelOCList.size()); ++u32Idx)
            bResult = bResult && (EDMLevelOCList[u32Idx] == rfoCmp.EDMLevelOCList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> Shape;
   oIn >> RoadClass;
   oIn >> PrefixPriority;
   oIn >> RoadNumberPrefix;
   oIn >> RoadNumber;
   oIn >> RoadNumberSuffix;
   oIn >> RoadName;
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> StateCode;
   }
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> NumberHierarchy;
   }
   oIn >> SegmentId;
   oIn >> LocationSegmentIdx;
   oIn >> Delay;
   oIn >> DelayStatus;
   oIn >> Length;
   oIn >> LengthStatus;
   oIn >> FlowValue;
   oIn >> NonGeneralisedExtent;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EDMLevelOCList.size(); ++u32Idx)
      {
         EDMLevelOCList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      EDMLevelOCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> EDMLevelOCList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << Shape;
   oOut << RoadClass;
   oOut << PrefixPriority;
   oOut << RoadNumberPrefix;
   oOut << RoadNumber;
   oOut << RoadNumberSuffix;
   oOut << RoadName;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << StateCode;
   }
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << NumberHierarchy;
   }
   oOut << SegmentId;
   oOut << LocationSegmentIdx;
   oOut << Delay;
   oOut << DelayStatus;
   oOut << Length;
   oOut << LengthStatus;
   oOut << FlowValue;
   oOut << NonGeneralisedExtent;
   oOut << (tU32)EDMLevelOCList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < EDMLevelOCList.size(); ++u32Idx)
         oOut << EDMLevelOCList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetExistingRDBsMethodStart::intedmfi_tclMsgGetExistingRDBsMethodStart(const intedmfi_tclMsgGetExistingRDBsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetExistingRDBsMethodStart& intedmfi_tclMsgGetExistingRDBsMethodStart::operator=(const intedmfi_tclMsgGetExistingRDBsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgGetExistingRDBsMethodStart::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgGetExistingRDBsMethodStart::u16GetFunctionID() const {return INTEDMFI_C_U16_GETEXISTINGRDBS;}
tU8 intedmfi_tclMsgGetExistingRDBsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 intedmfi_tclMsgGetExistingRDBsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intedmfi_tclMsgGetExistingRDBsMethodStart::operator==(const intedmfi_tclMsgGetExistingRDBsMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgGetExistingRDBsMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgGetExistingRDBsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetExistingRDBsMethodResult::intedmfi_tclMsgGetExistingRDBsMethodResult(const intedmfi_tclMsgGetExistingRDBsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   RDBList = coRef.RDBList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgGetExistingRDBsMethodResult& intedmfi_tclMsgGetExistingRDBsMethodResult::operator=(const intedmfi_tclMsgGetExistingRDBsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   RDBList = coRef.RDBList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgGetExistingRDBsMethodResult::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgGetExistingRDBsMethodResult::u16GetFunctionID() const {return INTEDMFI_C_U16_GETEXISTINGRDBS;}
tU8 intedmfi_tclMsgGetExistingRDBsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intedmfi_tclMsgGetExistingRDBsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RDBList.size(); ++u32Idx)
         RDBList[u32Idx].vDestroy();
   }
   RDBList.clear();
}

tU32 intedmfi_tclMsgGetExistingRDBsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RDBList.size(); ++u32ListIdx)
      u32DynamicSize += RDBList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool intedmfi_tclMsgGetExistingRDBsMethodResult::operator==(const intedmfi_tclMsgGetExistingRDBsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (RDBList.size() == rfoCmp.RDBList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RDBList.size()); ++u32Idx)
            bResult = bResult && (RDBList[u32Idx] == rfoCmp.RDBList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgGetExistingRDBsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RDBList.size(); ++u32Idx)
      {
         RDBList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RDBList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RDBList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgGetExistingRDBsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << (tU32)RDBList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RDBList.size(); ++u32Idx)
         oOut << RDBList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   ResetTMCCache = coRef.ResetTMCCache;
   TrafficMessages = coRef.TrafficMessages;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart& intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::operator=(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   ResetTMCCache = coRef.ResetTMCCache;
   TrafficMessages = coRef.TrafficMessages;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::u16GetFunctionID() const {return INTEDMFI_C_U16_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXT;}
tU8 intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TrafficMessages.size(); ++u32Idx)
         TrafficMessages[u32Idx].vDestroy();
   }
   TrafficMessages.clear();
}

tU32 intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TrafficMessages.size(); ++u32ListIdx)
      u32DynamicSize += TrafficMessages[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::operator==(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (ResetTMCCache == rfoCmp.ResetTMCCache);
      bResult = bResult && (TrafficMessages.size() == rfoCmp.TrafficMessages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TrafficMessages.size()); ++u32Idx)
            bResult = bResult && (TrafficMessages[u32Idx] == rfoCmp.TrafficMessages[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> ResetTMCCache;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TrafficMessages.size(); ++u32Idx)
      {
         TrafficMessages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TrafficMessages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TrafficMessages[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << ResetTMCCache;
   oOut << (tU32)TrafficMessages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TrafficMessages.size(); ++u32Idx)
         oOut << TrafficMessages[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessages = coRef.TrafficMessages;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult& intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::operator=(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessages = coRef.TrafficMessages;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::u16GetFunctionID() const {return INTEDMFI_C_U16_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXT;}
tU8 intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TrafficMessages.size(); ++u32Idx)
         TrafficMessages[u32Idx].vDestroy();
   }
   TrafficMessages.clear();
}

tU32 intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+TrafficMessages.size()*5;
}

tBool intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::operator==(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessages.size() == rfoCmp.TrafficMessages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TrafficMessages.size()); ++u32Idx)
            bResult = bResult && (TrafficMessages[u32Idx] == rfoCmp.TrafficMessages[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TrafficMessages.size(); ++u32Idx)
      {
         TrafficMessages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TrafficMessages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TrafficMessages[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)TrafficMessages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TrafficMessages.size(); ++u32Idx)
         oOut << TrafficMessages[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgCheckMOCDBClientsMethodStart::intedmfi_tclMsgCheckMOCDBClientsMethodStart(const intedmfi_tclMsgCheckMOCDBClientsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgCheckMOCDBClientsMethodStart& intedmfi_tclMsgCheckMOCDBClientsMethodStart::operator=(const intedmfi_tclMsgCheckMOCDBClientsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgCheckMOCDBClientsMethodStart::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgCheckMOCDBClientsMethodStart::u16GetFunctionID() const {return INTEDMFI_C_U16_CHECKMOCDBCLIENTS;}
tU8 intedmfi_tclMsgCheckMOCDBClientsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 intedmfi_tclMsgCheckMOCDBClientsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intedmfi_tclMsgCheckMOCDBClientsMethodStart::operator==(const intedmfi_tclMsgCheckMOCDBClientsMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgCheckMOCDBClientsMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgCheckMOCDBClientsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgCheckMOCDBClientsMethodResult::intedmfi_tclMsgCheckMOCDBClientsMethodResult(const intedmfi_tclMsgCheckMOCDBClientsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgCheckMOCDBClientsMethodResult& intedmfi_tclMsgCheckMOCDBClientsMethodResult::operator=(const intedmfi_tclMsgCheckMOCDBClientsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgCheckMOCDBClientsMethodResult::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgCheckMOCDBClientsMethodResult::u16GetFunctionID() const {return INTEDMFI_C_U16_CHECKMOCDBCLIENTS;}
tU8 intedmfi_tclMsgCheckMOCDBClientsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 intedmfi_tclMsgCheckMOCDBClientsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intedmfi_tclMsgCheckMOCDBClientsMethodResult::operator==(const intedmfi_tclMsgCheckMOCDBClientsMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgCheckMOCDBClientsMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgCheckMOCDBClientsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgTrafficMessageDataSetGet::intedmfi_tclMsgTrafficMessageDataSetGet(const intedmfi_tclMsgTrafficMessageDataSetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgTrafficMessageDataSetGet& intedmfi_tclMsgTrafficMessageDataSetGet::operator=(const intedmfi_tclMsgTrafficMessageDataSetGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgTrafficMessageDataSetGet::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgTrafficMessageDataSetGet::u16GetFunctionID() const {return INTEDMFI_C_U16_TRAFFICMESSAGEDATASET;}
tU8 intedmfi_tclMsgTrafficMessageDataSetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intedmfi_tclMsgTrafficMessageDataSetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intedmfi_tclMsgTrafficMessageDataSetGet::operator==(const intedmfi_tclMsgTrafficMessageDataSetGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgTrafficMessageDataSetGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgTrafficMessageDataSetGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgTrafficMessageDataSetStatus::intedmfi_tclMsgTrafficMessageDataSetStatus(const intedmfi_tclMsgTrafficMessageDataSetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
   Availability = coRef.Availability;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgTrafficMessageDataSetStatus& intedmfi_tclMsgTrafficMessageDataSetStatus::operator=(const intedmfi_tclMsgTrafficMessageDataSetStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
   Availability = coRef.Availability;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgTrafficMessageDataSetStatus::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgTrafficMessageDataSetStatus::u16GetFunctionID() const {return INTEDMFI_C_U16_TRAFFICMESSAGEDATASET;}
tU8 intedmfi_tclMsgTrafficMessageDataSetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 intedmfi_tclMsgTrafficMessageDataSetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool intedmfi_tclMsgTrafficMessageDataSetStatus::operator==(const intedmfi_tclMsgTrafficMessageDataSetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (Availability == rfoCmp.Availability);
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgTrafficMessageDataSetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   oIn >> DataSetId;
   oIn >> Availability;
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgTrafficMessageDataSetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   oOut << DataSetId;
   oOut << Availability;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgEngineeringTextGet::intedmfi_tclMsgEngineeringTextGet(const intedmfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgEngineeringTextGet& intedmfi_tclMsgEngineeringTextGet::operator=(const intedmfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return INTEDMFI_C_U16_ENGINEERINGTEXT;}
tU8 intedmfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 intedmfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intedmfi_tclMsgEngineeringTextGet::operator==(const intedmfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgEngineeringTextUpReg::intedmfi_tclMsgEngineeringTextUpReg(const intedmfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgEngineeringTextUpReg& intedmfi_tclMsgEngineeringTextUpReg::operator=(const intedmfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return INTEDMFI_C_U16_ENGINEERINGTEXT;}
tU8 intedmfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 intedmfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intedmfi_tclMsgEngineeringTextUpReg::operator==(const intedmfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgEngineeringTextRelUpReg::intedmfi_tclMsgEngineeringTextRelUpReg(const intedmfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgEngineeringTextRelUpReg& intedmfi_tclMsgEngineeringTextRelUpReg::operator=(const intedmfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return INTEDMFI_C_U16_ENGINEERINGTEXT;}
tU8 intedmfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 intedmfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool intedmfi_tclMsgEngineeringTextRelUpReg::operator==(const intedmfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgEngineeringTextStatus::intedmfi_tclMsgEngineeringTextStatus(const intedmfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
intedmfi_tclMsgEngineeringTextStatus& intedmfi_tclMsgEngineeringTextStatus::operator=(const intedmfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 intedmfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return INTEDMFI_C_U16_SERVICE_ID;}
tU16 intedmfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return INTEDMFI_C_U16_ENGINEERINGTEXT;}
tU8 intedmfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid intedmfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 intedmfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool intedmfi_tclMsgEngineeringTextStatus::operator==(const intedmfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& intedmfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& intedmfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

