#ifndef INTEDMFILANGUAGE_HEADER
#define INTEDMFILANGUAGE_HEADER

class intedmfi_tclInContext;
class intedmfi_tclOutContext;
class intedmfi_tclVisitorBase;

class MY_DECL intedmfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  intedmfi_tclDescription(fi_tclInContext* poIn, intedmfi_tclVisitorBase* poVisit);
  intedmfi_tclDescription(fi_tclOutContext* poOut, intedmfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(intedmfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ intedmfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  intedmfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<intedmfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<intedmfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline intedmfi_tclDescription::intedmfi_tclDescription(fi_tclInContext* poIn, intedmfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline intedmfi_tclDescription::intedmfi_tclDescription(fi_tclOutContext* poOut, intedmfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

