#include "precompiled.hh"

tBool intedmfi_tclDescription::bInitMessage(intedmfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case intedmfi_tclToken::EN_LAST_TOKEN:
   case intedmfi_tclToken::EN_LIST:
   case intedmfi_tclToken::EN_END_OF_STRUCT:
   case intedmfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEINTERSECTIONONECELLSMETHODSTART:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_B8_TMCINTERSECTIONPATH,intedmfi_tclSemanticDomain::EN_MSG_INTERSECTIONPATH));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_MSG_BIDIRECTIONAL));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_MSG_DIRECTION));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_MSG_EXTENT));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_MSG_SECONDARYLOCATION));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_MSG_PRIMARYLOCATION));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMLOCATIONTYPE,intedmfi_tclSemanticDomain::EN_MSG_LOCATIONTYPE));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E16_ISOCOUNTRYCODE,intedmfi_tclSemanticDomain::EN_MSG_COUNTRYCODEOFMESSAGE));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_RDBID,intedmfi_tclSemanticDomain::EN_MSG_RDBID));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32_DATASETID,intedmfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEINTERSECTIONONECELLSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_NAVCLUSTERDESC,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_MSG_CLUSTER));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_TMINTERSECTIONPATH,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_MSG_INTERSECTIONPATH));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_METER,intedmfi_tclSemanticDomain::EN_MSG_LENGTH));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_SECOND,intedmfi_tclSemanticDomain::EN_MSG_DELAY));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_MSG_LOCATIONSEGMENTIDX));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_MSG_SEGMENTID));
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_MSG_NUMBERHIERARCHY));
      }
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32,intedmfi_tclSemanticDomain::EN_MSG_STATECODE));
      }
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_TMCSTRUCTUREDTEXT,intedmfi_tclSemanticDomain::EN_MSG_ROADNAME));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_MSG_ROADNUMBERSUFFIX));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_MSG_ROADNUMBER));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_MSG_ROADNUMBERPREFIX));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_MSG_PREFIXPRIORITY));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_ROADCLASSCODE,intedmfi_tclSemanticDomain::EN_MSG_ROADCLASS));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_SHAPE,intedmfi_tclSemanticDomain::EN_MSG_SHAPE));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32_DATASETID,intedmfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEONECELLSMETHODSTART:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_METER,intedmfi_tclSemanticDomain::EN_MSG_EVENTLENGTH));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_SECOND,intedmfi_tclSemanticDomain::EN_MSG_DELAY));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8_PERCENT,intedmfi_tclSemanticDomain::EN_MSG_VLI));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S16_KMPERHOUR,intedmfi_tclSemanticDomain::EN_MSG_SPEED));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMEXTENDEDFLOWIMPACT,intedmfi_tclSemanticDomain::EN_MSG_TMFLOWIMPACT));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_TMPRECISELOCATIONDESCRIPTION,intedmfi_tclSemanticDomain::EN_MSG_PRECISELOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_MSG_BIDIRECTIONAL));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_MSG_DIRECTION));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_MSG_EXTENT));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_MSG_SECONDARYLOCATION));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_MSG_PRIMARYLOCATION));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMLOCATIONTYPE,intedmfi_tclSemanticDomain::EN_MSG_LOCATIONTYPE));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E16_ISOCOUNTRYCODE,intedmfi_tclSemanticDomain::EN_MSG_COUNTRYCODEOFMESSAGE));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_RDBID,intedmfi_tclSemanticDomain::EN_MSG_RDBID));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32_DATASETID,intedmfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEONECELLSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_EDMLEVELOCLIST,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_MSG_EDMLEVELOCLIST));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32,intedmfi_tclSemanticDomain::EN_MSG_NONGENERALISEDEXTENT));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_MSG_FLOWVALUE));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMVALUESTATUS,intedmfi_tclSemanticDomain::EN_MSG_LENGTHSTATUS));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_METER,intedmfi_tclSemanticDomain::EN_MSG_LENGTH));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMVALUESTATUS,intedmfi_tclSemanticDomain::EN_MSG_DELAYSTATUS));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_SECOND,intedmfi_tclSemanticDomain::EN_MSG_DELAY));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_MSG_LOCATIONSEGMENTIDX));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_MSG_SEGMENTID));
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_MSG_NUMBERHIERARCHY));
      }
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32,intedmfi_tclSemanticDomain::EN_MSG_STATECODE));
      }
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_TMCSTRUCTUREDTEXT,intedmfi_tclSemanticDomain::EN_MSG_ROADNAME));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_MSG_ROADNUMBERSUFFIX));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_MSG_ROADNUMBER));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_MSG_ROADNUMBERPREFIX));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_MSG_PREFIXPRIORITY));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_ROADCLASSCODE,intedmfi_tclSemanticDomain::EN_MSG_ROADCLASS));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_SHAPE,intedmfi_tclSemanticDomain::EN_MSG_SHAPE));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32_DATASETID,intedmfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case intedmfi_tclToken::EN_MSG_GETEXISTINGRDBSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_ISORDBID,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_MSG_RDBLIST));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32_DATASETID,intedmfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case intedmfi_tclToken::EN_MSG_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXTMETHODSTART:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_TMDESCRIPTION,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGES));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_MSG_RESETTMCCACHE));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32_DATASETID,intedmfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case intedmfi_tclToken::EN_MSG_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_TMREQUIREMENTFULFILMENT,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGES));
   } break;
   case intedmfi_tclToken::EN_MSG_TRAFFICMESSAGEDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_DATAAVAILABLE,intedmfi_tclSemanticDomain::EN_MSG_AVAILABILITY));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32_DATASETID,intedmfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32_MEDIAID,intedmfi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case intedmfi_tclToken::EN_BINCONTAINER:
   case intedmfi_tclToken::EN_U8_PERCENT:
   case intedmfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case intedmfi_tclToken::EN_S32_METER:
   case intedmfi_tclToken::EN_S32_SECOND:
   case intedmfi_tclToken::EN_S16_KMPERHOUR:
   case intedmfi_tclToken::EN_S32_LONGITUDE:
   case intedmfi_tclToken::EN_S32_LATITUDE:
   case intedmfi_tclToken::EN_POSITIONWGS84:
   case intedmfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case intedmfi_tclToken::EN_E8_TMLOCATIONTYPE:
   case intedmfi_tclToken::EN_RDBID:
   case intedmfi_tclToken::EN_E8_TMHAZARDLOCATIONACCURACY:
   case intedmfi_tclToken::EN_E8_TMRELIABILITY:
   case intedmfi_tclToken::EN_E8_TMHAZARDLOCATIONDYNAMICS:
   case intedmfi_tclToken::EN_E8_TMEXTENDEDFLOWIMPACT:
   case intedmfi_tclToken::EN_TMDESCRIPTION:
   case intedmfi_tclToken::EN_TMREQUIREMENTFULFILMENT:
   case intedmfi_tclToken::EN_TMPRECISELOCATIONDESCRIPTION:
   case intedmfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case intedmfi_tclToken::EN_NAVONECELLDESC:
   case intedmfi_tclToken::EN_E8_ROADCLASSCODE:
   case intedmfi_tclToken::EN_U32_DATASETID:
   case intedmfi_tclToken::EN_E8_SHAPETYPE:
   case intedmfi_tclToken::EN_SHAPE:
   case intedmfi_tclToken::EN_ISORDBID:
   case intedmfi_tclToken::EN_TMONECELLPORTION:
   case intedmfi_tclToken::EN_E8_TMVALUESTATUS:
   case intedmfi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE:
   case intedmfi_tclToken::EN_TMCSTRUCTUREDTEXT:
   case intedmfi_tclToken::EN_NAVCLUSTERDESC:
   case intedmfi_tclToken::EN_U32_MEDIAID:
   case intedmfi_tclToken::EN_E8_DATAAVAILABLE:
   case intedmfi_tclToken::EN_EDMONECELLPROP:
   case intedmfi_tclToken::EN_EDMONECELL:
   case intedmfi_tclToken::EN_EDMLEVELOCLIST:
   case intedmfi_tclToken::EN_B8_TMCINTERSECTIONPATH:
   case intedmfi_tclToken::EN_TMINTERSECTIONMATRIX:
   case intedmfi_tclToken::EN_TMINTERSECTIONPATH:
   case intedmfi_tclToken::EN_U8:   
   case intedmfi_tclToken::EN_S8:   
   case intedmfi_tclToken::EN_U16:   
   case intedmfi_tclToken::EN_S16:   
   case intedmfi_tclToken::EN_U24:   
   case intedmfi_tclToken::EN_S24:   
   case intedmfi_tclToken::EN_U32:   
   case intedmfi_tclToken::EN_S32:   
   case intedmfi_tclToken::EN_U64:   
   case intedmfi_tclToken::EN_S64:   
   case intedmfi_tclToken::EN_F32:   
   case intedmfi_tclToken::EN_F64:   
   case intedmfi_tclToken::EN_BOOL:   
   case intedmfi_tclToken::EN_STRING:   
   case intedmfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(intedmfi_tclKnot(enMsgToken,intedmfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool intedmfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool intedmfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      intedmfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      intedmfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      intedmfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == intedmfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(intedmfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(intedmfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(intedmfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case intedmfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == intedmfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case intedmfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            intedmfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(intedmfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            intedmfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(intedmfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case intedmfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case intedmfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intedmfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEINTERSECTIONONECELLSMETHODSTART:
   case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEINTERSECTIONONECELLSMETHODRESULT:
   case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEONECELLSMETHODSTART:
   case intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEONECELLSMETHODRESULT:
   case intedmfi_tclToken::EN_MSG_GETEXISTINGRDBSMETHODSTART:
   case intedmfi_tclToken::EN_MSG_GETEXISTINGRDBSMETHODRESULT:
   case intedmfi_tclToken::EN_MSG_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXTMETHODSTART:
   case intedmfi_tclToken::EN_MSG_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXTMETHODRESULT:
   case intedmfi_tclToken::EN_MSG_CHECKMOCDBCLIENTSMETHODSTART:
   case intedmfi_tclToken::EN_MSG_CHECKMOCDBCLIENTSMETHODRESULT:
   case intedmfi_tclToken::EN_MSG_TRAFFICMESSAGEDATASETGET:
   case intedmfi_tclToken::EN_MSG_TRAFFICMESSAGEDATASETSTATUS:
   case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case intedmfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_S32_SECOND:
   {
      fi_tcl_s32_Second o_s32_Second;
      if (!bDoIt(o_s32_Second))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_LATITUDE,intedmfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_LONGITUDE,intedmfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_E8_TMLOCATIONTYPE:
   {
      fi_tcl_e8_TMLocationType o_e8_TMLocationType;
      if (!bDoIt(o_e8_TMLocationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_RDBID:
   {
      if (poVisitor->bDoExpand_RDBId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_BSA));
         }
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_TABLENO));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_TMCCOUNTRYCODE));
      }
      else
      {
         fi_tcl_RDBId o_RDBId;
         if (!bDoIt(o_RDBId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_E8_TMHAZARDLOCATIONACCURACY:
   {
      fi_tcl_e8_TMHazardLocationAccuracy o_e8_TMHazardLocationAccuracy;
      if (!bDoIt(o_e8_TMHazardLocationAccuracy))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_E8_TMRELIABILITY:
   {
      fi_tcl_e8_TMReliability o_e8_TMReliability;
      if (!bDoIt(o_e8_TMReliability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_E8_TMHAZARDLOCATIONDYNAMICS:
   {
      fi_tcl_e8_TMHazardLocationDynamics o_e8_TMHazardLocationDynamics;
      if (!bDoIt(o_e8_TMHazardLocationDynamics))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_E8_TMEXTENDEDFLOWIMPACT:
   {
      fi_tcl_e8_TMExtendedFlowImpact o_e8_TMExtendedFlowImpact;
      if (!bDoIt(o_e8_TMExtendedFlowImpact))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_TMDESCRIPTION:
   {
      if (poVisitor->bDoExpand_TMDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_SECONDARYLOCATIONCODE));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_PRIMARYLOCATIONCODE));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMLOCATIONTYPE,intedmfi_tclSemanticDomain::EN_LOCATIONTYPE));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_RDBID,intedmfi_tclSemanticDomain::EN_RDBID));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32,intedmfi_tclSemanticDomain::EN_HANDLE));
      }
      else
      {
         fi_tcl_TMDescription o_TMDescription;
         if (!bDoIt(o_TMDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_TMREQUIREMENTFULFILMENT:
   {
      if (poVisitor->bDoExpand_TMRequirementFulfilment(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_REQUIREMENTFULFILLED));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32,intedmfi_tclSemanticDomain::EN_HANDLE));
      }
      else
      {
         fi_tcl_TMRequirementFulfilment o_TMRequirementFulfilment;
         if (!bDoIt(o_TMRequirementFulfilment))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMRequirementFulfilment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMRequirementFulfilment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_TMPRECISELOCATIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_TMPreciseLocationDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMHAZARDLOCATIONDYNAMICS,intedmfi_tclSemanticDomain::EN_DYNAMICS));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMRELIABILITY,intedmfi_tclSemanticDomain::EN_RELIABILITY));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMHAZARDLOCATIONACCURACY,intedmfi_tclSemanticDomain::EN_ACCURACY));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_METER,intedmfi_tclSemanticDomain::EN_DISTANCE));
      }
      else
      {
         fi_tcl_TMPreciseLocationDescription o_TMPreciseLocationDescription;
         if (!bDoIt(o_TMPreciseLocationDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMPreciseLocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMPreciseLocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16_INDEXINREFERENCELIST,intedmfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_NAVONECELLDIRECTION,intedmfi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_E8_ROADCLASSCODE:
   {
      fi_tcl_e8_RoadClassCode o_e8_RoadClassCode;
      if (!bDoIt(o_e8_RoadClassCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_E8_SHAPETYPE:
   {
      fi_tcl_e8_ShapeType o_e8_ShapeType;
      if (!bDoIt(o_e8_ShapeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_SHAPE:
   {
      if (poVisitor->bDoExpand_Shape(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_POSITIONWGS84,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_SHAPEPOINTS));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_SHAPETYPE,intedmfi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         fi_tcl_Shape o_Shape;
         if (!bDoIt(o_Shape))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_ISORDBID:
   {
      if (poVisitor->bDoExpand_ISORDBId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_SHAPE,intedmfi_tclSemanticDomain::EN_OUTLINE));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E16_ISOCOUNTRYCODE,intedmfi_tclSemanticDomain::EN_ISOCOUNTRYCODE));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_RDBID,intedmfi_tclSemanticDomain::EN_RDBID));
      }
      else
      {
         fi_tcl_ISORDBId o_ISORDBId;
         if (!bDoIt(o_ISORDBId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ISORDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ISORDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_TMONECELLPORTION:
   {
      if (poVisitor->bDoExpand_TMOneCellPortion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8_PERCENT,intedmfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8_PERCENT,intedmfi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_TMOneCellPortion o_TMOneCellPortion;
         if (!bDoIt(o_TMOneCellPortion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_E8_TMVALUESTATUS:
   {
      fi_tcl_e8_TMValueStatus o_e8_TMValueStatus;
      if (!bDoIt(o_e8_TMValueStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE:
   {
      fi_tcl_e8_TMCIntersectionPathType o_e8_TMCIntersectionPathType;
      if (!bDoIt(o_e8_TMCIntersectionPathType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_TMCSTRUCTUREDTEXT:
   {
      if (poVisitor->bDoExpand_TMCStructuredText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_LONGSUFFIX));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_SHORTSUFFIX));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_LONGBODY));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_SHORTBODY));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_LONGPREFIX));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_STRING,intedmfi_tclSemanticDomain::EN_SHORTPREFIX));
      }
      else
      {
         fi_tcl_TMCStructuredText o_TMCStructuredText;
         if (!bDoIt(o_TMCStructuredText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U32,intedmfi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_U32_MEDIAID:
   {
      fi_tcl_u32_MediaId o_u32_MediaId;
      if (!bDoIt(o_u32_MediaId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_E8_DATAAVAILABLE:
   {
      fi_tcl_e8_DataAvailable o_e8_DataAvailable;
      if (!bDoIt(o_e8_DataAvailable))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_EDMONECELLPROP:
   {
      if (poVisitor->bDoExpand_EDMOneCellProp(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_TMONECELLPORTION,intedmfi_tclSemanticDomain::EN_PORTION));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8_PERCENT,intedmfi_tclSemanticDomain::EN_RELLENGTH));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_S32_METER,intedmfi_tclSemanticDomain::EN_ABSLENGTH));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_F32,intedmfi_tclSemanticDomain::EN_VLI));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_F32,intedmfi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_ROADCLASSCODE,intedmfi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_LANENR));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_ISLAST));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_ISFIRST));
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_ISFREEWAY));
         }
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_ISBUILTUPAREA));
         }
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_ISINCOMPLEXINTERSECTION));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_ISINOBJECT));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_ISPRIMARY));
      }
      else
      {
         fi_tcl_EDMOneCellProp o_EDMOneCellProp;
         if (!bDoIt(o_EDMOneCellProp))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EDMOneCellProp.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EDMOneCellProp.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_EDMONECELL:
   {
      if (poVisitor->bDoExpand_EDMOneCell(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_EDMONECELLPROP,intedmfi_tclSemanticDomain::EN_OCPROPERTIES));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16_INDEXINREFERENCELIST,intedmfi_tclSemanticDomain::EN_INDEXINCLUSTERLIST));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U16,intedmfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_EDMOneCell o_EDMOneCell;
         if (!bDoIt(o_EDMOneCell))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EDMOneCell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EDMOneCell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_EDMLEVELOCLIST:
   {
      if (poVisitor->bDoExpand_EDMLevelOCList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_EDMONECELL,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_EDMOCLIST));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_NAVCLUSTERDESC,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_CLUSTERLIST));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_BOOL,intedmfi_tclSemanticDomain::EN_SORTEDINDRIVERSVIEW));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_EDMLevelOCList o_EDMLevelOCList;
         if (!bDoIt(o_EDMLevelOCList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EDMLevelOCList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EDMLevelOCList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_B8_TMCINTERSECTIONPATH:
   {
      fi_tcl_b8_TMCIntersectionPath o_b8_TMCIntersectionPath;
      if (!bDoIt(o_b8_TMCIntersectionPath))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intedmfi_tclToken::EN_TMINTERSECTIONMATRIX:
   {
      if (poVisitor->bDoExpand_TMIntersectionMatrix(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_NAVONECELLDESC,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_OUTOFINTERSECTIONONECELLS));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_NAVONECELLDESC,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_INTOINTERSECTIONONECELLS));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_U8,intedmfi_tclSemanticDomain::EN_DATALEVEL));
      }
      else
      {
         fi_tcl_TMIntersectionMatrix o_TMIntersectionMatrix;
         if (!bDoIt(o_TMIntersectionMatrix))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMIntersectionMatrix.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMIntersectionMatrix.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intedmfi_tclToken::EN_TMINTERSECTIONPATH:
   {
      if (poVisitor->bDoExpand_TMIntersectionPath(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_END_OF_STRUCT,intedmfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_TMINTERSECTIONMATRIX,intedmfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_LIST,intedmfi_tclSemanticDomain::EN_LEVELMATRIX));
         oPath.bGoDown(intedmfi_tclKnot(intedmfi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE,intedmfi_tclSemanticDomain::EN_PATHTYPE));
      }
      else
      {
         fi_tcl_TMIntersectionPath o_TMIntersectionPath;
         if (!bDoIt(o_TMIntersectionPath))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMIntersectionPath.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMIntersectionPath.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case intedmfi_tclToken::EN_UNKNOWN:
      case intedmfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

