#ifndef __INTEDMFIDEBUGVISITOR_H__
#define __INTEDMFIDEBUGVISITOR_H__

class MY_DECL intedmfi_tclPrintVisitor : public intedmfi_tclVisitorBase {

private:
   /* default constructor */ intedmfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   intedmfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tBool bDoExpand_RDBId(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMHazardLocationAccuracy(fi_tcl_e8_TMHazardLocationAccuracy& o_e8_TMHazardLocationAccuracy);
   virtual tVoid vVisit_e8_TMReliability(fi_tcl_e8_TMReliability& o_e8_TMReliability);
   virtual tVoid vVisit_e8_TMHazardLocationDynamics(fi_tcl_e8_TMHazardLocationDynamics& o_e8_TMHazardLocationDynamics);
   virtual tVoid vVisit_e8_TMExtendedFlowImpact(fi_tcl_e8_TMExtendedFlowImpact& o_e8_TMExtendedFlowImpact);
   virtual tBool bDoExpand_TMDescription(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMRequirementFulfilment(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMPreciseLocationDescription(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tBool bDoExpand_NavOneCellDesc(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tBool bDoExpand_Shape(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ISORDBId(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMOneCellPortion(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& o_e8_TMCIntersectionPathType);
   virtual tBool bDoExpand_TMCStructuredText(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavClusterDesc(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_e8_DataAvailable(fi_tcl_e8_DataAvailable& o_e8_DataAvailable);
   virtual tBool bDoExpand_EDMOneCellProp(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_EDMOneCell(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_EDMLevelOCList(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_TMCIntersectionPath(fi_tcl_b8_TMCIntersectionPath& o_b8_TMCIntersectionPath);
   virtual tBool bDoExpand_TMIntersectionMatrix(intedmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMIntersectionPath(intedmfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL intedmfi_tclRandomInitVisitor : public intedmfi_tclVisitorBase {
public:

   intedmfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e8_TMHazardLocationAccuracy(fi_tcl_e8_TMHazardLocationAccuracy& o_e8_TMHazardLocationAccuracy);
   virtual tVoid vVisit_e8_TMReliability(fi_tcl_e8_TMReliability& o_e8_TMReliability);
   virtual tVoid vVisit_e8_TMHazardLocationDynamics(fi_tcl_e8_TMHazardLocationDynamics& o_e8_TMHazardLocationDynamics);
   virtual tVoid vVisit_e8_TMExtendedFlowImpact(fi_tcl_e8_TMExtendedFlowImpact& o_e8_TMExtendedFlowImpact);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& o_e8_TMCIntersectionPathType);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_e8_DataAvailable(fi_tcl_e8_DataAvailable& o_e8_DataAvailable);
   virtual tVoid vVisit_b8_TMCIntersectionPath(fi_tcl_b8_TMCIntersectionPath& o_b8_TMCIntersectionPath);
	tU32 u32ListSize;
};

#endif
