/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef FASTMAPFITYPES_HEADER
#define FASTMAPFITYPES_HEADER

// #include <vector>
// 


class fastmapfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class fastmapfi_tclMsgOpenFastMapChannelMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgOpenFastMapChannelMethodStart():TransferType(),u8OrderType(),MajorVersion(0),MinorVersion(0),ChannelName(),ChannelSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgOpenFastMapChannelMethodStart& operator=(const fastmapfi_tclMsgOpenFastMapChannelMethodStart& coRef);
   fastmapfi_tclMsgOpenFastMapChannelMethodStart(const fastmapfi_tclMsgOpenFastMapChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_TransferType TransferType;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU8 MajorVersion;
   tU8 MinorVersion;
   fi_tclString ChannelName;
   tU32 ChannelSize;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgOpenFastMapChannelMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODSTART;}
};

class fastmapfi_tclMsgOpenFastMapChannelMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgOpenFastMapChannelMethodResult():Handle(0),CoordinateCoding() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgOpenFastMapChannelMethodResult& operator=(const fastmapfi_tclMsgOpenFastMapChannelMethodResult& coRef);
   fastmapfi_tclMsgOpenFastMapChannelMethodResult(const fastmapfi_tclMsgOpenFastMapChannelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Handle;
   fi_tcl_e8_CoordinateCoding CoordinateCoding;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgOpenFastMapChannelMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODRESULT;}
};

class fastmapfi_tclMsgCloseFastMapChannelMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgCloseFastMapChannelMethodStart():u8OrderType(),Handle(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgCloseFastMapChannelMethodStart& operator=(const fastmapfi_tclMsgCloseFastMapChannelMethodStart& coRef);
   fastmapfi_tclMsgCloseFastMapChannelMethodStart(const fastmapfi_tclMsgCloseFastMapChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU16 Handle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgCloseFastMapChannelMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODSTART;}
};

class fastmapfi_tclMsgCloseFastMapChannelMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgCloseFastMapChannelMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgCloseFastMapChannelMethodResult& operator=(const fastmapfi_tclMsgCloseFastMapChannelMethodResult& coRef);
   fastmapfi_tclMsgCloseFastMapChannelMethodResult(const fastmapfi_tclMsgCloseFastMapChannelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgCloseFastMapChannelMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODRESULT;}
};

class fastmapfi_tclMsgGetBlockIDsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgGetBlockIDsMethodStart():u8OrderType(),DataType(),DatasetID(0),MapScale(),BoundingBox() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgGetBlockIDsMethodStart& operator=(const fastmapfi_tclMsgGetBlockIDsMethodStart& coRef);
   fastmapfi_tclMsgGetBlockIDsMethodStart(const fastmapfi_tclMsgGetBlockIDsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   fi_tcl_e16_DataType DataType;
   tU32 DatasetID;
   fi_tcl_MapScale MapScale;
   fi_tcl_BoundingBox BoundingBox;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgGetBlockIDsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_GETBLOCKIDSMETHODSTART;}
};

class fastmapfi_tclMsgGetBlockIDsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgGetBlockIDsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgGetBlockIDsMethodResult& operator=(const fastmapfi_tclMsgGetBlockIDsMethodResult& coRef);
   fastmapfi_tclMsgGetBlockIDsMethodResult(const fastmapfi_tclMsgGetBlockIDsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_UniqueID, std::allocator<fi_tcl_UniqueID> > UniqueIDs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgGetBlockIDsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_GETBLOCKIDSMETHODRESULT;}
};

class fastmapfi_tclMsgLoadBlocksMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgLoadBlocksMethodStart():u8OrderType(),DatasetID(0),Handle(0),Offset(0),MaxSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgLoadBlocksMethodStart& operator=(const fastmapfi_tclMsgLoadBlocksMethodStart& coRef);
   fastmapfi_tclMsgLoadBlocksMethodStart(const fastmapfi_tclMsgLoadBlocksMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   std::vector<fi_tcl_UniqueID, std::allocator<fi_tcl_UniqueID> > UniqueIDs;
   tU32 DatasetID;
   tU16 Handle;
   tU32 Offset;
   tU32 MaxSize;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgLoadBlocksMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODSTART;}
};

class fastmapfi_tclMsgLoadBlocksMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgLoadBlocksMethodResult():Size(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgLoadBlocksMethodResult& operator=(const fastmapfi_tclMsgLoadBlocksMethodResult& coRef);
   fastmapfi_tclMsgLoadBlocksMethodResult(const fastmapfi_tclMsgLoadBlocksMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Size;
   std::vector<fi_tcl_ResultBlocks, std::allocator<fi_tcl_ResultBlocks> > ResultBlocks;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgLoadBlocksMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODRESULT;}
};

class fastmapfi_tclMsgLoadBlocksMethodAbort : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgLoadBlocksMethodAbort() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgLoadBlocksMethodAbort& operator=(const fastmapfi_tclMsgLoadBlocksMethodAbort& coRef);
   fastmapfi_tclMsgLoadBlocksMethodAbort(const fastmapfi_tclMsgLoadBlocksMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgLoadBlocksMethodAbort& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODABORT;}
};

class fastmapfi_tclMsgLoadBlocksAbortResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgLoadBlocksAbortResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgLoadBlocksAbortResult& operator=(const fastmapfi_tclMsgLoadBlocksAbortResult& coRef);
   fastmapfi_tclMsgLoadBlocksAbortResult(const fastmapfi_tclMsgLoadBlocksAbortResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgLoadBlocksAbortResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_LOADBLOCKSABORTRESULT;}
};

class fastmapfi_tclMsgConvertOnecellListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgConvertOnecellListMethodStart():u8OrderType(),DatasetID(0),Handle(0),Offset(0),MaxSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgConvertOnecellListMethodStart& operator=(const fastmapfi_tclMsgConvertOnecellListMethodStart& coRef);
   fastmapfi_tclMsgConvertOnecellListMethodStart(const fastmapfi_tclMsgConvertOnecellListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetID;
   tU16 Handle;
   tU32 Offset;
   tU32 MaxSize;
   std::vector<fi_tcl_NavClusterId, std::allocator<fi_tcl_NavClusterId> > ClusterIdList;
   std::vector<fi_tcl_LocalOneCellID, std::allocator<fi_tcl_LocalOneCellID> > OnecellIdList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgConvertOnecellListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODSTART;}
};

class fastmapfi_tclMsgConvertOnecellListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgConvertOnecellListMethodResult():Size(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgConvertOnecellListMethodResult& operator=(const fastmapfi_tclMsgConvertOnecellListMethodResult& coRef);
   fastmapfi_tclMsgConvertOnecellListMethodResult(const fastmapfi_tclMsgConvertOnecellListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Size;
   std::vector<fi_tcl_ResultBlocks, std::allocator<fi_tcl_ResultBlocks> > ResultBlockList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgConvertOnecellListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODRESULT;}
};

class fastmapfi_tclMsgBreakDownRouteOCMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgBreakDownRouteOCMethodStart():u8OrderType(),DatasetID(0),RequestType(),BreakDownLevel(0),BoundingBox() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgBreakDownRouteOCMethodStart& operator=(const fastmapfi_tclMsgBreakDownRouteOCMethodStart& coRef);
   fastmapfi_tclMsgBreakDownRouteOCMethodStart(const fastmapfi_tclMsgBreakDownRouteOCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetID;
   fi_tcl_e8_RequestType RequestType;
   tU8 BreakDownLevel;
   fi_tcl_BoundingBox BoundingBox;
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterIdList;
   std::vector<fi_tcl_NavOneCellDesc, std::allocator<fi_tcl_NavOneCellDesc> > OnecellIdList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgBreakDownRouteOCMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODSTART;}
};

class fastmapfi_tclMsgBreakDownRouteOCMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgBreakDownRouteOCMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgBreakDownRouteOCMethodResult& operator=(const fastmapfi_tclMsgBreakDownRouteOCMethodResult& coRef);
   fastmapfi_tclMsgBreakDownRouteOCMethodResult(const fastmapfi_tclMsgBreakDownRouteOCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_SameLevelOneCellBlock, std::allocator<fi_tcl_SameLevelOneCellBlock> > RouteBreakDownList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgBreakDownRouteOCMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODRESULT;}
};

class fastmapfi_tclMsgReserveClientUseIdRangeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgReserveClientUseIdRangeMethodStart():u8OrderType(),ClientName(),NoReqId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgReserveClientUseIdRangeMethodStart& operator=(const fastmapfi_tclMsgReserveClientUseIdRangeMethodStart& coRef);
   fastmapfi_tclMsgReserveClientUseIdRangeMethodStart(const fastmapfi_tclMsgReserveClientUseIdRangeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   fi_tclString ClientName;
   tU32 NoReqId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgReserveClientUseIdRangeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_RESERVECLIENTUSEIDRANGEMETHODSTART;}
};

class fastmapfi_tclMsgReserveClientUseIdRangeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgReserveClientUseIdRangeMethodResult():Handle(0),FirstId(),LastId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgReserveClientUseIdRangeMethodResult& operator=(const fastmapfi_tclMsgReserveClientUseIdRangeMethodResult& coRef);
   fastmapfi_tclMsgReserveClientUseIdRangeMethodResult(const fastmapfi_tclMsgReserveClientUseIdRangeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Handle;
   fi_tcl_UniqueID FirstId;
   fi_tcl_UniqueID LastId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgReserveClientUseIdRangeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_RESERVECLIENTUSEIDRANGEMETHODRESULT;}
};

class fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart():u8OrderType(),Handle(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart& operator=(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart& coRef);
   fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 Handle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_FREECLIENTUSEDIDRANGEMETHODSTART;}
};

class fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult& operator=(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult& coRef);
   fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_FREECLIENTUSEDIDRANGEMETHODRESULT;}
};

class fastmapfi_tclMsgGetClientIdRangeByNameMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgGetClientIdRangeByNameMethodStart():u8OrderType(),ClientName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgGetClientIdRangeByNameMethodStart& operator=(const fastmapfi_tclMsgGetClientIdRangeByNameMethodStart& coRef);
   fastmapfi_tclMsgGetClientIdRangeByNameMethodStart(const fastmapfi_tclMsgGetClientIdRangeByNameMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   fi_tclString ClientName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgGetClientIdRangeByNameMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_GETCLIENTIDRANGEBYNAMEMETHODSTART;}
};

class fastmapfi_tclMsgGetClientIdRangeByNameMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgGetClientIdRangeByNameMethodResult():FirstId(),LastId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgGetClientIdRangeByNameMethodResult& operator=(const fastmapfi_tclMsgGetClientIdRangeByNameMethodResult& coRef);
   fastmapfi_tclMsgGetClientIdRangeByNameMethodResult(const fastmapfi_tclMsgGetClientIdRangeByNameMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UniqueID FirstId;
   fi_tcl_UniqueID LastId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgGetClientIdRangeByNameMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_GETCLIENTIDRANGEBYNAMEMETHODRESULT;}
};

class fastmapfi_tclMsgDatablocksChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgDatablocksChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgDatablocksChangedUpReg& operator=(const fastmapfi_tclMsgDatablocksChangedUpReg& coRef);
   fastmapfi_tclMsgDatablocksChangedUpReg(const fastmapfi_tclMsgDatablocksChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgDatablocksChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDUPREG;}
};

class fastmapfi_tclMsgDatablocksChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgDatablocksChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgDatablocksChangedRelUpReg& operator=(const fastmapfi_tclMsgDatablocksChangedRelUpReg& coRef);
   fastmapfi_tclMsgDatablocksChangedRelUpReg(const fastmapfi_tclMsgDatablocksChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgDatablocksChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDRELUPREG;}
};

class fastmapfi_tclMsgDatablocksChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgDatablocksChangedStatus():Mask(),CompareValue() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgDatablocksChangedStatus& operator=(const fastmapfi_tclMsgDatablocksChangedStatus& coRef);
   fastmapfi_tclMsgDatablocksChangedStatus(const fastmapfi_tclMsgDatablocksChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UniqueID Mask;
   fi_tcl_UniqueID CompareValue;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgDatablocksChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDSTATUS;}
};

class fastmapfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgEngineeringTextGet& operator=(const fastmapfi_tclMsgEngineeringTextGet& coRef);
   fastmapfi_tclMsgEngineeringTextGet(const fastmapfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class fastmapfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgEngineeringTextUpReg& operator=(const fastmapfi_tclMsgEngineeringTextUpReg& coRef);
   fastmapfi_tclMsgEngineeringTextUpReg(const fastmapfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class fastmapfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgEngineeringTextRelUpReg& operator=(const fastmapfi_tclMsgEngineeringTextRelUpReg& coRef);
   fastmapfi_tclMsgEngineeringTextRelUpReg(const fastmapfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class fastmapfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fastmapfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fastmapfi_tclMsgEngineeringTextStatus& operator=(const fastmapfi_tclMsgEngineeringTextStatus& coRef);
   fastmapfi_tclMsgEngineeringTextStatus(const fastmapfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fastmapfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
