/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgOpenFastMapChannelMethodStart::fastmapfi_tclMsgOpenFastMapChannelMethodStart(const fastmapfi_tclMsgOpenFastMapChannelMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TransferType = coRef.TransferType;
   u8OrderType = coRef.u8OrderType;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   ChannelName = coRef.ChannelName;
   ChannelSize = coRef.ChannelSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgOpenFastMapChannelMethodStart& fastmapfi_tclMsgOpenFastMapChannelMethodStart::operator=(const fastmapfi_tclMsgOpenFastMapChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TransferType = coRef.TransferType;
   u8OrderType = coRef.u8OrderType;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   ChannelName = coRef.ChannelName;
   ChannelSize = coRef.ChannelSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgOpenFastMapChannelMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgOpenFastMapChannelMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_OPENFASTMAPCHANNEL;}
tU8 fastmapfi_tclMsgOpenFastMapChannelMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fastmapfi_tclMsgOpenFastMapChannelMethodStart::vDestroy()
{
   ChannelName.vDestroy();
}

tU32 fastmapfi_tclMsgOpenFastMapChannelMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+7+ChannelName.u32GetSize(u16MajorVersion);
}

tBool fastmapfi_tclMsgOpenFastMapChannelMethodStart::operator==(const fastmapfi_tclMsgOpenFastMapChannelMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TransferType == rfoCmp.TransferType);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (MajorVersion == rfoCmp.MajorVersion);
      bResult = bResult && (MinorVersion == rfoCmp.MinorVersion);
      bResult = bResult && (ChannelName == rfoCmp.ChannelName);
      bResult = bResult && (ChannelSize == rfoCmp.ChannelSize);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgOpenFastMapChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TransferType;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> MajorVersion;
   oIn >> MinorVersion;
   oIn >> ChannelName;
   oIn >> ChannelSize;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgOpenFastMapChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TransferType;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << MajorVersion;
   oOut << MinorVersion;
   oOut << ChannelName;
   oOut << ChannelSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgOpenFastMapChannelMethodResult::fastmapfi_tclMsgOpenFastMapChannelMethodResult(const fastmapfi_tclMsgOpenFastMapChannelMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Handle = coRef.Handle;
   CoordinateCoding = coRef.CoordinateCoding;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgOpenFastMapChannelMethodResult& fastmapfi_tclMsgOpenFastMapChannelMethodResult::operator=(const fastmapfi_tclMsgOpenFastMapChannelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Handle = coRef.Handle;
   CoordinateCoding = coRef.CoordinateCoding;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgOpenFastMapChannelMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgOpenFastMapChannelMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_OPENFASTMAPCHANNEL;}
tU8 fastmapfi_tclMsgOpenFastMapChannelMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 fastmapfi_tclMsgOpenFastMapChannelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool fastmapfi_tclMsgOpenFastMapChannelMethodResult::operator==(const fastmapfi_tclMsgOpenFastMapChannelMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Handle == rfoCmp.Handle);
      bResult = bResult && (CoordinateCoding == rfoCmp.CoordinateCoding);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgOpenFastMapChannelMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Handle;
   oIn >> CoordinateCoding;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgOpenFastMapChannelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Handle;
   oOut << CoordinateCoding;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgCloseFastMapChannelMethodStart::fastmapfi_tclMsgCloseFastMapChannelMethodStart(const fastmapfi_tclMsgCloseFastMapChannelMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   Handle = coRef.Handle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgCloseFastMapChannelMethodStart& fastmapfi_tclMsgCloseFastMapChannelMethodStart::operator=(const fastmapfi_tclMsgCloseFastMapChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   Handle = coRef.Handle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgCloseFastMapChannelMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgCloseFastMapChannelMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_CLOSEFASTMAPCHANNEL;}
tU8 fastmapfi_tclMsgCloseFastMapChannelMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 fastmapfi_tclMsgCloseFastMapChannelMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+2;
}

tBool fastmapfi_tclMsgCloseFastMapChannelMethodStart::operator==(const fastmapfi_tclMsgCloseFastMapChannelMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (Handle == rfoCmp.Handle);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgCloseFastMapChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> Handle;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgCloseFastMapChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << Handle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgCloseFastMapChannelMethodResult::fastmapfi_tclMsgCloseFastMapChannelMethodResult(const fastmapfi_tclMsgCloseFastMapChannelMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgCloseFastMapChannelMethodResult& fastmapfi_tclMsgCloseFastMapChannelMethodResult::operator=(const fastmapfi_tclMsgCloseFastMapChannelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgCloseFastMapChannelMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgCloseFastMapChannelMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_CLOSEFASTMAPCHANNEL;}
tU8 fastmapfi_tclMsgCloseFastMapChannelMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 fastmapfi_tclMsgCloseFastMapChannelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgCloseFastMapChannelMethodResult::operator==(const fastmapfi_tclMsgCloseFastMapChannelMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgCloseFastMapChannelMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgCloseFastMapChannelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgGetBlockIDsMethodStart::fastmapfi_tclMsgGetBlockIDsMethodStart(const fastmapfi_tclMsgGetBlockIDsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DataType = coRef.DataType;
   DatasetID = coRef.DatasetID;
   MapScale = coRef.MapScale;
   BoundingBox = coRef.BoundingBox;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgGetBlockIDsMethodStart& fastmapfi_tclMsgGetBlockIDsMethodStart::operator=(const fastmapfi_tclMsgGetBlockIDsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DataType = coRef.DataType;
   DatasetID = coRef.DatasetID;
   MapScale = coRef.MapScale;
   BoundingBox = coRef.BoundingBox;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgGetBlockIDsMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgGetBlockIDsMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_GETBLOCKIDS;}
tU8 fastmapfi_tclMsgGetBlockIDsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fastmapfi_tclMsgGetBlockIDsMethodStart::vDestroy()
{
   BoundingBox.vDestroy(); 
}

tU32 fastmapfi_tclMsgGetBlockIDsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+24;
}

tBool fastmapfi_tclMsgGetBlockIDsMethodStart::operator==(const fastmapfi_tclMsgGetBlockIDsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DataType == rfoCmp.DataType);
      bResult = bResult && (DatasetID == rfoCmp.DatasetID);
      bResult = bResult && (MapScale == rfoCmp.MapScale);
      bResult = bResult && (BoundingBox == rfoCmp.BoundingBox);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgGetBlockIDsMethodStart::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DataType;
   oIn >> DatasetID;
   oIn >> MapScale;
   oIn >> BoundingBox;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgGetBlockIDsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DataType;
   oOut << DatasetID;
   oOut << MapScale;
   oOut << BoundingBox;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgGetBlockIDsMethodResult::fastmapfi_tclMsgGetBlockIDsMethodResult(const fastmapfi_tclMsgGetBlockIDsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UniqueIDs = coRef.UniqueIDs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgGetBlockIDsMethodResult& fastmapfi_tclMsgGetBlockIDsMethodResult::operator=(const fastmapfi_tclMsgGetBlockIDsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UniqueIDs = coRef.UniqueIDs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgGetBlockIDsMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgGetBlockIDsMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_GETBLOCKIDS;}
tU8 fastmapfi_tclMsgGetBlockIDsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fastmapfi_tclMsgGetBlockIDsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UniqueIDs.size(); ++u32Idx)
         UniqueIDs[u32Idx].vDestroy();
   }
   UniqueIDs.clear();
}

tU32 fastmapfi_tclMsgGetBlockIDsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+UniqueIDs.size()*8;
}

tBool fastmapfi_tclMsgGetBlockIDsMethodResult::operator==(const fastmapfi_tclMsgGetBlockIDsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UniqueIDs.size() == rfoCmp.UniqueIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UniqueIDs.size()); ++u32Idx)
            bResult = bResult && (UniqueIDs[u32Idx] == rfoCmp.UniqueIDs[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgGetBlockIDsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UniqueIDs.size(); ++u32Idx)
      {
         UniqueIDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UniqueIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UniqueIDs[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgGetBlockIDsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)UniqueIDs.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UniqueIDs.size(); ++u32Idx)
         oOut << UniqueIDs[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgLoadBlocksMethodStart::fastmapfi_tclMsgLoadBlocksMethodStart(const fastmapfi_tclMsgLoadBlocksMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   UniqueIDs = coRef.UniqueIDs;
   DatasetID = coRef.DatasetID;
   Handle = coRef.Handle;
   Offset = coRef.Offset;
   MaxSize = coRef.MaxSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgLoadBlocksMethodStart& fastmapfi_tclMsgLoadBlocksMethodStart::operator=(const fastmapfi_tclMsgLoadBlocksMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   UniqueIDs = coRef.UniqueIDs;
   DatasetID = coRef.DatasetID;
   Handle = coRef.Handle;
   Offset = coRef.Offset;
   MaxSize = coRef.MaxSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgLoadBlocksMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgLoadBlocksMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_LOADBLOCKS;}
tU8 fastmapfi_tclMsgLoadBlocksMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fastmapfi_tclMsgLoadBlocksMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UniqueIDs.size(); ++u32Idx)
         UniqueIDs[u32Idx].vDestroy();
   }
   UniqueIDs.clear();
}

tU32 fastmapfi_tclMsgLoadBlocksMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+18+UniqueIDs.size()*8;
}

tBool fastmapfi_tclMsgLoadBlocksMethodStart::operator==(const fastmapfi_tclMsgLoadBlocksMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (UniqueIDs.size() == rfoCmp.UniqueIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UniqueIDs.size()); ++u32Idx)
            bResult = bResult && (UniqueIDs[u32Idx] == rfoCmp.UniqueIDs[u32Idx]);
      }
      bResult = bResult && (DatasetID == rfoCmp.DatasetID);
      bResult = bResult && (Handle == rfoCmp.Handle);
      bResult = bResult && (Offset == rfoCmp.Offset);
      bResult = bResult && (MaxSize == rfoCmp.MaxSize);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgLoadBlocksMethodStart::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UniqueIDs.size(); ++u32Idx)
      {
         UniqueIDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UniqueIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UniqueIDs[u32Idx];
      }
   }
   oIn >> DatasetID;
   oIn >> Handle;
   oIn >> Offset;
   oIn >> MaxSize;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgLoadBlocksMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << (tU32)UniqueIDs.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UniqueIDs.size(); ++u32Idx)
         oOut << UniqueIDs[u32Idx];
   }
   oOut << DatasetID;
   oOut << Handle;
   oOut << Offset;
   oOut << MaxSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgLoadBlocksMethodResult::fastmapfi_tclMsgLoadBlocksMethodResult(const fastmapfi_tclMsgLoadBlocksMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgLoadBlocksMethodResult& fastmapfi_tclMsgLoadBlocksMethodResult::operator=(const fastmapfi_tclMsgLoadBlocksMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgLoadBlocksMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgLoadBlocksMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_LOADBLOCKS;}
tU8 fastmapfi_tclMsgLoadBlocksMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fastmapfi_tclMsgLoadBlocksMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         ResultBlocks[u32Idx].vDestroy();
   }
   ResultBlocks.clear();
}

tU32 fastmapfi_tclMsgLoadBlocksMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ResultBlocks.size()*16;
}

tBool fastmapfi_tclMsgLoadBlocksMethodResult::operator==(const fastmapfi_tclMsgLoadBlocksMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Size == rfoCmp.Size);
      bResult = bResult && (ResultBlocks.size() == rfoCmp.ResultBlocks.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ResultBlocks.size()); ++u32Idx)
            bResult = bResult && (ResultBlocks[u32Idx] == rfoCmp.ResultBlocks[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgLoadBlocksMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Size;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
      {
         ResultBlocks[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ResultBlocks.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ResultBlocks[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgLoadBlocksMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Size;
   oOut << (tU32)ResultBlocks.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         oOut << ResultBlocks[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgLoadBlocksMethodAbort::fastmapfi_tclMsgLoadBlocksMethodAbort(const fastmapfi_tclMsgLoadBlocksMethodAbort& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgLoadBlocksMethodAbort& fastmapfi_tclMsgLoadBlocksMethodAbort::operator=(const fastmapfi_tclMsgLoadBlocksMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgLoadBlocksMethodAbort::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgLoadBlocksMethodAbort::u16GetFunctionID() const {return FASTMAPFI_C_U16_LOADBLOCKS;}
tU8 fastmapfi_tclMsgLoadBlocksMethodAbort::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODABORT;}

tU32 fastmapfi_tclMsgLoadBlocksMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgLoadBlocksMethodAbort::operator==(const fastmapfi_tclMsgLoadBlocksMethodAbort& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgLoadBlocksMethodAbort::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgLoadBlocksMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgLoadBlocksAbortResult::fastmapfi_tclMsgLoadBlocksAbortResult(const fastmapfi_tclMsgLoadBlocksAbortResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgLoadBlocksAbortResult& fastmapfi_tclMsgLoadBlocksAbortResult::operator=(const fastmapfi_tclMsgLoadBlocksAbortResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgLoadBlocksAbortResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgLoadBlocksAbortResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_LOADBLOCKS;}
tU8 fastmapfi_tclMsgLoadBlocksAbortResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_ABORTRESULT;}

tU32 fastmapfi_tclMsgLoadBlocksAbortResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgLoadBlocksAbortResult::operator==(const fastmapfi_tclMsgLoadBlocksAbortResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgLoadBlocksAbortResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgLoadBlocksAbortResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgConvertOnecellListMethodStart::fastmapfi_tclMsgConvertOnecellListMethodStart(const fastmapfi_tclMsgConvertOnecellListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetID = coRef.DatasetID;
   Handle = coRef.Handle;
   Offset = coRef.Offset;
   MaxSize = coRef.MaxSize;
   ClusterIdList = coRef.ClusterIdList;
   OnecellIdList = coRef.OnecellIdList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgConvertOnecellListMethodStart& fastmapfi_tclMsgConvertOnecellListMethodStart::operator=(const fastmapfi_tclMsgConvertOnecellListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetID = coRef.DatasetID;
   Handle = coRef.Handle;
   Offset = coRef.Offset;
   MaxSize = coRef.MaxSize;
   ClusterIdList = coRef.ClusterIdList;
   OnecellIdList = coRef.OnecellIdList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgConvertOnecellListMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgConvertOnecellListMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_CONVERTONECELLLIST;}
tU8 fastmapfi_tclMsgConvertOnecellListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fastmapfi_tclMsgConvertOnecellListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         ClusterIdList[u32Idx].vDestroy();
   }
   ClusterIdList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
         OnecellIdList[u32Idx].vDestroy();
   }
   OnecellIdList.clear();
}

tU32 fastmapfi_tclMsgConvertOnecellListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+22+ClusterIdList.size()*8+OnecellIdList.size()*4;
}

tBool fastmapfi_tclMsgConvertOnecellListMethodStart::operator==(const fastmapfi_tclMsgConvertOnecellListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetID == rfoCmp.DatasetID);
      bResult = bResult && (Handle == rfoCmp.Handle);
      bResult = bResult && (Offset == rfoCmp.Offset);
      bResult = bResult && (MaxSize == rfoCmp.MaxSize);
      bResult = bResult && (ClusterIdList.size() == rfoCmp.ClusterIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterIdList.size()); ++u32Idx)
            bResult = bResult && (ClusterIdList[u32Idx] == rfoCmp.ClusterIdList[u32Idx]);
      }
      bResult = bResult && (OnecellIdList.size() == rfoCmp.OnecellIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnecellIdList.size()); ++u32Idx)
            bResult = bResult && (OnecellIdList[u32Idx] == rfoCmp.OnecellIdList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgConvertOnecellListMethodStart::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetID;
   oIn >> Handle;
   oIn >> Offset;
   oIn >> MaxSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
      {
         ClusterIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterIdList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
      {
         OnecellIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnecellIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnecellIdList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgConvertOnecellListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetID;
   oOut << Handle;
   oOut << Offset;
   oOut << MaxSize;
   oOut << (tU32)ClusterIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         oOut << ClusterIdList[u32Idx];
   }
   oOut << (tU32)OnecellIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
         oOut << OnecellIdList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgConvertOnecellListMethodResult::fastmapfi_tclMsgConvertOnecellListMethodResult(const fastmapfi_tclMsgConvertOnecellListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Size = coRef.Size;
   ResultBlockList = coRef.ResultBlockList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgConvertOnecellListMethodResult& fastmapfi_tclMsgConvertOnecellListMethodResult::operator=(const fastmapfi_tclMsgConvertOnecellListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   ResultBlockList = coRef.ResultBlockList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgConvertOnecellListMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgConvertOnecellListMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_CONVERTONECELLLIST;}
tU8 fastmapfi_tclMsgConvertOnecellListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fastmapfi_tclMsgConvertOnecellListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlockList.size(); ++u32Idx)
         ResultBlockList[u32Idx].vDestroy();
   }
   ResultBlockList.clear();
}

tU32 fastmapfi_tclMsgConvertOnecellListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ResultBlockList.size()*16;
}

tBool fastmapfi_tclMsgConvertOnecellListMethodResult::operator==(const fastmapfi_tclMsgConvertOnecellListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Size == rfoCmp.Size);
      bResult = bResult && (ResultBlockList.size() == rfoCmp.ResultBlockList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ResultBlockList.size()); ++u32Idx)
            bResult = bResult && (ResultBlockList[u32Idx] == rfoCmp.ResultBlockList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgConvertOnecellListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Size;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ResultBlockList.size(); ++u32Idx)
      {
         ResultBlockList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ResultBlockList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ResultBlockList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgConvertOnecellListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Size;
   oOut << (tU32)ResultBlockList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlockList.size(); ++u32Idx)
         oOut << ResultBlockList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgBreakDownRouteOCMethodStart::fastmapfi_tclMsgBreakDownRouteOCMethodStart(const fastmapfi_tclMsgBreakDownRouteOCMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetID = coRef.DatasetID;
   RequestType = coRef.RequestType;
   BreakDownLevel = coRef.BreakDownLevel;
   BoundingBox = coRef.BoundingBox;
   ClusterIdList = coRef.ClusterIdList;
   OnecellIdList = coRef.OnecellIdList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgBreakDownRouteOCMethodStart& fastmapfi_tclMsgBreakDownRouteOCMethodStart::operator=(const fastmapfi_tclMsgBreakDownRouteOCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetID = coRef.DatasetID;
   RequestType = coRef.RequestType;
   BreakDownLevel = coRef.BreakDownLevel;
   BoundingBox = coRef.BoundingBox;
   ClusterIdList = coRef.ClusterIdList;
   OnecellIdList = coRef.OnecellIdList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgBreakDownRouteOCMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgBreakDownRouteOCMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_BREAKDOWNROUTEOC;}
tU8 fastmapfi_tclMsgBreakDownRouteOCMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fastmapfi_tclMsgBreakDownRouteOCMethodStart::vDestroy()
{
   BoundingBox.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         ClusterIdList[u32Idx].vDestroy();
   }
   ClusterIdList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
         OnecellIdList[u32Idx].vDestroy();
   }
   OnecellIdList.clear();
}

tU32 fastmapfi_tclMsgBreakDownRouteOCMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+30+ClusterIdList.size()*9+OnecellIdList.size()*5;
}

tBool fastmapfi_tclMsgBreakDownRouteOCMethodStart::operator==(const fastmapfi_tclMsgBreakDownRouteOCMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetID == rfoCmp.DatasetID);
      bResult = bResult && (RequestType == rfoCmp.RequestType);
      bResult = bResult && (BreakDownLevel == rfoCmp.BreakDownLevel);
      bResult = bResult && (BoundingBox == rfoCmp.BoundingBox);
      bResult = bResult && (ClusterIdList.size() == rfoCmp.ClusterIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterIdList.size()); ++u32Idx)
            bResult = bResult && (ClusterIdList[u32Idx] == rfoCmp.ClusterIdList[u32Idx]);
      }
      bResult = bResult && (OnecellIdList.size() == rfoCmp.OnecellIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnecellIdList.size()); ++u32Idx)
            bResult = bResult && (OnecellIdList[u32Idx] == rfoCmp.OnecellIdList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgBreakDownRouteOCMethodStart::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetID;
   oIn >> RequestType;
   oIn >> BreakDownLevel;
   oIn >> BoundingBox;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
      {
         ClusterIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterIdList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
      {
         OnecellIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnecellIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnecellIdList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgBreakDownRouteOCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetID;
   oOut << RequestType;
   oOut << BreakDownLevel;
   oOut << BoundingBox;
   oOut << (tU32)ClusterIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         oOut << ClusterIdList[u32Idx];
   }
   oOut << (tU32)OnecellIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
         oOut << OnecellIdList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgBreakDownRouteOCMethodResult::fastmapfi_tclMsgBreakDownRouteOCMethodResult(const fastmapfi_tclMsgBreakDownRouteOCMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RouteBreakDownList = coRef.RouteBreakDownList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgBreakDownRouteOCMethodResult& fastmapfi_tclMsgBreakDownRouteOCMethodResult::operator=(const fastmapfi_tclMsgBreakDownRouteOCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RouteBreakDownList = coRef.RouteBreakDownList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgBreakDownRouteOCMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgBreakDownRouteOCMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_BREAKDOWNROUTEOC;}
tU8 fastmapfi_tclMsgBreakDownRouteOCMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fastmapfi_tclMsgBreakDownRouteOCMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteBreakDownList.size(); ++u32Idx)
         RouteBreakDownList[u32Idx].vDestroy();
   }
   RouteBreakDownList.clear();
}

tU32 fastmapfi_tclMsgBreakDownRouteOCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteBreakDownList.size(); ++u32ListIdx)
      u32DynamicSize += RouteBreakDownList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fastmapfi_tclMsgBreakDownRouteOCMethodResult::operator==(const fastmapfi_tclMsgBreakDownRouteOCMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RouteBreakDownList.size() == rfoCmp.RouteBreakDownList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteBreakDownList.size()); ++u32Idx)
            bResult = bResult && (RouteBreakDownList[u32Idx] == rfoCmp.RouteBreakDownList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgBreakDownRouteOCMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteBreakDownList.size(); ++u32Idx)
      {
         RouteBreakDownList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteBreakDownList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteBreakDownList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgBreakDownRouteOCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RouteBreakDownList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteBreakDownList.size(); ++u32Idx)
         oOut << RouteBreakDownList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::fastmapfi_tclMsgReserveClientUseIdRangeMethodStart(const fastmapfi_tclMsgReserveClientUseIdRangeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   ClientName = coRef.ClientName;
   NoReqId = coRef.NoReqId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgReserveClientUseIdRangeMethodStart& fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::operator=(const fastmapfi_tclMsgReserveClientUseIdRangeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   ClientName = coRef.ClientName;
   NoReqId = coRef.NoReqId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_RESERVECLIENTUSEIDRANGE;}
tU8 fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::vDestroy()
{
   ClientName.vDestroy();
}

tU32 fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4+ClientName.u32GetSize(u16MajorVersion);
}

tBool fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::operator==(const fastmapfi_tclMsgReserveClientUseIdRangeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (ClientName == rfoCmp.ClientName);
      bResult = bResult && (NoReqId == rfoCmp.NoReqId);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> ClientName;
   oIn >> NoReqId;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgReserveClientUseIdRangeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << ClientName;
   oOut << NoReqId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::fastmapfi_tclMsgReserveClientUseIdRangeMethodResult(const fastmapfi_tclMsgReserveClientUseIdRangeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Handle = coRef.Handle;
   FirstId = coRef.FirstId;
   LastId = coRef.LastId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgReserveClientUseIdRangeMethodResult& fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::operator=(const fastmapfi_tclMsgReserveClientUseIdRangeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Handle = coRef.Handle;
   FirstId = coRef.FirstId;
   LastId = coRef.LastId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_RESERVECLIENTUSEIDRANGE;}
tU8 fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::vDestroy()
{
   FirstId.vDestroy(); 
   LastId.vDestroy(); 
}

tU32 fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

tBool fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::operator==(const fastmapfi_tclMsgReserveClientUseIdRangeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Handle == rfoCmp.Handle);
      bResult = bResult && (FirstId == rfoCmp.FirstId);
      bResult = bResult && (LastId == rfoCmp.LastId);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Handle;
   oIn >> FirstId;
   oIn >> LastId;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgReserveClientUseIdRangeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Handle;
   oOut << FirstId;
   oOut << LastId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   Handle = coRef.Handle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart& fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::operator=(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   Handle = coRef.Handle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_FREECLIENTUSEDIDRANGE;}
tU8 fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4;
}

tBool fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::operator==(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (Handle == rfoCmp.Handle);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> Handle;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgFreeClientUsedIdRangeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << Handle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult& fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::operator=(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_FREECLIENTUSEDIDRANGE;}
tU8 fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::operator==(const fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgFreeClientUsedIdRangeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::fastmapfi_tclMsgGetClientIdRangeByNameMethodStart(const fastmapfi_tclMsgGetClientIdRangeByNameMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   ClientName = coRef.ClientName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgGetClientIdRangeByNameMethodStart& fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::operator=(const fastmapfi_tclMsgGetClientIdRangeByNameMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   ClientName = coRef.ClientName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::u16GetFunctionID() const {return FASTMAPFI_C_U16_GETCLIENTIDRANGEBYNAME;}
tU8 fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::vDestroy()
{
   ClientName.vDestroy();
}

tU32 fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+0+ClientName.u32GetSize(u16MajorVersion);
}

tBool fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::operator==(const fastmapfi_tclMsgGetClientIdRangeByNameMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (ClientName == rfoCmp.ClientName);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> ClientName;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgGetClientIdRangeByNameMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << ClientName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::fastmapfi_tclMsgGetClientIdRangeByNameMethodResult(const fastmapfi_tclMsgGetClientIdRangeByNameMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FirstId = coRef.FirstId;
   LastId = coRef.LastId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgGetClientIdRangeByNameMethodResult& fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::operator=(const fastmapfi_tclMsgGetClientIdRangeByNameMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FirstId = coRef.FirstId;
   LastId = coRef.LastId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::u16GetFunctionID() const {return FASTMAPFI_C_U16_GETCLIENTIDRANGEBYNAME;}
tU8 fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::vDestroy()
{
   FirstId.vDestroy(); 
   LastId.vDestroy(); 
}

tU32 fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::operator==(const fastmapfi_tclMsgGetClientIdRangeByNameMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FirstId == rfoCmp.FirstId);
      bResult = bResult && (LastId == rfoCmp.LastId);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> FirstId;
   oIn >> LastId;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgGetClientIdRangeByNameMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FirstId;
   oOut << LastId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgDatablocksChangedUpReg::fastmapfi_tclMsgDatablocksChangedUpReg(const fastmapfi_tclMsgDatablocksChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgDatablocksChangedUpReg& fastmapfi_tclMsgDatablocksChangedUpReg::operator=(const fastmapfi_tclMsgDatablocksChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgDatablocksChangedUpReg::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgDatablocksChangedUpReg::u16GetFunctionID() const {return FASTMAPFI_C_U16_DATABLOCKSCHANGED;}
tU8 fastmapfi_tclMsgDatablocksChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 fastmapfi_tclMsgDatablocksChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgDatablocksChangedUpReg::operator==(const fastmapfi_tclMsgDatablocksChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgDatablocksChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgDatablocksChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgDatablocksChangedRelUpReg::fastmapfi_tclMsgDatablocksChangedRelUpReg(const fastmapfi_tclMsgDatablocksChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgDatablocksChangedRelUpReg& fastmapfi_tclMsgDatablocksChangedRelUpReg::operator=(const fastmapfi_tclMsgDatablocksChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgDatablocksChangedRelUpReg::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgDatablocksChangedRelUpReg::u16GetFunctionID() const {return FASTMAPFI_C_U16_DATABLOCKSCHANGED;}
tU8 fastmapfi_tclMsgDatablocksChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 fastmapfi_tclMsgDatablocksChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgDatablocksChangedRelUpReg::operator==(const fastmapfi_tclMsgDatablocksChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgDatablocksChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgDatablocksChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgDatablocksChangedStatus::fastmapfi_tclMsgDatablocksChangedStatus(const fastmapfi_tclMsgDatablocksChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Mask = coRef.Mask;
   CompareValue = coRef.CompareValue;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgDatablocksChangedStatus& fastmapfi_tclMsgDatablocksChangedStatus::operator=(const fastmapfi_tclMsgDatablocksChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   Mask = coRef.Mask;
   CompareValue = coRef.CompareValue;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgDatablocksChangedStatus::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgDatablocksChangedStatus::u16GetFunctionID() const {return FASTMAPFI_C_U16_DATABLOCKSCHANGED;}
tU8 fastmapfi_tclMsgDatablocksChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid fastmapfi_tclMsgDatablocksChangedStatus::vDestroy()
{
   Mask.vDestroy(); 
   CompareValue.vDestroy(); 
}

tU32 fastmapfi_tclMsgDatablocksChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool fastmapfi_tclMsgDatablocksChangedStatus::operator==(const fastmapfi_tclMsgDatablocksChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Mask == rfoCmp.Mask);
      bResult = bResult && (CompareValue == rfoCmp.CompareValue);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgDatablocksChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Mask;
   oIn >> CompareValue;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgDatablocksChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Mask;
   oOut << CompareValue;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgEngineeringTextGet::fastmapfi_tclMsgEngineeringTextGet(const fastmapfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgEngineeringTextGet& fastmapfi_tclMsgEngineeringTextGet::operator=(const fastmapfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return FASTMAPFI_C_U16_ENGINEERINGTEXT;}
tU8 fastmapfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 fastmapfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgEngineeringTextGet::operator==(const fastmapfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgEngineeringTextUpReg::fastmapfi_tclMsgEngineeringTextUpReg(const fastmapfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgEngineeringTextUpReg& fastmapfi_tclMsgEngineeringTextUpReg::operator=(const fastmapfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return FASTMAPFI_C_U16_ENGINEERINGTEXT;}
tU8 fastmapfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 fastmapfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgEngineeringTextUpReg::operator==(const fastmapfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgEngineeringTextRelUpReg::fastmapfi_tclMsgEngineeringTextRelUpReg(const fastmapfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgEngineeringTextRelUpReg& fastmapfi_tclMsgEngineeringTextRelUpReg::operator=(const fastmapfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return FASTMAPFI_C_U16_ENGINEERINGTEXT;}
tU8 fastmapfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 fastmapfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fastmapfi_tclMsgEngineeringTextRelUpReg::operator==(const fastmapfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgEngineeringTextStatus::fastmapfi_tclMsgEngineeringTextStatus(const fastmapfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fastmapfi_tclMsgEngineeringTextStatus& fastmapfi_tclMsgEngineeringTextStatus::operator=(const fastmapfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fastmapfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return FASTMAPFI_C_U16_SERVICE_ID;}
tU16 fastmapfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return FASTMAPFI_C_U16_ENGINEERINGTEXT;}
tU8 fastmapfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid fastmapfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 fastmapfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool fastmapfi_tclMsgEngineeringTextStatus::operator==(const fastmapfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& fastmapfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& fastmapfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

