#ifndef FASTMAPFILANGUAGE_HEADER
#define FASTMAPFILANGUAGE_HEADER

class fastmapfi_tclInContext;
class fastmapfi_tclOutContext;
class fastmapfi_tclVisitorBase;

class MY_DECL fastmapfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  fastmapfi_tclDescription(fi_tclInContext* poIn, fastmapfi_tclVisitorBase* poVisit);
  fastmapfi_tclDescription(fi_tclOutContext* poOut, fastmapfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(fastmapfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ fastmapfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  fastmapfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<fastmapfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<fastmapfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline fastmapfi_tclDescription::fastmapfi_tclDescription(fi_tclInContext* poIn, fastmapfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline fastmapfi_tclDescription::fastmapfi_tclDescription(fi_tclOutContext* poOut, fastmapfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

