#ifndef __FASTMAPFIDEBUGVISITOR_H__
#define __FASTMAPFIDEBUGVISITOR_H__

class MY_DECL fastmapfi_tclPrintVisitor : public fastmapfi_tclVisitorBase {

private:
   /* default constructor */ fastmapfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   fastmapfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavClusterDesc(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tBool bDoExpand_NavOneCellDesc(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& o_e8_DapOrderType);
   virtual tBool bDoExpand_NavClusterId(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LocalOneCellID(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TransferType(fi_tcl_e8_TransferType& o_e8_TransferType);
   virtual tVoid vVisit_e8_CoordinateCoding(fi_tcl_e8_CoordinateCoding& o_e8_CoordinateCoding);
   virtual tVoid vVisit_e16_DataType(fi_tcl_e16_DataType& o_e16_DataType);
   virtual tBool bDoExpand_UniqueID(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_MapScale(fi_tcl_MapScale& o_MapScale);
   virtual tBool bDoExpand_BoundingBox(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ResultBlocks(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequestType(fi_tcl_e8_RequestType& o_e8_RequestType);
   virtual tVoid vVisit_e16_OneCellIndex(fi_tcl_e16_OneCellIndex& o_e16_OneCellIndex);
   virtual tBool bDoExpand_OneCellRelation(fastmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SameLevelOneCellBlock(fastmapfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL fastmapfi_tclRandomInitVisitor : public fastmapfi_tclVisitorBase {
public:

   fastmapfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& o_e8_DapOrderType);
   virtual tVoid vVisit_e8_TransferType(fi_tcl_e8_TransferType& o_e8_TransferType);
   virtual tVoid vVisit_e8_CoordinateCoding(fi_tcl_e8_CoordinateCoding& o_e8_CoordinateCoding);
   virtual tVoid vVisit_e16_DataType(fi_tcl_e16_DataType& o_e16_DataType);
   virtual tVoid vVisit_MapScale(fi_tcl_MapScale& o_MapScale);
   virtual tVoid vVisit_e8_RequestType(fi_tcl_e8_RequestType& o_e8_RequestType);
   virtual tVoid vVisit_e16_OneCellIndex(fi_tcl_e16_OneCellIndex& o_e16_OneCellIndex);
	tU32 u32ListSize;
};

#endif
