/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgLocationTableListMethodStart::dap_tmcfi_tclMsgLocationTableListMethodStart(const dap_tmcfi_tclMsgLocationTableListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgLocationTableListMethodStart& dap_tmcfi_tclMsgLocationTableListMethodStart::operator=(const dap_tmcfi_tclMsgLocationTableListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgLocationTableListMethodStart::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgLocationTableListMethodStart::u16GetFunctionID() const {return DAP_TMCFI_C_U16_LOCATIONTABLELIST;}
tU8 dap_tmcfi_tclMsgLocationTableListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_tmcfi_tclMsgLocationTableListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+9;
}

tBool dap_tmcfi_tclMsgLocationTableListMethodStart::operator==(const dap_tmcfi_tclMsgLocationTableListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgLocationTableListMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32DatasetId;
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgLocationTableListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgLocationTableListMethodResult::dap_tmcfi_tclMsgLocationTableListMethodResult(const dap_tmcfi_tclMsgLocationTableListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   u32MaxLocationSizeWithOC = coRef.u32MaxLocationSizeWithOC;
   u32MaxLocationSizeWithoutOC = coRef.u32MaxLocationSizeWithoutOC;
   aoLocTables = coRef.aoLocTables;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgLocationTableListMethodResult& dap_tmcfi_tclMsgLocationTableListMethodResult::operator=(const dap_tmcfi_tclMsgLocationTableListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   u32MaxLocationSizeWithOC = coRef.u32MaxLocationSizeWithOC;
   u32MaxLocationSizeWithoutOC = coRef.u32MaxLocationSizeWithoutOC;
   aoLocTables = coRef.aoLocTables;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgLocationTableListMethodResult::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgLocationTableListMethodResult::u16GetFunctionID() const {return DAP_TMCFI_C_U16_LOCATIONTABLELIST;}
tU8 dap_tmcfi_tclMsgLocationTableListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_tmcfi_tclMsgLocationTableListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoLocTables.size(); ++u32Idx)
         aoLocTables[u32Idx].vDestroy();
   }
   aoLocTables.clear();
}

tU32 dap_tmcfi_tclMsgLocationTableListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoLocTables.size(); ++u32ListIdx)
      u32DynamicSize += aoLocTables[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+21;
}

tBool dap_tmcfi_tclMsgLocationTableListMethodResult::operator==(const dap_tmcfi_tclMsgLocationTableListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (u32MaxLocationSizeWithOC == rfoCmp.u32MaxLocationSizeWithOC);
      bResult = bResult && (u32MaxLocationSizeWithoutOC == rfoCmp.u32MaxLocationSizeWithoutOC);
      bResult = bResult && (aoLocTables.size() == rfoCmp.aoLocTables.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoLocTables.size()); ++u32Idx)
            bResult = bResult && (aoLocTables[u32Idx] == rfoCmp.aoLocTables[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgLocationTableListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   oIn >> u32MaxLocationSizeWithOC;
   oIn >> u32MaxLocationSizeWithoutOC;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoLocTables.size(); ++u32Idx)
      {
         aoLocTables[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoLocTables.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoLocTables[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgLocationTableListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   oOut << u32MaxLocationSizeWithOC;
   oOut << u32MaxLocationSizeWithoutOC;
   oOut << (tU32)aoLocTables.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoLocTables.size(); ++u32Idx)
         oOut << aoLocTables[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgGetLocationMethodStart::dap_tmcfi_tclMsgGetLocationMethodStart(const dap_tmcfi_tclMsgGetLocationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   u16LocationId = coRef.u16LocationId;
   T_LocTableIdent = coRef.T_LocTableIdent;
   T_e8_LocClass = coRef.T_e8_LocClass;
   bWithOCs = coRef.bWithOCs;
   bFoundSecundary = coRef.bFoundSecundary;
   u8Direction = coRef.u8Direction;
   u8Distance = coRef.u8Distance;
   u32SharedMemSize = coRef.u32SharedMemSize;
   szSharedMemory = coRef.szSharedMemory;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgGetLocationMethodStart& dap_tmcfi_tclMsgGetLocationMethodStart::operator=(const dap_tmcfi_tclMsgGetLocationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   u16LocationId = coRef.u16LocationId;
   T_LocTableIdent = coRef.T_LocTableIdent;
   T_e8_LocClass = coRef.T_e8_LocClass;
   bWithOCs = coRef.bWithOCs;
   bFoundSecundary = coRef.bFoundSecundary;
   u8Direction = coRef.u8Direction;
   u8Distance = coRef.u8Distance;
   u32SharedMemSize = coRef.u32SharedMemSize;
   szSharedMemory = coRef.szSharedMemory;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgGetLocationMethodStart::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgGetLocationMethodStart::u16GetFunctionID() const {return DAP_TMCFI_C_U16_GETLOCATION;}
tU8 dap_tmcfi_tclMsgGetLocationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_tmcfi_tclMsgGetLocationMethodStart::vDestroy()
{
   T_LocTableIdent.vDestroy(); 
   szSharedMemory.vDestroy();
}

tU32 dap_tmcfi_tclMsgGetLocationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+22+szSharedMemory.u32GetSize(u16MajorVersion);
}

tBool dap_tmcfi_tclMsgGetLocationMethodStart::operator==(const dap_tmcfi_tclMsgGetLocationMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (u16LocationId == rfoCmp.u16LocationId);
      bResult = bResult && (T_LocTableIdent == rfoCmp.T_LocTableIdent);
      bResult = bResult && (T_e8_LocClass == rfoCmp.T_e8_LocClass);
      bResult = bResult && (bWithOCs == rfoCmp.bWithOCs);
      bResult = bResult && (bFoundSecundary == rfoCmp.bFoundSecundary);
      bResult = bResult && (u8Direction == rfoCmp.u8Direction);
      bResult = bResult && (u8Distance == rfoCmp.u8Distance);
      bResult = bResult && (u32SharedMemSize == rfoCmp.u32SharedMemSize);
      bResult = bResult && (szSharedMemory == rfoCmp.szSharedMemory);
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgGetLocationMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32DatasetId;
   oIn >> u16LocationId;
   oIn >> T_LocTableIdent;
   oIn >> T_e8_LocClass;
   oIn >> bWithOCs;
   oIn >> bFoundSecundary;
   oIn >> u8Direction;
   oIn >> u8Distance;
   oIn >> u32SharedMemSize;
   oIn >> szSharedMemory;
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgGetLocationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32DatasetId;
   oOut << u16LocationId;
   oOut << T_LocTableIdent;
   oOut << T_e8_LocClass;
   oOut << bWithOCs;
   oOut << bFoundSecundary;
   oOut << u8Direction;
   oOut << u8Distance;
   oOut << u32SharedMemSize;
   oOut << szSharedMemory;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgGetLocationMethodResult::dap_tmcfi_tclMsgGetLocationMethodResult(const dap_tmcfi_tclMsgGetLocationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   u16LocationId = coRef.u16LocationId;
   oLocTableIdent = coRef.oLocTableIdent;
   enLocClass = coRef.enLocClass;
   bWithOCs = coRef.bWithOCs;
   bFoundSecundary = coRef.bFoundSecundary;
   enDirection = coRef.enDirection;
   u8Distance = coRef.u8Distance;
   u32LocationSize = coRef.u32LocationSize;
   szSharedMemory = coRef.szSharedMemory;
   oBBox = coRef.oBBox;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgGetLocationMethodResult& dap_tmcfi_tclMsgGetLocationMethodResult::operator=(const dap_tmcfi_tclMsgGetLocationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   u16LocationId = coRef.u16LocationId;
   oLocTableIdent = coRef.oLocTableIdent;
   enLocClass = coRef.enLocClass;
   bWithOCs = coRef.bWithOCs;
   bFoundSecundary = coRef.bFoundSecundary;
   enDirection = coRef.enDirection;
   u8Distance = coRef.u8Distance;
   u32LocationSize = coRef.u32LocationSize;
   szSharedMemory = coRef.szSharedMemory;
   oBBox = coRef.oBBox;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgGetLocationMethodResult::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgGetLocationMethodResult::u16GetFunctionID() const {return DAP_TMCFI_C_U16_GETLOCATION;}
tU8 dap_tmcfi_tclMsgGetLocationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_tmcfi_tclMsgGetLocationMethodResult::vDestroy()
{
   oLocTableIdent.vDestroy(); 
   szSharedMemory.vDestroy();
   oBBox.vDestroy(); 
}

tU32 dap_tmcfi_tclMsgGetLocationMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 38+szSharedMemory.u32GetSize(u16MajorVersion);
}

tBool dap_tmcfi_tclMsgGetLocationMethodResult::operator==(const dap_tmcfi_tclMsgGetLocationMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (u16LocationId == rfoCmp.u16LocationId);
      bResult = bResult && (oLocTableIdent == rfoCmp.oLocTableIdent);
      bResult = bResult && (enLocClass == rfoCmp.enLocClass);
      bResult = bResult && (bWithOCs == rfoCmp.bWithOCs);
      bResult = bResult && (bFoundSecundary == rfoCmp.bFoundSecundary);
      bResult = bResult && (enDirection == rfoCmp.enDirection);
      bResult = bResult && (u8Distance == rfoCmp.u8Distance);
      bResult = bResult && (u32LocationSize == rfoCmp.u32LocationSize);
      bResult = bResult && (szSharedMemory == rfoCmp.szSharedMemory);
      bResult = bResult && (oBBox == rfoCmp.oBBox);
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgGetLocationMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   oIn >> u16LocationId;
   oIn >> oLocTableIdent;
   oIn >> enLocClass;
   oIn >> bWithOCs;
   oIn >> bFoundSecundary;
   oIn >> enDirection;
   oIn >> u8Distance;
   oIn >> u32LocationSize;
   oIn >> szSharedMemory;
   oIn >> oBBox;
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgGetLocationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   oOut << u16LocationId;
   oOut << oLocTableIdent;
   oOut << enLocClass;
   oOut << bWithOCs;
   oOut << bFoundSecundary;
   oOut << enDirection;
   oOut << u8Distance;
   oOut << u32LocationSize;
   oOut << szSharedMemory;
   oOut << oBBox;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgLanguageIdListMethodStart::dap_tmcfi_tclMsgLanguageIdListMethodStart(const dap_tmcfi_tclMsgLanguageIdListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgLanguageIdListMethodStart& dap_tmcfi_tclMsgLanguageIdListMethodStart::operator=(const dap_tmcfi_tclMsgLanguageIdListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgLanguageIdListMethodStart::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgLanguageIdListMethodStart::u16GetFunctionID() const {return DAP_TMCFI_C_U16_LANGUAGEIDLIST;}
tU8 dap_tmcfi_tclMsgLanguageIdListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_tmcfi_tclMsgLanguageIdListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+9;
}

tBool dap_tmcfi_tclMsgLanguageIdListMethodStart::operator==(const dap_tmcfi_tclMsgLanguageIdListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgLanguageIdListMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32DatasetId;
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgLanguageIdListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgLanguageIdListMethodResult::dap_tmcfi_tclMsgLanguageIdListMethodResult(const dap_tmcfi_tclMsgLanguageIdListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoLanguageIds = coRef.aoLanguageIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgLanguageIdListMethodResult& dap_tmcfi_tclMsgLanguageIdListMethodResult::operator=(const dap_tmcfi_tclMsgLanguageIdListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoLanguageIds = coRef.aoLanguageIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgLanguageIdListMethodResult::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgLanguageIdListMethodResult::u16GetFunctionID() const {return DAP_TMCFI_C_U16_LANGUAGEIDLIST;}
tU8 dap_tmcfi_tclMsgLanguageIdListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_tmcfi_tclMsgLanguageIdListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoLanguageIds.size(); ++u32Idx)
         aoLanguageIds[u32Idx].vDestroy();
   }
   aoLanguageIds.clear();
}

tU32 dap_tmcfi_tclMsgLanguageIdListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+aoLanguageIds.size()*8;
}

tBool dap_tmcfi_tclMsgLanguageIdListMethodResult::operator==(const dap_tmcfi_tclMsgLanguageIdListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (aoLanguageIds.size() == rfoCmp.aoLanguageIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoLanguageIds.size()); ++u32Idx)
            bResult = bResult && (aoLanguageIds[u32Idx] == rfoCmp.aoLanguageIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgLanguageIdListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoLanguageIds.size(); ++u32Idx)
      {
         aoLanguageIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoLanguageIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoLanguageIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgLanguageIdListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   oOut << (tU32)aoLanguageIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoLanguageIds.size(); ++u32Idx)
         oOut << aoLanguageIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgBSAIdListMethodStart::dap_tmcfi_tclMsgBSAIdListMethodStart(const dap_tmcfi_tclMsgBSAIdListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   oLocTableIdent = coRef.oLocTableIdent;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgBSAIdListMethodStart& dap_tmcfi_tclMsgBSAIdListMethodStart::operator=(const dap_tmcfi_tclMsgBSAIdListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   oLocTableIdent = coRef.oLocTableIdent;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgBSAIdListMethodStart::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgBSAIdListMethodStart::u16GetFunctionID() const {return DAP_TMCFI_C_U16_BSAIDLIST;}
tU8 dap_tmcfi_tclMsgBSAIdListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_tmcfi_tclMsgBSAIdListMethodStart::vDestroy()
{
   oLocTableIdent.vDestroy(); 
}

tU32 dap_tmcfi_tclMsgBSAIdListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+11;
}

tBool dap_tmcfi_tclMsgBSAIdListMethodStart::operator==(const dap_tmcfi_tclMsgBSAIdListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (oLocTableIdent == rfoCmp.oLocTableIdent);
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgBSAIdListMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32DatasetId;
   oIn >> oLocTableIdent;
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgBSAIdListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32DatasetId;
   oOut << oLocTableIdent;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgBSAIdListMethodResult::dap_tmcfi_tclMsgBSAIdListMethodResult(const dap_tmcfi_tclMsgBSAIdListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   oLocTableIdent = coRef.oLocTableIdent;
   au16BSAIds = coRef.au16BSAIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgBSAIdListMethodResult& dap_tmcfi_tclMsgBSAIdListMethodResult::operator=(const dap_tmcfi_tclMsgBSAIdListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   oLocTableIdent = coRef.oLocTableIdent;
   au16BSAIds = coRef.au16BSAIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgBSAIdListMethodResult::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgBSAIdListMethodResult::u16GetFunctionID() const {return DAP_TMCFI_C_U16_BSAIDLIST;}
tU8 dap_tmcfi_tclMsgBSAIdListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_tmcfi_tclMsgBSAIdListMethodResult::vDestroy()
{
   oLocTableIdent.vDestroy(); 
   au16BSAIds.clear();
}

tU32 dap_tmcfi_tclMsgBSAIdListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15+au16BSAIds.size()*2;
}

tBool dap_tmcfi_tclMsgBSAIdListMethodResult::operator==(const dap_tmcfi_tclMsgBSAIdListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (oLocTableIdent == rfoCmp.oLocTableIdent);
      bResult = bResult && (au16BSAIds.size() == rfoCmp.au16BSAIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < au16BSAIds.size()); ++u32Idx)
            bResult = bResult && (au16BSAIds[u32Idx] == rfoCmp.au16BSAIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgBSAIdListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   oIn >> oLocTableIdent;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      au16BSAIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> au16BSAIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgBSAIdListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   oOut << oLocTableIdent;
   oOut << (tU32)au16BSAIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < au16BSAIds.size(); ++u32Idx)
         oOut << au16BSAIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgPrefixTableMethodStart::dap_tmcfi_tclMsgPrefixTableMethodStart(const dap_tmcfi_tclMsgPrefixTableMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgPrefixTableMethodStart& dap_tmcfi_tclMsgPrefixTableMethodStart::operator=(const dap_tmcfi_tclMsgPrefixTableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgPrefixTableMethodStart::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgPrefixTableMethodStart::u16GetFunctionID() const {return DAP_TMCFI_C_U16_PREFIXTABLE;}
tU8 dap_tmcfi_tclMsgPrefixTableMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_tmcfi_tclMsgPrefixTableMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+9;
}

tBool dap_tmcfi_tclMsgPrefixTableMethodStart::operator==(const dap_tmcfi_tclMsgPrefixTableMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgPrefixTableMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32DatasetId;
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgPrefixTableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgPrefixTableMethodResult::dap_tmcfi_tclMsgPrefixTableMethodResult(const dap_tmcfi_tclMsgPrefixTableMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoPrefixTable = coRef.aoPrefixTable;
   aoPrefixElems = coRef.aoPrefixElems;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_tmcfi_tclMsgPrefixTableMethodResult& dap_tmcfi_tclMsgPrefixTableMethodResult::operator=(const dap_tmcfi_tclMsgPrefixTableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoPrefixTable = coRef.aoPrefixTable;
   aoPrefixElems = coRef.aoPrefixElems;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_tmcfi_tclMsgPrefixTableMethodResult::u16GetServiceID() const {return DAP_TMCFI_C_U16_SERVICE_ID;}
tU16 dap_tmcfi_tclMsgPrefixTableMethodResult::u16GetFunctionID() const {return DAP_TMCFI_C_U16_PREFIXTABLE;}
tU8 dap_tmcfi_tclMsgPrefixTableMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_tmcfi_tclMsgPrefixTableMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoPrefixTable.size(); ++u32Idx)
         aoPrefixTable[u32Idx].vDestroy();
   }
   aoPrefixTable.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < aoPrefixElems.size(); ++u32Idx)
         aoPrefixElems[u32Idx].vDestroy();
   }
   aoPrefixElems.clear();
}

tU32 dap_tmcfi_tclMsgPrefixTableMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoPrefixElems.size(); ++u32ListIdx)
      u32DynamicSize += aoPrefixElems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+17+aoPrefixTable.size()*10;
}

tBool dap_tmcfi_tclMsgPrefixTableMethodResult::operator==(const dap_tmcfi_tclMsgPrefixTableMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (aoPrefixTable.size() == rfoCmp.aoPrefixTable.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoPrefixTable.size()); ++u32Idx)
            bResult = bResult && (aoPrefixTable[u32Idx] == rfoCmp.aoPrefixTable[u32Idx]);
      }
      bResult = bResult && (aoPrefixElems.size() == rfoCmp.aoPrefixElems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoPrefixElems.size()); ++u32Idx)
            bResult = bResult && (aoPrefixElems[u32Idx] == rfoCmp.aoPrefixElems[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_tmcfi_tclMsgPrefixTableMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoPrefixTable.size(); ++u32Idx)
      {
         aoPrefixTable[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoPrefixTable.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoPrefixTable[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoPrefixElems.size(); ++u32Idx)
      {
         aoPrefixElems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoPrefixElems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoPrefixElems[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_tmcfi_tclMsgPrefixTableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   oOut << (tU32)aoPrefixTable.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoPrefixTable.size(); ++u32Idx)
         oOut << aoPrefixTable[u32Idx];
   }
   oOut << (tU32)aoPrefixElems.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoPrefixElems.size(); ++u32Idx)
         oOut << aoPrefixElems[u32Idx];
   }
   return oOut;
}

